/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.extension.organize;

import com.ibm.pdp.engine.IGeneratedInfo;
import com.ibm.pdp.engine.IGeneratedTag;
import com.ibm.pdp.pacbase.extension.organize.GeneratedFunctionsCursorForDialog;

public class GeneratedFunctionsCursorForServer
extends GeneratedFunctionsCursorForDialog {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2014, 2015.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    String[] labelsWithoutFn = new String[]{"FSERVER", "FEND-PGM", "FSERVER-STRVIEW", "F80OK"};

    public GeneratedFunctionsCursorForServer(IGeneratedInfo generatedInfo) {
        super(generatedInfo);
    }

    @Override
    protected boolean findLastStatement(IGeneratedTag candidate) {
        if ("05".equals(candidate.getProperty("level")) || "10".equals(candidate.getProperty("level"))) {
            if (!candidate.getName().startsWith("F80-")) {
                int i = 0;
                while (i < this.labelsWithoutFn.length) {
                    if (this.labelsWithoutFn[i].equals(candidate.getName())) {
                        this.lastStatementBeginIdx = -1;
                        this.lastStatementEndIdx = -1;
                        this.cobolName = candidate.getName();
                        return true;
                    }
                    ++i;
                }
            }
        } else if (candidate.getName().endsWith("-PROC")) {
            this.lastStatementBeginIdx = -1;
            this.lastStatementEndIdx = -1;
            this.cobolName = candidate.getName();
            return true;
        }
        return super.findLastStatement(candidate);
    }

    @Override
    protected boolean validateFirstStatement(IGeneratedTag candidate, String cobolLabel, int lineStartIdx, int nextLineStartIdx) {
        if (super.validateFirstStatement(candidate, cobolLabel, lineStartIdx, nextLineStartIdx)) {
            if (candidate.getName().startsWith("F80-") && candidate.getName().contains("-EX-")) {
                this.firstStatementBeginIdx = lineStartIdx;
                this.firstStatementEndIdx = nextLineStartIdx;
                this.cobolName = cobolLabel;
            }
            return true;
        }
        return "05".equals(candidate.getProperty("level")) && cobolLabel.trim().length() == 0;
    }

    @Override
    protected boolean validateLastStatement(IGeneratedTag candidate, String cobolLabel, int lineBeginIdx, int lineEndIdx) {
        return super.validateLastStatement(candidate, cobolLabel, lineBeginIdx, lineEndIdx);
    }

    @Override
    protected boolean validateNoTextFoundInFirstStatement(IGeneratedTag candidate) {
        if (this.lastStatementBeginIdx > 0) {
            int endInd;
            int beginInd = candidate.getBeginIndex();
            int n = endInd = this.lastStatementBeginIdx == -1 ? candidate.getEndIndex() : this.lastStatementBeginIdx;
            if (this.text.subSequence(beginInd, endInd).toString().trim().startsWith("*!GT  \"05")) {
                return true;
            }
        }
        return false;
    }
}

