/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.extension.organize;

import com.ibm.pdp.engine.IGeneratedInfo;
import com.ibm.pdp.engine.IGeneratedTag;
import com.ibm.pdp.pacbase.extension.organize.GeneratedFunctionsCursor;
import com.ibm.pdp.pacbase.extension.organize.Location;

public class GeneratedFunctionsCursorForDialog
extends GeneratedFunctionsCursor {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2014, 2016.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public GeneratedFunctionsCursorForDialog(IGeneratedInfo generatedInfo) {
        super(generatedInfo);
    }

    @Override
    protected boolean acceptTagProperties(IGeneratedTag candidate) {
        if (!super.acceptTagProperties(candidate)) {
            return candidate.getName().startsWith("END-OF-");
        }
        return true;
    }

    @Override
    protected boolean validateFirstStatement(IGeneratedTag candidate, String cobolLabel, int lineStartIdx, int nextLineStartIdx) {
        if (super.validateFirstStatement(candidate, cobolLabel, lineStartIdx, nextLineStartIdx)) {
            return this.validateFirstTrueStatementF80(candidate, cobolLabel, lineStartIdx, nextLineStartIdx);
        }
        if (candidate.getName().startsWith("F35A-") || candidate.getName().startsWith("F35R-")) {
            return this.validateFirstStatementF35(candidate, cobolLabel, lineStartIdx, nextLineStartIdx);
        }
        if ("F3999".equals(candidate.getName())) {
            return this.validateFirstStatementF3999(candidate, cobolLabel, lineStartIdx, nextLineStartIdx);
        }
        if ("F6999".equals(candidate.getName())) {
            return this.validateFirstStatementF6999(candidate, cobolLabel, lineStartIdx, nextLineStartIdx);
        }
        if (candidate.getName().startsWith("F80")) {
            return this.validateFirstFalseStatementF80(candidate, cobolLabel, lineStartIdx, nextLineStartIdx);
        }
        return false;
    }

    @Override
    protected boolean validateLastStatement(IGeneratedTag candidate, String cobolLabel, int lineBeginIdx, int lineEndIdx) {
        if (!super.validateLastStatement(candidate, cobolLabel, lineBeginIdx, lineEndIdx)) {
            if (candidate.getName().startsWith("F80") && candidate.getName().contains("-") || candidate.getName().startsWith("END-OF-")) {
                this.lastStatementBeginIdx = -1;
                this.lastStatementEndIdx = -1;
                this.cobolName = candidate.getName();
                if ("F80-OKKO".equals(candidate.getName())) {
                    this.cobolName = "F80-OK";
                }
                return true;
            }
            if (candidate.getName().startsWith("F35")) {
                return this.validateLastStatementF35(candidate, cobolLabel, lineBeginIdx, lineEndIdx);
            }
            return false;
        }
        return this.validateLastStatementF80(candidate, cobolLabel, lineBeginIdx, lineEndIdx);
    }

    protected boolean validateFirstStatementF35(IGeneratedTag candidate, String cobolLabel, int lineStartIdx, int nextLineStartIdx) {
        if (cobolLabel.length() == 7 && candidate.getName().equals(this.cobolName)) {
            this.lastStatementBeginIdx = -1;
            this.lastStatementEndIdx = -1;
            this.cobolName = cobolLabel;
            return true;
        }
        return false;
    }

    protected boolean validateFirstStatementF3999(IGeneratedTag candidate, String cobolLabel, int lineStartIdx, int nextLineStartIdx) {
        if (!"F3999-ITER-FI".equals(cobolLabel) && !"F3999-ITER-FT".equals(cobolLabel)) {
            return false;
        }
        this.cobolName = cobolLabel;
        this.firstStatementBeginIdx = lineStartIdx;
        this.firstStatementEndIdx = nextLineStartIdx;
        return true;
    }

    protected boolean validateFirstStatementF6999(IGeneratedTag candidate, String cobolLabel, int lineStartIdx, int nextLineStartIdx) {
        if (!"F6999-ITER-FI".equals(cobolLabel) && !"F6999-ITER-FT".equals(cobolLabel)) {
            return false;
        }
        this.cobolName = cobolLabel;
        this.firstStatementBeginIdx = lineStartIdx;
        this.firstStatementEndIdx = nextLineStartIdx;
        return true;
    }

    protected boolean validateFirstTrueStatementF80(IGeneratedTag candidate, String cobolLabel, int lineStartIdx, int nextLineStartIdx) {
        if (candidate.getName().startsWith("F80-") && candidate.getName().length() == 8 && cobolLabel.length() > 4) {
            try {
                Integer.parseInt(cobolLabel.substring(3, 5));
            }
            catch (Exception exception) {
                return true;
            }
            return false;
        }
        return true;
    }

    protected boolean validateLastStatementF35(IGeneratedTag candidate, String cobolLabel, int lineStartIdx, int nextLineStartIdx) {
        if ((candidate.getName().startsWith("F35A-") && cobolLabel.startsWith("F35A-") || candidate.getName().startsWith("F35R-") && cobolLabel.startsWith("F35R-")) && cobolLabel.length() == 7) {
            this.lastStatementBeginIdx = -1;
            this.lastStatementEndIdx = -1;
            this.cobolName = cobolLabel;
            return true;
        }
        if ((candidate.getName().startsWith("F35A-") || candidate.getName().startsWith("F35R-") && cobolLabel.startsWith("F35R-")) && candidate.getName().length() < 12 && "06".equals(candidate.getProperty("level"))) {
            this.lastStatementBeginIdx = -1;
            this.lastStatementEndIdx = -1;
            this.cobolName = candidate.getName();
            return true;
        }
        return false;
    }

    protected boolean validateFirstFalseStatementF80(IGeneratedTag candidate, String cobolLabel, int lineStartIdx, int nextLineStartIdx) {
        if (this.cobolName.startsWith("F80") && cobolLabel.startsWith("F80-")) {
            this.firstStatementBeginIdx = -1;
            this.firstStatementEndIdx = -1;
            return true;
        }
        if (this.cobolName.startsWith("F80-") && this.cobolName.length() == 8 && this.lastStatementBeginIndex() == -1) {
            this.firstStatementBeginIdx = -1;
            this.firstStatementEndIdx = -1;
            return true;
        }
        return false;
    }

    protected boolean validateLastStatementF80(IGeneratedTag candidate, String cobolLabel, int lineStartIdx, int nextLineStartIdx) {
        if (candidate.getName().startsWith("F80-") && candidate.getName().length() == 8) {
            if (cobolLabel.length() > 4) {
                try {
                    Integer.parseInt(cobolLabel.substring(3, 5));
                }
                catch (Exception exception) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    @Override
    protected boolean validateNoTextFoundInFirstStatement(IGeneratedTag candidate) {
        return this.validateNoTextFoundForCandidate(candidate);
    }

    @Override
    protected boolean validateNoTextFoundInLastStatement(IGeneratedTag candidate) {
        return this.validateNoTextFoundForCandidate(candidate);
    }

    protected boolean validateNoTextFoundForCandidate(IGeneratedTag candidate) {
        if (candidate.getName().startsWith("F80-") && candidate.getName().length() == 8 || candidate.getName().equals("F25") || candidate.getName().equals("F35") || candidate.getName().equals("F60")) {
            this.cobolName = candidate.getName();
            this.lastStatementBeginIdx = -1;
            this.lastStatementEndIdx = -1;
            this.firstStatementBeginIdx = -1;
            this.firstStatementEndIdx = -1;
            return true;
        }
        return false;
    }

    @Override
    public Location location() {
        String action = this.currentTag.getProperty("action");
        if (action == null || action.trim().length() == 0) {
            return null;
        }
        Location[] locationArray = Location.values();
        int n = locationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Location value = locationArray[n2];
            if (action.equals(value.getInsertMspName())) {
                return value;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public String reference() {
        String refInPgm = this.currentTag.getProperty("refInPgm");
        if ("ZZ".equals(refInPgm)) {
            return refInPgm;
        }
        String ref = this.currentTag.getProperty("refMIA");
        if (ref != null && ref.trim().length() != 0) {
            ref = this.calculateRefForSpecificPattern(ref);
        }
        return ref;
    }

    protected String calculateRefForSpecificPattern(String ref) {
        if (this.currentTag.getName().startsWith("F80") && ref.lastIndexOf("-") > 7) {
            ref = ref.substring(0, ref.lastIndexOf("-"));
        }
        return ref;
    }

    @Override
    public float level() {
        if (this.currentTag.getProperty("level") == null && this.currentTag.getName().startsWith("END-OF")) {
            return 5.0f;
        }
        return super.level();
    }
}

