/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.extension.organize;

import com.ibm.pdp.engine.IBuilderTag;
import com.ibm.pdp.engine.IGeneratedInfo;
import com.ibm.pdp.engine.IGeneratedTag;
import com.ibm.pdp.pacbase.extension.organize.GeneratedFunctionsCursor;

public class GeneratedFunctionsCursorForBatch
extends GeneratedFunctionsCursor {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2014, 2015.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public GeneratedFunctionsCursorForBatch(IGeneratedInfo generatedInfo) {
        super(generatedInfo);
    }

    @Override
    protected boolean validateFirstStatement(IGeneratedTag candidate, String cobolLabel, int lineStartIdx, int nextLineStartIdx) {
        if (super.validateFirstStatement(candidate, cobolLabel, lineStartIdx, nextLineStartIdx)) {
            return true;
        }
        if ("F76".equals(candidate.getName())) {
            return this.validateFirstStatementF76(candidate, cobolLabel, lineStartIdx, nextLineStartIdx);
        }
        if (candidate.getName().startsWith("F01") || candidate.getName().startsWith("F10")) {
            return this.validateFirstStatementF01F10(candidate, cobolLabel, lineStartIdx, nextLineStartIdx);
        }
        return false;
    }

    protected boolean validateFirstStatementF76(IGeneratedTag candidate, String cobolLabel, int lineStartIdx, int nextLineStartIdx) {
        if (!"F76-A".equals(cobolLabel)) {
            return false;
        }
        this.firstStatementBeginIdx = lineStartIdx;
        this.firstStatementEndIdx = nextLineStartIdx;
        return true;
    }

    protected boolean validateFirstStatementF01F10(IGeneratedTag candidate, String cobolLabel, int lineStartIdx, int nextLineStartIdx) {
        if (!cobolLabel.startsWith(this.cobolName)) {
            return false;
        }
        this.cobolName = cobolLabel;
        this.firstStatementBeginIdx = lineStartIdx;
        this.firstStatementEndIdx = nextLineStartIdx;
        return true;
    }

    @Override
    protected boolean findFirstStatement(IGeneratedTag candidate) {
        if (!candidate.getName().equals("F9099")) {
            if (!super.findFirstStatement(candidate)) {
                if (candidate.getName().startsWith("F") && candidate.getName().length() > 2 && candidate.getName().length() < 6) {
                    if (this.lastStatementBeginIdx < 0) {
                        return true;
                    }
                    if (candidate.getName().startsWith("F01")) {
                        this.firstStatementBeginIdx = -1;
                        this.firstStatementEndIdx = -1;
                        return true;
                    }
                }
                return false;
            }
            return true;
        }
        this.firstStatementBeginIdx = candidate.getBeginIndex();
        this.firstStatementEndIdx = candidate.getEndIndex();
        return true;
    }

    @Override
    protected boolean findLastStatement(IGeneratedTag candidate) {
        if (super.findLastStatement(candidate)) {
            return true;
        }
        if (!candidate.getName().startsWith("F") && candidate.getName().length() < 3 && candidate.getName().length() > 5) {
            return false;
        }
        this.lastStatementBeginIdx = -1;
        this.lastStatementEndIdx = -1;
        this.cobolName = candidate.getName();
        return true;
    }

    @Override
    protected boolean acceptTagProperties(IGeneratedTag candidate) {
        String candidateName = candidate.getName();
        if (!candidateName.startsWith("F")) {
            return false;
        }
        if (candidate.getProperty("level") == null) {
            return "F9099".equals(candidateName);
        }
        return true;
    }

    @Override
    public String reference() {
        IBuilderTag tag = this.currentTag.getGeneratedInfo().toGeneratedInfoBuilder().tagFromName(this.currentTag.getName());
        if (tag.getText().toString().contains("COA")) {
            return "COA";
        }
        return super.reference();
    }

    @Override
    protected boolean validateLastStatement(IGeneratedTag candidate, String cobolLabel, int lineBeginIdx, int lineEndIdx) {
        if (super.validateLastStatement(candidate, cobolLabel, lineBeginIdx, lineEndIdx)) {
            String line = candidate.getGeneratedInfo().getText().subSequence(lineBeginIdx, lineEndIdx).toString();
            if (line.trim().endsWith("COA")) {
                this.cobolName = candidate.getName();
                this.lastStatementBeginIdx = -1;
                this.lastStatementEndIdx = -1;
            }
            return true;
        }
        if (!"F05".equals(candidate.getName())) {
            return false;
        }
        this.cobolName = "F05";
        this.lastStatementBeginIdx = -1;
        this.lastStatementEndIdx = -1;
        return true;
    }
}

