/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.extension.organize;

import com.ibm.pdp.engine.IGeneratedInfo;
import com.ibm.pdp.engine.IGeneratedTag;
import com.ibm.pdp.pacbase.extension.organize.Location;
import com.ibm.pdp.util.Strings;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class GeneratedFunctionsCursor {
    protected IGeneratedInfo generatedInfo;
    protected CharSequence text;
    protected boolean found;
    protected IGeneratedTag currentTag;
    protected IGeneratedTag dash900Tag;
    protected String cobolName;
    protected int firstStatementBeginIdx;
    protected int firstStatementEndIdx;
    protected int lastStatementBeginIdx;
    protected int lastStatementEndIdx;
    protected Deque<Iterator<IGeneratedTag>> stack;
    protected static final Set<String> tagNamesToSkip = new HashSet<String>();
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2014, 2015.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    static {
        tagNamesToSkip.add("IDENTIFICATION");
        tagNamesToSkip.add("ENVIRONMENT");
        tagNamesToSkip.add("DATA");
    }

    public GeneratedFunctionsCursor(IGeneratedInfo generatedInfo) {
        this.generatedInfo = generatedInfo;
        this.text = generatedInfo.getText();
        this.stack = new ArrayDeque<Iterator<IGeneratedTag>>();
        this.currentTag = generatedInfo.getRootTag();
        if (this.currentTag != null && this.currentTag.nbOfSons() == 0) {
            this.currentTag = null;
        }
        this.firstStatementBeginIdx = -1;
        this.firstStatementEndIdx = -1;
        this.lastStatementBeginIdx = -1;
        this.lastStatementEndIdx = -1;
    }

    public boolean searchNextFunction() {
        if (this.currentTag == null) {
            return false;
        }
        do {
            this.enterCurrentTag();
            Iterator<IGeneratedTag> tags = this.stack.peek();
            while (!tags.hasNext()) {
                this.stack.pop();
                if (this.stack.isEmpty()) {
                    return this.ko();
                }
                tags = this.stack.peek();
            }
            this.currentTag = tags.next();
        } while (!this.accept(this.currentTag));
        return this.ok();
    }

    protected boolean enterCurrentTag() {
        if (tagNamesToSkip.contains(this.currentTag.getName()) || this.currentTag.nbOfSons() == 0) {
            return false;
        }
        Iterator subTags = this.currentTag.sons();
        this.stack.push(subTags);
        return true;
    }

    protected boolean accept(IGeneratedTag candidate) {
        if (!this.acceptTagProperties(candidate)) {
            return false;
        }
        if (!this.findLastStatement(candidate)) {
            return false;
        }
        if (!this.findFirstStatement(candidate)) {
            return false;
        }
        this.dash900Tag = this.findDash900Tag(candidate);
        return true;
    }

    protected boolean acceptTagProperties(IGeneratedTag candidate) {
        if (!candidate.getName().startsWith("F")) {
            return false;
        }
        return candidate.getProperty("level") != null;
    }

    protected IGeneratedTag findDash900Tag(IGeneratedTag functionTag) {
        String dash900TagName = String.valueOf(this.cobolName) + "-900";
        return this.reccursiveFindDash900Tag(dash900TagName, functionTag);
    }

    protected IGeneratedTag reccursiveFindDash900Tag(String dash900TagName, IGeneratedTag tag) {
        if (tag.getName().equals(dash900TagName)) {
            return tag;
        }
        Iterator subtags = tag.sons();
        while (subtags.hasNext()) {
            IGeneratedTag found = this.reccursiveFindDash900Tag(dash900TagName, (IGeneratedTag)subtags.next());
            if (found == null) continue;
            return found;
        }
        return null;
    }

    protected boolean findLastStatement(IGeneratedTag candidate) {
        int minIdx = this.lastPartStartIndex(candidate);
        int maxIdx = candidate.getEndIndex();
        int column = this.computeColumn(maxIdx);
        if (column != 0) {
            return false;
        }
        int lineBeginIdx = maxIdx;
        while (lineBeginIdx > minIdx) {
            int lineEndIdx = this.findEndOfLine(lineBeginIdx = this.moveToPreviousNonBlankLineBegining(lineBeginIdx - 1, minIdx), maxIdx);
            if (lineEndIdx - lineBeginIdx < 7 || this.text.charAt(lineBeginIdx + 6) != ' ') continue;
            int idx = lineBeginIdx + 6;
            while (++idx < lineEndIdx) {
                char c = this.text.charAt(idx);
                if (c == ' ') continue;
                int nameStart = idx;
                int nameStop = idx;
                while (++idx < lineEndIdx) {
                    c = this.text.charAt(idx);
                    if (c == ' ' || c == '\n' || c == '\r') break;
                    if (c != '.') continue;
                    nameStop = idx;
                    break;
                }
                String cobolLabel = this.text.subSequence(nameStart, nameStop).toString();
                return this.validateLastStatement(candidate, cobolLabel, lineBeginIdx, lineEndIdx);
            }
        }
        return this.validateNoTextFoundInLastStatement(candidate);
    }

    protected boolean validateNoTextFoundInLastStatement(IGeneratedTag candidate) {
        return false;
    }

    protected boolean validateNoTextFoundInFirstStatement(IGeneratedTag candidate) {
        return false;
    }

    protected boolean isDash900Line(int startIndex, int stopIndex, String cobolName) {
        int spaces = this.countSpaces(startIndex, stopIndex);
        if (spaces < 7) {
            return false;
        }
        int nameLength = cobolName.length();
        if (stopIndex - startIndex - spaces < nameLength + 5) {
            return false;
        }
        return Strings.sameSubSequences((CharSequence)cobolName, (int)0, (CharSequence)this.text, (int)(startIndex + spaces), (int)nameLength) && Strings.sameSubSequences((CharSequence)"-900.", (int)0, (CharSequence)this.text, (int)(startIndex + spaces + nameLength), (int)5);
    }

    protected int countSpaces(int idx, int max) {
        int count = 0;
        while (idx < max) {
            if (this.text.charAt(idx) != ' ') {
                return count;
            }
            ++idx;
            ++count;
        }
        return count;
    }

    protected boolean validateLastStatement(IGeneratedTag candidate, String cobolLabel, int lineBeginIdx, int lineEndIdx) {
        if (!cobolLabel.startsWith("F") || !cobolLabel.endsWith("-FN")) {
            return false;
        }
        this.cobolName = cobolLabel.substring(0, cobolLabel.length() - 3);
        this.lastStatementBeginIdx = lineBeginIdx;
        this.lastStatementEndIdx = lineEndIdx;
        return true;
    }

    protected int lastPartStartIndex(IGeneratedTag tag) {
        int lastPartStartIdx = tag.getBeginIndex();
        Iterator sons = tag.sons();
        while (sons.hasNext()) {
            IGeneratedTag son = (IGeneratedTag)sons.next();
            if (!son.getName().startsWith("F") || son.getProperty("level") == null) continue;
            lastPartStartIdx = son.getEndIndex();
        }
        return lastPartStartIdx;
    }

    protected boolean findFirstStatement(IGeneratedTag candidate) {
        int idx = candidate.getBeginIndex();
        int maxIdx = this.lastStatementBeginIdx == -1 ? candidate.getEndIndex() : this.lastStatementBeginIdx;
        int column = this.computeColumn(idx);
        if (column != 0) {
            return false;
        }
        idx = this.moveToColumn6(column, idx, maxIdx);
        while (idx < maxIdx) {
            column = 6;
            char c = this.text.charAt(idx);
            if (c == ' ') {
                while (++idx < maxIdx) {
                    String cobolLabel;
                    ++column;
                    c = this.text.charAt(idx);
                    if (c == '\n' || c == '\r') break;
                    if (c == ' ') continue;
                    int lineStartIdx = idx - column;
                    int nextLineStartIdx = this.moveToNextLine(idx, maxIdx);
                    int nameStart = idx;
                    int nameStop = idx;
                    while (++idx < nextLineStartIdx) {
                        c = this.text.charAt(idx);
                        if (c == ' ' || c == '\n' || c == '\r') break;
                        if (c != '.') continue;
                        nameStop = idx;
                        break;
                    }
                    if (this.validateFirstStatement(candidate, cobolLabel = this.text.subSequence(nameStart, nameStop).toString(), lineStartIdx, nextLineStartIdx)) {
                        return true;
                    }
                    break;
                }
            } else {
                ++column;
            }
            idx = this.moveToColumn6(column, idx, maxIdx);
        }
        return this.validateNoTextFoundInFirstStatement(candidate);
    }

    protected boolean validateFirstStatement(IGeneratedTag candidate, String cobolLabel, int lineStartIdx, int nextLineStartIdx) {
        if (!cobolLabel.equals(this.cobolName)) {
            return false;
        }
        this.firstStatementBeginIdx = lineStartIdx;
        this.firstStatementEndIdx = nextLineStartIdx;
        return true;
    }

    protected int firstPartStopIndex(IGeneratedTag tag) {
        Iterator sons = tag.sons();
        return sons.hasNext() ? ((IGeneratedTag)sons.next()).getBeginIndex() : tag.getEndIndex();
    }

    protected int moveToColumn6(int column, int idx, int maxIdx) {
        while (idx < maxIdx) {
            char c = this.text.charAt(idx);
            if (c == '\r' || c == '\n') {
                column = 0;
            } else {
                if (column == 6) {
                    return idx;
                }
                ++column;
            }
            ++idx;
        }
        return idx;
    }

    protected int moveToNextLine(int idx, int maxIdx) {
        while (idx < maxIdx) {
            char c = this.text.charAt(idx);
            if (c == '\r') {
                if (idx + 1 < maxIdx && this.text.charAt(idx + 1) == '\n') {
                    return idx + 2;
                }
                return idx + 1;
            }
            if (c == '\n') {
                if (idx + 1 < maxIdx && this.text.charAt(idx + 1) == '\r') {
                    return idx + 2;
                }
                return idx + 1;
            }
            ++idx;
        }
        return maxIdx;
    }

    protected int moveToPreviousNonBlankLineBegining(int idx, int minIdx) {
        boolean foundSignificantChar = false;
        while (--idx >= minIdx) {
            char c = this.text.charAt(idx);
            if (c == '\r' || c == '\n') {
                if (!foundSignificantChar) continue;
                return idx + 1;
            }
            if (c == ' ') continue;
            foundSignificantChar = true;
        }
        return idx + 1;
    }

    protected int findEndOfLine(int idx, int maxIdx) {
        while (idx < maxIdx) {
            char c = this.text.charAt(idx);
            if (c == '\n' || c == '\r') {
                return idx;
            }
            ++idx;
        }
        return maxIdx;
    }

    protected int computeColumn(int idx) {
        if (idx == 0 || idx == this.text.length()) {
            return 0;
        }
        char c = this.text.charAt(idx);
        if (c == '\r' || c == '\n') {
            return 0;
        }
        int column = 0;
        do {
            if ((c = this.text.charAt(--idx)) == '\n' || c == '\r') {
                return column;
            }
            ++column;
        } while (idx > 0);
        return column;
    }

    protected boolean ok() {
        this.found = true;
        return true;
    }

    protected boolean ko() {
        this.currentTag = null;
        this.dash900Tag = null;
        this.cobolName = null;
        this.firstStatementBeginIdx = -1;
        this.firstStatementEndIdx = -1;
        this.lastStatementBeginIdx = -1;
        this.lastStatementEndIdx = -1;
        this.found = false;
        return false;
    }

    public boolean found() {
        return this.found;
    }

    public IGeneratedTag tag() {
        return this.currentTag;
    }

    public IGeneratedTag dash900Tag() {
        return this.dash900Tag;
    }

    public float level() {
        String levelStr = this.currentTag.getProperty("level");
        if (levelStr == null) {
            return -1.0f;
        }
        try {
            return Float.parseFloat(levelStr);
        }
        catch (NumberFormatException numberFormatException) {
            return -1.0f;
        }
    }

    public Location location() {
        return null;
    }

    public String reference() {
        return "";
    }

    public String cobolName() {
        return this.cobolName;
    }

    public int beginIndex() {
        return this.currentTag.getBeginIndex();
    }

    public int endIndex() {
        return this.currentTag.getEndIndex();
    }

    public int firstStatementBeginIndex() {
        return this.firstStatementBeginIdx;
    }

    public int firstStatementEndIndex() {
        return this.firstStatementEndIdx;
    }

    public int bodyEndIndex() {
        return -1;
    }

    public int lastStatementBeginIndex() {
        return this.lastStatementBeginIdx;
    }

    public int lastStatementEndIndex() {
        return this.lastStatementEndIdx;
    }
}

