/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.extension.organize;

import com.ibm.pdp.engine.IBuilderTag;
import com.ibm.pdp.engine.IGenInfoBuilder;
import com.ibm.pdp.engine.IGeneratedInfo;
import com.ibm.pdp.engine.ITextProcessor;
import com.ibm.pdp.framework.PdpTool;
import com.ibm.pdp.pacbase.extension.organize.FunctionUtilities;
import com.ibm.pdp.pacbase.extension.organize.IVirtualFunction;
import com.ibm.pdp.pacbase.extension.organize.PdpFunction;
import com.ibm.pdp.pacbase.extension.organize.SpecialMacroAnalyzer;
import com.ibm.pdp.pacbase.generate.util.NodeInformations;
import com.ibm.pdp.pacbase.generate.util.NodeTagInformations;
import com.ibm.pdp.pacbase.generator.VirtualMacroCleaner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class GenInfoModification {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2016, 2023.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    ITextProcessor textProcessor = null;
    Comparator<NodeInformations> defaultComparator = null;
    public static final String LEVEL = "level";
    public static final String MSP = "msp";
    private List<String> allFunctionsFromSPmacro;
    private String patternName = null;
    private List<String> allSubFunctionsWithMoreThanMP;
    List<String> allSUPfunctions = new ArrayList<String>();
    List<String> allArtificalCreateSubFunctionsToClean = new ArrayList<String>();
    Map<String, List<String>> allSubFunctionsInSubFunction = new HashMap<String, List<String>>();
    Map<String, List<String>> allMPsInSubFunction = new HashMap<String, List<String>>();
    List<String> allSubFunctionsWithNnumberLineDifferentFromZero = Collections.emptyList();
    List<String> allFunctionsOverridenInSpecific = Collections.emptyList();
    List<String> dash900toRestore = new ArrayList<String>();
    List<String> allSubFunctionToReplaceAfterMerge = new ArrayList<String>();
    private List<String> specialFunctionsdependingOnPattern = null;

    public GenInfoModification(ITextProcessor textProcessor, String pattern) {
        this.textProcessor = textProcessor;
        this.patternName = pattern;
        this.allFunctionsFromSPmacro = new ArrayList<String>();
        this.allSubFunctionsWithMoreThanMP = new ArrayList<String>();
    }

    public void setTextProcessor(ITextProcessor tp) {
        if (tp != null) {
            this.textProcessor = tp;
        }
    }

    public IGeneratedInfo getGenInfoAfterDeletedSubFunctionFromMacroSP(List<IVirtualFunction> functionsList, String macroSP) {
        IGenInfoBuilder gib = this.textProcessor.getGeneratedInfo().toGeneratedInfoBuilder();
        ArrayList tagsToDelete = new ArrayList();
        for (IVirtualFunction iFunction : functionsList) {
            PdpFunction f = (PdpFunction)iFunction;
            String name = f.getCobolName();
            IBuilderTag currentTag = gib.tagFromName(name);
            boolean toDelete = true;
            ArrayList<IBuilderTag> tagsToDeleteTmp = new ArrayList<IBuilderTag>();
            String msp = "";
            if (currentTag != null) {
                IBuilderTag currentSon = currentTag.firstSon();
                while (currentSon != null) {
                    if (this.isCurrentSonInCurrentFunction(name, currentSon)) {
                        msp = currentSon.getProperty(MSP);
                        if (msp == null || !msp.equals(macroSP)) {
                            String dash900 = String.valueOf(name) + "-900";
                            if (!currentSon.getName().equals(dash900)) {
                                toDelete = false;
                                break;
                            }
                        }
                        tagsToDeleteTmp.add(currentSon);
                    }
                    currentSon = currentSon.nextTag();
                }
            }
            if (!toDelete) {
                this.allSubFunctionsWithMoreThanMP.add(name);
                this.setPropertiesOnTag(currentTag, msp);
                for (IBuilderTag iBuilderTag : tagsToDeleteTmp) {
                    if (iBuilderTag == null) continue;
                    if (iBuilderTag.getName().startsWith("N")) {
                        gib.removeTagAndText(iBuilderTag);
                        continue;
                    }
                    this.setPropertiesOnTag(iBuilderTag, msp);
                }
                tagsToDeleteTmp.clear();
                continue;
            }
            tagsToDelete.addAll(tagsToDeleteTmp);
            tagsToDelete.add(currentTag);
        }
        for (IBuilderTag iBuilderTag : tagsToDelete) {
            if (iBuilderTag == null) continue;
            gib.removeTagAndText(iBuilderTag);
        }
        return gib.toGeneratedInfo();
    }

    public void setAllSUPfunctions(String allFunctions) {
        StringTokenizer st = new StringTokenizer(allFunctions);
        while (st.hasMoreTokens()) {
            this.allSUPfunctions.add(st.nextToken());
        }
    }

    public void setAllArtificalCreateSubFunctionsToClean(List<String> l) {
        this.allArtificalCreateSubFunctionsToClean = l;
        this.allSubFunctionsWithNnumberLineDifferentFromZero.removeAll(l);
    }

    public void setAllMPsInSubFunction(Map<String, List<String>> map) {
        this.allMPsInSubFunction = map;
    }

    public void setAllSubFunctionsWith_N_lineNumberDifferentFromZero(List<String> l) {
        this.allSubFunctionsWithNnumberLineDifferentFromZero = l;
    }

    public void setAllFunctionsOverridenInSpeific(List<String> l) {
        this.allFunctionsOverridenInSpecific = l;
    }

    public void setDash900Torestore(List<String> l) {
        this.dash900toRestore = l;
    }

    protected boolean isCurrentSonInCurrentFunctionCondition(String functionName, IBuilderTag currentSon) {
        String endOfSonName;
        int l;
        String sonName = currentSon.getName();
        if (sonName.startsWith("N" + functionName.substring(1))) {
            return true;
        }
        if (sonName.startsWith(functionName) && (l = (endOfSonName = sonName.substring(functionName.length())).length()) == 3) {
            int index = 0;
            while (l > index && Character.isDigit(endOfSonName.charAt(index))) {
                ++index;
            }
            return index == l;
        }
        return false;
    }

    protected boolean isCurrentSonInCurrentFunction(String functionName, IBuilderTag currentSon) {
        String sonName = currentSon.getName();
        if (sonName.startsWith("N" + functionName.substring(1))) {
            return true;
        }
        if (sonName.startsWith(functionName)) {
            String endOfSonName = sonName.substring(functionName.length());
            if ("-900".equals(endOfSonName)) {
                return true;
            }
            int l = endOfSonName.length();
            if (l == 3 || l == 6) {
                int index = 0;
                while (l > index && Character.isDigit(endOfSonName.charAt(index))) {
                    ++index;
                }
                return index == l;
            }
        } else if (currentSon.getProperty(LEVEL) != null) {
            List<Object> allSubFcts = null;
            if (this.allSubFunctionsInSubFunction.containsKey(functionName)) {
                allSubFcts = this.allSubFunctionsInSubFunction.get(functionName);
            } else {
                allSubFcts = new ArrayList();
                this.allSubFunctionsInSubFunction.put(functionName, allSubFcts);
            }
            allSubFcts.add(sonName);
            return false;
        }
        return false;
    }

    private void setPropertiesOnTag(IBuilderTag tag, String msp) {
        Iterator proprietes = tag.propertyNames();
        boolean isFunction = false;
        while (proprietes.hasNext()) {
            String prop = (String)proprietes.next();
            if (!LEVEL.equals(prop) && !MSP.equals(prop)) {
                tag.setProperty(prop, null);
            }
            if (MSP.equals(prop) && msp.length() > 0) {
                tag.setProperty(MSP, msp);
            }
            if (!LEVEL.equals(prop)) continue;
            tag.setProperty(LEVEL, "10");
            this.allSubFunctionToReplaceAfterMerge.add(tag.getName());
            isFunction = true;
        }
        if (!isFunction && tag.getParent().firstSon() == tag) {
            String text = tag.getText().toString();
            String newLine = PdpTool.determineDelimiterOfV2((CharSequence)text);
            text = "       " + tag.getParent().getName() + "." + newLine;
            text = VirtualMacroCleaner.AppendLevel(text, "lv10", true);
            tag.setText((CharSequence)text);
            int beginIndex = tag.getBeginIndex();
            int endIndex = tag.getEndIndex();
            String parentName = tag.getParent().getName();
            IBuilderTag nextTag = tag.nextTag();
            while (nextTag != null && !nextTag.getName().startsWith(parentName)) {
                nextTag = nextTag.nextTag();
            }
            String tagName = nextTag.getName();
            if ((tagName = tagName.substring(0, tagName.length() - 3)).equals(parentName)) {
                tagName = String.valueOf(nextTag.getName()) + "_Label";
            }
            tag.getGenInfoBuilder().removeTag(tag);
            IBuilderTag newTag = tag.getGenInfoBuilder().addTag(beginIndex, endIndex, tagName, parentName);
            proprietes = tag.propertyNames();
            while (proprietes.hasNext()) {
                String prop = (String)proprietes.next();
                newTag.setProperty(prop, tag.getProperty(prop));
            }
        }
    }

    public void cleanAllSubFunctionsToReplaceAfterMerge() {
        Iterator<String> itf = this.allSubFunctionToReplaceAfterMerge.iterator();
        ArrayList<String> toRemove = new ArrayList<String>();
        while (itf.hasNext()) {
            String functionCode = itf.next();
            if (this.allFunctionsFromSPmacro.contains(functionCode)) continue;
            toRemove.add(functionCode);
        }
        this.allSubFunctionToReplaceAfterMerge.removeAll(toRemove);
    }

    public IGeneratedInfo getGenInfoAfterRestoreSupFunctions(SpecialMacroAnalyzer sma, String name, IGeneratedInfo genInfo) {
        IGenInfoBuilder gib = this.textProcessor.getGeneratedInfo().toGeneratedInfoBuilder();
        Iterator<String> itsf = this.allSubFunctionsWithMoreThanMP.iterator();
        while (itsf.hasNext()) {
            this.allMPsInSubFunction.remove(itsf.next());
        }
        this.restoreNonArtificialCreateSubFunctions(gib, genInfo);
        this.cleanFunctionsOverridedInSpecific(gib, genInfo.toGeneratedInfoBuilder());
        Set<String> allSubFunctions = this.createListForNTI(sma, genInfo);
        allSubFunctions.addAll(this.addSpecialFunctionsDependingOnPattern(sma, gib, genInfo.toGeneratedInfoBuilder()));
        allSubFunctions.addAll(this.getMacroSubFunctionErasedBySPSubFunctions(gib, genInfo));
        List<NodeInformations> allNti = this.getAllNti(genInfo, allSubFunctions, sma);
        this.transformNTI(gib, allNti);
        this.modifyReferencedNTI(allNti, gib, genInfo.toGeneratedInfoBuilder());
        VirtualMacroCleaner.restoreDeletedSubFunctions(gib, allNti, name, true);
        if (sma != null) {
            this.restoreFunctionsCorrectly(gib, genInfo, sma.getAllFunctions());
        }
        this.restoreProperties(gib, genInfo);
        allSubFunctions.clear();
        for (String dash900 : this.dash900toRestore) {
            if (gib.tagFromName(dash900) != null) continue;
            allSubFunctions.add(dash900);
        }
        allNti = this.getDash900Nti(genInfo, allSubFunctions, sma);
        VirtualMacroCleaner.restoreDeletedSubFunctions(gib, allNti, name, true);
        this.cleanAllStarCfunctions(sma, gib);
        this.cleanAllArtificalCreateSubFunctions(gib);
        if ("com.ibm.pdp.pacbase.batch".equals(this.patternName)) {
            this.synchronizeSUPfunctions(gib, genInfo);
        }
        return gib.toGeneratedInfo();
    }

    public void synchronizeSUPfunctions(IGenInfoBuilder oldGib, IGeneratedInfo newGenInfo) {
        IGenInfoBuilder newGIB = newGenInfo.toGeneratedInfoBuilder();
        for (String supFunction : this.allSUPfunctions) {
            IBuilderTag tagCreated;
            IBuilderTag oldTag = oldGib.tagFromName(supFunction);
            oldTag = oldTag.firstSon();
            IBuilderTag newTag = newGIB.tagFromName(supFunction);
            newTag = newTag.firstSon();
            while (newTag != null && oldTag != null && this.isCurrentSonInCurrentFunction(supFunction, newTag)) {
                if (!oldTag.getName().equals(newTag.getName())) {
                    if (oldGib.tagFromName(newTag.getName()) == null) {
                        tagCreated = oldGib.addTagBefore(newTag.getName(), oldTag.getName());
                        GenInfoModification.CopyProperties(newTag, tagCreated);
                        tagCreated.setText(newTag.getText());
                        oldTag = tagCreated;
                        continue;
                    }
                    oldTag = oldTag.nextTag();
                    continue;
                }
                oldTag = oldTag.nextTag();
                newTag = newTag.nextTag();
            }
            while (newTag != null && this.isCurrentSonInCurrentFunction(supFunction, newTag)) {
                oldTag = oldGib.tagFromName(newTag.getName());
                if (oldTag != null) {
                    oldGib.removeTagAndText(oldTag);
                }
                oldTag = oldGib.tagFromName(newTag.previousTag().getName());
                tagCreated = oldGib.addTagAfter(newTag.getName(), oldTag.getName());
                GenInfoModification.CopyProperties(newTag, tagCreated);
                tagCreated.setText(newTag.getText());
                newTag = newTag.nextTag();
            }
        }
    }

    private void cleanAllArtificalCreateSubFunctions(IGenInfoBuilder gib) {
        for (String subfunction : this.allArtificalCreateSubFunctionsToClean) {
            String nl;
            int index;
            IBuilderTag tag = gib.tagFromName(subfunction);
            if (tag == null) continue;
            tag.setProperty(MSP, "artificialCreate");
            if (!FunctionUtilities.IsCOASubFunction(tag.getText().toString(), subfunction)) {
                gib.removeTagAndText(tag.firstSon());
            }
            String textAfter = tag.lastSon().getTextAfter().toString();
            StringBuilder sb = new StringBuilder();
            if (textAfter.length() > 3 && (index = textAfter.lastIndexOf(nl = PdpTool.determineDelimiterOfV2((CharSequence)textAfter), textAfter.length() - nl.length() - 1)) != -1) {
                sb.append(textAfter.substring(0, index + nl.length()));
            }
            tag.lastSon().setTextAfter((CharSequence)sb.toString());
        }
    }

    private void cleanAllStarCfunctions(SpecialMacroAnalyzer sma, IGenInfoBuilder oldGib) {
        if (sma == null) {
            return;
        }
        List<String> l = sma.getAllStarC();
        if (l == null) {
            return;
        }
        for (String string : l) {
            String fctName;
            IBuilderTag fctTag;
            int index = string.indexOf("=");
            if (index == -1 || (fctTag = oldGib.tagFromName(fctName = string.substring(0, index))) == null) continue;
            IBuilderTag currentTag = fctTag.firstSon();
            ArrayList<IBuilderTag> allTags = new ArrayList<IBuilderTag>();
            while (currentTag != null && this.isCurrentSonInCurrentFunction(fctName, currentTag)) {
                allTags.add(currentTag);
                currentTag = currentTag.nextTag();
            }
            for (IBuilderTag iBuilderTag : allTags) {
                oldGib.removeTagAndText(iBuilderTag);
            }
            this.cleanTextInTag(fctTag);
            oldGib.removeTag(fctTag);
        }
    }

    private List<NodeInformations> getDash900Nti(IGeneratedInfo genInfo, Set<String> supFunctionsList, SpecialMacroAnalyzer sma) {
        ArrayList<NodeInformations> allNti = new ArrayList<NodeInformations>();
        IGenInfoBuilder newGib = genInfo.toGeneratedInfoBuilder();
        for (String iFunction : supFunctionsList) {
            IBuilderTag tag = newGib.tagFromName(iFunction);
            if (tag == null) continue;
            NodeTagInformations nti = this.instanciateNewNti(tag);
            this.updatePositionInformations(nti, tag);
            nti.setNodeTagBefore(null);
            String t = nti.getTextAfter();
            int index = t.indexOf("EXIT");
            if (index != -1) {
                t = t.substring(0, index);
                nti.setTextAfter(t);
            }
            nti.setText(tag.getText().toString());
            allNti.add((NodeInformations)nti);
        }
        return allNti;
    }

    private void transformNTI(IGenInfoBuilder gib, List<NodeInformations> allNti) {
        NodeTagInformations nti;
        ArrayList<NodeInformations> toDelete = new ArrayList<NodeInformations>();
        ArrayList<NodeInformations> toAdd = new ArrayList<NodeInformations>();
        for (NodeInformations ni : allNti) {
            if (!(ni instanceof NodeTagInformations) || gib.tagFromName((nti = (NodeTagInformations)ni).getTagName()) == null) continue;
            toDelete.add(ni);
            NodeInformations niNew = new NodeInformations();
            niNew.setNodeTagAfter(ni.getNodeTagAfter());
            niNew.setNodeTagBefore(ni.getNodeTagBefore());
            niNew.setNodeTagEnclosing(nti.getTagName());
            niNew.setText(nti.getText());
            niNew.setTextAfter(nti.getTextAfter());
            niNew.setTextBefore(nti.getTextBefore());
            toAdd.add(niNew);
        }
        allNti.removeAll(toDelete);
        allNti.addAll(toAdd);
        if ("com.ibm.pdp.pacbase.dialog".equals(this.patternName) || "com.ibm.pdp.pacbase.csclient".equals(this.patternName)) {
            for (NodeInformations ni : allNti) {
                String textFct;
                IBuilderTag tag;
                String tagName;
                if (!(ni instanceof NodeTagInformations) || (nti = (NodeTagInformations)ni).getNodeTagAfter() != null && nti.getNodeTagBefore() != null || !"F25".equals(tagName = nti.getNodeTagEnclosing()) && !"F35".equals(tagName) || (tag = gib.tagFromName("N" + tagName.substring(1))) == null || !(textFct = tag.getTextAfter().toString()).startsWith("       " + tagName)) continue;
                String nl = PdpTool.determineDelimiterOfV2((CharSequence)textFct);
                nti.setTextBefore(textFct.substring(0, textFct.indexOf(nl) + nl.length()));
            }
        }
    }

    private void modifyReferencedNTI(List<NodeInformations> allNti, IGenInfoBuilder oldGib, IGenInfoBuilder newGib) {
        for (NodeInformations ni : allNti) {
            NodeTagInformations ntiBefore;
            if (!(ni instanceof NodeTagInformations)) continue;
            NodeTagInformations nti = (NodeTagInformations)ni;
            NodeTagInformations ntiAfter = this.searchNTIfromName(allNti, nti.getNodeTagAfter());
            if (ntiAfter != null) {
                if (ntiAfter.getNodeTagBefore() != null && ntiAfter.getNodeTagBefore().equals(nti.getNodeTagBefore())) {
                    ntiAfter.setNodeTagBefore(nti.getTagName());
                }
                this.detectEnglobingTags(nti, oldGib, newGib);
            }
            if ((ntiBefore = this.searchNTIfromName(allNti, nti.getNodeTagBefore())) == null) continue;
            if (ntiBefore.getNodeTagAfter() != null && ntiBefore.getNodeTagAfter().equals(nti.getNodeTagAfter())) {
                ntiBefore.setNodeTagAfter(nti.getTagName());
            }
            this.detectEnglobingTags(nti, oldGib, newGib);
        }
    }

    private void detectEnglobingTags(NodeTagInformations nti, IGenInfoBuilder oldGib, IGenInfoBuilder newGib) {
        IBuilderTag tag = newGib.tagFromName(nti.getTagName());
        String firstEnglobingTag = this.firstEnglobingTag(tag, oldGib);
        nti.setFirstEnglobingTagName(firstEnglobingTag);
        String lastEnglobingTag = this.lastEnglobingTag(tag, oldGib);
        nti.setLastEnglobingTagName(lastEnglobingTag);
        if (this.allSUPfunctions.contains(nti.getTagName()) && firstEnglobingTag == null && lastEnglobingTag == null && nti.getNodeTagAfter() != null && nti.getNodeTagBefore() != null) {
            if (oldGib.tagFromName(nti.getNodeTagBefore()) != null) {
                nti.setNodeTagAfter(null);
            } else if (oldGib.tagFromName(nti.getNodeTagAfter()) != null) {
                nti.setNodeTagBefore(null);
            }
        }
    }

    private String firstEnglobingTag(IBuilderTag tag, IGenInfoBuilder oldGib) {
        if (oldGib.tagFromName(tag.getName()) != null) {
            return tag.getName();
        }
        List<String> l = this.allMPsInSubFunction.get(tag.getName());
        if (l != null) {
            return l.get(0);
        }
        IBuilderTag son = tag.firstSon();
        String result = null;
        while (son != null && result == null) {
            result = this.firstEnglobingTag(son, oldGib);
            son = son.nextTag();
        }
        return result;
    }

    private String lastEnglobingTag(IBuilderTag tag, IGenInfoBuilder oldGib) {
        if (oldGib.tagFromName(tag.getName()) != null) {
            return tag.getName();
        }
        IBuilderTag son = tag.lastSon();
        String result = null;
        while (son != null && result == null) {
            result = this.lastEnglobingTag(son, oldGib);
            son = son.previousTag();
        }
        if (result != null) {
            return result;
        }
        List<String> l = this.allMPsInSubFunction.get(tag.getName());
        if (l != null) {
            return l.get(l.size() - 1);
        }
        return null;
    }

    private NodeTagInformations searchNTIfromName(List<NodeInformations> list, String name) {
        for (NodeInformations ni : list) {
            NodeTagInformations nti;
            if (!(ni instanceof NodeTagInformations) || !(nti = (NodeTagInformations)ni).getTagName().equals(name)) continue;
            return nti;
        }
        return null;
    }

    private void cleanFunctionsOverridedInSpecific(IGenInfoBuilder oldGib, IGenInfoBuilder newGib) {
        IBuilderTag tag;
        Iterator<String> itf = this.allFunctionsOverridenInSpecific.iterator();
        ArrayList<String> allTagsToDelete = new ArrayList<String>();
        while (itf.hasNext()) {
            String fct = itf.next();
            tag = oldGib.tagFromName(fct);
            if (tag == null) continue;
            allTagsToDelete.addAll(this.getAllGeneratedSubTags(tag, newGib));
        }
        if ("com.ibm.pdp.pacbase.dialog".equals(this.patternName)) {
            allTagsToDelete.remove("N05");
            allTagsToDelete.remove("N50");
            this.allFunctionsOverridenInSpecific.remove("F05");
            this.allFunctionsOverridenInSpecific.remove("F50");
        }
        for (String tagName : allTagsToDelete) {
            oldGib.removeTagAndText(oldGib.tagFromName(tagName));
        }
        for (String fct : this.allFunctionsOverridenInSpecific) {
            tag = oldGib.tagFromName(fct);
            if (tag == null) continue;
            this.cleanTextInTag(tag);
            tag.setProperty("functionOverridedBySpecific", "true");
        }
    }

    private void cleanTextInTag(IBuilderTag tag) {
        if (!tag.hasSon()) {
            tag.setText((CharSequence)"");
        } else {
            IBuilderTag currentTag = tag.firstSon();
            currentTag.setTextBefore((CharSequence)"");
            while (currentTag != null) {
                currentTag.setTextAfter((CharSequence)"");
                currentTag = currentTag.nextTag();
            }
        }
    }

    private List<String> getAllGeneratedSubTags(IBuilderTag tag, IGenInfoBuilder newGib) {
        ArrayList<String> result = new ArrayList<String>();
        IBuilderTag currentTag = tag.firstSon();
        while (currentTag != null) {
            if (this.isGeneratedTag(currentTag, newGib)) {
                result.addAll(this.getAllGeneratedSubTags(currentTag, newGib));
                result.add(currentTag.getName());
            }
            currentTag = currentTag.nextTag();
        }
        return result;
    }

    private boolean isGeneratedTag(IBuilderTag tagFromOld, IGenInfoBuilder newGib) {
        if (tagFromOld.getProperty(MSP) == null && tagFromOld.getProperty("mp") == null) {
            IBuilderTag newTag = newGib.tagFromName(tagFromOld.getName());
            if (newTag == null) {
                return true;
            }
            if (newTag.getProperty(MSP) == null && newTag.getProperty("mp") == null) {
                return true;
            }
        }
        return false;
    }

    private List<String> addSpecialFunctionsDependingOnPattern(SpecialMacroAnalyzer sma, IGenInfoBuilder oldGib, IGenInfoBuilder newGib) {
        if (sma == null) {
            return Collections.emptyList();
        }
        List<String> allFunctions = this.getSpecialFunctionsDependingOnPattern();
        ArrayList<String> result = new ArrayList<String>();
        for (String fct : allFunctions) {
            IBuilderTag newTag;
            IBuilderTag oldTag;
            if (sma.getAllFunctions().contains(fct) || (oldTag = oldGib.tagFromName(fct)) != null && oldTag.getLength() != 0 || (newTag = newGib.tagFromName(fct)) == null || newTag.getProperty("TagForXnnMP") == null) continue;
            oldGib.removeTag(fct);
            if (newTag.getLength() == 0 && newTag.getProperty("TagForXnnMP") == null) continue;
            sma.getAllFunctions().add(fct);
            result.add(fct);
        }
        this.specialFunctionsdependingOnPattern.retainAll(result);
        return this.specialFunctionsdependingOnPattern;
    }

    private List<String> getSpecialFunctionsDependingOnPattern() {
        if (this.specialFunctionsdependingOnPattern == null) {
            this.specialFunctionsdependingOnPattern = new ArrayList<String>();
            if ("com.ibm.pdp.pacbase.dialog".equals(this.patternName) || "com.ibm.pdp.pacbase.csclient".equals(this.patternName)) {
                this.specialFunctionsdependingOnPattern.add("F25");
                this.specialFunctionsdependingOnPattern.add("F35");
                this.specialFunctionsdependingOnPattern.add("F60");
            }
        }
        return this.specialFunctionsdependingOnPattern;
    }

    private void restoreFunctionsCorrectly(IGenInfoBuilder gib, IGeneratedInfo newGenInfo, List<String> allFunctions) {
        for (String function : allFunctions) {
            IBuilderTag fctTag = gib.tagFromName(function);
            if (fctTag == null) continue;
            int beginIndex = fctTag.getBeginIndex();
            int endIndex = fctTag.getEndIndex();
            int newBeginIndex = beginIndex;
            int newEndIndex = endIndex;
            for (String subFct : this.allMPsInSubFunction.keySet()) {
                if (!subFct.startsWith(function)) continue;
                List<String> mps = this.allMPsInSubFunction.get(subFct);
                for (String mpTag : mps) {
                    IBuilderTag currentTag = gib.tagFromName(mpTag);
                    int index = currentTag.getBeginIndex();
                    if (index < newBeginIndex) {
                        newBeginIndex = index;
                    }
                    if ((index = currentTag.getEndIndex()) <= newEndIndex) continue;
                    newEndIndex = index;
                }
            }
            if (beginIndex == newBeginIndex && endIndex == newEndIndex) continue;
            gib.removeTag(function);
            gib.addTag(newBeginIndex, newEndIndex, function, "PROCEDURE");
        }
    }

    private void restoreNonArtificialCreateSubFunctions(IGenInfoBuilder oldGib, IGeneratedInfo newGenInfo) {
        IGenInfoBuilder newGIB = newGenInfo.toGeneratedInfoBuilder();
        for (String aFunction : this.allSubFunctionToReplaceAfterMerge) {
            String text;
            IBuilderTag tagFct = newGIB.tagFromName(aFunction);
            IBuilderTag oldTagFct = oldGib.tagFromName(aFunction);
            IBuilderTag oldTag = oldTagFct.firstSon();
            String nTagName = "N" + aFunction.substring(1);
            if (tagFct.firstSon().getName().startsWith(nTagName)) {
                IBuilderTag newTag = tagFct.firstSon();
                nTagName = newTag.getName();
                IBuilderTag tmpTag = oldGib.addTagBefore(nTagName, oldTag.getName());
                tmpTag.setText(newTag.getText());
                Iterator itp = newTag.propertyNames();
                while (itp.hasNext()) {
                    String prop = (String)itp.next();
                    tmpTag.setProperty(prop, newTag.getProperty(prop));
                }
                newTag = newTag.nextTag();
                String etName = newTag.getName();
                if (tmpTag.nextTag().getName().equals(etName)) continue;
                String tagNameToDelete = tmpTag.nextTag().getName();
                tmpTag = oldGib.addTagAfter(etName, nTagName);
                tmpTag.setText(newTag.getText());
                itp = newTag.propertyNames();
                while (itp.hasNext()) {
                    String prop = (String)itp.next();
                    tmpTag.setProperty(prop, newTag.getProperty(prop));
                }
                oldGib.removeTagAndText(oldGib.tagFromName(tagNameToDelete));
                continue;
            }
            if (this.allSubFunctionsWithNnumberLineDifferentFromZero.contains(aFunction)) {
                IBuilderTag tag = oldTagFct.firstSon();
                while (newGIB.tagFromName(tag.getName()) == null) {
                    IBuilderTag next = tag.nextTag();
                    oldGib.removeTagAndText(tag);
                    tag = next;
                }
                tag = tagFct.firstSon();
                while (oldGib.tagFromName(tag.getName()) == null) {
                    tag = tag.nextTag();
                }
                String tagName = tag.getName();
                tag = tag.previousTag();
                while (tag != null) {
                    IBuilderTag newTag = oldGib.addTagBefore(tag.getName(), tagName);
                    newTag.setText(tag.getText());
                    GenInfoModification.CopyProperties(tag, newTag);
                    tagName = tag.getName();
                    tag = tag.previousTag();
                }
            }
            oldTag = oldTagFct.firstSon();
            String levOld = tagFct.getProperty("NTI_level");
            if (levOld == null) {
                levOld = tagFct.getProperty(LEVEL);
            }
            if ((text = oldTag.getText().toString()).length() > 0) {
                text = VirtualMacroCleaner.AppendLevel(text, "lv" + levOld, true);
                oldTag.setText((CharSequence)text);
            }
            if (oldTag.nextTag() == null) continue;
            IBuilderTag tagInNew = newGIB.tagFromName(oldTag.nextTag().getName());
            this.restoreOldGenInfoFrom(tagInNew, oldGib, aFunction);
        }
    }

    protected void restoreOldGenInfoFrom(IBuilderTag newTag, IGenInfoBuilder oldGIB, String aFunction) {
        while (newTag != null && this.isCurrentSonInCurrentFunction(aFunction, newTag) && this.isCurrentSonInCurrentFunctionCondition(aFunction, newTag)) {
            IBuilderTag oldTag = oldGIB.tagFromName(newTag.getName());
            if (oldTag != null && newTag.getText().charAt(6) != '*' && newTag.getText().charAt(7) != '!') {
                oldTag.setText((CharSequence)VirtualMacroCleaner.AppendMacroCode(newTag.getText().toString(), null));
            }
            newTag = newTag.nextTag();
        }
    }

    private Set<String> createListForNTI(SpecialMacroAnalyzer sma, IGeneratedInfo genInfo) {
        if (sma == null) {
            return new HashSet<String>();
        }
        IGenInfoBuilder gib = genInfo.toGeneratedInfoBuilder();
        HashSet<String> result = new HashSet<String>();
        for (IVirtualFunction iVirtualFunction : sma.getAllSupFunctions()) {
            String fctName = iVirtualFunction.getCobolName();
            IBuilderTag tag = gib.tagFromName(fctName);
            if (tag == null || this.isSubFunctionEmpty(tag)) continue;
            result.add(iVirtualFunction.getCobolName());
        }
        this.allArtificalCreateSubFunctionsToClean.removeAll(result);
        for (String string : this.allFunctionsFromSPmacro) {
            if (result.contains(string) || !this.isTerminalSubFunction(string) || this.allSubFunctionToReplaceAfterMerge.contains(string)) continue;
            IBuilderTag tag = gib.tagFromName(string);
            if (tag != null) {
                String prop = tag.getProperty(MSP);
                if (prop == null) {
                    prop = tag.getProperty("NTI_msp");
                }
                if (prop != null && !"MSPVIRT".equals(prop)) {
                    result.add(string);
                    continue;
                }
                prop = tag.getProperty("specificSubFunction");
                if (prop == null) {
                    result.add(string);
                    continue;
                }
                String speFct = this.getSpecialFunction(tag);
                if (speFct == null) continue;
                result.add(speFct);
                continue;
            }
            if (!"com.ibm.pdp.pacbase.dialog".equals(this.patternName)) continue;
            if ("F8095".equals(string) && gib.tagFromName("F80-HELP") != null) {
                result.add("F80-HELP");
                continue;
            }
            if ("F8098".equals(string) && gib.tagFromName("F80-LE00") != null) {
                result.add("F80-LE00");
                continue;
            }
            if (!"F8099".equals(string) || gib.tagFromName("F80-OKKO") == null) continue;
            result.add("F80-OKKO");
        }
        this.allFunctionsOverridenInSpecific.removeAll(result);
        result.addAll(this.allFunctionsOverridenInSpecific);
        return result;
    }

    private String getSpecialFunction(IBuilderTag tag) {
        if ("com.ibm.pdp.pacbase.dialog".equals(this.patternName)) {
            String ref = tag.getProperty("ref");
            if (ref == null) {
                return null;
            }
            ref = ref.trim();
            if (tag.getName().equals("F8095") && "HELP".equals(ref)) {
                return "F80-HELP";
            }
            if (tag.getName().equals("F8098") && "LE00".equals(ref)) {
                return "F80-LE00";
            }
            if (tag.getName().equals("F8099") && "OKKO".equals(ref)) {
                return "F80-OKKO";
            }
        }
        return null;
    }

    private boolean isTerminalSubFunction(String fctCode) {
        if (fctCode.length() == 5) {
            return !this.allMPsInSubFunction.containsKey(fctCode) && !this.allSubFunctionsInSubFunction.containsKey(fctCode);
        }
        Iterator<String> its = this.allMPsInSubFunction.keySet().iterator();
        while (its.hasNext()) {
            if (!its.next().startsWith(fctCode)) continue;
            return true;
        }
        its = this.allSubFunctionsInSubFunction.keySet().iterator();
        while (its.hasNext()) {
            if (!its.next().startsWith(fctCode)) continue;
            return true;
        }
        return false;
    }

    private void restoreProperties(IGenInfoBuilder gib, IGeneratedInfo genInfo) {
        Iterator<String> its = this.allFunctionsFromSPmacro.iterator();
        IGenInfoBuilder newGib = genInfo.toGeneratedInfoBuilder();
        while (its.hasNext()) {
            String fct = its.next();
            IBuilderTag oldTag = gib.tagFromName(fct);
            IBuilderTag newTag = newGib.tagFromName(fct);
            if (newTag == null || oldTag == null) continue;
            Iterator itp = newTag.propertyNames();
            ArrayList<String> allNTIprop = new ArrayList<String>();
            while (itp.hasNext()) {
                String prop = (String)itp.next();
                if (prop.startsWith("NTI_")) {
                    allNTIprop.add(prop);
                    continue;
                }
                oldTag.setProperty(prop, newTag.getProperty(prop));
            }
            for (String propNTI : allNTIprop) {
                String prop = propNTI.substring(4);
                oldTag.setProperty(prop, newTag.getProperty(propNTI));
            }
        }
    }

    private List<String> getMacroSubFunctionErasedBySPSubFunctions(IGenInfoBuilder gib, IGeneratedInfo newGenInfo) {
        IGenInfoBuilder newGIB = newGenInfo.toGeneratedInfoBuilder();
        ArrayList<String> subFunctionsToKeep = new ArrayList<String>();
        HashSet<String> allSubFunctions = new HashSet<String>();
        allSubFunctions.addAll(this.allMPsInSubFunction.keySet());
        allSubFunctions.addAll(this.allSubFunctionsInSubFunction.keySet());
        for (String subFunctionName : allSubFunctions) {
            IBuilderTag fctTag;
            if (!this.allFunctionsFromSPmacro.contains(subFunctionName) || (fctTag = newGIB.tagFromName(subFunctionName)) == null || this.isSubFunctionEmpty(fctTag) || this.allSubFunctionToReplaceAfterMerge.contains(subFunctionName)) continue;
            subFunctionsToKeep.add(subFunctionName);
        }
        return subFunctionsToKeep;
    }

    private boolean isSubFunctionEmpty(IBuilderTag tag) {
        if (tag.getLength() == 0) {
            return true;
        }
        return tag.hasSon() && tag.firstSon().getProperty(LEVEL) != null;
    }

    public IGeneratedInfo getGenInfoAfterDeletedInfosMacroSP(SpecialMacroAnalyzer sma) {
        List<IVirtualFunction> functionsList = sma.getAllRelativeFunctions();
        List<String> indexesList = sma.getAllIndexes();
        String macroSP = sma.getCpLine().getMacro().getName();
        IGeneratedInfo genInfo = null;
        this.setAllFunctionsFromSPmacro(functionsList);
        if (!functionsList.isEmpty()) {
            genInfo = this.getGenInfoAfterDeletedSubFunctionFromMacroSP(functionsList, macroSP);
        }
        if (!indexesList.isEmpty()) {
            genInfo = this.modifyGenInfoForIndexesFromMacroSP(genInfo, indexesList, this.patternName);
        }
        return genInfo;
    }

    public boolean needToRestoreOldGeneratedInfo() {
        if (!(this.allSubFunctionToReplaceAfterMerge.isEmpty() && this.allFunctionsFromSPmacro.isEmpty() && this.allMPsInSubFunction.isEmpty() && this.dash900toRestore.isEmpty() && this.allSubFunctionsWithNnumberLineDifferentFromZero.isEmpty() && this.allArtificalCreateSubFunctionsToClean.isEmpty() && this.allFunctionsOverridenInSpecific.isEmpty() && this.allSUPfunctions.isEmpty())) {
            return true;
        }
        if ("com.ibm.pdp.pacbase.dialog".equals(this.patternName)) {
            return this.allFunctionsFromSPmacro.contains("F8095") || this.allFunctionsFromSPmacro.contains("F8098") || this.allFunctionsFromSPmacro.contains("F8099");
        }
        return false;
    }

    private IGeneratedInfo modifyGenInfoForIndexesFromMacroSP(IGeneratedInfo gi, List<String> indexesList, String pattern) {
        IGenInfoBuilder gib = gi.toGeneratedInfoBuilder();
        for (String iIndex : indexesList) {
            IBuilderTag tag = gib.tagFromName(iIndex);
            if (tag == null) continue;
            gib.removeTagAndText(tag);
        }
        return gib.toGeneratedInfo();
    }

    private List<NodeInformations> getAllNti(IGeneratedInfo genInfo, Set<String> supFunctionsList, SpecialMacroAnalyzer sma) {
        ArrayList<NodeInformations> allNti = new ArrayList<NodeInformations>();
        IGenInfoBuilder oldGib = this.textProcessor.getGeneratedInfo().toGeneratedInfoBuilder();
        IGenInfoBuilder newGib = genInfo.toGeneratedInfoBuilder();
        for (String iFunction : supFunctionsList) {
            IBuilderTag tag = newGib.tagFromName(iFunction);
            if (tag == null) continue;
            NodeTagInformations nti = this.instanciateNewNti(tag);
            this.updatePositionInformations(nti, tag);
            allNti.add((NodeInformations)nti);
            if (tag.hasSon()) {
                this.processAllSons(tag, allNti, sma);
                nti.setText(tag.firstSon().getTextBefore().toString());
            } else {
                nti.setText(tag.getText().toString());
            }
            this.detectEnglobingTags(nti, oldGib, newGib);
        }
        return allNti;
    }

    private void processAllSons(IBuilderTag tag, List<NodeInformations> allNti, SpecialMacroAnalyzer sma) {
        if (tag != null) {
            boolean isFunction = sma.getAllFunctions().contains(tag.getName());
            if (isFunction) {
                isFunction = tag.getProperty(MSP) == null;
            }
            IBuilderTag currentSon = tag.firstSon();
            String name = "N" + tag.getName().substring(1);
            NodeTagInformations lastNTICreated = null;
            while (currentSon != null) {
                CharSequence t;
                if (!(!currentSon.getName().startsWith(tag.getName()) && !currentSon.getName().startsWith(name) || currentSon.getProperty("specificSubFunction") != null || currentSon.getProperty(MSP) != null && isFunction)) {
                    NodeTagInformations nti = this.instanciateNewNti(currentSon);
                    if (currentSon.getText() != null && currentSon.getText().length() > 0) {
                        nti.setText(currentSon.getText().toString());
                    }
                    this.updatePositionInformations(nti, currentSon);
                    lastNTICreated = nti;
                    allNti.add((NodeInformations)nti);
                }
                if ((t = currentSon.getTextAfter()) != null && t.length() > 0) {
                    NodeInformations ni = new NodeInformations();
                    ni.setText(t.toString());
                    if (lastNTICreated != null) {
                        if (lastNTICreated instanceof NodeTagInformations) {
                            ni.setNodeTagBefore(lastNTICreated.getTagName());
                        } else {
                            ni.setTextBefore(lastNTICreated.getText());
                        }
                    }
                    ni.setNodeTagEnclosing(tag.getName());
                    allNti.add(ni);
                }
                currentSon = currentSon.nextTag();
            }
        }
    }

    private NodeTagInformations instanciateNewNti(IBuilderTag tag) {
        NodeTagInformations nti = new NodeTagInformations();
        nti.setTagName(tag.getName());
        if (tag.getProperty(MSP) != null) {
            nti.addProperty(MSP, tag.getProperty(MSP));
        }
        if (tag.getProperty(LEVEL) != null) {
            nti.addProperty(LEVEL, tag.getProperty(LEVEL));
        }
        if ("true".equals(tag.getProperty("functionOverridedBySpecific"))) {
            nti.addProperty("functionOverridedBySpecific", "true");
        }
        return nti;
    }

    private IBuilderTag getParent(IBuilderTag tag) {
        IBuilderTag parent = tag.getParent();
        if (!this.isNotSpecificTag(parent)) {
            parent = this.getParent(parent);
        }
        return parent;
    }

    private boolean isNotSpecificTag(IBuilderTag tag) {
        return tag.getProperty("specificSubFunction") == null || this.getSpecialFunctionsDependingOnPattern().contains(tag.getName());
    }

    private String searchTextBeforeFrom(IBuilderTag tag) {
        if (tag.getTextBefore().length() != 0) {
            return tag.getTextBefore().toString();
        }
        IBuilderTag currentTag = tag.previousTag();
        while (currentTag != null && !this.isNotSpecificTag(currentTag) && currentTag.getLength() == 0) {
            if (currentTag.getTextBefore().length() != 0) {
                return currentTag.getTextBefore().toString();
            }
            currentTag = currentTag.previousTag();
        }
        return null;
    }

    private String searchTextAfterFrom(IBuilderTag tag) {
        if (tag.getTextAfter().length() != 0) {
            return tag.getTextAfter().toString();
        }
        IBuilderTag currentTag = tag.nextTag();
        while (currentTag != null && !this.isNotSpecificTag(currentTag) && currentTag.getLength() == 0) {
            if (currentTag.getTextAfter().length() != 0) {
                return currentTag.getTextAfter().toString();
            }
            currentTag = currentTag.nextTag();
        }
        return null;
    }

    private void updatePositionInformations(NodeTagInformations nti, IBuilderTag tag) {
        IBuilderTag parent = this.getParent(tag);
        if (parent == null) {
            return;
        }
        nti.setNodeTagEnclosing(parent.getName());
        String tagNameToSearch = null;
        IBuilderTag firstTag = tag;
        IBuilderTag lastTagFound = null;
        String tagNameBefore = null;
        boolean firstSearch = true;
        while (tagNameToSearch == null && tag != parent) {
            if (!firstSearch) {
                tagNameToSearch = this.searchMPfrom(tag.getName(), true);
            }
            if (tagNameToSearch == null) {
                tagNameToSearch = this.searchPreviousFirstNotSpecificTagNameAtSameLevel(tag.previousTag());
            }
            lastTagFound = tag;
            tag = tag.getParent();
            firstSearch = false;
        }
        if (tagNameToSearch != null) {
            nti.setNodeTagBefore(tagNameToSearch);
            tagNameBefore = tagNameToSearch;
            tagNameToSearch = null;
        } else if (lastTagFound != null) {
            String textBefore = this.searchTextBeforeFrom(lastTagFound);
            nti.setTextBefore(textBefore);
            lastTagFound = null;
        }
        tag = firstTag;
        while (tagNameToSearch == null && tag != parent) {
            tagNameToSearch = this.searchNextFirstNotSpecificTagNameAtSameLevel(tag.nextTag());
            lastTagFound = tag;
            tag = tag.getParent();
        }
        if (tagNameToSearch != null && !tagNameToSearch.equals(tagNameBefore)) {
            nti.setNodeTagAfter(tagNameToSearch);
            tagNameToSearch = null;
        } else if (lastTagFound != null) {
            int index;
            String textAfter = this.searchTextAfterFrom(lastTagFound);
            if (textAfter != null && (index = textAfter.lastIndexOf("EXIT.")) != -1 && textAfter.substring(index + 5).trim().length() == 0) {
                StringBuilder result = new StringBuilder(textAfter.substring(0, index));
                textAfter = result.toString();
            }
            nti.setTextAfter(textAfter);
        }
    }

    private String searchMPfrom(String subFunctionName, boolean isPreviousToFind) {
        String mpTagForReference = null;
        List<String> mps = this.allMPsInSubFunction.get(subFunctionName);
        if (isPreviousToFind) {
            if (mps != null && !mps.isEmpty()) {
                mpTagForReference = mps.get(mps.size() - 1);
            }
        } else if (mps != null && !mps.isEmpty()) {
            mpTagForReference = mps.get(0);
        }
        return mpTagForReference;
    }

    private String searchPreviousFirstNotSpecificTagName(IBuilderTag from) {
        IBuilderTag originalTag = from;
        if (from == null) {
            return null;
        }
        if (this.isNotSpecificTag(from)) {
            return from.getName();
        }
        String result = null;
        if (from.hasSon()) {
            from = from.lastSon();
            while (result == null && from != null) {
                result = this.searchPreviousFirstNotSpecificTagName(from);
                from = from.previousTag();
            }
        }
        if (result == null) {
            result = this.searchMPfrom(originalTag.getName(), true);
        }
        return result;
    }

    private String searchNextFirstNotSpecificTagName(IBuilderTag from) {
        if (from == null) {
            return null;
        }
        if (this.isNotSpecificTag(from)) {
            return from.getName();
        }
        String result = this.searchMPfrom(from.getName(), false);
        if (result != null) {
            return result;
        }
        if (from.hasSon()) {
            from = from.firstSon();
            while (result == null && from != null) {
                result = this.searchNextFirstNotSpecificTagName(from);
                from = from.nextTag();
            }
            return result;
        }
        return null;
    }

    private String searchPreviousFirstNotSpecificTagNameAtSameLevel(IBuilderTag from) {
        while (from != null) {
            String result = this.searchPreviousFirstNotSpecificTagName(from);
            if (result != null) {
                return result;
            }
            from = from.previousTag();
        }
        return null;
    }

    private String searchNextFirstNotSpecificTagNameAtSameLevel(IBuilderTag from) {
        while (from != null) {
            String result = this.searchNextFirstNotSpecificTagName(from);
            if (result != null) {
                return result;
            }
            from = from.nextTag();
        }
        return null;
    }

    private static void CopyProperties(IBuilderTag sourceTag, IBuilderTag targetTag) {
        Iterator itp = sourceTag.propertyNames();
        while (itp.hasNext()) {
            String propName = (String)itp.next();
            targetTag.setProperty(propName, sourceTag.getProperty(propName));
        }
    }

    public void setAllFunctionsFromSPmacro(List<IVirtualFunction> allFunctionsFromSP) {
        this.allFunctionsFromSPmacro.clear();
        for (IVirtualFunction pdpFunction : allFunctionsFromSP) {
            this.allFunctionsFromSPmacro.add(pdpFunction.getCobolName());
        }
    }
}

