/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.extension.organize;

import com.ibm.pdp.engine.IGeneratedInfo;
import com.ibm.pdp.engine.IGeneratedInfoFactory;
import com.ibm.pdp.engine.IGeneratedTag;
import com.ibm.pdp.engine.tree.IEditTree;
import com.ibm.pdp.engine.tree.ITextNode;
import com.ibm.pdp.engine.turbo.core.BeginTagAtIndexIntoTag;
import com.ibm.pdp.engine.turbo.core.CloseTag;
import com.ibm.pdp.engine.turbo.core.EndTagAtIndexIntoTag;
import com.ibm.pdp.engine.turbo.core.GeneratedChangePosition;
import com.ibm.pdp.engine.turbo.core.GeneratedInfoChange;
import com.ibm.pdp.engine.turbo.core.GeneratedInfoTransformer;
import com.ibm.pdp.engine.turbo.core.InsertDash900AfterTagClose;
import com.ibm.pdp.engine.turbo.core.InsertDash900BeforeTagOpen;
import com.ibm.pdp.engine.turbo.core.InsertTextAndCloseTagAfterTagClose;
import com.ibm.pdp.engine.turbo.core.InsertTextAndCloseTagBeforeTagOpen;
import com.ibm.pdp.engine.turbo.core.OpenTag;
import com.ibm.pdp.engine.turbo.core.RemoveSolidTextInterval;
import com.ibm.pdp.engine.turbo.core.SkipTag;
import com.ibm.pdp.engine.turbo.core.SkipTagClose;
import com.ibm.pdp.engine.turbo.impl.GenInfoFactory;
import com.ibm.pdp.pacbase.PacTool;
import com.ibm.pdp.pacbase.extension.organize.DefaultFunction;
import com.ibm.pdp.pacbase.extension.organize.DefaultTreeHandler;
import com.ibm.pdp.pacbase.extension.organize.DialogTreeHandler;
import com.ibm.pdp.pacbase.extension.organize.Function;
import com.ibm.pdp.pacbase.extension.organize.GeneratedFunctionsCursor;
import com.ibm.pdp.pacbase.extension.organize.GeneratedFunctionsCursorForBatch;
import com.ibm.pdp.pacbase.extension.organize.GeneratedFunctionsCursorForDialog;
import com.ibm.pdp.pacbase.extension.organize.GeneratedFunctionsCursorForServer;
import com.ibm.pdp.pacbase.extension.organize.IFunction;
import com.ibm.pdp.pacbase.extension.organize.ITreeHandler;
import com.ibm.pdp.pacbase.extension.organize.InfoFunctionChanges;
import com.ibm.pdp.pacbase.extension.organize.Location;
import com.ibm.pdp.pacbase.extension.organize.Messages;
import com.ibm.pdp.pacbase.extension.organize.MutableFunction;
import com.ibm.pdp.pacbase.extension.organize.PdpFunction;
import com.ibm.pdp.pacbase.extension.organize.ServerTreeHandler;
import com.ibm.pdp.pacbase.extension.organize.SpecificFunction;
import com.ibm.pdp.util.Strings;
import com.ibm.pdp.util.strings.search.SearchCursor;
import com.ibm.pdp.util.strings.search.SubSequenceFinder;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FunctionsConsistencyAnalyzer {
    protected IEditTree editTree;
    protected Map<String, Integer> functionLevelChanges;
    protected Set<String> deletedFunctions;
    protected List<IFunction> insertedFunctions;
    private List<IFunction> finalTree = new ArrayList<IFunction>();
    private boolean _isMVdone = false;
    private boolean _isMVinProgress = false;
    public static String rootTagName;
    public static int functionsTraceLevel;
    public static boolean isValidation;
    public static final boolean CREATE_SPECIFIC = false;
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2014, 2023.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    static {
        functionsTraceLevel = 0;
        isValidation = false;
        String traceLevel = System.getProperty("pac.functions.trace.level");
        if (traceLevel != null) {
            try {
                functionsTraceLevel = Integer.parseInt(traceLevel);
            }
            catch (Throwable throwable) {}
        }
    }

    public FunctionsConsistencyAnalyzer(IEditTree editTree, boolean isMVdone, boolean isMVinProgress) {
        this.editTree = editTree;
        this._isMVdone = isMVdone;
        this._isMVinProgress = isMVinProgress;
    }

    public IGeneratedInfo refactorGeneratedInfo() {
        if (this.functionLevelChanges == null) {
            this.functionLevelChanges = new HashMap<String, Integer>();
        } else {
            this.functionLevelChanges.clear();
        }
        if (this.deletedFunctions == null) {
            this.deletedFunctions = new HashSet<String>();
        } else {
            this.deletedFunctions.clear();
        }
        IGeneratedInfo generatedInfo = this.editTree.getTextProcessor().getGeneratedInfo();
        rootTagName = generatedInfo.getRootTag().getName();
        ArrayList<Function> functions = new ArrayList<Function>();
        this.findGeneratedFunctions(generatedInfo, functions, new HashMap<String, Function>());
        if (functions.isEmpty()) {
            return null;
        }
        boolean error = this.findFnModifications(functions);
        if (error) {
            return null;
        }
        if (!this.validateModifications(functions)) {
            return null;
        }
        this.storeDeletedFunctionsAndLevelChanges(functions);
        this.setModifiedTreefromFunction(functions);
        if (this.unchangedOrder(functions)) {
            return null;
        }
        IGeneratedInfo newGenInfo = this.buildRefactoredGeneratedInfo(functions);
        return newGenInfo;
    }

    protected ITreeHandler newTreeHandler(IGeneratedInfo genInfo) {
        String patternName = genInfo.getProperty("pattern");
        if (patternName == null) {
            return new DefaultTreeHandler();
        }
        if ("com.ibm.pdp.pacbase.dialog".equals(patternName) || "com.ibm.pdp.pacbase.csclient".equals(patternName)) {
            return new DialogTreeHandler();
        }
        if ("com.ibm.pdp.pacbase.csserver".equals(patternName)) {
            return new ServerTreeHandler(genInfo);
        }
        return new DefaultTreeHandler();
    }

    public IGeneratedInfo moveDeletedSubFunctions() {
        IGeneratedInfo generatedInfo = this.editTree.getTextProcessor().getGeneratedInfo();
        rootTagName = generatedInfo.getRootTag().getName();
        ArrayList<Function> initialTree = new ArrayList<Function>();
        HashMap<String, Function> functionsFromTagName = new HashMap<String, Function>();
        this.findGeneratedFunctions(generatedInfo, initialTree, functionsFromTagName);
        this.collectInsertedFunctions(initialTree, functionsFromTagName);
        if (initialTree.isEmpty() || this.deletedFunctions.isEmpty() || this.insertedFunctions.isEmpty()) {
            return null;
        }
        ArrayList<IFunction> modifiedTree = new ArrayList<IFunction>();
        this.copyTree(initialTree, modifiedTree);
        ITreeHandler handler = this.newTreeHandler(generatedInfo);
        for (Map.Entry<String, Integer> levelChange : this.functionLevelChanges.entrySet()) {
            handler.changeLevel(levelChange.getKey(), levelChange.getValue(), modifiedTree);
        }
        for (IFunction function : this.insertedFunctions) {
            String tagName = function.getTagName();
            if (functionsFromTagName.containsKey(tagName)) continue;
            SpecificFunction insertedFunction = new SpecificFunction(tagName, tagName, (int)function.getLevel(), 0, function.getLocation(), function.getReference());
            handler.addFunction(insertedFunction, modifiedTree);
        }
        int f = 0;
        while (f < modifiedTree.size()) {
            Function initialFunction;
            int level;
            IFunction function = modifiedTree.get(f);
            if (function instanceof MutableFunction && (level = (int)(initialFunction = ((MutableFunction)function).getFunction()).getLevel()) != -1 && !initialFunction.isFunction() && this.deletedFunctions.contains(initialFunction.getTagName())) {
                int beginDeleteIdx = f;
                int endDeleteIdx = f + 1;
                while (endDeleteIdx < modifiedTree.size()) {
                    function = modifiedTree.get(endDeleteIdx);
                    if (!(function instanceof MutableFunction) || (level = (int)(initialFunction = ((MutableFunction)function).getFunction()).getLevel()) == -1 || initialFunction.isFunction() || !this.deletedFunctions.contains(initialFunction.getTagName())) break;
                    ++endDeleteIdx;
                }
                this.adjustLevelForDeletedFunctions(modifiedTree, beginDeleteIdx, endDeleteIdx, handler);
                f = endDeleteIdx - 1;
            }
            ++f;
        }
        IGeneratedInfo mergedGeneratedInfo = this.buildCorrectGeneratedInfo(generatedInfo, initialTree, modifiedTree);
        this.setModifiedTree(modifiedTree);
        return mergedGeneratedInfo;
    }

    protected void collectInsertedFunctions(List<Function> tree, Map<String, Function> functionsFromTagName) {
        if (this.insertedFunctions == null) {
            this.insertedFunctions = new ArrayList<IFunction>();
        } else {
            this.insertedFunctions.clear();
        }
        Iterator itn = this.editTree.rootNodes();
        while (itn.hasNext()) {
            this.collectInsertedFunctionsFromTextNode((ITextNode)itn.next());
        }
    }

    protected void collectInsertedFunctionsFromTextNode(ITextNode node) {
        int level = this.toInt(node.getProperties().getProperty("level"));
        if (node.isSyntacticTag() && level != -1) {
            String tagName = node.getLabel().toString();
            String ref = node.getProperties().getProperty("TagName");
            Location location = null;
            if (ref != null && ref.length() > 0) {
                location = this.getLocation(node.getProperties().getProperty("TagPosition"));
            }
            this.insertedFunctions.add(new SpecificFunction(tagName, tagName, level, 0, location, ref));
        }
        Iterator itn = node.sons();
        while (itn.hasNext()) {
            this.collectInsertedFunctionsFromTextNode((ITextNode)itn.next());
        }
    }

    private Location getLocation(String location) {
        Location[] locationArray = Location.values();
        int n = locationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Location value = locationArray[n2];
            if (location.equals(value.getInsertName())) {
                return value;
            }
            ++n2;
        }
        return null;
    }

    public List<IFunction> getModifiedTree() {
        return this.finalTree;
    }

    private void setModifiedTree(List<IFunction> tree) {
        this.finalTree = tree;
    }

    private void setModifiedTreefromFunction(List<Function> tree) {
        ArrayList<IFunction> functions = new ArrayList<IFunction>();
        functions.addAll(tree);
        this.setModifiedTree(functions);
    }

    protected IGeneratedInfo buildCorrectGeneratedInfo(IGeneratedInfo genInfo, List<Function> initialTree, List<IFunction> modifiedTree) {
        List<GeneratedInfoChange> changes = this.buildCorrectChangesFromTreeChanges(initialTree, modifiedTree);
        if (changes.isEmpty()) {
            return null;
        }
        GeneratedInfoTransformer transformer = new GeneratedInfoTransformer((IGeneratedInfoFactory)new GenInfoFactory(), changes.iterator());
        return transformer.convert(genInfo);
    }

    protected void storeDeletedFunctionsAndLevelChanges(List<Function> functions) {
        for (Function function : functions) {
            int initialLevel;
            if (function.isDeleted()) {
                this.deletedFunctions.add(function.getTagName());
                continue;
            }
            int specificLevel = function.getSpecificLevel();
            if (specificLevel == -1 || specificLevel == (initialLevel = (int)function.getLevel())) continue;
            this.functionLevelChanges.put(function.getTagName(), specificLevel);
        }
    }

    protected boolean checkCursors(IGeneratedInfo genInfo) {
        ArrayList<Function> functions = new ArrayList<Function>();
        HashMap<String, Function> functionsFromName = new HashMap<String, Function>();
        this.findGeneratedFunctions(genInfo, functions, functionsFromName);
        OpenCloseCursor<Function> openCloseCursor = new OpenCloseCursor<Function>(functions);
        BeginEndCursor beginEndCursor = new BeginEndCursor(functions.iterator());
        while (openCloseCursor.searchNext()) {
            System.out.print(openCloseCursor.function().getTagName());
            if (openCloseCursor.isEnd()) {
                System.out.print("-FN");
            }
            System.out.println();
            if (!beginEndCursor.searchNext()) {
                return false;
            }
            if (openCloseCursor.isBegin() != beginEndCursor.isBegin()) {
                return false;
            }
            if (openCloseCursor.function() == beginEndCursor.function()) continue;
            return false;
        }
        if (beginEndCursor.searchNext()) {
            return false;
        }
        this.findFnModifications(functions);
        ModifiedBeginEndCursorKeepDeleted modifiedCursor = new ModifiedBeginEndCursorKeepDeleted(functions.iterator());
        while (modifiedCursor.searchNext()) {
            System.out.print(modifiedCursor.function().getTagName());
            if (modifiedCursor.isEnd()) {
                System.out.print("-FN");
            }
            if (modifiedCursor.function().isDeleted()) {
                System.out.print(" X");
            }
            System.out.println();
        }
        return true;
    }

    protected boolean findFnModifications(List<Function> generatedFunctions) {
        if (generatedFunctions.isEmpty()) {
            return false;
        }
        HashMap<String, Function> segmentSubFunctionsFromEndMark = new HashMap<String, Function>();
        for (Function function : generatedFunctions) {
            if (!function.isSegmentSubFunction() || function.getFirstLineBeginIndex() != -1) continue;
            segmentSubFunctionsFromEndMark.put(function.endMark(), function);
        }
        CharSequence text = this.editTree.getTextProcessor().getText();
        SubSequenceFinder finder = Strings.newSubSequenceFinder();
        IGeneratedTag ancestorTag = null;
        int f = 0;
        while (f < generatedFunctions.size()) {
            Function function = generatedFunctions.get(f);
            IGeneratedTag tag = function.getTag();
            ancestorTag = ancestorTag == null ? tag : this.commonAncestor(ancestorTag, tag);
            Iterator<String> marks = function.marks();
            while (marks.hasNext()) {
                String mark = marks.next();
                finder.addSubSequenceToFind((CharSequence)mark, (Object)function);
            }
            ++f;
        }
        CharSequence textToSearch = text;
        int ancestorStartIndex = 0;
        if (ancestorTag != null && ancestorTag != this.editTree.getTextProcessor().getGeneratedInfo().getRootTag()) {
            ancestorStartIndex = this.editTree.nodeFromTagName(ancestorTag.getName()).beginIndex();
            textToSearch = textToSearch.subSequence(ancestorStartIndex, text.length());
        }
        boolean error = false;
        SearchCursor cursor = finder.newSearchCursor(textToSearch);
        while (cursor.search()) {
            if (!this.isRightFnMatching((SearchCursor<Function>)cursor, segmentSubFunctionsFromEndMark) || ((Function)cursor.getValue()).handleMark((SearchCursor<Function>)cursor)) continue;
            error = true;
        }
        this.fixFnModifications(generatedFunctions);
        return error;
    }

    protected boolean isRightFnMatching(SearchCursor<Function> cursor, Map<String, Function> segmentSubFunctionsFromEndMark) {
        int beginIndex;
        CharSequence text = cursor.getSequenceToScan();
        String key = text.subSequence((beginIndex = cursor.getSubSequenceBeginIndex()) + 1, cursor.getSubSequenceEndIndex()).toString();
        Function segmentFunction = segmentSubFunctionsFromEndMark.get(key);
        if (segmentFunction == null) {
            return true;
        }
        if (cursor.getValue() == segmentFunction) {
            return !this.hasOpeningTagBefore(key, text, beginIndex);
        }
        return this.hasOpeningTagBefore(key, text, beginIndex);
    }

    protected boolean hasOpeningTagBefore(String endTag, CharSequence text, int index) {
        String beginTag = endTag.substring(0, endTag.length() - 4);
        index = FunctionsConsistencyAnalyzer.jumpToBeginingOfPreviousLine(text, index);
        while (index != -1) {
            int column = 1;
            int i = 0;
            while (i < text.length()) {
                if (text.charAt(index + i) != ' ') {
                    column += i;
                    break;
                }
                ++i;
            }
            if (column >= 8 && column <= 11) {
                int startIdx = index + column - 1;
                if (Strings.sameSubSequences((CharSequence)text, (int)startIdx, (CharSequence)"F80.", (int)0, (int)4)) {
                    return false;
                }
                if (Strings.sameSubSequences((CharSequence)text, (int)startIdx, (CharSequence)beginTag, (int)0, (int)beginTag.length())) {
                    if (text.charAt(startIdx + beginTag.length()) == '.') {
                        return true;
                    }
                    if (Strings.sameSubSequences((CharSequence)text, (int)(startIdx + beginTag.length()), (CharSequence)"-FN.", (int)0, (int)4)) {
                        return false;
                    }
                }
            }
            index = FunctionsConsistencyAnalyzer.jumpToBeginingOfPreviousLine(text, index);
        }
        return false;
    }

    protected static int jumpToBeginingOfPreviousLine(CharSequence text, int index) {
        index = FunctionsConsistencyAnalyzer.previousEol(text, index);
        if ((index = FunctionsConsistencyAnalyzer.previousNotEol(text, index)) < 0) {
            return -1;
        }
        return 1 + FunctionsConsistencyAnalyzer.previousEol(text, index);
    }

    protected static int previousEol(CharSequence text, int index) {
        while (index >= 0 && !FunctionsConsistencyAnalyzer.isEol(text.charAt(index))) {
            --index;
        }
        return index;
    }

    protected static int previousNotEol(CharSequence text, int index) {
        while (index >= 0 && FunctionsConsistencyAnalyzer.isEol(text.charAt(index))) {
            --index;
        }
        return index;
    }

    protected static boolean isEol(char c) {
        return c == '\n' || c == '\r';
    }

    protected void fixFnModifications(List<Function> functions) {
        ArrayList<Integer> erroneousSegmentSubFunctions = new ArrayList<Integer>();
        int f = 0;
        while (f < functions.size()) {
            Function function = functions.get(f);
            int modifiedBeginIdx = function.getModifiedBeginIndex();
            int modifiedEndIdx = function.getModifiedEndIndex();
            if (modifiedBeginIdx == -1) {
                if (modifiedEndIdx == -1) {
                    if (function.isSegmentSubFunction()) {
                        erroneousSegmentSubFunctions.add(f);
                    }
                } else if (function.isFunction()) {
                    function.setModifiedBeginIndex(this.findIndexBeforeAllSubFunctions(functions, f));
                } else if (function.isSegmentSubFunction()) {
                    erroneousSegmentSubFunctions.add(f);
                } else {
                    function.setModifiedBeginIndex(modifiedEndIdx - 1);
                }
            } else if (modifiedEndIdx == -1) {
                if (function.isFunction()) {
                    function.setModifiedEndIndex(this.findIndexAfterAllSubFunctions(functions, f));
                } else {
                    function.setModifiedEndIndex(modifiedBeginIdx + 1);
                }
            }
            ++f;
        }
        Iterator iterator = erroneousSegmentSubFunctions.iterator();
        while (iterator.hasNext()) {
            int subFunctionBeginIdx;
            int sf;
            int newModifiedBeginIdx;
            f = (Integer)iterator.next();
            Function function = functions.get(f);
            int max = Math.min(f + 1 + function.getNbOfDependents(), functions.size());
            if (function.getModifiedEndIndex() != -1) {
                newModifiedBeginIdx = function.getModifiedEndIndex() - 1;
                sf = f + 1;
                while (sf < max) {
                    subFunctionBeginIdx = functions.get(sf).getModifiedBeginIndex();
                    if (subFunctionBeginIdx != -1) {
                        newModifiedBeginIdx = subFunctionBeginIdx - 1;
                        break;
                    }
                    ++sf;
                }
                function.setModifiedBeginIndex(newModifiedBeginIdx);
                continue;
            }
            newModifiedBeginIdx = function.getModifiedBeginIndex();
            sf = f + 1;
            while (sf < max) {
                subFunctionBeginIdx = functions.get(sf).getModifiedBeginIndex();
                if (subFunctionBeginIdx != -1) {
                    newModifiedBeginIdx = subFunctionBeginIdx - 1;
                    break;
                }
                ++sf;
            }
            function.setModifiedBeginIndex(newModifiedBeginIdx);
            int end = this.findIndexAfterAllSubFunctions(functions, f);
            function.setModifiedEndIndex(end != 0 ? end : -1);
        }
    }

    protected int findIndexBeforeAllSubFunctions(List<Function> functions, int rank) {
        Function function = functions.get(rank);
        int max = rank + function.getNbOfDependents();
        int minIndex = Integer.MAX_VALUE;
        int f = rank + 1;
        while (f <= max) {
            Function next = functions.get(f);
            int index = next.getModifiedBeginIndex();
            if (index != -1 && index < minIndex) {
                minIndex = index;
            }
            if ((index = next.getModifiedEndIndex()) != -1 && index < minIndex) {
                minIndex = index;
            }
            ++f;
        }
        if (minIndex != Integer.MAX_VALUE) {
            return minIndex - 1;
        }
        return function.getModifiedEndIndex() - 1;
    }

    protected int findIndexAfterAllSubFunctions(List<Function> functions, int rank) {
        Function function = functions.get(rank);
        int max = rank + function.getNbOfDependents();
        int maxIndex = Integer.MIN_VALUE;
        int f = rank + 1;
        while (f <= max) {
            Function subFunction = functions.get(f);
            int index = subFunction.getModifiedBeginIndex();
            if (index != -1 && index > maxIndex) {
                maxIndex = index;
            }
            if ((index = subFunction.getModifiedEndIndex()) != -1 && index > maxIndex) {
                maxIndex = index;
            }
            ++f;
        }
        if (maxIndex != Integer.MIN_VALUE) {
            return maxIndex + 1;
        }
        return function.getModifiedBeginIndex() + 1;
    }

    /*
     * Unable to fully structure code
     */
    protected boolean validateModifications(List<Function> functions) {
        previousmodifiedBeginIdx = 0;
        opened = new ArrayDeque<Function>();
        for (Function function : functions) {
            modifiedBeginIdx = function.getModifiedBeginIndex();
            modifiedEndIdx = function.getModifiedEndIndex();
            if (modifiedBeginIdx == -1 || modifiedEndIdx == -1) {
                if (modifiedBeginIdx == -1 && modifiedEndIdx == -1) continue;
                return FunctionsConsistencyAnalyzer.trace(function.getTagName(), Messages.WRONG_UPDATE);
            }
            if (modifiedBeginIdx >= modifiedEndIdx) {
                return FunctionsConsistencyAnalyzer.trace(function.getTagName(), Messages.ENDTAG_BEFORE_BEGINTAG);
            }
            if (modifiedBeginIdx >= previousmodifiedBeginIdx) ** GOTO lbl15
            return FunctionsConsistencyAnalyzer.trace(function.getTagName(), Messages.WRONG_ORDER);
lbl-1000:
            // 1 sources

            {
                opened.pop();
lbl15:
                // 2 sources

                ** while (!opened.isEmpty() && ((Function)opened.peek()).getModifiedEndIndex() <= modifiedBeginIdx)
            }
lbl16:
            // 1 sources

            if (!opened.isEmpty() && ((Function)opened.peek()).getModifiedEndIndex() < modifiedEndIdx) {
                return FunctionsConsistencyAnalyzer.trace(function.getTagName(), Messages.WRONG_NESTING);
            }
            previousmodifiedBeginIdx = modifiedBeginIdx;
            opened.push(function);
        }
        return true;
    }

    public static boolean trace(String functionName, String message) {
        switch (functionsTraceLevel) {
            case 2: {
                String fullMessage = FunctionsConsistencyAnalyzer.message(functionName, message);
                System.err.println(fullMessage);
                throw new RuntimeException(String.valueOf(functionName) + " : " + message);
            }
            case 1: {
                System.err.println(FunctionsConsistencyAnalyzer.message(functionName, message));
            }
        }
        return false;
    }

    public static String message(String functionName, String message) {
        return "Entity=" + rootTagName + " Function=" + functionName + " : " + message;
    }

    protected IGeneratedInfo buildRefactoredGeneratedInfo(List<Function> functions) {
        List<GeneratedInfoChange> changes = null;
        if (this._isMVdone && PacTool.isCobolValidated(this.editTree.getTextProcessor().getGeneratedInfo())) {
            return null;
        }
        changes = this._isMVinProgress || this._isMVdone ? this.buildGeneratedInfoChangesForVirtualMacro(functions) : this.buildGeneratedInfoChanges(functions);
        if (changes.isEmpty()) {
            return null;
        }
        GeneratedInfoTransformer transformer = new GeneratedInfoTransformer((IGeneratedInfoFactory)new GenInfoFactory(), changes.iterator());
        return transformer.convert(this.editTree.getTextProcessor().getGeneratedInfo());
    }

    protected List<GeneratedInfoChange> buildGeneratedInfoChanges(List<Function> functions) {
        ArrayList<GeneratedInfoChange> changes = new ArrayList<GeneratedInfoChange>();
        OpenCloseCursorWindow generated = new OpenCloseCursorWindow(new OpenCloseCursor<Function>(functions));
        ModifiedBeginEndCursorKeepDeleted modified = new ModifiedBeginEndCursorKeepDeleted(functions.iterator());
        ((BeginEndCursor)modified).searchNext();
        while (generated.hasCurrent()) {
            Function function = generated.function();
            String functionName = generated.function().getTagName();
            if (modified.found()) {
                Function modifiedFunction = modified.function();
                if (modified.isBegin() != generated.isBegin()) {
                    if (generated.isBegin()) {
                        if (generated.hasPrevious() && generated.previousIsEnd()) {
                            this.addFnInsertionAfter(changes, modifiedFunction, generated.previousFunction().getTagName());
                        } else {
                            this.addFnInsertionBefore(changes, modifiedFunction, functionName);
                        }
                        ((BeginEndCursor)modified).searchNext();
                        continue;
                    }
                    this.addFnDeletion(changes, function);
                    generated.searchNext();
                    continue;
                }
                if (generated.isEnd() && function != modifiedFunction) {
                    this.addFnDeletion(changes, function);
                    generated.searchNext();
                    continue;
                }
                generated.searchNext();
                ((BeginEndCursor)modified).searchNext();
                continue;
            }
            this.addFnDeletion(changes, function);
            generated.searchNext();
        }
        if (generated.hasPrevious()) {
            String previousFunctionName = generated.previousFunction().getTagName();
            while (modified.found()) {
                this.addFnInsertionAfter(changes, modified.function(), previousFunctionName);
                ((BeginEndCursor)modified).searchNext();
            }
        }
        return changes;
    }

    protected List<GeneratedInfoChange> buildGeneratedInfoChangesForVirtualMacro(List<Function> functions) {
        ArrayList<GeneratedInfoChange> changes = new ArrayList<GeneratedInfoChange>();
        OpenCloseCursorWindow generated = new OpenCloseCursorWindow(new OpenCloseCursor<Function>(functions));
        ModifiedBeginEndCursor modified = new ModifiedBeginEndCursor(functions.iterator());
        modified.searchNext();
        while (generated.hasCurrent()) {
            Function function = generated.function();
            String functionName = generated.function().getTagName();
            if (this.deletedFunctions.contains(functionName)) {
                generated.searchNext();
                continue;
            }
            if (modified.found()) {
                Function modifiedFunction = modified.function();
                if (modified.isBegin() != generated.isBegin()) {
                    if (generated.isBegin()) {
                        if (generated.hasPrevious() && generated.previousIsEnd()) {
                            this.addFnInsertionAfter(changes, modifiedFunction, generated.previousFunction().getTagName());
                        } else {
                            this.addFnInsertionBefore(changes, modifiedFunction, functionName);
                        }
                        modified.searchNext();
                        continue;
                    }
                    this.addFnDeletion(changes, function);
                    generated.searchNext();
                    continue;
                }
                if (generated.isEnd() && function != modifiedFunction) {
                    this.addFnDeletion(changes, function);
                    generated.searchNext();
                    continue;
                }
                generated.searchNext();
                modified.searchNext();
                continue;
            }
            this.addFnDeletion(changes, function);
            generated.searchNext();
        }
        if (generated.hasPrevious()) {
            String previousFunctionName = generated.previousFunction().getTagName();
            while (modified.found()) {
                this.addFnInsertionAfter(changes, modified.function(), previousFunctionName);
                modified.searchNext();
            }
        }
        return changes;
    }

    protected List<GeneratedInfoChange> buildCorrectChangesFromTreeChanges(List<Function> initialTree, List<IFunction> modifiedTree) {
        ArrayList<GeneratedInfoChange> changes = new ArrayList<GeneratedInfoChange>();
        OpenCloseCursorWindow generated = new OpenCloseCursorWindow(new OpenCloseCursor<Function>(initialTree));
        OpenCloseCursorSkipSpecific<IFunction> modified = new OpenCloseCursorSkipSpecific<IFunction>(modifiedTree);
        ((OpenCloseCursor)modified).searchNext();
        while (generated.hasCurrent()) {
            Function function = generated.function();
            String functionName = generated.function().getTagName();
            if (modified.found()) {
                Function modifiedFunction = ((MutableFunction)modified.function()).getFunction();
                if (modified.isBegin() != generated.isBegin()) {
                    if (generated.isBegin()) {
                        if (generated.hasPrevious() && generated.previousIsEnd()) {
                            this.addFnInsertionAfter(changes, modifiedFunction, generated.previousFunction().getTagName());
                        } else {
                            this.addFnInsertionBefore(changes, modifiedFunction, functionName);
                        }
                        ((OpenCloseCursor)modified).searchNext();
                        continue;
                    }
                    this.addFnDeletion(changes, function);
                    generated.searchNext();
                    continue;
                }
                if (generated.isEnd() && function != modifiedFunction) {
                    this.addFnDeletion(changes, function);
                    generated.searchNext();
                    continue;
                }
                generated.searchNext();
                ((OpenCloseCursor)modified).searchNext();
                continue;
            }
            this.addFnDeletion(changes, function);
            generated.searchNext();
        }
        if (generated.hasPrevious()) {
            String previousFunctionName = generated.previousFunction().getTagName();
            while (modified.found()) {
                Function modifiedFunction = ((MutableFunction)modified.function()).getFunction();
                this.addFnInsertionAfter(changes, modifiedFunction, previousFunctionName);
                ((OpenCloseCursor)modified).searchNext();
            }
        }
        return changes;
    }

    protected static boolean isValidCobolTagColumn(CharSequence text, int beginIdx, int endIdx) {
        int column = FunctionsConsistencyAnalyzer.computeColumn(beginIdx, text);
        if (column < 8 || column > 11) {
            return false;
        }
        int idx = beginIdx;
        while (--idx >= 0) {
            char c = text.charAt(idx);
            if (c == '\n' || c == '\r') {
                return true;
            }
            if (c == ' ') continue;
            return false;
        }
        return true;
    }

    protected static boolean isMiddleArea(int column) {
        return column > 7 && column < 73;
    }

    protected static boolean isFnTag(CharSequence text, int beginIdx, int endIdx) {
        if (endIdx - beginIdx < 8) {
            return false;
        }
        return text.charAt(endIdx - 4) == '-' && text.charAt(endIdx - 3) == 'F' && text.charAt(endIdx - 2) == 'N';
    }

    protected static int extractSpecificLevel(CharSequence text, int idx) {
        int column = FunctionsConsistencyAnalyzer.computeColumn(idx, text);
        int indexOfColumn73 = idx - column + 73;
        if (indexOfColumn73 + 4 > text.length()) {
            return -1;
        }
        char c1 = text.charAt(indexOfColumn73);
        if (c1 != 'l' && c1 != 'L') {
            return -1;
        }
        char c2 = text.charAt(indexOfColumn73 + 1);
        if (c2 != 'v' && c2 != 'V') {
            return -1;
        }
        c1 = text.charAt(indexOfColumn73 + 2);
        if (c1 < '0' || c1 > '9') {
            return -1;
        }
        c2 = text.charAt(indexOfColumn73 + 3);
        if (c2 < '0' || c2 > '9') {
            return -1;
        }
        return 10 * (c1 - 48) + c2 - 48;
    }

    protected Set<String> deletedFunctionNames(List<Function> actualFunctions) {
        HashSet<String> deletedFunctions = new HashSet<String>();
        for (Function function : actualFunctions) {
            if (function.getFirstLineBeginIndex() != -1) continue;
            deletedFunctions.add(function.getCobolName());
        }
        return deletedFunctions;
    }

    protected boolean unchangedOrder(List<Function> functions) {
        OpenCloseCursor<Function> generated = new OpenCloseCursor<Function>(functions);
        ModifiedBeginEndCursorKeepDeleted modified = new ModifiedBeginEndCursorKeepDeleted(functions.iterator());
        while (generated.searchNext()) {
            if (((BeginEndCursor)modified).searchNext() && generated.isBegin() == modified.isBegin() && generated.function() == modified.function()) continue;
            return false;
        }
        return !((BeginEndCursor)modified).searchNext();
    }

    public IGeneratedInfo mergeSyntacticTagsWithGeneratedInfo(IGeneratedInfo newGeneratedInfo) {
        if (this.functionLevelChanges.isEmpty() && this.deletedFunctions.isEmpty() && this.insertedFunctions.isEmpty()) {
            return newGeneratedInfo;
        }
        rootTagName = newGeneratedInfo.getRootTag().getName();
        ArrayList<Function> initialTree = new ArrayList<Function>();
        HashMap<String, Function> functionsFromTagName = new HashMap<String, Function>();
        this.findGeneratedFunctions(newGeneratedInfo, initialTree, functionsFromTagName);
        if (!isValidation && initialTree.isEmpty()) {
            return newGeneratedInfo;
        }
        ArrayList<IFunction> modifiedTree = new ArrayList<IFunction>();
        this.copyTree(initialTree, modifiedTree);
        ITreeHandler handler = this.newTreeHandler(newGeneratedInfo);
        for (Map.Entry<String, Integer> levelChange : this.functionLevelChanges.entrySet()) {
            handler.changeLevel(levelChange.getKey(), levelChange.getValue(), modifiedTree);
        }
        for (IFunction function : this.insertedFunctions) {
            String tagName = function.getTagName();
            if (functionsFromTagName.containsKey(tagName)) continue;
            SpecificFunction insertedFunction = new SpecificFunction(tagName, tagName, (int)function.getLevel(), 0, function.getLocation(), function.getReference());
            handler.addFunction(insertedFunction, modifiedTree);
        }
        if (!this.deletedFunctions.isEmpty()) {
            int f = 0;
            while (f < modifiedTree.size()) {
                Function initialFunction;
                int level;
                IFunction function = modifiedTree.get(f);
                if (function instanceof MutableFunction && (level = (int)(initialFunction = ((MutableFunction)function).getFunction()).getLevel()) != -1 && !initialFunction.isFunction() && this.deletedFunctions.contains(initialFunction.getTagName())) {
                    int beginDeleteIdx = f;
                    int endDeleteIdx = f + 1;
                    while (endDeleteIdx < modifiedTree.size()) {
                        function = modifiedTree.get(endDeleteIdx);
                        if (!(function instanceof MutableFunction) || (level = (int)(initialFunction = ((MutableFunction)function).getFunction()).getLevel()) == -1 || initialFunction.isFunction() || !this.deletedFunctions.contains(initialFunction.getTagName())) break;
                        ++endDeleteIdx;
                    }
                    this.adjustLevelForDeletedFunctions(modifiedTree, beginDeleteIdx, endDeleteIdx, handler);
                    f = endDeleteIdx - 1;
                }
                ++f;
            }
        }
        IGeneratedInfo mergedGeneratedInfo = this.buildModifiedGeneratedInfo(newGeneratedInfo, initialTree, modifiedTree);
        this.setModifiedTree(modifiedTree);
        return mergedGeneratedInfo;
    }

    protected boolean adjustLevelForDeletedFunctions(List<IFunction> tree, int beginDeletionIndex, int endDeletionIndex, ITreeHandler treeHandler) {
        float previousLevel = 0.0f;
        if (beginDeletionIndex > 0) {
            previousLevel = tree.get(beginDeletionIndex - 1).getLevel();
        }
        float nextLevel = previousLevel;
        if (endDeletionIndex < tree.size()) {
            nextLevel = tree.get(endDeletionIndex).getLevel();
        }
        float rightLevel = Math.max(previousLevel, nextLevel) + 5.0f;
        int i = beginDeletionIndex;
        while (i < endDeletionIndex) {
            IFunction function = tree.get(i);
            String name = function.getTagName();
            treeHandler.changeLevel(name, (int)rightLevel, tree);
            ++i;
        }
        return true;
    }

    protected GeneratedFunctionsCursor newGeneratedFunctionCursor(IGeneratedInfo genInfo) {
        String patternName = genInfo.getProperty("pattern");
        if (patternName == null) {
            return null;
        }
        if ("com.ibm.pdp.pacbase.dialog".equals(patternName) || "com.ibm.pdp.pacbase.csclient".equals(patternName)) {
            return new GeneratedFunctionsCursorForDialog(genInfo);
        }
        if ("com.ibm.pdp.pacbase.csserver".equals(patternName)) {
            return new GeneratedFunctionsCursorForServer(genInfo);
        }
        return new GeneratedFunctionsCursorForBatch(genInfo);
    }

    protected void findGeneratedFunctions(IGeneratedInfo genInfo, List<Function> functions, Map<String, Function> functionsFromName) {
        CharSequence text = genInfo.getText();
        GeneratedFunctionsCursor cursor = this.newGeneratedFunctionCursor(genInfo);
        while (cursor.searchNextFunction()) {
            IGeneratedTag tag = cursor.tag();
            Function function = new Function(tag, text, cursor.cobolName(), cursor.level(), cursor.location(), cursor.reference(), cursor.firstStatementBeginIndex(), cursor.firstStatementEndIndex(), cursor.bodyEndIndex(), cursor.lastStatementBeginIndex(), cursor.lastStatementEndIndex());
            function.setDash900Tag(cursor.dash900Tag());
            IGeneratedTag ancestor = tag.getParent();
            while (ancestor != null) {
                IFunction ancestorFunction = functionsFromName.get(ancestor.getName());
                if (ancestorFunction != null) {
                    ancestorFunction.setNbOfDependents(ancestorFunction.getNbOfDependents() + 1);
                }
                ancestor = ancestor.getParent();
            }
            functions.add(function);
            functionsFromName.put(tag.getName(), function);
        }
    }

    protected IGeneratedInfo buildModifiedGeneratedInfo(IGeneratedInfo genInfo, List<Function> initialTree, List<IFunction> modifiedTree) {
        List<GeneratedInfoChange> changes = this.buildGeneratedInfoChangesFromTreeChanges(initialTree, modifiedTree);
        if (changes.isEmpty()) {
            return genInfo;
        }
        GeneratedInfoTransformer transformer = new GeneratedInfoTransformer((IGeneratedInfoFactory)new GenInfoFactory(), changes.iterator());
        return transformer.convert(genInfo);
    }

    protected static <T extends IFunction> void dumpTree(List<T> tree) {
        OpenCloseCursor<T> cursor = new OpenCloseCursor<T>(tree);
        while (cursor.searchNext()) {
            T function = cursor.function();
            if (cursor.isBegin()) {
                System.out.println(String.valueOf(function.getCobolName()) + " LV" + function.getLevel());
                continue;
            }
            System.out.println(String.valueOf(function.getCobolName()) + "-FN LV" + function.getLevel());
        }
    }

    private String getLabel900IfNecessary(List<IFunction> modifiedTree, DefaultFunction currentFct, List<IFunction> initialTree) {
        if (!("IT".equals(((PdpFunction)currentFct).getCondition()) || "DI".equals(((PdpFunction)currentFct).getCondition()) || "DV".equals(((PdpFunction)currentFct).getCondition()) || "DC".equals(((PdpFunction)currentFct).getCondition()))) {
            return "";
        }
        for (IFunction iFunction : initialTree) {
            PdpFunction f;
            if (!iFunction.getCobolName().startsWith(currentFct.getCobolName())) continue;
            if (!(iFunction instanceof PdpFunction) || !(f = (PdpFunction)iFunction).isLabel900Exist() || !f.isLabel900InCoa()) break;
            return f.getLine900();
        }
        String fctName = currentFct.getCobolName().substring(0, 3);
        int index = modifiedTree.indexOf(currentFct);
        String label = "";
        int j = index + 1;
        while (j < modifiedTree.size()) {
            PdpFunction nextFct = (PdpFunction)modifiedTree.get(j);
            String nextFctName = nextFct.getCobolName().substring(0, 3);
            if (!fctName.equals(nextFctName)) break;
            if (currentFct.getLevel() == nextFct.getLevel()) {
                if (!"EL".equals(nextFct.getCondition())) break;
                label = nextFct.getCobolName();
                break;
            }
            ++j;
        }
        if (label.length() == 0) {
            float level = 0.0f;
            int j2 = index - 1;
            while (j2 > 0) {
                PdpFunction previousFct = (PdpFunction)modifiedTree.get(j2);
                String previousFctName = previousFct.getCobolName().substring(0, 3);
                if (fctName.equals(previousFctName)) {
                    if (previousFct.getLevel() == level || currentFct.getLevel() == previousFct.getLevel() && previousFct.getCondition().length() == 0) break;
                    if (currentFct.getLevel() > previousFct.getLevel()) {
                        level = previousFct.getLevel();
                        if (!"CO".equals(previousFct.getCondition())) break;
                        label = previousFct.getCobolName();
                        break;
                    }
                }
                --j2;
            }
        }
        return label;
    }

    private void dealWithLabel900(String newLabel900, PdpFunction initialFunction, List<InfoFunctionChanges> changes) {
        String oldLabel900 = "";
        if (initialFunction.isLabel900Exist()) {
            int index = initialFunction.getLine900().indexOf("-FN.");
            oldLabel900 = initialFunction.getLine900().substring(index - 5, index);
        }
        if (newLabel900.length() > 0 && (!initialFunction.isLabel900Exist() || oldLabel900.length() > 0 && !oldLabel900.equals(newLabel900)) || newLabel900.length() == 0 && initialFunction.isLabel900Exist() && !initialFunction.isLabel900InCoa()) {
            changes.add(new InfoFunctionChanges(InfoFunctionChanges.ActionType.REMOVE_FN, initialFunction, initialFunction.getLastStatementBeginIdx(), initialFunction.getLastStatementEndIdx()));
            changes.add(new InfoFunctionChanges(InfoFunctionChanges.ActionType.INSERT_FN, (IFunction)initialFunction, (Integer)initialFunction.getLastStatementBeginIdx(), (Integer)initialFunction.getLastStatementBeginIdx(), newLabel900));
        }
    }

    public List<InfoFunctionChanges> buildChangesFromTreeInsertions(List<IFunction> initialTree, List<IFunction> modifiedTree, String name) {
        if (initialTree.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<InfoFunctionChanges> changes = new ArrayList<InfoFunctionChanges>();
        OpenCloseCursor<IFunction> initial = new OpenCloseCursor<IFunction>(initialTree);
        OpenCloseCursor<IFunction> modified = new OpenCloseCursor<IFunction>(modifiedTree);
        modified.searchNext();
        initial.searchNext();
        PdpFunction lastInitialFunction = null;
        String newLabel900 = null;
        String updtFctName = name.substring(0, 3);
        while (initial.found() && modified.found()) {
            String modifiedFctName;
            PdpFunction initialFunction = (PdpFunction)initial.currentFunction;
            DefaultFunction modifiedFunction = (DefaultFunction)modified.currentFunction;
            if (modified.found() && modified.isEnd() && updtFctName.equals(modifiedFunction.getCobolName().substring(0, 3))) {
                newLabel900 = this.getLabel900IfNecessary(modifiedTree, modifiedFunction, initialTree);
            }
            if (this.samePosition(initial, modified)) {
                if (updtFctName.equals(modifiedFunction.getCobolName().substring(0, 3)) && newLabel900 != null && modified.isEnd()) {
                    this.dealWithLabel900(newLabel900, initialFunction, changes);
                }
                modified.searchNext();
                lastInitialFunction = (PdpFunction)initial.currentFunction;
                initial.searchNext();
                continue;
            }
            if (initial.isEnd) {
                boolean searchNext = false;
                for (InfoFunctionChanges infoFunctionChanges : changes) {
                    if (!infoFunctionChanges.getFunction().getCobolName().equals(initialFunction.getCobolName())) continue;
                    changes.add(new InfoFunctionChanges(InfoFunctionChanges.ActionType.REMOVE_FN, initialFunction, initialFunction.getLastStatementBeginIdx(), initialFunction.getLastStatementEndIdx()));
                    searchNext = true;
                    break;
                }
                if (searchNext) {
                    initial.searchNext();
                    continue;
                }
            }
            if ((modifiedFctName = modifiedFunction.getTagName()).equals(name)) {
                if (modified.isBegin()) {
                    if (initial.isEnd()) {
                        changes.add(new InfoFunctionChanges(InfoFunctionChanges.ActionType.INSERT_FCT, modifiedFunction, initialFunction.getLastStatementBeginIdx(), initialFunction.getLastStatementBeginIdx()));
                    } else {
                        changes.add(new InfoFunctionChanges(InfoFunctionChanges.ActionType.INSERT_FCT, modifiedFunction, initialFunction.getBodyStatementBeginIdx(), initialFunction.getBodyStatementBeginIdx()));
                    }
                }
                if (modified.isEnd()) {
                    if (initial.isEnd()) {
                        changes.add(new InfoFunctionChanges(InfoFunctionChanges.ActionType.INSERT_FN, (IFunction)modifiedFunction, (Integer)initialFunction.getLastStatementBeginIdx(), (Integer)initialFunction.getLastStatementBeginIdx(), newLabel900));
                    } else {
                        changes.add(new InfoFunctionChanges(InfoFunctionChanges.ActionType.INSERT_FN, (IFunction)modifiedFunction, (Integer)initialFunction.getBodyStatementBeginIdx(), (Integer)initialFunction.getBodyStatementBeginIdx(), newLabel900));
                    }
                }
                modified.searchNext();
                continue;
            }
            if (modified.isEnd()) {
                changes.add(new InfoFunctionChanges(InfoFunctionChanges.ActionType.INSERT_FN, (IFunction)modifiedFunction, (Integer)initialFunction.getBodyStatementBeginIdx(), (Integer)initialFunction.getBodyStatementBeginIdx(), newLabel900));
                modified.searchNext();
                continue;
            }
            if (modified.isBegin() && initial.isEnd()) {
                changes.add(new InfoFunctionChanges(InfoFunctionChanges.ActionType.INSERT_FN, initialFunction, initialFunction.getLastStatementBeginIdx(), initialFunction.getLastStatementEndIdx()));
            }
            initial.searchNext();
        }
        while (modified.found()) {
            int index;
            DefaultFunction modifiedFunction = (DefaultFunction)modified.currentFunction;
            int n = index = lastInitialFunction == null ? 0 : lastInitialFunction.getLastStatementEndIdx();
            if (modified.isBegin()) {
                changes.add(new InfoFunctionChanges(InfoFunctionChanges.ActionType.INSERT_FCT, modifiedFunction, index, index));
            }
            if (modified.isEnd()) {
                changes.add(new InfoFunctionChanges(InfoFunctionChanges.ActionType.INSERT_FN, modifiedFunction, index, index));
            }
            modified.searchNext();
        }
        return changes;
    }

    public List<InfoFunctionChanges> buildChangesFromTreeChanges(List<IFunction> initialTree, List<IFunction> modifiedTree, String name) {
        PdpFunction initialFunction;
        if (initialTree.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<InfoFunctionChanges> changes = new ArrayList<InfoFunctionChanges>();
        OpenCloseCursor<IFunction> initial = new OpenCloseCursor<IFunction>(initialTree);
        OpenCloseCursor<IFunction> modified = new OpenCloseCursor<IFunction>(modifiedTree);
        modified.searchNext();
        initial.searchNext();
        String newLabel900 = null;
        PdpFunction lastInitialFunction = null;
        String updtFctName = name.substring(0, 3);
        while (initial.found() && modified.found()) {
            lastInitialFunction = initialFunction = (PdpFunction)initial.currentFunction;
            DefaultFunction modifiedFunction = (DefaultFunction)modified.currentFunction;
            newLabel900 = null;
            if (modified.found() && modified.isEnd() && updtFctName.equals(modifiedFunction.getCobolName().substring(0, 3))) {
                newLabel900 = this.getLabel900IfNecessary(modifiedTree, modifiedFunction, initialTree);
            }
            if (this.samePosition(initial, modified)) {
                if (updtFctName.equals(modifiedFunction.getCobolName().substring(0, 3)) && newLabel900 != null && modified.isEnd()) {
                    this.dealWithLabel900(newLabel900, initialFunction, changes);
                }
                if (modifiedFunction.getTagName().equals(name) && modified.isBegin() && initial.isBegin() && initialFunction.getLevelIndex() > 0) {
                    changes.add(new InfoFunctionChanges(InfoFunctionChanges.ActionType.CHANGE_LEVEL, (IFunction)modifiedFunction, (Integer)initialFunction.getBodyStatementBeginIdx(), (Integer)initialFunction.getBodyStatementEndIdx(), initialFunction.getLevelIndex()));
                }
                initial.searchNext();
                modified.searchNext();
                continue;
            }
            if (modified.isEnd()) {
                if (initial.isEnd()) {
                    changes.add(new InfoFunctionChanges(InfoFunctionChanges.ActionType.INSERT_FN, (IFunction)modifiedFunction, (Integer)initialFunction.getLastStatementBeginIdx(), (Integer)initialFunction.getLastStatementBeginIdx(), newLabel900));
                } else {
                    changes.add(new InfoFunctionChanges(InfoFunctionChanges.ActionType.INSERT_FN, (IFunction)modifiedFunction, (Integer)initialFunction.getBodyStatementBeginIdx(), (Integer)initialFunction.getBodyStatementBeginIdx(), newLabel900));
                }
            } else if (initial.isEnd()) {
                changes.add(new InfoFunctionChanges(InfoFunctionChanges.ActionType.REMOVE_FN, initialFunction, initialFunction.getLastStatementBeginIdx(), initialFunction.getLastStatementEndIdx()));
                initial.searchNext();
                continue;
            }
            modified.searchNext();
        }
        while (initial.found()) {
            lastInitialFunction = initialFunction = (PdpFunction)initial.currentFunction;
            if (!updtFctName.equals(initialFunction.getCobolName().substring(0, 3))) break;
            if (initial.isEnd) {
                changes.add(new InfoFunctionChanges(InfoFunctionChanges.ActionType.REMOVE_FN, initialFunction, initialFunction.getLastStatementBeginIdx(), initialFunction.getLastStatementEndIdx()));
            }
            initial.searchNext();
        }
        while (modified.found()) {
            int index;
            PdpFunction modifiedFunction = (PdpFunction)modified.currentFunction;
            int n = index = lastInitialFunction == null ? 0 : lastInitialFunction.getLastStatementEndIdx();
            if (!updtFctName.equals(modifiedFunction.getCobolName().substring(0, 3))) break;
            if (modified.isEnd()) {
                changes.add(new InfoFunctionChanges(InfoFunctionChanges.ActionType.INSERT_FN, modifiedFunction, index, index));
            }
            modified.searchNext();
        }
        return changes;
    }

    private boolean samePosition(OpenCloseCursor<IFunction> initial, OpenCloseCursor<IFunction> modified) {
        boolean b = false;
        if (initial.currentFunction.getCobolName().equals(modified.currentFunction.getCobolName()) && (initial.isBegin() && modified.isBegin() || initial.isEnd() && modified.isEnd())) {
            b = true;
        }
        return b;
    }

    protected List<GeneratedInfoChange> buildGeneratedInfoChangesFromTreeChanges(List<Function> initialTree, List<IFunction> modifiedTree) {
        if (initialTree.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<GeneratedInfoChange> changes = new ArrayList<GeneratedInfoChange>();
        OpenCloseCursorWindow initial = new OpenCloseCursorWindow(new OpenCloseCursor<Function>(initialTree));
        OpenCloseCursor<IFunction> modified = new OpenCloseCursor<IFunction>(modifiedTree);
        modified.searchNext();
        int insertionPosition = 0;
        while (initial.hasCurrent()) {
            Function function = initial.function();
            String functionName = function.getTagName();
            if (modified.found()) {
                IFunction modifiedFunction = modified.function();
                if (modifiedFunction instanceof SpecificFunction) {
                    if (insertionPosition == 0) {
                        if (modified.isBegin()) {
                            if (initial.isBegin()) {
                                this.addBeginTagBefore(changes, modifiedFunction, functionName);
                                insertionPosition = 2;
                            } else if (initial.hasPrevious() && initial.previousIsEnd()) {
                                this.addBeginTagAfter(changes, modifiedFunction, initial.previousFunction().getTagName());
                            } else {
                                this.addBeginTagAtIndex(changes, modifiedFunction, function.insertionIndex(), functionName);
                                insertionPosition = 1;
                            }
                        } else if (initial.hasPrevious() && initial.previousIsEnd()) {
                            this.addEndTagAfter(changes, initial.previousFunction().getTagName());
                        } else if (initial.isBegin()) {
                            this.addEndTagBefore(changes, functionName);
                            insertionPosition = 2;
                        } else {
                            this.addEndTagAtIndex(changes, function.insertionIndex(), functionName);
                            insertionPosition = 1;
                        }
                    } else if (insertionPosition == 1) {
                        if (modified.isBegin()) {
                            this.addBeginTagAtIndex(changes, modifiedFunction, function.insertionIndex(), functionName);
                        } else {
                            this.addEndTagAtIndex(changes, function.insertionIndex(), functionName);
                        }
                    } else if (insertionPosition == 2) {
                        if (modified.isBegin()) {
                            this.addBeginTagBefore(changes, modifiedFunction, functionName);
                        } else {
                            this.addEndTagBefore(changes, functionName);
                        }
                    }
                    modified.searchNext();
                    continue;
                }
                if (initial.isBegin() != modified.isBegin()) {
                    Function original = ((MutableFunction)modifiedFunction).getFunction();
                    if (insertionPosition == 0) {
                        if (initial.isBegin()) {
                            if (initial.hasPrevious() && initial.previousIsEnd()) {
                                this.addFnInsertionAfter(changes, original, initial.previousFunction().getTagName());
                            } else {
                                this.addFnInsertionBefore(changes, original, functionName);
                                insertionPosition = 2;
                            }
                            modified.searchNext();
                            continue;
                        }
                        this.addFnDeletion(changes, function);
                        initial.searchNext();
                        insertionPosition = 0;
                        continue;
                    }
                    if (insertionPosition == 1) {
                        this.addFnDeletion(changes, function);
                        initial.searchNext();
                        insertionPosition = 0;
                        continue;
                    }
                    if (insertionPosition != 2) continue;
                    this.addFnInsertionBefore(changes, original, functionName);
                    modified.searchNext();
                    continue;
                }
                if (initial.isEnd() && !functionName.equals(modifiedFunction.getTagName())) {
                    this.addFnDeletion(changes, function);
                    initial.searchNext();
                    insertionPosition = 0;
                    continue;
                }
                initial.searchNext();
                modified.searchNext();
                insertionPosition = 0;
                continue;
            }
            this.addFnDeletion(changes, function);
            initial.searchNext();
            insertionPosition = 0;
        }
        String previousTagName = initial.previousFunction().getTagName();
        while (modified.found()) {
            IFunction modifiedFunction = modified.function();
            if (modifiedFunction instanceof SpecificFunction) {
                if (modified.isBegin()) {
                    this.addBeginTagAfter(changes, modifiedFunction, previousTagName);
                } else {
                    this.addEndTagAfter(changes, previousTagName);
                }
            } else if (modified.isEnd()) {
                this.addFnInsertionAfter(changes, ((MutableFunction)modified.function()).getFunction(), initial.previousFunction().getTagName());
            }
            modified.searchNext();
        }
        return changes;
    }

    protected void addBeginTagBefore(List<GeneratedInfoChange> changes, IFunction function, String positionTagName) {
    }

    protected void addBeginTagAfter(List<GeneratedInfoChange> changes, IFunction function, String positionTagName) {
    }

    protected void addBeginTagAtIndex(List<GeneratedInfoChange> changes, IFunction function, int index, String includingTagName) {
    }

    protected void addEndTagBefore(List<GeneratedInfoChange> changes, String positionTagName) {
    }

    protected void addEndTagAfter(List<GeneratedInfoChange> changes, String positionTagName) {
    }

    protected void addEndTagAtIndex(List<GeneratedInfoChange> changes, int index, String includingTagName) {
    }

    protected void addFnInsertionAfter(List<GeneratedInfoChange> changes, Function function, String afterTagName) {
        IGeneratedTag dash900Tag = function.getDash900Tag();
        if (dash900Tag != null) {
            changes.add(this.newDash900InsertionAfter(dash900Tag, afterTagName));
        }
        if (function.foundLastLine()) {
            changes.add(this.newFnInsertionAfter(function, afterTagName));
        } else {
            changes.add(this.newEndTagAfter(afterTagName));
        }
    }

    protected void addFnInsertionBefore(List<GeneratedInfoChange> changes, Function function, String beforeTagName) {
        IGeneratedTag dash900Tag = function.getDash900Tag();
        if (dash900Tag != null) {
            changes.add(this.newDash900InsertionBefore(dash900Tag, beforeTagName));
        }
        if (function.foundLastLine()) {
            changes.add(this.newFnInsertionBefore(function, beforeTagName));
        } else {
            changes.add(this.newEndTagBefore(beforeTagName));
        }
    }

    protected void addFnDeletion(List<GeneratedInfoChange> changes, Function function) {
        IGeneratedTag dash900Tag = function.getDash900Tag();
        if (dash900Tag != null) {
            changes.add(this.newSkipTag(dash900Tag));
        }
        if (function.foundLastLine()) {
            changes.add(this.newFnTextDeletion(function));
        }
        changes.add(this.newSkipTagClose(function.getTagName()));
    }

    protected GeneratedInfoChange newFnInsertionBefore(Function function, String beforeTagName) {
        return new InsertTextAndCloseTagBeforeTagOpen(beforeTagName, function.lastLine());
    }

    protected GeneratedInfoChange newDash900InsertionBefore(IGeneratedTag dash900Tag, String beforeTagName) {
        return new InsertDash900BeforeTagOpen(dash900Tag, beforeTagName);
    }

    protected GeneratedInfoChange newFnInsertionAfter(Function function, String afterTagName) {
        return new InsertTextAndCloseTagAfterTagClose(afterTagName, function.lastLine());
    }

    protected GeneratedInfoChange newDash900InsertionAfter(IGeneratedTag dash900Tag, String afterTagName) {
        return new InsertDash900AfterTagClose(dash900Tag, afterTagName);
    }

    protected GeneratedInfoChange newFnTextDeletion(Function function) {
        int beginIdx = function.getLastLineBeginIndex();
        int endIdx = function.getEndIndex();
        return new RemoveSolidTextInterval(function.getTag().getGeneratedInfo().getText(), beginIdx, endIdx);
    }

    protected GeneratedInfoChange newSkipTag(IGeneratedTag tagToSkip) {
        return new SkipTag(tagToSkip);
    }

    protected GeneratedInfoChange newBeginTagBefore(IFunction function, String positionTagName) {
        OpenTag change = new OpenTag(GeneratedChangePosition.BEFORE_TAG_OPEN, positionTagName, function.getTagName());
        change.addProperty("SpecificTag", "true");
        change.addProperty("level", String.valueOf((int)function.getLevel()));
        return change;
    }

    protected GeneratedInfoChange newEndTagBefore(String positionTagName) {
        CloseTag change = new CloseTag(GeneratedChangePosition.BEFORE_TAG_OPEN, positionTagName);
        return change;
    }

    protected GeneratedInfoChange newBeginTagAfter(IFunction function, String tagNamePosition) {
        OpenTag change = new OpenTag(GeneratedChangePosition.AFTER_TAG_CLOSE, tagNamePosition, function.getTagName());
        change.addProperty("SpecificTag", "true");
        change.addProperty("level", String.valueOf((int)function.getLevel()));
        return change;
    }

    protected GeneratedInfoChange newEndTagAfter(String positionTagName) {
        CloseTag change = new CloseTag(GeneratedChangePosition.AFTER_TAG_CLOSE, positionTagName);
        return change;
    }

    protected GeneratedInfoChange newBeginTagAtIndex(IFunction function, int index, String includingTagName) {
        BeginTagAtIndexIntoTag change = new BeginTagAtIndexIntoTag(index, function.getTagName(), includingTagName);
        change.addProperty("SpecificTag", "true");
        change.addProperty("level", String.valueOf((int)function.getLevel()));
        return change;
    }

    protected GeneratedInfoChange newEndTagAtIndex(int index, String includingTagName) {
        EndTagAtIndexIntoTag change = new EndTagAtIndexIntoTag(index, includingTagName);
        return change;
    }

    protected GeneratedInfoChange newSkipTagClose(String tagName) {
        return new SkipTagClose(tagName);
    }

    protected static boolean sameFunctions(Function left, Function right) {
        String leftName = left.getCobolName();
        String rightName = right.getCobolName();
        if (leftName.length() < 3 || rightName.length() < 3) {
            return false;
        }
        if (leftName.charAt(0) == 'F' && rightName.charAt(0) == 'F' && leftName.charAt(1) == rightName.charAt(1) && leftName.charAt(2) == rightName.charAt(2)) {
            if (rightName.startsWith("F80") && !"F80".equals(leftName)) {
                String refInPgmRight = right.getTag().getProperty("refInPgm");
                String refInPgmLeft = null;
                IGeneratedTag tag = left.getTag();
                while (refInPgmLeft == null && tag != null) {
                    refInPgmLeft = tag.getProperty("refInPgm");
                    tag = tag.getParent();
                }
                if (refInPgmLeft != null) {
                    return refInPgmLeft.equals(refInPgmRight);
                }
                return refInPgmRight == null;
            }
            return true;
        }
        return false;
    }

    protected void copyTree(List<Function> tree, List<IFunction> copy) {
        for (Function function : tree) {
            MutableFunction functionCopy = new MutableFunction(function);
            copy.add(functionCopy);
        }
    }

    protected int toInt(String str) {
        if (str == null) {
            return -1;
        }
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    protected List<IFunction> buildGeneratedTree(IGeneratedInfo genInfo) {
        HashMap<String, DefaultFunction> functionsFromName = new HashMap<String, DefaultFunction>();
        ArrayList<IFunction> functions = new ArrayList<IFunction>();
        GeneratedFunctionsCursorForBatch cursor = new GeneratedFunctionsCursorForBatch(genInfo);
        while (cursor.searchNextFunction()) {
            IGeneratedTag tag = cursor.tag();
            String tagName = tag.getName();
            DefaultFunction function = new DefaultFunction(tagName, tagName, cursor.level(), 0, null, null);
            IGeneratedTag ancestor = tag.getParent();
            while (ancestor != null) {
                IFunction ancestorFunction = (IFunction)functionsFromName.get(ancestor.getName());
                if (ancestorFunction != null) {
                    ancestorFunction.setNbOfDependents(ancestorFunction.getNbOfDependents() + 1);
                }
                ancestor = ancestor.getParent();
            }
            functions.add(function);
            functionsFromName.put(tagName, function);
        }
        return functions;
    }

    protected String showFunctions(List<Function> functions, CharSequence txt) {
        StringBuilder builder = new StringBuilder();
        for (Function function : functions) {
            builder.append(function.details(txt)).append(Strings.getLineSeparator());
        }
        return builder.toString();
    }

    protected IGeneratedTag commonAncestor(IGeneratedTag tag1, IGeneratedTag tag2) {
        if (tag1 == tag2) {
            return tag1;
        }
        ArrayList<IGeneratedTag> ancestors1 = new ArrayList<IGeneratedTag>();
        ArrayList<IGeneratedTag> ancestors2 = new ArrayList<IGeneratedTag>();
        this.storeAncestors(tag1, ancestors1);
        this.storeAncestors(tag2, ancestors2);
        int idx1 = ancestors1.size();
        int idx2 = ancestors2.size();
        IGeneratedTag ancestor = null;
        while (idx1 > 0 && idx2 > 0) {
            IGeneratedTag ancestor1;
            if ((ancestor1 = ancestors1.get(--idx1)) == ancestors2.get(--idx2)) {
                ancestor = ancestor1;
                continue;
            }
            return ancestor;
        }
        return ancestor;
    }

    protected void storeAncestors(IGeneratedTag tag, ArrayList<IGeneratedTag> ancestors) {
        do {
            ancestors.add(tag);
        } while ((tag = tag.getParent()) != null);
    }

    protected boolean validateActualFunctions(List<Function> functions, int indexShift) {
        int previousFirstLineEndIdx = 0;
        for (Function function : functions) {
            int firstLineBeginIdx = function.getFirstLineBeginIndex();
            int firstLineEndIdx = function.getFirstLineEndIndex();
            int lastLineBeginIdx = function.getLastLineBeginIndex();
            int lastLineEndIdx = function.getLastLineEndIndex();
            function.shiftAllIndexes(indexShift);
            if (!(firstLineBeginIdx != -1 && firstLineEndIdx != -1 && lastLineBeginIdx != -1 && lastLineEndIdx != -1 || firstLineBeginIdx == -1 && firstLineEndIdx == -1 && lastLineBeginIdx == -1 && lastLineEndIdx == -1)) {
                return false;
            }
            if (lastLineBeginIdx < firstLineEndIdx) {
                return false;
            }
            if (firstLineBeginIdx == -1) continue;
            if (firstLineBeginIdx < previousFirstLineEndIdx) {
                return false;
            }
            previousFirstLineEndIdx = firstLineEndIdx;
        }
        return true;
    }

    protected static int computeColumn(int idx, CharSequence str) {
        int column = 0;
        while (idx >= 0) {
            char c = str.charAt(idx);
            if (c == '\n' || c == '\r') {
                return column;
            }
            ++column;
            --idx;
        }
        return column;
    }

    protected static int nextLineStart(int idx, CharSequence str) {
        boolean foundN = false;
        boolean foundR = false;
        while (idx < str.length()) {
            char c = str.charAt(idx);
            if (c == '\n') {
                if (foundN) {
                    return idx;
                }
                foundN = true;
            } else if (c == '\r') {
                if (foundR) {
                    return idx;
                }
                foundR = true;
            } else if (foundR || foundN) {
                return idx;
            }
            ++idx;
        }
        return idx;
    }

    protected static class BeginEndCursor {
        protected Iterator<Function> functions;
        protected Function nextFunction;
        protected Deque<Function> opened;
        protected Function currentFunction;
        protected boolean isEnd;

        public BeginEndCursor(Iterator<Function> functions) {
            this.functions = functions;
            this.opened = new ArrayDeque<Function>();
            this.forward();
        }

        public boolean searchNext() {
            Function parent;
            if (this.nextFunction == null) {
                if (this.opened.isEmpty()) {
                    return this.notFound();
                }
                return this.foundEnd(this.opened.pop());
            }
            int nextIndex = this.beginIndex(this.nextFunction);
            if (!this.opened.isEmpty() && this.endIndex(parent = this.opened.peek()) < nextIndex) {
                this.opened.pop();
                return this.foundEnd(parent);
            }
            Function function = this.nextFunction;
            this.opened.push(function);
            this.forward();
            return this.foundBegin(function);
        }

        protected void forward() {
            this.nextFunction = this.functions.hasNext() ? this.functions.next() : null;
        }

        public boolean found() {
            return this.currentFunction != null;
        }

        public Function function() {
            return this.currentFunction;
        }

        public boolean isBegin() {
            return !this.isEnd;
        }

        public boolean isEnd() {
            return this.isEnd;
        }

        protected int beginIndex(Function function) {
            return function.getBeginIndex();
        }

        protected int endIndex(Function function) {
            return function.getEndIndex();
        }

        protected boolean foundBegin(Function function) {
            this.currentFunction = function;
            this.isEnd = false;
            return true;
        }

        protected boolean foundEnd(Function function) {
            this.currentFunction = function;
            this.isEnd = true;
            return true;
        }

        protected boolean notFound() {
            this.currentFunction = null;
            return false;
        }
    }

    protected static class BeginEndCursorWindow {
        protected BeginEndCursor cursor;
        protected Function previousFunction;
        protected boolean previousIsBegin;
        protected Function currentFunction;
        protected boolean currentIsBegin;
        protected Function nextFunction;
        protected boolean nextIsBegin;

        public BeginEndCursorWindow(BeginEndCursor cursor) {
            this.cursor = cursor;
            if (cursor.searchNext()) {
                this.currentFunction = cursor.function();
                this.currentIsBegin = cursor.isBegin();
                if (cursor.searchNext()) {
                    this.nextFunction = cursor.function();
                    this.nextIsBegin = cursor.isBegin();
                }
            }
        }

        public boolean hasPrevious() {
            return this.previousFunction != null;
        }

        public Function previousFunction() {
            return this.previousFunction;
        }

        public boolean previousIsBegin() {
            return this.previousIsBegin;
        }

        public boolean previousIsEnd() {
            return !this.previousIsBegin;
        }

        public boolean hasCurrent() {
            return this.currentFunction != null;
        }

        public Function function() {
            return this.currentFunction;
        }

        public boolean isBegin() {
            return this.currentIsBegin;
        }

        public boolean isEnd() {
            return !this.currentIsBegin;
        }

        public boolean hasNext() {
            return this.nextFunction != null;
        }

        public Function nextFunction() {
            return this.nextFunction;
        }

        public boolean nextIsBegin() {
            return this.nextIsBegin;
        }

        public boolean nextIsEnd() {
            return !this.nextIsBegin;
        }

        public void searchNext() {
            this.previousFunction = this.currentFunction;
            this.previousIsBegin = this.currentIsBegin;
            this.currentFunction = this.nextFunction;
            this.currentIsBegin = this.nextIsBegin;
            if (this.cursor.searchNext()) {
                this.nextFunction = this.cursor.function();
                this.nextIsBegin = this.cursor.isBegin();
            } else {
                this.nextFunction = null;
                this.nextIsBegin = false;
            }
        }
    }

    protected static class ModifiedBeginEndCursor
    extends BeginEndCursor {
        public ModifiedBeginEndCursor(Iterator<Function> functions) {
            super(functions);
        }

        @Override
        protected int beginIndex(Function function) {
            int beginIdx = function.getModifiedBeginIndex();
            if (beginIdx == -1) {
                beginIdx = function.getModifiedEndIndex() - 1;
            }
            return beginIdx;
        }

        @Override
        protected int endIndex(Function function) {
            int endIdx = function.getModifiedEndIndex();
            if (endIdx == -1) {
                endIdx = function.getModifiedBeginIndex() + 1;
            }
            return endIdx;
        }

        @Override
        protected void forward() {
            while (this.functions.hasNext()) {
                this.nextFunction = (Function)this.functions.next();
                if (this.nextFunction.isDeleted()) continue;
                return;
            }
            this.nextFunction = null;
        }
    }

    protected static class ModifiedBeginEndCursorKeepDeleted
    extends BeginEndCursor {
        public ModifiedBeginEndCursorKeepDeleted(Iterator<Function> functions) {
            super(functions);
        }

        @Override
        public boolean searchNext() {
            if (this.nextFunction == null) {
                if (this.opened.isEmpty()) {
                    return this.notFound();
                }
                return this.foundEnd((Function)this.opened.pop());
            }
            if (!this.opened.isEmpty()) {
                Function parent = (Function)this.opened.peek();
                if (parent.isDeleted()) {
                    if (!parent.isFunction() || !FunctionsConsistencyAnalyzer.sameFunctions(parent, this.nextFunction)) {
                        this.opened.pop();
                        return this.foundEnd(parent);
                    }
                } else if (this.nextFunction.isDeleted()) {
                    if (!FunctionsConsistencyAnalyzer.sameFunctions(parent, this.nextFunction) || this.nextFunction.getBeginIndex() > parent.getEndIndex()) {
                        this.opened.pop();
                        return this.foundEnd(parent);
                    }
                } else if (this.endIndex(parent) < this.beginIndex(this.nextFunction)) {
                    this.opened.pop();
                    return this.foundEnd(parent);
                }
            }
            Function function = this.nextFunction;
            this.opened.push(function);
            this.forward();
            return this.foundBegin(function);
        }

        @Override
        protected int beginIndex(Function function) {
            int beginIdx = function.getModifiedBeginIndex();
            if (beginIdx == -1) {
                beginIdx = function.getModifiedEndIndex() - 1;
            }
            return beginIdx;
        }

        @Override
        protected int endIndex(Function function) {
            int endIdx = function.getModifiedEndIndex();
            if (endIdx == -1) {
                endIdx = function.getModifiedBeginIndex() + 1;
            }
            return endIdx;
        }
    }

    protected static class OpenCloseCursor<T extends IFunction> {
        protected List<T> tree;
        protected int index;
        protected Deque<Integer> opened;
        protected T currentFunction;
        protected boolean isEnd;

        public OpenCloseCursor(List<T> tree) {
            this.tree = tree;
            this.opened = new ArrayDeque<Integer>();
        }

        public boolean searchNext() {
            IFunction parent;
            int parentIdx;
            if (!this.opened.isEmpty() && (parentIdx = this.opened.peek().intValue()) + (parent = (IFunction)this.tree.get(parentIdx)).getNbOfDependents() < this.index) {
                this.opened.pop();
                return this.foundEnd(parent);
            }
            if (this.index == this.tree.size()) {
                return this.notFound();
            }
            IFunction function = (IFunction)this.tree.get(this.index);
            this.opened.push(this.index);
            ++this.index;
            return this.foundBegin(function);
        }

        public boolean found() {
            return this.currentFunction != null;
        }

        public T function() {
            return this.currentFunction;
        }

        public boolean isBegin() {
            return !this.isEnd;
        }

        public boolean isEnd() {
            return this.isEnd;
        }

        protected boolean foundBegin(T function) {
            this.currentFunction = function;
            this.isEnd = false;
            return true;
        }

        protected boolean foundEnd(T function) {
            this.currentFunction = function;
            this.isEnd = true;
            return true;
        }

        protected boolean notFound() {
            this.currentFunction = null;
            return false;
        }
    }

    protected static class OpenCloseCursorSkipSpecific<T extends IFunction>
    extends OpenCloseCursor<T> {
        public OpenCloseCursorSkipSpecific(List<T> tree) {
            super(tree);
        }

        @Override
        public boolean searchNext() {
            while (super.searchNext()) {
                if (this.currentFunction instanceof SpecificFunction) continue;
                return true;
            }
            return false;
        }
    }

    protected static class OpenCloseCursorWindow {
        protected OpenCloseCursor<Function> cursor;
        protected Function previousFunction;
        protected boolean previousIsBegin;
        protected Function currentFunction;
        protected boolean currentIsBegin;
        protected Function nextFunction;
        protected boolean nextIsBegin;

        public OpenCloseCursorWindow(OpenCloseCursor<Function> cursor) {
            this.cursor = cursor;
            if (cursor.searchNext()) {
                this.currentFunction = cursor.function();
                this.currentIsBegin = cursor.isBegin();
                if (cursor.searchNext()) {
                    this.nextFunction = cursor.function();
                    this.nextIsBegin = cursor.isBegin();
                }
            }
        }

        public boolean hasPrevious() {
            return this.previousFunction != null;
        }

        public Function previousFunction() {
            return this.previousFunction;
        }

        public boolean previousIsBegin() {
            return this.previousIsBegin;
        }

        public boolean previousIsEnd() {
            return !this.previousIsBegin;
        }

        public boolean hasCurrent() {
            return this.currentFunction != null;
        }

        public Function function() {
            return this.currentFunction;
        }

        public boolean isBegin() {
            return this.currentIsBegin;
        }

        public boolean isEnd() {
            return !this.currentIsBegin;
        }

        public boolean hasNext() {
            return this.nextFunction != null;
        }

        public Function nextFunction() {
            return this.nextFunction;
        }

        public boolean nextIsBegin() {
            return this.nextIsBegin;
        }

        public boolean nextIsEnd() {
            return !this.nextIsBegin;
        }

        public void searchNext() {
            this.previousFunction = this.currentFunction;
            this.previousIsBegin = this.currentIsBegin;
            this.currentFunction = this.nextFunction;
            this.currentIsBegin = this.nextIsBegin;
            if (this.cursor.searchNext()) {
                this.nextFunction = this.cursor.function();
                this.nextIsBegin = this.cursor.isBegin();
            } else {
                this.nextFunction = null;
                this.nextIsBegin = false;
            }
        }
    }
}

