/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.extension.organize;

import com.ibm.pdp.engine.IGeneratedTag;
import com.ibm.pdp.engine.ITagProperties;
import com.ibm.pdp.engine.TextStatus;
import com.ibm.pdp.engine.tree.IEditTree;
import com.ibm.pdp.engine.tree.ITextNode;
import com.ibm.pdp.engine.util.tree.EditTreeFilter;
import com.ibm.pdp.engine.util.tree.ITextNodeFilter;
import com.ibm.pdp.framework.PdpTool;
import com.ibm.pdp.framework.views.CompoundTextNodeFilter;
import com.ibm.pdp.pacbase.FunctionInformations;
import com.ibm.pdp.pacbase.PacTool;
import com.ibm.pdp.pacbase.extension.organize.IVirtualFunction;
import com.ibm.pdp.pacbase.extension.organize.Location;
import com.ibm.pdp.pacbase.extension.organize.PdpFunction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class FunctionUtilities {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2016, 2020.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private String newLine = null;
    private String currentPattern;
    private List<String> dash900List;
    private List<String> supFunctionsList;
    private List<String> functionCodes;
    private Map<String, IVirtualFunction> supFunctionsToCreate;
    private List<String> specialFunctionsNotToCreate;
    private List<String> specialFunctionsOverrideSpecific;
    private List<String> allFunctionsFromSPmacro;
    private List<String> allFunctionsOverrideGenerated;

    public FunctionUtilities(String pattern) {
        this.currentPattern = pattern;
        this.dash900List = new ArrayList<String>();
        this.supFunctionsList = new ArrayList<String>();
        this.functionCodes = new ArrayList<String>();
        this.supFunctionsToCreate = new HashMap<String, IVirtualFunction>();
        this.allFunctionsFromSPmacro = new ArrayList<String>();
        this.instanciateSpecificFunctions();
    }

    private void instanciateSpecificFunctions() {
        this.specialFunctionsOverrideSpecific = new ArrayList<String>();
        if (this.currentPattern.equals("com.ibm.pdp.pacbase.batch")) {
            this.specialFunctionsOverrideSpecific.add("F9099");
        }
        this.specialFunctionsNotToCreate = new ArrayList<String>();
        if (this.currentPattern.equals("com.ibm.pdp.pacbase.dialog")) {
            this.specialFunctionsNotToCreate.add("F20A");
            this.specialFunctionsNotToCreate.add("F20R");
            this.specialFunctionsNotToCreate.add("F20Z");
            this.specialFunctionsNotToCreate.add("F25A");
            this.specialFunctionsNotToCreate.add("F25R");
            this.specialFunctionsNotToCreate.add("F25Z");
            this.specialFunctionsNotToCreate.add("F30A");
            this.specialFunctionsNotToCreate.add("F30R");
            this.specialFunctionsNotToCreate.add("F30Z");
            this.specialFunctionsNotToCreate.add("F35A");
            this.specialFunctionsNotToCreate.add("F35R");
            this.specialFunctionsNotToCreate.add("F35Z");
            this.specialFunctionsNotToCreate.add("F60A");
            this.specialFunctionsNotToCreate.add("F60R");
            this.specialFunctionsNotToCreate.add("F60Z");
            this.specialFunctionsNotToCreate.add("F65A");
            this.specialFunctionsNotToCreate.add("F65R");
            this.specialFunctionsNotToCreate.add("F65Z");
        }
    }

    public List<IVirtualFunction> searchSpecificFunction(IEditTree editTree) {
        IVirtualFunction f;
        EditTreeFilter etf = new EditTreeFilter();
        this.allFunctionsOverrideGenerated = new ArrayList<String>();
        this.newLine = PdpTool.determineDelimiterOfV2((CharSequence)editTree.getTextProcessor().getText());
        etf.setNodeFilter((ITextNodeFilter)new CompoundTextNodeFilter(new ITextNodeFilter[]{new ShowUserCodeNodesFilter()}));
        ITextNode tn = etf.nodeFromTagName(editTree, "PROCEDURE");
        List<IVirtualFunction> result = this.getSpecificSubFunctionsFrom(tn, etf);
        result.addAll(this.instanciateOverridedFunctions(editTree));
        if (!this.supFunctionsToCreate.isEmpty()) {
            for (String fct : this.supFunctionsToCreate.keySet()) {
                f = this.supFunctionsToCreate.get(fct);
                if (result.contains(f)) continue;
                this.supFunctionsList.add(fct);
                result.add(f);
            }
        }
        Iterator<IVirtualFunction> itf = result.iterator();
        ArrayList<IVirtualFunction> toDelete = new ArrayList<IVirtualFunction>();
        while (itf.hasNext()) {
            f = itf.next();
            if (!this.specialFunctionsNotToCreate.contains(f.getCobolName())) continue;
            toDelete.add(f);
        }
        result.removeAll(toDelete);
        return result;
    }

    private List<IVirtualFunction> instanciateOverridedFunctions(IEditTree editTree) {
        ArrayList<IVirtualFunction> l = new ArrayList<IVirtualFunction>();
        ITextNode tnRoot = editTree.nodeFromTagName("PROCEDURE");
        if (tnRoot == null) {
            return Collections.emptyList();
        }
        Iterator ittn = tnRoot.sons();
        while (ittn.hasNext()) {
            ITextNode tn = (ITextNode)ittn.next();
            if (tn == null || !"true".equals(tn.getProperties().getProperty("functionOverridedBySpecific"))) continue;
            if (tn.text().length() == 0) {
                this.createSUPfunction(tn);
                continue;
            }
            IVirtualFunction f = this.createFunction(tn);
            if (f == null) continue;
            l.add(f);
        }
        return l;
    }

    public List<String> getSpecificDash900() {
        return this.dash900List;
    }

    public List<String> getSpecificSUPfunctions() {
        return this.supFunctionsList;
    }

    private List<IVirtualFunction> getSpecificSubFunctionsFrom(ITextNode textNode, EditTreeFilter editTreeFilter) {
        ArrayList<IVirtualFunction> l = new ArrayList<IVirtualFunction>();
        if (editTreeFilter == null || textNode == null) {
            return l;
        }
        Iterator it = editTreeFilter.sons(textNode);
        while (it.hasNext()) {
            ITextNode current = (ITextNode)it.next();
            IVirtualFunction f = this.convertOneTextNodeToFunction(current);
            if (f != null && !this.functionCodes.contains(f.getCobolName())) {
                l.add(f);
                this.functionCodes.add(f.getCobolName());
            }
            l.addAll(this.getSpecificSubFunctionsFrom(current, editTreeFilter));
        }
        return l;
    }

    public IVirtualFunction convertOneTextNodeToFunction(ITextNode textNode) {
        ITagProperties prop;
        TextStatus status = textNode.getTextStatus();
        String functionCode = textNode.getLabel().toString();
        if (this.functionCodes.contains(functionCode) || functionCode.charAt(0) != 'F') {
            return null;
        }
        if (this.newLine == null) {
            this.newLine = PdpTool.determineDelimiterOfV2((CharSequence)textNode.text());
        }
        if (status == TextStatus.Inserted) {
            if (textNode.isSyntacticTag()) {
                prop = textNode.getProperties();
                if ("pac_function".equals(prop.getProperty("category"))) {
                    PdpFunction f = new PdpFunction();
                    f.cobolName = functionCode;
                    String lev = prop.getProperty("level");
                    if (lev == null) {
                        return null;
                    }
                    f.level = Float.parseFloat(lev);
                    String condition = PacTool.getFunctionCondition(functionCode, textNode, true);
                    f.condition = FunctionUtilities.ConvertCondition(condition);
                    String dash900 = PacTool.getDash900ForFunction(functionCode, textNode.text().toString());
                    if (dash900 != null) {
                        this.dash900List.add(dash900);
                    }
                    this.detectAndModifyRelativePositionningInformations(f, textNode);
                    return f;
                }
            } else {
                return this.takeIntoAccountSUPfunctions(textNode);
            }
        }
        if (status == TextStatus.Deleted) {
            if (textNode.isGeneratedTag()) {
                ITagProperties prop2;
                String levGen = PacTool.getFunctionLevel(functionCode, textNode.generatedText().toString());
                if (levGen == null && (levGen = (prop2 = textNode.getProperties()).getProperty("level")) == null) {
                    return null;
                }
                if (functionCode.length() > 3 && this.allFunctionsOverrideGenerated.contains(functionCode.substring(0, 3))) {
                    return null;
                }
                if (functionCode.length() > 5 && functionCode.contains("-")) {
                    String ref = functionCode.substring(functionCode.indexOf("-") + 1);
                    String chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890";
                    String subFctCode = "";
                    do {
                        int x = 0;
                        while (x < 2) {
                            int i = (int)Math.floor(Math.random() * 36.0);
                            subFctCode = String.valueOf(subFctCode) + chars.charAt(i);
                            ++x;
                        }
                    } while (textNode.getEditTree().nodeFromTagName(subFctCode) != null);
                    functionCode = String.valueOf(functionCode.substring(0, 3)) + subFctCode;
                    ITagProperties prop3 = textNode.getProperties();
                    PdpFunction f = new PdpFunction();
                    f.cobolName = functionCode;
                    String lev = prop3.getProperty("level");
                    if (lev == null) {
                        return null;
                    }
                    f.level = Float.parseFloat(lev);
                    f.condition = "SUP";
                    if (5.0 != (double)f.level) {
                        f.level = 99.0f;
                    }
                    f.setReference(ref);
                    f.setlocation(Location.REPLACE);
                    return f;
                }
                return this.createSUPfunction(textNode);
            }
            if (functionCode.length() > 3 && this.allFunctionsOverrideGenerated.contains(functionCode.substring(0, 3))) {
                return null;
            }
            return this.takeIntoAccountSUPfunctions(textNode);
        }
        if ((status == TextStatus.Reformated || status == TextStatus.Unchanged) && textNode.isGeneratedTag()) {
            String dash900Gen;
            String dash900Spe;
            String conditionSpe;
            prop = textNode.getProperties();
            String propLevel = prop.getProperty("level");
            propLevel = this.modifyLevelDependingOnpatternAndFunction(textNode, propLevel);
            while (prop != null && propLevel == null) {
                if ((textNode = textNode.parentNode()) != null) {
                    prop = textNode.getProperties();
                    propLevel = prop.getProperty("level");
                    continue;
                }
                prop = null;
            }
            if (textNode == null) {
                return null;
            }
            functionCode = textNode.getLabel().toString();
            if (this.functionCodes.contains(functionCode = this.convertFunctionCode(functionCode))) {
                return null;
            }
            boolean generatedFunction = false;
            String levGen = PacTool.getFunctionLevel(functionCode, textNode.generatedText().toString());
            if ((levGen == null && prop.getProperty("msp") == null || "artificialCreate".equals(prop.getProperty("msp"))) && propLevel != null) {
                levGen = propLevel;
                generatedFunction = true;
                if (functionCode.length() == 3 && FunctionUtilities.isThereOverrideBetweenFunction(functionCode, textNode, this.newLine)) {
                    this.allFunctionsOverrideGenerated.add(functionCode);
                }
            }
            if (levGen == null) {
                return null;
            }
            String levSpe = PacTool.getFunctionLevel(functionCode, textNode.text().toString());
            if (levSpe == null) {
                if (textNode.text().length() == 0) {
                    if (functionCode.length() > 3 && this.allFunctionsOverrideGenerated.contains(functionCode.substring(0, 3))) {
                        return null;
                    }
                    if (textNode.generatedText().length() > 0) {
                        FunctionInformations fi = PacTool.getFunctionInformations(functionCode, textNode, false);
                        if (fi != null && functionCode.equals(fi.getName())) {
                            if (functionCode.length() == 3 && prop.getProperty("msp") == null) {
                                this.allFunctionsOverrideGenerated.add(functionCode);
                            }
                            IVirtualFunction f = this.createSUPfunction(textNode);
                            return f;
                        }
                        if ("artificialCreate".equals(prop.getProperty("msp")) || FunctionUtilities.IsCOAsubFunction(textNode)) {
                            IVirtualFunction f = this.createSUPfunction(textNode);
                            return f;
                        }
                        return null;
                    }
                    return null;
                }
                if ("artificialCreate".equals(prop.getProperty("msp")) && !FunctionUtilities.IsFirstLineWithCOA(textNode.generatedText().toString())) {
                    IVirtualFunction f = this.createSUPfunction(textNode);
                    return f;
                }
                if (prop.getProperty("msp") == null && functionCode.length() != 3 && status != TextStatus.Unchanged && PacTool.getFunctionInformations(functionCode, textNode, true) == null) {
                    boolean subFunctionToErase;
                    boolean isSpecialGeneratedSubFunction = this.currentPattern.equals("com.ibm.pdp.pacbase.dialog") && "F3999".equals(functionCode);
                    boolean bl = subFunctionToErase = "05".equals(levGen) && functionCode.length() == 3 || !"05".equals(levGen) && functionCode.length() == 5;
                    if (isSpecialGeneratedSubFunction || subFunctionToErase && PacTool.getFunctionInformations(functionCode, textNode, false) != null) {
                        IVirtualFunction f = this.createSUPfunction(textNode);
                        return f;
                    }
                }
                return null;
            }
            String conditionGen = PacTool.getFunctionCondition(functionCode, textNode, false);
            if (conditionGen == null || generatedFunction) {
                conditionGen = "";
            }
            if ((conditionSpe = PacTool.getFunctionCondition(functionCode, textNode, true)) == null) {
                conditionSpe = "";
            }
            if ((dash900Spe = PacTool.getDash900ForFunction(functionCode, textNode.text().toString())) != null && !dash900Spe.equals(dash900Gen = PacTool.getDash900ForFunction(functionCode, textNode.generatedText().toString()))) {
                this.dash900List.add(dash900Spe);
            }
            PdpFunction f = new PdpFunction();
            f.cobolName = functionCode;
            f.level = Float.parseFloat(levSpe);
            f.condition = FunctionUtilities.ConvertCondition(conditionSpe);
            this.detectAndModifyRelativePositionningInformations(f, textNode);
            if (!levGen.equals(levSpe) || !conditionGen.equals(conditionSpe) || this.isSpecificOverrideGeneratedCode(functionCode) && prop.getProperty("msp") == null || this.isThereDifferencesInReferences(f, textNode) && FunctionUtilities.isThereOverrideBetweenFunction(f.getCobolName(), textNode, this.newLine) || FunctionUtilities.isThereOverrideBetweenFunction(f.getCobolName(), textNode, this.newLine)) {
                return f;
            }
            this.functionCodes.add(functionCode);
        }
        return null;
    }

    public static boolean isThereOverrideBetweenFunction(String cobolName, ITextNode textNode, String newLine) {
        IGeneratedTag tag;
        if ("true".equals(textNode.getProperties().getProperty("functionOverridedBySpecific"))) {
            return true;
        }
        String textGenerated = textNode.generatedText().toString();
        boolean isFunction = cobolName.length() == 3;
        String functionCode = "       " + cobolName;
        if (isFunction && !textGenerated.contains(String.valueOf(newLine) + functionCode + ".") && !textGenerated.startsWith(String.valueOf(functionCode) + ".") && !"artificialCreate".equals((tag = textNode.enclosingGeneratedTag()).getProperty("msp"))) {
            return false;
        }
        String textSpecific = textNode.text().toString();
        StringTokenizer stGen = new StringTokenizer(textGenerated, newLine);
        StringTokenizer stSpe = new StringTokenizer(textSpecific, newLine);
        boolean differences = false;
        boolean continu = stGen.hasMoreTokens() && stSpe.hasMoreTokens();
        while (continu && !differences) {
            String lineSpe;
            String lineGen = stGen.nextToken();
            if (lineGen.equals(lineSpe = stSpe.nextToken())) {
                if (lineGen.startsWith(functionCode)) {
                    continu = false;
                    continue;
                }
                continu = stGen.hasMoreTokens() && stSpe.hasMoreTokens();
                continue;
            }
            if (lineGen.startsWith(functionCode)) {
                if (lineGen.length() > 72) {
                    lineGen = lineGen.substring(0, 72);
                }
                lineGen = lineGen.trim();
                if (lineSpe.length() > 72) {
                    lineSpe = lineSpe.substring(0, 72);
                }
                lineSpe = lineSpe.trim();
                continu = false;
            }
            if (lineGen.equals(lineSpe)) continue;
            differences = true;
        }
        return differences;
    }

    private boolean isThereDifferencesInReferences(IVirtualFunction f, ITextNode textNode) {
        String genRef;
        IGeneratedTag tag = textNode.enclosingGeneratedTag();
        String genLocString = tag.getProperty("action");
        Location genLoc = null;
        if (genLocString != null) {
            if ("*A".equals(genLocString)) {
                genLoc = Location.BEFORE;
            } else if ("*P".equals(genLocString)) {
                genLoc = Location.AFTER;
            } else if ("*R".equals(genLocString)) {
                genLoc = Location.REPLACE;
            } else if ("*B".equals(genLocString)) {
                genLoc = Location.BEGINNING;
            }
        }
        if ((genRef = tag.getProperty("ref")) == null) {
            genRef = "";
        }
        Location speLoc = f.getLocation();
        String speRef = f.getReference();
        if (speRef == null) {
            speRef = "";
        }
        return !genRef.equals(speRef) || genLoc != speLoc;
    }

    private IVirtualFunction createFunction(ITextNode textNode) {
        IGeneratedTag tag = textNode.enclosingGeneratedTag();
        String lev = this.modifyLevelDependingOnpatternAndFunction(textNode, tag.getProperty("level"));
        if (lev == null) {
            tag = textNode.enclosingGeneratedTag().getParent();
            lev = this.modifyLevelDependingOnpatternAndFunction(textNode, tag.getProperty("level"));
        }
        if (lev == null) {
            return null;
        }
        String functionCode = tag.getName();
        if (this.functionCodes.contains(functionCode) || this.supFunctionsToCreate.containsKey(functionCode) || this.doNotSUPSpecialFunctionInPattern(functionCode)) {
            return null;
        }
        PdpFunction f = new PdpFunction();
        f.cobolName = functionCode;
        f.level = Float.parseFloat(lev);
        return f;
    }

    private IVirtualFunction createSUPfunction(ITextNode textNode) {
        PdpFunction f = (PdpFunction)this.createFunction(textNode);
        if (f == null) {
            return null;
        }
        f.condition = "SUP";
        if (5.0 != (double)f.level) {
            f.level = 99.0f;
        }
        this.supFunctionsToCreate.put(f.cobolName, f);
        return f;
    }

    private IVirtualFunction takeIntoAccountSUPfunctions(ITextNode textNode) {
        IGeneratedTag tag = textNode.enclosingGeneratedTag();
        String functionCode = tag.getName();
        if (this.supFunctionsToCreate.containsKey(functionCode)) {
            if (textNode.text().length() == 0) {
                if (this.doNotSUPSpecialFunctionInPattern(functionCode)) {
                    return null;
                }
                PdpFunction fct = (PdpFunction)this.supFunctionsToCreate.get(functionCode);
                this.supFunctionsToCreate.remove(functionCode);
                this.supFunctionsList.add(functionCode);
                return fct;
            }
            this.supFunctionsToCreate.remove(functionCode);
            return null;
        }
        return null;
    }

    private boolean doNotSUPSpecialFunctionInPattern(String functionCode) {
        return "com.ibm.pdp.pacbase.dialog".equals(this.currentPattern) && functionCode.startsWith("F80-");
    }

    private boolean isSpecificOverrideGeneratedCode(String functionCode) {
        return this.specialFunctionsOverrideSpecific.contains(functionCode);
    }

    private String modifyLevelDependingOnpatternAndFunction(ITextNode textNode, String propLevel) {
        if (this.currentPattern.equals("com.ibm.pdp.pacbase.batch") && textNode.getLabel().equals("F9099") && propLevel == null) {
            return "10";
        }
        return propLevel;
    }

    private static String ConvertCondition(String condition) {
        if (condition == null || condition.trim().length() == 0) {
            return null;
        }
        if ("IT".equals(condition) || "DC".equals(condition) || "DI".equals(condition) || "DV".equals(condition)) {
            return "IT";
        }
        return condition;
    }

    private static String ConvertLevel(float level) {
        int l = Float.valueOf(level).intValue();
        String res = null;
        res = l < 10 ? new String("0") : new String();
        res = String.valueOf(res) + String.valueOf(l);
        return res;
    }

    private String convertFunctionCode(String functionCode) {
        if (this.currentPattern.equals("com.ibm.pdp.pacbase.dialog") && functionCode.startsWith("F80")) {
            if (functionCode.equals("F80-HELP")) {
                functionCode = "F8095";
            } else if (functionCode.equals("F80-LE00")) {
                functionCode = "F8098";
            } else if (functionCode.equals("F80-OKKO")) {
                functionCode = "F8099";
            }
        }
        return functionCode;
    }

    public static StringBuilder WriteCommentFor(String fct, String newLine) {
        StringBuilder sb = new StringBuilder();
        sb.append("000   *N");
        sb.append(fct.substring(1));
        if (fct.trim().length() == 3) {
            sb.append(".      NOTE *************************************.");
            sb.append(newLine);
            sb.append("      *               *                                   *");
            sb.append(newLine);
            sb.append("      *               *FUNCTION FROM VIRTUAL MACRO        *");
            sb.append(newLine);
            sb.append("      *               *                                   *");
            sb.append(newLine);
            sb.append("      *               *************************************.");
        } else {
            sb.append(".    NOTE *FUNCTION FROM VIRTUAL MACRO        *.");
        }
        sb.append(newLine);
        return sb;
    }

    public static StringBuilder WriteFunction(IVirtualFunction function, String newLine) {
        StringBuilder sb = new StringBuilder();
        sb.append(function.getCobolName());
        sb.append(newLine);
        sb.append((CharSequence)FunctionUtilities.WriteCommentFor(function.getCobolName(), newLine));
        sb.append("      *");
        String functionType = function.getCondition();
        if (functionType != null && functionType.trim().length() > 0 && !"SUP".equals(functionType)) {
            sb.append(functionType);
            sb.append(" ");
        }
        sb.append("LV=");
        sb.append(FunctionUtilities.ConvertLevel(function.getLevel()));
        if (function.getReference() != null && function.getReference().trim().length() > 0) {
            if (function.getLevel() == 5.0f && (function.getReference().equals("BS") || function.getReference().equals("ES") || function.getReference().equals("SQ"))) {
                sb.append(" ACTION=*C");
                sb.append(" REF=");
                sb.append(function.getReference());
                sb.append(" ");
                String s = function.getLocation().getInsertMspName().substring(1);
                if (s.equals("A") || s.equals("P") || s.equals("R")) {
                    sb.append(function.getLocation().getInsertMspName().substring(1));
                }
            } else {
                sb.append(" ACTION=");
                sb.append(function.getLocation().getInsertMspName());
                sb.append(" REF=");
                sb.append(function.getReference());
                if (function.getProperties() != null && function.getProperties().get("ATTACH_TAG_TREATMENT_IN_STAR_FUNCTION") != null) {
                    sb.append(" functionNotEmpty=true");
                }
            }
        }
        sb.append(newLine);
        sb.append((CharSequence)FunctionUtilities.GetSpecialLinesForFunctionType(functionType, newLine));
        return sb;
    }

    private static boolean IsFirstLineWithCOA(String text) {
        String token;
        String newLine = System.getProperty("line.separator");
        StringTokenizer st = new StringTokenizer(text, newLine);
        return st.hasMoreTokens() && (token = st.nextToken()).endsWith("COA");
    }

    public static boolean IsCOAsubFunction(ITextNode textNode) {
        String textGenerated = textNode.generatedText().toString();
        String fctCode = textNode.enclosingTagName();
        return FunctionUtilities.IsCOASubFunction(textGenerated, fctCode);
    }

    public static boolean IsCOASubFunction(String textGenerated, String fctCode) {
        String newLine = System.getProperty("line.separator");
        StringTokenizer st = new StringTokenizer(textGenerated, newLine);
        String currentString = st.nextToken();
        if (currentString.endsWith("COA")) {
            while (st.hasMoreTokens()) {
                currentString = st.nextToken();
            }
            if ((currentString = currentString.trim()).startsWith(String.valueOf(fctCode) + "-FN.")) {
                return true;
            }
        }
        return false;
    }

    private static StringBuilder GetSpecialLinesForFunctionType(String functionType, String newLine) {
        StringBuilder sb = new StringBuilder();
        if (functionType == null || functionType.trim().length() == 0 || "EL".equals(functionType)) {
            return sb;
        }
        if ("IT".equals(functionType)) {
            sb.append("                       CONDITION = VIRTUAL");
        } else if ("DU".equals(functionType)) {
            sb.append("                 IF    CONDITION = VIRTUAL");
        } else if ("DW".equals(functionType)) {
            sb.append("                       CONDITION NOT > VIRTUAL");
        } else if ("SUP".equals(functionType)) {
            sb.append("      *!SUP");
        }
        sb.append(newLine);
        return sb;
    }

    private void detectAndModifyRelativePositionningInformations(IVirtualFunction function, ITextNode textNode) {
        String text;
        if (!"com.ibm.pdp.pacbase.batch".equals(this.currentPattern) && (text = textNode.text().toString().trim()).startsWith("*")) {
            if ((text = text.substring(1)).startsWith(Location.BEFORE.getComment())) {
                function.setlocation(Location.BEFORE);
                text = text.substring(Location.BEFORE.getComment().length());
            } else if (text.startsWith(Location.REPLACE.getComment())) {
                function.setlocation(Location.REPLACE);
                text = text.substring(Location.REPLACE.getComment().length());
            } else if (text.startsWith(Location.AFTER.getComment())) {
                function.setlocation(Location.AFTER);
                text = text.substring(Location.AFTER.getComment().length());
            } else if (text.startsWith(Location.BEGINNING.getComment())) {
                function.setlocation(Location.BEGINNING);
                text = text.substring(Location.BEGINNING.getComment().length());
            }
            if (function.getLocation() != null) {
                String ref = text.substring(0, text.indexOf(this.newLine));
                function.setReference(ref.trim());
            }
        }
    }

    public String getNewLineDelimiter() {
        return this.newLine;
    }

    public void setAllFunctionsFromSPmacro(List<IVirtualFunction> allFunctionsFromSP) {
        for (IVirtualFunction pdpFunction : allFunctionsFromSP) {
            this.allFunctionsFromSPmacro.add(pdpFunction.getCobolName());
        }
    }

    public class ShowUserCodeNodesFilter
    implements ITextNodeFilter {
        public boolean skipNode(ITextNode node) {
            return node.getTextStatus().isGeneratedText() && !node.includeUserSubNode();
        }

        public boolean skipSubNodes(ITextNode node) {
            return !node.includeUserSubNode();
        }
    }
}

