/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.extension.organize;

import com.ibm.pdp.engine.IGeneratedTag;
import com.ibm.pdp.pacbase.extension.organize.FunctionsConsistencyAnalyzer;
import com.ibm.pdp.pacbase.extension.organize.IFunction;
import com.ibm.pdp.pacbase.extension.organize.Location;
import com.ibm.pdp.pacbase.extension.organize.Messages;
import com.ibm.pdp.util.Iterators;
import com.ibm.pdp.util.ObjectArrays;
import com.ibm.pdp.util.Strings;
import com.ibm.pdp.util.strings.search.SearchCursor;
import java.util.Iterator;

public class Function
implements IFunction {
    protected IGeneratedTag tag;
    protected IGeneratedTag dash900Tag;
    protected CharSequence text;
    protected String cobolName;
    protected float level;
    protected int beginIdx;
    protected int endIdx;
    protected int firstStatementBeginIdx;
    protected int firstStatementEndIdx;
    protected int lastStatementBeginIdx;
    protected int lastStatementEndIdx;
    protected int nbOfDependents;
    protected Location location;
    protected String reference;
    protected String[] marks;
    protected boolean check;
    protected int modifiedBeginIdx;
    protected int modifiedEndIdx;
    protected int specificLevel;
    private static final String[] F9099_MARKS = new String[]{" F9099.", " F9099-FN.", " F9099-ITER-FN."};
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2014, 2016.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public Function(IGeneratedTag tag, CharSequence text, float level, int beginIndex, int endIndex) {
        this.tag = tag;
        this.text = text;
        this.level = level;
        this.cobolName = tag.getName();
        this.beginIdx = beginIndex;
        this.endIdx = endIndex;
        this.firstStatementBeginIdx = -1;
        this.firstStatementEndIdx = -1;
        this.lastStatementBeginIdx = -1;
        this.lastStatementEndIdx = -1;
        this.modifiedBeginIdx = -1;
        this.modifiedEndIdx = -1;
        this.specificLevel = -1;
        this.check = true;
    }

    public Function(IGeneratedTag tag, CharSequence text, String cobolName, float level, Location loc, String reference, int firstLineBeginIndex, int firstLineEndIndex, int bodyEndIndex, int lastLineBeginIndex, int lastLineEndIndex) {
        this.tag = tag;
        this.text = text;
        this.cobolName = cobolName;
        this.level = level;
        this.location = loc;
        this.reference = reference;
        this.beginIdx = tag.getBeginIndex();
        this.endIdx = tag.getEndIndex();
        this.firstStatementBeginIdx = firstLineBeginIndex;
        this.firstStatementEndIdx = firstLineEndIndex;
        this.lastStatementBeginIdx = lastLineBeginIndex;
        this.lastStatementEndIdx = lastLineEndIndex;
        this.modifiedBeginIdx = -1;
        this.modifiedEndIdx = -1;
        this.specificLevel = -1;
        this.check = true;
    }

    @Override
    public String getTagName() {
        return this.tag.getName();
    }

    @Override
    public String getCobolName() {
        return this.cobolName;
    }

    @Override
    public int getNbOfDependents() {
        return this.nbOfDependents;
    }

    @Override
    public void setNbOfDependents(int newNbOfDependents) {
        this.nbOfDependents = newNbOfDependents;
    }

    public IGeneratedTag getTag() {
        return this.tag;
    }

    public IGeneratedTag getDash900Tag() {
        return this.dash900Tag;
    }

    public void setDash900Tag(IGeneratedTag newDash900Tag) {
        this.dash900Tag = newDash900Tag;
    }

    public void setCobolName(String newCobolName) {
        this.cobolName = newCobolName;
    }

    @Override
    public float getLevel() {
        return this.level;
    }

    @Override
    public void setLevel(float newLevel) {
        this.level = newLevel;
    }

    public int getBeginIndex() {
        return this.beginIdx;
    }

    public void setBeginIndex(int newBeginIdx) {
        this.beginIdx = newBeginIdx;
    }

    public int getEndIndex() {
        return this.endIdx;
    }

    public void setEndIndex(int newEndIdx) {
        this.endIdx = newEndIdx;
    }

    public int getFirstLineBeginIndex() {
        return this.firstStatementBeginIdx;
    }

    public void setFirstLineBeginIndex(int newFirstLineBeginIdx) {
        this.firstStatementBeginIdx = newFirstLineBeginIdx;
    }

    public int getFirstLineEndIndex() {
        return this.firstStatementEndIdx;
    }

    public void setFirstLineEndIndex(int newFirstLineEndIdx) {
        this.firstStatementEndIdx = newFirstLineEndIdx;
    }

    public int getLastLineBeginIndex() {
        return this.lastStatementBeginIdx;
    }

    public void setLastLineBeginIndex(int newLastLineBeginIdx) {
        this.lastStatementBeginIdx = newLastLineBeginIdx;
    }

    public int getLastLineEndIndex() {
        return this.lastStatementEndIdx;
    }

    public void setLastLineEndIndex(int newLastLineEndIdx) {
        this.lastStatementEndIdx = newLastLineEndIdx;
    }

    public int getModifiedBeginIndex() {
        return this.modifiedBeginIdx;
    }

    public void setModifiedBeginIndex(int newModifiedBeginIndex) {
        this.modifiedBeginIdx = newModifiedBeginIndex;
    }

    public int getModifiedEndIndex() {
        return this.modifiedEndIdx;
    }

    public void setModifiedEndIndex(int newModifiedEndIndex) {
        this.modifiedEndIdx = newModifiedEndIndex;
    }

    public int getSpecificLevel() {
        return this.specificLevel;
    }

    public void setSpecificLevel(int newSpecificLevel) {
        this.specificLevel = newSpecificLevel;
    }

    public boolean isCheck() {
        return this.check;
    }

    public void setCheck(boolean newCheck) {
        this.check = newCheck;
    }

    public int insertionIndex() {
        if (this.dash900Tag != null) {
            return this.dash900Tag.getBeginIndex();
        }
        return this.lastStatementBeginIdx >= 0 ? this.lastStatementBeginIdx : this.endIdx;
    }

    public boolean isDeleted() {
        return this.modifiedBeginIdx == -1 && this.modifiedEndIdx == -1;
    }

    public boolean foundFirstLine() {
        return this.firstStatementBeginIdx >= 0;
    }

    public boolean foundLastLine() {
        return this.lastStatementBeginIdx >= 0;
    }

    public boolean isFunction() {
        return this.level < 5.1f && this.level > 4.9f;
    }

    public boolean isModificationValid() {
        if (this.modifiedBeginIdx == -1 || this.modifiedEndIdx == -1) {
            return this.modifiedBeginIdx == -1 && this.modifiedEndIdx == -1;
        }
        return this.modifiedBeginIdx < this.modifiedEndIdx;
    }

    public void shiftAllIndexes(int indexShift) {
        this.beginIdx += indexShift;
        this.endIdx += indexShift;
        if (this.firstStatementBeginIdx != -1) {
            this.firstStatementBeginIdx += indexShift;
        }
        if (this.firstStatementEndIdx != -1) {
            this.firstStatementEndIdx += indexShift;
        }
        if (this.lastStatementBeginIdx != -1) {
            this.lastStatementBeginIdx += indexShift;
        }
        if (this.lastStatementEndIdx != -1) {
            this.lastStatementEndIdx += indexShift;
        }
    }

    public CharSequence text() {
        return this.text.subSequence(this.beginIdx, this.endIdx);
    }

    public CharSequence firstLine() {
        if (this.firstStatementBeginIdx == -1 || this.firstStatementEndIdx == -1) {
            return "";
        }
        return this.text.subSequence(this.firstStatementBeginIdx, this.firstStatementEndIdx);
    }

    public CharSequence lastLine() {
        if (this.lastStatementBeginIdx == -1 || this.lastStatementEndIdx == -1) {
            return "";
        }
        return this.text.subSequence(this.lastStatementBeginIdx, this.endIdx);
    }

    public String toString() {
        if (this.tag == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder(this.tag.getName().length() + 6);
        builder.append(this.tag.getName());
        if (this.level != 0.0f) {
            builder.append(" LV").append(this.level);
        }
        return builder.toString();
    }

    public String details(CharSequence text) {
        if (this.tag == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder(this.tag.getName().length() + 80);
        builder.append(this.tag.getName());
        if (this.level != 0.0f) {
            builder.append(" LV").append(this.level);
        }
        builder.append(Strings.getLineSeparator());
        if (this.firstStatementBeginIdx != -1) {
            builder.append(text.subSequence(this.firstStatementBeginIdx, this.firstStatementEndIdx));
        }
        if (this.lastStatementBeginIdx != -1) {
            builder.append(text.subSequence(this.lastStatementBeginIdx, this.lastStatementEndIdx));
        }
        return builder.toString();
    }

    @Override
    public String getReference() {
        return this.reference;
    }

    @Override
    public void setReference(String newReference) {
        this.reference = newReference;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    @Override
    public void setlocation(Location newLocation) {
        this.location = newLocation;
    }

    public boolean isSegmentSubFunction() {
        return this.getTagName().startsWith("F80") && (double)this.level > 9.0 && (double)this.level < 10.0;
    }

    public Iterator<String> marks() {
        if (this.marks == null) {
            this.marks = this.buildMarks();
        }
        return Iterators.iterator((Object[])this.marks);
    }

    protected String[] buildMarks() {
        if (this.cobolName == null) {
            return ObjectArrays.EMPTY_STRING_ARRAY;
        }
        if (this.tag.getName().equals("F9099")) {
            return F9099_MARKS;
        }
        if ((this.cobolName.startsWith("F01") || this.cobolName.startsWith("F10")) && this.cobolName.indexOf("-10") > 0) {
            return new String[]{" " + this.cobolName + ".", " " + this.tag.getName() + ".", " " + this.tag.getName() + "-FN."};
        }
        if (this.firstStatementBeginIdx == -1) {
            return new String[]{" " + this.cobolName + "-FN."};
        }
        if (this.lastStatementBeginIdx == -1) {
            return new String[]{" " + this.cobolName + "."};
        }
        return new String[]{" " + this.cobolName + ".", " " + this.cobolName + "-FN."};
    }

    public String endMark() {
        Iterator<String> marks = this.marks();
        while (marks.hasNext()) {
            String mark = marks.next();
            if (!mark.endsWith("-FN.")) continue;
            return mark.trim();
        }
        return null;
    }

    public boolean handleMark(SearchCursor<Function> cursor) {
        int endIdx;
        int beginIdx;
        CharSequence searchedText = cursor.getSequenceToScan();
        if (!Function.isValidCobolTagColumn(searchedText, (beginIdx = cursor.getSubSequenceBeginIndex()) + 1, endIdx = cursor.getSubSequenceEndIndex())) {
            return true;
        }
        if (Function.isFnTag(searchedText, beginIdx, endIdx)) {
            if (this.check && this.modifiedEndIdx >= 0) {
                return FunctionsConsistencyAnalyzer.trace(this.tag.getName(), Messages.FOUND_SEVERAL_END_TAGS);
            }
            if (this.tag.getName().equals("F9099") && Function.isIterFn(searchedText, beginIdx, endIdx)) {
                if (this.check && this.modifiedBeginIdx != -1) {
                    return FunctionsConsistencyAnalyzer.trace(this.tag.getName(), Messages.FOUND_BOTH_F9099);
                }
                if (this.check && this.modifiedEndIdx != -1) {
                    return FunctionsConsistencyAnalyzer.trace(this.tag.getName(), Messages.FOUND_BOTH_F9099);
                }
                this.modifiedBeginIdx = beginIdx;
                if (this.specificLevel != -1) {
                    this.setSpecificLevel(Function.extractSpecificLevel(searchedText, beginIdx));
                }
            }
            this.modifiedEndIdx = endIdx;
        } else if (!Function.hasCoaAtEndOfLine(searchedText, beginIdx + 1)) {
            if (this.modifiedBeginIdx != -1) {
                if (this.check && !this.tag.getName().equals("F50") && !this.tag.getName().equals("F05") && !this.twoConsecutiveLines(searchedText, beginIdx, this.modifiedBeginIdx)) {
                    return FunctionsConsistencyAnalyzer.trace(this.tag.getName(), Messages.FOUND_SEVERAL_BEGIN_TAGS);
                }
                if (beginIdx < this.modifiedBeginIdx) {
                    this.modifiedBeginIdx = beginIdx;
                    this.setSpecificLevel(Function.extractSpecificLevel(searchedText, beginIdx));
                }
            } else {
                this.modifiedBeginIdx = beginIdx;
                this.setSpecificLevel(Function.extractSpecificLevel(searchedText, beginIdx));
            }
        }
        return true;
    }

    protected boolean twoConsecutiveLines(CharSequence text, int index1, int index2) {
        if (index1 == index2) {
            return true;
        }
        if (index1 > index2) {
            int tmp = index1;
            index1 = index2;
            index2 = tmp;
        }
        if (index2 - index1 > 100) {
            return false;
        }
        boolean foundN = false;
        boolean foundR = false;
        int i = index1;
        while (i < index2) {
            char c = text.charAt(i);
            if (c == '\n') {
                if (foundN) {
                    return false;
                }
                foundN = true;
            } else if (c == '\r') {
                if (foundR) {
                    return false;
                }
                foundR = true;
            }
            ++i;
        }
        return foundN || foundR;
    }

    protected static boolean isValidCobolTagColumn(CharSequence text, int beginIdx, int endIdx) {
        int column = Function.computeColumn(beginIdx, text);
        if (column < 8 || column > 11) {
            return false;
        }
        int idx = beginIdx;
        while (--idx >= 0) {
            char c = text.charAt(idx);
            if (c == '\n' || c == '\r') {
                return true;
            }
            if (c == ' ') continue;
            return false;
        }
        return true;
    }

    protected static boolean isMiddleArea(int column) {
        return column > 7 && column < 73;
    }

    protected static boolean isFnTag(CharSequence text, int beginIdx, int endIdx) {
        if (endIdx - beginIdx < 8) {
            return false;
        }
        return text.charAt(endIdx - 4) == '-' && text.charAt(endIdx - 3) == 'F' && text.charAt(endIdx - 2) == 'N';
    }

    protected static boolean isIterFn(CharSequence text, int beginIdx, int endIdx) {
        return Strings.sameSubSequences((CharSequence)text, (int)(beginIdx + 1), (CharSequence)"F9099-ITER", (int)0, (int)10);
    }

    /*
     * Unable to fully structure code
     */
    protected static boolean hasCoaAtEndOfLine(CharSequence text, int idx) {
        block6: {
            column = Function.computeColumn(idx, text);
            if (column == 0) {
                return false;
            }
            if (idx + 76 - column > text.length()) {
                return false;
            }
            if (column <= 73) ** GOTO lbl15
            idx -= column - 73;
            column = 73;
            break block6;
lbl-1000:
            // 1 sources

            {
                c = text.charAt(idx);
                if (c == '\n' || c == '\r') {
                    return false;
                }
                ++idx;
                ++column;
lbl15:
                // 2 sources

                ** while (column < 73)
            }
        }
        c = text.charAt(idx);
        if (c != 'c' && c != 'C') {
            return false;
        }
        c = text.charAt(idx + 1);
        if (c != 'o' && c != 'O') {
            return false;
        }
        c = text.charAt(idx + 2);
        return c == 'a' || c == 'A';
    }

    /*
     * Unable to fully structure code
     */
    protected static int extractSpecificLevel(CharSequence text, int idx) {
        block8: {
            column = Function.computeColumn(idx, text);
            if (column == 0) {
                return -1;
            }
            if (idx + 77 - column > text.length()) {
                return -1;
            }
            if (column <= 73) ** GOTO lbl15
            idx -= column - 73;
            column = 73;
            break block8;
lbl-1000:
            // 1 sources

            {
                c = text.charAt(idx);
                if (c == '\n' || c == '\r') {
                    return -1;
                }
                ++idx;
                ++column;
lbl15:
                // 2 sources

                ** while (column < 73)
            }
        }
        c1 = text.charAt(idx);
        if (c1 != 'l' && c1 != 'L') {
            return -1;
        }
        c2 = text.charAt(idx + 1);
        if (c2 != 'v' && c2 != 'V') {
            return -1;
        }
        c1 = text.charAt(idx + 2);
        if (c1 < '0' || c1 > '9') {
            return -1;
        }
        c2 = text.charAt(idx + 3);
        if (c2 < '0' || c2 > '9') {
            return -1;
        }
        return 10 * (c1 - 48) + c2 - 48;
    }

    protected static int computeColumn(int idx, CharSequence str) {
        int column = 0;
        while (idx >= 0) {
            char c = str.charAt(idx);
            if (c == '\n' || c == '\r') {
                return column;
            }
            ++column;
            --idx;
        }
        return column;
    }
}

