/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.extension.organize;

import com.ibm.pdp.pacbase.extension.organize.DefaultTreeHandler;
import com.ibm.pdp.pacbase.extension.organize.IFunction;
import com.ibm.pdp.pacbase.util.EBCDICCompare;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class DialogTreeHandler
extends DefaultTreeHandler {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2014, 2015.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    static final String[] generatedF80tags = new String[]{"F80-HELP", "F80-LE00", "F80-OKKO"};
    protected static final float level_50 = 5.0f;
    protected static final float level_55 = 5.5f;
    protected static final float level_95 = 9.5f;
    protected static final float level_10 = 10.0f;
    protected int indexForf;
    protected int indexForStartOfFct;
    protected int indexForEndOfFct;
    protected int indexForGeneratedTagName;
    protected int indexForNextGeneratedTagName;
    protected int indexForPreviousGeneratedTagName;
    protected boolean isParentFctExist = false;

    protected void initIndexes() {
        this.indexForEndOfFct = this.indexForStartOfFct = 0;
        this.indexForGeneratedTagName = -1;
        this.indexForNextGeneratedTagName = -1;
        this.indexForPreviousGeneratedTagName = -1;
        this.indexForf = -1;
        this.isParentFctExist = false;
    }

    @Override
    protected Comparator<IFunction> getDefaultComparator() {
        if (this.defaultComparator == null) {
            this.defaultComparator = new Comparator<IFunction>(){

                @Override
                public int compare(IFunction firstF, IFunction secondF) {
                    return EBCDICCompare.stringCompare((String)DialogTreeHandler.this.getEbcdicValueForFunction(firstF.getTagName()), (String)DialogTreeHandler.this.getEbcdicValueForFunction(secondF.getTagName()));
                }
            };
        }
        return this.defaultComparator;
    }

    private String getEbcdicValueForFunction(String tagName) {
        String newTag = tagName;
        if ("END-OF-RECEPTION".equals(tagName)) {
            newTag = "F45999";
        }
        if ("END-OF-DISPLAY".equals(tagName)) {
            newTag = "F78999";
        }
        return newTag;
    }

    @Override
    protected int getIndexForFunction(IFunction f, List<IFunction> tree, String name) {
        String functionName;
        String string = functionName = f == null ? this.getFunctionName(name) : this.getFunctionName(f.getCobolName());
        if (!this.isFunctionForRelativeLocation(functionName, null)) {
            return this.getIndexForFunctionToUpdate(f, tree, name);
        }
        if (f == null) {
            f = new DefaultTreeHandler.PrivateDefaultFunction(name, "");
        }
        this.initIndexesForSpecificPattern(f, tree, functionName);
        if (this.indexForf > 0) {
            return this.indexForf;
        }
        if (f.getCobolName().length() == 0) {
            return -1;
        }
        List<IFunction> nonGeneratedFctTree = this.getNonGeneratedFunctionsList(tree.subList(this.indexForStartOfFct, this.indexForEndOfFct + 1));
        if (f.getReference() == null || f.getReference().trim().length() == 0) {
            int index = this.searchIndexForAbsoluteLocation(f, tree, nonGeneratedFctTree);
            if (index > 0) {
                return index;
            }
            this.indexForGeneratedTagName = -1;
        }
        if (this.indexForGeneratedTagName < 0) {
            return this.searchIndexAtEndOfFunction(f, tree, nonGeneratedFctTree);
        }
        return this.searchIndexForRelativeLocation(f, tree);
    }

    protected int searchIndexForAbsoluteLocation(IFunction f, List<IFunction> tree, List<IFunction> nonGeneratedFctsTree) {
        int ind = this.getIndexForFunction(f, nonGeneratedFctsTree, "", this.getDefaultComparator());
        if (ind > 0) {
            return tree.indexOf(nonGeneratedFctsTree.get(--ind)) + 1;
        }
        return ind;
    }

    protected void initIndexesForSpecificPattern(IFunction f, List<IFunction> tree, String functionName) {
        this.initIndexes();
        this.indexForStartOfFct = this.getIndexForFunction(null, tree, functionName, this.getDefaultComparator());
        if (this.indexForStartOfFct < tree.size() && !functionName.equals(this.getFunctionName(tree.get(this.indexForStartOfFct).getCobolName()))) {
            this.indexForf = this.indexForStartOfFct;
        } else {
            this.isParentFctExist = true;
            this.indexForEndOfFct = tree.size() - 1;
            boolean isNextFound = false;
            int i = this.indexForStartOfFct;
            while (i < tree.size()) {
                if (f.getTagName().equals(tree.get(i).getTagName()) || f.getCobolName().equals(tree.get(i).getCobolName())) {
                    this.indexForf = i;
                    if (f.getCobolName().length() == 0) break;
                }
                if (this.isEndOfFunction(functionName, tree.get(i).getTagName(), tree.get(i).getCobolName())) {
                    this.indexForEndOfFct = i != this.indexForStartOfFct ? i - 1 : i;
                    if (!"F80".equals(functionName) || !this.isEndOfFunction(functionName, f.getTagName(), f.getCobolName())) break;
                }
                if (f.getReference() != null) {
                    if (this.indexForGeneratedTagName < 0) {
                        if (f.getReference().equals(tree.get(i).getTagName())) {
                            this.indexForGeneratedTagName = i;
                        } else {
                            this.indexForPreviousGeneratedTagName = i;
                        }
                    } else if (!(isNextFound || tree.get(i).getCobolName().equals(tree.get(i).getTagName()) && (tree.get(i).getReference() == null || tree.get(i).getReference().equals(f.getReference())))) {
                        this.indexForNextGeneratedTagName = i;
                        isNextFound = true;
                    }
                }
                ++i;
            }
        }
    }

    private int searchIndexAtEndOfFunction(IFunction f, List<IFunction> tree, List<IFunction> nonGeneratedFctsTree) {
        IFunction startZZFunction = this.getFirstZZFunction(tree, nonGeneratedFctsTree);
        int i = this.indexForEndOfFct + 1;
        if (startZZFunction != null) {
            i = tree.indexOf(startZZFunction);
            return i + this.getIndexForFunctionToUpdate(f, tree.subList(i, this.indexForEndOfFct), null);
        }
        return i;
    }

    protected boolean isEndForPattern(IFunction fct) {
        return this.compareFloatLevel(fct.getLevel(), 5.5f) || fct.getTagName().length() > 5 || !fct.getTagName().equals(fct.getCobolName()) || fct.getReference() != null && !"ZZ".equals(fct.getReference()) && fct.getReference().trim().length() > 0;
    }

    private int searchIndexForRelativeLocation(IFunction f, List<IFunction> tree) {
        switch (f.getLocation()) {
            case AFTER: {
                if (this.indexForNextGeneratedTagName < 0) {
                    int i = this.indexForGeneratedTagName;
                    while (i < this.indexForEndOfFct) {
                        if (EBCDICCompare.stringCompare((String)tree.get(i).getCobolName(), (String)f.getCobolName()) < 0) {
                            this.indexForNextGeneratedTagName = i;
                        }
                        ++i;
                    }
                    if (this.indexForNextGeneratedTagName < 0) {
                        this.indexForNextGeneratedTagName = this.indexForEndOfFct;
                    }
                }
                if (this.indexForNextGeneratedTagName - this.indexForGeneratedTagName < 2) {
                    return ++this.indexForGeneratedTagName;
                }
                ++this.indexForGeneratedTagName;
                return this.indexForGeneratedTagName + this.getIndexForFunction(f, tree.subList(this.indexForGeneratedTagName, this.indexForNextGeneratedTagName), "", this.getDefaultComparator());
            }
            case BEFORE: {
                if (this.indexForPreviousGeneratedTagName < 0) {
                    this.indexForPreviousGeneratedTagName = this.indexForStartOfFct;
                }
                if (this.indexForGeneratedTagName - this.indexForPreviousGeneratedTagName < 2) {
                    return this.indexForGeneratedTagName;
                }
                ++this.indexForPreviousGeneratedTagName;
                return this.indexForPreviousGeneratedTagName + this.getIndexForFunction(f, tree.subList(this.indexForPreviousGeneratedTagName, this.indexForGeneratedTagName), "", this.getDefaultComparator());
            }
            case REPLACE: {
                ArrayList<IFunction> l = new ArrayList<IFunction>();
                l.add(tree.get(this.indexForGeneratedTagName));
                if (GeneratedDialogFunction.F80.getName().equals(this.getFunctionName(f.getCobolName())) && this.compareFloatLevel(tree.get(this.indexForGeneratedTagName).getLevel(), 9.5f)) {
                    int i = this.indexForGeneratedTagName;
                    while (i < this.indexForGeneratedTagName + tree.get(this.indexForGeneratedTagName).getNbOfDependents() + 1) {
                        l.add(tree.get(i));
                        ++i;
                    }
                }
                tree.removeAll(l);
                return this.indexForGeneratedTagName;
            }
        }
        return super.getIndexForFunction(f, tree, "");
    }

    protected boolean isFunctionForRelativeLocation(String name, List<IFunction> tree) {
        GeneratedDialogFunction[] generatedFcts = GeneratedDialogFunction.values();
        int i = 0;
        while (i < generatedFcts.length) {
            if (generatedFcts[i].getName().equals(name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected List<IFunction> getNonGeneratedFunctionsList(List<IFunction> tree) {
        ArrayList<IFunction> newTree = new ArrayList<IFunction>();
        int i = 0;
        while (i < tree.size()) {
            if (!(!tree.get(i).getCobolName().equals(tree.get(i).getTagName()) || this.compareFloatLevel(tree.get(i).getLevel(), 5.5f) || this.compareFloatLevel(tree.get(i).getLevel(), new Float(9.5f).floatValue()) || tree.get(i).getCobolName().length() != 3 && tree.get(i).getCobolName().length() != 5 || this.compareFloatLevel(tree.get(i).getLevel(), 5.0f) && i < tree.size() - 1 && tree.get(i + 1).getCobolName().startsWith(tree.get(i).getCobolName()))) {
                newTree.add(tree.get(i));
            }
            ++i;
        }
        Collections.sort(newTree, this.getDefaultComparator());
        return newTree;
    }

    private boolean isEndOfFunction(String functionName, String tagName, String cobolName) {
        if (cobolName.length() > 0 && !functionName.equals(this.getFunctionName(cobolName))) {
            return true;
        }
        if (GeneratedDialogFunction.F80.getName().equals(functionName)) {
            String[] stringArray = generatedF80tags;
            int n = generatedF80tags.length;
            int n2 = 0;
            while (n2 < n) {
                String f80Tag = stringArray[n2];
                if (f80Tag.equals(tagName)) {
                    return true;
                }
                ++n2;
            }
        } else if (GeneratedDialogFunction.F25.getName().equals(functionName) && "F2599".equals(tagName)) {
            return true;
        }
        return false;
    }

    @Override
    protected void updateNbOfDependents(List<IFunction> tree, String functionName) {
        if (!this.isFunctionForRelativeLocation(functionName, tree)) {
            super.updateNbOfDependents(tree, functionName);
        } else {
            int startIndex = this.getIndexForFunctionToUpdate(null, tree, functionName);
            int endIndex = tree.size();
            int i = startIndex;
            while (i < tree.size()) {
                IFunction fct = tree.get(i);
                if (!functionName.equals(this.getFunctionName(fct.getCobolName()))) {
                    endIndex = i--;
                    break;
                }
                ++i;
            }
            List<IFunction> nonGeneratedFctTree = this.getNonGeneratedFunctionsList(tree.subList(startIndex, endIndex));
            String startZZFunction = "";
            IFunction ZZFct = this.getFirstZZFunction(tree, nonGeneratedFctTree);
            if (ZZFct != null) {
                startZZFunction = ZZFct.getCobolName();
            }
            String tagNameForCateg = "";
            boolean isLvCategExist = false;
            if (GeneratedDialogFunction.F80.getName().equals(functionName)) {
                isLvCategExist = false;
            }
            boolean endBlockStarting = false;
            int i2 = startIndex;
            while (i2 < endIndex) {
                IFunction parentFct = tree.get(i2);
                if (this.isFunctionWithSons(parentFct)) {
                    String parentRef = this.getReference(parentFct);
                    int nbDpts = 0;
                    if (parentFct.getCobolName().equals(startZZFunction) || "ZZ".equals(this.getReference(parentFct))) {
                        endBlockStarting = true;
                    }
                    if (this.compareFloatLevel(parentFct.getLevel(), 5.5f)) {
                        isLvCategExist = true;
                        tagNameForCateg = parentFct.getTagName();
                    } else if (!(GeneratedDialogFunction.F80.getName().equals(functionName) || tagNameForCateg.length() != 4 || parentFct.getTagName().length() <= 4 || parentRef.length() <= 4 || parentFct.getTagName().startsWith(tagNameForCateg) || parentRef.startsWith(tagNameForCateg))) {
                        isLvCategExist = false;
                    }
                    float level = parentFct.getLevel();
                    if (this.compareFloatLevel(level, 0.0f)) {
                        level = parentFct.getCobolName().length() == 3 ? 5.0f : 10.0f;
                    }
                    int j = i2 + 1;
                    while (j < endIndex) {
                        IFunction currentFct = tree.get(j);
                        if (level > 5.0f) {
                            if (GeneratedDialogFunction.F80.getName().equals(functionName) && (this.isEndOfFunction(functionName, currentFct.getTagName(), currentFct.getCobolName()) || "F80-HELP".equals(parentFct.getTagName()) && "F8098".equals(currentFct.getTagName()) && !(currentFct.getLevel() > 10.0f))) break;
                            if (!endBlockStarting || endBlockStarting && !isLvCategExist) {
                                if (!this.isGeneratedFunction(currentFct) && currentFct.getCobolName().equals(startZZFunction) && (!GeneratedDialogFunction.F80.getName().equals(functionName) ? isLvCategExist : currentFct.getLevel() <= 10.0f)) break;
                                String currentRef = this.getReference(currentFct);
                                if (GeneratedDialogFunction.F80.getName().equals(functionName)) {
                                    if (this.isEndOfFunction(functionName, currentFct.getTagName(), currentFct.getCobolName()) || parentRef.length() > 0 && currentRef.length() > 0 && (parentRef.length() == 8 ? !"ZZ".equals(currentRef) && !currentRef.startsWith(parentRef) || "ZZ".equals(currentRef) && currentFct.getLevel() <= 10.0f : !currentRef.equals(parentRef))) {
                                        break;
                                    }
                                } else {
                                    String currentCateg;
                                    String string = currentCateg = currentRef.indexOf("-") > 0 ? currentRef.substring(0, currentRef.indexOf("-")) : currentRef.trim();
                                    if (this.compareFloatLevel(parentFct.getLevel(), 5.5f)) {
                                        if (currentCateg.length() > 0 && !currentCateg.startsWith(tagNameForCateg)) {
                                            break;
                                        }
                                    } else {
                                        String parentCateg;
                                        String string2 = parentCateg = parentRef.indexOf("-") > 0 ? parentRef.substring(0, parentRef.indexOf("-")) : parentRef.trim();
                                        if (parentCateg.length() > 0 && currentCateg.length() > 0 && !currentCateg.startsWith(parentCateg) && !"ZZ".equals(currentCateg)) break;
                                    }
                                    if (GeneratedDialogFunction.F25.getName().equals(functionName) && isLvCategExist && this.isEndOfFunction(functionName, currentFct.getTagName(), currentFct.getCobolName())) break;
                                }
                            }
                        }
                        if (!(currentFct.getLevel() > level)) break;
                        ++nbDpts;
                        ++j;
                    }
                    parentFct.setNbOfDependents(nbDpts);
                }
                ++i2;
            }
        }
    }

    private boolean isFunctionWithSons(IFunction parentFct) {
        return parentFct.getLevel() != 6.0f || !parentFct.getCobolName().startsWith("F35A-") && !parentFct.getCobolName().startsWith("F35R-") || parentFct.getCobolName().length() != 7 || parentFct.getTagName().equals(parentFct.getCobolName());
    }

    protected IFunction getFirstZZFunction(List<IFunction> tree, List<IFunction> nonGeneratedFctsTree) {
        IFunction startZZFunction = null;
        int i = 0;
        while (i < nonGeneratedFctsTree.size()) {
            if (i == 0 && (this.getReference(nonGeneratedFctsTree.get(i)) == null || this.getReference(nonGeneratedFctsTree.get(i)).length() == 0)) {
                startZZFunction = nonGeneratedFctsTree.get(i);
                break;
            }
            if ("ZZ".equals(this.getReference(nonGeneratedFctsTree.get(i)))) {
                startZZFunction = nonGeneratedFctsTree.get(i);
                break;
            }
            ++i;
        }
        return startZZFunction;
    }

    protected boolean isGeneratedFunction(IFunction fct) {
        if (this.isFunctionForRelativeLocation(this.getFunctionName(fct.getCobolName()), null)) {
            if (this.compareFloatLevel(fct.getLevel(), 5.5f) || this.compareFloatLevel(fct.getLevel(), 9.5f)) {
                return true;
            }
            if (this.isAutomaticFunction(fct)) {
                return true;
            }
        }
        return false;
    }

    private boolean isAutomaticFunction(IFunction fct) {
        return !fct.getCobolName().equals(fct.getTagName()) || GeneratedDialogFunction.F80.getName().equals(this.getFunctionName(fct.getCobolName())) && fct.getTagName().length() > 5 && fct.getTagName().indexOf("-") == 3;
    }

    private String getReference(IFunction fct) {
        if (fct.getReference() != null) {
            return fct.getReference();
        }
        if (this.isAutomaticFunction(fct)) {
            return fct.getTagName();
        }
        return "";
    }

    private static enum GeneratedDialogFunction {
        F20("F20"),
        F25("F25"),
        F30("F30"),
        F35("F35"),
        F60("F60"),
        F65("F65"),
        F80("F80");

        String name = "";

        private GeneratedDialogFunction(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

