/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.extension.organize;

import com.ibm.pdp.pacbase.extension.organize.DefaultStatus;
import com.ibm.pdp.pacbase.extension.organize.IFunction;
import com.ibm.pdp.pacbase.extension.organize.IStatus;
import com.ibm.pdp.pacbase.extension.organize.ITreeHandler;
import com.ibm.pdp.pacbase.extension.organize.Location;
import com.ibm.pdp.pacbase.util.EBCDICCompare;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class DefaultTreeHandler
implements ITreeHandler {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2014, 2015.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    Comparator<IFunction> defaultComparator = null;
    protected static final float level_00 = 0.0f;

    @Override
    public IStatus addFunction(IFunction f, List<IFunction> tree) {
        int ind = this.getIndexForFunction(f, tree, "");
        if (ind < tree.size() && f.getCobolName().equals(tree.get(ind).getTagName())) {
            return new DefaultStatus(1, "");
        }
        tree.add(ind, f);
        this.updateNbOfDependents(tree, this.getFunctionName(f.getTagName()));
        return new DefaultStatus(0, "");
    }

    @Override
    public IStatus removeFunction(String name, List<IFunction> tree) {
        int ind = this.getIndexForFunction(null, tree, name);
        if (ind < 0 || ind == tree.size() || !name.equals(tree.get(ind).getTagName())) {
            return new DefaultStatus(2, "");
        }
        tree.remove(ind);
        this.updateNbOfDependents(tree, this.getFunctionName(name));
        return new DefaultStatus(0, "");
    }

    @Override
    public IStatus changeLevel(String name, int newLevel, List<IFunction> tree) {
        if (name.equals(this.getFunctionName(name)) && (float)newLevel != 5.0f) {
            return new DefaultStatus(0, "");
        }
        int ind = this.getIndexForFunction(null, tree, name);
        if (ind < 0 || ind == tree.size() || !name.equals(tree.get(ind).getTagName())) {
            return new DefaultStatus(2, "");
        }
        tree.get(ind).setLevel(newLevel);
        this.updateNbOfDependents(tree, this.getFunctionName(name));
        return new DefaultStatus(0, "");
    }

    protected int getIndexForFunction(IFunction f, List<IFunction> tree, String name) {
        return this.getIndexForFunction(f, tree, name, this.getDefaultComparator());
    }

    protected int getIndexForFunction(IFunction f, List<IFunction> tree, String name, Comparator<IFunction> comparator) {
        int index;
        if (f == null) {
            f = new PrivateDefaultFunction(name, name);
        }
        return (index = Collections.binarySearch(tree, f, comparator)) < 0 ? ~index : index;
    }

    protected Comparator<IFunction> getDefaultComparator() {
        if (this.defaultComparator == null) {
            this.defaultComparator = new Comparator<IFunction>(){

                @Override
                public int compare(IFunction firstF, IFunction secondF) {
                    return EBCDICCompare.stringCompare((String)firstF.getTagName(), (String)secondF.getTagName());
                }
            };
        }
        return this.defaultComparator;
    }

    protected String getFunctionName(String function) {
        return function.length() > 2 ? function.substring(0, 3) : function;
    }

    protected void updateNbOfDependents(List<IFunction> tree, String functionName) {
        int ind;
        int i = ind = this.getIndexForFunctionToUpdate(null, tree, functionName);
        while (i < tree.size()) {
            IFunction fct = tree.get(i);
            int nbDpts = 0;
            float level = fct.getLevel();
            if (this.compareFloatLevel(level, 0.0f)) {
                level = fct.getCobolName().length() == 3 ? 5.0f : 10.0f;
            }
            if (!functionName.equals(this.getFunctionName(fct.getCobolName()))) break;
            int j = i + 1;
            while (j < tree.size()) {
                IFunction fctNext = tree.get(j);
                if (functionName.equals(this.getFunctionName(fctNext.getCobolName()))) {
                    if (!(fctNext.getLevel() > level)) break;
                    ++nbDpts;
                }
                ++j;
            }
            fct.setNbOfDependents(nbDpts);
            ++i;
        }
    }

    protected int getIndexForFunctionToUpdate(IFunction f, List<IFunction> tree, String name) {
        return this.getIndexForFunction(f, tree, name, this.getDefaultComparator());
    }

    protected boolean compareFloatLevel(float level, float value) {
        return level > value - 0.1f && level < value + 0.1f;
    }

    protected class PrivateDefaultFunction
    implements IFunction {
        protected String tagName;
        protected String cobolName;

        protected PrivateDefaultFunction(String tagName, String cobolName) {
            this.tagName = tagName;
            this.cobolName = cobolName;
        }

        @Override
        public String getTagName() {
            return this.tagName;
        }

        @Override
        public String getCobolName() {
            return this.cobolName;
        }

        @Override
        public float getLevel() {
            return 0.0f;
        }

        @Override
        public void setLevel(float newLevel) {
        }

        @Override
        public int getNbOfDependents() {
            return 0;
        }

        @Override
        public void setNbOfDependents(int newNbOfDependents) {
        }

        @Override
        public String getReference() {
            return null;
        }

        @Override
        public void setReference(String reference) {
        }

        @Override
        public Location getLocation() {
            return null;
        }

        @Override
        public void setlocation(Location insertion) {
        }
    }
}

