/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.extension.organize;

import com.ibm.icu.util.StringTokenizer;
import com.ibm.pdp.engine.ITextProcessor;
import com.ibm.pdp.pacbase.extension.organize.DefaultFunction;
import com.ibm.pdp.pacbase.extension.organize.IVirtualFunction;
import com.ibm.pdp.pacbase.extension.organize.Location;
import com.ibm.pdp.pacbase.extension.organize.PdpFunction;
import com.ibm.pdp.util.Util;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.List;

public class CobolModification {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2016, 2017.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    ITextProcessor textProcessor = null;
    String pattern = null;

    public CobolModification(String pattern, ITextProcessor textProcessor) {
        this.textProcessor = textProcessor;
        this.pattern = pattern;
    }

    public String getNewCobol(List<IVirtualFunction> functionsList, List<IVirtualFunction> supFunctionsList, List<String> starCList) {
        String newLine = System.getProperty("line.separator");
        StringReader sr = new StringReader(this.textProcessor.getText().toString());
        BufferedReader br = new BufferedReader(sr);
        boolean inProc = false;
        boolean starCListOK = false;
        StringBuilder sb = new StringBuilder();
        StringBuilder sbTemp = new StringBuilder();
        try {
            String line = br.readLine();
            if (line != null) {
                do {
                    boolean bl = inProc = inProc || line.startsWith("       PROCEDURE");
                    if (inProc) {
                        if ((line = this.dealWithRightMark(line)).length() > 10 && line.substring(0, 7).trim().length() == 0 && line.charAt(7) == 'F' && !line.trim().endsWith("COA")) {
                            StringTokenizer st = new StringTokenizer(line);
                            String label = st.nextToken();
                            if (label.endsWith("-FN.")) {
                                sb.append((CharSequence)sbTemp);
                                sb.append(line);
                                sb.append(newLine);
                            } else {
                                label = label.substring(0, label.length() - 1);
                                int i = 0;
                                while (i < functionsList.size()) {
                                    PdpFunction f = (PdpFunction)functionsList.get(i);
                                    if (f.getCobolName().equals(label) && f.getLocation() != null) {
                                        if ("SUP".equals(f.getCondition())) {
                                            supFunctionsList.remove(f);
                                            break;
                                        }
                                        String comment = this.formatComment(f);
                                        sb.append(comment);
                                        sb.append(newLine);
                                        break;
                                    }
                                    ++i;
                                }
                                sb.append((CharSequence)sbTemp);
                                sb.append(line);
                                sb.append(newLine);
                            }
                            sbTemp = new StringBuilder();
                            continue;
                        }
                        if (line.startsWith("      *N")) {
                            sb.append((CharSequence)sbTemp);
                            sbTemp = new StringBuilder();
                        }
                        sbTemp.append(line);
                        sbTemp.append(newLine);
                        if (!starCListOK) {
                            int i = 0;
                            while (i < starCList.size()) {
                                String s = starCList.get(i);
                                sbTemp.append("      *@ATTACH ");
                                sbTemp.append(s);
                                sbTemp.append(newLine);
                                ++i;
                            }
                        }
                        if (!line.startsWith("       PROCEDURE") && starCListOK) continue;
                        starCListOK = true;
                        sb.append((CharSequence)sbTemp);
                        sbTemp = new StringBuilder();
                        continue;
                    }
                    sb.append(line);
                    sb.append(newLine);
                } while ((line = br.readLine()) != null);
            }
            if (sbTemp.length() > 0) {
                sb.append((CharSequence)sbTemp);
            }
        }
        catch (IOException ioe) {
            Util.rethrow((Throwable)ioe);
        }
        return sb.toString();
    }

    private String dealWithRightMark(String line) {
        if (line.length() < 73) {
            return line;
        }
        String mark = line.substring(72, line.length()).trim();
        if (mark.length() == 8 && mark.endsWith("SP")) {
            return line.substring(0, 72);
        }
        return line;
    }

    private String formatComment(DefaultFunction function) {
        StringBuilder comment = new StringBuilder("      *");
        Location[] values = Location.values();
        int i = 0;
        while (i < values.length) {
            if (values[i].equals((Object)function.getLocation())) {
                comment.append(values[i].getComment());
                break;
            }
            ++i;
        }
        comment.append(" ");
        comment.append(function.getReference());
        return comment.toString();
    }

    private String formatCommentWithTagName(DefaultFunction function) {
        String categ = "A";
        StringBuilder sb = new StringBuilder();
        StringTokenizer st = new StringTokenizer(function.getReference());
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (st.hasMoreTokens()) {
                sb.append(token);
                sb.append("-");
                continue;
            }
            if (function.getCobolName().startsWith("F80")) {
                sb.append(token);
                continue;
            }
            if (token.length() == 1) {
                categ = token;
                if (sb.length() <= 0) continue;
                sb = sb.deleteCharAt(sb.length() - 1);
                continue;
            }
            sb.append(token);
        }
        StringBuilder comment = new StringBuilder("      *");
        Location[] values = Location.values();
        int i = 0;
        while (i < values.length) {
            if (values[i].equals((Object)function.getLocation())) {
                comment.append(values[i].getComment());
                break;
            }
            ++i;
        }
        comment.append(" ");
        comment.append(function.getCobolName().substring(0, 3));
        comment.append(categ);
        if (function.getReference().length() > 0) {
            comment.append("-");
            comment.append(sb.toString());
        }
        return comment.toString();
    }
}

