/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.extension.organize;

import com.ibm.icu.util.StringTokenizer;
import com.ibm.pdp.engine.ITextProcessor;
import com.ibm.pdp.engine.TextStatus;
import com.ibm.pdp.engine.tree.IEditTree;
import com.ibm.pdp.engine.tree.ITextNode;
import com.ibm.pdp.framework.ConsistencyCheckException;
import com.ibm.pdp.framework.ControllerFactory;
import com.ibm.pdp.framework.PdpTool;
import com.ibm.pdp.framework.interfaces.IController;
import com.ibm.pdp.pacbase.PacTool;
import com.ibm.pdp.pacbase.extension.matching.BasicPacLabelRecognizer;
import com.ibm.pdp.pacbase.extension.matching.CobolLabel;
import com.ibm.pdp.pacbase.extension.organize.FunctionUtilities;
import com.ibm.pdp.pacbase.extension.organize.Messages;
import com.ibm.pdp.pacbase.extension.organize.PacRightMarginMarkerUpdateExtension;
import com.ibm.pdp.util.Util;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;

public class CobolAnalyzerGeneric {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2017, 2021.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private String NEW_LINE = System.getProperty("line.separator");
    private List<CobolError> errors = new ArrayList<CobolError>();
    private Stack<Function> etiquet = new Stack();
    private boolean inProcedure;
    protected Map<String, Integer> labelTable = new HashMap<String, Integer>();
    public static final String RESULTS_FILE_NAME = ".structureControlResults.log";
    private static String FOLDER_TXT_FILE = "/.metadata/";
    private StringBuilder sb = new StringBuilder();
    static int traceLevel = 1;

    static {
        String junit = System.getProperty("junitInvariantTest");
        if (junit == null) {
            traceLevel = 2;
        }
    }

    private void trace(CobolError ce) {
        switch (traceLevel) {
            case 2: {
                throw new ConsistencyCheckException(String.valueOf(ce.getMessage()) + " " + ce.getText());
            }
            case 1: {
                if (System.getProperty("junitInvariantTest") != null) {
                    if (ce.getText().startsWith("              MOVE ZERO TO TALLI") || ce.getText().startsWith("           INSPECT")) {
                        return;
                    }
                    if (ce.getText().endsWith("lv00") || ce.getText().endsWith("lv99")) {
                        return;
                    }
                }
                this.sb.append("*** " + ce.getMessage() + " " + ce.getText());
                this.sb.append(this.NEW_LINE);
            }
        }
    }

    public void analyze(ITextProcessor textProcessor, IController controler) {
        this.NEW_LINE = PdpTool.determineDelimiterOfV2((CharSequence)textProcessor.getText());
        if (!PacTool.isStruturedCobol(controler)) {
            return;
        }
        this.analyzeWarningsFromRightMarginChecking(controler.getResourceName());
        this.analyzeAllText(textProcessor.getText().toString());
        if (this.errors.size() > 0) {
            this.analyzeErrors(textProcessor.getEditTree());
        }
        if (this.isNestingFunctionChecking()) {
            ITextNode tn = textProcessor.getEditTree().nodeFromTagName("PROCEDURE");
            this.navigate(tn, null, this.isNestingFunctionAuthorized());
        }
        this.processErrorsFile(controler.getDesignLink().getFileId());
    }

    private void processErrorsFile(String cobolName) {
        if (traceLevel == 1 && this.sb.length() > 0) {
            String content;
            this.sb.insert(0, " ------- ANALYSE DE " + cobolName + this.NEW_LINE);
            String reportFilePath = String.valueOf(CobolAnalyzerGeneric.getWorkspaceFolder()) + FOLDER_TXT_FILE + RESULTS_FILE_NAME;
            File file = new File(reportFilePath);
            if (file.exists() && (content = PdpTool.readFileContents((String)reportFilePath)).length() > 0) {
                this.sb.append(content);
            }
            PdpTool.writeFileContents((String)this.sb.toString(), (String)reportFilePath);
        }
    }

    public static String getWorkspaceFolder() {
        return PdpTool.getWorkspaceFolder();
    }

    private void analyzeWarningsFromRightMarginChecking(String cobolFile) {
        String junit = System.getProperty("junitInvariantTest");
        if (junit != null) {
            IFile resourceFile = PdpTool.getFile((String)cobolFile);
            IController controler = ControllerFactory.getInstance().getController(cobolFile);
            PacRightMarginMarkerUpdateExtension ext = new PacRightMarginMarkerUpdateExtension();
            ext.updateMarkersOnly(controler, null, resourceFile);
        }
        IFile file = PdpTool.getFile((String)cobolFile);
        try {
            IMarker[] existingMarkers = file.findMarkers("com.ibm.pdp.pacbase.extension.organize.right_margin_problem_marker", false, 2);
            if (existingMarkers.length > 0) {
                int i = 0;
                while (i < existingMarkers.length) {
                    String label = (String)existingMarkers[i].getAttribute("LEVEL");
                    if (label != null) {
                        this.trace(this.writeError(label, CobolErrorType.Wrong_level, 0));
                    } else {
                        label = (String)existingMarkers[i].getAttribute("COA");
                        if (label != null) {
                            this.trace(this.writeError(label, CobolErrorType.Coa_Value, 0));
                        }
                    }
                    label = (String)existingMarkers[i].getAttribute("RIGHT_MARGIN_PROBLEM");
                    if (label != null) {
                        this.trace(this.writeError(label, CobolErrorType.Wrong_Value_Right_Margin, 0));
                    }
                    ++i;
                }
            }
        }
        catch (CoreException ce) {
            Util.rethrow((Throwable)ce);
        }
    }

    private void analyzeAllText(String allLines) {
        String[] its = PdpTool.splitTextIntoArrayLines((String)allLines);
        this.inProcedure = false;
        boolean lastEtiqIsFN = false;
        boolean isFreeCodeFromCoa = false;
        int index = 0;
        boolean isProcedureDivUsing = false;
        String previousLabel = "";
        boolean isNestingFunctionAuthorized = this.isNestingFunctionAuthorized();
        String[] stringArray = its;
        int n = its.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            String textAfterEtiq = "";
            if (line.length() > 80) {
                this.errors.add(this.writeError(line, CobolErrorType.Wrong_line_length, index + 1));
            }
            if (line.trim().length() > 0) {
                if (!this.inProcedure) {
                    if (line.toUpperCase().trim().startsWith("PROCEDURE DIVISION")) {
                        this.inProcedure = true;
                        if (line.contains("USING")) {
                            isProcedureDivUsing = true;
                        }
                    }
                } else {
                    String realLine;
                    String etiq = this.readEtiquet(line);
                    if (this.isEtiquet(etiq)) {
                        if (this.labelTable.containsKey(etiq)) {
                            this.errors.add(this.writeError(etiq, CobolErrorType.Duplicate_Label, this.labelTable.get(etiq) + 1));
                            this.errors.add(this.writeError(etiq, CobolErrorType.Duplicate_Label, index + 1));
                        }
                        this.stockLabelForDuplicateChecking(etiq, index);
                        isFreeCodeFromCoa = false;
                        isProcedureDivUsing = false;
                        if (this.isEtiquetFN(etiq)) {
                            textAfterEtiq = this.afterEtiquet(line);
                            lastEtiqIsFN = true;
                        } else {
                            lastEtiqIsFN = false;
                        }
                    }
                    if (this.isEtiquet(etiq) && !this.isSpecialEtiquet(etiq)) {
                        isNestingFunctionAuthorized = this.isNestingFunctionAuthorized(etiq, isNestingFunctionAuthorized);
                        if (!this.isEtiquetFN(etiq)) {
                            this.etiquet.push(new Function(etiq, index));
                        } else {
                            if (!this.etiquet.empty()) {
                                Function lastEtiquetStack = this.etiquet.peek();
                                String etiqWithoutFN = etiq.substring(0, etiq.length() - 3);
                                if (etiqWithoutFN.equals(lastEtiquetStack.label)) {
                                    this.etiquet.pop();
                                } else if (this.isEtiquetExistInStack(etiqWithoutFN)) {
                                    while (!this.etiquet.peek().label.equals(etiqWithoutFN)) {
                                        Function fct = this.etiquet.peek();
                                        this.errors.add(this.writeError(fct.label, CobolErrorType.Wrong_nesting_label, fct.index + 1));
                                        this.errors.add(this.writeError(fct.label, CobolErrorType.Missing_end_Label, fct.index + 1));
                                        this.etiquet.pop();
                                    }
                                    this.etiquet.pop();
                                } else {
                                    boolean found = false;
                                    for (CobolError error : this.errors) {
                                        if (!error.text.equals(etiqWithoutFN) || !error.type.equals((Object)CobolErrorType.Missing_end_Label)) continue;
                                        this.errors.remove(error);
                                        found = true;
                                        break;
                                    }
                                    if (!found) {
                                        this.errors.add(this.writeError(etiq, CobolErrorType.Missing_beginning_label, index + 1));
                                    }
                                }
                            } else {
                                this.errors.add(this.writeError(etiq, CobolErrorType.Missing_beginning_label, index + 1));
                            }
                            if (this.isNestingFunctionChecking() && !isNestingFunctionAuthorized && previousLabel.length() > 0 && previousLabel.length() < 9 && !previousLabel.substring(0, 3).equals(etiq.substring(0, 3))) {
                                this.errors.add(this.writeError(String.valueOf(previousLabel) + " / " + etiq, CobolErrorType.Wrong_nesting_Function, index + 1));
                            }
                        }
                        previousLabel = etiq;
                    }
                    if (!"".equals(textAfterEtiq) && !this.isFreeCodeAlwaysAllowed(textAfterEtiq)) {
                        this.errors.add(this.writeError(String.valueOf(previousLabel) + " : " + textAfterEtiq, CobolErrorType.Free_code, index + 1));
                    }
                    if (!(this.isEtiquet(etiq) || this.isSpecialEtiquet(etiq) || line.contains("-900. GO TO") || !lastEtiqIsFN || (realLine = CobolAnalyzerGeneric.trimRight(line)).length() < 7 || realLine.length() == 7 && realLine.charAt(6) == '*' || realLine.length() > 7 && realLine.charAt(6) == '*' && realLine.charAt(7) != '!' || !this.etiquet.empty() && this.etiquet.peek().label.startsWith("F80") && line.length() > 9 && line.substring(6).startsWith("*!SQL") || isFreeCodeFromCoa || isProcedureDivUsing)) {
                        if (line.length() > 72 && line.trim().toUpperCase().endsWith("COA")) {
                            isFreeCodeFromCoa = true;
                        } else if (!this.isFreeCodeAlwaysAllowed(realLine.substring(6).trim())) {
                            this.errors.add(this.writeError(String.valueOf(previousLabel) + " : " + line, CobolErrorType.Free_code, index + 1));
                        }
                    }
                }
            }
            index = index + line.length() + this.NEW_LINE.length();
            ++n2;
        }
        if (this.etiquet.size() != 0) {
            for (Function fct : this.etiquet) {
                this.errors.add(this.writeError(fct.label, CobolErrorType.Missing_end_Label, fct.index + 1));
            }
        }
    }

    private CobolError writeError(String text, CobolErrorType type, int index) {
        CobolError err = new CobolError();
        err.text = text;
        err.type = type;
        err.index = index;
        return err;
    }

    protected void stockLabelForDuplicateChecking(String etiq, Integer ind) {
        this.labelTable.put(etiq, ind);
    }

    private boolean isEtiquetExistInStack(String etiq) {
        for (Function fct : this.etiquet) {
            if (!fct.label.equals(etiq)) continue;
            return true;
        }
        return false;
    }

    private void analyzeErrors(IEditTree ediTree) {
        String rootNodeLabel = ((ITextNode)ediTree.rootNodes().next()).getLabel().toString();
        if (rootNodeLabel.startsWith("ENTITY_")) {
            rootNodeLabel = rootNodeLabel.substring(7);
            rootNodeLabel = String.valueOf(rootNodeLabel) + "SP";
        }
        for (CobolError error : this.getErrors()) {
            ITextNode node = ediTree.includingNode(error.index, error.index);
            TextStatus status = node.getTextStatus();
            String mspCode = node.getProperties().getProperty("msp");
            boolean isMacroSP = false;
            if (mspCode != null && mspCode.equals(rootNodeLabel)) {
                isMacroSP = true;
            }
            if (node.isSyntacticTag() || status == TextStatus.Inserted || isMacroSP) {
                if (this.isReservedLabel(node.isSyntacticTag() ? node : node.parentNode(), error.text) || isMacroSP && !error.type.equals((Object)CobolErrorType.Duplicate_Label)) continue;
                this.trace(error);
                continue;
            }
            if (status != TextStatus.Modified || this.isReservedLabel(node, error.text)) continue;
            ArrayList<CobolLabel> generatedLabels = this.getLabels(node.generatedText().toString());
            ArrayList<CobolLabel> labels = this.getLabels(node.text().toString());
            if (generatedLabels.size() <= 0 || generatedLabels.size() == labels.size()) continue;
            this.trace(error);
        }
    }

    private void navigate(ITextNode textNode, String parentLevel, boolean isNestingFunctionAuthorized) {
        if (textNode == null) {
            return;
        }
        ITextNode previousNode = null;
        Iterator it = textNode.sons();
        while (it.hasNext()) {
            boolean functionDiffer;
            ITextNode current = (ITextNode)it.next();
            TextStatus status = current.getTextStatus();
            if (!current.isTagged()) continue;
            String level = PacTool.getRealLevel(current);
            String fctCode = current.getLabel().toString().substring(0, 3);
            isNestingFunctionAuthorized = this.isNestingFunctionAuthorized(fctCode, isNestingFunctionAuthorized);
            boolean bl = functionDiffer = level != null && FunctionUtilities.isThereOverrideBetweenFunction(current.getLabel().toString(), current, this.NEW_LINE);
            if (status != TextStatus.Deleted && (current.isSyntacticTag() || current.parentNode().isSyntacticTag() || functionDiffer) && level != null && !level.contains(".5")) {
                String newLevel = null;
                if (functionDiffer) {
                    newLevel = PacTool.getFunctionLevel(current.getLabel().toString(), current.text().toString());
                }
                if (newLevel != null) {
                    level = newLevel;
                    String hidden = current.getProperties().getProperty("hidden");
                    if (hidden == null || hidden.toUpperCase().equals("NO")) {
                        String previousLevel;
                        if (parentLevel != null && !(Float.parseFloat(parentLevel) < Float.parseFloat(level))) {
                            this.trace(this.writeError(current.getLabel().toString(), CobolErrorType.Wrong_nesting_label_compared_With_levels, 0));
                        }
                        if (previousNode != null && (previousLevel = PacTool.getRealLevel(previousNode)) != null && !previousLevel.contains(".5") && !this.isSpecialNode(previousNode)) {
                            if ("00".equals(previousLevel)) {
                                previousLevel = "10";
                            }
                            if ((isNestingFunctionAuthorized || fctCode.equals(previousNode.getLabel().toString().substring(0, 3))) && !this.isBeforeRelativeSubFunction(current) && Float.parseFloat(previousLevel) < Float.parseFloat(level)) {
                                this.trace(this.writeError(current.getLabel().toString(), CobolErrorType.Wrong_nesting_label_compared_With_levels, 0));
                            }
                        }
                    }
                }
            }
            this.navigate(current, level, isNestingFunctionAuthorized);
            previousNode = current;
        }
    }

    private boolean isBeforeRelativeSubFunction(ITextNode node) {
        String pos = node.getProperties().getProperty("TagPosition");
        return pos != null && "B".equals(pos);
    }

    private List<CobolError> getErrors() {
        ArrayList<CobolError> toRemove = new ArrayList<CobolError>();
        int i = 0;
        while (i < this.errors.size()) {
            int j = i + 1;
            while (j < this.errors.size()) {
                if (!this.errors.get(i).type.equals((Object)CobolErrorType.Duplicate_Label) && this.errors.get(i).text.equals(this.errors.get(j).text)) {
                    if (this.errors.get(i).type.equals((Object)CobolErrorType.Wrong_nesting_label)) {
                        toRemove.add(this.errors.get(i));
                    } else {
                        toRemove.add(this.errors.get(j));
                    }
                }
                ++j;
            }
            ++i;
        }
        this.errors.removeAll(toRemove);
        return this.errors;
    }

    protected boolean isNestingFunctionChecking() {
        return true;
    }

    protected boolean isNestingFunctionAuthorized() {
        return false;
    }

    protected boolean isNestingFunctionAuthorized(String etiq, boolean previousNestingFunctionChecking) {
        return this.isNestingFunctionAuthorized();
    }

    private boolean isReservedLabel(ITextNode tn, String label) {
        String cond;
        return (label.length() == 7 && label.endsWith("-A") || label.endsWith("-B")) && ("DU".equals(cond = PacTool.getFunctionCondition(label.substring(0, label.length() - 2), tn, true)) || "DO".equals(cond));
    }

    protected boolean isEtiquet(String etiq) {
        return etiq != null;
    }

    protected boolean isEtiquetFN(String etiq) {
        return etiq != null && etiq.endsWith("-FN");
    }

    protected boolean isSpecialEtiquet(String etiq) {
        return etiq != null && etiq.length() > 5 && (etiq.endsWith("-900") || etiq.endsWith("-A") || etiq.endsWith("-B"));
    }

    protected String readEtiquet(String line) {
        int indBeforeDot;
        if (this.inProcedure && line.length() > 7 && line.charAt(6) != '*' && line.charAt(7) == 'F' && !line.toUpperCase().endsWith("COA") && (indBeforeDot = line.indexOf(".")) != -1 && indBeforeDot > 7) {
            return line.substring(7, indBeforeDot);
        }
        return null;
    }

    protected String afterEtiquet(String line) {
        int indBeforeDot = line.indexOf(".");
        if (indBeforeDot + 1 != -1) {
            return line.substring(indBeforeDot + 1).trim();
        }
        return "";
    }

    protected boolean isFreeCodeAlwaysAllowed(String word) {
        return "EXIT.".equals(word) || "EXIT".equals(word);
    }

    private ArrayList<CobolLabel> getLabels(String text) {
        ArrayList<CobolLabel> labels = new ArrayList<CobolLabel>();
        StringTokenizer lines = new StringTokenizer(text, this.NEW_LINE);
        while (lines.hasMoreTokens()) {
            CobolLabel cobolLabel;
            String line = lines.nextToken();
            String margin = "";
            if (line.length() > 71) {
                margin = CobolAnalyzerGeneric.trimRight(line.substring(72));
            }
            if ("COA".equals(margin.toUpperCase()) || (cobolLabel = BasicPacLabelRecognizer.findCobolLabelInLine(line)) == null) continue;
            labels.add(cobolLabel);
        }
        return labels;
    }

    protected boolean isSpecialNode(ITextNode node) {
        return false;
    }

    private static String trimRight(String name) {
        int end = name.length() - 1;
        char[] value = name.toCharArray();
        while (end >= 0 && value[end] <= ' ') {
            --end;
        }
        return new String(value, 0, end + 1);
    }

    public static class CobolError {
        private String text;
        private CobolErrorType type;
        private int index;

        public String getText() {
            return this.text;
        }

        public String getMessage() {
            String message = "";
            switch (this.type) {
                case Coa_Value: {
                    message = Messages.MANDATORY_COA;
                    break;
                }
                case Duplicate_Label: {
                    message = Messages.DUPLICATE_LABEL;
                    break;
                }
                case Free_code: {
                    message = Messages.FREE_CODE;
                    break;
                }
                case Missing_beginning_label: {
                    message = Messages.MISSING_BEGINNING_LABEL;
                    break;
                }
                case Missing_end_Label: {
                    message = Messages.MISSING_END_LABEL;
                    break;
                }
                case Wrong_nesting_label: {
                    message = Messages.WRONG_NESTING;
                    break;
                }
                case Wrong_nesting_label_compared_With_levels: {
                    message = Messages.WRONG_NESTING_WITH_LEVELS;
                    break;
                }
                case Wrong_level: {
                    message = Messages.WRONG_LEVEL;
                    break;
                }
                case Wrong_nesting_Function: {
                    message = Messages.WRONG_NESTING_FUNCTION;
                    break;
                }
                case Wrong_line_length: {
                    message = Messages.WRONG_LINE_LENGTH;
                    break;
                }
            }
            return message;
        }
    }

    public static enum CobolErrorType {
        Coa_Value,
        Duplicate_Label,
        Free_code,
        Missing_beginning_label,
        Missing_end_Label,
        Wrong_nesting_label,
        Wrong_nesting_label_compared_With_levels,
        Wrong_level,
        Wrong_nesting_Function,
        Wrong_line_length,
        Wrong_Value_Right_Margin;

    }

    public static class Function {
        String label;
        int index;

        public Function(String label, int index) {
            this.label = label;
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        public String getLabel() {
            return this.label;
        }
    }
}

