/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.extension.organize;

import com.ibm.pdp.engine.tree.ITextNode;
import com.ibm.pdp.pacbase.extension.organize.CobolAnalyzerGeneric;

public class CobolAnalyzerDialog
extends CobolAnalyzerGeneric {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2017, 2018.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    boolean firstF05 = true;
    boolean firstF50 = true;

    @Override
    protected void stockLabelForDuplicateChecking(String etiq, Integer ind) {
        if ("F05".equals(etiq)) {
            if (!this.firstF05) {
                this.labelTable.put(etiq, ind);
            } else {
                this.firstF05 = false;
            }
        } else if ("F50".equals(etiq)) {
            if (!this.firstF50) {
                this.labelTable.put(etiq, ind);
            } else {
                this.firstF50 = false;
            }
        } else {
            super.stockLabelForDuplicateChecking(etiq, ind);
        }
    }

    @Override
    protected boolean isSpecialEtiquet(String etiq) {
        boolean b = super.isSpecialEtiquet(etiq);
        if (b) {
            return true;
        }
        return etiq != null && (etiq.startsWith("F35A-") || etiq.startsWith("F35R-") || etiq.startsWith("F35Z-")) && etiq.length() == 7;
    }

    @Override
    protected boolean isSpecialNode(ITextNode node) {
        String level;
        boolean b = super.isSpecialNode(node);
        if (b) {
            return true;
        }
        String label = node.getLabel().toString();
        return (label.startsWith("F35A-") || label.startsWith("F35R-") || label.startsWith("F35Z-")) && label.length() > 5 && label.length() < 12 && (level = node.getProperties().getProperty("level")) != null && "06".equals(level);
    }
}

