/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.extension.nodesview;

import com.ibm.pdp.engine.ITagProperties;
import com.ibm.pdp.engine.tree.ITextNode;
import com.ibm.pdp.explorer.model.service.PTModelService;
import com.ibm.pdp.framework.PdpTool;
import com.ibm.pdp.framework.interfaces.IGeneratedCodeStructureTreeView;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.pacbase.extension.nodesview.Messages;
import com.ibm.pdp.util.Util;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class OpenMacroEditorAction
extends Action {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2014, 2015.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    IWorkbenchPage _page;
    IGeneratedCodeStructureTreeView _view;

    public OpenMacroEditorAction(IGeneratedCodeStructureTreeView view) {
        this._view = view;
        this._page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
    }

    public String getText() {
        return Messages.OpenMacroEditorAction_OPEN_MACRO_EDITOR;
    }

    public void run() {
        String mspName;
        ITagProperties properties;
        IStructuredSelection sel = (IStructuredSelection)this._view.getSelection();
        if (sel == null) {
            return;
        }
        ITextNode textNode = (ITextNode)sel.getFirstElement();
        if (textNode.isTagged() && (properties = textNode.getProperties()) != null && (mspName = properties.getProperty("msp")) != null && !mspName.isEmpty()) {
            RadicalEntity designRoot = (RadicalEntity)this._view.getController().getDesignLink().getModelRoot();
            String type = "pacmacro";
            String designId = this.getDesignId(designRoot, mspName, type);
            try {
                PdpTool.openDesignEditorWithContext((String)designId, (String)designRoot.getProject());
            }
            catch (Exception e) {
                Util.rethrow((Throwable)e);
            }
        }
    }

    private String getDesignId(RadicalEntity radicalObject, String macroname, String type) {
        String projectName = radicalObject.getProject();
        RadicalEntity re = PTModelService.resolveResource((String)projectName, (String)"", (String)macroname, (String)type);
        String designID = re.getDesignId(re.getProject());
        return designID;
    }

    public boolean isEnabled() {
        String mspName;
        ITagProperties properties;
        IStructuredSelection sel = (IStructuredSelection)this._view.getSelection();
        if (sel == null) {
            return false;
        }
        ITextNode textNode = (ITextNode)sel.getFirstElement();
        return textNode != null && textNode.isTagged() && (properties = textNode.getProperties()) != null && (mspName = properties.getProperty("msp")) != null && !mspName.isEmpty();
    }
}

