/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.extension.nodesview;

import com.ibm.pdp.engine.IBuilderTag;
import com.ibm.pdp.engine.IGenInfoBuilder;
import com.ibm.pdp.engine.ITagProperties;
import com.ibm.pdp.engine.ITextProcessor;
import com.ibm.pdp.engine.tree.IEditTree;
import com.ibm.pdp.engine.tree.ITextNode;
import com.ibm.pdp.framework.PdpTool;
import com.ibm.pdp.framework.interfaces.IController;
import com.ibm.pdp.framework.interfaces.IGeneratedCodeStructureTreeView;
import com.ibm.pdp.framework.interfaces.IPattern;
import com.ibm.pdp.pacbase.FunctionUpdatesManager;
import com.ibm.pdp.pacbase.PacTool;
import com.ibm.pdp.pacbase.extension.nodesview.CommonWizardFunctionAction;
import com.ibm.pdp.pacbase.extension.nodesview.GsvFunctionAction;
import com.ibm.pdp.pacbase.extension.nodesview.Messages;
import com.ibm.pdp.pacbase.wizards.FunctionModel;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.part.WorkbenchPart;

public class DeleteFunctionAction
extends GsvFunctionAction {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2015, 2022.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public DeleteFunctionAction(IGeneratedCodeStructureTreeView view) {
        super(view);
        this._titleAction = Messages.DeleteSubFunction_ACTION;
    }

    public void run() {
        if (!DeleteFunctionAction.isUpdatesAuthorized(this._view.getController(), ((WorkbenchPart)this._view).getSite().getShell())) {
            return;
        }
        IPattern pattern = this._view.getController().getPattern();
        String title = " " + this._textNode.getLabel().toString();
        String question = "";
        String function = "";
        String subFunction = "";
        if (this.isAttachFunction(this._textNode)) {
            title = String.valueOf(Messages.DeleteFunction) + title;
            question = String.valueOf(question) + Messages.DeleteFunction_QUESTION;
        } else {
            String fct = this._textNode.getLabel().toString();
            function = fct.substring(1, 3);
            subFunction = fct.substring(3, fct.length());
            if (this._textNode.getLabel().length() > 3) {
                title = String.valueOf(Messages.DeleteSubFunction) + title;
                question = String.valueOf(question) + Messages.DeleteSubFunction_QUESTION;
            } else {
                title = String.valueOf(Messages.DeleteFunction) + title;
                question = String.valueOf(question) + Messages.DeleteFunction_QUESTION;
            }
        }
        String[] buttons = new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL};
        boolean isGenerationRequired = false;
        if (PacTool.isGenerationWithVirtualMacroAlreadyDone(this._view.getController().getTextProcessor().getGeneratedInfo())) {
            isGenerationRequired = CommonWizardFunctionAction.IsGenerationNeeded(pattern.getName(), function, subFunction);
            if (isGenerationRequired) {
                question = String.valueOf(question) + NEW_LINE + Messages.DeleteFunction_REQUIRED_GENERATION;
            }
            buttons = new String[]{IDialogConstants.OK_LABEL, Messages.DeleteFunction_OK_TO_GENERATE, IDialogConstants.CANCEL_LABEL};
        }
        InternalMessageDialog dialogWithToggle = this.createDialog(this._textNode, title, question, buttons, isGenerationRequired);
        boolean choice = false;
        boolean deleteDpdts = false;
        int returnCode = -1;
        if (!PacTool.isGenerationWithVirtualMacroAlreadyDone(this._view.getController().getTextProcessor().getGeneratedInfo()) && !this.isDeleteDependentsPossible(this._textNode)) {
            choice = InternalMessageDialog.openConfirm((Shell)this._view.getTreeViewer().getTree().getShell(), (String)title, (String)question);
        } else {
            String cat;
            ITagProperties properties;
            boolean viewToggle = true;
            if (this._textNode != null && this._textNode.isTagged() && (properties = this._textNode.getProperties()) != null && "ATTACH_CATEGORY".equals(cat = properties.getProperty("category"))) {
                viewToggle = false;
            }
            if (viewToggle) {
                returnCode = dialogWithToggle.open();
                if (returnCode > -1 && returnCode != 1) {
                    choice = true;
                    deleteDpdts = dialogWithToggle.getToggleState();
                }
            } else {
                choice = InternalMessageDialog.openQuestion((Shell)this._view.getTreeViewer().getTree().getShell(), (String)title, (String)question);
                deleteDpdts = false;
            }
        }
        if (choice) {
            if (PacTool.isGenerationWithVirtualMacroAlreadyDone(this._view.getController().getTextProcessor().getGeneratedInfo()) && (returnCode != 0 || CommonWizardFunctionAction.IsGenerationNeeded(pattern.getName(), function, subFunction))) {
                this.manageDeletesWithVirtualMacro(this._textNode, deleteDpdts);
            } else if (deleteDpdts && this._textNode.sons().hasNext()) {
                this.deleteFunctionWithDependents(this._textNode);
            } else {
                DeleteFunctionAction.deleteFunctionOnly(this._textNode, null);
            }
        }
    }

    private boolean isAttachFunction(ITextNode textNode) {
        String cat;
        ITagProperties properties;
        return textNode != null && textNode.isTagged() && (properties = textNode.getProperties()) != null && "ATTACH_CATEGORY".equals(cat = properties.getProperty("category"));
    }

    private boolean isDeleteDependentsPossible(ITextNode textNode) {
        boolean b = true;
        Iterator it = textNode.sons();
        while (it.hasNext() && b) {
            ITextNode tn = (ITextNode)it.next();
            if (!tn.isSyntacticTag() && tn.getProperties() != null && tn.getProperties().getProperty("mp") == null) {
                b = false;
                return b;
            }
            b = this.isDeleteDependentsPossible(tn);
        }
        return b;
    }

    private InternalMessageDialog createDialog(ITextNode textNode, String title, String question, String[] buttons, boolean isGenerationRequired) {
        InternalMessageDialog dialogWithToggle = new InternalMessageDialog(this, this._view.getTreeViewer().getTree().getShell(), title, null, question, 3, buttons, 0, Messages.Delete_WITH_DEPENDENTS, false, isGenerationRequired){};
        return dialogWithToggle;
    }

    private void deleteFunctionWithDependents(ITextNode textNode) {
        DeleteFunctionAction.removeMpTagsFromGeneratedInfo(textNode.getEditTree().getTextProcessor(), textNode.text().toString());
        textNode.getEditTree().getTextProcessor().replaceText(textNode.beginIndex(), textNode.endIndex(), (CharSequence)"");
    }

    public static String[] deleteFunction(ITextNode textNode) {
        String text = "";
        int index = textNode.beginIndex();
        StringBuilder fctText = new StringBuilder();
        if (textNode.sons().hasNext()) {
            Iterator iterator = textNode.sons();
            while (iterator.hasNext()) {
                ITextNode tn = (ITextNode)iterator.next();
                if (index < tn.beginIndex()) {
                    fctText.append(textNode.getEditTree().getTextProcessor().getText().toString().substring(index, tn.beginIndex()));
                }
                index = tn.endIndex();
                if (tn.getProperties() != null && tn.getProperties().getProperty("mp") != null) continue;
                text = String.valueOf(text) + tn.text();
            }
        }
        if (index < textNode.endIndex()) {
            fctText.append(textNode.getEditTree().getTextProcessor().getText().toString().substring(index, textNode.endIndex()));
        }
        return new String[]{text, fctText.toString()};
    }

    public static void deleteFunctionOnly(ITextNode textNode, FunctionUpdatesManager fum) {
        if (textNode.getLabel().length() > 3) {
            int beg;
            int secondBTS;
            textNode.getEditTree().rootNodes();
            String fctContent = textNode.text().toString();
            String newLine = PdpTool.determineDelimiterOfV2((CharSequence)fctContent);
            int index = fctContent.indexOf(newLine);
            String beginningToSearch = fctContent.substring(0, index);
            index = fctContent.lastIndexOf(newLine);
            index = fctContent.lastIndexOf(newLine, index - 1);
            String endToSearch = fctContent.substring(index);
            index = endToSearch.substring(newLine.length() + 7).indexOf(" ");
            endToSearch = endToSearch.substring(0, index + 7 + newLine.length());
            if (fum == null) {
                fum = new FunctionUpdatesManager(textNode.getEditTree());
            }
            FunctionModel fm = new FunctionModel(false);
            String fct = textNode.getLabel().toString().substring(1, 3);
            fm.setFunction(fct);
            fct = textNode.getLabel().toString().substring(3);
            fm.setSubFunction(fct);
            fm.setLevel("100");
            StringBuilder newText = new StringBuilder();
            newText.append(fum.changeLevelFunction(fm));
            int procDivIndex = PacTool.searchTextInText(newText.toString(), " PROCEDURE DIVISION", true, true);
            newText = newText.delete(0, procDivIndex);
            if (beginningToSearch.indexOf("lv") > 0) {
                String level = beginningToSearch.substring(beginningToSearch.indexOf("lv")).trim();
                beginningToSearch = beginningToSearch.replace(level, "lv100");
            }
            if ((secondBTS = newText.indexOf(beginningToSearch, (beg = newText.indexOf(beginningToSearch)) + 1)) > 0) {
                String debSubFct;
                int indSubFct = newText.indexOf("      " + textNode.getLabel().toString());
                if ((debSubFct = newText.substring(indSubFct -= 400, indSubFct + 80)).trim().equals(beginningToSearch.trim())) {
                    beg = indSubFct - 1;
                }
            }
            int end = newText.indexOf(endToSearch);
            end += newText.substring(end).indexOf("EXIT.");
            end = end + 5 + newLine.length();
            fctContent = newText.substring(beg, end);
            DeleteFunctionAction.removeMpTagsFromGeneratedInfo(textNode.getEditTree().getTextProcessor(), fctContent);
            textNode.getEditTree().rootNodes();
            newText.delete(beg, end);
            textNode.getEditTree().getTextProcessor().replaceText(procDivIndex, textNode.getEditTree().getTextProcessor().getTextLength(), (CharSequence)newText);
        } else {
            String[] texts = DeleteFunctionAction.deleteFunction(textNode);
            int begin = textNode.beginIndex();
            int end = textNode.endIndex();
            DeleteFunctionAction.removeMpTagsFromGeneratedInfo(textNode.getEditTree().getTextProcessor(), texts[1].toString());
            textNode.getEditTree().rootNodes();
            if (texts[0].trim().length() > 0) {
                textNode.getEditTree().getTextProcessor().replaceText(begin, end, (CharSequence)texts[0]);
            } else {
                textNode.getEditTree().getTextProcessor().replaceText(begin, end, (CharSequence)"");
            }
        }
    }

    private void manageDeletesWithVirtualMacro(ITextNode textNode, boolean deleteDpdts) {
        IController duplicateController = DeleteFunctionAction.createNewControler(this._view.getAssociatedEditor());
        String sourceText = duplicateController.getTextProcessor().getText().toString();
        IEditTree editTree = duplicateController.getTextProcessor().getEditTree();
        editTree.rootNodes();
        String[] texts = new String[]{"", ""};
        StringBuilder newText = new StringBuilder(sourceText.length());
        newText.append(sourceText.substring(0, textNode.beginIndex()));
        if (textNode.nbOfSons() == 0) {
            newText.append(sourceText.substring(textNode.endIndex()));
            texts[1] = textNode.text().toString();
        } else {
            if (!deleteDpdts) {
                texts = DeleteFunctionAction.deleteFunction(textNode);
                newText.append(texts[0]);
            } else {
                ArrayList<InternalNode> nodes = new ArrayList<InternalNode>();
                this.searchNodes(textNode, nodes);
                StringBuilder sb = new StringBuilder();
                for (InternalNode internalNode : nodes) {
                    if (!internalNode.isCodeToKeep) continue;
                    sb.append(editTree.getTextProcessor().getText().subSequence(internalNode.startIndex, internalNode.endIndex));
                }
                newText.append((CharSequence)sb);
                texts[1] = textNode.text().toString();
            }
            newText.append(sourceText.substring(textNode.endIndex()));
        }
        duplicateController.getTextProcessor().setText((CharSequence)newText);
        DeleteFunctionAction.removeMpTagsFromGeneratedInfo(duplicateController.getTextProcessor(), texts[1]);
        if (this.isGeneratedFunctionOverridenInSpecific()) {
            IGenInfoBuilder gib = duplicateController.getTextProcessor().getGeneratedInfo().toGeneratedInfoBuilder();
            IBuilderTag tag = gib.tagFromName(this._textNode.enclosingTagName());
            if (tag != null) {
                tag.setProperty("functionOverridedBySpecific", "false");
            }
            ((com.ibm.pdp.engine.internal.ITextProcessor)duplicateController.getTextProcessor()).setGeneratedInfoKeepActualText(gib.toGeneratedInfo());
        }
        if (DeleteFunctionAction.generate(duplicateController, this._view.getAssociatedEditor())) {
            this._view.getAssociatedEditor().getSelectionProvider().setSelection((ISelection)new TextSelection(textNode.beginIndex() - 3, 0));
        }
    }

    private void searchNodes(ITextNode textNode, ArrayList<InternalNode> nodes) {
        Iterator it = textNode.sons();
        boolean isCodeToKeep = false;
        boolean isSpecificMP = false;
        while (it.hasNext()) {
            ITextNode child = (ITextNode)it.next();
            if (nodes.size() > 0 && child.beginIndex() > nodes.get((int)(nodes.size() - 1)).endIndex) {
                InternalNode in = nodes.get(nodes.size() - 1);
                nodes.add(new InternalNode(String.valueOf(in.node) + "-code", in.endIndex, child.beginIndex(), textNode.isGeneratedTag()));
            }
            if (child.nbOfSons() > 0) {
                this.searchNodes(child, nodes);
                continue;
            }
            isCodeToKeep = child.isGeneratedTag();
            if (!child.isTagged() && child.parentNode().isGeneratedTag()) {
                isCodeToKeep = true;
            }
            if (child.isGeneratedTag() && child.getProperties().getProperty("mp") != null) {
                isCodeToKeep = false;
                if (textNode.isGeneratedTag() && !isSpecificMP) {
                    isCodeToKeep = true;
                }
            }
            isSpecificMP = !child.isGeneratedTag();
            nodes.add(new InternalNode(child.getLabel().toString(), child.beginIndex(), child.endIndex(), isCodeToKeep));
        }
        if (nodes.size() > 0 && textNode.endIndex() > nodes.get((int)(nodes.size() - 1)).endIndex) {
            nodes.add(new InternalNode(String.valueOf(textNode.getLabel().toString()) + "-FN", nodes.get((int)(nodes.size() - 1)).endIndex, textNode.endIndex(), textNode.isGeneratedTag()));
        }
    }

    public static void removeMpTagsFromGeneratedInfo(ITextProcessor tp, String text) {
        ArrayList<String> ids = DeleteFunctionAction.getIdsForMps(text);
        if (ids.size() == 0) {
            return;
        }
        boolean genInfoModified = false;
        IGenInfoBuilder genInfo = tp.getGeneratedInfo().toGeneratedInfoBuilder();
        int i = 0;
        while (i < ids.size()) {
            IBuilderTag tag = genInfo.tagFromName(ids.get(i));
            if (tag != null && text.indexOf(tag.getText().toString()) != -1) {
                genInfo.removeTagAndText(tag);
                genInfoModified = true;
            }
            ++i;
        }
        if (genInfoModified) {
            ((com.ibm.pdp.engine.internal.ITextProcessor)tp).setGeneratedInfoKeepActualText(genInfo.toGeneratedInfo());
        }
    }

    private static ArrayList<String> getIdsForMps(String text) {
        ArrayList<String> ids = new ArrayList<String>();
        String newLine = PdpTool.determineDelimiterOfV2((CharSequence)text);
        String[] lines = text.split(newLine);
        int i = 0;
        while (i < lines.length) {
            String line = lines[i];
            if (line.length() > 7 && line.substring(6).startsWith("*!")) {
                String mp = line.substring(8, 11);
                boolean b = true;
                String lineId = line;
                if (line.indexOf("id=") < 0) {
                    if (i < lines.length - 1) {
                        lineId = lines[i + 1];
                    }
                    if (lineId.indexOf("id=") > 0) {
                        ++i;
                    } else {
                        b = false;
                    }
                }
                if (b) {
                    StringBuilder id = new StringBuilder();
                    int end = line.substring(8).indexOf(" ");
                    id.append(line.substring(8, 8 + end));
                    id.append("_");
                    int beg = lineId.indexOf("id=") + 3;
                    end = lineId.substring(beg).indexOf(" ");
                    end = end > 0 ? beg + end : lineId.length();
                    id.append(lineId.substring(beg, end));
                    ids.add(id.toString());
                    if (mp.equals("DCF") || mp.equals("DIF") || mp.equals("DVF")) {
                        ids.add(id.append("_").append("Next").toString());
                    }
                }
            }
            ++i;
        }
        return ids;
    }

    @Override
    public boolean isEnabled() {
        boolean isEnabled = super.isEnabled();
        if (!isEnabled) {
            isEnabled = this.isGeneratedFunctionOverridenInSpecific();
        }
        if (!isEnabled) {
            return this.isEnabledBecauseOfAttach(this._view.getController().getPattern().getName());
        }
        return isEnabled;
    }

    protected class InternalMessageDialog
    extends MessageDialogWithToggle {
        boolean isGenerationRequired;
        String initialMessage;

        protected InternalMessageDialog(Shell parentShell, String dialogTitle, Image image, String message, int dialogImageType, String[] dialogButtonLabels, int defaultIndex, String toggleMessage, boolean toggleState, boolean isGenerationRequired) {
            super(parentShell, dialogTitle, image, message, dialogImageType, dialogButtonLabels, defaultIndex, toggleMessage, toggleState);
            this.isGenerationRequired = false;
            this.isGenerationRequired = isGenerationRequired;
            this.initialMessage = message;
        }

        protected Control createButtonBar(Composite parent) {
            Control c = super.createButtonBar(parent);
            if (this.isGenerationRequired) {
                this.getButton(0).setEnabled(false);
            }
            return c;
        }

        protected Button createToggleButton(Composite parent) {
            Button withDpts = super.createToggleButton(parent);
            withDpts.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    super.widgetSelected(e);
                    if (!InternalMessageDialog.this.isGenerationRequired) {
                        InternalMessageDialog.this.getButton(0).setEnabled(true);
                        InternalMessageDialog.this.message = InternalMessageDialog.this.initialMessage;
                        if (InternalMessageDialog.this.getToggleState() && PacTool.isGenerationWithVirtualMacroAlreadyDone(((InternalMessageDialog)InternalMessageDialog.this).DeleteFunctionAction.this._view.getController().getTextProcessor().getGeneratedInfo())) {
                            InternalMessageDialog.this.getButton(0).setEnabled(false);
                            InternalMessageDialog.this.message = String.valueOf(InternalMessageDialog.this.initialMessage) + NEW_LINE + Messages.DeleteFunction_REQUIRED_GENERATION;
                        }
                        InternalMessageDialog.this.messageLabel.setText(InternalMessageDialog.this.message);
                        InternalMessageDialog.this.messageLabel.pack();
                    }
                }
            });
            return withDpts;
        }
    }

    protected class InternalNode {
        String node;
        int startIndex;
        int endIndex;
        boolean isCodeToKeep;

        protected InternalNode(String node, int start, int end, boolean isCodeToKeep) {
            this.node = node;
            this.startIndex = start;
            this.endIndex = end;
            this.isCodeToKeep = isCodeToKeep;
        }
    }
}

