/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.extension.nodesview;

import com.ibm.pdp.engine.IBuilderTag;
import com.ibm.pdp.engine.IGenInfoBuilder;
import com.ibm.pdp.engine.ITagProperties;
import com.ibm.pdp.engine.internal.ITextProcessor;
import com.ibm.pdp.engine.tree.IEditTree;
import com.ibm.pdp.engine.tree.ITextNode;
import com.ibm.pdp.framework.PdpTool;
import com.ibm.pdp.framework.interfaces.IController;
import com.ibm.pdp.framework.interfaces.IEditor;
import com.ibm.pdp.framework.interfaces.IGeneratedCodeStructureTreeView;
import com.ibm.pdp.pacbase.FunctionInformations;
import com.ibm.pdp.pacbase.FunctionText;
import com.ibm.pdp.pacbase.FunctionTextManager;
import com.ibm.pdp.pacbase.FunctionUpdatesManager;
import com.ibm.pdp.pacbase.IFunctionNode;
import com.ibm.pdp.pacbase.IFunctionText;
import com.ibm.pdp.pacbase.INodeLoader;
import com.ibm.pdp.pacbase.NodeLoader2;
import com.ibm.pdp.pacbase.NodeLoaderManager;
import com.ibm.pdp.pacbase.PacTool;
import com.ibm.pdp.pacbase.dialogs.MoveTreeDialog;
import com.ibm.pdp.pacbase.extension.Ebcdic;
import com.ibm.pdp.pacbase.extension.nodesview.DeleteFunctionAction;
import com.ibm.pdp.pacbase.extension.nodesview.GsvFunctionAction;
import com.ibm.pdp.pacbase.extension.organize.Location;
import com.ibm.pdp.pacbase.extension.organize.PdpFunction;
import com.ibm.pdp.pacbase.wizards.ActionType;
import com.ibm.pdp.pacbase.wizards.FunctionModel;
import com.ibm.pdp.pacbase.wizards.IFunctionControls;
import com.ibm.pdp.pacbase.wizards.PdpEditorFunctionControls;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.part.WorkbenchPart;

public class CopyPasteAndMoveTreeFunctionAction
extends GsvFunctionAction {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2019, 2022.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected FunctionModel _model;
    protected IEditor _editor;
    protected ActionType _actionType;
    protected IEditTree _editTree;
    protected FunctionUpdatesManager _fctUpdateManager;
    protected INodeLoader _nodeLoader;
    protected IFunctionControls _functionControls;
    protected Map<String, String> DOMap = new HashMap<String, String>();
    protected String _oldLabel;
    private static final String INDEXES_LEVEL01_BATCH = "INDICES";
    private static final String INDEXES_LEVEL01_OTHERS = "PACBASE-INDEXES";
    private static final String FUNCTION_NOT_EMPTY = "functionNotEmpty";

    public CopyPasteAndMoveTreeFunctionAction(IEditor editor, String title, IGeneratedCodeStructureTreeView view) {
        super(view);
        this._editor = editor;
        this._model = new FunctionModel(false);
        this._titleAction = title;
    }

    public CopyPasteAndMoveTreeFunctionAction(IEditor editor, String title, IGeneratedCodeStructureTreeView view, ActionType actionType) {
        super(view);
        this._editor = editor;
        this._model = new FunctionModel(false);
        this._titleAction = title;
        this._actionType = actionType;
    }

    protected void initInstanceVariables() {
        this._editTree = this._editor.getController().getTextProcessor().getEditTree();
        if (this._nodeLoader == null) {
            this._nodeLoader = this.instanciateNewNodeLoader();
            this._nodeLoader.initialize(this._editTree);
        }
        this._functionControls = new PdpEditorFunctionControls(this._editor, this._nodeLoader);
    }

    public void run() {
        if (!CopyPasteAndMoveTreeFunctionAction.isUpdatesAuthorized(this._view.getController(), ((WorkbenchPart)this._view).getSite().getShell())) {
            return;
        }
        this.initInstanceVariables();
        FunctionModel oldModel = null;
        this.updateModel();
        oldModel = new FunctionModel(false);
        oldModel.setFunction(this._model.getFunction());
        oldModel.setSubFunction(this._model.getSubFunction());
        oldModel.setCondition(this._model.getCondition());
        oldModel.setLevel(this._model.getLevel());
        oldModel.setTitles(this._model.getTitle());
        oldModel.setReference(this._model.getReference());
        oldModel.setAction(this._model.getAction());
        String label = String.valueOf(this._model.getFunction()) + this._model.getSubFunction();
        IFunctionNode fn = this._nodeLoader.getNodesMap().get("F" + label);
        Shell s = ((WorkbenchPart)this._view).getSite().getShell();
        MoveTreeDialog dialogMoveTree = new MoveTreeDialog(label, this._functionControls, s, fn, this._actionType);
        boolean choice = false;
        String targetFunction = "";
        String targetSubFunction = "";
        int returnCode = -1;
        returnCode = dialogMoveTree.open();
        if (returnCode > -1 && returnCode != 1) {
            choice = true;
            targetFunction = dialogMoveTree.get_function();
            targetSubFunction = dialogMoveTree.get_subFunction();
            this._model.setFunction(targetFunction);
            if (targetSubFunction != null) {
                this._model.setSubFunction(targetSubFunction);
            }
        }
        if (choice && returnCode == 0) {
            this._model.setGenerationRequested(true);
            this.manageUpdatesWithVirtualMacro(oldModel);
        }
    }

    protected INodeLoader instanciateNewNodeLoader() {
        HashMap<INodeLoader, IConfigurationElement> implementors = NodeLoaderManager.getNodeLoaderImplementors();
        Iterator<INodeLoader> itNodeLoader = implementors.keySet().iterator();
        String patternName = this._editor.getController().getPattern().getName();
        while (itNodeLoader.hasNext()) {
            INodeLoader nd = itNodeLoader.next();
            if (!("com.ibm.pdp.pacbase.dialog".equals(patternName) || "com.ibm.pdp.pacbase.csclient".equals(patternName) ? nd.getPattern().equals("com.ibm.pdp.pacbase.dialog") : nd.getPattern().equals(patternName))) continue;
            return nd;
        }
        return new NodeLoader2();
    }

    protected IFunctionText instanciateNewFunctionText() {
        HashMap<IFunctionText, IConfigurationElement> implementors = FunctionTextManager.getFunctionTextImplementors();
        Iterator<IFunctionText> itFunctionText = implementors.keySet().iterator();
        String patternName = this._editor.getController().getPattern().getName();
        while (itFunctionText.hasNext()) {
            IFunctionText ft = itFunctionText.next();
            if (!("com.ibm.pdp.pacbase.dialog".equals(patternName) || "com.ibm.pdp.pacbase.csclient".equals(patternName) ? ft.getPattern().equals("com.ibm.pdp.pacbase.dialog") : ft.getPattern().equals(patternName))) continue;
            return ft;
        }
        return new FunctionText();
    }

    private String getNewTextTree(String text, String label) {
        String newFunction;
        String oldLabel = label;
        String oldFunction = label.substring(0, 2);
        String targetCode = newFunction = this._model.getFunction();
        if (label.length() == 4) {
            targetCode = String.valueOf(targetCode) + this._model.getSubFunction().substring(0, 1);
        }
        String newLabel = "";
        StringBuilder newText = new StringBuilder(text.length());
        String[] lines = text.split(NEW_LINE);
        String id = "000000";
        boolean isFragmentExist = false;
        boolean header = false;
        String pattern = this._editor.getController().getPattern().getName();
        String cond = "";
        int i = 0;
        while (i < lines.length) {
            String line = lines[i];
            if (!PacTool.isSpecialPositioningComment(line, pattern, oldFunction)) {
                if (line.length() > 7 && line.substring(6).startsWith("*!")) {
                    String lineId = line;
                    if (line.indexOf("id=") < 0) {
                        if (i + 1 < lines.length) {
                            lineId = lines[i + 1];
                        }
                        newText.append(line).append(NEW_LINE);
                        if (lineId.indexOf("id=") > 0) {
                            ++i;
                        }
                    }
                    if (lineId.indexOf("id=") > 0) {
                        int beginInd = lineId.indexOf("id=");
                        int endInd = lineId.substring(beginInd + 3).indexOf(" ");
                        endInd = endInd < 0 ? lineId.length() : (endInd += beginInd + 3);
                        String idToCopy = lineId.substring(beginInd + 3, endInd);
                        id = new String(idToCopy);
                        id = "000000" + id;
                        id = id.substring(id.length() - 6);
                        newText.append(lineId.substring(0, beginInd));
                        if (this._actionType != ActionType.COPYPASTE_TREE_ACTION) {
                            newText.append("id=");
                            newText.append(idToCopy);
                        }
                        newText.append(lineId.substring(endInd, lineId.length()));
                        newText.append(NEW_LINE);
                    }
                    if (PacTool.searchTextInText(line, "\\*!DCF", true, false) != -1 || PacTool.searchTextInText(line, "\\*!DIF", true, false) != -1 || PacTool.searchTextInText(line, "\\*!DVF", true, false) != -1) {
                        isFragmentExist = true;
                    }
                } else if (!line.endsWith(id)) {
                    String tmpLine = line.trim();
                    boolean copy = true;
                    if (isFragmentExist && tmpLine.contains("NEXT")) {
                        isFragmentExist = false;
                        copy = false;
                    }
                    if (copy) {
                        if (PacTool.isSubFunctionOrFunctionComment(line) || PacTool.searchTextInText(line, " F", true, false) != -1 && line.indexOf("lv") > 71 && !header) {
                            CharSequence cs;
                            oldLabel = line.substring(10, 11).equals(".") ? line.substring(8, 10) : line.substring(8, 12);
                            int indexOsb = PacTool.searchTextInText(this._textNode.text().toString(), " F" + oldLabel, true, true);
                            int indexEndOsb = PacTool.searchTextInText(this._textNode.text().toString(), " F" + oldLabel + "-FN", true, true);
                            if (oldLabel.length() == 2) {
                                newLabel = targetCode;
                                cs = this._textNode.text().subSequence(indexOsb, indexEndOsb + 14);
                            } else {
                                newLabel = targetCode.length() == 2 ? String.valueOf(targetCode) + oldLabel.substring(2, 4) : (oldLabel.substring(2, 3).equals(label.substring(2, 3)) ? String.valueOf(targetCode) + oldLabel.substring(3, 4) : String.valueOf(newFunction) + oldLabel.substring(2, 4));
                                cs = this._textNode.text().subSequence(indexOsb, indexEndOsb + 16);
                            }
                            FunctionInformations fi = PacTool.getFunctionInformations(cs);
                            if (fi != null) {
                                cond = fi.getConditionType();
                            }
                            header = true;
                            if ("DO".equals(cond)) {
                                this.DOMap.put(oldLabel, newLabel);
                            }
                        }
                        if (header) {
                            if (oldFunction != null && newFunction != null) {
                                String newLine;
                                if (PacTool.isSubFunctionOrFunctionComment(line)) {
                                    newLine = line.replaceFirst(oldLabel, newLabel);
                                } else {
                                    newLine = line.replaceAll("F" + oldLabel, "F" + newLabel);
                                    if ("DO".equals(cond)) {
                                        newLine = newLine.replaceAll("J" + oldLabel + "R", "J" + newLabel + "R");
                                    }
                                }
                                newText.append(newLine);
                                newText.append(NEW_LINE);
                            }
                            int length = Math.min(lines[i].length(), 72);
                            if ("IT".equals(cond) || "DW".equals(cond)) {
                                if (line.charAt(6) != '*' && line.charAt(7) != 'F' && line.substring(0, length).trim().endsWith(".")) {
                                    header = false;
                                }
                            } else if ("DU".equals(cond)) {
                                int index = tmpLine.indexOf(" ");
                                String l = tmpLine.substring(0, index > 0 ? index : tmpLine.length());
                                if (l.endsWith("-B.")) {
                                    header = false;
                                }
                            } else if ("DO".equals(cond)) {
                                if (tmpLine.endsWith(String.valueOf(oldLabel) + "-FN.")) {
                                    header = false;
                                }
                            } else if (line.length() > 7 && line.substring(7).startsWith("F")) {
                                header = false;
                            }
                        } else {
                            String newLine = line;
                            if (targetCode.length() == 3) {
                                newLine = newLine.replaceAll(" F" + oldLabel.substring(0, 3), " F" + newLabel.substring(0, 3));
                                newLine = newLine.replaceAll(" F" + oldFunction, " F" + newFunction);
                            } else {
                                newLine = newLine.replaceAll(" F" + oldFunction, " F" + newFunction);
                            }
                            if ("DO".equals(cond)) {
                                newLine = newLine.replaceAll("\\(J" + oldLabel + "R", "\\(J" + newLabel + "R");
                                newLine = newLine.replaceAll("\\( J" + oldLabel + "R", "\\( J" + newLabel + "R");
                                newLine = newLine.replaceAll("J" + oldLabel + "R\\)", "J" + newLabel + "R\\)");
                                newLine = newLine.replaceAll("J" + oldLabel + "R \\)", "J" + newLabel + "R \\)");
                            }
                            newText.append(newLine).append(NEW_LINE);
                        }
                    }
                }
            }
            ++i;
        }
        return newText.toString();
    }

    private Location getLocation(String action) {
        Location[] locationArray = Location.values();
        int n = locationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Location value = locationArray[n2];
            if (action.equals(value.getInsertMspName())) {
                return value;
            }
            ++n2;
        }
        return null;
    }

    private void updateModel() {
        ITagProperties prop;
        String cat;
        if (!this.isEnabled()) {
            return;
        }
        this._model.setMoveAction(true);
        if (this._actionType == ActionType.COPYPASTE_TREE_ACTION) {
            this._model.setCopyPasteTreeAction(true);
        }
        if ("ATTACH_CATEGORY".equals(cat = (prop = this._textNode.getProperties()).getProperty("category"))) {
            this._model.setFunction(prop.getProperty("ATTACH_FUNCTION").substring(1));
            this._model.setReference(prop.getProperty("ATTACH_LOGICAL_VIEW"));
            this._model.setAction(Location.ATTACH.getInsertMspName());
            this._model.setLevel("05");
        } else {
            String function = this._textNode.getLabel().toString();
            this._model.setFunction(function.substring(1, 3));
            this._model.setSubFunction(function.substring(3, function.length()));
            String lv = prop.getProperty("level");
            if (lv != null) {
                this._model.setLevel(lv);
            }
            this._model.setCondition(PacTool.getFunctionCondition(function, this._textNode, true));
            String newLine = System.getProperty("line.separator");
            String[] lines = this._textNode.text().toString().split(newLine);
            StringBuilder sb = new StringBuilder();
            String[] stringArray = lines;
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                if (PacTool.searchTextInText(line, "\\*N", true, false) != -1) {
                    sb.append(line);
                    if (this._model.getSubFunction().length() > 0) {
                        break;
                    }
                } else {
                    if (PacTool.searchTextInText(line, "\\*", true, false) == -1) break;
                    sb.append(line);
                }
                sb.append(newLine);
                ++n2;
            }
            this._model.setFormattedTitles(sb.toString());
            String ref = prop.getProperty("TagName");
            String action = prop.getProperty("TagPosition");
            if (ref != null) {
                this._model.setReference(ref);
            }
            if (action != null) {
                if ("B".equals(action)) {
                    this._model.setAction("*A");
                }
                if ("A".equals(action)) {
                    this._model.setAction("*P");
                }
                if ("R".equals(action)) {
                    this._model.setAction("*R");
                }
            }
        }
    }

    private StringBuilder orderingAttachLines(StringBuilder text) {
        int ind2;
        String attachLine;
        String t = text.toString();
        int ind1 = t.indexOf(attachLine = "      *@ATTACH");
        if (ind1 != (ind2 = t.lastIndexOf(attachLine))) {
            StringBuilder sb = new StringBuilder(text.length());
            sb.append(text.substring(0, ind1));
            int ind3 = ind2 + t.substring(ind2).indexOf(NEW_LINE) + NEW_LINE.length();
            String textToOrder = t.substring(ind1, ind3);
            List<String> lines = Arrays.asList(textToOrder.split(NEW_LINE));
            Collections.sort(lines, this.getDefaultComparator());
            for (String line : lines) {
                sb.append(line).append(NEW_LINE);
            }
            sb.append(text.substring(ind3));
            return sb;
        }
        return text;
    }

    protected Comparator<String> getDefaultComparator() {
        Comparator<String> defaultComparator = new Comparator<String>(){

            @Override
            public int compare(String firstLine, String secondLine) {
                int indf = firstLine.indexOf("F");
                int inds = secondLine.indexOf("F");
                if (indf < 0 || inds < 0) {
                    return 0;
                }
                String firstFct = firstLine.substring(indf, indf + 3);
                String secondFct = secondLine.substring(inds, inds + 3);
                return Ebcdic.stringCompare(firstFct, secondFct);
            }
        };
        return defaultComparator;
    }

    private boolean isMoveDependentsPossible(ITextNode textNode) {
        boolean b = true;
        Iterator it = textNode.sons();
        while (it.hasNext() && b) {
            ITextNode tn = (ITextNode)it.next();
            if (!tn.isSyntacticTag() && tn.getProperties() != null && tn.getProperties().getProperty("mp") == null) {
                return false;
            }
            b = this.isMoveDependentsPossible(tn);
        }
        return b;
    }

    private boolean isRealTerminal(ITextNode textNode) {
        boolean b = true;
        Iterator it = textNode.sons();
        while (it.hasNext()) {
            ITextNode tn = (ITextNode)it.next();
            if (!tn.isSyntacticTag()) continue;
            b = false;
        }
        return b;
    }

    private void manageUpdatesWithVirtualMacro(FunctionModel oldModel) {
        IController duplicateController = CopyPasteAndMoveTreeFunctionAction.createNewControler(this._editor);
        String sourceText = duplicateController.getTextProcessor().getText().toString();
        IFunctionText functionText = this.instanciateNewFunctionText();
        float level = Integer.parseInt(this._model.getLevel());
        String name = "F" + this._model.getFunction() + this._model.getSubFunction();
        PdpFunction f = new PdpFunction(name, level, this.getLocation(this._model.getAction()), this._model.getReference(), this._model.getCondition());
        ((ITextProcessor)duplicateController.getTextProcessor()).getGlobalContext().put("Mv_subfunction_to_modify", f);
        if (this._actionType == ActionType.COPYPASTE_TREE_ACTION) {
            Iterator it = this._textNode.parentNode().sons();
            boolean isTextNodeFound = false;
            while (it.hasNext()) {
                ITextNode tn = (ITextNode)it.next();
                if (isTextNodeFound) {
                    String br = tn.getLabel().toString();
                    FunctionInformations fi = PacTool.getFunctionInformations(br, tn, true);
                    if (!"EL".equals(fi.getConditionType())) break;
                    float lev = Float.valueOf(fi.getLevel()).floatValue();
                    PdpFunction ef = new PdpFunction(br, lev, null, "", "EL");
                    ((ITextProcessor)duplicateController.getTextProcessor()).getGlobalContext().put("Mv_subfunction_el", ef);
                    break;
                }
                if (!tn.equals(this._textNode)) continue;
                isTextNodeFound = true;
            }
        }
        StringBuilder newText = new StringBuilder();
        newText.append(sourceText.substring(0, this._textNode.beginIndex()));
        functionText.setGenerateInsertComment(false);
        functionText.initialize(name, this._model.getFormattedTitle(), level, this._model.getCondition(), this._model.getReference(), this._model.getAction());
        if (this._actionType == ActionType.COPYPASTE_TREE_ACTION) {
            newText.append(this._textNode.text().toString());
        }
        String text = this.getNewTextTree(this._textNode.text().toString(), String.valueOf(oldModel.getFunction()) + oldModel.getSubFunction());
        String attach = functionText.getAttachLine();
        if (attach != null && attach.length() > 0 && this._model.getFunction().equals(oldModel.getFunction())) {
            newText.append(attach);
            if (this._textNode.text().toString().contains(FUNCTION_NOT_EMPTY)) {
                newText.append(" ").append(FUNCTION_NOT_EMPTY);
            }
            newText.append(NEW_LINE);
            if (text.length() == 0) {
                name = attach;
            }
        }
        newText.append(text);
        newText.append(sourceText.substring(this._textNode.endIndex()));
        if (this._actionType != ActionType.COPYPASTE_TREE_ACTION) {
            DeleteFunctionAction.removeMpTagsFromGeneratedInfo(duplicateController.getTextProcessor(), this._textNode.text().toString());
        }
        if (name.contains("@ATTACH")) {
            newText = this.orderingAttachLines(newText);
        }
        StringBuilder newCobol = new StringBuilder();
        String textWithNewDOIndexes = newText.toString();
        if (this.DOMap.size() != 0) {
            for (Map.Entry<String, String> line : this.DOMap.entrySet()) {
                String ol = line.getKey();
                String nl = line.getValue();
                Object[] obj = this.insertIndexForDoSubFunction(textWithNewDOIndexes, ol, nl);
                textWithNewDOIndexes = (String)obj[0];
            }
            newCobol = newCobol.append(textWithNewDOIndexes);
        } else {
            newCobol = newText;
        }
        duplicateController.getTextProcessor().setText((CharSequence)newCobol.toString());
        if (CopyPasteAndMoveTreeFunctionAction.generate(duplicateController, this._editor)) {
            ((ITextProcessor)duplicateController.getTextProcessor()).getGlobalContext().remove("Mv_subfunction_to_modify");
            int index = this._editor.getDocument().get().indexOf(name.contains("@ATTACH") ? name.trim() : String.valueOf(name) + ".");
            if (index > 0) {
                this._editor.getSelectionProvider().setSelection((ISelection)new TextSelection(index, 0));
            }
        }
    }

    public static void removeMpTagsFromGeneratedInfo(com.ibm.pdp.engine.ITextProcessor tp, String text) {
        ArrayList<String> ids = CopyPasteAndMoveTreeFunctionAction.getIdsForMps(text);
        if (ids.size() == 0) {
            return;
        }
        boolean genInfoModified = false;
        IGenInfoBuilder genInfo = tp.getGeneratedInfo().toGeneratedInfoBuilder();
        int i = 0;
        while (i < ids.size()) {
            IBuilderTag tag = genInfo.tagFromName(ids.get(i));
            if (tag != null && text.indexOf(tag.getText().toString()) != -1) {
                genInfo.removeTagAndText(tag);
                genInfoModified = true;
            }
            ++i;
        }
        if (genInfoModified) {
            ((ITextProcessor)tp).setGeneratedInfoKeepActualText(genInfo.toGeneratedInfo());
        }
    }

    private static ArrayList<String> getIdsForMps(String text) {
        ArrayList<String> ids = new ArrayList<String>();
        String newLine = PdpTool.determineDelimiterOfV2((CharSequence)text);
        String[] lines = text.split(newLine);
        int i = 0;
        while (i < lines.length) {
            String line = lines[i];
            if (line.length() > 7 && line.substring(6).startsWith("*!")) {
                boolean b = true;
                String lineId = line;
                if (line.indexOf("id=") < 0) {
                    if (i < lines.length - 1) {
                        lineId = lines[i + 1];
                    }
                    if (lineId.indexOf("id=") > 0) {
                        ++i;
                    } else {
                        b = false;
                    }
                }
                if (b) {
                    StringBuilder id = new StringBuilder();
                    int end = line.substring(8).indexOf(" ");
                    id.append(line.substring(8, 8 + end));
                    id.append("_");
                    int beg = lineId.indexOf("id=") + 3;
                    end = lineId.substring(beg).indexOf(" ");
                    end = end > 0 ? beg + end : lineId.length();
                    id.append(lineId.substring(beg, end));
                    ids.add(id.toString());
                }
            }
            ++i;
        }
        return ids;
    }

    @Override
    public boolean isEnabled() {
        boolean isEnabled = super.isEnabled();
        if (isEnabled && this._textNode.nbOfSons() == 0) {
            isEnabled = false;
        }
        if (isEnabled && !this.isMoveDependentsPossible(this._textNode)) {
            isEnabled = false;
        }
        if (isEnabled && this._textNode.nbOfSons() != 0 && this.isRealTerminal(this._textNode)) {
            isEnabled = false;
        }
        if (!isEnabled) {
            isEnabled = this.isGeneratedFunctionOverridenInSpecific();
        }
        if (!isEnabled) {
            return this.isEnabledBecauseOfAttach(this._view.getController().getPattern().getName());
        }
        return isEnabled;
    }

    protected Object[] insertIndexForDoSubFunction(String newText, String oldLabel, String newLabel) {
        int startIndex = 0;
        int endIndex = 0;
        ITextNode tn = null;
        tn = "com.ibm.pdp.pacbase.batch".equals(this._editor.getController().getPattern().getName()) ? this._textNode.getEditTree().nodeFromTagName("INDEXES") : this._textNode.getEditTree().nodeFromTagName("AA200");
        if (tn != null) {
            startIndex = tn.beginIndex();
        }
        if ((tn = this._textNode.getEditTree().nodeFromTagName("WSS-CONTINUATION")) == null) {
            return new Object[]{newText, 0};
        }
        if (startIndex == 0) {
            startIndex = tn.beginIndex();
        }
        endIndex = tn.endIndex();
        String text = newText.substring(startIndex, endIndex);
        String indexToCopy = oldLabel;
        StringBuilder sb = new StringBuilder();
        sb.append(newText.substring(0, startIndex));
        boolean found = false;
        boolean foundIndexes = false;
        String label = newLabel;
        String lineToCopy = "";
        boolean isSearchPossible = false;
        String[] lines = text.split(NEW_LINE);
        int i = 0;
        while (i < lines.length) {
            String line = lines[i];
            if (line.trim().startsWith("01") && (line.contains(INDEXES_LEVEL01_BATCH) || line.contains(INDEXES_LEVEL01_OTHERS))) {
                isSearchPossible = true;
            }
            if (isSearchPossible) {
                int index = line.indexOf("J");
                if (!found) {
                    if (index > 0 && line.substring(index + 5).startsWith("R")) {
                        foundIndexes = true;
                        String labelInLine = line.substring(index + 1, index + 5);
                        if (Ebcdic.stringCompare(labelInLine, label) == 0) {
                            return new Object[]{newText, 0};
                        }
                        if (Ebcdic.stringCompare(labelInLine, label) > 0) {
                            String lineToInsert = new String(line);
                            lineToInsert = lineToInsert.replace(labelInLine, label);
                            lineToInsert = lineToInsert.substring(0, Math.min(lineToInsert.length(), 72));
                            sb.append(lineToInsert);
                            sb.append(NEW_LINE);
                            found = true;
                        } else if (Ebcdic.stringCompare(labelInLine, indexToCopy) == 0) {
                            lineToCopy = line;
                        }
                    }
                    if (index < 0 && foundIndexes) {
                        String lineToInsert = new String(line);
                        lineToInsert = lineToCopy.replace(indexToCopy, label);
                        sb.append(lineToInsert);
                        sb.append(NEW_LINE);
                        found = true;
                    }
                }
            }
            sb.append(line).append(NEW_LINE);
            ++i;
        }
        sb.append(newText.substring(endIndex));
        return new Object[]{sb.toString(), startIndex};
    }

    protected class InternalNode {
        String node;
        int startIndex;
        int endIndex;
        boolean isCodeToKeep;

        protected InternalNode(String node, int start, int end, boolean isCodeToKeep) {
            this.node = node;
            this.startIndex = start;
            this.endIndex = end;
            this.isCodeToKeep = isCodeToKeep;
        }
    }
}

