/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.extension.nodesview;

import com.ibm.pdp.engine.ITagProperties;
import com.ibm.pdp.engine.internal.ITextProcessor;
import com.ibm.pdp.engine.tree.IEditTree;
import com.ibm.pdp.engine.tree.ITextNode;
import com.ibm.pdp.framework.EditorLink;
import com.ibm.pdp.framework.interfaces.IController;
import com.ibm.pdp.framework.interfaces.IEditor;
import com.ibm.pdp.mdl.pacbase.PacDialogServerTypeValues;
import com.ibm.pdp.mdl.pacbase.impl.PacServerImpl;
import com.ibm.pdp.pacbase.FunctionInformations;
import com.ibm.pdp.pacbase.FunctionText;
import com.ibm.pdp.pacbase.FunctionTextManager;
import com.ibm.pdp.pacbase.FunctionUpdatesManager;
import com.ibm.pdp.pacbase.IFunctionText;
import com.ibm.pdp.pacbase.INodeLoader;
import com.ibm.pdp.pacbase.NodeLoader2;
import com.ibm.pdp.pacbase.NodeLoaderManager;
import com.ibm.pdp.pacbase.PacTool;
import com.ibm.pdp.pacbase.extension.Ebcdic;
import com.ibm.pdp.pacbase.extension.nodesview.AbstractFunctionAction;
import com.ibm.pdp.pacbase.extension.nodesview.DeleteFunctionAction;
import com.ibm.pdp.pacbase.extension.organize.FunctionUtilities;
import com.ibm.pdp.pacbase.extension.organize.IVirtualFunction;
import com.ibm.pdp.pacbase.extension.organize.Location;
import com.ibm.pdp.pacbase.extension.organize.PdpFunction;
import com.ibm.pdp.pacbase.wizards.ActionType;
import com.ibm.pdp.pacbase.wizards.FunctionModel;
import com.ibm.pdp.pacbase.wizards.FunctionWizardDialog;
import com.ibm.pdp.pacbase.wizards.FunctionWizardForPdpEditor;
import com.ibm.pdp.pacbase.wizards.IFunctionControls;
import com.ibm.pdp.pacbase.wizards.PdpEditorFunctionControls;
import com.ibm.pdp.util.Util;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.ui.part.WorkbenchPart;

public class CommonWizardFunctionAction
extends AbstractFunctionAction {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2016, 2023.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected FunctionModel _model;
    protected IEditor _editor;
    protected ActionType _actionType;
    protected IEditTree _editTree;
    protected FunctionUpdatesManager _fctUpdateManager;
    protected INodeLoader _nodeLoader;
    protected IFunctionControls _functionControls;
    protected boolean _isBodyToDelete;
    private static final String INDEXES_LEVEL01_BATCH = "INDICES";
    private static final String INDEXES_LEVEL01_OTHERS = "PACBASE-INDEXES";
    private static final String FUNCTION_NOT_EMPTY = "functionNotEmpty";

    public CommonWizardFunctionAction(IEditor editor, String title, ActionType actionType) {
        this._editor = editor;
        this.setText(title);
        this._model = new FunctionModel(false);
        this._actionType = actionType;
    }

    protected void initInstanceVariables() {
        this._editTree = this._editor.getController().getTextProcessor().getEditTree();
        if (this._nodeLoader == null) {
            this._nodeLoader = this.instanciateNewNodeLoader();
            this._nodeLoader.initialize(this._editTree);
        }
        this._functionControls = new PdpEditorFunctionControls(this._editor, this._nodeLoader);
    }

    public void run() {
        EditorLink.setShortTimer();
        if (!CommonWizardFunctionAction.isUpdatesAuthorized(this._editor.getController(), ((WorkbenchPart)this._editor).getSite().getShell())) {
            return;
        }
        this.initInstanceVariables();
        FunctionModel oldModel = null;
        if (this._actionType != ActionType.CREATE_ACTION) {
            this.updateModel();
            oldModel = new FunctionModel(false);
            oldModel.setFunction(this._model.getFunction());
            oldModel.setSubFunction(this._model.getSubFunction());
            oldModel.setCondition(this._model.getCondition());
            oldModel.setLevel(this._model.getLevel());
            oldModel.setTitles(this._model.getTitle());
            String formattedTitle = this._model.getFormattedTitle();
            int debTitle = this._model.isOverrideAction() ? 6 : formattedTitle.indexOf("*N");
            formattedTitle = formattedTitle.substring(debTitle, formattedTitle.lastIndexOf("*") + 2);
            oldModel.setFormattedTitle(formattedTitle);
            oldModel.setTitle(this._model.getTitle());
            oldModel.setReference(this._model.getReference());
            oldModel.setAction(this._model.getAction());
        }
        FunctionWizardForPdpEditor wizard = new FunctionWizardForPdpEditor(this._model, this._functionControls, this._editTree, oldModel, this._isBodyToDelete);
        FunctionWizardDialog dialog = new FunctionWizardDialog(((WorkbenchPart)this._editor).getSite().getShell(), (IWizard)wizard);
        dialog.open();
        if (dialog.getReturnCode() == 0) {
            if (this._model.isOverrideAction() && this._model.isBodyToDelete()) {
                DeleteFunctionAction.deleteFunctionOnly(this._textNode, null);
                this._model.setGenerationRequested(false);
                this._actionType = ActionType.CREATE_ACTION;
            }
            if (this._model.isOverrideAction() && !this._model.isBodyToDelete()) {
                this._model.setGenerationRequested(true);
            }
            String patternName = this._editor.getController().getPattern().getName();
            if (PacTool.isGenerationWithVirtualMacroAlreadyDone(this._editor.getController().getTextProcessor().getGeneratedInfo()) && CommonWizardFunctionAction.IsGenerationNeeded(patternName, this._model.getFunction(), this._model.getSubFunction()) && this._model.isHighUpdatesForModel(oldModel) || this._model.isGenerationRequested()) {
                this.manageUpdatesWithVirtualMacro(oldModel);
            } else {
                this._fctUpdateManager = new FunctionUpdatesManager(this._editTree);
                this.manageUpdatesWithTreeHandler(oldModel);
            }
        }
    }

    protected IFunctionText instanciateNewFunctionText() {
        HashMap<IFunctionText, IConfigurationElement> implementors = FunctionTextManager.getFunctionTextImplementors();
        Iterator<IFunctionText> itFunctionText = implementors.keySet().iterator();
        String patternName = this._editor.getController().getPattern().getName();
        while (itFunctionText.hasNext()) {
            IFunctionText ft = itFunctionText.next();
            if (!("com.ibm.pdp.pacbase.dialog".equals(patternName) || "com.ibm.pdp.pacbase.csclient".equals(patternName) ? ft.getPattern().equals("com.ibm.pdp.pacbase.dialog") : ft.getPattern().equals(patternName))) continue;
            return ft;
        }
        return new FunctionText();
    }

    protected INodeLoader instanciateNewNodeLoader() {
        HashMap<INodeLoader, IConfigurationElement> implementors = NodeLoaderManager.getNodeLoaderImplementors();
        Iterator<INodeLoader> itNodeLoader = implementors.keySet().iterator();
        String patternName = this._editor.getController().getPattern().getName();
        while (itNodeLoader.hasNext()) {
            INodeLoader nd = itNodeLoader.next();
            if (!("com.ibm.pdp.pacbase.dialog".equals(patternName) || "com.ibm.pdp.pacbase.csclient".equals(patternName) ? nd.getPattern().equals("com.ibm.pdp.pacbase.dialog") : nd.getPattern().equals(patternName))) continue;
            return nd;
        }
        return new NodeLoader2();
    }

    private void manageUpdatesWithVirtualMacro(FunctionModel oldModel) {
        IController duplicateController = CommonWizardFunctionAction.createNewControler(this._editor);
        String sourceText = duplicateController.getTextProcessor().getText().toString();
        IFunctionText functionText = this.instanciateNewFunctionText();
        float level = Integer.parseInt(this._model.getLevel());
        String name = "F" + this._model.getFunction() + this._model.getSubFunction();
        PdpFunction f = new PdpFunction(name, level, this.getLocation(this._model.getAction()), this._model.getReference(), this._model.getCondition());
        ((ITextProcessor)duplicateController.getTextProcessor()).getGlobalContext().put("Mv_subfunction_to_modify", f);
        if (this._actionType == ActionType.COPYPASTE_ACTION) {
            Iterator it = this._textNode.parentNode().sons();
            boolean isTextNodeFound = false;
            while (it.hasNext()) {
                ITextNode tn = (ITextNode)it.next();
                if (isTextNodeFound) {
                    String br = tn.getLabel().toString();
                    FunctionInformations fi = PacTool.getFunctionInformations(br, tn, true);
                    if (fi == null || !"EL".equals(fi.getConditionType())) break;
                    float lev = Float.valueOf(fi.getLevel()).floatValue();
                    PdpFunction ef = new PdpFunction(br, lev, null, "", "EL");
                    ((ITextProcessor)duplicateController.getTextProcessor()).getGlobalContext().put("Mv_subfunction_el", ef);
                    break;
                }
                if (!tn.equals(this._textNode)) continue;
                isTextNodeFound = true;
            }
        }
        StringBuilder newText = new StringBuilder();
        if (this._actionType == ActionType.OVERRIDE_ACTION && this._model.isBodyToDelete()) {
            newText.append(sourceText.substring(0, this._textNode.beginIndex()));
            String[] texts = new String[]{"", ""};
            if (this._textNode.nbOfSons() == 0) {
                newText.append(sourceText.substring(this._textNode.endIndex()));
                texts[1] = this._textNode.text().toString();
            } else {
                texts = DeleteFunctionAction.deleteFunction(this._textNode);
                newText.append(texts[0]);
                newText.append(sourceText.substring(this._textNode.endIndex()));
            }
            functionText.setGenerateInsertComment(true);
            functionText.initialize(name, this._model.getFormattedTitle(), level, this._model.getCondition(), this._model.getReference(), this._model.getAction());
            newText.append(functionText.getCompleteFunctionText());
        }
        if (this._actionType == ActionType.CREATE_ACTION) {
            functionText.setGenerateInsertComment(true);
            functionText.initialize(name, this._model.getFormattedTitle(), level, this._model.getCondition(), this._model.getReference(), this._model.getAction());
            newText = this.prepareTextToCreate(functionText, sourceText);
            if ("*C".equals(this._model.getAction())) {
                name = functionText.getAttachLine();
            }
        } else if (this._actionType == ActionType.UPDATE_ACTION && Location.ATTACH.getInsertMspName().equals(this._model.getAction()) && !Location.ATTACH.getInsertMspName().equals(oldModel.getAction())) {
            functionText.setGenerateInsertComment(true);
            functionText.initialize(name, this._model.getFormattedTitle(), level, this._model.getCondition(), this._model.getReference(), this._model.getAction());
            String[] texts = new String[]{"", ""};
            newText.append(sourceText.substring(0, this._textNode.beginIndex()));
            if (this._textNode.nbOfSons() == 0) {
                newText.append(sourceText.substring(this._textNode.endIndex()));
                texts[1] = this._textNode.text().toString();
            } else {
                texts = DeleteFunctionAction.deleteFunction(this._textNode);
                newText.append(texts[0]);
                newText.append(sourceText.substring(this._textNode.endIndex()));
            }
            newText = this.prepareTextToCreate(functionText, newText.toString());
            DeleteFunctionAction.removeMpTagsFromGeneratedInfo(duplicateController.getTextProcessor(), texts[1]);
        } else {
            boolean isFctTypeUpdated;
            String attach;
            String text;
            newText.append(sourceText.substring(0, this._textNode.beginIndex()));
            functionText.setGenerateInsertComment(false);
            functionText.initialize(name, this._model.getFormattedTitle(), level, this._model.getCondition(), this._model.getReference(), this._model.getAction());
            if (this._model.isCopyAction() || this._model.isMoveAction()) {
                Iterator sons = this._textNode.sons();
                StringBuilder nt = new StringBuilder();
                int index = this._textNode.beginIndex();
                int endIndex = this._textNode.endIndex();
                CharSequence t = this._textNode.getEditTree().getTextProcessor().getText();
                while (sons.hasNext()) {
                    ITextNode son = (ITextNode)sons.next();
                    ITagProperties prop = son.getProperties();
                    int is = son.beginIndex();
                    if (is != index) {
                        nt.append(t.subSequence(index, is));
                        if ("pac_function".equals(prop.getProperty("category")) || "artificialCreate".equals(prop.getProperty("msp"))) {
                            index = son.endIndex();
                            continue;
                        }
                        index = is;
                        continue;
                    }
                    index = son.endIndex();
                }
                nt.append(t.subSequence(index, endIndex));
                text = this.getNewText(nt.toString(), this._model, oldModel);
            } else {
                text = this.getNewText(this._textNode.text().toString(), this._model, oldModel);
            }
            if (this._model.isMoveAction()) {
                String[] t = new String[]{"", ""};
                t = DeleteFunctionAction.deleteFunction(this._textNode);
                newText.append(t[0]);
            }
            if (this._model.isCopyAction()) {
                newText.append(this._textNode.text().toString());
            }
            if ((attach = functionText.getAttachLine()) != null && attach.length() > 0) {
                newText.append(attach);
                if ((this._model.isMoveAction() || this._actionType == ActionType.UPDATE_ACTION) && this._textNode.text().toString().contains(FUNCTION_NOT_EMPTY)) {
                    newText.append(" ").append(FUNCTION_NOT_EMPTY);
                }
                newText.append(NEW_LINE);
                if (text.length() == 0) {
                    name = attach;
                }
            }
            boolean bl = isFctTypeUpdated = !oldModel.getCondition().equals(this._model.getCondition());
            if (isFctTypeUpdated) {
                newText.append(functionText.getHeader());
            }
            newText.append(text);
            newText.append(sourceText.substring(this._textNode.endIndex()));
            if (!this._model.isCopyAction()) {
                DeleteFunctionAction.removeMpTagsFromGeneratedInfo(duplicateController.getTextProcessor(), this._textNode.text().toString());
            }
        }
        if (name.contains("@ATTACH")) {
            newText = this.orderingAttachLines(newText);
        }
        StringBuilder newCobol = new StringBuilder();
        if ((this._model.isMoveAction() || this._model.isCopyAction()) && "DO".equals(this._model.getCondition())) {
            Object[] obj = this.insertIndexForDoSubFunction(newText.toString(), String.valueOf(oldModel.getFunction()) + oldModel.getSubFunction(), String.valueOf(this._model.getFunction()) + this._model.getSubFunction());
            String textWithNewDOIndexes = (String)obj[0];
            newCobol = newCobol.append(textWithNewDOIndexes);
        } else {
            newCobol = newText;
        }
        duplicateController.getTextProcessor().setText((CharSequence)newCobol.toString());
        if (CommonWizardFunctionAction.generate(duplicateController, this._editor)) {
            ((ITextProcessor)duplicateController.getTextProcessor()).getGlobalContext().remove("Mv_subfunction_to_modify");
            int index = this._editor.getDocument().get().indexOf(name.contains("@ATTACH") ? name.trim() : String.valueOf(name) + ".");
            if (index > 0) {
                this._editor.getSelectionProvider().setSelection((ISelection)new TextSelection(index, 0));
            }
        }
    }

    private StringBuilder orderingAttachLines(StringBuilder text) {
        int ind2;
        String attachLine;
        String t = text.toString();
        int ind1 = t.indexOf(attachLine = "      *@ATTACH");
        if (ind1 != (ind2 = t.lastIndexOf(attachLine))) {
            StringBuilder sb = new StringBuilder(text.length());
            sb.append(text.substring(0, ind1));
            int ind3 = ind2 + t.substring(ind2).indexOf(NEW_LINE) + NEW_LINE.length();
            String textToOrder = t.substring(ind1, ind3);
            List<String> lines = Arrays.asList(textToOrder.split(NEW_LINE));
            Collections.sort(lines, this.getDefaultComparator());
            for (String line : lines) {
                sb.append(line).append(NEW_LINE);
            }
            sb.append(text.substring(ind3));
            return sb;
        }
        return text;
    }

    protected Comparator<String> getDefaultComparator() {
        Comparator<String> defaultComparator = new Comparator<String>(){

            @Override
            public int compare(String firstLine, String secondLine) {
                int indf = firstLine.indexOf("F");
                int inds = secondLine.indexOf("F");
                if (indf < 0 || inds < 0) {
                    return 0;
                }
                String firstFct = firstLine.substring(indf, indf + 3);
                String secondFct = secondLine.substring(inds, inds + 3);
                return Ebcdic.stringCompare(firstFct, secondFct);
            }
        };
        return defaultComparator;
    }

    private StringBuilder prepareTextToCreate(IFunctionText functionText, String sourceText) {
        StringBuilder newText = new StringBuilder();
        if ("*C".equals(this._model.getAction())) {
            int ind1 = sourceText.indexOf("PROCEDURE DIVISION.");
            int ind2 = sourceText.substring(ind1).indexOf(NEW_LINE);
            newText.append(sourceText.substring(0, ind1 + ind2));
            newText.append(NEW_LINE);
            newText.append(functionText.getAttachLine());
            newText.append(sourceText.substring(ind1 + ind2));
        } else {
            newText.append(sourceText);
            if (!sourceText.endsWith(NEW_LINE)) {
                newText.append(NEW_LINE);
            }
            if (functionText.getAttachLine().length() > 0) {
                newText.append(functionText.getAttachLine()).append(NEW_LINE);
            }
            newText.append(functionText.getCompleteFunctionText());
        }
        return newText;
    }

    private Location getLocation(String action) {
        Location[] locationArray = Location.values();
        int n = locationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Location value = locationArray[n2];
            if (action.equals(value.getInsertMspName())) {
                return value;
            }
            ++n2;
        }
        return null;
    }

    private void manageUpdatesWithTreeHandler(FunctionModel oldModel) {
        String sourceText;
        String newText = sourceText = this._editor.getDocument().get();
        int divIndex = PacTool.searchTextInText(newText, " PROCEDURE DIVISION", true, true);
        if (this._actionType == ActionType.CREATE_ACTION) {
            newText = this.insertNewText(null, this._fctUpdateManager);
        } else {
            if (this._model.isMoveAction()) {
                newText = this.moveFunctionAction(oldModel);
                sourceText = this._editor.getDocument().get();
            } else if (this._model.isCopyAction()) {
                newText = this.insertNewText(this.getNewText(this._fctUpdateManager.getTextForNode(oldModel, false), this._model, oldModel), this._fctUpdateManager);
            }
            if (this._model.isMoveAction() || this._model.isCopyAction()) {
                if (oldModel.getCondition().equals("DO")) {
                    Object[] obj = this.insertIndexForDoSubFunction(newText, String.valueOf(oldModel.getFunction()) + oldModel.getSubFunction(), String.valueOf(this._model.getFunction()) + this._model.getSubFunction());
                    newText = (String)obj[0];
                    if ((Integer)obj[1] > 0) {
                        divIndex = (Integer)obj[1];
                    }
                }
            } else if (this._model.isUpdatedModel(oldModel)) {
                if (!oldModel.getLevel().equals(this._model.getLevel())) {
                    newText = this._fctUpdateManager.changeLevelFunction(this._model);
                }
                if (!oldModel.getTitle().equals(this._model.getTitle())) {
                    newText = this.updateTitle(newText, oldModel);
                }
            }
        }
        if (divIndex == -1) {
            return;
        }
        int len = sourceText.length() - divIndex;
        try {
            this._editor.replace(divIndex, len, newText.substring(divIndex));
            int index = this._editor.getDocument().get().indexOf("F" + this._model.getFunction() + this._model.getSubFunction() + ".");
            if (index > 0) {
                this._editor.getSelectionProvider().setSelection((ISelection)new TextSelection(index, 0));
            }
        }
        catch (Exception e) {
            Util.rethrow((Throwable)e);
        }
    }

    private String updateTitle(String newText, FunctionModel oldModel) {
        String text;
        String string = text = newText.length() > 0 ? newText : this._textNode.getEditTree().getTextProcessor().getText().toString();
        if (oldModel.getFormattedTitle().trim().length() > 0 && this._model.getFormattedTitle().trim().length() > 0) {
            text = text.replace(oldModel.getFormattedTitle(), this._model.getFormattedTitle());
        } else {
            int ind = text.indexOf("       F" + this._model.getFunction() + this._model.getSubFunction());
            if (ind > 0) {
                StringBuilder sb = new StringBuilder();
                if (this._model.getFormattedTitle().trim().length() > 0) {
                    sb.append(text.substring(0, ind + 6));
                    sb.append(this._model.getFormattedTitle()).append(NEW_LINE);
                } else {
                    int start = text.indexOf(oldModel.getFormattedTitle());
                    if (start > 0) {
                        sb.append(text.substring(0, start - 6));
                    }
                }
                sb.append(text.substring(ind));
                text = sb.toString();
            }
        }
        return text;
    }

    private String moveFunctionAction(FunctionModel oldModel) {
        String text = this.getNewText(this._fctUpdateManager.getTextForNode(oldModel, false), this._model, oldModel);
        FunctionUpdatesManager fum = new FunctionUpdatesManager(this._textNode.getEditTree());
        DeleteFunctionAction.deleteFunctionOnly(this._textNode, fum);
        FunctionUpdatesManager fumAfterDelete = new FunctionUpdatesManager(this._textNode.getEditTree(), fum.getInitialTree());
        return this.insertNewText(text, fumAfterDelete);
    }

    private String insertNewText(String text, FunctionUpdatesManager fum) {
        return fum.insertFunction(this._model, text);
    }

    private void updateModel() {
        ITagProperties prop;
        String cat;
        if (!this.isEnabled()) {
            return;
        }
        if (this._actionType == ActionType.MOVE_ACTION) {
            this._model.setMoveAction(true);
        }
        if (this._actionType == ActionType.COPYPASTE_TREE_ACTION) {
            this._model.setMoveAction(true);
        }
        this._model.setCopyPasteTreeAction(true);
        if (this._actionType == ActionType.COPYPASTE_ACTION) {
            this._model.setCopyAction(true);
        }
        if (this._actionType == ActionType.OVERRIDE_ACTION) {
            this._model.setOverrideAction(true);
        }
        if ("ATTACH_CATEGORY".equals(cat = (prop = this._textNode.getProperties()).getProperty("category"))) {
            this._model.setFunction(prop.getProperty("ATTACH_FUNCTION").substring(1));
            this._model.setReference(prop.getProperty("ATTACH_LOGICAL_VIEW"));
            this._model.setAction(Location.ATTACH.getInsertMspName());
            this._model.setLevel("05");
        } else {
            String function = this._textNode.getLabel().toString();
            this._model.setFunction(function.substring(1, 3));
            this._model.setSubFunction(function.substring(3, function.length()));
            String lv = PacTool.getRealLevel(this._textNode);
            if (lv != null) {
                this._model.setLevel(lv);
            }
            this._model.setCondition(PacTool.getFunctionCondition(function, this._textNode, true));
            String newLine = System.getProperty("line.separator");
            String[] lines = this._textNode.text().toString().split(newLine);
            StringBuilder sb = new StringBuilder();
            String[] stringArray = lines;
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                if (PacTool.searchTextInText(line, "\\*N", true, false) != -1) {
                    sb.append(line);
                    if (this._model.getSubFunction().length() > 0) {
                        break;
                    }
                } else {
                    if (PacTool.searchTextInText(line, "\\*", true, false) == -1) break;
                    sb.append(line);
                }
                sb.append(newLine);
                ++n2;
            }
            this._model.setFormattedTitles(sb.toString());
            String ref = prop.getProperty("TagName");
            String action = prop.getProperty("TagPosition");
            if (ref != null) {
                this._model.setReference(ref);
            }
            if (action != null) {
                if ("B".equals(action)) {
                    this._model.setAction("*A");
                }
                if ("A".equals(action)) {
                    this._model.setAction("*P");
                }
                if ("R".equals(action)) {
                    this._model.setAction("*R");
                }
            }
        }
    }

    @Override
    public boolean isEnabled() {
        String patternName = this._editor.getController().getPattern().getName();
        if (!PacTool.isGenerationWithVirtualMacroAlreadyDone(this._editor.getController()) && "com.ibm.pdp.pacbase.csserver".equals(patternName) && !((PacServerImpl)this._editor.getController().getDesignLink().getModelRoot()).getDialogType().equals(PacDialogServerTypeValues._IT_LITERAL)) {
            return false;
        }
        if (this._actionType == ActionType.OVERRIDE_ACTION) {
            IStructuredSelection sel = this.getSelection();
            if (sel == null) {
                return false;
            }
            ITextNode textNode = (ITextNode)sel.getFirstElement();
            if (textNode.isGeneratedTag()) {
                FunctionUtilities fu = new FunctionUtilities(patternName);
                IVirtualFunction ivf = fu.convertOneTextNodeToFunction(textNode);
                if (ivf != null) {
                    return false;
                }
                ITagProperties properties = textNode.getProperties();
                if (properties != null) {
                    String level = properties.getProperty("level");
                    String sort = properties.getProperty("sort");
                    if (properties.getProperty("ref") != null || level == null || level != null && (level.equals("05") || level.equals("05.5")) || level.equals("06") && sort != null && sort.equals("9358R A")) {
                        return false;
                    }
                    if (properties.getProperty("msp") != null) {
                        this._textNode = textNode;
                        this._isBodyToDelete = false;
                        return true;
                    }
                    this._textNode = textNode;
                    this._isBodyToDelete = true;
                    return true;
                }
            }
            return false;
        }
        if (this._actionType == ActionType.UPDATE_ACTION || this._actionType == ActionType.MOVE_ACTION || this._actionType == ActionType.COPYPASTE_ACTION) {
            if (this._actionType == ActionType.UPDATE_ACTION) {
                FunctionUtilities fu;
                IVirtualFunction ivf;
                IStructuredSelection sel = this.getSelection();
                if (sel == null) {
                    return false;
                }
                ITextNode textNode = (ITextNode)sel.getFirstElement();
                if (textNode.isGeneratedTag() && (ivf = (fu = new FunctionUtilities(patternName)).convertOneTextNodeToFunction(textNode)) != null) {
                    this._textNode = textNode;
                    return true;
                }
            }
            if (!super.isEnabled()) {
                return this.isEnabledBecauseOfAttach(patternName);
            }
            return true;
        }
        return true;
    }

    @Override
    protected IStructuredSelection getSelection() {
        return (IStructuredSelection)this._editor.getController().getEditorLink().getGeneratedCodeStructureView().getSelection();
    }

    private String getNewText(String text, FunctionModel newModel, FunctionModel oldModel) {
        String oldLabel = String.valueOf(oldModel.getFunction()) + oldModel.getSubFunction();
        String newLabel = String.valueOf(newModel.getFunction()) + newModel.getSubFunction();
        String oldFunction = oldModel.getFunction();
        boolean isConditionUpdated = !oldModel.getCondition().equals(newModel.getCondition());
        String cond = newModel.getCondition();
        boolean isConditionExist = false;
        String pattern = this._editor.getController().getPattern().getName();
        if (isConditionUpdated) {
            cond = oldModel.getCondition();
            if (oldModel.getCondition().length() > 0 && !"EL".equals(oldModel.getCondition())) {
                isConditionExist = true;
            }
        }
        StringBuilder newText = new StringBuilder(text.length());
        String[] lines = text.split(NEW_LINE);
        String id = "000000";
        boolean isFragmentExist = false;
        boolean header = true;
        boolean title = false;
        int i = 0;
        while (i < lines.length) {
            String line = lines[i];
            if (!PacTool.isSpecialPositioningComment(line, pattern, oldFunction)) {
                if (line.length() > 7 && line.substring(6).startsWith("*!")) {
                    String lineId = line;
                    if (line.indexOf("id=") < 0) {
                        if (i + 1 < lines.length) {
                            lineId = lines[i + 1];
                        }
                        newText.append(line).append(NEW_LINE);
                        if (lineId.indexOf("id=") > 0) {
                            ++i;
                        }
                    }
                    if (lineId.indexOf("id=") > 0) {
                        int beginInd = lineId.indexOf("id=");
                        int endInd = lineId.substring(beginInd + 3).indexOf(" ");
                        endInd = endInd < 0 ? lineId.length() : (endInd += beginInd + 3);
                        String idToCopy = lineId.substring(beginInd + 3, endInd);
                        id = new String(idToCopy);
                        id = "000000" + id;
                        id = id.substring(id.length() - 6);
                        newText.append(lineId.substring(0, beginInd));
                        if (this._actionType != ActionType.COPYPASTE_ACTION && this._actionType != ActionType.COPYPASTE_TREE_ACTION) {
                            newText.append("id=");
                            newText.append(idToCopy);
                        }
                        newText.append(lineId.substring(endInd, lineId.length()));
                        newText.append(NEW_LINE);
                    }
                    if (PacTool.searchTextInText(line, "\\*!DCF", true, false) != -1 || PacTool.searchTextInText(line, "\\*!DIF", true, false) != -1 || PacTool.searchTextInText(line, "\\*!DVF", true, false) != -1) {
                        isFragmentExist = true;
                    }
                } else if (!line.endsWith(id)) {
                    String tmpLine = line.trim();
                    boolean copy = true;
                    if (isFragmentExist && tmpLine.contains("NEXT")) {
                        copy = false;
                    }
                    if (copy) {
                        String label;
                        if (header) {
                            if (oldLabel != null && newLabel != null) {
                                if (PacTool.searchTextInText(line, "\\*N", true, false) != -1 || PacTool.searchTextInText(line, "\\*", true, false) == -1) {
                                    if (PacTool.searchTextInText(line, "\\*N", true, false) != -1) {
                                        title = true;
                                        if (!isConditionUpdated && newModel.getFormattedTitle().trim().length() > 0) {
                                            StringBuilder sb = new StringBuilder();
                                            sb.append(line.substring(0, 6));
                                            sb.append(newModel.getFormattedTitle());
                                            if (cond.length() > 0) {
                                                sb.append(cond);
                                            }
                                            newText.append(sb.toString());
                                        }
                                    } else {
                                        if (line.indexOf(oldLabel) == 8 && line.indexOf("lv") > 71) {
                                            if (!title && newModel.getFormattedTitle().trim().length() > 0) {
                                                StringBuilder sb = new StringBuilder();
                                                sb.append(line.substring(0, 6));
                                                sb.append(newModel.getFormattedTitle());
                                                if (cond.length() > 0) {
                                                    sb.append(cond);
                                                }
                                                if (!isConditionUpdated || isConditionExist) {
                                                    newText.append(this.transformHeaderLine(sb.toString(), isConditionUpdated));
                                                    newText.append(NEW_LINE);
                                                }
                                            }
                                            title = false;
                                        }
                                        String newLine = line.replaceAll("F" + oldLabel, "F" + newLabel);
                                        if ("DO".equals(cond)) {
                                            newLine = newLine.replaceAll("J" + oldLabel + "R", "J" + newLabel + "R");
                                        }
                                        if (line.contains("lv")) {
                                            if (isConditionUpdated) {
                                                newLine = newLine.replace("lv" + oldModel.getLevel(), "");
                                            } else if (!oldModel.getLevel().equals(newModel.getLevel())) {
                                                newLine = newLine.replace("lv" + oldModel.getLevel(), "lv" + newModel.getLevel());
                                            }
                                        }
                                        if (!isConditionUpdated || isConditionExist) {
                                            newText.append(this.transformHeaderLine(newLine, isConditionUpdated));
                                        }
                                    }
                                    if (newText.length() > 0) {
                                        newText.append(NEW_LINE);
                                    }
                                } else if (!"DO".equals(oldModel.getCondition()) && !title) {
                                    newText.append(this.transformHeaderLine(line, isConditionUpdated));
                                    newText.append(NEW_LINE);
                                }
                            }
                            int length = Math.min(lines[i].length(), 72);
                            if ("IT".equals(oldModel.getCondition()) || "DW".equals(oldModel.getCondition())) {
                                if (line.charAt(6) != '*' && line.charAt(7) != 'F' && line.substring(0, length).trim().endsWith(".")) {
                                    header = false;
                                }
                            } else if ("DU".equals(oldModel.getCondition())) {
                                int index = tmpLine.indexOf(" ");
                                label = tmpLine.substring(0, index > 0 ? index : tmpLine.length());
                                if (label.endsWith("-B.")) {
                                    header = false;
                                }
                            } else if ("DO".equals(oldModel.getCondition())) {
                                if (tmpLine.endsWith(String.valueOf(oldLabel) + "-FN.")) {
                                    header = false;
                                }
                            } else if (line.length() > 7 && line.substring(7).startsWith("F")) {
                                header = false;
                            }
                        } else if (line.length() > 7 && line.substring(7).startsWith("F")) {
                            boolean isRenamed = false;
                            int index = tmpLine.indexOf(" ");
                            label = tmpLine.substring(0, index > 0 ? index : tmpLine.length());
                            if (label.startsWith("F" + oldLabel)) {
                                if (label.endsWith("-FN.") || line.trim().endsWith("COA") || line.trim().endsWith("coa")) {
                                    newText.append(line.replaceFirst(oldLabel, newLabel));
                                    newText.append(NEW_LINE);
                                    isRenamed = true;
                                } else if (label.endsWith("-900.")) {
                                    isRenamed = true;
                                    if (this._actionType == ActionType.UPDATE_ACTION && newLabel.length() == 2) {
                                        isRenamed = false;
                                    }
                                    if ("IT".equals(oldModel.getCondition())) {
                                        newText.append(line.replaceAll(oldLabel, newLabel));
                                        newText.append(NEW_LINE);
                                    }
                                }
                            }
                            if (!isRenamed) {
                                newText.append(line).append(NEW_LINE);
                            }
                        } else {
                            String newLine = line;
                            if ("DO".equals(oldModel.getCondition())) {
                                newLine = newLine.replaceAll("\\(J" + oldLabel + "R", "\\(J" + newLabel + "R");
                                newLine = newLine.replaceAll("\\( J" + oldLabel + "R", "\\( J" + newLabel + "R");
                                newLine = newLine.replaceAll("J" + oldLabel + "R\\)", "J" + newLabel + "R\\)");
                                newLine = newLine.replaceAll("J" + oldLabel + "R \\)", "J" + newLabel + "R \\)");
                            }
                            newText.append(newLine).append(NEW_LINE);
                        }
                    }
                }
            }
            ++i;
        }
        return newText.toString();
    }

    private String transformHeaderLine(String line, boolean isComment) {
        if (isComment && line.length() > 7 && line.charAt(6) != '*') {
            char[] cars = line.toCharArray();
            char[] buffer = new char[cars.length];
            int j = 0;
            while (j < cars.length) {
                buffer[j] = j == 6 ? 42 : cars[j];
                ++j;
            }
            return String.copyValueOf(buffer);
        }
        return line;
    }

    protected Object[] insertIndexForDoSubFunction(String newText, String oldLabel, String newLabel) {
        int startIndex = 0;
        int endIndex = 0;
        ITextNode tn = null;
        tn = "com.ibm.pdp.pacbase.batch".equals(this._editor.getController().getPattern().getName()) ? this._textNode.getEditTree().nodeFromTagName("INDEXES") : this._textNode.getEditTree().nodeFromTagName("AA200");
        if (tn != null) {
            startIndex = tn.beginIndex();
        }
        if ((tn = this._textNode.getEditTree().nodeFromTagName("WSS-CONTINUATION")) == null) {
            return new Object[]{newText, 0};
        }
        if (startIndex == 0) {
            startIndex = tn.beginIndex();
        }
        endIndex = tn.endIndex();
        String text = newText.substring(startIndex, endIndex);
        String indexToCopy = oldLabel;
        StringBuilder sb = new StringBuilder();
        sb.append(newText.substring(0, startIndex));
        boolean found = false;
        boolean foundIndexes = false;
        String label = newLabel;
        String lineToCopy = "";
        boolean isSearchPossible = false;
        String[] lines = text.split(NEW_LINE);
        int i = 0;
        while (i < lines.length) {
            String line = lines[i];
            if (line.trim().startsWith("01") && (line.contains(INDEXES_LEVEL01_BATCH) || line.contains(INDEXES_LEVEL01_OTHERS))) {
                isSearchPossible = true;
            }
            if (isSearchPossible) {
                int index = line.indexOf("J");
                if (!found) {
                    if (index > 0 && line.substring(index + 5).startsWith("R")) {
                        foundIndexes = true;
                        String labelInLine = line.substring(index + 1, index + 5);
                        if (Ebcdic.stringCompare(labelInLine, label) == 0) {
                            return new Object[]{newText, 0};
                        }
                        if (Ebcdic.stringCompare(labelInLine, label) > 0) {
                            String lineToInsert = new String(line);
                            lineToInsert = lineToInsert.replace(labelInLine, label);
                            lineToInsert = lineToInsert.substring(0, Math.min(lineToInsert.length(), 72));
                            sb.append(lineToInsert);
                            sb.append(NEW_LINE);
                            found = true;
                        } else if (Ebcdic.stringCompare(labelInLine, indexToCopy) == 0) {
                            lineToCopy = line;
                        }
                    }
                    if (index < 0 && foundIndexes) {
                        String lineToInsert = new String(line);
                        lineToInsert = lineToCopy.replace(indexToCopy, label);
                        sb.append(lineToInsert);
                        sb.append(NEW_LINE);
                        found = true;
                    }
                }
            }
            sb.append(line).append(NEW_LINE);
            ++i;
        }
        sb.append(newText.substring(endIndex));
        return new Object[]{sb.toString(), startIndex};
    }

    public static boolean IsGenerationNeeded(String patternName, String function, String subFunction) {
        if ("com.ibm.pdp.pacbase.batch".equals(patternName) || "com.ibm.pdp.pacbase.communicationmonitor".equals(patternName) || "com.ibm.pdp.pacbase.folder".equals(patternName) || "com.ibm.pdp.pacbase.server.it".equals(patternName)) {
            return false;
        }
        return !"com.ibm.pdp.pacbase.dialog".equals(patternName) && !"com.ibm.pdp.pacbase.csclient".equals(patternName) || function.equals("20") || function.equals("25") || function.equals("30") || function.equals("35") || function.equals("60") || function.equals("65") || function.equals("80");
    }
}

