/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.extension.nodesview;

import com.ibm.pdp.engine.tree.ITextNode;
import com.ibm.pdp.framework.filters.CommonFoldingAction;
import com.ibm.pdp.framework.interfaces.IController;
import com.ibm.pdp.framework.interfaces.IEditor;
import com.ibm.pdp.framework.interfaces.IGSVContextualMenuBuilder;
import com.ibm.pdp.framework.interfaces.IGeneratedCodeStructureTreeView;
import com.ibm.pdp.framework.interfaces.IPattern;
import com.ibm.pdp.framework.views.GeneratedCodeStructureTreeView;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.pacbase.PacProgram;
import com.ibm.pdp.mdl.pacbase.PacProgramStructureValues;
import com.ibm.pdp.mdl.pacbase.PacProgramVariantValues;
import com.ibm.pdp.pacbase.design.ModelUtil;
import com.ibm.pdp.pacbase.extension.ProcedureLine;
import com.ibm.pdp.pacbase.extension.ProcedureLineConstants;
import com.ibm.pdp.pacbase.extension.nodesview.CaseOfRefactoringAction;
import com.ibm.pdp.pacbase.extension.nodesview.CommonWizardFunctionAction;
import com.ibm.pdp.pacbase.extension.nodesview.CopyPasteAndMoveTreeFunctionAction;
import com.ibm.pdp.pacbase.extension.nodesview.DeleteFunctionAction;
import com.ibm.pdp.pacbase.extension.nodesview.Messages;
import com.ibm.pdp.pacbase.extension.nodesview.OpenMacroEditorAction;
import com.ibm.pdp.pacbase.filters.ResetOriginalCOBOLFoldingAction;
import com.ibm.pdp.pacbase.filters.ShowTitlesOfPacDSandFunctionsAction;
import com.ibm.pdp.pacbase.filters.ShowTitlesOfPacFunctionsAction;
import com.ibm.pdp.pacbase.wizards.ActionType;
import com.ibm.pdp.util.Strings;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.ui.texteditor.AbstractDecoratedTextEditor;

public class CommonGSVContextualMenuBuilder
implements IGSVContextualMenuBuilder,
ProcedureLineConstants {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2022.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private ShowTitlesOfPacDSandFunctionsAction _showTitlesOfPacDSandFunctionsAction;
    private ShowTitlesOfPacFunctionsAction _showTitlesOfPacFunctionsAction;
    private ResetOriginalCOBOLFoldingAction _resetOriginalCOBOLFoldingAction;
    protected String patternName = null;
    protected IEditor editor = null;
    protected Separator SEPARATOR = new Separator("additions");

    private void addPacFilterAction(IMenuManager menuManager, IGeneratedCodeStructureTreeView view) {
        PacProgram pgm;
        menuManager.add((IContributionItem)new Separator());
        IMenuManager foldingSubMenu = menuManager.findMenuUsingPath("com.ibm.pdp.framework.filters.filteringSubmenuId");
        if (this._resetOriginalCOBOLFoldingAction == null) {
            this._resetOriginalCOBOLFoldingAction = new ResetOriginalCOBOLFoldingAction(view);
            view.addFoldingActionToView((CommonFoldingAction)this._resetOriginalCOBOLFoldingAction);
        }
        foldingSubMenu.add((IAction)this._resetOriginalCOBOLFoldingAction);
        String designFileId = view.getController().getDesignLink().getFileId();
        RadicalEntity designRoot = ModelUtil.getSharedRadicalEntity(designFileId);
        boolean isPgmOfVariantC_Or_NatureSDF = false;
        if (designRoot instanceof PacProgram && ((pgm = (PacProgram)designRoot).getVariante() == PacProgramVariantValues._C_LITERAL || pgm.getProgramStructure() == PacProgramStructureValues._D_LITERAL || pgm.getProgramStructure() == PacProgramStructureValues._F_LITERAL || pgm.getProgramStructure() == PacProgramStructureValues._S_LITERAL)) {
            isPgmOfVariantC_Or_NatureSDF = true;
        }
        if (!isPgmOfVariantC_Or_NatureSDF) {
            if (this._showTitlesOfPacDSandFunctionsAction == null) {
                this._showTitlesOfPacDSandFunctionsAction = new ShowTitlesOfPacDSandFunctionsAction(view);
                view.addFoldingActionToView((CommonFoldingAction)this._showTitlesOfPacDSandFunctionsAction);
            }
            foldingSubMenu.add((IAction)this._showTitlesOfPacDSandFunctionsAction);
            if (this._showTitlesOfPacFunctionsAction == null) {
                this._showTitlesOfPacFunctionsAction = new ShowTitlesOfPacFunctionsAction(view);
                view.addFoldingActionToView((CommonFoldingAction)this._showTitlesOfPacFunctionsAction);
            }
            foldingSubMenu.add((IAction)this._showTitlesOfPacFunctionsAction);
        }
    }

    public void fillContextMenu(IMenuManager menuManager, IGeneratedCodeStructureTreeView view, ITextNode textNode) {
        this.editor = view.getAssociatedEditor();
        if (this.editor instanceof AbstractDecoratedTextEditor && this.editor.getAnnotationModel() instanceof ProjectionAnnotationModel) {
            IPattern pattern;
            IController controler = view.getController();
            if (controler != null && (pattern = controler.getPattern()) != null) {
                this.patternName = pattern.getName();
                if (!("com.ibm.pdp.pacbase.csclient".equals(this.patternName) || "com.ibm.pdp.pacbase.csserver".equals(this.patternName) || "com.ibm.pdp.pacbase.dialog".equals(this.patternName) || "com.ibm.pdp.pacbase.batch".equals(this.patternName) || "com.ibm.pdp.pacbase.communicationmonitor".equals(this.patternName) || "com.ibm.pdp.pacbase.folder".equals(this.patternName) || "com.ibm.pdp.pacbase.server.it".equals(this.patternName))) {
                    return;
                }
            }
            this.addPacFilterAction(menuManager, view);
            menuManager.add((IContributionItem)new Separator());
            OpenMacroEditorAction openMacroEditorAction = new OpenMacroEditorAction(view);
            menuManager.add((IAction)openMacroEditorAction);
            menuManager.add((IContributionItem)new Separator());
            MenuManager mm = new MenuManager(Messages.SubFunction_ACTION);
            menuManager.add((IContributionItem)mm);
            DeleteFunctionAction deleteFunctionAction = new DeleteFunctionAction(view);
            mm.add((IAction)deleteFunctionAction);
            CommonWizardFunctionAction createFunctionAction = this.getWizardFunctionAction(Messages.PdpCobolEditor2_CREATE_FUNCTION_SUBFUNCTION, ActionType.CREATE_ACTION);
            mm.add((IAction)createFunctionAction);
            CommonWizardFunctionAction updateFunctionAction = this.getWizardFunctionAction(Messages.PdpCobolEditor2_UPDT_FUNCTION_SUBFUNCTION, ActionType.UPDATE_ACTION);
            mm.add((IAction)updateFunctionAction);
            CommonWizardFunctionAction overrideFunctionAction = this.getWizardFunctionAction(Messages.OverrideSubFunction_ACTION, ActionType.OVERRIDE_ACTION);
            mm.add((IAction)overrideFunctionAction);
            CommonWizardFunctionAction moveFunctionAction = this.getWizardFunctionAction(Messages.MoveSubFunction_ACTION, ActionType.MOVE_ACTION);
            mm.add((IAction)moveFunctionAction);
            CopyPasteAndMoveTreeFunctionAction moveTreeFunctionAction = this.getMoveTreeFunctionAction(Messages.MoveSubFunctionTree_ACTION, view, ActionType.MOVE_ACTION);
            mm.add((IAction)moveTreeFunctionAction);
            CommonWizardFunctionAction copyPasteFunctionAction = this.getWizardFunctionAction(Messages.CopyPasteSubFunction_ACTION, ActionType.COPYPASTE_ACTION);
            mm.add((IAction)copyPasteFunctionAction);
            CopyPasteAndMoveTreeFunctionAction copyPasteTreeFunctionAction = this.getMoveTreeFunctionAction(Messages.CopyPasteSubFunctionTree_ACTION, view, ActionType.COPYPASTE_TREE_ACTION);
            mm.add((IAction)copyPasteTreeFunctionAction);
            CaseOfRefactoringAction caseOfRefactoringAction = new CaseOfRefactoringAction(view);
            mm.add((IAction)caseOfRefactoringAction);
        }
    }

    public CommonWizardFunctionAction getWizardFunctionAction(String title, ActionType actionType) {
        return new CommonWizardFunctionAction(this.editor, title, actionType);
    }

    public CopyPasteAndMoveTreeFunctionAction getMoveTreeFunctionAction(String title, IGeneratedCodeStructureTreeView view, ActionType actionType) {
        return new CopyPasteAndMoveTreeFunctionAction(this.editor, title, view, actionType);
    }

    protected static boolean hasRelativeReplace(IGeneratedCodeStructureTreeView view, String tag) {
        String totTxt = ((GeneratedCodeStructureTreeView)view).getAssociatedEditor().getDocument().get();
        return ProcedureLine.includedWithWhiteAfter(totTxt, "*@REPLACE F" + tag);
    }

    protected static boolean hasRelatives(IGeneratedCodeStructureTreeView view, String tag) {
        if (tag == null || tag.length() < 2) {
            return false;
        }
        String totTxt = ((GeneratedCodeStructureTreeView)view).getAssociatedEditor().getDocument().get();
        boolean bl1 = ProcedureLine.includedWithWhiteAfter(totTxt, "*@BEFORE F" + tag);
        boolean bl2 = ProcedureLine.includedWithWhiteAfter(totTxt, "*@REPLACE F" + tag);
        boolean bl3 = ProcedureLine.includedWithWhiteAfter(totTxt, "*@AFTER F" + tag);
        return bl1 || bl2 || bl3;
    }

    protected static boolean isBalanced(IGeneratedCodeStructureTreeView view, String func) {
        String tot = ((GeneratedCodeStructureTreeView)view).getAssociatedEditor().getDocument().get();
        int index = tot.indexOf(String.valueOf(func) + "-FN.");
        String lineSep = Strings.getLineSeparator();
        while (-1 < index) {
            int sep = index - 7;
            if (tot.substring(sep - lineSep.length(), sep).equals(lineSep)) {
                return true;
            }
            ++index;
            index = tot.indexOf(String.valueOf(func) + "-FN.", index);
        }
        return false;
    }

    protected static String getRealLabel(IGeneratedCodeStructureTreeView view, int beg, int end) {
        String tot = ((GeneratedCodeStructureTreeView)view).getAssociatedEditor().getDocument().get();
        if (tot.length() < beg || tot.length() < end || end < beg) {
            return "";
        }
        return ProcedureLine.extractLabel(tot.substring(beg, end));
    }

    protected static String getRealComment(IGeneratedCodeStructureTreeView view, int beg, int end) {
        String tot = ((GeneratedCodeStructureTreeView)view).getAssociatedEditor().getDocument().get();
        if (tot.length() < beg || tot.length() < end || end < beg) {
            return "";
        }
        return ProcedureLine.extractComment(tot.substring(beg, end));
    }

    /*
     * Unable to fully structure code
     */
    protected static boolean hasTiretFN(IGeneratedCodeStructureTreeView view, String ABXY) {
        tot = ((GeneratedCodeStructureTreeView)view).getAssociatedEditor().getDocument().get();
        pos = tot.indexOf(lab = "F" + ABXY + "-FN.");
        if (pos != -1) ** GOTO lbl7
        return false;
lbl-1000:
        // 1 sources

        {
            if ((pos = tot.indexOf(lab, pos + 1)) != -1) continue;
            return false;
lbl7:
            // 2 sources

            ** while (!CommonGSVContextualMenuBuilder.isLabel((String)tot, (int)pos))
        }
lbl8:
        // 1 sources

        return true;
    }

    private static boolean isLabel(String tot, int pos) {
        if (tot.charAt(pos - 1) != ' ') {
            return false;
        }
        String del = Strings.getLineSeparator();
        int posdel = pos - 7 - del.length();
        return tot.substring(posdel, posdel + del.length()).equals(del);
    }

    protected static boolean hasNoFollower(IGeneratedCodeStructureTreeView view, int beg, int end) {
        String tot = ((GeneratedCodeStructureTreeView)view).getAssociatedEditor().getDocument().get();
        if (tot.length() < beg || tot.length() < end || end < beg) {
            return false;
        }
        return ProcedureLine.hasGroupOfLinesNoFollower(tot.substring(beg, end));
    }

    protected static boolean isCommentNotRelative(IGeneratedCodeStructureTreeView view, int beg, int end) {
        String realComment = CommonGSVContextualMenuBuilder.getRealComment(view, beg, end);
        return realComment.indexOf("*@BEFORE") == -1 && realComment.indexOf("*@REPLACE") == -1 && realComment.indexOf("*@AFTER") == -1;
    }

    protected static boolean isCommentRelative(IGeneratedCodeStructureTreeView view, int beg, int end) {
        String realComment = CommonGSVContextualMenuBuilder.getRealComment(view, beg, end);
        return realComment.indexOf("*@BEFORE") != -1 || realComment.indexOf("*@REPLACE") != -1 || realComment.indexOf("*@AFTER") != -1;
    }

    protected static boolean isPrecedingLineRelative(IGeneratedCodeStructureTreeView view, int begIndex) {
        IDocument doc = ((GeneratedCodeStructureTreeView)view).getAssociatedEditor().getDocument();
        try {
            int lineOfRelative = doc.getLineOfOffset(begIndex) - 1;
            int lineOffset = doc.getLineOffset(lineOfRelative);
            int lineLen = doc.getLineLength(lineOfRelative);
            String line = doc.get(lineOffset, lineLen);
            return line.indexOf("*@BEFORE") == 6 || line.indexOf("*@REPLACE") == 6 || line.indexOf("*@AFTER") == 6;
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }
}

