/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.extension.nodesview;

import com.ibm.icu.util.StringTokenizer;
import com.ibm.pdp.engine.tree.ITextNode;
import com.ibm.pdp.framework.interfaces.IGeneratedCodeStructureTreeView;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.pacbase.PacCommunicationMonitor;
import com.ibm.pdp.mdl.pacbase.PacDialog;
import com.ibm.pdp.mdl.pacbase.PacFolder;
import com.ibm.pdp.mdl.pacbase.PacGeneratedLanguageValues;
import com.ibm.pdp.mdl.pacbase.PacProgram;
import com.ibm.pdp.mdl.pacbase.PacScreen;
import com.ibm.pdp.mdl.pacbase.PacServer;
import com.ibm.pdp.mdl.pacbase.util.PacCommunicationMonitorWrapper;
import com.ibm.pdp.mdl.pacbase.util.PacDialogWrapper;
import com.ibm.pdp.mdl.pacbase.util.PacFolderWrapper;
import com.ibm.pdp.mdl.pacbase.util.PacProgramWrapper;
import com.ibm.pdp.mdl.pacbase.util.PacScreenWrapper;
import com.ibm.pdp.mdl.pacbase.util.PacServerWrapper;
import com.ibm.pdp.pacbase.PacTool;
import com.ibm.pdp.pacbase.extension.matching.BasicPacLabelRecognizer;
import com.ibm.pdp.pacbase.extension.matching.CobolLabel;
import com.ibm.pdp.pacbase.extension.matching.PacLabel;
import com.ibm.pdp.pacbase.extension.nodesview.GsvFunctionAction;
import com.ibm.pdp.pacbase.extension.nodesview.Messages;
import com.ibm.pdp.util.Strings;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;

public class CaseOfRefactoringAction
extends GsvFunctionAction {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2017, 2021.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    ITextNode coTextNode = null;
    private static String COBOL_LINE_BEGINNING = "       ";
    private static String COBOL_LINE_INDENT = "                ";

    public CaseOfRefactoringAction(IGeneratedCodeStructureTreeView view) {
        super(view);
        this._titleAction = Messages.CaseOfRefactoring_ACTION;
    }

    public void run() {
        String newLine = Strings.getLineSeparator();
        StringBuilder sbParent = this.getTextForParentOnly(this.coTextNode.text().toString(), newLine);
        StringBuilder sbChild = new StringBuilder();
        Iterator sons = this.coTextNode.sons();
        ArrayList<CaseOfSsFct> coChildren = new ArrayList<CaseOfSsFct>();
        String otherSsFctStart = "";
        String otherSsFctEnd = "";
        while (sons.hasNext()) {
            ITextNode son = (ITextNode)sons.next();
            if (!son.isSyntacticTag()) {
                if (!coChildren.isEmpty()) {
                    this.sendErrorMessage(Messages.CaseOfRefactoring_ERROR_REASON4);
                    return;
                }
                if (son.getLabel().length() != 5 || !son.getLabel().toString().startsWith("N") && !son.getLabel().toString().startsWith("F")) continue;
                this.sendErrorMessage(Messages.CaseOfRefactoring_ERROR_REASON4);
                return;
            }
            String cond = PacTool.getFunctionCondition(son.getLabel().toString(), son, true);
            if (cond.length() == 0 || cond.length() > 0 && otherSsFctStart.length() > 0) {
                sbChild.append(son.text().toString());
                if (otherSsFctStart == "") {
                    otherSsFctStart = son.getLabel().toString();
                }
                otherSsFctEnd = son.getLabel().toString();
                continue;
            }
            sbChild.append((CharSequence)this.getNewTextNode(son.text().toString(), newLine, coChildren));
        }
        if (coChildren.isEmpty()) {
            this.sendErrorMessage(Messages.CaseOfRefactoring_ERROR_REASON2);
            return;
        }
        String[] result = this.determineVarToEvaluateForEachSubfunctione(coChildren, newLine);
        if (result[1].length() > 0) {
            this.sendErrorMessage(result[1]);
            return;
        }
        String varToEvaluate = result[0];
        if ((result = this.getTextForEvaluate(varToEvaluate, coChildren, otherSsFctStart, otherSsFctEnd, newLine))[1].length() > 0) {
            this.sendErrorMessage(result[1]);
            return;
        }
        sbParent.append(result[0]);
        sbParent.append(COBOL_LINE_BEGINNING);
        sbParent.append("    GO TO ");
        sbParent.append(this.coTextNode.getLabel());
        sbParent.append("-FN.");
        sbParent.append(newLine);
        sbParent.append((CharSequence)sbChild);
        sbParent.append(COBOL_LINE_BEGINNING);
        sbParent.append(this.coTextNode.getLabel().toString()).append("-FN. EXIT.");
        sbParent.append(newLine);
        this.coTextNode.getEditTree().getTextProcessor().replaceText(this.coTextNode.beginIndex(), this.coTextNode.endIndex(), (CharSequence)sbParent.toString());
    }

    private String[] getTextForEvaluate(String varToEvaluate, ArrayList<CaseOfSsFct> coChildren, String otherSsFctStart, String otherSsFctEnd, String newLine) {
        StringBuilder sbParent = new StringBuilder();
        sbParent.append(COBOL_LINE_BEGINNING);
        sbParent.append("    EVALUATE ");
        sbParent.append(varToEvaluate);
        sbParent.append(newLine);
        for (CaseOfSsFct child : coChildren) {
            String[] result = this.getCondition(child.condition.toString(), this.getValue(child, varToEvaluate), newLine);
            if (result[1].length() > 0) {
                return result;
            }
            sbParent.append(result[0]);
            sbParent.append(COBOL_LINE_INDENT);
            sbParent.append(" PERFORM ");
            sbParent.append(child.ssFct);
            sbParent.append(" THRU ");
            sbParent.append(child.ssFct);
            sbParent.append("-FN");
            sbParent.append(newLine);
        }
        if (otherSsFctStart.length() > 0) {
            sbParent.append(COBOL_LINE_INDENT);
            sbParent.append("WHEN OTHER");
            sbParent.append(" PERFORM ");
            sbParent.append(otherSsFctStart);
            sbParent.append(" THRU ");
            sbParent.append(otherSsFctEnd).append("-FN");
            sbParent.append(newLine);
        }
        sbParent.append(COBOL_LINE_INDENT);
        sbParent.append("END-EVALUATE.");
        sbParent.append(newLine);
        return new String[]{sbParent.toString(), ""};
    }

    private String[] getCondition(String cond, String value, String newLine) {
        int indValue;
        StringBuilder sb = new StringBuilder();
        int indEqual = cond.indexOf(" = ");
        if (indEqual < (indValue = cond.lastIndexOf(value))) {
            cond = cond.substring(indEqual);
            cond = cond.substring(cond.indexOf(value));
        } else {
            cond = cond.substring(cond.indexOf(value), indEqual);
        }
        if (cond.contains(" AND ")) {
            return new String[]{"", Messages.CaseOfRefactoring_ERROR_REASON3};
        }
        StringTokenizer words = new StringTokenizer(cond, "OR");
        while (words.hasMoreTokens()) {
            String word = words.nextToken();
            if ("OR".equals(word)) continue;
            sb.append(COBOL_LINE_INDENT);
            sb.append("WHEN ");
            sb.append(word.trim());
            sb.append(newLine);
        }
        return new String[]{sb.toString(), ""};
    }

    private String getValue(CaseOfSsFct child, String varToEvaluate) {
        if (varToEvaluate.equals(child.var1)) {
            return child.var2;
        }
        return child.var1;
    }

    private StringBuilder getTextForParentOnly(String text, String newLine) {
        StringTokenizer lines = new StringTokenizer(text, newLine);
        StringBuilder sb = new StringBuilder();
        String name = "";
        while (lines.hasMoreTokens()) {
            String line = lines.nextToken();
            CobolLabel cobolLabel = BasicPacLabelRecognizer.findCobolLabelInLine(line);
            if (cobolLabel != null) {
                if (name.length() == 0) {
                    name = cobolLabel.getPacLabel();
                }
                if (name.length() > 0 && !name.equals(cobolLabel.getPacLabel())) {
                    break;
                }
            } else if (name.length() > 0 && line.trim().startsWith("*N")) break;
            sb.append(line);
            sb.append(newLine);
        }
        return sb;
    }

    private StringBuilder getNewTextNode(String text, String newLine, ArrayList<CaseOfSsFct> coChildren) {
        StringTokenizer lines = new StringTokenizer(text, newLine);
        StringBuilder sb = new StringBuilder();
        boolean toAnalyze = true;
        String name = "";
        CaseOfSsFct coFct = null;
        PacLabel pacLabel = null;
        while (lines.hasMoreTokens()) {
            String line = lines.nextToken();
            if (toAnalyze) {
                if (line.trim().startsWith("*N")) {
                    if (line.trim().endsWith(".IT")) {
                        sb.append(line.replace(".IT", "   "));
                    } else {
                        sb.append(line);
                    }
                    sb.append(newLine);
                    continue;
                }
                if (line.trim().startsWith("F") && (pacLabel = BasicPacLabelRecognizer.findPacbaseLabelInLine(line)) != null && pacLabel.isBeginningLabel()) {
                    name = pacLabel.getPacLabel();
                    StringBuilder tmpLine = new StringBuilder();
                    tmpLine.append(COBOL_LINE_BEGINNING);
                    tmpLine.append(name).append(".");
                    while (tmpLine.length() < 72) {
                        tmpLine.append(" ");
                    }
                    tmpLine.append(line.substring(72));
                    sb.append((CharSequence)tmpLine);
                    sb.append(newLine);
                    coFct = new CaseOfSsFct(name);
                }
                if (line.trim().startsWith("NEXT")) {
                    toAnalyze = false;
                    continue;
                }
                line = line.length() > 72 ? line.substring(0, 72) : line;
                coFct.condition.append(line);
                coFct.condition.append(newLine);
                continue;
            }
            CobolLabel cobolLabel = BasicPacLabelRecognizer.findCobolLabelInLine(line);
            if (cobolLabel != null && cobolLabel.getPacLabel().endsWith("-900") && line.contains(name)) continue;
            sb.append(line);
            sb.append(newLine);
        }
        if (coFct != null) {
            coChildren.add(coFct);
        }
        return sb;
    }

    private String[] determineVarToEvaluateForEachSubfunctione(ArrayList<CaseOfSsFct> coChildren, String newLine) {
        for (CaseOfSsFct child : coChildren) {
            StringTokenizer lines = new StringTokenizer(child.condition.toString(), newLine);
            boolean ifFound = false;
            boolean equalFound = false;
            while (lines.hasMoreTokens()) {
                String line = lines.nextToken();
                StringTokenizer words = new StringTokenizer(line, " ", true);
                while (words.hasMoreTokens()) {
                    String word = words.nextToken();
                    if (ifFound && !"=".equals(word)) {
                        if (!equalFound) {
                            child.var1 = String.valueOf(child.var1) + word;
                        } else {
                            child.var2 = String.valueOf(child.var2) + word;
                        }
                    }
                    if ("IF".equals(word)) {
                        ifFound = true;
                    }
                    if (!"=".equals(word)) continue;
                    equalFound = true;
                }
            }
            if (child.var1.length() <= 0 || child.var2.length() <= 0) continue;
            child.var1 = child.var1.trim();
            child.var2 = child.var2.trim();
        }
        String varToEvaluate = "";
        CaseOfSsFct coTmp = null;
        for (CaseOfSsFct child : coChildren) {
            if (coTmp == null) {
                coTmp = child;
                continue;
            }
            if (child.var1.equals(coTmp.var1) || child.var1.equals(coTmp.var2)) {
                varToEvaluate = child.var1;
                break;
            }
            if (!child.var2.equals(coTmp.var1) && !child.var2.equals(coTmp.var2)) break;
            varToEvaluate = child.var2;
            break;
        }
        if (varToEvaluate.length() == 0) {
            if (coChildren.size() == 1) {
                if (coTmp.var2.charAt(0) == '\"' && coTmp.var2.charAt(coTmp.var2.length() - 1) == '\"' || coTmp.var2.charAt(0) == '\'' && coTmp.var2.charAt(coTmp.var2.length() - 1) == '\'') {
                    varToEvaluate = coTmp.var1;
                }
                if (coTmp.var1.charAt(0) == '\"' && coTmp.var1.charAt(coTmp.var1.length() - 1) == '\"' || coTmp.var1.charAt(0) == '\'' && coTmp.var1.charAt(coTmp.var1.length() - 1) == '\'') {
                    varToEvaluate = coTmp.var2;
                }
                if (varToEvaluate.length() == 0) {
                    return new String[]{"", Messages.CaseOfRefactoring_ERROR_REASON1};
                }
            } else {
                return new String[]{"", Messages.CaseOfRefactoring_ERROR_REASON2};
            }
        }
        return new String[]{varToEvaluate, ""};
    }

    private void sendErrorMessage(String reason) {
        ErrorDialog.openError((Shell)this._view.getTreeViewer().getTree().getShell(), (String)Messages.CaseOfRefactoring_ERROR, (String)"", (IStatus)new Status(4, "org.eclipse.ui", reason));
    }

    @Override
    public boolean isEnabled() {
        if (super.isEnabled()) {
            PacGeneratedLanguageValues language = CaseOfRefactoringAction.SearchGeneratedLanguageFor((RadicalEntity)this._view.getController().getDesignLink().getModelRoot());
            if (PacGeneratedLanguageValues._C_LITERAL.equals(language)) {
                return false;
            }
            IStructuredSelection sel = (IStructuredSelection)this._view.getSelection();
            ITextNode textNode = (ITextNode)sel.getFirstElement();
            if (textNode != null && textNode.isTagged() && textNode.isSyntacticTag()) {
                String cond = PacTool.getFunctionCondition(textNode.getLabel().toString(), textNode, true);
                if ("CO".equals(cond)) {
                    this.coTextNode = textNode;
                    return true;
                }
                this.coTextNode = this.getParentNode(textNode);
                return this.coTextNode != null;
            }
        }
        return false;
    }

    private ITextNode getParentNode(ITextNode tn) {
        if ("PROCEDURE".equals(tn.parentNode().getLabel()) || "05".equals(tn.parentNode().getProperties().getProperty("level"))) {
            return null;
        }
        String cond = PacTool.getFunctionCondition(tn.parentNode().getLabel().toString(), tn.parentNode(), true);
        if ("CO".equals(cond)) {
            return tn.parentNode();
        }
        return this.getParentNode(tn.parentNode());
    }

    public static PacGeneratedLanguageValues SearchGeneratedLanguageFor(RadicalEntity re) {
        PacGeneratedLanguageValues result = null;
        switch (re.eClass().getClassifierID()) {
            case 39: {
                PacProgramWrapper p = new PacProgramWrapper((PacProgram)re);
                result = p.getGenerationParameter().getGeneratedLanguage();
                break;
            }
            case 70: {
                PacScreenWrapper p = new PacScreenWrapper((PacScreen)re);
                result = p.getGenerationParameter().getGeneratedLanguage();
                break;
            }
            case 72: {
                PacDialogWrapper p = new PacDialogWrapper((PacDialog)re);
                result = p.getGenerationParameter().getGeneratedLanguage();
                break;
            }
            case 101: {
                PacServerWrapper p = new PacServerWrapper((PacServer)re);
                result = p.getGenerationParameter().getGeneratedLanguage();
                break;
            }
            case 127: {
                PacCommunicationMonitorWrapper p = new PacCommunicationMonitorWrapper((PacCommunicationMonitor)re);
                result = p.getGenerationParameter().getGeneratedLanguage();
                break;
            }
            case 120: {
                PacFolderWrapper p = new PacFolderWrapper((PacFolder)re);
                result = p.getGenerationParameter().getGeneratedLanguage();
            }
        }
        return result;
    }

    protected class CaseOfSsFct {
        String ssFct = "";
        String var1 = "";
        String var2 = "";
        StringBuilder condition = new StringBuilder();

        protected CaseOfSsFct(String ssFct) {
            this.ssFct = ssFct;
        }
    }
}

