/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.extension.nodesview;

import com.ibm.pdp.engine.ITagProperties;
import com.ibm.pdp.engine.internal.ITextProcessor;
import com.ibm.pdp.engine.tree.ITextNode;
import com.ibm.pdp.framework.ConsistencyCheckException;
import com.ibm.pdp.framework.ControllerFactory;
import com.ibm.pdp.framework.GenerationManager;
import com.ibm.pdp.framework.MigrationHelpTool;
import com.ibm.pdp.framework.PdpTool;
import com.ibm.pdp.framework.interfaces.IController;
import com.ibm.pdp.framework.interfaces.IEditor;
import com.ibm.pdp.framework.interfaces.IGenResult;
import com.ibm.pdp.framework.interfaces.IGenStatus;
import com.ibm.pdp.framework.interfaces.IPattern;
import com.ibm.pdp.framework.interfaces.IStatusMessage;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.pacbase.PacTool;
import com.ibm.pdp.pacbase.PdpPacbasePlugin;
import com.ibm.pdp.pacbase.extension.nodesview.Messages;
import com.ibm.pdp.pacbase.extension.organize.CobolAnalyzerDialog;
import com.ibm.pdp.pacbase.extension.organize.CobolAnalyzerGeneric;
import com.ibm.pdp.pacbase.extension.organize.CobolAnalyzerServer;
import com.ibm.pdp.util.Util;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public abstract class AbstractFunctionAction
extends Action {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2017, 2018.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected ITextNode _textNode;
    protected static final String NEW_LINE = System.getProperty("line.separator");

    public boolean isEnabled() {
        String cat;
        ITagProperties properties;
        IStructuredSelection sel = this.getSelection();
        if (sel == null) {
            return false;
        }
        ITextNode textNode = (ITextNode)sel.getFirstElement();
        if (textNode != null && textNode.isTagged() && textNode.isSyntacticTag() && (properties = textNode.getProperties()) != null && "pac_function".equals(cat = properties.getProperty("category"))) {
            this._textNode = textNode;
            return true;
        }
        return false;
    }

    protected boolean isGeneratedFunctionOverridenInSpecific() {
        ITagProperties properties;
        IStructuredSelection sel = this.getSelection();
        if (sel == null) {
            return false;
        }
        ITextNode textNode = (ITextNode)sel.getFirstElement();
        if (textNode != null && (properties = textNode.getProperties()) != null && "true".equals(properties.getProperty("functionOverridedBySpecific"))) {
            this._textNode = textNode;
            return true;
        }
        return false;
    }

    protected boolean isEnabledBecauseOfAttach(String patternName) {
        if (PacTool.isMacroVirtualEnabled()) {
            String cat;
            ITagProperties properties;
            ITextNode textNode;
            IStructuredSelection sel = this.getSelection();
            if (sel == null) {
                return false;
            }
            if ("com.ibm.pdp.pacbase.csserver".equals(patternName) && (textNode = (ITextNode)sel.getFirstElement()) != null && textNode.isTagged() && textNode.isSyntacticTag() && (properties = textNode.getProperties()) != null && "ATTACH_CATEGORY".equals(cat = properties.getProperty("category"))) {
                this._textNode = textNode;
                return true;
            }
        }
        return false;
    }

    protected IStructuredSelection getSelection() {
        return null;
    }

    protected static boolean isUpdatesAuthorized(IController controler, Shell parent) {
        if (!PacTool.isCobolValidated(controler.getTextProcessor().getGeneratedInfo())) {
            MessageDialog.openInformation((Shell)parent, (String)"", (String)Messages.FunctionAction_PROBLEM_COBOL_NOT_VALIDATED);
            return false;
        }
        return AbstractFunctionAction.isCobolStructureOk(controler, parent);
    }

    protected static boolean isGenerationRequired(IController controller) {
        return !PacTool.isGenerationWithVirtualMacroAlreadyDone(controller);
    }

    private static boolean isCobolStructureOk(IController controler, Shell parent) {
        block4: {
            String message = "";
            IPreferenceStore store = PdpPacbasePlugin.getDefault().getPreferenceStore();
            int structureChecking = 0;
            if (store.contains("com.ibm.pdp.pacbase.preferences.structurecontrol")) {
                structureChecking = store.getInt("com.ibm.pdp.pacbase.preferences.structurecontrol");
            }
            if (structureChecking != 0) {
                return true;
            }
            try {
                CobolAnalyzerGeneric cag = null;
                String pattern = controler.getPattern().getName();
                cag = "com.ibm.pdp.pacbase.csclient".equals(pattern) || "com.ibm.pdp.pacbase.dialog".equals(pattern) ? new CobolAnalyzerDialog() : ("com.ibm.pdp.pacbase.csserver".equals(pattern) ? new CobolAnalyzerServer() : new CobolAnalyzerGeneric());
                cag.analyze(controler.getTextProcessor(), controler);
            }
            catch (ConsistencyCheckException cce) {
                message = cce.getMessage();
                if (message == null || message.trim().length() <= 0) break block4;
                message = String.valueOf(Messages.FunctionAction_PROBLEM_STRUCTURE_CHECKING) + NEW_LINE + message;
                MessageDialog.openError((Shell)parent, (String)"", (String)message);
                PdpTool.openErrorLog();
                return false;
            }
        }
        return true;
    }

    protected static IController createNewControler(IEditor editor) {
        ControllerFactory factory = (ControllerFactory)ControllerFactory.getInstance();
        IController duplicatedController = factory.createDuplicatedControllerFrom(editor.getController());
        if (duplicatedController == null) {
            Shell parent = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            MessageDialog.openError((Shell)parent, (String)"Messages.GENERATION_FAILED", (String)Messages.FunctionAction_PREVIOUS_COBOL_ABSENT_OR_NOT_COBOL);
            return null;
        }
        return duplicatedController;
    }

    protected static boolean generate(IController duplicatedController, IEditor editor) {
        ArrayList<IController> controllers = new ArrayList<IController>();
        controllers.add(duplicatedController);
        Iterator referencesIterator = editor.getController().getGenerationLink().getSubReferences();
        String logicalDesignName = MigrationHelpTool.getLogicalDesignName((Iterator)referencesIterator);
        String realFileName = PdpTool.addRPPFolderToFileName((String)logicalDesignName);
        Object design = editor.getController().getPattern().getDesign(realFileName);
        ((ITextProcessor)duplicatedController.getTextProcessor()).getGlobalContext().put("generation_mode", "from_wizard");
        if (AbstractFunctionAction.generate((RadicalEntity)design, editor.getController().getPattern(), controllers)) {
            ((ITextProcessor)duplicatedController.getTextProcessor()).getGlobalContext().remove("generation_mode");
            ((ControllerFactory)ControllerFactory.getInstance()).setUpNewController(duplicatedController);
            editor.getController().getEditorLink().getGeneratedCodeStructureView().setController(duplicatedController, editor, 1);
            return true;
        }
        return false;
    }

    private static boolean generate(RadicalEntity sharedInstance, IPattern pattern, List<IController> controllers) {
        RunnableWithProgress genProcess = new RunnableWithProgress(sharedInstance, pattern, controllers);
        try {
            if (PlatformUI.isWorkbenchRunning()) {
                IProgressService ips = PlatformUI.getWorkbench().getProgressService();
                ips.run(true, true, (IRunnableWithProgress)genProcess);
            } else {
                genProcess.run((IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (InvocationTargetException e) {
            Util.rethrow((Throwable)e.getCause());
        }
        catch (InterruptedException f) {
            Util.rethrow((Throwable)f);
        }
        IGenStatus genStatus = genProcess.getStatus().getGenStatus();
        if (genStatus != null && genStatus.getState() == 1) {
            Iterator it = genStatus.getMessages();
            StringBuilder sb = new StringBuilder();
            while (it.hasNext()) {
                IStatusMessage message = (IStatusMessage)it.next();
                sb.append(message.getText());
                sb.append("\n");
            }
            Shell parent = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            MessageDialog.openError((Shell)parent, (String)"Messages.GENERATION_FAILED", (String)sb.toString());
            PdpTool.openErrorLog();
            return false;
        }
        return true;
    }

    private static class RunnableWithProgress
    implements IRunnableWithProgress {
        private IGenResult _result;
        private Object _design;
        private IPattern _pattern;
        private List<IController> _controllers;

        public RunnableWithProgress(Object design, IPattern pattern, List<IController> controllers) {
            this._design = design;
            this._pattern = pattern;
            this._controllers = controllers;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            this._result = GenerationManager.generate(this._controllers, (Object)this._design, (IPattern)this._pattern, (IProgressMonitor)monitor, null);
            this._design = null;
        }

        public IGenResult getStatus() {
            return this._result;
        }
    }
}

