/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.extension.micropattern.internal;

import com.ibm.pdp.engine.IMicroPattern;
import com.ibm.pdp.mdl.pacbase.lal.util.converter.PacNumericFormat;
import com.ibm.pdp.pacbase.PacTool;
import com.ibm.pdp.pacbase.extension.micropattern.AbstractCommonMicroPatternHandler;
import com.ibm.pdp.pacbase.extension.micropattern.AbstractWLineMicroPatternHandler;
import com.ibm.pdp.pacbase.extension.micropattern.Messages;
import com.ibm.pdp.pacbase.extension.micropattern.internal.WorkingData;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UniqueWLineMP {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2011, 2018.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Pattern WlineBeforeDECode = Pattern.compile("(\\s+|[\\s\\S]{1,6}\\s+)(\\d{2}|\\d{1})\\s+[^\\s]+(\\-|_)");
    private static final Pattern WlineLevel = Pattern.compile("(\\s+|[\\s\\S]{1,6}\\s+)(\\d{2}|\\d{1})\\s+");
    private static final Pattern DeCode = Pattern.compile("[^\\s^\\.]{1,6}");
    private static final Pattern Picture = Pattern.compile("(P|p)(I|i)(C|c)(T|t)(U|u)(R|r)(E|e)");
    private static String NEW_LINE;
    private static Pattern MPdelimiter;
    private static final String MPDelimiterRegex = "(\\.+|\\s)+";
    private String oldContent;
    private String level;
    private String afterLevel;
    private String afterPrefix;
    private String dataElementCode;
    private String rest;
    private StringBuilder newContent;
    private TextAndTags textAndtags;
    private String beginning;
    private String markAtEnd = null;

    static {
        MPdelimiter = null;
    }

    public UniqueWLineMP(String content, String newLine, boolean forceLevel) {
        this.oldContent = content;
        this.newContent = new StringBuilder();
        NEW_LINE = newLine;
        this.initialize(forceLevel);
    }

    private void initialize(boolean forceLevel) {
        int indexMark;
        if (PacTool.markAtEndOfLine() && (indexMark = this.oldContent.indexOf(NEW_LINE)) > 72) {
            this.markAtEnd = this.oldContent.substring(72, indexMark);
            this.oldContent = String.valueOf(AbstractCommonMicroPatternHandler.trimRight(this.oldContent.substring(0, 72))) + NEW_LINE;
        }
        MPdelimiter = Pattern.compile(MPDelimiterRegex + NEW_LINE);
        this.afterPrefix = UniqueWLineMP.BeforeDataElementCode(this.oldContent, this);
        String[] levelAndMore = UniqueWLineMP.AfterLevelCode(this.newContent.toString());
        if (levelAndMore[0] != null) {
            this.level = levelAndMore[0].substring(6).trim();
        }
        this.afterLevel = levelAndMore[1];
        this.rest = UniqueWLineMP.DataElementCode(this.afterPrefix, this);
        this.textAndtags = new TextAndTags();
        if (forceLevel) {
            this.newContent.replace(0, 12, "            ");
        }
        this.beginning = this.newContent.toString();
    }

    public boolean isWellFormed() {
        return this.afterPrefix != null && this.afterLevel != null && this.dataElementCode != null && this.afterPrefix.trim().length() > 0 && this.afterLevel.trim().length() > 0 && this.dataElementCode.trim().length() > 0;
    }

    public TextAndTags generate(AbstractWLineMicroPatternHandler handler, IMicroPattern microPattern) {
        WorkingData wd = new WorkingData();
        wd.setLabel(String.valueOf(this.afterLevel) + this.dataElementCode);
        wd.setEntityName(this.dataElementCode);
        wd.setFormat(handler.getReferenceFormat());
        String pictureLine = handler.createPictureLine(this.dataElementCode, this.oldContent.substring(0, this.oldContent.lastIndexOf(NEW_LINE)), wd, microPattern);
        if (pictureLine == null) {
            if (wd.getEntity() == null) {
                this.textAndtags.wellFormed = false;
                this.textAndtags.message = String.valueOf(Messages.WIESMicroPatternHandler_UNKNOWN_DATA_ELEMENT_CODE) + " : " + this.dataElementCode;
            }
            pictureLine = "";
        }
        String commentLine = handler.createCommentLine(microPattern);
        if (handler.isBreakdateOption(microPattern.getProcessingContext()) && handler.isDate(microPattern)) {
            this.newContent = new StringBuilder();
            this.appendResult(pictureLine);
            this.textAndtags.appendIndexes(this.newContent.indexOf(NEW_LINE) + NEW_LINE.length());
            this.appendResult(NEW_LINE);
            this.textAndtags.appendIndexes(this.newContent.length());
            this.textAndtags.appendIndexes(pictureLine.indexOf(NEW_LINE) + NEW_LINE.length());
        } else {
            boolean somethingAfter;
            int index = UniqueWLineMP.PointAtTheEndOfTheFirstLine(this.rest);
            if (index != -1) {
                this.appendResult(this.rest.substring(0, index));
                this.rest = this.rest.substring(index);
            } else {
                int firstCR = this.rest.indexOf(NEW_LINE);
                if (firstCR != -1) {
                    this.appendResult(this.rest.substring(0, firstCR));
                    this.rest = this.rest.substring(firstCR + NEW_LINE.length());
                }
            }
            boolean bl = somethingAfter = pictureLine.trim().length() > 0 || commentLine.trim().length() > 0;
            if (somethingAfter && PacTool.markAtEndOfLine() && this.markAtEnd != null) {
                while (this.newContent.length() < 72) {
                    this.appendResult(" ");
                }
                this.appendResult(this.markAtEnd);
            }
            if (pictureLine.trim().length() > 0) {
                this.appendResult(NEW_LINE);
                this.textAndtags.appendIndexes(this.newContent.length());
                this.appendResult(pictureLine);
                if (commentLine.trim().length() > 0) {
                    this.appendResult(NEW_LINE);
                    this.appendResult(commentLine);
                }
            } else if (commentLine.trim().length() > 0) {
                this.appendResult(NEW_LINE);
                this.textAndtags.appendIndexes(this.newContent.length());
                this.appendResult(commentLine);
            }
            if (index != -1) {
                this.appendResult(".");
                if (!somethingAfter && PacTool.markAtEndOfLine() && this.markAtEnd != null) {
                    while (this.newContent.length() < 72) {
                        this.appendResult(" ");
                    }
                    this.appendResult(this.markAtEnd);
                }
                this.appendResult(NEW_LINE);
            } else if (this.rest.trim().length() > 0) {
                while (this.rest.trim().length() > 0) {
                    int firstCR = this.rest.indexOf(NEW_LINE) + NEW_LINE.length();
                    String nextLine = this.rest.substring(0, firstCR);
                    if (UniqueWLineMP.FindLineWithPicture(nextLine)) {
                        index = UniqueWLineMP.PointAtTheEndOfTheFirstLine(nextLine);
                        this.rest = this.rest.substring(firstCR);
                        continue;
                    }
                    if (UniqueWLineMP.FindLineWithComment(nextLine)) {
                        index = UniqueWLineMP.PointAtTheEndOfTheFirstLine(nextLine);
                        this.rest = this.rest.substring(firstCR);
                        continue;
                    }
                    index = -1;
                    this.appendResult(NEW_LINE);
                    this.textAndtags.appendIndexes(this.newContent.length());
                    this.appendResult(nextLine);
                    this.rest = this.rest.substring(firstCR);
                }
                if (index != -1) {
                    this.appendResult(".");
                }
                if (!this.newContent.toString().endsWith(NEW_LINE)) {
                    this.appendResult(NEW_LINE);
                }
            } else if (!this.newContent.toString().endsWith(NEW_LINE)) {
                this.appendResult(NEW_LINE);
            }
        }
        String result = this.newContent.toString().trim();
        if (result.length() == 0) {
            this.textAndtags.setText(this.oldContent);
            if (this.textAndtags.getIndexes().isEmpty()) {
                this.textAndtags.appendIndexes(this.oldContent.length());
            }
            return this.textAndtags;
        }
        this.textAndtags.setText(this.newContent.toString());
        if (this.textAndtags.getIndexes().isEmpty()) {
            this.textAndtags.appendIndexes(this.newContent.length());
            this.textAndtags.wellFormed = false;
        }
        return this.textAndtags;
    }

    public void appendResult(String s) {
        this.newContent.append(s);
    }

    public String getDataElementCode() {
        return this.dataElementCode;
    }

    public String getLevel() {
        return this.level;
    }

    public String getCompleteZone() {
        return String.valueOf(this.afterLevel) + this.dataElementCode;
    }

    public void setDataElementCode(String code) {
        this.dataElementCode = code;
    }

    public String getBeginning() {
        return this.beginning;
    }

    private static String BeforeDataElementCode(String s, UniqueWLineMP result) {
        Matcher m = WlineBeforeDECode.matcher(s);
        if (m.lookingAt()) {
            result.appendResult(s.substring(0, m.end()));
            return s.substring(m.end());
        }
        return "";
    }

    private static String[] AfterLevelCode(String s) {
        Matcher m = WlineLevel.matcher(s);
        String[] res = new String[2];
        if (m.lookingAt()) {
            res[0] = s.substring(0, m.end());
            res[1] = s.substring(m.end());
        }
        return res;
    }

    private static String DataElementCode(String s, UniqueWLineMP result) {
        Matcher m = DeCode.matcher(s);
        if (m.lookingAt()) {
            String code = s.substring(0, m.end());
            result.setDataElementCode(code.toUpperCase());
            result.appendResult(code);
            return s.substring(m.end());
        }
        return "";
    }

    private static boolean FindLineWithPicture(String s) {
        Matcher m = Picture.matcher(s);
        return m.find();
    }

    private static boolean FindLineWithComment(String s) {
        String lineToTest = s.toUpperCase();
        for (String element : PacNumericFormat.ListOfComments) {
            Pattern p = Pattern.compile(element);
            if (!p.matcher(lineToTest).find()) continue;
            return true;
        }
        return false;
    }

    private static int PointAtTheEndOfTheFirstLine(String s) {
        Matcher m;
        int index = s.indexOf(NEW_LINE);
        String toAnalyse = s;
        if (index != -1 && index + 2 <= s.length()) {
            toAnalyse = s.substring(0, index + 2);
        }
        if ((m = MPdelimiter.matcher(toAnalyse)).find()) {
            return m.start();
        }
        return -1;
    }

    public static class TextAndTags {
        private String text;
        private ArrayList<Object> indexes = new ArrayList();
        private boolean wellFormed = true;
        private boolean specificFirst = true;
        private String message;

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }

        public ArrayList<Object> getIndexes() {
            return this.indexes;
        }

        public void appendIndexes(int index) {
            this.indexes.add(index);
        }

        public boolean isSpecificFirst() {
            return this.specificFirst;
        }

        public boolean isWellFormed() {
            return this.wellFormed;
        }

        public String getErrorMessage() {
            return this.message;
        }

        public void setSpecificFirst(boolean specificFirst) {
            this.specificFirst = specificFirst;
        }
    }
}

