/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.extension.micropattern.internal;

import com.ibm.pdp.engine.IBuilderTag;
import com.ibm.pdp.engine.IGenInfoBuilder;
import com.ibm.pdp.engine.IMicroPatternProcessingContext;
import com.ibm.pdp.framework.PdpTool;
import com.ibm.pdp.framework.cobol.micropattern.internal.MicroPatternConstants;
import com.ibm.pdp.mdl.kernel.DataAggregate;
import com.ibm.pdp.mdl.kernel.DataAggregateDescription;
import com.ibm.pdp.mdl.kernel.DataCall;
import com.ibm.pdp.mdl.kernel.DataDescription;
import com.ibm.pdp.mdl.kernel.DataElement;
import com.ibm.pdp.mdl.kernel.DataElementDescription;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.pacbase.PacBlockBase;
import com.ibm.pdp.mdl.pacbase.PacBlockBaseTypeValues;
import com.ibm.pdp.mdl.pacbase.PacDLine;
import com.ibm.pdp.mdl.pacbase.PacDRLine;
import com.ibm.pdp.mdl.pacbase.PacDataCall;
import com.ibm.pdp.mdl.pacbase.PacDataElement;
import com.ibm.pdp.mdl.pacbase.PacDataElementDescription;
import com.ibm.pdp.mdl.pacbase.PacProgramVariantValues;
import com.ibm.pdp.mdl.pacbase.PacSQLRecordTypeValues;
import com.ibm.pdp.mdl.pacbase.PacScreen;
import com.ibm.pdp.mdl.pacbase.PacScreenRecordTypeValues;
import com.ibm.pdp.mdl.pacbase.PacServer;
import com.ibm.pdp.pacbase.extension.Ebcdic;
import com.ibm.pdp.pacbase.extension.micropattern.AbstractCommonMicroPatternHandler;
import com.ibm.pdp.pacbase.util.sql.AccessGeneratorInfosForSQL;
import com.ibm.pdp.pacbase.util.sql.GeneratorInfosForSQLEntities;
import com.ibm.pdp.pacbase.util.sql.MpSQLExtractionMethod;
import com.ibm.pdp.pacbase.util.sql.SQLUtilities;
import com.ibm.pdp.pacbase.util.sql.ScreenGeneratorInfosForSQL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;

public class SQLAndF80Utilities
implements MicroPatternConstants {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2011, 2020.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String NEW_LINE = "\r\n";
    public static final String EQUAL = " =  ";
    public static final String GRT = " >  ";
    public static final String ORDBY = "ORDER BY";
    public static final String EXEC = "EXEC SQL ";
    public static final String END = "END-EXEC";
    public static final String DC = "DECLARE";
    public static final String DIS = " DISPLAY_";
    public static final String ALL = " ALL_";
    public static final String FR = "FROM      ";
    public static final String SPACE = "         ";
    public static final String SEP = ",";
    public static final String INTO = "INTO     ";
    public static final String SELECT = "SELECT ALL ";
    public static final String SELECTSTAR = "SELECT * ";
    public static final String FETCH = "FETCH  ";
    public static final String UPDATE = "UPDATE ";
    public static final String INSERT = "INSERT ";
    public static final String DEL = "DELETE ";
    public static final String OPEN = "OPEN   ";
    public static final String CLOSE = "CLOSE  ";
    public static final String CURS = "CURSOR";
    public static final String FSA = "FOR SELECT ALL";
    public static final String FSSTAR = "FOR SELECT *";
    public static final String WHERE = "WHERE ";
    public static final String ORDERBY = "ORDER BY ";
    public static final String AND = "   AND ";
    public static final String OR = "   OR ";
    public static final String CURSMR = "WITH ROWSET POSITIONING";
    public static final String INTO2 = "INTO      ";
    public static final String SET = "SET     ";
    public static final String VALUES = "VALUES ( ";
    public static final String PARO = "       (";
    public static final String PAROS = "(";
    public static final String PARC = ")";
    public static final String DOT = ".";
    public static final String RNMR1 = "                 IF CURS-ENDRS =  1\r\n                 AND RCURSR NOT < RCURSL\r\n           MOVE 1 TO ZZ-XX\r\n           GO TO F95SF-CURS-RN-FN.\r\n                 IF RCURSR < RCURSL\r\n           GO TO F95SF-CURS-RN-MOVE.\r\n           EXEC SQL\r\n           FETCH NEXT ROWSET DISPLAY_CURS\r\n           FOR :RCURSM ROWS";
    public static final String RNMR2 = "           END-EXEC\r\n           MOVE 0 TO RCURSR\r\n           MOVE SQLERRD (3) TO RCURSL.\r\n                 IF SQLCODE = +100\r\n           MOVE 1 TO CURS-ENDRS.\r\n                 IF RCURSL = 0\r\n           MOVE 1 TO ZZ-XX\r\n           GO TO F95SF-CURS-RN-FN.\r\n       F95SF-CURS-RN-MOVE. EXIT.\r\n           ADD 1 TO RCURSR";
    public static final String RNMR3 = "       F95SF-CURS-RN-FN. EXIT.\r\n";
    public static final String MOVE = "MOVE      '";
    public static final String MOVEEX = "MOVE  'EXTRACT NAME : ";
    public static final String EXCL1 = "IF  L-CURS-EXTNAM NOT = SPACE";
    public static final String EXCL2 = "           AND TECH-CALSRV NOT = SPACE AND TECH-CALSRV NOT = 'L'";
    public static final String EXCL3 = "           AND TECH-CALSRV NOT = 'C'        GO TO F80-OK.";
    public static final String CSCL1 = "IF TECH-CALSRV NOT = SPACE AND TECH-CALSRV NOT = 'L'";
    public static final String INFOTYPE = "' TO  V-INFO-TYPE";
    public static final String INFOCODE = "' TO  V-INFO-CODE";
    public static final String SQLCODE = " IF SQLCODE = ZERO \r\n               GO TO F80-OK ELSE GO TO F80-KO.";
    public static final String GO80 = "GO TO F80-OK.\r\n";
    public static final String FILE_RANK_PROPERTY = "refInPgm";
    static List<Keys> lsKeys = new ArrayList<Keys>();

    public static void updateLastColumn(GeneratorInfosForSQLEntities.MPALine contribution, String standardAccess) {
        String endLine = "";
        String lastLineUpdated = "";
        if (standardAccess.equals("W")) {
            endLine = PARC;
        }
        String lastLine = contribution.getLastLine();
        int posSepLastLine = lastLine.length() - 1;
        lastLineUpdated = String.valueOf(lastLine.substring(0, posSepLastLine)) + endLine;
        contribution.setLastLine(lastLineUpdated);
    }

    public static void updateLastVline(GeneratorInfosForSQLEntities.MPALine contribution, String standardAccess) {
        String endLine = "";
        String lastLineUpdated = "";
        if (standardAccess.equals("R") || standardAccess.equals("RN") || standardAccess.equals("RU") || standardAccess.equals("RA")) {
            endLine = "";
        }
        if (standardAccess.equals("W")) {
            endLine = PARC;
        }
        String lastLine = contribution.getLastLine();
        int posSepLastLine = lastLine.length() - 1;
        lastLineUpdated = String.valueOf(lastLine.substring(0, posSepLastLine)) + endLine;
        contribution.setLastLine(lastLineUpdated);
    }

    private static void writeForBrowseAccess(GeneratorInfosForSQLEntities.MPALine contribution) {
        contribution.append(NEW_LINE);
        contribution.append("           ");
        contribution.append(" FOR BROWSE ACCESS");
    }

    private static void writeDeclareCursorFSA(GeneratorInfosForSQLEntities.MPALine contribution, String cursorCode) {
        contribution.append(NEW_LINE);
        contribution.append("           ");
        contribution.append("DECLARE DISPLAY_" + cursorCode);
        contribution.append(NEW_LINE);
        contribution.append("           ");
        contribution.append("CURSOR FOR SELECT ALL");
    }

    private static void writeDeclareCursorStar(GeneratorInfosForSQLEntities.MPALine contribution, String cursorCode) {
        contribution.append(NEW_LINE);
        contribution.append("           ");
        contribution.append("DECLARE DISPLAY_" + cursorCode);
        contribution.append(NEW_LINE);
        contribution.append("           ");
        contribution.append("CURSOR FOR SELECT *");
    }

    private static void writeDeclareCursorAll(GeneratorInfosForSQLEntities.MPALine contribution, String cursorCode) {
        contribution.append(NEW_LINE);
        contribution.append("           ");
        contribution.append("DECLARE ALL_" + cursorCode);
        contribution.append(NEW_LINE);
        contribution.append("           ");
        contribution.append("CURSOR FOR SELECT ALL");
    }

    private static void writeDeclareCursorEx(GeneratorInfosForSQLEntities.MPALine contribution, String cursorCode) {
        contribution.append(NEW_LINE);
        contribution.append("           ");
        contribution.append("DECLARE " + cursorCode);
        contribution.append(NEW_LINE);
        contribution.append("           ");
        contribution.append("CURSOR FOR SELECT ALL");
    }

    private static void writeDeclareCursorForMultiRow(GeneratorInfosForSQLEntities.MPALine contribution, String cursorCode) {
        contribution.append(NEW_LINE);
        contribution.append("           ");
        contribution.append("DECLARE DISPLAY_" + cursorCode + " " + CURS);
        contribution.append(NEW_LINE);
        contribution.append("           ");
        contribution.append(CURSMR);
        contribution.append(NEW_LINE);
        contribution.append("           ");
        contribution.append(FSA);
    }

    private static void writeRorRULine(GeneratorInfosForSQLEntities.MPALine contribution, boolean all) {
        contribution.append(NEW_LINE);
        contribution.append("           ");
        if (all) {
            contribution.append(SELECT);
        } else {
            contribution.append(SELECTSTAR);
        }
    }

    private static void writeRNLine(GeneratorInfosForSQLEntities.MPALine contribution, String cursorCode) {
        contribution.append(NEW_LINE);
        contribution.append("           ");
        contribution.append("FETCH   DISPLAY_" + cursorCode);
    }

    private static void writeRNAllLine(GeneratorInfosForSQLEntities.MPALine contribution, String cursorCode) {
        contribution.append(NEW_LINE);
        contribution.append("           ");
        contribution.append("FETCH   ALL_" + cursorCode);
    }

    private static void writeRNExLine(GeneratorInfosForSQLEntities.MPALine contribution, String cursorCode) {
        contribution.append(NEW_LINE);
        contribution.append("           ");
        contribution.append(FETCH + cursorCode);
    }

    private static void writeWLine(GeneratorInfosForSQLEntities.MPALine contribution) {
        contribution.append(NEW_LINE);
        contribution.append("           ");
        contribution.append(INSERT);
    }

    private static void writeRWLine(GeneratorInfosForSQLEntities.MPALine contribution) {
        contribution.append(NEW_LINE);
        contribution.append("           ");
        contribution.append(UPDATE);
    }

    private static void writeDLine(GeneratorInfosForSQLEntities.MPALine contribution) {
        contribution.append(NEW_LINE);
        contribution.append("           ");
        contribution.append(DEL);
    }

    private static void writePLine(GeneratorInfosForSQLEntities.MPALine contribution, String cursorCode) {
        contribution.append(NEW_LINE);
        contribution.append("           ");
        contribution.append("OPEN    DISPLAY_" + cursorCode);
    }

    private static void writePAllLine(GeneratorInfosForSQLEntities.MPALine contribution, String cursorCode) {
        contribution.append(NEW_LINE);
        contribution.append("           ");
        contribution.append("OPEN    ALL_" + cursorCode);
    }

    private static void writePExLine(GeneratorInfosForSQLEntities.MPALine contribution, String cursorCode) {
        contribution.append(NEW_LINE);
        contribution.append("           ");
        contribution.append(OPEN + cursorCode);
    }

    private static void writeFromOrIntoLine(GeneratorInfosForSQLEntities entInfos, GeneratorInfosForSQLEntities.MPALine contribution, boolean fromTableCode) {
        String accessFrom = "";
        accessFrom = entInfos.isHeritedAccess() && entInfos.getHeritedAccess().trim().length() > 0 ? entInfos.getHeritedAccess() : entInfos.getStandardAccess();
        String access = entInfos.getStandardAccess();
        if (access.equals("")) {
            access = entInfos.getNoStandardAccess();
        }
        SQLUtilities.standardAccessList accessType = SQLUtilities.getAccess((String)entInfos.getStandardAccess());
        if (!(accessFrom.equals("P") || accessFrom.equals("RN") || accessFrom.equals("CL"))) {
            if (!accessType.equals((Object)SQLUtilities.standardAccessList.SP)) {
                accessFrom = entInfos.getStandardAccess();
            }
            if (fromTableCode) {
                SQLAndF80Utilities.writeFromIntoLine(contribution, accessFrom, SQLAndF80Utilities.getTableCode(entInfos), entInfos.getDag());
            } else {
                SQLAndF80Utilities.writeFromIntoLine(contribution, accessFrom, entInfos.getDag().getProxyName(), entInfos.getDag());
            }
        }
    }

    private static void writeFromIntoLine(GeneratorInfosForSQLEntities.MPALine contribution, String standardAccess, String tableCode, DataAggregate dag) {
        String beginLine = SPACE;
        if (standardAccess.equals("DC") || standardAccess.equals("*D") || standardAccess.equals("R") || standardAccess.equals("RU") || standardAccess.equals("D") || standardAccess.equals("RA") || standardAccess.equals("EX")) {
            beginLine = FR;
        }
        if (standardAccess.equals("W")) {
            beginLine = INTO;
        }
        if (standardAccess.equals("RW")) {
            beginLine = SPACE;
        }
        if (!tableCode.equals("")) {
            contribution.append(NEW_LINE);
            contribution.append("           ");
            contribution.append(String.valueOf(beginLine) + tableCode);
        } else {
            contribution.append(NEW_LINE);
            contribution.append("           ");
            contribution.append(String.valueOf(beginLine) + dag.getProxyName());
        }
    }

    private static String getDBDTableCode(GeneratorInfosForSQLEntities entinfos) {
        String tableCode = "";
        PacBlockBase pbb = entinfos.getPbb();
        DataAggregate dag = entinfos.getDag();
        for (PacDRLine drLine : pbb.getDRLines()) {
            if (drLine.getSegment() == null || !drLine.getSegment().getName().equals(dag.getProxyName())) continue;
            if (entinfos.getPgm() != null && (drLine.getSqlRecordType().equals(PacSQLRecordTypeValues._T_LITERAL) || drLine.getSqlRecordType().equals(PacSQLRecordTypeValues._V_LITERAL))) {
                tableCode = drLine.getDataBaseObjectExternalName();
                break;
            }
            if (entinfos.getPgm() != null) continue;
            if (drLine.getSqlRecordType().equals(PacSQLRecordTypeValues._T_LITERAL) && entinfos.getRecordTypeValue().equals(PacScreenRecordTypeValues._T_LITERAL) || drLine.getSqlRecordType().equals(PacSQLRecordTypeValues._V_LITERAL) && entinfos.getRecordTypeValue().equals(PacScreenRecordTypeValues._V_LITERAL)) {
                tableCode = drLine.getDataBaseObjectExternalName();
                break;
            }
            if (!entinfos.getRecordTypeValue().equals(PacScreenRecordTypeValues._NONE_LITERAL) || !drLine.getSqlRecordType().equals(PacSQLRecordTypeValues._T_LITERAL) && !drLine.getSqlRecordType().equals(PacSQLRecordTypeValues._V_LITERAL)) continue;
            tableCode = drLine.getDataBaseObjectExternalName();
            break;
        }
        return tableCode;
    }

    private static String getTableCode(GeneratorInfosForSQLEntities entinfos) {
        String tableCode = "";
        PacBlockBase pbb = entinfos.getPbb();
        if (pbb != null) {
            tableCode = SQLAndF80Utilities.getDBDTableCode(entinfos);
        }
        if (tableCode.startsWith(DOT)) {
            return tableCode.substring(1);
        }
        return tableCode;
    }

    private static void writeSpecificFromLine(GeneratorInfosForSQLEntities.MPALine contribution, AccessGeneratorInfosForSQL.SQLAccessLine sqlal, String standardAccess) {
        String ordre = "";
        ordre = standardAccess.equals("W") ? INTO : (standardAccess.equals("RW") ? SPACE : FR);
        if (!sqlal.isAdd().booleanValue() && sqlal.getNumLine() == 1) {
            contribution.append(NEW_LINE);
            contribution.append("           ");
            contribution.append(String.valueOf(ordre) + " " + sqlal.getDescription().toUpperCase());
        } else {
            contribution.append(NEW_LINE);
            contribution.append("           ");
            contribution.append(sqlal.getDescription().toUpperCase());
        }
    }

    private static void writeFetchOnly(GeneratorInfosForSQLEntities.MPALine contribution) {
        contribution.append(NEW_LINE);
        contribution.append("           ");
        contribution.append(" FOR FETCH ONLY");
    }

    private static void writeForUpdate(GeneratorInfosForSQLEntities.MPALine contribution) {
        contribution.append(NEW_LINE);
        contribution.append("           ");
        contribution.append(" FOR UPDATE");
    }

    private static void writeCLLine(GeneratorInfosForSQLEntities.MPALine contribution, String cursorCode) {
        contribution.append(NEW_LINE);
        contribution.append("           ");
        contribution.append("CLOSE   DISPLAY_" + cursorCode);
    }

    private static void writeCLAllLine(GeneratorInfosForSQLEntities.MPALine contribution, String cursorCode) {
        contribution.append(NEW_LINE);
        contribution.append("           ");
        contribution.append("CLOSE   ALL_" + cursorCode);
    }

    private static void writeCLExLine(GeneratorInfosForSQLEntities.MPALine contribution, String cursorCode) {
        contribution.append(NEW_LINE);
        contribution.append("           ");
        contribution.append(CLOSE + cursorCode);
    }

    private static void writeCSLinesEx(GeneratorInfosForSQLEntities.MPALine contribution, String access, String tableCode) {
        if (access.equals("CL")) {
            contribution.append("           ");
            contribution.append(EXCL1);
            contribution.append(NEW_LINE);
            contribution.append(EXCL2);
            contribution.append(NEW_LINE);
            contribution.append(EXCL3);
            contribution.append(NEW_LINE);
        }
        contribution.append("           ");
        contribution.append(MOVE + SQLAndF80Utilities.completeWithBlanks(access, 2) + INFOTYPE + DOT);
        contribution.append(NEW_LINE);
        contribution.append("           ");
        contribution.append(MOVEEX + tableCode + INFOCODE + DOT);
        contribution.append(NEW_LINE);
    }

    private static void writeCSLines(GeneratorInfosForSQLEntities.MPALine contribution, String standardAccess, DataAggregate dag, PacBlockBase pbb, String tableCode) {
        if (standardAccess.equals("CL")) {
            contribution.append("           ");
            contribution.append(CSCL1);
            contribution.append(NEW_LINE);
            contribution.append(EXCL3);
            contribution.append(NEW_LINE);
        }
        contribution.append("           ");
        contribution.append(MOVE + SQLAndF80Utilities.completeWithBlanks(standardAccess, 2) + INFOTYPE + DOT);
        contribution.append(NEW_LINE);
        contribution.append("           ");
        contribution.append(MOVE + SQLAndF80Utilities.completeWithBlanks(tableCode, 27) + INFOCODE + DOT);
        contribution.append(NEW_LINE);
    }

    private static String completeWithBlanks(String tableCode, int maxLength) {
        StringBuffer sb = new StringBuffer(tableCode);
        int i = tableCode.length();
        while (i < maxLength) {
            sb.append(" ");
            ++i;
        }
        return sb.toString();
    }

    private static void writeCSLinesSP(GeneratorInfosForSQLEntities.MPALine contribution, String standardAccess, DataAggregate dag, PacBlockBase pbb, String tableCode) {
        contribution.append("           ");
        contribution.append(MOVE + SQLAndF80Utilities.completeWithBlanks(standardAccess, 2) + INFOTYPE + DOT);
        contribution.append(NEW_LINE);
        contribution.append("           ");
        contribution.append("MOVE      'SEGMENT CODE : " + tableCode + INFOCODE + DOT);
        contribution.append(NEW_LINE);
    }

    private static void writeEtiqBegin(GeneratorInfosForSQLEntities.MPALine contribution, String cursorCode, String nostandardAccess) {
        contribution.append("       F80-" + cursorCode + "-" + nostandardAccess + DOT);
        contribution.append(NEW_LINE);
    }

    private static void writeEtiqBeginExtractMethod(GeneratorInfosForSQLEntities.MPALine contribution, String cursorCode, String extractMethod, String access) {
        contribution.append("       F80-" + cursorCode + "-" + access + "-" + extractMethod + DOT);
        contribution.append(NEW_LINE);
    }

    private static void writeEtiqEnd(GeneratorInfosForSQLEntities.MPALine contribution, String nostandardAccess) {
        contribution.append("       F80" + nostandardAccess + "-FN.");
        contribution.append(NEW_LINE);
    }

    private static void writeWhereDC(GeneratorInfosForSQLEntities genInfos, GeneratorInfosForSQLEntities.MPALine contribution, ArrayList<String> lsDataElementCode, ArrayList<String> lsLabel) {
        int size = lsDataElementCode.size();
        boolean isAllControlBreak = true;
        String firstkeysuite = "";
        int i = 0;
        while (i < size) {
            String controlBreak = "";
            if (lsDataElementCode.get(i).indexOf(SEP) > -1) {
                controlBreak = lsDataElementCode.get(i).substring(lsDataElementCode.get(i).indexOf(SEP) + 1);
            }
            if (!controlBreak.equals("E") && !controlBreak.equals("R")) {
                isAllControlBreak = false;
                if (i == 0) {
                    firstkeysuite = SQLAndF80Utilities.writeFollowingFirstKey(lsDataElementCode.get(i).substring(0, lsDataElementCode.get(i).indexOf(SEP)), lsLabel.get(i), genInfos.getCursorCode());
                }
            }
            ++i;
        }
        if (size == 1) {
            SQLAndF80Utilities.writeWhereDCOneKey(contribution, genInfos, lsDataElementCode, lsLabel);
        } else if (isAllControlBreak) {
            SQLAndF80Utilities.writeWhereDCCBAll(contribution, genInfos, lsDataElementCode, lsLabel);
        } else {
            SQLAndF80Utilities.writeWhereDCKeys(contribution, genInfos, lsDataElementCode, lsLabel);
            contribution.append(firstkeysuite);
        }
    }

    private static String writeFollowingFirstKey(String dataelementCode, String rellabel, String cursorCode) {
        StringBuilder sb = new StringBuilder();
        sb.append(NEW_LINE);
        sb.append("           ");
        sb.append(AND + rellabel + " >= ");
        sb.append(NEW_LINE);
        sb.append(SPACE).append("             ");
        sb.append(":").append(cursorCode).append("-").append(dataelementCode);
        return sb.toString();
    }

    private static void writeWhereDCOneKey(GeneratorInfosForSQLEntities.MPALine contribution, GeneratorInfosForSQLEntities genInfos, ArrayList<String> lsDataElementCode, ArrayList<String> lsLabel) {
        int size = lsDataElementCode.size();
        String standardAccess = genInfos.getStandardAccess();
        String cursorCode = genInfos.getCursorCode();
        int i = 0;
        if (i < size) {
            String rellabel = lsLabel.get(i);
            String dataelementCode = "";
            String controlBreak = "";
            if (lsDataElementCode.get(i).indexOf(SEP) > -1) {
                dataelementCode = lsDataElementCode.get(i).substring(0, lsDataElementCode.get(i).indexOf(SEP));
                controlBreak = lsDataElementCode.get(i).substring(lsDataElementCode.get(i).indexOf(SEP) + 1);
            } else {
                dataelementCode = lsDataElementCode.get(i);
            }
            String eq = "";
            String parc = PARC;
            eq = controlBreak.equals("E") || controlBreak.equals("R") ? " =" : " >=";
            contribution.append(NEW_LINE);
            contribution.append("           ");
            if (standardAccess.equals("DC") && genInfos.getSrv() != null || genInfos.getScr() != null && SQLUtilities.isClient((PacScreen)genInfos.getScr())) {
                contribution.append("WHERE (" + rellabel + eq);
                contribution.append(NEW_LINE);
                contribution.append("                       :" + cursorCode + "-" + dataelementCode + parc);
            } else {
                contribution.append(WHERE + rellabel + eq);
                contribution.append(NEW_LINE);
                contribution.append("                       :" + cursorCode + "-" + dataelementCode);
            }
        }
    }

    private static void writeWhereDCKeys(GeneratorInfosForSQLEntities.MPALine contribution, GeneratorInfosForSQLEntities genInfos, ArrayList<String> lsDataElementCode, ArrayList<String> lsLabel) {
        String cursorCode = genInfos.getCursorCode();
        ArrayList<String> lskeynobreak = null;
        ArrayList<String> lshostVarnobreak = null;
        String currentRelLabel = "";
        StringBuffer currentHostvar = new StringBuffer();
        boolean done = false;
        int i = 0;
        while (i < lsLabel.size()) {
            if (lskeynobreak != null) {
                lskeynobreak.add(currentRelLabel);
            }
            if (lshostVarnobreak != null) {
                lshostVarnobreak.add(currentHostvar.toString());
            }
            currentRelLabel = lsLabel.get(i);
            String currentDataElementCode = "";
            String currentControlBreak = "";
            if (lsDataElementCode.get(i).indexOf(SEP) > -1) {
                currentDataElementCode = lsDataElementCode.get(i).substring(0, lsDataElementCode.get(i).indexOf(SEP));
                currentControlBreak = lsDataElementCode.get(i).substring(lsDataElementCode.get(i).indexOf(SEP) + 1);
            } else {
                currentDataElementCode = lsDataElementCode.get(i);
            }
            Keys key = new Keys(cursorCode, currentDataElementCode);
            key.setRelationalLabel(currentRelLabel);
            key.setControlBreak(currentControlBreak);
            currentHostvar = new StringBuffer();
            currentHostvar.append(":").append(cursorCode).append("-").append(currentDataElementCode);
            key.setHostVar(currentHostvar.toString());
            if (!(currentControlBreak.equals("E") || currentControlBreak.equals("R") || done)) {
                lskeynobreak = new ArrayList<String>();
                lshostVarnobreak = new ArrayList<String>();
                done = true;
            }
            if (lskeynobreak != null) {
                key.getLsPreviousRelLabel().addAll((Collection<String>)lskeynobreak);
            }
            if (lshostVarnobreak != null) {
                key.getLsPreviousHostVar().addAll((Collection<String>)lshostVarnobreak);
            }
            lsKeys.add(key);
            ++i;
        }
        StringBuffer newline = new StringBuffer(NEW_LINE);
        newline.append("           ");
        boolean first = false;
        boolean hasPreviousKeyWithBreak = false;
        int j = 0;
        while (j < lsKeys.size()) {
            Keys key = lsKeys.get(j);
            String endRelLabelLine = "";
            String endHostVarLine = "";
            if (key.getControlBreak().equals("E") || key.getControlBreak().equals("R")) {
                endRelLabelLine = EQUAL;
                endHostVarLine = AND;
            } else {
                endRelLabelLine = GRT;
                endHostVarLine = "";
            }
            if (j == 0) {
                contribution.append(newline.toString());
                if (genInfos.getSrv() != null || genInfos.getScr() != null && SQLUtilities.isClient((PacScreen)genInfos.getScr())) {
                    contribution.append("WHERE (" + key.getRelationalLabel() + endRelLabelLine);
                } else {
                    contribution.append(WHERE + currentRelLabel + endRelLabelLine);
                }
                contribution.append(newline.toString());
                contribution.append(SPACE);
                contribution.append(String.valueOf(key.getHostVar().toString()) + endHostVarLine);
            } else {
                if (!key.getLsPreviousRelLabel().isEmpty()) {
                    int k = 0;
                    while (k < key.getLsPreviousRelLabel().size()) {
                        String prevRelLabel = key.getLsPreviousRelLabel().get(k);
                        String prevHostVar = key.getLsPreviousHostVar().get(k);
                        if (k == 0) {
                            contribution.append(newline.toString());
                            contribution.append("   OR (" + prevRelLabel + EQUAL);
                            contribution.append(newline.toString());
                            contribution.append(SPACE);
                            contribution.append(prevHostVar);
                        } else {
                            contribution.append(newline.toString());
                            contribution.append(AND + prevRelLabel);
                            contribution.append(newline.toString());
                            contribution.append(SPACE);
                            contribution.append(EQUAL + prevHostVar);
                        }
                        ++k;
                    }
                } else {
                    hasPreviousKeyWithBreak = true;
                    if (key.getControlBreak().equals("E") || key.getControlBreak().equals("R")) {
                        contribution.append(newline.toString());
                        contribution.append("       ");
                        contribution.append(String.valueOf(key.getRelationalLabel()) + EQUAL);
                        contribution.append(newline.toString());
                        contribution.append(SPACE);
                        first = true;
                    } else {
                        contribution.append(newline.toString());
                        if (j == lsKeys.size() - 1) {
                            contribution.append("       " + key.getRelationalLabel());
                            contribution.append(" >= ");
                        } else {
                            contribution.append("      (" + key.getRelationalLabel());
                            contribution.append(GRT);
                        }
                        contribution.append(newline.toString());
                        contribution.append(SPACE);
                        first = true;
                    }
                }
                if (!first) {
                    contribution.append(newline.toString());
                    contribution.append(AND + key.getRelationalLabel());
                    contribution.append(newline.toString());
                    contribution.append(SPACE);
                }
                if (j == lsKeys.size() - 1) {
                    if (key.getControlBreak().equals("E") || key.getControlBreak().equals("R")) {
                        contribution.append(EQUAL + key.getHostVar() + PARC + PARC);
                    } else if (!first) {
                        contribution.append(" >= " + key.getHostVar() + PARC + PARC);
                    } else {
                        contribution.append(key.getHostVar());
                    }
                    if (hasPreviousKeyWithBreak) {
                        contribution.append(PARC);
                        hasPreviousKeyWithBreak = false;
                    }
                } else if (!first) {
                    contribution.append(String.valueOf(endRelLabelLine) + key.getHostVar() + PARC);
                } else if (key.getControlBreak().equals("E") || key.getControlBreak().equals("R")) {
                    contribution.append(String.valueOf(key.getHostVar()) + endHostVarLine);
                } else {
                    contribution.append(key.getHostVar());
                }
                first = false;
            }
            ++j;
        }
        lsKeys.clear();
    }

    private static void writeWhereDCCBAll(GeneratorInfosForSQLEntities.MPALine contribution, GeneratorInfosForSQLEntities genInfos, ArrayList<String> lsDataElementCode, ArrayList<String> lsLabel) {
        String cursorCode = genInfos.getCursorCode();
        String standardAccess = genInfos.getStandardAccess();
        int i = 0;
        while (i < lsLabel.size()) {
            String rellabel = lsLabel.get(i);
            String dataelementCode = "";
            dataelementCode = lsDataElementCode.get(i).indexOf(SEP) > -1 ? lsDataElementCode.get(i).substring(0, lsDataElementCode.get(i).indexOf(SEP)) : lsDataElementCode.get(i);
            contribution.append(NEW_LINE);
            contribution.append("           ");
            if (i == 0) {
                if (standardAccess.equals("DC") && (genInfos.getSrv() != null || genInfos.getScr() != null && SQLUtilities.isClient((PacScreen)genInfos.getScr()))) {
                    contribution.append("WHERE (" + rellabel + EQUAL);
                } else {
                    contribution.append(WHERE + rellabel + EQUAL);
                }
                contribution.append(NEW_LINE);
                contribution.append("                       :" + cursorCode + "-" + dataelementCode + AND);
            } else {
                contribution.append("       " + rellabel + EQUAL);
                contribution.append(NEW_LINE);
                contribution.append("           ");
                if (i != lsLabel.size() - 1) {
                    contribution.append("              :" + cursorCode + "-" + dataelementCode + AND);
                }
                if (i == lsLabel.size() - 1) {
                    if (standardAccess.equals("DC") && (genInfos.getSrv() != null || genInfos.getScr() != null && SQLUtilities.isClient((PacScreen)genInfos.getScr()))) {
                        contribution.append("              :" + cursorCode + "-" + dataelementCode + PARC);
                    } else {
                        contribution.append("              :" + cursorCode + "-" + dataelementCode);
                    }
                }
            }
            ++i;
        }
    }

    private static void writeWhere(GeneratorInfosForSQLEntities genInfos, GeneratorInfosForSQLEntities.MPALine contribution, ArrayList<String> lsDataElementCode, ArrayList<String> lsRelationalLabel) {
        String cursorCode = genInfos.getCursorCode();
        PacServer srv = genInfos.getSrv();
        String standardAccess = genInfos.getStandardAccess();
        int i = 0;
        while (i < lsRelationalLabel.size()) {
            String rellabel = lsRelationalLabel.get(i);
            String dataelementCode = "";
            String controlBreak = "";
            if (lsDataElementCode.get(i).indexOf(SEP) > -1) {
                dataelementCode = lsDataElementCode.get(i).substring(0, lsDataElementCode.get(i).indexOf(SEP));
                controlBreak = lsDataElementCode.get(i).substring(lsDataElementCode.get(i).indexOf(SEP) + 1);
            } else {
                dataelementCode = lsDataElementCode.get(i);
            }
            contribution.append(NEW_LINE);
            contribution.append("           ");
            if (srv == null) {
                if (i == 0) {
                    contribution.append(WHERE + rellabel + " = :" + cursorCode + "-" + dataelementCode);
                } else {
                    contribution.append(AND + rellabel + " = :" + cursorCode + "-" + dataelementCode);
                }
            } else {
                String eq = " =";
                String paro = "";
                String parc = "";
                if (standardAccess.equals("DC") || standardAccess.equals("*D")) {
                    if (!controlBreak.equals("E") && !controlBreak.equals("R")) {
                        eq = " >=";
                    }
                    paro = PARO;
                    parc = PARC;
                }
                if (i == 0) {
                    if (lsRelationalLabel.size() == 1) {
                        if (standardAccess.equals("DC")) {
                            contribution.append(WHERE + paro + rellabel + eq);
                            contribution.append(NEW_LINE);
                            contribution.append("                       :" + cursorCode + "-" + dataelementCode + parc);
                        } else {
                            contribution.append(WHERE + rellabel + eq);
                            contribution.append(NEW_LINE);
                            contribution.append("                       :" + cursorCode + "-" + dataelementCode);
                        }
                    } else {
                        contribution.append(WHERE + paro + rellabel + eq);
                        contribution.append(NEW_LINE);
                        contribution.append("                       :" + cursorCode + "-" + dataelementCode);
                    }
                } else {
                    contribution.append(AND + rellabel + eq);
                    contribution.append(NEW_LINE);
                    if (i != lsRelationalLabel.size() - 1) {
                        contribution.append("                       :" + cursorCode + "-" + dataelementCode);
                    }
                    if (i == lsRelationalLabel.size() - 1) {
                        contribution.append("                       :" + cursorCode + "-" + dataelementCode + parc);
                    }
                }
            }
            ++i;
        }
    }

    private static void writeOrderBy(GeneratorInfosForSQLEntities genInfos, GeneratorInfosForSQLEntities.MPALine contribution, ArrayList<String> lsDataElementCode, ArrayList<String> lsLabel) {
        String cursorCode = genInfos.getCursorCode();
        PacServer srv = genInfos.getSrv();
        String standardAccess = genInfos.getStandardAccess();
        int i = 0;
        while (i < lsLabel.size()) {
            String rellabel = lsLabel.get(i);
            String dataelementCode = "";
            dataelementCode = lsDataElementCode.get(i).indexOf(SEP) > -1 ? lsDataElementCode.get(i).substring(0, lsDataElementCode.get(i).indexOf(SEP)) : lsDataElementCode.get(i);
            contribution.append(NEW_LINE);
            contribution.append("           ");
            if (!standardAccess.equals("DC") && !standardAccess.equals("*D")) {
                if (srv == null) {
                    if (i == 0) {
                        contribution.append(ORDERBY + rellabel + " = :" + cursorCode + "-" + dataelementCode);
                    } else {
                        contribution.append(AND + rellabel + " = :" + cursorCode + "-" + dataelementCode);
                    }
                } else if (i == 0) {
                    contribution.append(ORDERBY + rellabel + " =");
                    contribution.append(NEW_LINE);
                    contribution.append("                       :" + cursorCode + "-" + dataelementCode);
                } else {
                    contribution.append(AND + rellabel + " =");
                    contribution.append(NEW_LINE);
                    contribution.append("                       :" + cursorCode + "-" + dataelementCode);
                }
            } else if (i == 0) {
                if (i == lsLabel.size() - 1) {
                    contribution.append(ORDERBY + rellabel);
                } else {
                    contribution.append(ORDERBY + rellabel + ',');
                }
            } else if (i == lsLabel.size() - 1) {
                contribution.append(rellabel);
            } else {
                contribution.append(String.valueOf(rellabel) + ',');
            }
            ++i;
        }
    }

    private static void writeFromClause(GeneratorInfosForSQLEntities.MPALine contribution, GeneratorInfosForSQLEntities entInfos) {
        if (entInfos.getCursorCode().startsWith(entInfos.getSdCode())) {
            if (entInfos.getPbb() != null) {
                if (!entInfos.getPbb().getBlockType().equals(PacBlockBaseTypeValues._QR_LITERAL)) {
                    SQLAndF80Utilities.writeFromOrIntoLine(entInfos, contribution, true);
                }
            } else {
                SQLAndF80Utilities.writeFromOrIntoLine(entInfos, contribution, false);
            }
        }
    }

    private static void writeFromIntoLine(GeneratorInfosForSQLEntities.MPALine contribution, ArrayList<AccessGeneratorInfosForSQL.SQLAccessLine> sqlalListFrom, String standardAccess, DataAggregate dag, String tableCode) {
        for (AccessGeneratorInfosForSQL.SQLAccessLine sqlal : sqlalListFrom) {
            if (sqlal.isAdd().booleanValue() && sqlal.getNumLine() == 1) {
                SQLAndF80Utilities.writeFromIntoLine(contribution, standardAccess, tableCode, dag);
            }
            SQLAndF80Utilities.writeSpecificFromLine(contribution, sqlal, standardAccess);
        }
    }

    private static void writeGoToF80(GeneratorInfosForSQLEntities.MPALine contribution, PacBlockBaseTypeValues blocType) {
        contribution.append("           ");
        if (blocType.equals(PacBlockBaseTypeValues._QN_LITERAL)) {
            contribution.append(SQLCODE);
        } else {
            contribution.append(GO80);
        }
    }

    private static void writeGoToF80(GeneratorInfosForSQLEntities.MPALine contribution) {
        contribution.append("           ");
        contribution.append(GO80);
    }

    private static void writeExecLine(GeneratorInfosForSQLEntities.MPALine contribution) {
        contribution.append("           ");
        contribution.append(EXEC);
    }

    private static void writeExecAt(GeneratorInfosForSQLEntities.MPALine contribution, String externalName) {
        contribution.append("           ");
        contribution.append("EXEC SQL  AT " + externalName);
    }

    public static void generateSpecificCL(AccessGeneratorInfosForSQL accessGenInfos) {
        GeneratorInfosForSQLEntities.MPALine contribution = accessGenInfos.getGenInfos().getMpaline();
        GeneratorInfosForSQLEntities entInfos = accessGenInfos.getGenInfos();
        ArrayList sqlalListAccess = entInfos.getListAccess();
        ArrayList sqlalListColumn = entInfos.getListColumn();
        ArrayList sqlalListFrom = entInfos.getListFrom();
        ArrayList sqlalListOther = entInfos.getListOther();
        ArrayList sqlalListOrder = entInfos.getListOrder();
        ArrayList sqlalListParam = entInfos.getListParam();
        boolean isHeritedAccess = entInfos.isHeritedAccess();
        String heritedAccess = entInfos.getHeritedAccess();
        SQLAndF80Utilities.writeBeginAccess(contribution, entInfos, "CL");
        boolean isCLAll = false;
        if (entInfos.getStandardAccess().equals("*C")) {
            isCLAll = true;
        }
        if (!sqlalListAccess.isEmpty()) {
            for (AccessGeneratorInfosForSQL.SQLAccessLine sqlal : sqlalListAccess) {
                if (sqlal.isAdd().booleanValue() && sqlal.getNumLine() == 1) {
                    SQLAndF80Utilities.writeCLLine(contribution, entInfos.getCursorCode());
                }
                SQLAndF80Utilities.writeAccessLine(entInfos, contribution, sqlal);
                if (!sqlal.isAdd().booleanValue()) continue;
            }
        } else if (!isCLAll) {
            SQLAndF80Utilities.writeCLLine(contribution, entInfos.getCursorCode());
        } else {
            SQLAndF80Utilities.writeCLAllLine(contribution, entInfos.getCursorCode());
        }
        if (entInfos.getPgm() != null && isHeritedAccess && (heritedAccess.equals("D") || heritedAccess.equals("W") || heritedAccess.equals("RW"))) {
            if (sqlalListFrom.isEmpty()) {
                SQLAndF80Utilities.writeFromClause(contribution, entInfos);
            } else {
                for (AccessGeneratorInfosForSQL.SQLAccessLine sqlal : sqlalListFrom) {
                    if (sqlal.isAdd().booleanValue() && sqlal.getNumLine() == 1) {
                        SQLAndF80Utilities.writeFromOrIntoLine(entInfos, contribution, true);
                    }
                    SQLAndF80Utilities.writeSpecificFromLine(contribution, sqlal, entInfos.getStandardAccess());
                }
            }
        }
        if (!sqlalListColumn.isEmpty()) {
            entInfos.setFirst(true);
            entInfos.setFirstV(true);
            SQLAndF80Utilities.writeColumnLine(entInfos, contribution, sqlalListColumn, "CL");
        }
        if (entInfos.getPgm() == null && !sqlalListFrom.isEmpty()) {
            for (AccessGeneratorInfosForSQL.SQLAccessLine sqlal : sqlalListFrom) {
                SQLAndF80Utilities.writeSpecificFromLine(contribution, sqlal, entInfos.getStandardAccess());
            }
        }
        if (entInfos.getPgm() != null && isHeritedAccess && (heritedAccess.equals("R") || heritedAccess.equals("RA") || heritedAccess.equals("RU") || heritedAccess.equals("DC"))) {
            if (sqlalListFrom.isEmpty()) {
                SQLAndF80Utilities.writeFromClause(contribution, entInfos);
            } else {
                for (AccessGeneratorInfosForSQL.SQLAccessLine sqlal : sqlalListFrom) {
                    if (sqlal.isAdd().booleanValue() && sqlal.getNumLine() == 1) {
                        SQLAndF80Utilities.writeFromOrIntoLine(entInfos, contribution, true);
                    }
                    SQLAndF80Utilities.writeSpecificFromLine(contribution, sqlal, entInfos.getStandardAccess());
                }
            }
        }
        if (!sqlalListOther.isEmpty()) {
            SQLAndF80Utilities.writeOtherLine(entInfos, contribution, sqlalListOther, true);
        }
        if (!sqlalListOrder.isEmpty()) {
            SQLAndF80Utilities.writeOtherLine(entInfos, contribution, sqlalListOrder, false);
        }
        if (!sqlalListParam.isEmpty()) {
            SQLAndF80Utilities.writeOtherLine(entInfos, contribution, sqlalListParam, false);
        }
        SQLAndF80Utilities.writeEndSpecificAccess(entInfos, contribution);
    }

    public static void generateSpecificD(AccessGeneratorInfosForSQL accessGenInfos) {
        GeneratorInfosForSQLEntities.MPALine contribution = accessGenInfos.getGenInfos().getMpaline();
        GeneratorInfosForSQLEntities entInfos = accessGenInfos.getGenInfos();
        ArrayList sqlalListAccess = entInfos.getListAccess();
        ArrayList sqlalListColumn = entInfos.getListColumn();
        ArrayList sqlalListFrom = entInfos.getListFrom();
        ArrayList sqlalListOther = entInfos.getListOther();
        ArrayList sqlalListOrder = entInfos.getListOrder();
        ArrayList sqlalListParam = entInfos.getListParam();
        String standardAccess = entInfos.getStandardAccess();
        String extractMethod = entInfos.getExtractMethod();
        String specificAccess = entInfos.getNoStandardAccess();
        boolean isStandardCustom = false;
        if (extractMethod.trim().length() == 0 && specificAccess.trim().length() == 0 && standardAccess.trim().length() > 0) {
            isStandardCustom = true;
        }
        boolean isHeritedAccess = entInfos.isHeritedAccess();
        String heritedAccess = entInfos.getHeritedAccess();
        SQLAndF80Utilities.writeBeginAccess(contribution, entInfos, "D");
        if (!sqlalListAccess.isEmpty()) {
            for (AccessGeneratorInfosForSQL.SQLAccessLine sqlal : sqlalListAccess) {
                if (sqlal.isAdd().booleanValue() && sqlal.getNumLine() == 1) {
                    SQLAndF80Utilities.writeDLine(contribution);
                }
                SQLAndF80Utilities.writeAccessLine(entInfos, contribution, sqlal);
                if (!sqlal.isAdd().booleanValue()) continue;
            }
        } else {
            SQLAndF80Utilities.writeDLine(contribution);
        }
        if (entInfos.getScr() != null && !SQLUtilities.isClient((PacScreen)entInfos.getScr()) && sqlalListAccess.isEmpty() || entInfos.getPgm() != null && (!isHeritedAccess || isHeritedAccess && (heritedAccess.equals("D") || heritedAccess.equals("W") || heritedAccess.equals("RW")))) {
            if (sqlalListFrom.isEmpty()) {
                if (entInfos.getPgm() != null && (!entInfos.isSpecificOnly() || isStandardCustom) || entInfos.getPgm() == null) {
                    SQLAndF80Utilities.writeFromClause(contribution, entInfos);
                }
            } else {
                for (AccessGeneratorInfosForSQL.SQLAccessLine sqlal : sqlalListFrom) {
                    if (sqlal.isAdd().booleanValue() && sqlal.getNumLine() == 1) {
                        SQLAndF80Utilities.writeFromOrIntoLine(entInfos, contribution, true);
                    }
                    SQLAndF80Utilities.writeSpecificFromLine(contribution, sqlal, standardAccess);
                }
            }
        }
        if (!sqlalListColumn.isEmpty()) {
            entInfos.setFirst(true);
            entInfos.setFirstV(true);
            SQLAndF80Utilities.writeColumnLine(entInfos, contribution, sqlalListColumn, "D");
        }
        if (entInfos.getPgm() != null && isHeritedAccess && (heritedAccess.equals("DC") || heritedAccess.equals("R") || heritedAccess.equals("RA") || heritedAccess.equals("RU")) || entInfos.getScr() != null && SQLUtilities.isClient((PacScreen)entInfos.getScr()) || entInfos.getSrv() != null) {
            if (sqlalListFrom.isEmpty()) {
                if (entInfos.getCursorCode().startsWith(entInfos.getSdCode())) {
                    if (entInfos.getPbb() != null) {
                        if (!entInfos.getPbb().getBlockType().equals(PacBlockBaseTypeValues._QR_LITERAL)) {
                            SQLAndF80Utilities.writeFromClause(contribution, entInfos);
                        }
                    } else {
                        SQLAndF80Utilities.writeFromOrIntoLine(entInfos, contribution, false);
                    }
                }
            } else {
                for (AccessGeneratorInfosForSQL.SQLAccessLine sqlal : sqlalListFrom) {
                    if (sqlal.isAdd().booleanValue() && sqlal.getNumLine() == 1) {
                        SQLAndF80Utilities.writeFromOrIntoLine(entInfos, contribution, true);
                    }
                    SQLAndF80Utilities.writeSpecificFromLine(contribution, sqlal, standardAccess);
                }
            }
        }
        if (!sqlalListOther.isEmpty()) {
            SQLAndF80Utilities.writeOtherLine(entInfos, contribution, sqlalListOther, true);
        } else if (entInfos.getPgm() == null && !entInfos.getKeysUpdate().isEmpty()) {
            ArrayList<String> lskeys = new ArrayList<String>();
            ArrayList<String> lsLabel = new ArrayList<String>();
            int i = 0;
            while (i < entInfos.getKeysUpdate().size()) {
                if (((String)entInfos.getKeysUpdate().get(i)).indexOf(SEP) > -1) {
                    String use = ((String)entInfos.getKeysUpdate().get(i)).substring(((String)entInfos.getKeysUpdate().get(i)).indexOf(SEP) + 1);
                    if (entInfos.getSrv() != null && (use.equals("S") || use.equals("T")) || entInfos.getScr() != null && use.equals("X")) {
                        lskeys.add((String)entInfos.getKeysUpdate().get(i));
                        lsLabel.add((String)entInfos.getRelLabelUpdate().get(i));
                    }
                }
                ++i;
            }
            SQLAndF80Utilities.writeWhere(entInfos, contribution, lskeys, lsLabel);
        }
        if (!sqlalListOrder.isEmpty()) {
            SQLAndF80Utilities.writeOtherLine(entInfos, contribution, sqlalListOrder, false);
        }
        if (!sqlalListParam.isEmpty()) {
            SQLAndF80Utilities.writeOtherLine(entInfos, contribution, sqlalListParam, false);
        }
        SQLAndF80Utilities.writeEndSpecificAccess(entInfos, contribution);
    }

    public static void generateSpecificDC(AccessGeneratorInfosForSQL accessGenInfos) {
        GeneratorInfosForSQLEntities.MPALine contribution = accessGenInfos.getGenInfos().getMpaline();
        GeneratorInfosForSQLEntities entInfos = accessGenInfos.getGenInfos();
        ArrayList sqlalListAccess = entInfos.getListAccess();
        ArrayList sqlalListColumn = entInfos.getListColumn();
        ArrayList sqlalListFrom = entInfos.getListFrom();
        ArrayList sqlalListOther = entInfos.getListOther();
        ArrayList sqlalListOrder = entInfos.getListOrder();
        ArrayList sqlalListParam = entInfos.getListParam();
        String cursorCode = entInfos.getCursorCode();
        String standardAccess = entInfos.getStandardAccess();
        String extractMethod = entInfos.getExtractMethod();
        String specificAccess = entInfos.getNoStandardAccess();
        boolean isPersEx = false;
        if (extractMethod != null && extractMethod.trim().length() > 0 && specificAccess.trim().length() > 0) {
            isPersEx = true;
        }
        boolean isEx = false;
        if (extractMethod != null && extractMethod.trim().length() > 0) {
            isEx = true;
        }
        boolean hastoIgnoreColumn = false;
        hastoIgnoreColumn = !entInfos.isSpecificOnly() ? false : !entInfos.isValidOnCDorCS() && !sqlalListAccess.isEmpty() && sqlalListColumn.isEmpty() && sqlalListFrom.isEmpty() && sqlalListOther.isEmpty() && sqlalListOrder.isEmpty() && sqlalListParam.isEmpty();
        boolean isStandardCustom = false;
        if (extractMethod.trim().length() == 0 && specificAccess.trim().length() == 0 && standardAccess.trim().length() > 0) {
            isStandardCustom = true;
        }
        boolean isHeritedAccess = entInfos.isHeritedAccess();
        String heritedAccess = entInfos.getHeritedAccess();
        SQLAndF80Utilities.writeBeginAccess(contribution, entInfos, "DC");
        boolean isDCAll = false;
        if (standardAccess.equals("*D")) {
            isDCAll = true;
        }
        if (!sqlalListAccess.isEmpty()) {
            for (AccessGeneratorInfosForSQL.SQLAccessLine sqlal : sqlalListAccess) {
                if (sqlal.isAdd().booleanValue() && sqlal.getNumLine() == 1) {
                    SQLAndF80Utilities.writeDeclareCursorFSA(contribution, cursorCode);
                }
                SQLAndF80Utilities.writeAccessLine(entInfos, contribution, sqlal);
                if (!sqlal.isAdd().booleanValue()) continue;
            }
        } else if (!entInfos.isMultiRow()) {
            if (entInfos.getPgm() == null && entInfos.getExtractMethod().trim().length() > 0) {
                SQLAndF80Utilities.writeDeclareCursorEx(contribution, entInfos.getExtractMethod());
            } else if (entInfos.isSQLALL()) {
                if (!isDCAll) {
                    SQLAndF80Utilities.writeDeclareCursorFSA(contribution, cursorCode);
                } else {
                    SQLAndF80Utilities.writeDeclareCursorAll(contribution, cursorCode);
                }
            } else {
                SQLAndF80Utilities.writeDeclareCursorStar(contribution, cursorCode);
            }
        } else {
            SQLAndF80Utilities.writeDeclareCursorForMultiRow(contribution, cursorCode);
        }
        if (entInfos.getPgm() != null && isHeritedAccess && (heritedAccess.equals("D") || heritedAccess.equals("W") || heritedAccess.equals("RW"))) {
            if (sqlalListFrom.isEmpty()) {
                SQLAndF80Utilities.writeFromClause(contribution, entInfos);
            } else {
                for (AccessGeneratorInfosForSQL.SQLAccessLine sqlal : sqlalListFrom) {
                    if (sqlal.isAdd().booleanValue() && sqlal.getNumLine() == 1) {
                        SQLAndF80Utilities.writeFromOrIntoLine(entInfos, contribution, true);
                    }
                    SQLAndF80Utilities.writeSpecificFromLine(contribution, sqlal, standardAccess);
                }
            }
        }
        if (!sqlalListColumn.isEmpty()) {
            entInfos.setFirst(true);
            entInfos.setFirstV(true);
            SQLAndF80Utilities.writeColumnLine(entInfos, contribution, sqlalListColumn, "DC");
        } else if (!isPersEx && !hastoIgnoreColumn && entInfos.isSQLALL()) {
            entInfos.setFirst(true);
            if (SQLAndF80Utilities.writeAllColumn(entInfos, contribution, false)) {
                SQLAndF80Utilities.updateLastColumn(contribution, standardAccess);
            }
        }
        if (entInfos.getPgm() != null && (!isHeritedAccess || isHeritedAccess && (heritedAccess.equals("DC") || heritedAccess.equals("R") || heritedAccess.equals("RA") || heritedAccess.equals("RU"))) || entInfos.getPgm() == null && !isPersEx) {
            if (sqlalListFrom.isEmpty()) {
                if ((entInfos.getPgm() != null && (!entInfos.isSpecificOnly() || isStandardCustom) || entInfos.getPgm() == null) && entInfos.getCursorCode().startsWith(entInfos.getSdCode())) {
                    if (entInfos.getPbb() != null) {
                        if (!entInfos.getPbb().getBlockType().equals(PacBlockBaseTypeValues._QR_LITERAL)) {
                            SQLAndF80Utilities.writeFromClause(contribution, entInfos);
                        }
                    } else {
                        SQLAndF80Utilities.writeFromOrIntoLine(entInfos, contribution, false);
                    }
                }
            } else {
                for (AccessGeneratorInfosForSQL.SQLAccessLine sqlal : sqlalListFrom) {
                    if (sqlal.isAdd().booleanValue() && sqlal.getNumLine() == 1) {
                        SQLAndF80Utilities.writeFromOrIntoLine(entInfos, contribution, true);
                    }
                    SQLAndF80Utilities.writeSpecificFromLine(contribution, sqlal, standardAccess);
                }
            }
        }
        if (!sqlalListOther.isEmpty()) {
            SQLAndF80Utilities.writeOtherLine(entInfos, contribution, sqlalListOther, true);
        } else if (!isPersEx && !isEx && entInfos.isDcproc() && entInfos.getPgm() == null && !entInfos.getKeysDisplay().isEmpty()) {
            if (standardAccess.equals("DC")) {
                SQLAndF80Utilities.writeWhereDC(entInfos, contribution, entInfos.getKeysDisplay(), entInfos.getRelLabelDisplay());
            }
            if (standardAccess.equals("*D")) {
                SQLAndF80Utilities.writeWhere(entInfos, contribution, entInfos.getKeysDisplay(), entInfos.getRelLabelDisplay());
            }
        }
        if (!sqlalListOrder.isEmpty()) {
            SQLAndF80Utilities.writeOtherLine(entInfos, contribution, sqlalListOrder, false);
        } else if (!(isPersEx || isEx || entInfos.getPgm() != null || entInfos.getKeysDisplay().isEmpty())) {
            SQLAndF80Utilities.writeOrderBy(entInfos, contribution, entInfos.getKeysDisplay(), entInfos.getRelLabelDisplay());
        }
        if (entInfos.getPbb() != null && sqlalListParam.isEmpty()) {
            SQLAndF80Utilities.writeForFetchOnly(entInfos, contribution);
        }
        if (!sqlalListParam.isEmpty()) {
            SQLAndF80Utilities.writeOtherLine(entInfos, contribution, sqlalListParam, false);
        }
        if (entInfos.getPbb() != null && entInfos.getPbb().getBlockType().equals(PacBlockBaseTypeValues._QN_LITERAL)) {
            SQLAndF80Utilities.writeForBrowseAccess(contribution);
        }
        SQLAndF80Utilities.writeEndSpecificAccess(entInfos, contribution);
    }

    public static void generateSpecificNA(AccessGeneratorInfosForSQL accessGenInfos) {
        GeneratorInfosForSQLEntities.MPALine contribution = accessGenInfos.getGenInfos().getMpaline();
        GeneratorInfosForSQLEntities entInfos = accessGenInfos.getGenInfos();
        ArrayList sqlalListAccess = entInfos.getListAccess();
        ArrayList sqlalListColumn = entInfos.getListColumn();
        ArrayList sqlalListFrom = entInfos.getListFrom();
        ArrayList sqlalListOther = entInfos.getListOther();
        ArrayList sqlalListOrder = entInfos.getListOrder();
        ArrayList sqlalListParam = entInfos.getListParam();
        boolean isHeritedAccess = entInfos.isHeritedAccess();
        String heritedAccess = entInfos.getHeritedAccess();
        if (entInfos.getExtractMethod().trim().length() != 0 || entInfos.getNoStandardAccess().trim().length() != 0 || entInfos.getStandardAccess().trim().length() > 0) {
            // empty if block
        }
        entInfos.setNewAccess(true);
        SQLAndF80Utilities.writeBeginAccess(contribution, entInfos, "NA");
        if (!sqlalListAccess.isEmpty()) {
            for (AccessGeneratorInfosForSQL.SQLAccessLine sqlal : sqlalListAccess) {
                SQLAndF80Utilities.writeAccessLine(entInfos, contribution, sqlal);
            }
        }
        if (entInfos.getPgm() != null && isHeritedAccess && (heritedAccess.equals("D") || heritedAccess.equals("W") || heritedAccess.equals("RW"))) {
            if (sqlalListFrom.isEmpty()) {
                SQLAndF80Utilities.writeFromClause(contribution, entInfos);
            } else {
                for (AccessGeneratorInfosForSQL.SQLAccessLine sqlal : sqlalListFrom) {
                    if (sqlal.isAdd().booleanValue() && sqlal.getNumLine() == 1) {
                        SQLAndF80Utilities.writeFromOrIntoLine(entInfos, contribution, true);
                    }
                    if (entInfos.getSrv() != null && entInfos.isSpecificOnly() && entInfos.getStandardAccess().equals("")) {
                        SQLAndF80Utilities.writeSpecificFromLine(contribution, sqlal, "RW");
                        continue;
                    }
                    SQLAndF80Utilities.writeSpecificFromLine(contribution, sqlal, entInfos.getStandardAccess());
                }
            }
        }
        if (!sqlalListColumn.isEmpty()) {
            entInfos.setFirst(true);
            entInfos.setFirstV(true);
            SQLAndF80Utilities.writeColumnLine(entInfos, contribution, sqlalListColumn, "SP");
        }
        if ((entInfos.getPgm() == null || entInfos.getPgm() != null && !isHeritedAccess) && !sqlalListFrom.isEmpty()) {
            for (AccessGeneratorInfosForSQL.SQLAccessLine sqlal : sqlalListFrom) {
                if (sqlal.isAdd().booleanValue() && sqlal.getNumLine() == 1) {
                    SQLAndF80Utilities.writeFromOrIntoLine(entInfos, contribution, true);
                }
                if (entInfos.getSrv() != null && entInfos.isSpecificOnly() && entInfos.getStandardAccess().equals("")) {
                    SQLAndF80Utilities.writeSpecificFromLine(contribution, sqlal, "RW");
                    continue;
                }
                SQLAndF80Utilities.writeSpecificFromLine(contribution, sqlal, entInfos.getStandardAccess());
            }
        }
        if (entInfos.getPgm() != null && isHeritedAccess && (heritedAccess.equals("DC") || heritedAccess.equals("R") || heritedAccess.equals("RA") || heritedAccess.equals("RU"))) {
            if (sqlalListFrom.isEmpty()) {
                if (entInfos.getCursorCode().startsWith(entInfos.getSdCode()) && entInfos.getPbb() != null && !entInfos.getPbb().getBlockType().equals(PacBlockBaseTypeValues._QR_LITERAL)) {
                    SQLAndF80Utilities.writeFromClause(contribution, entInfos);
                }
            } else {
                for (AccessGeneratorInfosForSQL.SQLAccessLine sqlal : sqlalListFrom) {
                    if (sqlal.isAdd().booleanValue() && sqlal.getNumLine() == 1) {
                        SQLAndF80Utilities.writeFromOrIntoLine(entInfos, contribution, true);
                    }
                    if (entInfos.getSrv() != null && entInfos.isSpecificOnly() && entInfos.getStandardAccess().equals("")) {
                        SQLAndF80Utilities.writeSpecificFromLine(contribution, sqlal, "RW");
                        continue;
                    }
                    SQLAndF80Utilities.writeSpecificFromLine(contribution, sqlal, entInfos.getStandardAccess());
                }
            }
        }
        if (!sqlalListOther.isEmpty()) {
            SQLAndF80Utilities.writeOtherLine(entInfos, contribution, sqlalListOther, true);
        }
        if (!sqlalListOrder.isEmpty()) {
            SQLAndF80Utilities.writeOtherLine(entInfos, contribution, sqlalListOrder, false);
        }
        if (!sqlalListParam.isEmpty()) {
            SQLAndF80Utilities.writeOtherLine(entInfos, contribution, sqlalListParam, false);
        }
        SQLAndF80Utilities.writeEndSpecificAccess(entInfos, contribution);
    }

    public static void generateSpecificRA(AccessGeneratorInfosForSQL accessGenInfos) {
        GeneratorInfosForSQLEntities.MPALine contribution = accessGenInfos.getGenInfos().getMpaline();
        GeneratorInfosForSQLEntities entInfos = accessGenInfos.getGenInfos();
        ArrayList sqlalListAccess = entInfos.getListAccess();
        ArrayList sqlalListColumn = entInfos.getListColumn();
        ArrayList sqlalListFrom = entInfos.getListFrom();
        ArrayList sqlalListOther = entInfos.getListOther();
        ArrayList sqlalListOrder = entInfos.getListOrder();
        ArrayList sqlalListParam = entInfos.getListParam();
        String standardAccess = entInfos.getStandardAccess();
        String extractMethod = entInfos.getExtractMethod();
        String specificAccess = entInfos.getNoStandardAccess();
        boolean isStandardCustom = false;
        if (extractMethod.trim().length() == 0 && specificAccess.trim().length() == 0 && standardAccess.trim().length() > 0) {
            isStandardCustom = true;
        }
        SQLAndF80Utilities.writeBeginAccess(contribution, entInfos, "RA");
        boolean hastoIgnoreColumn = false;
        hastoIgnoreColumn = !entInfos.isSpecificOnly() ? false : !entInfos.isValidOnCDorCS() && !sqlalListAccess.isEmpty() && sqlalListColumn.isEmpty() && sqlalListFrom.isEmpty() && sqlalListOther.isEmpty() && sqlalListOrder.isEmpty() && sqlalListParam.isEmpty();
        boolean isHeritedAccess = entInfos.isHeritedAccess();
        String heritedAccess = entInfos.getHeritedAccess();
        if (!sqlalListAccess.isEmpty()) {
            for (AccessGeneratorInfosForSQL.SQLAccessLine sqlal : sqlalListAccess) {
                if (sqlal.isAdd().booleanValue() && sqlal.getNumLine() == 1) {
                    SQLAndF80Utilities.writeRorRULine(contribution, entInfos.isSQLALL());
                }
                SQLAndF80Utilities.writeAccessLine(entInfos, contribution, sqlal);
                if (!sqlal.isAdd().booleanValue()) continue;
            }
        } else {
            SQLAndF80Utilities.writeRorRULine(contribution, entInfos.isSQLALL());
        }
        if (entInfos.getPgm() != null && isHeritedAccess && (heritedAccess.equals("D") || heritedAccess.equals("W") || heritedAccess.equals("RW"))) {
            if (sqlalListFrom.isEmpty()) {
                SQLAndF80Utilities.writeFromClause(contribution, entInfos);
            } else {
                for (AccessGeneratorInfosForSQL.SQLAccessLine sqlal : sqlalListFrom) {
                    if (sqlal.isAdd().booleanValue() && sqlal.getNumLine() == 1) {
                        SQLAndF80Utilities.writeFromOrIntoLine(entInfos, contribution, true);
                    }
                    SQLAndF80Utilities.writeSpecificFromLine(contribution, sqlal, standardAccess);
                }
            }
        }
        if (!sqlalListColumn.isEmpty()) {
            entInfos.setFirst(true);
            entInfos.setFirstV(true);
            SQLAndF80Utilities.writeColumnLine(entInfos, contribution, sqlalListColumn, "RA");
        } else if (!hastoIgnoreColumn) {
            if (entInfos.isSQLALL()) {
                entInfos.setFirst(true);
                if (SQLAndF80Utilities.writeAllColumn(entInfos, contribution, false)) {
                    SQLAndF80Utilities.updateLastColumn(contribution, standardAccess);
                    entInfos.setFirstV(true);
                    SQLAndF80Utilities.writeAllVLines(entInfos, contribution, false);
                    SQLAndF80Utilities.updateLastVline(contribution, standardAccess);
                }
            } else {
                SQLAndF80Utilities.writeForSTARSelect(contribution, entInfos, INTO, "");
            }
        }
        if (entInfos.getPgm() != null && (!isHeritedAccess || isHeritedAccess && (heritedAccess.equals("DC") || heritedAccess.equals("R") || heritedAccess.equals("RA") || heritedAccess.equals("RU"))) || entInfos.getPgm() == null) {
            if (sqlalListFrom.isEmpty()) {
                if ((entInfos.getPgm() != null && (!entInfos.isSpecificOnly() || isStandardCustom) || entInfos.getPgm() == null) && entInfos.getCursorCode().startsWith(entInfos.getSdCode())) {
                    if (entInfos.getPbb() != null) {
                        if (!entInfos.getPbb().getBlockType().equals(PacBlockBaseTypeValues._QR_LITERAL)) {
                            SQLAndF80Utilities.writeFromClause(contribution, entInfos);
                        }
                    } else {
                        SQLAndF80Utilities.writeFromOrIntoLine(entInfos, contribution, false);
                    }
                }
            } else {
                for (AccessGeneratorInfosForSQL.SQLAccessLine sqlal : sqlalListFrom) {
                    if (sqlal.isAdd().booleanValue() && sqlal.getNumLine() == 1) {
                        SQLAndF80Utilities.writeFromOrIntoLine(entInfos, contribution, true);
                    }
                    SQLAndF80Utilities.writeSpecificFromLine(contribution, sqlal, standardAccess);
                }
            }
        }
        if (!sqlalListOther.isEmpty()) {
            SQLAndF80Utilities.writeOtherLine(entInfos, contribution, sqlalListOther, true);
        } else if (entInfos.getPgm() == null && !entInfos.getKeysDisplay().isEmpty()) {
            SQLAndF80Utilities.writeWhere(entInfos, contribution, entInfos.getKeysDisplay(), entInfos.getRelLabelDisplay());
        }
        if (!sqlalListOrder.isEmpty()) {
            SQLAndF80Utilities.writeOtherLine(entInfos, contribution, sqlalListOrder, false);
        }
        if (!sqlalListParam.isEmpty()) {
            SQLAndF80Utilities.writeOtherLine(entInfos, contribution, sqlalListParam, false);
        }
        if (entInfos.getPbb() != null && entInfos.getPbb().getBlockType().equals(PacBlockBaseTypeValues._QN_LITERAL)) {
            SQLAndF80Utilities.writeForBrowseAccess(contribution);
        }
        SQLAndF80Utilities.writeEndSpecificAccess(entInfos, contribution);
    }

    public static void generateSpecificRN(AccessGeneratorInfosForSQL accessGenInfos) {
        GeneratorInfosForSQLEntities.MPALine contribution = accessGenInfos.getGenInfos().getMpaline();
        GeneratorInfosForSQLEntities entInfos = accessGenInfos.getGenInfos();
        ArrayList sqlalListAccess = entInfos.getListAccess();
        ArrayList sqlalListColumn = entInfos.getListColumn();
        ArrayList sqlalListFrom = entInfos.getListFrom();
        ArrayList sqlalListOther = entInfos.getListOther();
        ArrayList sqlalListOrder = entInfos.getListOrder();
        ArrayList sqlalListParam = entInfos.getListParam();
        String cursorCode = entInfos.getCursorCode();
        String standardAccess = entInfos.getStandardAccess();
        String extractMethod = entInfos.getExtractMethod();
        String specificAccess = entInfos.getNoStandardAccess();
        boolean isPersEx = false;
        if (extractMethod != null && extractMethod.trim().length() > 0 && specificAccess.trim().length() > 0) {
            isPersEx = true;
        }
        boolean hastoIgnoreColumn = false;
        hastoIgnoreColumn = !entInfos.isSpecificOnly() ? false : !entInfos.isValidOnCDorCS() && !sqlalListAccess.isEmpty() && sqlalListColumn.isEmpty() && sqlalListFrom.isEmpty() && sqlalListOther.isEmpty() && sqlalListOrder.isEmpty() && sqlalListParam.isEmpty();
        boolean isHeritedAccess = entInfos.isHeritedAccess();
        String heritedAccess = entInfos.getHeritedAccess();
        SQLAndF80Utilities.writeBeginAccess(contribution, entInfos, "RN");
        boolean isRNAll = false;
        if (standardAccess.equals("*R")) {
            isRNAll = true;
        }
        if (!entInfos.isMultiRow()) {
            if (!sqlalListAccess.isEmpty()) {
                for (AccessGeneratorInfosForSQL.SQLAccessLine sqlal : sqlalListAccess) {
                    if (sqlal.isAdd().booleanValue() && sqlal.getNumLine() == 1) {
                        SQLAndF80Utilities.writeRNLine(contribution, cursorCode);
                    }
                    SQLAndF80Utilities.writeAccessLine(entInfos, contribution, sqlal);
                    if (!sqlal.isAdd().booleanValue()) continue;
                }
            } else if (!isRNAll) {
                SQLAndF80Utilities.writeRNLine(contribution, cursorCode);
            } else {
                SQLAndF80Utilities.writeRNAllLine(contribution, cursorCode);
            }
            if (entInfos.getPgm() != null && isHeritedAccess && (heritedAccess.equals("D") || heritedAccess.equals("W") || heritedAccess.equals("RW"))) {
                if (sqlalListFrom.isEmpty()) {
                    SQLAndF80Utilities.writeFromClause(contribution, entInfos);
                } else {
                    for (AccessGeneratorInfosForSQL.SQLAccessLine sqlal : sqlalListFrom) {
                        if (sqlal.isAdd().booleanValue() && sqlal.getNumLine() == 1) {
                            SQLAndF80Utilities.writeFromOrIntoLine(entInfos, contribution, true);
                        }
                        SQLAndF80Utilities.writeSpecificFromLine(contribution, sqlal, standardAccess);
                    }
                }
            }
            if (!sqlalListColumn.isEmpty()) {
                entInfos.setFirst(true);
                entInfos.setFirstV(true);
                SQLAndF80Utilities.writeColumnLine(entInfos, contribution, sqlalListColumn, "RN");
            } else if (entInfos.isSQLALL() && !hastoIgnoreColumn && !isPersEx) {
                entInfos.setFirstV(true);
                if (SQLAndF80Utilities.writeAllVLines(entInfos, contribution, false)) {
                    SQLAndF80Utilities.updateLastVline(contribution, standardAccess);
                }
            }
        } else {
            SQLAndF80Utilities.writeRNForMultiRow(entInfos, contribution, sqlalListColumn);
        }
        if (entInfos.getPgm() == null && !sqlalListFrom.isEmpty()) {
            for (AccessGeneratorInfosForSQL.SQLAccessLine sqlal : sqlalListFrom) {
                SQLAndF80Utilities.writeSpecificFromLine(contribution, sqlal, entInfos.getStandardAccess());
            }
        }
        if (entInfos.getPgm() != null && isHeritedAccess && (heritedAccess.equals("R") || heritedAccess.equals("RA") || heritedAccess.equals("RU") || heritedAccess.equals("DC"))) {
            if (sqlalListFrom.isEmpty()) {
                SQLAndF80Utilities.writeFromClause(contribution, entInfos);
            } else {
                for (AccessGeneratorInfosForSQL.SQLAccessLine sqlal : sqlalListFrom) {
                    if (sqlal.isAdd().booleanValue() && sqlal.getNumLine() == 1) {
                        SQLAndF80Utilities.writeFromOrIntoLine(entInfos, contribution, true);
                    }
                    SQLAndF80Utilities.writeSpecificFromLine(contribution, sqlal, entInfos.getStandardAccess());
                }
            }
        }
        if (!sqlalListOther.isEmpty()) {
            SQLAndF80Utilities.writeOtherLine(entInfos, contribution, sqlalListOther, true);
        }
        if (!sqlalListOrder.isEmpty()) {
            SQLAndF80Utilities.writeOtherLine(entInfos, contribution, sqlalListOrder, false);
        }
        if (!sqlalListParam.isEmpty()) {
            SQLAndF80Utilities.writeOtherLine(entInfos, contribution, sqlalListParam, false);
        }
        SQLAndF80Utilities.writeEndSpecificAccess(entInfos, contribution);
    }

    public static void generateSpecificP(AccessGeneratorInfosForSQL accessGenInfos) {
        GeneratorInfosForSQLEntities.MPALine contribution = accessGenInfos.getGenInfos().getMpaline();
        GeneratorInfosForSQLEntities entInfos = accessGenInfos.getGenInfos();
        ArrayList sqlalListAccess = entInfos.getListAccess();
        ArrayList sqlalListColumn = entInfos.getListColumn();
        ArrayList sqlalListFrom = entInfos.getListFrom();
        ArrayList sqlalListOther = entInfos.getListOther();
        ArrayList sqlalListOrder = entInfos.getListOrder();
        ArrayList sqlalListParam = entInfos.getListParam();
        String cursorCode = entInfos.getCursorCode();
        String standardAccess = entInfos.getStandardAccess();
        boolean isHeritedAccess = entInfos.isHeritedAccess();
        String heritedAccess = entInfos.getHeritedAccess();
        boolean isPAll = false;
        if (standardAccess.equals("*P")) {
            isPAll = true;
        }
        SQLAndF80Utilities.writeBeginAccess(contribution, entInfos, "P");
        if (!sqlalListAccess.isEmpty()) {
            for (AccessGeneratorInfosForSQL.SQLAccessLine sqlal : sqlalListAccess) {
                if (sqlal.isAdd().booleanValue() && sqlal.getNumLine() == 1) {
                    SQLAndF80Utilities.writePLine(contribution, cursorCode);
                }
                SQLAndF80Utilities.writeAccessLine(entInfos, contribution, sqlal);
                if (!sqlal.isAdd().booleanValue()) continue;
            }
        } else if (!isPAll) {
            SQLAndF80Utilities.writePLine(contribution, cursorCode);
        } else {
            SQLAndF80Utilities.writePAllLine(contribution, cursorCode);
        }
        if (entInfos.getPgm() != null && isHeritedAccess && (heritedAccess.equals("D") || heritedAccess.equals("W") || heritedAccess.equals("RW"))) {
            if (sqlalListFrom.isEmpty()) {
                SQLAndF80Utilities.writeFromClause(contribution, entInfos);
            } else {
                for (AccessGeneratorInfosForSQL.SQLAccessLine sqlal : sqlalListFrom) {
                    if (sqlal.isAdd().booleanValue() && sqlal.getNumLine() == 1) {
                        SQLAndF80Utilities.writeFromOrIntoLine(entInfos, contribution, true);
                    }
                    SQLAndF80Utilities.writeSpecificFromLine(contribution, sqlal, standardAccess);
                }
            }
        }
        if (!sqlalListColumn.isEmpty()) {
            entInfos.setFirst(true);
            entInfos.setFirstV(true);
            SQLAndF80Utilities.writeColumnLine(entInfos, contribution, sqlalListColumn, "P");
        }
        if (entInfos.getPgm() == null && !sqlalListFrom.isEmpty()) {
            for (AccessGeneratorInfosForSQL.SQLAccessLine sqlal : sqlalListFrom) {
                SQLAndF80Utilities.writeSpecificFromLine(contribution, sqlal, entInfos.getStandardAccess());
            }
        }
        if (entInfos.getPgm() != null && isHeritedAccess && (heritedAccess.equals("R") || heritedAccess.equals("RA") || heritedAccess.equals("RU") || heritedAccess.equals("DC"))) {
            if (sqlalListFrom.isEmpty()) {
                SQLAndF80Utilities.writeFromClause(contribution, entInfos);
            } else {
                for (AccessGeneratorInfosForSQL.SQLAccessLine sqlal : sqlalListFrom) {
                    if (sqlal.isAdd().booleanValue() && sqlal.getNumLine() == 1) {
                        SQLAndF80Utilities.writeFromOrIntoLine(entInfos, contribution, true);
                    }
                    SQLAndF80Utilities.writeSpecificFromLine(contribution, sqlal, entInfos.getStandardAccess());
                }
            }
        }
        if (!sqlalListOther.isEmpty()) {
            SQLAndF80Utilities.writeOtherLine(entInfos, contribution, sqlalListOther, true);
        }
        if (!sqlalListOrder.isEmpty()) {
            SQLAndF80Utilities.writeOtherLine(entInfos, contribution, sqlalListOrder, false);
        }
        if (!sqlalListParam.isEmpty()) {
            SQLAndF80Utilities.writeOtherLine(entInfos, contribution, sqlalListParam, false);
        }
        SQLAndF80Utilities.writeEndSpecificAccess(entInfos, contribution);
    }

    public static void generateSpecificRW(AccessGeneratorInfosForSQL accessGenInfos) {
        GeneratorInfosForSQLEntities.MPALine contribution = accessGenInfos.getGenInfos().getMpaline();
        GeneratorInfosForSQLEntities entInfos = accessGenInfos.getGenInfos();
        ArrayList sqlalListAccess = entInfos.getListAccess();
        ArrayList sqlalListColumn = entInfos.getListColumn();
        ArrayList sqlalListFrom = entInfos.getListFrom();
        ArrayList sqlalListOther = entInfos.getListOther();
        ArrayList sqlalListOrder = entInfos.getListOrder();
        ArrayList sqlalListParam = entInfos.getListParam();
        String standardAccess = entInfos.getStandardAccess();
        String extractMethod = entInfos.getExtractMethod();
        String specificAccess = entInfos.getNoStandardAccess();
        boolean isStandardCustom = false;
        if (extractMethod.trim().length() == 0 && specificAccess.trim().length() == 0 && standardAccess.trim().length() > 0) {
            isStandardCustom = true;
        }
        if (extractMethod.trim().length() != 0 || specificAccess.trim().length() <= 0 || standardAccess.trim().length() > 0) {
            // empty if block
        }
        DataAggregate dag = entInfos.getDag();
        DataAggregateDescription descriptionSeg = null;
        if (dag != null) {
            descriptionSeg = (DataAggregateDescription)entInfos.getDag().getDataDescription();
        }
        boolean hastoIgnoreColumn = false;
        hastoIgnoreColumn = !entInfos.isSpecificOnly() ? false : !entInfos.isValidOnCDorCS() && !sqlalListAccess.isEmpty() && sqlalListColumn.isEmpty() && sqlalListFrom.isEmpty() && sqlalListOther.isEmpty() && sqlalListOrder.isEmpty() && sqlalListParam.isEmpty();
        boolean isHeritedAccess = entInfos.isHeritedAccess();
        String heritedAccess = entInfos.getHeritedAccess();
        SQLAndF80Utilities.writeBeginAccess(contribution, entInfos, "RW");
        if (!sqlalListAccess.isEmpty()) {
            for (AccessGeneratorInfosForSQL.SQLAccessLine sqlal : sqlalListAccess) {
                if (sqlal.isAdd().booleanValue() && sqlal.getNumLine() == 1) {
                    SQLAndF80Utilities.writeRWLine(contribution);
                }
                SQLAndF80Utilities.writeAccessLine(entInfos, contribution, sqlal);
                if (!sqlal.isAdd().booleanValue()) continue;
            }
        } else {
            SQLAndF80Utilities.writeRWLine(contribution);
        }
        if (entInfos.getPgm() == null && sqlalListAccess.isEmpty() || entInfos.getPgm() != null && (!isHeritedAccess || isHeritedAccess && (heritedAccess.equals("D") || heritedAccess.equals("W") || heritedAccess.equals("RW")))) {
            if (sqlalListFrom.isEmpty()) {
                if ((entInfos.getPgm() != null && (!entInfos.isSpecificOnly() || isStandardCustom) || entInfos.getPgm() == null) && entInfos.getCursorCode().startsWith(entInfos.getSdCode())) {
                    if (entInfos.getPbb() != null) {
                        if (!entInfos.getPbb().getBlockType().equals(PacBlockBaseTypeValues._QR_LITERAL)) {
                            SQLAndF80Utilities.writeFromClause(contribution, entInfos);
                        }
                    } else {
                        SQLAndF80Utilities.writeFromOrIntoLine(entInfos, contribution, false);
                    }
                }
            } else {
                for (AccessGeneratorInfosForSQL.SQLAccessLine sqlal : sqlalListFrom) {
                    if (sqlal.isAdd().booleanValue() && sqlal.getNumLine() == 1) {
                        SQLAndF80Utilities.writeFromOrIntoLine(entInfos, contribution, true);
                    }
                    SQLAndF80Utilities.writeSpecificFromLine(contribution, sqlal, standardAccess);
                }
            }
        }
        if (!sqlalListColumn.isEmpty()) {
            entInfos.setFirst(true);
            entInfos.setFirstV(true);
            SQLAndF80Utilities.writeColumnLine(entInfos, contribution, sqlalListColumn, "RW");
        } else if (!hastoIgnoreColumn && SQLAndF80Utilities.writeRWLine(entInfos, contribution, descriptionSeg, false, 1)) {
            SQLAndF80Utilities.updateLastVline(contribution, standardAccess);
        }
        if (entInfos.getPgm() != null && isHeritedAccess && (heritedAccess.equals("DC") || heritedAccess.equals("R") || heritedAccess.equals("RA") || heritedAccess.equals("RU"))) {
            if (sqlalListFrom.isEmpty()) {
                SQLAndF80Utilities.writeFromClause(contribution, entInfos);
            } else {
                for (AccessGeneratorInfosForSQL.SQLAccessLine sqlal : sqlalListFrom) {
                    if (sqlal.isAdd().booleanValue() && sqlal.getNumLine() == 1) {
                        SQLAndF80Utilities.writeFromOrIntoLine(entInfos, contribution, true);
                    }
                    SQLAndF80Utilities.writeSpecificFromLine(contribution, sqlal, standardAccess);
                }
            }
        }
        if (!sqlalListOther.isEmpty()) {
            SQLAndF80Utilities.writeOtherLine(entInfos, contribution, sqlalListOther, true);
        } else if (entInfos.getPgm() == null && !entInfos.getKeysUpdate().isEmpty()) {
            ArrayList<String> lskeys = new ArrayList<String>();
            ArrayList<String> lsLabel = new ArrayList<String>();
            int i = 0;
            while (i < entInfos.getKeysUpdate().size()) {
                String use;
                if (((String)entInfos.getKeysUpdate().get(i)).indexOf(SEP) > -1 && ((use = ((String)entInfos.getKeysUpdate().get(i)).substring(((String)entInfos.getKeysUpdate().get(i)).indexOf(SEP) + 1)).equals("M") || use.equals("X") || use.equals("T"))) {
                    lskeys.add((String)entInfos.getKeysUpdate().get(i));
                    lsLabel.add((String)entInfos.getRelLabelUpdate().get(i));
                }
                ++i;
            }
            SQLAndF80Utilities.writeWhere(entInfos, contribution, lskeys, lsLabel);
        }
        if (!sqlalListOrder.isEmpty()) {
            SQLAndF80Utilities.writeOtherLine(entInfos, contribution, sqlalListOrder, false);
        }
        if (!sqlalListParam.isEmpty()) {
            SQLAndF80Utilities.writeOtherLine(entInfos, contribution, sqlalListParam, false);
        }
        SQLAndF80Utilities.writeEndSpecificAccess(entInfos, contribution);
    }

    public static void generateSpecificR(AccessGeneratorInfosForSQL accessGenInfos) {
        GeneratorInfosForSQLEntities.MPALine contribution = accessGenInfos.getGenInfos().getMpaline();
        GeneratorInfosForSQLEntities entInfos = accessGenInfos.getGenInfos();
        ArrayList sqlalListAccess = entInfos.getListAccess();
        ArrayList sqlalListColumn = entInfos.getListColumn();
        ArrayList sqlalListFrom = entInfos.getListFrom();
        ArrayList sqlalListOther = entInfos.getListOther();
        ArrayList sqlalListOrder = entInfos.getListOrder();
        ArrayList sqlalListParam = entInfos.getListParam();
        String standardAccess = entInfos.getStandardAccess();
        String extractMethod = entInfos.getExtractMethod();
        String specificAccess = entInfos.getNoStandardAccess();
        boolean isStandardCustom = false;
        if (extractMethod.trim().length() == 0 && specificAccess.trim().length() == 0 && standardAccess.trim().length() > 0) {
            isStandardCustom = true;
        }
        boolean isHeritedAccess = entInfos.isHeritedAccess();
        String heritedAccess = entInfos.getHeritedAccess();
        SQLAndF80Utilities.writeBeginAccess(contribution, entInfos, "R");
        boolean hastoIgnoreColumn = false;
        hastoIgnoreColumn = !entInfos.isSpecificOnly() ? false : !entInfos.isValidOnCDorCS() && !sqlalListAccess.isEmpty() && sqlalListColumn.isEmpty() && sqlalListFrom.isEmpty() && sqlalListOther.isEmpty() && sqlalListOrder.isEmpty() && sqlalListParam.isEmpty();
        if (!sqlalListAccess.isEmpty()) {
            for (AccessGeneratorInfosForSQL.SQLAccessLine sqlal : sqlalListAccess) {
                if (sqlal.isAdd().booleanValue() && sqlal.getNumLine() == 1) {
                    SQLAndF80Utilities.writeRorRULine(contribution, entInfos.isSQLALL());
                }
                SQLAndF80Utilities.writeAccessLine(entInfos, contribution, sqlal);
                if (!sqlal.isAdd().booleanValue()) continue;
            }
        } else {
            SQLAndF80Utilities.writeRorRULine(contribution, entInfos.isSQLALL());
        }
        if (entInfos.getPgm() != null && isHeritedAccess && (heritedAccess.equals("D") || heritedAccess.equals("W") || heritedAccess.equals("RW"))) {
            if (sqlalListFrom.isEmpty()) {
                SQLAndF80Utilities.writeFromClause(contribution, entInfos);
            } else {
                for (AccessGeneratorInfosForSQL.SQLAccessLine sqlal : sqlalListFrom) {
                    if (sqlal.isAdd().booleanValue() && sqlal.getNumLine() == 1) {
                        SQLAndF80Utilities.writeFromOrIntoLine(entInfos, contribution, true);
                    }
                    SQLAndF80Utilities.writeSpecificFromLine(contribution, sqlal, standardAccess);
                }
            }
        }
        if (!sqlalListColumn.isEmpty()) {
            entInfos.setFirst(true);
            entInfos.setFirstV(true);
            SQLAndF80Utilities.writeColumnLine(entInfos, contribution, sqlalListColumn, "R");
        } else if (!hastoIgnoreColumn) {
            if (entInfos.isSQLALL()) {
                entInfos.setFirst(true);
                if (SQLAndF80Utilities.writeAllColumn(entInfos, contribution, false)) {
                    SQLAndF80Utilities.updateLastColumn(contribution, standardAccess);
                    entInfos.setFirstV(true);
                    SQLAndF80Utilities.writeAllVLines(entInfos, contribution, false);
                    SQLAndF80Utilities.updateLastVline(contribution, standardAccess);
                }
            } else {
                SQLAndF80Utilities.writeForSTARSelect(contribution, entInfos, INTO, "");
            }
        }
        if (entInfos.getPgm() != null && (!isHeritedAccess || isHeritedAccess && (heritedAccess.equals("DC") || heritedAccess.equals("R") || heritedAccess.equals("RA") || heritedAccess.equals("RU"))) || entInfos.getPgm() == null) {
            if (sqlalListFrom.isEmpty()) {
                if ((entInfos.getPgm() != null && (!entInfos.isSpecificOnly() || isStandardCustom) || entInfos.getPgm() == null) && entInfos.getCursorCode().startsWith(entInfos.getSdCode())) {
                    if (entInfos.getPbb() != null) {
                        if (!entInfos.getPbb().getBlockType().equals(PacBlockBaseTypeValues._QR_LITERAL)) {
                            SQLAndF80Utilities.writeFromClause(contribution, entInfos);
                        }
                    } else {
                        SQLAndF80Utilities.writeFromOrIntoLine(entInfos, contribution, false);
                    }
                }
            } else {
                for (AccessGeneratorInfosForSQL.SQLAccessLine sqlal : sqlalListFrom) {
                    if (sqlal.isAdd().booleanValue() && sqlal.getNumLine() == 1) {
                        SQLAndF80Utilities.writeFromOrIntoLine(entInfos, contribution, true);
                    }
                    SQLAndF80Utilities.writeSpecificFromLine(contribution, sqlal, standardAccess);
                }
            }
        }
        if (!sqlalListOther.isEmpty()) {
            SQLAndF80Utilities.writeOtherLine(entInfos, contribution, sqlalListOther, true);
        } else if (entInfos.getPgm() == null) {
            ArrayList<String> lsLabel;
            ArrayList<String> lskeys;
            if (!entInfos.getKeysRead().isEmpty()) {
                lskeys = new ArrayList<String>();
                lsLabel = new ArrayList<String>();
                int i = 0;
                while (i < entInfos.getKeysRead().size()) {
                    String use;
                    if (!(((String)entInfos.getKeysRead().get(i)).indexOf(SEP) <= -1 || (use = ((String)entInfos.getKeysRead().get(i)).substring(((String)entInfos.getKeysRead().get(i)).indexOf(SEP) + 1)).equals("N") && entInfos.getScr() == null)) {
                        lskeys.add((String)entInfos.getKeysRead().get(i));
                        lsLabel.add((String)entInfos.getRelLabelRead().get(i));
                    }
                    ++i;
                }
                SQLAndF80Utilities.writeWhere(entInfos, contribution, lskeys, lsLabel);
            } else if (!entInfos.getKeysUpdate().isEmpty()) {
                lskeys = new ArrayList();
                lsLabel = new ArrayList();
                int i = 0;
                while (i < entInfos.getKeysUpdate().size()) {
                    String use;
                    if (!(((String)entInfos.getKeysUpdate().get(i)).indexOf(SEP) <= -1 || (use = ((String)entInfos.getKeysUpdate().get(i)).substring(((String)entInfos.getKeysUpdate().get(i)).indexOf(SEP) + 1)).equals("N") && entInfos.getScr() == null)) {
                        lskeys.add((String)entInfos.getKeysUpdate().get(i));
                        lsLabel.add((String)entInfos.getRelLabelUpdate().get(i));
                    }
                    ++i;
                }
                SQLAndF80Utilities.writeWhere(entInfos, contribution, lskeys, lsLabel);
            }
        }
        if (!sqlalListOrder.isEmpty()) {
            SQLAndF80Utilities.writeOtherLine(entInfos, contribution, sqlalListOrder, false);
        }
        if (!sqlalListParam.isEmpty()) {
            SQLAndF80Utilities.writeOtherLine(entInfos, contribution, sqlalListParam, false);
        }
        if (entInfos.getPbb() != null && entInfos.getPbb().getBlockType().equals(PacBlockBaseTypeValues._QN_LITERAL)) {
            SQLAndF80Utilities.writeForBrowseAccess(contribution);
        }
        SQLAndF80Utilities.writeEndSpecificAccess(entInfos, contribution);
    }

    public static void generateSpecificRU(AccessGeneratorInfosForSQL accessGenInfos) {
        GeneratorInfosForSQLEntities.MPALine contribution = accessGenInfos.getGenInfos().getMpaline();
        GeneratorInfosForSQLEntities entInfos = accessGenInfos.getGenInfos();
        ArrayList sqlalListAccess = entInfos.getListAccess();
        ArrayList sqlalListColumn = entInfos.getListColumn();
        ArrayList sqlalListFrom = entInfos.getListFrom();
        ArrayList sqlalListOther = entInfos.getListOther();
        ArrayList sqlalListOrder = entInfos.getListOrder();
        ArrayList sqlalListParam = entInfos.getListParam();
        String standardAccess = entInfos.getStandardAccess();
        String extractMethod = entInfos.getExtractMethod();
        String specificAccess = entInfos.getNoStandardAccess();
        boolean isStandardCustom = false;
        if (extractMethod.trim().length() == 0 && specificAccess.trim().length() == 0 && standardAccess.trim().length() > 0) {
            isStandardCustom = true;
        }
        boolean hastoIgnoreColumn = false;
        hastoIgnoreColumn = !entInfos.isSpecificOnly() ? false : !entInfos.isValidOnCDorCS() && !sqlalListAccess.isEmpty() && sqlalListColumn.isEmpty() && sqlalListFrom.isEmpty() && sqlalListOther.isEmpty() && sqlalListOrder.isEmpty() && sqlalListParam.isEmpty();
        boolean isHeritedAccess = entInfos.isHeritedAccess();
        String heritedAccess = entInfos.getHeritedAccess();
        SQLAndF80Utilities.writeBeginAccess(contribution, entInfos, "RU");
        if (!sqlalListAccess.isEmpty()) {
            for (AccessGeneratorInfosForSQL.SQLAccessLine sqlal : sqlalListAccess) {
                if (sqlal.isAdd().booleanValue() && sqlal.getNumLine() == 1) {
                    SQLAndF80Utilities.writeRorRULine(contribution, entInfos.isSQLALL());
                }
                SQLAndF80Utilities.writeAccessLine(entInfos, contribution, sqlal);
                if (!sqlal.isAdd().booleanValue()) continue;
            }
        } else {
            SQLAndF80Utilities.writeRorRULine(contribution, entInfos.isSQLALL());
        }
        if (entInfos.getPgm() != null && isHeritedAccess && (heritedAccess.equals("D") || heritedAccess.equals("W") || heritedAccess.equals("RW"))) {
            if (sqlalListFrom.isEmpty()) {
                SQLAndF80Utilities.writeFromClause(contribution, entInfos);
            } else {
                for (AccessGeneratorInfosForSQL.SQLAccessLine sqlal : sqlalListFrom) {
                    if (sqlal.isAdd().booleanValue() && sqlal.getNumLine() == 1) {
                        SQLAndF80Utilities.writeFromOrIntoLine(entInfos, contribution, true);
                    }
                    SQLAndF80Utilities.writeSpecificFromLine(contribution, sqlal, standardAccess);
                }
            }
        }
        if (!sqlalListColumn.isEmpty()) {
            entInfos.setFirst(true);
            entInfos.setFirstV(true);
            SQLAndF80Utilities.writeColumnLine(entInfos, contribution, sqlalListColumn, "RU");
        } else if (!hastoIgnoreColumn) {
            if (entInfos.isSQLALL()) {
                entInfos.setFirst(true);
                if (SQLAndF80Utilities.writeAllColumn(entInfos, contribution, false)) {
                    SQLAndF80Utilities.updateLastColumn(contribution, standardAccess);
                    entInfos.setFirstV(true);
                    SQLAndF80Utilities.writeAllVLines(entInfos, contribution, false);
                    SQLAndF80Utilities.updateLastVline(contribution, standardAccess);
                }
            } else {
                SQLAndF80Utilities.writeForSTARSelect(contribution, entInfos, INTO, "");
            }
        }
        if (entInfos.getPgm() != null && (!isHeritedAccess || isHeritedAccess && (heritedAccess.equals("DC") || heritedAccess.equals("R") || heritedAccess.equals("RA") || heritedAccess.equals("RU"))) || entInfos.getPgm() == null) {
            if (sqlalListFrom.isEmpty()) {
                if ((entInfos.getPgm() != null && (!entInfos.isSpecificOnly() || isStandardCustom) || entInfos.getPgm() == null) && entInfos.getCursorCode().startsWith(entInfos.getSdCode())) {
                    if (entInfos.getPbb() != null) {
                        if (!entInfos.getPbb().getBlockType().equals(PacBlockBaseTypeValues._QR_LITERAL)) {
                            SQLAndF80Utilities.writeFromClause(contribution, entInfos);
                        }
                    } else {
                        SQLAndF80Utilities.writeFromOrIntoLine(entInfos, contribution, false);
                    }
                }
            } else {
                for (AccessGeneratorInfosForSQL.SQLAccessLine sqlal : sqlalListFrom) {
                    if (sqlal.isAdd().booleanValue() && sqlal.getNumLine() == 1) {
                        SQLAndF80Utilities.writeFromOrIntoLine(entInfos, contribution, true);
                    }
                    SQLAndF80Utilities.writeSpecificFromLine(contribution, sqlal, standardAccess);
                }
            }
        }
        if (!sqlalListOther.isEmpty()) {
            SQLAndF80Utilities.writeOtherLine(entInfos, contribution, sqlalListOther, true);
        } else if (entInfos.getPgm() == null && !entInfos.getKeysUpdate().isEmpty()) {
            ArrayList<String> lskeys = new ArrayList<String>();
            ArrayList<String> lsLabel = new ArrayList<String>();
            int i = 0;
            while (i < entInfos.getKeysUpdate().size()) {
                if (((String)entInfos.getKeysUpdate().get(i)).indexOf(SEP) > -1) {
                    String use = ((String)entInfos.getKeysUpdate().get(i)).substring(((String)entInfos.getKeysUpdate().get(i)).indexOf(SEP) + 1);
                    if (entInfos.getSrv() != null && (use.equals("S") || use.equals("C")) || use.equals("M") || use.equals("X") || use.equals("T")) {
                        lskeys.add((String)entInfos.getKeysUpdate().get(i));
                        lsLabel.add((String)entInfos.getRelLabelUpdate().get(i));
                    }
                }
                ++i;
            }
            SQLAndF80Utilities.writeWhere(entInfos, contribution, lskeys, lsLabel);
        }
        if (!sqlalListOrder.isEmpty()) {
            SQLAndF80Utilities.writeOtherLine(entInfos, contribution, sqlalListOrder, false);
        }
        if (!sqlalListParam.isEmpty()) {
            SQLAndF80Utilities.writeOtherLine(entInfos, contribution, sqlalListParam, false);
        }
        int version = 0;
        if (entInfos.getPbb() != null && entInfos.getPbb().getVersion().trim().length() > 0) {
            version = Integer.parseInt(entInfos.getPbb().getVersion());
        }
        if (entInfos.getPbb() != null && entInfos.isOracle() && version >= 7000) {
            SQLAndF80Utilities.writeForUpdate(contribution);
        }
        SQLAndF80Utilities.writeEndSpecificAccess(entInfos, contribution);
    }

    public static void generateSpecificW(AccessGeneratorInfosForSQL accessGenInfos) {
        GeneratorInfosForSQLEntities.MPALine contribution = accessGenInfos.getGenInfos().getMpaline();
        GeneratorInfosForSQLEntities entInfos = accessGenInfos.getGenInfos();
        ArrayList sqlalListAccess = entInfos.getListAccess();
        ArrayList sqlalListColumn = entInfos.getListColumn();
        ArrayList sqlalListFrom = entInfos.getListFrom();
        ArrayList sqlalListOther = entInfos.getListOther();
        ArrayList sqlalListOrder = entInfos.getListOrder();
        ArrayList sqlalListParam = entInfos.getListParam();
        entInfos.getCursorCode();
        String standardAccess = entInfos.getStandardAccess();
        String extractMethod = entInfos.getExtractMethod();
        String specificAccess = entInfos.getNoStandardAccess();
        boolean isStandardCustom = false;
        if (extractMethod.trim().length() == 0 && specificAccess.trim().length() == 0 && standardAccess.trim().length() > 0) {
            isStandardCustom = true;
        }
        entInfos.getDag();
        boolean hastoIgnoreColumn = false;
        hastoIgnoreColumn = !entInfos.isSpecificOnly() ? false : !entInfos.isValidOnCDorCS() && !sqlalListAccess.isEmpty() && sqlalListColumn.isEmpty() && sqlalListFrom.isEmpty() && sqlalListOther.isEmpty() && sqlalListOrder.isEmpty() && sqlalListParam.isEmpty();
        boolean isHeritedAccess = entInfos.isHeritedAccess();
        String heritedAccess = entInfos.getHeritedAccess();
        SQLAndF80Utilities.writeBeginAccess(contribution, entInfos, "W");
        if (!sqlalListAccess.isEmpty()) {
            for (AccessGeneratorInfosForSQL.SQLAccessLine sqlal : sqlalListAccess) {
                if (sqlal.isAdd().booleanValue() && sqlal.getNumLine() == 1) {
                    SQLAndF80Utilities.writeWLine(contribution);
                }
                SQLAndF80Utilities.writeAccessLine(entInfos, contribution, sqlal);
                if (!sqlal.isAdd().booleanValue()) continue;
            }
        } else {
            SQLAndF80Utilities.writeWLine(contribution);
        }
        if (entInfos.getPgm() == null || entInfos.getPgm() != null && (!isHeritedAccess || isHeritedAccess && (heritedAccess.equals("D") || heritedAccess.equals("W") || heritedAccess.equals("RW")))) {
            if (sqlalListFrom.isEmpty()) {
                if ((entInfos.getPgm() != null && (!entInfos.isSpecificOnly() || isStandardCustom) || entInfos.getPgm() == null) && entInfos.getCursorCode().startsWith(entInfos.getSdCode())) {
                    if (entInfos.getPbb() != null) {
                        if (!entInfos.getPbb().getBlockType().equals(PacBlockBaseTypeValues._QR_LITERAL)) {
                            SQLAndF80Utilities.writeFromClause(contribution, entInfos);
                        }
                    } else {
                        SQLAndF80Utilities.writeFromOrIntoLine(entInfos, contribution, false);
                    }
                }
            } else {
                for (AccessGeneratorInfosForSQL.SQLAccessLine sqlal : sqlalListFrom) {
                    if (sqlal.isAdd().booleanValue() && sqlal.getNumLine() == 1) {
                        SQLAndF80Utilities.writeFromOrIntoLine(entInfos, contribution, true);
                    }
                    SQLAndF80Utilities.writeSpecificFromLine(contribution, sqlal, standardAccess);
                }
            }
        }
        if (!sqlalListColumn.isEmpty()) {
            entInfos.setFirst(true);
            entInfos.setFirstV(true);
            SQLAndF80Utilities.writeColumnLine(entInfos, contribution, sqlalListColumn, "W");
        } else if (!hastoIgnoreColumn) {
            if (entInfos.isSQLALL()) {
                entInfos.setFirst(true);
                if (SQLAndF80Utilities.writeAllColumn(entInfos, contribution, false)) {
                    SQLAndF80Utilities.updateLastColumn(contribution, standardAccess);
                    entInfos.setFirstV(true);
                    SQLAndF80Utilities.writeAllVLines(entInfos, contribution, false);
                    SQLAndF80Utilities.updateLastVline(contribution, standardAccess);
                }
            } else {
                SQLAndF80Utilities.writeForSTARSelect(contribution, entInfos, VALUES, PARC);
            }
        }
        if (entInfos.getPgm() != null && isHeritedAccess && (heritedAccess.equals("DC") || heritedAccess.equals("R") || heritedAccess.equals("RA") || heritedAccess.equals("RU"))) {
            if (sqlalListFrom.isEmpty()) {
                if (entInfos.getCursorCode().startsWith(entInfos.getSdCode()) && entInfos.getPbb() != null && !entInfos.getPbb().getBlockType().equals(PacBlockBaseTypeValues._QR_LITERAL)) {
                    SQLAndF80Utilities.writeFromClause(contribution, entInfos);
                }
            } else {
                for (AccessGeneratorInfosForSQL.SQLAccessLine sqlal : sqlalListFrom) {
                    if (sqlal.isAdd().booleanValue() && sqlal.getNumLine() == 1) {
                        SQLAndF80Utilities.writeFromOrIntoLine(entInfos, contribution, true);
                    }
                    SQLAndF80Utilities.writeSpecificFromLine(contribution, sqlal, standardAccess);
                }
            }
        }
        if (!sqlalListOther.isEmpty()) {
            SQLAndF80Utilities.writeOtherLine(entInfos, contribution, sqlalListOther, true);
        }
        if (!sqlalListOrder.isEmpty()) {
            SQLAndF80Utilities.writeOtherLine(entInfos, contribution, sqlalListOrder, false);
        }
        if (!sqlalListParam.isEmpty()) {
            SQLAndF80Utilities.writeOtherLine(entInfos, contribution, sqlalListParam, false);
        }
        SQLAndF80Utilities.writeEndSpecificAccess(entInfos, contribution);
    }

    private static void writeAccessLine(GeneratorInfosForSQLEntities entInfos, GeneratorInfosForSQLEntities.MPALine contribution, AccessGeneratorInfosForSQL.SQLAccessLine sqlal) {
        contribution.append(NEW_LINE);
        contribution.append("           ");
        boolean hasLineToBeAnalysed = true;
        if (entInfos.getStandardAccess().equals("") && entInfos.isNewAccess()) {
            hasLineToBeAnalysed = false;
        }
        String newDesc = sqlal.getDescription().toUpperCase();
        if (hasLineToBeAnalysed && newDesc.contains("SQL-")) {
            int indSQL = newDesc.indexOf("SQL-");
            int startPosition = indSQL + 4;
            String specialChars = "\\/:*<>|\"%#?";
            String line = newDesc.substring(startPosition);
            int endPosition = -1;
            int i = 1;
            while (i < line.length()) {
                char charact = line.charAt(i);
                if ((Character.isWhitespace(charact) || charact == '.') && charact != '$' && charact != '-' && specialChars.indexOf(charact) == -1) {
                    endPosition = i;
                    break;
                }
                ++i;
            }
            String dataElementCode = "";
            dataElementCode = endPosition > 0 ? line.substring(0, endPosition) : line;
            String desc1 = SQLUtilities.findRelationalLabel((GeneratorInfosForSQLEntities)entInfos, (String)dataElementCode);
            String desc = desc1.replaceAll("SQL-", "");
            contribution.append(desc);
        } else {
            contribution.append(newDesc);
        }
    }

    private static String generateHostVariable(GeneratorInfosForSQLEntities entInfos, String dataElementCode, DataAggregate dataagg) {
        int ind1;
        String cursorCode = entInfos.getCursorCode();
        String element = "";
        String dataElementCodeOnly = dataElementCode;
        int ind = dataElementCode.indexOf(" ");
        if (ind > 0) {
            dataElementCodeOnly = dataElementCode.substring(0, dataElementCode.indexOf(" "));
        }
        if ((ind1 = dataElementCode.indexOf(PARC)) > 0) {
            dataElementCodeOnly = dataElementCode.substring(0, dataElementCode.indexOf(PARC)).trim();
        }
        if (dataagg != null) {
            DataAggregateDescription descriptionSeg = (DataAggregateDescription)dataagg.getDataDescription();
            Iterator lsComponent = descriptionSeg.getComponents().iterator();
            Integer num = 0;
            block0: while (lsComponent.hasNext()) {
                Object component = lsComponent.next();
                if (!(component instanceof DataCall)) continue;
                DataCall dc = (DataCall)component;
                num = num + 1;
                String elementCode = "";
                if (dc.getDataDefinition() != null && dc.getDataDefinition() instanceof DataElement) {
                    DataElement de = (DataElement)dc.getDataDefinition();
                    elementCode = de.getName();
                } else {
                    if (dc.getDataDefinition() != null && dc.getDataDefinition() instanceof DataAggregate) {
                        DataAggregate dag2 = (DataAggregate)dc.getDataDefinition();
                        SQLAndF80Utilities.generateHostVariable(entInfos, dataElementCode, dag2);
                    }
                    if (dc.getDataDefinition() != null && dc.getDataDefinition() instanceof DataElement) {
                        elementCode = dc.getDataDescription().getName();
                    }
                }
                if (!elementCode.equals(dataElementCodeOnly)) continue;
                PacDataCall pacDataCall = null;
                EList extensions = dc.getExtensions();
                int i = 0;
                while (i < extensions.size()) {
                    Object object = extensions.get(i);
                    if (object instanceof PacDataCall) {
                        pacDataCall = (PacDataCall)object;
                        if ((entInfos.getPbb() != null && !entInfos.isOracle() && !entInfos.getPbb().getBlockType().equals(PacBlockBaseTypeValues._Q3_LITERAL) && !entInfos.getPbb().getBlockType().equals(PacBlockBaseTypeValues._QY_LITERAL) || entInfos.getPbb() == null) && (pacDataCall.getSortKey().equals("V") || pacDataCall.getSortKey().equals("W") || pacDataCall.getSortKey().equals("L"))) {
                            if (!entInfos.isNewAccess() && !entInfos.isHeritedAccess()) {
                                element = " :V" + cursorCode + "-" + elementCode;
                                continue block0;
                            }
                            element = " :" + cursorCode + "-" + elementCode;
                            continue block0;
                        }
                        element = " :" + cursorCode + "-" + elementCode;
                        continue block0;
                    }
                    ++i;
                }
            }
            if (element.equals("")) {
                element = " :" + cursorCode + "-" + dataElementCodeOnly;
            }
        }
        return element;
    }

    private static String generateIndicator(String cursorCode, String indicatorString, DataAggregate dataagg) {
        String indicator = "";
        int indIndicator = indicatorString.indexOf(":-");
        int indV = indicatorString.indexOf("-:-");
        if (indIndicator >= 0) {
            String element = indicatorString.substring(indIndicator + 2);
            if (dataagg != null) {
                DataAggregateDescription descriptionSeg = (DataAggregateDescription)dataagg.getDataDescription();
                Iterator lsComponent = descriptionSeg.getComponents().iterator();
                Integer num = 0;
                while (lsComponent.hasNext()) {
                    Object component = lsComponent.next();
                    if (!(component instanceof DataCall)) continue;
                    DataCall dc = (DataCall)component;
                    num = num + 1;
                    String elementCode = "";
                    if (dc.getDataDefinition() != null && dc.getDataDefinition() instanceof DataElement) {
                        DataElement de = (DataElement)dc.getDataDefinition();
                        elementCode = de.getName();
                    } else {
                        if (dc.getDataDefinition() != null && dc.getDataDefinition() instanceof DataAggregate) {
                            DataAggregate dag2 = (DataAggregate)dc.getDataDefinition();
                            SQLAndF80Utilities.generateIndicator(cursorCode, indicatorString, dag2);
                        }
                        if (dc.getDataDefinition() != null && dc.getDataDefinition() instanceof DataElement) {
                            elementCode = dc.getDataDescription().getName();
                        }
                    }
                    if (!elementCode.equals(element)) continue;
                    EList extensions = dc.getExtensions();
                    int i = 0;
                    while (i < extensions.size()) {
                        Object object = extensions.get(i);
                        if (object instanceof PacDataCall) {
                            indicator = indV >= 0 ? ":V-" + cursorCode + "-" + elementCode : ":V" + cursorCode + "-" + elementCode;
                        }
                        ++i;
                    }
                }
                if (indicator.equals("")) {
                    indicator = indV >= 0 ? ":V-" + cursorCode + "-" + element : ":V" + cursorCode + "-" + element;
                }
            }
        } else {
            indicator = ":V" + indicatorString;
        }
        return indicator;
    }

    private static boolean writeAllColumn(GeneratorInfosForSQLEntities entInfos, GeneratorInfosForSQLEntities.MPALine contribution, Boolean isAdd) {
        if (!entInfos.getLsComp().isEmpty()) {
            Iterator lsComponent = entInfos.getLsComp().iterator();
            Integer num = 0;
            while (lsComponent.hasNext()) {
                DataCall dc = (DataCall)lsComponent.next();
                num = num + 1;
                Boolean isSubSchema = true;
                if (entInfos.getSubschema().length() > 0) {
                    isSubSchema = entInfos.checkSubSchema(dc);
                }
                if (!isSubSchema.booleanValue()) continue;
                if (dc.getDataDefinition() != null && dc.getDataDefinition() instanceof DataElement) {
                    DataElement de = (DataElement)dc.getDataDefinition();
                    SQLAndF80Utilities.writeAllColumnForDataElement(entInfos, contribution, lsComponent.hasNext(), de, isAdd);
                    entInfos.setFirst(false);
                    continue;
                }
                if (dc.getDataDescription() == null || !(dc.getDataDescription() instanceof DataElementDescription)) continue;
                DataElementDescription ded = (DataElementDescription)dc.getDataDescription();
                PacDataElementDescription pdedp = null;
                PacDataElementDescription pded = null;
                for (Object objpded : ded.getExtensions()) {
                    if (!(objpded instanceof PacDataElementDescription)) continue;
                    pded = (PacDataElementDescription)objpded;
                }
                for (Object obj2 : dc.getExtensions()) {
                    String desc = "";
                    if (!(obj2 instanceof PacDataCall)) continue;
                    PacDataCall pacDataCall = (PacDataCall)obj2;
                    desc = SQLUtilities.searchAlias((PacDataCall)pacDataCall);
                    if (desc == null) {
                        desc = dc.getDataDescription().getName();
                    }
                    String description = desc;
                    String infosToChar = null;
                    if (entInfos.getPbb() != null && entInfos.isOracle() && !entInfos.getStandardAccess().equals("W")) {
                        infosToChar = entInfos.formatToChar(pded, pdedp, "");
                    }
                    String infosConvert = null;
                    if (entInfos.getPbb() != null) {
                        infosConvert = entInfos.formatConvert(pded, pdedp, "");
                    }
                    if (infosToChar != null && infosToChar.length() > 0) {
                        description = "TO_CHAR(" + desc + infosToChar;
                    }
                    if (infosConvert != null && infosConvert.length() > 0) {
                        description = infosConvert.replaceAll("LIBRELTOREPLACE", desc);
                    }
                    SQLAndF80Utilities.writeAllColumnDetail(entInfos, contribution, lsComponent.hasNext(), description);
                }
            }
            return true;
        }
        return false;
    }

    private static void writeAllColumnDetail(GeneratorInfosForSQLEntities entInfos, GeneratorInfosForSQLEntities.MPALine contribution, boolean isComponentNext, String description) {
        String beginLine = "";
        if (entInfos.getStandardAccess().equals("W")) {
            beginLine = PARO;
        }
        contribution.append(NEW_LINE);
        contribution.append("           ");
        if (entInfos.isFirst()) {
            contribution.append(String.valueOf(beginLine) + " " + description + SEP);
        } else {
            contribution.append(" " + description + SEP);
        }
    }

    private static boolean writeRWLine(GeneratorInfosForSQLEntities entInfos, GeneratorInfosForSQLEntities.MPALine contribution, DataAggregateDescription descriptionSeg, Boolean isAdd, Integer aRank) {
        int rank = aRank;
        boolean hasComponent = false;
        String standardAccess = entInfos.getStandardAccess();
        DataAggregate dag = entInfos.getDag();
        String beginLine = SET;
        String endLine = " ";
        if (standardAccess.equals("W")) {
            beginLine = PARO;
            endLine = PARC;
        }
        if (isAdd.booleanValue()) {
            endLine = SEP;
        }
        if (dag != null) {
            Iterator lsComponent = descriptionSeg.getComponents().iterator();
            int num = 0;
            while (lsComponent.hasNext()) {
                Object component = lsComponent.next();
                hasComponent = true;
                String infosExt = null;
                if (!(component instanceof DataCall)) continue;
                DataCall dc = (DataCall)component;
                Boolean isSubSchema = true;
                if (entInfos.getSubschema().trim().length() > 0) {
                    isSubSchema = entInfos.checkSubSchema(dc);
                }
                if (!isSubSchema.booleanValue()) continue;
                Boolean isRelationalLabel = false;
                ++num;
                PacDataCall pacDataCall = null;
                EList extensionsDC = dc.getExtensions();
                String sortKey = "";
                int k = 0;
                while (k < extensionsDC.size()) {
                    Object objectDC = extensionsDC.get(k);
                    if (objectDC instanceof PacDataCall) {
                        pacDataCall = (PacDataCall)objectDC;
                        if (entInfos.getPbb() != null && !entInfos.isOracle() && !entInfos.getPbb().getBlockType().equals(PacBlockBaseTypeValues._Q3_LITERAL) && !entInfos.getPbb().getBlockType().equals(PacBlockBaseTypeValues._QY_LITERAL) && (pacDataCall.getSortKey().equals("V") || pacDataCall.getSortKey().equals("W") || pacDataCall.getSortKey().equals("L"))) {
                            sortKey = "V";
                        }
                        if (dc.getDataDefinition() != null && dc.getDataDefinition() instanceof DataElement) {
                            DataElement de = (DataElement)dc.getDataDefinition();
                            String type = "";
                            if (entInfos.getPbb() != null && entInfos.isOracle()) {
                                infosExt = entInfos.findExtendedFormat(de);
                            }
                            if (entInfos.getPbb() != null && (entInfos.getPbb().getBlockType().equals(PacBlockBaseTypeValues._QT_LITERAL) || entInfos.getPbb().getBlockType().equals(PacBlockBaseTypeValues._QU_LITERAL))) {
                                type = entInfos.findInfosCheckType(de);
                            }
                            if (entInfos.getPbb() != null && entInfos.getPbb().getBlockType().equals(PacBlockBaseTypeValues._QN_LITERAL)) {
                                infosExt = entInfos.findExtendedFormat(de);
                                type = infosExt == null && entInfos.isExtendedFormat() ? "" : entInfos.findInfosCheckType(de);
                            }
                            PacDataElement pacDataElement = null;
                            EList extensions = de.getExtensions();
                            int i = 0;
                            while (i < extensions.size()) {
                                Object object = extensions.get(i);
                                if (object instanceof PacDataElement) {
                                    pacDataElement = (PacDataElement)object;
                                    EList dLines = pacDataElement.getDLines();
                                    int j = 0;
                                    while (j < dLines.size()) {
                                        PacDLine dline = (PacDLine)dLines.get(j);
                                        if (dline.getLineType().equals("R")) {
                                            contribution.append(NEW_LINE);
                                            contribution.append("           ");
                                            if (lsComponent.hasNext()) {
                                                if (num == 1 && rank == num) {
                                                    SQLAndF80Utilities.writeRWLineForOneElement(entInfos, contribution, beginLine, SEP, dline.getDescription(), sortKey, type, infosExt, de.getName());
                                                } else {
                                                    SQLAndF80Utilities.writeRWLineForOneElement(entInfos, contribution, " ", SEP, dline.getDescription(), sortKey, type, infosExt, de.getName());
                                                }
                                            } else if (num == 1 && rank == num) {
                                                SQLAndF80Utilities.writeRWLineForOneElement(entInfos, contribution, beginLine, endLine, dline.getDescription(), sortKey, type, infosExt, de.getName());
                                            } else if (num == rank) {
                                                SQLAndF80Utilities.writeRWLineForOneElement(entInfos, contribution, " ", endLine, dline.getDescription(), sortKey, type, infosExt, de.getName());
                                            } else {
                                                SQLAndF80Utilities.writeRWLineForOneElement(entInfos, contribution, " ", SEP, dline.getDescription(), sortKey, type, infosExt, de.getName());
                                            }
                                            isRelationalLabel = true;
                                        }
                                        ++j;
                                    }
                                    if (!isRelationalLabel.booleanValue()) {
                                        String desc = null;
                                        desc = SQLUtilities.findRelationalLabelInDag((String)de.getName(), (DataAggregate)dag);
                                        if (desc == null) {
                                            desc = de.getName();
                                        }
                                        contribution.append(NEW_LINE);
                                        contribution.append("           ");
                                        if (lsComponent.hasNext()) {
                                            if (num == 1 && rank == num) {
                                                SQLAndF80Utilities.writeRWLineForOneElement(entInfos, contribution, beginLine, SEP, desc, sortKey, type, infosExt, de.getName());
                                            } else {
                                                SQLAndF80Utilities.writeRWLineForOneElement(entInfos, contribution, " ", SEP, desc, sortKey, type, infosExt, de.getName());
                                            }
                                        } else if (num == 1 && rank == num) {
                                            SQLAndF80Utilities.writeRWLineForOneElement(entInfos, contribution, beginLine, endLine, desc, sortKey, type, infosExt, de.getName());
                                        } else if (num == rank) {
                                            SQLAndF80Utilities.writeRWLineForOneElement(entInfos, contribution, " ", endLine, desc, sortKey, type, infosExt, de.getName());
                                        } else {
                                            SQLAndF80Utilities.writeRWLineForOneElement(entInfos, contribution, " ", SEP, desc, sortKey, type, infosExt, de.getName());
                                        }
                                    }
                                }
                                ++i;
                            }
                        } else if (dc.getDataDescription() != null && dc.getDataDescription() instanceof DataAggregateDescription) {
                            DataAggregateDescription dad2 = (DataAggregateDescription)dc.getDataDescription();
                            SQLAndF80Utilities.writeRWLine(entInfos, contribution, dad2, isAdd, num);
                        } else if (dc.getDataDefinition() != null && dc.getDataDefinition() instanceof DataAggregate) {
                            DataAggregate dag2 = (DataAggregate)dc.getDataDefinition();
                            DataAggregateDescription dad = (DataAggregateDescription)dag2.getDataDescription();
                            SQLAndF80Utilities.writeRWLine(entInfos, contribution, dad, isAdd, num);
                        } else if (dc.getDataDescription() != null && dc.getDataDescription() instanceof DataElementDescription) {
                            DataDescription dd = dc.getDataDescription();
                            String desc = null;
                            String type = "";
                            desc = SQLUtilities.searchAlias((PacDataCall)pacDataCall);
                            if (desc == null) {
                                desc = dd.getName();
                            }
                            contribution.append(NEW_LINE);
                            contribution.append("           ");
                            if (lsComponent.hasNext()) {
                                if (num == 1 && rank == num) {
                                    SQLAndF80Utilities.writeRWLineForOneElement(entInfos, contribution, beginLine, SEP, desc, sortKey, type, infosExt, dd.getName());
                                } else {
                                    SQLAndF80Utilities.writeRWLineForOneElement(entInfos, contribution, " ", SEP, desc, sortKey, type, infosExt, dd.getName());
                                }
                            } else if (num == 1 && rank == num) {
                                SQLAndF80Utilities.writeRWLineForOneElement(entInfos, contribution, beginLine, endLine, desc, sortKey, type, infosExt, dd.getName());
                            } else if (num == rank) {
                                SQLAndF80Utilities.writeRWLineForOneElement(entInfos, contribution, " ", endLine, desc, sortKey, type, infosExt, dd.getName());
                            } else {
                                SQLAndF80Utilities.writeRWLineForOneElement(entInfos, contribution, " ", SEP, desc, sortKey, type, infosExt, dd.getName());
                            }
                        }
                    }
                    ++k;
                }
            }
        }
        return hasComponent;
    }

    private static void writeRWLineForOneElement(GeneratorInfosForSQLEntities entInfos, GeneratorInfosForSQLEntities.MPALine contribution, String beginLine, String endLine, String desc, String sortKey, String type, String infosExt, String name) {
        String cursorCode = entInfos.getCursorCode();
        String SQLindicator = "";
        if (entInfos.isSQLIndicator()) {
            SQLindicator = "-";
        }
        contribution.append(String.valueOf(beginLine) + " " + desc + " = ");
        contribution.append(NEW_LINE);
        contribution.append("           ");
        if (entInfos.getPbb() != null && entInfos.getPbb().getBlockType().equals(PacBlockBaseTypeValues._QN_LITERAL)) {
            if (infosExt != null && infosExt.length() > 0) {
                type = " TYPE AS DATETIME";
                if (!entInfos.isFromStandardAccess()) {
                    contribution.append(" :" + sortKey + cursorCode + "-" + name + type + infosExt + SEP);
                } else {
                    contribution.append(" :" + sortKey + cursorCode + "-" + name + type);
                    contribution.append(NEW_LINE);
                    contribution.append("           ");
                    contribution.append(String.valueOf(infosExt) + SEP);
                }
            } else {
                contribution.append(" :" + sortKey + cursorCode + "-" + name + type + SEP);
            }
        } else if (entInfos.getPbb() != null && entInfos.getPbb().getBlockType().equals(PacBlockBaseTypeValues._QC_LITERAL)) {
            contribution.append(" :" + sortKey + cursorCode + "-" + name + type + SEP);
        } else if (entInfos.getPbb() != null && entInfos.isOracle()) {
            if (infosExt != null && infosExt.length() > 0) {
                contribution.append("TO_DATE(:" + sortKey + cursorCode + "-" + name + ":V" + SQLindicator + cursorCode + SQLindicator + name + infosExt + endLine);
            } else {
                contribution.append(" :" + sortKey + cursorCode + "-" + name + ":V" + SQLindicator + cursorCode + SQLindicator + name + endLine);
            }
        } else if (entInfos.getPbb() != null && (entInfos.getPbb().getBlockType().equals(PacBlockBaseTypeValues._QT_LITERAL) || entInfos.getPbb().getBlockType().equals(PacBlockBaseTypeValues._QU_LITERAL)) && !type.equals("")) {
            contribution.append(String.valueOf(type) + ":" + sortKey + cursorCode + "-" + name + ":V" + SQLindicator + cursorCode + SQLindicator + name + PARC + endLine);
        } else {
            contribution.append(" :" + sortKey + cursorCode + "-" + name + ":V" + SQLindicator + cursorCode + SQLindicator + name + endLine);
        }
    }

    public static void writeAllColumnForDataElement(GeneratorInfosForSQLEntities entInfos, GeneratorInfosForSQLEntities.MPALine contribution, boolean isComponentNext, DataElement de, Boolean isAdd) {
        String standardAccess = entInfos.getStandardAccess();
        DataAggregate dag = entInfos.getDag();
        Boolean isRelationalLabel = false;
        String infosToChar = null;
        String descrel = "";
        if (entInfos.getPbb() != null && entInfos.isOracle() && !standardAccess.equals("W")) {
            infosToChar = entInfos.findExtendedFormat(de);
        }
        String infosConvert = null;
        if (entInfos.getPbb() != null && !standardAccess.equals("RW") && !standardAccess.equals("W")) {
            infosConvert = entInfos.findInfosConvert(de);
        }
        PacDataElement pacDataElement = null;
        EList extensions = de.getExtensions();
        int i = 0;
        while (i < extensions.size()) {
            Object object = extensions.get(i);
            if (object instanceof PacDataElement) {
                pacDataElement = (PacDataElement)object;
                EList dLines = pacDataElement.getDLines();
                int j = 0;
                while (j < dLines.size()) {
                    PacDLine dline = (PacDLine)dLines.get(j);
                    if (dline.getLineType().equals("R")) {
                        String description = dline.getDescription();
                        String descriptioninDag = SQLUtilities.findRelationalLabelInDag((String)de.getName(), (DataAggregate)dag);
                        if (entInfos.getPgm() == null && descriptioninDag != null) {
                            description = descriptioninDag;
                        }
                        if (infosToChar != null && infosToChar.length() > 0) {
                            description = "TO_CHAR(" + description + infosToChar;
                        }
                        if (infosConvert != null && infosConvert.length() > 0) {
                            description = infosConvert.replaceAll("LIBRELTOREPLACE", dline.getDescription());
                        }
                        descrel = description;
                        isRelationalLabel = true;
                    }
                    ++j;
                }
                if (!isRelationalLabel.booleanValue()) {
                    String description = SQLUtilities.findRelationalLabelInDag((String)de.getName(), (DataAggregate)dag);
                    if (description == null) {
                        description = de.getName();
                    }
                    if (infosToChar != null && infosToChar.length() > 0) {
                        description = "TO_CHAR(" + de.getName() + infosToChar;
                    }
                    if (infosConvert != null && infosConvert.length() > 0) {
                        description = infosConvert.replaceAll("LIBRELTOREPLACE", de.getName());
                    }
                    SQLAndF80Utilities.writeAllColumnDetail(entInfos, contribution, isComponentNext, description);
                } else {
                    SQLAndF80Utilities.writeAllColumnDetail(entInfos, contribution, isComponentNext, descrel);
                }
            }
            ++i;
        }
    }

    public static void writeColumnLine(GeneratorInfosForSQLEntities entInfos, GeneratorInfosForSQLEntities.MPALine contribution, ArrayList<AccessGeneratorInfosForSQL.SQLAccessLine> sqlalListColumn, String access) {
        AccessGeneratorInfosForSQL.SQLAccessLine sqlal;
        String standardAccess = entInfos.getStandardAccess();
        if (entInfos.isHeritedAccess() && standardAccess.equals("")) {
            standardAccess = entInfos.getHeritedAccess();
        }
        boolean overrideInto = false;
        String cursorCode = entInfos.getCursorCode();
        DataAggregate dag = entInfos.getDag();
        DataAggregateDescription descriptionSeg = null;
        if (dag != null) {
            descriptionSeg = (DataAggregateDescription)dag.getDataDescription();
        }
        ArrayList<String> lsColumnLine1 = new ArrayList<String>();
        ArrayList<String> lsColumnLine2 = new ArrayList<String>();
        Boolean isAdd = false;
        Boolean isVLine = false;
        sqlalListColumn.iterator();
        int a = 0;
        while (a < sqlalListColumn.size()) {
            sqlal = sqlalListColumn.get(a);
            if (sqlal.isAdd().booleanValue() && sqlal.getNumLine() == 1) {
                isAdd = true;
                if (access.equals("DC") || access.equals("R") || access.equals("W") || access.equals("RU") || access.equals("RA")) {
                    entInfos.setFirst(true);
                    SQLAndF80Utilities.writeAllColumn(entInfos, contribution, false);
                }
                if (access.equals("RN")) {
                    entInfos.setFirstV(true);
                    SQLAndF80Utilities.writeAllVLines(entInfos, contribution, true);
                }
                if (access.equals("RW")) {
                    SQLAndF80Utilities.writeRWLine(entInfos, contribution, descriptionSeg, true, 1);
                }
            }
            String infosToChar = null;
            String infosConvert = null;
            String infosExtendedDate = null;
            String newDesc = sqlal.getDescription().toUpperCase();
            String typeLine = sqlal.getTypeLine();
            String columnName = "";
            String hostVariable = "";
            String indicator = "";
            String hostInd = "";
            Boolean toDate = false;
            String type = "";
            AccessGeneratorInfosForSQL.SQLAccessLine sqlalNext = null;
            if (sqlalListColumn.size() > 1 && a < sqlalListColumn.size()) {
                if (a < sqlalListColumn.size() - 1) {
                    sqlalNext = sqlalListColumn.get(a + 1);
                }
                if (isVLine.booleanValue() && typeLine.equals("G")) {
                    sqlal.setPreviousLineV(true);
                }
                if (sqlal.getTypeLine().equals("V") && sqlalNext != null && sqlalNext.getTypeLine().equals("G")) {
                    sqlal.setHasFollowingLine(true);
                }
            }
            Boolean isSep = false;
            isVLine = typeLine.equals("V") ? Boolean.valueOf(true) : Boolean.valueOf(false);
            if (newDesc.contains("SQL-")) {
                int specialChar;
                overrideInto = true;
                int endPosition = -1;
                int i = 1;
                while (i < newDesc.length()) {
                    char charact = newDesc.charAt(i);
                    if (Character.isWhitespace(charact)) {
                        endPosition = i;
                        break;
                    }
                    ++i;
                }
                String part1 = "";
                part1 = endPosition > 0 ? newDesc.substring(0, endPosition) : newDesc;
                String dataElementCode = "";
                if (isVLine.booleanValue() && part1.indexOf(SEP) > 0) {
                    isSep = true;
                    part1 = part1.substring(0, part1.indexOf(SEP));
                }
                if ((specialChar = SQLAndF80Utilities.findSpecialChar(dataElementCode = part1.substring(part1.indexOf("SQL-") + 4))) > -1) {
                    dataElementCode = dataElementCode.substring(0, specialChar);
                    endPosition = specialChar + 4;
                }
                DataElement de = SQLUtilities.searchDataElement((GeneratorInfosForSQLEntities)entInfos, (String)dataElementCode);
                if (entInfos.getPbb() != null && entInfos.isOracle()) {
                    if (!access.equals("RN")) {
                        infosToChar = entInfos.findExtendedFormat(de);
                    }
                    if (access.equals("W") || access.equals("RW")) {
                        toDate = true;
                    }
                }
                if (!(entInfos.getPbb() == null || access.equals("RN") || access.equals("RW") || access.equals("W"))) {
                    infosConvert = entInfos.findInfosConvert(de);
                }
                if (entInfos.getPbb() != null && entInfos.getPbb().getBlockType().equals(PacBlockBaseTypeValues._QN_LITERAL)) {
                    type = entInfos.findInfosCheckType(de);
                    infosExtendedDate = entInfos.findExtendedFormat(de);
                }
                if (entInfos.isNewAccess()) {
                    infosExtendedDate = "";
                    toDate = false;
                }
                String desc1 = SQLUtilities.findRelationalLabel((GeneratorInfosForSQLEntities)entInfos, (String)dataElementCode);
                sqlal.setLrel(desc1);
                columnName = desc1.replaceAll("SQL-", "");
                sqlal.setLrel(columnName);
                if (endPosition < 0) {
                    if (!isVLine.booleanValue()) {
                        hostVariable = SQLAndF80Utilities.generateHostVariable(entInfos, dataElementCode, dag);
                    }
                } else {
                    String part2 = newDesc.substring(endPosition + 1);
                    int pos = part2.indexOf(":-");
                    int posV = part2.indexOf(":V");
                    if (pos == 0) {
                        if (posV >= 0) {
                            indicator = SQLAndF80Utilities.generateIndicator(cursorCode, part2.substring(posV + 2), dag);
                            hostVariable = SQLAndF80Utilities.generateHostVariable(entInfos, part2.substring(pos + 2, posV), dag);
                        } else {
                            hostVariable = SQLAndF80Utilities.generateHostVariable(entInfos, part2.substring(pos + 2), dag);
                        }
                    } else if (pos > 0) {
                        if (posV >= 0) {
                            indicator = SQLAndF80Utilities.generateIndicator(cursorCode, part2.substring(posV + 2), dag);
                        } else {
                            hostVariable = SQLAndF80Utilities.generateHostVariable(entInfos, part2.substring(pos + 2), dag);
                        }
                    } else {
                        hostVariable = " " + part2;
                    }
                }
            } else {
                int endFirstWord;
                int pos = newDesc.indexOf(":-");
                int posV = newDesc.indexOf(":V");
                int posDash = newDesc.indexOf(":");
                if (posDash >= 0 && !overrideInto) {
                    overrideInto = true;
                }
                if (pos == 0) {
                    if (posV >= 0) {
                        indicator = SQLAndF80Utilities.generateIndicator(cursorCode, newDesc.substring(posV + 2), dag);
                        hostVariable = SQLAndF80Utilities.generateHostVariable(entInfos, newDesc.substring(pos + 2, posV), dag);
                    } else {
                        hostVariable = SQLAndF80Utilities.generateHostVariable(entInfos, newDesc.substring(pos + 2), dag);
                    }
                } else if (pos > 0) {
                    if (posV >= 0) {
                        if (newDesc.indexOf(":") >= pos && newDesc.substring(0, newDesc.indexOf(":")).trim().length() > 0) {
                            columnName = newDesc.substring(0, newDesc.indexOf(":"));
                        }
                        hostVariable = SQLAndF80Utilities.generateHostVariable(entInfos, newDesc.substring(pos + 2, posV), dag);
                        indicator = SQLAndF80Utilities.generateIndicator(cursorCode, newDesc.substring(posV + 2), dag);
                    } else {
                        endFirstWord = -1;
                        int i = 1;
                        while (i < newDesc.length()) {
                            char charact = newDesc.charAt(i);
                            if (Character.isWhitespace(charact)) {
                                endFirstWord = i;
                                break;
                            }
                            ++i;
                        }
                        if (endFirstWord == -1) {
                            columnName = newDesc.trim().length() > 6 ? newDesc.substring(0, 6) : newDesc;
                        }
                        if (endFirstWord > 0) {
                            columnName = String.valueOf(newDesc.substring(0, endFirstWord)) + " ";
                        }
                        hostVariable = SQLAndF80Utilities.generateHostVariable(entInfos, newDesc.substring(pos + 2), dag);
                        if (standardAccess.equals("DC")) {
                            sqlal.setSeveralColumn(true);
                        }
                    }
                } else {
                    endFirstWord = -1;
                    int beginFirstWord = -1;
                    int i = 0;
                    while (i < newDesc.length()) {
                        char charact = newDesc.charAt(i);
                        if (!Character.isWhitespace(charact)) {
                            beginFirstWord = i;
                            break;
                        }
                        ++i;
                    }
                    String forFirstWord = "";
                    forFirstWord = beginFirstWord > 0 ? newDesc.substring(beginFirstWord) : newDesc;
                    int i2 = 0;
                    while (i2 < forFirstWord.length()) {
                        char charact = forFirstWord.charAt(i2);
                        if (Character.isWhitespace(charact)) {
                            endFirstWord = i2;
                            break;
                        }
                        ++i2;
                    }
                    if (endFirstWord == -1) {
                        columnName = newDesc;
                        boolean isAlias = false;
                        if (newDesc.contains(DOT)) {
                            String aliasOndeCode = forFirstWord.substring(0, forFirstWord.indexOf(DOT));
                            isAlias = AccessGeneratorInfosForSQL.searchAliasOnDataElementCode((GeneratorInfosForSQLEntities)entInfos, (String)aliasOndeCode);
                            if (isAlias) {
                                hostVariable = columnName;
                                if (columnName.contains(DOT)) {
                                    String column = SQLUtilities.trimLeft((String)columnName.substring(columnName.indexOf(DOT) + 1));
                                    hostVariable = SQLAndF80Utilities.generateHostVariable(entInfos, column, dag);
                                    String SQLindicator = "";
                                    if (entInfos.isSQLIndicator()) {
                                        SQLindicator = "-";
                                    }
                                    indicator = ":V" + SQLindicator + cursorCode + SQLindicator + column;
                                }
                            }
                        } else {
                            int sepByComma = -1;
                            int i3 = 1;
                            while (i3 < newDesc.length()) {
                                char charact = newDesc.charAt(i3);
                                if (charact == ',') {
                                    sepByComma = i3;
                                    break;
                                }
                                ++i3;
                            }
                            if (sepByComma >= 0 && posDash == -1) {
                                hostVariable = newDesc;
                            }
                        }
                    }
                    if (endFirstWord >= 0) {
                        if (beginFirstWord > 5) {
                            columnName = "";
                            hostVariable = SQLUtilities.trimLeft((String)newDesc);
                        } else {
                            columnName = newDesc.substring(beginFirstWord, beginFirstWord + endFirstWord);
                            hostVariable = SQLUtilities.trimLeft((String)newDesc.substring(beginFirstWord + endFirstWord + 1));
                        }
                        sqlal.setSeveralColumn(true);
                    }
                }
            }
            if (sqlal.hasFollowingLine() && columnName.trim().length() > 0) {
                hostInd = "";
            } else if (sqlal.isPreviousLineV()) {
                columnName = "";
                hostInd = SQLUtilities.trimLeft((String)newDesc);
            } else {
                if (isSep.booleanValue()) {
                    columnName = String.valueOf(columnName) + SEP;
                }
                if (hostVariable.length() == 0 && indicator.length() == 0) {
                    hostVariable = isVLine != false ? columnName : " ";
                }
                hostInd = hostVariable.concat(indicator);
                if (infosToChar != null && infosToChar.length() > 0) {
                    if (!toDate.booleanValue()) {
                        columnName = "TO_CHAR(" + columnName + infosToChar;
                    } else {
                        hostInd = "TO_DATE(:" + hostInd.substring(2) + infosToChar;
                    }
                }
                if (infosConvert != null && infosConvert.length() > 0) {
                    columnName = infosConvert.replaceAll("LIBRELTOREPLACE", columnName);
                }
                if (!type.equals("")) {
                    hostInd = String.valueOf(hostInd) + type;
                }
                if (infosExtendedDate != null && infosExtendedDate.length() > 0) {
                    hostInd = String.valueOf(hostInd) + " TYPE AS DATETIME" + " " + infosExtendedDate;
                }
            }
            sqlal.setColumnName(columnName);
            sqlal.setHost(hostInd);
            ++a;
        }
        a = 0;
        while (a < sqlalListColumn.size()) {
            AccessGeneratorInfosForSQL.SQLAccessLine sqlalNext;
            AccessGeneratorInfosForSQL.SQLAccessLine sqlalPrevious;
            sqlal = sqlalListColumn.get(a);
            if (sqlalListColumn.size() > 1 && a >= 1 && ((sqlalPrevious = sqlalListColumn.get(a - 1)).getColumnName().trim().length() > 0 && sqlalPrevious.getHost().trim().length() > 0 && sqlal.getColumnName().trim().length() == 0 && sqlal.getHost().trim().length() > 0 || sqlalPrevious.hasSeveralHost() && sqlal.getColumnName().trim().length() == 0 && sqlal.getHost().trim().length() > 0)) {
                sqlal.setSeveralHost(true);
            }
            if (sqlalListColumn.size() > 1 && a < sqlalListColumn.size() && a < sqlalListColumn.size() - 1 && (sqlalNext = sqlalListColumn.get(a + 1)) != null && sqlal.getColumnName().trim().length() > 0 && sqlal.getHost().trim().length() > 0 && sqlalNext.getColumnName().trim().length() == 0 && sqlalNext.getHost().trim().length() > 0) {
                sqlal.setSeveralHost(true);
            }
            ++a;
        }
        boolean lastLineFollowingHost = false;
        int a2 = 0;
        while (a2 < sqlalListColumn.size()) {
            AccessGeneratorInfosForSQL.SQLAccessLine sqlal2 = sqlalListColumn.get(a2);
            SQLUtilities.standardAccessList accessType = SQLUtilities.getAccess((String)access);
            switch (accessType) {
                case DC: {
                    if (!entInfos.isHeritedAccess()) {
                        SQLAndF80Utilities.writeColumn(entInfos, sqlal2.getColumnName(), "", sqlal2.getTypeLine(), sqlal2.isAdd(), sqlal2.getLrel(), lsColumnLine1, lsColumnLine2, sqlal2.hasFollowingLine(), sqlal2.isPreviousLineV(), sqlal2.hasSeveralHost());
                        if (!sqlal2.hasSeveralColumn()) break;
                        SQLAndF80Utilities.writeColumn(entInfos, sqlal2.getHost(), "", sqlal2.getTypeLine(), sqlal2.isAdd(), sqlal2.getLrel(), lsColumnLine1, lsColumnLine2, sqlal2.hasFollowingLine(), sqlal2.isPreviousLineV(), sqlal2.hasSeveralHost());
                        break;
                    }
                    SQLAndF80Utilities.writeColumn(entInfos, sqlal2.getColumnName(), sqlal2.getHost(), sqlal2.getTypeLine(), sqlal2.isAdd(), sqlal2.getLrel(), lsColumnLine1, lsColumnLine2, sqlal2.hasFollowingLine(), sqlal2.isPreviousLineV(), sqlal2.hasSeveralHost());
                    break;
                }
                case R: {
                    SQLAndF80Utilities.writeColumn(entInfos, sqlal2.getColumnName(), sqlal2.getHost(), sqlal2.getTypeLine(), sqlal2.isAdd(), sqlal2.getLrel(), lsColumnLine1, lsColumnLine2, sqlal2.hasFollowingLine(), sqlal2.isPreviousLineV(), sqlal2.hasSeveralHost());
                    break;
                }
                case RU: {
                    SQLAndF80Utilities.writeColumn(entInfos, sqlal2.getColumnName(), sqlal2.getHost(), sqlal2.getTypeLine(), sqlal2.isAdd(), sqlal2.getLrel(), lsColumnLine1, lsColumnLine2, sqlal2.hasFollowingLine(), sqlal2.isPreviousLineV(), sqlal2.hasSeveralHost());
                    break;
                }
                case W: {
                    SQLAndF80Utilities.writeColumn(entInfos, sqlal2.getColumnName(), sqlal2.getHost(), sqlal2.getTypeLine(), sqlal2.isAdd(), sqlal2.getLrel(), lsColumnLine1, lsColumnLine2, sqlal2.hasFollowingLine(), sqlal2.isPreviousLineV(), sqlal2.hasSeveralHost());
                    break;
                }
                case RW: {
                    SQLAndF80Utilities.writeColumn(entInfos, sqlal2.getColumnName(), sqlal2.getHost(), sqlal2.getTypeLine(), sqlal2.isAdd(), sqlal2.getLrel(), lsColumnLine1, lsColumnLine2, sqlal2.hasFollowingLine(), sqlal2.isPreviousLineV(), sqlal2.hasSeveralHost());
                    break;
                }
                case D: {
                    SQLAndF80Utilities.writeColumn(entInfos, sqlal2.getColumnName(), sqlal2.getHost(), sqlal2.getTypeLine(), sqlal2.isAdd(), sqlal2.getLrel(), lsColumnLine1, lsColumnLine2, sqlal2.hasSeveralHost(), sqlal2.isPreviousLineV(), sqlal2.hasSeveralHost());
                    break;
                }
                case P: {
                    SQLAndF80Utilities.writeColumn(entInfos, sqlal2.getColumnName(), sqlal2.getHost(), sqlal2.getTypeLine(), sqlal2.isAdd(), sqlal2.getLrel(), lsColumnLine1, lsColumnLine2, sqlal2.hasSeveralHost(), sqlal2.isPreviousLineV(), sqlal2.hasSeveralHost());
                    break;
                }
                case RN: {
                    SQLAndF80Utilities.writeColumn(entInfos, sqlal2.getColumnName(), sqlal2.getHost(), sqlal2.getTypeLine(), sqlal2.isAdd(), sqlal2.getLrel(), lsColumnLine1, lsColumnLine2, sqlal2.hasSeveralHost(), sqlal2.isPreviousLineV(), sqlal2.hasSeveralHost());
                    break;
                }
                case CL: {
                    SQLAndF80Utilities.writeColumn(entInfos, sqlal2.getColumnName(), sqlal2.getHost(), sqlal2.getTypeLine(), sqlal2.isAdd(), sqlal2.getLrel(), lsColumnLine1, lsColumnLine2, sqlal2.hasSeveralHost(), sqlal2.isPreviousLineV(), sqlal2.hasSeveralHost());
                    break;
                }
                case RA: {
                    SQLAndF80Utilities.writeColumn(entInfos, sqlal2.getColumnName(), sqlal2.getHost(), sqlal2.getTypeLine(), sqlal2.isAdd(), sqlal2.getLrel(), lsColumnLine1, lsColumnLine2, sqlal2.hasSeveralHost(), sqlal2.isPreviousLineV(), sqlal2.hasSeveralHost());
                    break;
                }
                case SP: {
                    SQLAndF80Utilities.writeColumn(entInfos, sqlal2.getColumnName(), sqlal2.getHost(), sqlal2.getTypeLine(), sqlal2.isAdd(), sqlal2.getLrel(), lsColumnLine1, lsColumnLine2, sqlal2.hasSeveralHost(), sqlal2.isPreviousLineV(), sqlal2.hasSeveralHost());
                }
            }
            if (a2 == sqlalListColumn.size() - 1 && sqlal2.hasSeveralHost()) {
                lastLineFollowingHost = true;
            }
            ++a2;
        }
        if (isAdd.booleanValue()) {
            overrideInto = true;
        }
        boolean writeHost = false;
        writeHost = standardAccess.equals("RN") ? true : overrideInto;
        boolean writeCol = true;
        if (entInfos.getStandardAccess().equals("EX") && access.equals("RN")) {
            writeCol = false;
        }
        if (writeCol) {
            int i = 0;
            while (i < lsColumnLine1.size()) {
                contribution.append(NEW_LINE);
                contribution.append("           ");
                contribution.append(lsColumnLine1.get(i));
                ++i;
            }
            if (!lsColumnLine1.isEmpty() && !lastLineFollowingHost) {
                SQLAndF80Utilities.updateLastColumn(contribution, standardAccess);
            }
            if (isAdd.booleanValue() && (standardAccess.equals("R") || standardAccess.equals("RU") || standardAccess.equals("W") || standardAccess.equals("RA"))) {
                SQLAndF80Utilities.writeAllVLines(entInfos, contribution, true);
            }
        }
        if (writeHost) {
            int i = 0;
            while (i < lsColumnLine2.size()) {
                String s = (String)lsColumnLine2.get(i);
                if (entInfos.getPbb() != null && entInfos.getPbb().getBlockType().equals(PacBlockBaseTypeValues._QN_LITERAL) && s.length() > 50) {
                    contribution.append(NEW_LINE);
                    contribution.append("           ");
                    SQLAndF80Utilities.splitLine(contribution, s);
                } else {
                    contribution.append(NEW_LINE);
                    contribution.append("           ");
                    contribution.append(s);
                }
                ++i;
            }
            if (!lsColumnLine2.isEmpty()) {
                SQLAndF80Utilities.updateLastVline(contribution, standardAccess);
            }
        } else if (!lsColumnLine2.isEmpty()) {
            entInfos.setFirstV(true);
            SQLAndF80Utilities.writeAllVLines(entInfos, contribution, true);
            SQLAndF80Utilities.updateLastVline(contribution, standardAccess);
        }
    }

    private static int findSpecialChar(String dataElementCode) {
        String specialChars = "-.=:)\\/*<>|\"%#?";
        int endPosition = -1;
        int i = 1;
        while (i < dataElementCode.length()) {
            char charact = dataElementCode.charAt(i);
            if (Character.isWhitespace(charact) && charact != '$' || specialChars.indexOf(charact) > -1) {
                endPosition = i;
                break;
            }
            ++i;
        }
        return endPosition;
    }

    private static void writeVLine(GeneratorInfosForSQLEntities entInfos, GeneratorInfosForSQLEntities.MPALine contribution, ArrayList<AccessGeneratorInfosForSQL.SQLAccessLine> sqlalListColumn) {
        String cursorCode = entInfos.getCursorCode();
        String standardAccess = entInfos.getStandardAccess();
        DataAggregate dag = entInfos.getDag();
        for (AccessGeneratorInfosForSQL.SQLAccessLine sqlal : sqlalListColumn) {
            if (sqlal.isAdd().booleanValue() && sqlal.numLine == 1 && standardAccess.equals("RN")) {
                entInfos.setFirstV(true);
                SQLAndF80Utilities.writeAllVLines(entInfos, contribution, true);
            }
            String newDesc = sqlal.getDescription().toUpperCase();
            String hostVariable = "";
            String indicator = "";
            String hostInd = "";
            if (newDesc.contains("SQL-")) {
                int endPosition = -1;
                int i = 1;
                while (i < newDesc.length()) {
                    char charact = newDesc.charAt(i);
                    if (Character.isWhitespace(charact)) {
                        endPosition = i;
                        break;
                    }
                    ++i;
                }
                String part1 = "";
                part1 = endPosition > 0 ? newDesc.substring(0, endPosition) : newDesc;
                String dataElementCode = "";
                dataElementCode = part1.substring(part1.indexOf("SQL-") + 4);
                DataElement de = SQLUtilities.searchDataElement((GeneratorInfosForSQLEntities)entInfos, (String)dataElementCode);
                String desc = null;
                PacDataElement pacDataElement = null;
                EList extensions = de.getExtensions();
                int i2 = 0;
                while (i2 < extensions.size()) {
                    Object object = extensions.get(i2);
                    if (object instanceof PacDataElement) {
                        pacDataElement = (PacDataElement)object;
                        EList dLines = pacDataElement.getDLines();
                        int j = 0;
                        while (j < dLines.size()) {
                            PacDLine dline = (PacDLine)dLines.get(j);
                            if (dline.getLineType().equals("R")) {
                                desc = dline.getDescription();
                                break;
                            }
                            ++j;
                        }
                        if (desc == null && (desc = SQLUtilities.findRelationalLabelInDag((String)de.getName(), (DataAggregate)dag)) == null) {
                            desc = de.getName();
                        }
                    }
                    contribution.append(NEW_LINE);
                    contribution.append("           ");
                    contribution.append(" " + desc + SEP);
                    ++i2;
                }
                if (endPosition < 0) {
                    hostVariable = SQLAndF80Utilities.generateHostVariable(entInfos, dataElementCode, dag);
                } else {
                    String part2 = newDesc.substring(endPosition + 1);
                    int pos = part2.indexOf(":-");
                    int posV = part2.indexOf(":V");
                    if (pos == 0) {
                        if (posV >= 0) {
                            hostVariable = SQLAndF80Utilities.generateHostVariable(entInfos, part2.substring(pos + 2, posV), dag);
                            indicator = SQLAndF80Utilities.generateIndicator(cursorCode, part2.substring(posV + 2), dag);
                        } else {
                            hostVariable = SQLAndF80Utilities.generateHostVariable(entInfos, part2.substring(pos + 2), dag);
                        }
                    } else if (pos > 0) {
                        if (posV >= 0) {
                            indicator = SQLAndF80Utilities.generateIndicator(cursorCode, part2.substring(posV + 2), dag);
                        } else {
                            hostVariable = SQLAndF80Utilities.generateHostVariable(entInfos, part2.substring(pos + 2), dag);
                        }
                    } else {
                        hostVariable = " " + part2;
                    }
                }
            } else {
                int pos = newDesc.indexOf(":-");
                int posV = newDesc.indexOf(":V");
                if (pos == 0) {
                    if (posV >= 0) {
                        hostVariable = SQLAndF80Utilities.generateHostVariable(entInfos, newDesc.substring(pos + 2, posV), dag);
                        indicator = SQLAndF80Utilities.generateIndicator(cursorCode, newDesc.substring(posV + 2), dag);
                    } else {
                        hostVariable = SQLAndF80Utilities.generateHostVariable(entInfos, newDesc.substring(pos + 2), dag);
                    }
                } else if (pos > 0) {
                    if (posV >= 0) {
                        indicator = SQLAndF80Utilities.generateIndicator(cursorCode, newDesc.substring(posV + 2), dag);
                    } else {
                        hostVariable = SQLAndF80Utilities.generateHostVariable(entInfos, newDesc.substring(pos + 2), dag);
                    }
                } else {
                    hostVariable = " " + newDesc;
                }
            }
            if (hostVariable.length() == 0) {
                hostVariable = " ";
            }
            hostInd = hostVariable.concat(indicator);
            String beginLine = "";
            beginLine = entInfos.isFirstV() ? INTO2 : "";
            contribution.append(NEW_LINE);
            contribution.append("           ");
            contribution.append(String.valueOf(beginLine) + hostInd + SEP);
            entInfos.setFirstV(false);
        }
    }

    public static void writeColumn(GeneratorInfosForSQLEntities entInfos, String column, String host, String typeLine, boolean isAdd, String lrel, ArrayList<String> lsColumnLine1, ArrayList<String> lsColumnLine2, boolean hasFollowingLine, boolean isPreviousLineV, boolean isFollowingHost) {
        String standardAccess = entInfos.getStandardAccess();
        boolean isHeritedAccess = entInfos.isHeritedAccess();
        if (entInfos.isHeritedAccess() && standardAccess.equals("")) {
            standardAccess = entInfos.getHeritedAccess();
        }
        String sep = "";
        boolean isVLine = false;
        sep = typeLine.equals("G") || hasFollowingLine ? SEP : " ";
        if (typeLine.equals("V")) {
            isVLine = true;
        }
        String separateur = SEP;
        if (standardAccess.equals("RW") && !isHeritedAccess) {
            separateur = "=";
        }
        String begin = " ";
        String beginLine1 = " ";
        String beginLine2 = "";
        if (standardAccess.equals("W")) {
            beginLine1 = PARO;
            beginLine2 = VALUES;
        }
        if (standardAccess.equals("RN")) {
            if (!isHeritedAccess) {
                beginLine1 = INTO2;
            } else {
                beginLine2 = INTO2;
            }
        }
        if (standardAccess.equals("RW")) {
            beginLine1 = SET;
            if (isHeritedAccess) {
                beginLine2 = INTO2;
            }
        }
        if (!(standardAccess.equals("RW") || standardAccess.equals("RN") || standardAccess.equals("W"))) {
            beginLine2 = INTO2;
        }
        if (entInfos.getPgm() == null && standardAccess.equals("RN") && entInfos.getCategory().equals("R")) {
            beginLine2 = INTO2;
        }
        if (isAdd) {
            begin = " ";
            beginLine1 = " ";
            beginLine2 = standardAccess.equals("D") || standardAccess.equals("CL") || standardAccess.equals("P") ? INTO2 : "";
        }
        if (host.trim().length() == 0) {
            if (!isVLine && column.trim().length() > 0 && column.endsWith(sep)) {
                sep = "";
            }
            if (entInfos.isFirst()) {
                if (!isPreviousLineV) {
                    if (standardAccess.equals("RW") && hasFollowingLine) {
                        lsColumnLine1.add(String.valueOf(beginLine1) + column + separateur);
                    } else {
                        lsColumnLine1.add(String.valueOf(beginLine1) + column + sep);
                    }
                }
                if (hasFollowingLine) {
                    entInfos.setFirst(true);
                } else {
                    entInfos.setFirst(false);
                }
            } else if (!isPreviousLineV) {
                if (standardAccess.equals("RW") && hasFollowingLine) {
                    lsColumnLine1.add(" " + column + separateur);
                } else {
                    lsColumnLine1.add(" " + column + sep);
                }
            }
        } else if (!standardAccess.equals("RN") && !standardAccess.equals("RW")) {
            if (!isVLine) {
                if (host.trim().length() > 0 && host.endsWith(sep)) {
                    sep = "";
                }
                String sepc = SEP;
                if (column.trim().length() > 0 && column.endsWith(SEP)) {
                    sepc = "";
                }
                if (entInfos.isFirst()) {
                    if (!isPreviousLineV) {
                        lsColumnLine1.add(String.valueOf(beginLine1) + column + sepc);
                    }
                    lsColumnLine2.add(String.valueOf(beginLine2) + host + sep);
                    if (hasFollowingLine) {
                        entInfos.setFirst(true);
                    } else {
                        entInfos.setFirst(false);
                    }
                } else {
                    if (!isPreviousLineV) {
                        lsColumnLine1.add(String.valueOf(begin) + column + sepc);
                    }
                    lsColumnLine2.add(String.valueOf(host) + sep);
                }
            } else if (entInfos.isFirst()) {
                lsColumnLine1.add(String.valueOf(beginLine1) + column + sep);
                lsColumnLine2.add(String.valueOf(beginLine2) + host + sep);
                entInfos.setFirst(false);
            } else if (!column.equals(host)) {
                if (entInfos.getPbb() != null && (entInfos.getPbb().getBlockType().equals(PacBlockBaseTypeValues._Q3_LITERAL) || entInfos.getPbb().getBlockType().equals(PacBlockBaseTypeValues._QY_LITERAL) || entInfos.getPbb().getBlockType().equals(PacBlockBaseTypeValues._QN_LITERAL) || entInfos.isOracle())) {
                    lsColumnLine2.add(String.valueOf(begin) + lrel + " " + host + sep);
                } else {
                    lsColumnLine2.add(String.valueOf(begin) + column + " " + host + sep);
                }
            } else if (entInfos.getPbb() != null && (entInfos.getPbb().getBlockType().equals(PacBlockBaseTypeValues._Q3_LITERAL) || entInfos.getPbb().getBlockType().equals(PacBlockBaseTypeValues._QY_LITERAL) || entInfos.getPbb().getBlockType().equals(PacBlockBaseTypeValues._QN_LITERAL) || entInfos.isOracle())) {
                lsColumnLine2.add(String.valueOf(begin) + lrel + sep);
            } else {
                lsColumnLine2.add(String.valueOf(begin) + column + sep);
            }
        } else if (!isVLine) {
            if (host.trim().length() > 0 && host.endsWith(sep)) {
                sep = "";
            }
            if (column.length() > 0) {
                if (column.trim().length() > 0 && column.endsWith(separateur)) {
                    separateur = "";
                }
                if (entInfos.isFirst()) {
                    lsColumnLine1.add(String.valueOf(beginLine1) + column + separateur);
                    if (isHeritedAccess) {
                        lsColumnLine2.add(String.valueOf(beginLine2) + host + sep);
                    }
                    entInfos.setFirst(false);
                } else {
                    lsColumnLine1.add(String.valueOf(begin) + column + separateur);
                    if (isHeritedAccess) {
                        lsColumnLine2.add(String.valueOf(host) + sep);
                    }
                }
            }
            if (!isHeritedAccess) {
                if (entInfos.isFirst()) {
                    if (column.length() == 0) {
                        if (!isPreviousLineV) {
                            lsColumnLine1.add(String.valueOf(beginLine1) + host + sep);
                        } else {
                            lsColumnLine1.add(String.valueOf(host) + sep);
                        }
                    } else {
                        lsColumnLine1.add(String.valueOf(beginLine2) + host + sep);
                    }
                } else {
                    lsColumnLine1.add(String.valueOf(host) + sep);
                }
                entInfos.setFirst(false);
            }
        } else if (entInfos.isFirst()) {
            if (column.length() > 0) {
                lsColumnLine1.add(String.valueOf(beginLine1) + column + separateur + sep);
            }
            if (isFollowingHost) {
                lsColumnLine1.add(String.valueOf(beginLine2) + host + sep);
            } else {
                lsColumnLine2.add(String.valueOf(beginLine2) + host + sep);
            }
            entInfos.setFirst(false);
        } else if (!column.equals(host)) {
            if (column.length() > 0) {
                if (isFollowingHost) {
                    lsColumnLine1.add(String.valueOf(column) + separateur + sep);
                    lsColumnLine1.add(host);
                } else {
                    lsColumnLine2.add(String.valueOf(begin) + column + " " + host + sep);
                }
            } else if (isFollowingHost) {
                lsColumnLine1.add(host);
            } else {
                lsColumnLine2.add(String.valueOf(begin) + column + " " + host + sep);
            }
        } else {
            lsColumnLine2.add(String.valueOf(begin) + column + sep);
        }
    }

    public static boolean writeAllVLines(GeneratorInfosForSQLEntities entInfos, GeneratorInfosForSQLEntities.MPALine contribution, Boolean isAdd) {
        String infosToChar = null;
        String infosExtendedDate = null;
        boolean hasComponent = false;
        if (!entInfos.getLsComp().isEmpty()) {
            for (Object component : entInfos.getLsComp()) {
                hasComponent = true;
                String elementCode = "";
                DataCall dc = (DataCall)component;
                Boolean isSubSchema = true;
                if (entInfos.getSubschema().trim().length() > 0) {
                    isSubSchema = entInfos.checkSubSchema(dc);
                }
                if (!isSubSchema.booleanValue()) continue;
                if (dc.getDataDefinition() != null && dc.getDataDefinition() instanceof DataElement) {
                    String type = "";
                    DataElement de = (DataElement)dc.getDataDefinition();
                    elementCode = de.getName();
                    if (entInfos.getPbb() != null && entInfos.isOracle()) {
                        infosToChar = entInfos.findExtendedFormat(de);
                    }
                    if (entInfos.getPbb() != null && entInfos.getPbb().getBlockType().equals(PacBlockBaseTypeValues._QN_LITERAL)) {
                        infosExtendedDate = entInfos.findExtendedFormat(de);
                        type = infosExtendedDate == null && entInfos.isExtendedFormat() ? "" : entInfos.findInfosCheckType(de);
                    }
                    SQLAndF80Utilities.writeAllVLinesDetail(entInfos, contribution, elementCode, dc, type, infosToChar, infosExtendedDate, isAdd);
                    continue;
                }
                if (dc.getDataDescription() == null || !(dc.getDataDescription() instanceof DataElementDescription)) continue;
                elementCode = dc.getDataDescription().getName();
                SQLAndF80Utilities.writeAllVLinesDetail(entInfos, contribution, elementCode, dc, "", infosToChar, infosExtendedDate, isAdd);
            }
        }
        return hasComponent;
    }

    public static void writeAllVLinesDetail(GeneratorInfosForSQLEntities entInfos, GeneratorInfosForSQLEntities.MPALine contribution, String elementCode, DataCall dc, String type, String infosToChar, String infosExtendedDate, Boolean isAdd) {
        String standardAccess = entInfos.getStandardAccess();
        boolean isMultiRow = entInfos.isMultiRow();
        String beginLine = "";
        if (standardAccess.equals("R") || standardAccess.equals("RN") || standardAccess.equals("RU") || standardAccess.equals("RA") || standardAccess.equals("EX") && entInfos.getPgm() == null) {
            beginLine = INTO2;
        }
        if (standardAccess.equals("W")) {
            beginLine = VALUES;
        }
        PacDataCall pacDataCall = null;
        EList extensions = dc.getExtensions();
        int i = 0;
        while (i < extensions.size()) {
            Object object = extensions.get(i);
            if (object instanceof PacDataCall) {
                pacDataCall = (PacDataCall)object;
                String sortKey = "";
                if (entInfos.getPbb() != null && !entInfos.isOracle() && !entInfos.getPbb().getBlockType().equals(PacBlockBaseTypeValues._Q3_LITERAL) && !entInfos.getPbb().getBlockType().equals(PacBlockBaseTypeValues._QY_LITERAL) && (pacDataCall.getSortKey().equals("V") || pacDataCall.getSortKey().equals("W") || pacDataCall.getSortKey().equals("L"))) {
                    sortKey = "V";
                }
                if (entInfos.getPbb() == null && !entInfos.getOrganisation().equals("G") && !entInfos.getOrganisation().equals("D") && (pacDataCall.getSortKey().equals("V") || pacDataCall.getSortKey().equals("W") || pacDataCall.getSortKey().equals("L"))) {
                    sortKey = "V";
                }
                contribution.append(NEW_LINE);
                contribution.append("           ");
                if (entInfos.isFirstV()) {
                    if (!isMultiRow || isMultiRow && !standardAccess.equals("RN")) {
                        SQLAndF80Utilities.writeAllVlinesForOneElement(entInfos, contribution, beginLine, sortKey, elementCode, type, infosToChar, infosExtendedDate);
                    } else if (isMultiRow) {
                        SQLAndF80Utilities.writeAllVlinesForOneElementMR(entInfos, contribution, beginLine, sortKey, elementCode);
                    }
                    entInfos.setFirstV(false);
                } else if (!isMultiRow || isMultiRow && !standardAccess.equals("RN")) {
                    SQLAndF80Utilities.writeAllVlinesForOneElement(entInfos, contribution, "", sortKey, elementCode, type, infosToChar, infosExtendedDate);
                } else if (isMultiRow) {
                    SQLAndF80Utilities.writeAllVlinesForOneElementMR(entInfos, contribution, "", sortKey, elementCode);
                }
            }
            ++i;
        }
    }

    public static void writeAllVlinesForOneElement(GeneratorInfosForSQLEntities entInfos, GeneratorInfosForSQLEntities.MPALine contribution, String beginLine, String sortKey, String elementCode, String type, String infosToChar, String infosExtendedDate) {
        String cursorCode = entInfos.getCursorCode();
        String SQLindicator = "";
        if (entInfos.isSQLIndicator()) {
            SQLindicator = "-";
        }
        if (entInfos.getPbb() != null && entInfos.getPbb().getBlockType().equals(PacBlockBaseTypeValues._QN_LITERAL)) {
            if (infosExtendedDate != null && infosExtendedDate.length() > 0) {
                type = " TYPE AS DATETIME";
                if (!entInfos.isFromStandardAccess()) {
                    contribution.append(String.valueOf(beginLine) + " :" + sortKey + cursorCode + "-" + elementCode + type + infosExtendedDate + SEP);
                } else {
                    contribution.append(String.valueOf(beginLine) + " :" + sortKey + cursorCode + "-" + elementCode + type);
                    contribution.append(NEW_LINE);
                    contribution.append("           ");
                    contribution.append(" " + infosExtendedDate + SEP);
                }
            } else {
                contribution.append(String.valueOf(beginLine) + " :" + sortKey + cursorCode + "-" + elementCode + type + SEP);
            }
        } else if (entInfos.getPbb() != null && entInfos.getPbb().getBlockType().equals(PacBlockBaseTypeValues._QC_LITERAL)) {
            if (entInfos.isFromStandardAccess() || entInfos.isStandard()) {
                contribution.append(String.valueOf(beginLine) + " :" + sortKey + cursorCode + "-" + elementCode + ":V" + SQLindicator + cursorCode + SQLindicator + elementCode + SEP);
            } else {
                contribution.append(String.valueOf(beginLine) + " :" + sortKey + cursorCode + "-" + elementCode + type + SEP);
            }
        } else if (entInfos.getPbb() != null && entInfos.isOracle()) {
            if (entInfos.getStandardAccess().equals("W") && infosToChar != null && infosToChar.length() > 0) {
                contribution.append(String.valueOf(beginLine) + "TO_DATE(:" + sortKey + cursorCode + "-" + elementCode + ":V" + SQLindicator + cursorCode + SQLindicator + elementCode + infosToChar + SEP);
            } else {
                contribution.append(String.valueOf(beginLine) + " :" + sortKey + cursorCode + "-" + elementCode + ":V" + SQLindicator + cursorCode + SQLindicator + elementCode + SEP);
            }
        } else {
            contribution.append(String.valueOf(beginLine) + " :" + sortKey + cursorCode + "-" + elementCode + ":V" + SQLindicator + cursorCode + SQLindicator + elementCode + SEP);
        }
    }

    protected static void writeAllVlinesForOneElementMR(GeneratorInfosForSQLEntities entInfos, GeneratorInfosForSQLEntities.MPALine contribution, String beginLine, String sortKey, String element) {
        if (entInfos.getPgm() != null) {
            String SQLindicator = "";
            if (entInfos.getPgm().isSQLIndicator()) {
                SQLindicator = "-";
            }
            contribution.append(String.valueOf(beginLine) + " :R-" + sortKey + entInfos.getCursorCode() + "-" + element + ":W" + SQLindicator + entInfos.getCursorCode() + SQLindicator + element + SEP);
        }
    }

    private static void writeRNForMultiRow(GeneratorInfosForSQLEntities entInfos, GeneratorInfosForSQLEntities.MPALine contribution, ArrayList<AccessGeneratorInfosForSQL.SQLAccessLine> sqlalListColumn) {
        String cursorCode = entInfos.getCursorCode();
        String newrnmr1 = "";
        String newrnmr2 = "";
        String newrnmr3 = "";
        String breakStr = "";
        if (entInfos.getBreakLevel() > 0) {
            breakStr = "1-";
            newrnmr1 = RNMR1.replaceAll("ZZ-XX", String.valueOf(cursorCode.substring(0, 2)) + "-FI");
        } else {
            newrnmr1 = RNMR1.replaceAll("ZZ-XX", String.valueOf(cursorCode.substring(0, 2)) + "-FT");
        }
        newrnmr2 = newrnmr1.replaceAll("CURS", cursorCode);
        newrnmr3 = newrnmr2.replaceAll("SF", cursorCode.substring(0, 2));
        contribution.append(newrnmr3);
        if (sqlalListColumn != null && !sqlalListColumn.isEmpty()) {
            entInfos.setFirstV(true);
            SQLAndF80Utilities.writeVLine(entInfos, contribution, sqlalListColumn);
        } else {
            entInfos.setFirstV(true);
            SQLAndF80Utilities.writeAllVLines(entInfos, contribution, false);
        }
        SQLAndF80Utilities.updateLastVline(contribution, entInfos.getStandardAccess());
        newrnmr1 = entInfos.getBreakLevel() > 0 ? RNMR2.replaceAll("ZZ-XX", String.valueOf(cursorCode.substring(0, 2)) + "-FI") : RNMR2.replaceAll("ZZ-XX", String.valueOf(cursorCode.substring(0, 2)) + "-FT");
        contribution.append(NEW_LINE);
        newrnmr2 = newrnmr1.replaceAll("CURS", cursorCode);
        newrnmr3 = newrnmr2.replaceAll("SF", cursorCode.substring(0, 2));
        contribution.append(newrnmr3);
        DataAggregateDescription descriptionSeg = (DataAggregateDescription)entInfos.getDag().getDataDescription();
        SQLAndF80Utilities.generationMoveR(entInfos, contribution, descriptionSeg, breakStr);
        SQLAndF80Utilities.generationMoveW(entInfos, contribution, descriptionSeg, breakStr);
        contribution.append(NEW_LINE);
        newrnmr1 = RNMR3.replaceAll("CURS", cursorCode);
        newrnmr2 = newrnmr1.replaceAll("SF", cursorCode.substring(0, 2));
        contribution.append(newrnmr2);
    }

    private static void generationMoveW(GeneratorInfosForSQLEntities entInfos, GeneratorInfosForSQLEntities.MPALine contribution, DataAggregateDescription descriptionSeg, String breakStr) {
        String elementCode = "";
        String SQLindicator = "";
        if (entInfos.getPgm().isSQLIndicator()) {
            SQLindicator = "-";
        }
        if (!entInfos.getLsComp().isEmpty()) {
            for (Object component : entInfos.getLsComp()) {
                DataCall dc = (DataCall)component;
                Boolean isSubSchema = true;
                if (entInfos.getSubschema().trim().length() > 0) {
                    isSubSchema = entInfos.checkSubSchema(dc);
                }
                if (!isSubSchema.booleanValue()) continue;
                if (dc.getDataDefinition() != null && dc.getDataDefinition() instanceof DataElement) {
                    DataElement de = (DataElement)dc.getDataDefinition();
                    elementCode = de.getName();
                    SQLAndF80Utilities.writeMoveW(entInfos, contribution, elementCode, dc, SQLindicator);
                }
                if (dc.getDataDescription() == null || !(dc.getDataDescription() instanceof DataElementDescription)) continue;
                elementCode = dc.getDataDescription().getName();
                SQLAndF80Utilities.writeMoveW(entInfos, contribution, elementCode, dc, SQLindicator);
            }
        }
    }

    private static void generationMoveR(GeneratorInfosForSQLEntities entInfos, GeneratorInfosForSQLEntities.MPALine contribution, DataAggregateDescription descriptionSeg, String breakStr) {
        String elementCode = "";
        if (!entInfos.getLsComp().isEmpty()) {
            for (Object component : entInfos.getLsComp()) {
                DataCall dc = (DataCall)component;
                Boolean isSubSchema = true;
                if (entInfos.getSubschema().trim().length() > 0) {
                    isSubSchema = entInfos.checkSubSchema(dc);
                }
                if (!isSubSchema.booleanValue()) continue;
                if (dc.getDataDefinition() != null && dc.getDataDefinition() instanceof DataElement) {
                    DataElement de = (DataElement)dc.getDataDefinition();
                    elementCode = de.getName();
                    SQLAndF80Utilities.writeMoveR(entInfos, contribution, elementCode, dc, breakStr);
                    continue;
                }
                if (dc.getDataDescription() == null || !(dc.getDataDescription() instanceof DataElementDescription)) continue;
                elementCode = dc.getDataDescription().getName();
                SQLAndF80Utilities.writeMoveR(entInfos, contribution, elementCode, dc, breakStr);
            }
        }
    }

    private static void writeMoveW(GeneratorInfosForSQLEntities entInfos, GeneratorInfosForSQLEntities.MPALine contribution, String elementCode, DataCall dc, String SQLindicator) {
        String cursorCode = entInfos.getCursorCode();
        String element = "";
        EList extensions = dc.getExtensions();
        int i = 0;
        while (i < extensions.size()) {
            Object object = extensions.get(i);
            if (object instanceof PacDataCall) {
                element = SQLindicator.equals("-") ? String.valueOf(cursorCode) + "-" + elementCode : String.valueOf(cursorCode) + elementCode;
            }
            ++i;
        }
        contribution.append(NEW_LINE);
        contribution.append("           ");
        contribution.append(" MOVE W" + SQLindicator + element + " (R" + cursorCode + "R) TO V" + SQLindicator + element);
    }

    private static void writeMoveR(GeneratorInfosForSQLEntities entInfos, GeneratorInfosForSQLEntities.MPALine contribution, String elementCode, DataCall dc, String breakStr) {
        String cursorCode = entInfos.getCursorCode();
        PacDataCall pacDataCall = null;
        String element = "";
        EList extensions = dc.getExtensions();
        int i = 0;
        while (i < extensions.size()) {
            Object object = extensions.get(i);
            if (object instanceof PacDataCall) {
                pacDataCall = (PacDataCall)object;
                element = pacDataCall.getSortKey().equals("V") || pacDataCall.getSortKey().equals("W") || pacDataCall.getSortKey().equals("L") ? "V" + cursorCode + "-" + elementCode : String.valueOf(cursorCode) + "-" + elementCode;
            }
            ++i;
        }
        contribution.append(NEW_LINE);
        contribution.append("           ");
        contribution.append(" MOVE R-" + element + " (R" + cursorCode + "R) TO " + element);
    }

    private static void writeOtherLine(GeneratorInfosForSQLEntities entInfos, GeneratorInfosForSQLEntities.MPALine contribution, ArrayList<AccessGeneratorInfosForSQL.SQLAccessLine> sqlalList, Boolean isWhereClause) {
        DataAggregate dag = entInfos.getDag();
        String cursorCode = entInfos.getCursorCode();
        String standardAccess = entInfos.getStandardAccess();
        ArrayList lsDataElement = new ArrayList();
        ArrayList lsLabel = new ArrayList();
        if (entInfos.getPgm() == null) {
            if (entInfos.getStandardAccess().equals("DC") || entInfos.getStandardAccess().equals("RA") || entInfos.getStandardAccess().equals("D*")) {
                lsDataElement = entInfos.getKeysDisplay();
                lsLabel = entInfos.getRelLabelDisplay();
            } else {
                int i = 0;
                while (i < entInfos.getKeysUpdate().size()) {
                    if (((String)entInfos.getKeysUpdate().get(i)).indexOf(SEP) > -1) {
                        String use = ((String)entInfos.getKeysUpdate().get(i)).substring(((String)entInfos.getKeysUpdate().get(i)).indexOf(SEP) + 1);
                        if (standardAccess.equals("D") && (use.equals("S") || use.equals("T"))) {
                            lsDataElement.add((String)entInfos.getKeysUpdate().get(i));
                            lsLabel.add((String)entInfos.getRelLabelUpdate().get(i));
                        } else {
                            if (standardAccess.equals("R") && !use.equals("N")) {
                                lsDataElement.add((String)entInfos.getKeysUpdate().get(i));
                                lsLabel.add((String)entInfos.getRelLabelUpdate().get(i));
                            }
                            if (standardAccess.equals("RW") && (use.equals("M") || use.equals("X") || use.equals("T"))) {
                                lsDataElement.add((String)entInfos.getKeysUpdate().get(i));
                                lsLabel.add((String)entInfos.getRelLabelUpdate().get(i));
                            }
                            if (standardAccess.equals("RU") && (use.equals("M") || use.equals("X") || use.equals("T") || use.equals("S") || use.equals("C"))) {
                                lsDataElement.add((String)entInfos.getKeysUpdate().get(i));
                                lsLabel.add((String)entInfos.getRelLabelUpdate().get(i));
                            }
                            if (standardAccess.equals("D") && (use.equals("S") || use.equals("T"))) {
                                lsDataElement.add((String)entInfos.getKeysUpdate().get(i));
                                lsLabel.add((String)entInfos.getRelLabelUpdate().get(i));
                            }
                        }
                    }
                    ++i;
                }
            }
        }
        entInfos.setOtherLine(true);
        Integer num = 0;
        Iterator<AccessGeneratorInfosForSQL.SQLAccessLine> it = sqlalList.iterator();
        while (it.hasNext()) {
            String desc = "";
            AccessGeneratorInfosForSQL.SQLAccessLine sqlal = it.next();
            if ((num = Integer.valueOf(num + 1)) == 1 && sqlal.getOrdre().equals("") && !sqlal.isAdd().booleanValue() && sqlalList.size() == 1) {
                if (entInfos.getStandardAccess().equals("DC")) {
                    SQLAndF80Utilities.writeWhereDC(entInfos, contribution, lsDataElement, lsLabel);
                    continue;
                }
                SQLAndF80Utilities.writeWhere(entInfos, contribution, lsDataElement, lsLabel);
                continue;
            }
            if (sqlal.getDescription().trim().length() > 0) {
                String description = sqlal.getDescription().toUpperCase();
                String descrAfterSql = "";
                descrAfterSql = description.contains("SQL-") ? entInfos.analyseLineForSQL(description) : description;
                String infosToChar = "";
                String infosExtendedDate = "";
                String type = "";
                String hostVariable = "";
                String indicator = "";
                String hostInd = "";
                int pos = descrAfterSql.indexOf(":-");
                int posV = descrAfterSql.indexOf(":V");
                if (pos >= 0) {
                    DataElement de;
                    int posV2;
                    String specialChars = "\\/*<>|\"%#?";
                    String line = descrAfterSql.substring(pos + 2);
                    int endPosition = -1;
                    int i = 1;
                    while (i < line.length()) {
                        char charact = line.charAt(i);
                        if ((Character.isWhitespace(charact) || charact == '.' || charact == ')' || charact == ':') && charact != '$' && charact != '-' && specialChars.indexOf(charact) == -1) {
                            endPosition = i;
                            break;
                        }
                        ++i;
                    }
                    String dataElementCode = "";
                    dataElementCode = endPosition > 0 ? line.substring(0, endPosition) : line;
                    if (entInfos.getPbb() != null && entInfos.isOracle()) {
                        String dataElementToSearch = dataElementCode;
                        posV2 = dataElementCode.indexOf(":V");
                        if (posV2 > 0) {
                            dataElementToSearch = dataElementCode.substring(0, posV2);
                        }
                        if ((de = SQLUtilities.searchDataElement((GeneratorInfosForSQLEntities)entInfos, (String)dataElementToSearch)) != null) {
                            infosToChar = entInfos.findExtendedFormat(de);
                        }
                    }
                    if (entInfos.getPbb() != null && entInfos.getPbb().getBlockType().equals(PacBlockBaseTypeValues._QN_LITERAL)) {
                        String dataElementToSearch = dataElementCode;
                        posV2 = dataElementCode.indexOf(":V");
                        if (posV2 > 0) {
                            dataElementToSearch = dataElementCode.substring(0, posV2);
                        }
                        if ((de = SQLUtilities.searchDataElement((GeneratorInfosForSQLEntities)entInfos, (String)dataElementToSearch)) != null) {
                            infosExtendedDate = entInfos.findExtendedFormat(de);
                        }
                        type = infosExtendedDate == null && entInfos.isExtendedFormat() ? "" : entInfos.findInfosCheckType(de);
                    }
                    if (entInfos.isNewAccess()) {
                        infosToChar = "";
                        infosExtendedDate = "";
                        type = "";
                    }
                    if (posV >= 0) {
                        hostVariable = SQLAndF80Utilities.generateHostVariable(entInfos, descrAfterSql.substring(pos + 2, posV), dag);
                        indicator = SQLAndF80Utilities.generateIndicator(cursorCode, descrAfterSql.substring(posV + 2), dag);
                    } else {
                        hostVariable = SQLAndF80Utilities.generateHostVariable(entInfos, descrAfterSql.substring(pos + 2), dag);
                        int posfin = pos + 2 + dataElementCode.length();
                        indicator = descrAfterSql.substring(posfin);
                    }
                } else if (posV >= 0) {
                    indicator = SQLAndF80Utilities.generateIndicator(cursorCode, descrAfterSql.substring(posV + 2), dag);
                } else {
                    hostVariable = SQLAndF80Utilities.generateHostVariable(entInfos, descrAfterSql.substring(pos + 2), dag);
                }
                hostInd = hostVariable.concat(indicator);
                if (infosToChar != null && infosToChar.length() > 0) {
                    hostInd = "TO_DATE(:" + hostInd.substring(2) + infosToChar;
                }
                if (!type.equals("")) {
                    hostInd = String.valueOf(hostInd) + type;
                }
                if (infosExtendedDate != null && infosExtendedDate.length() > 0) {
                    hostInd = String.valueOf(hostInd) + " TYPE AS DATETIME" + " " + infosExtendedDate;
                }
                if ((desc = pos >= 0 ? String.valueOf(descrAfterSql.substring(0, pos)) + hostInd : descrAfterSql).contains("SQL-")) {
                    desc = entInfos.analyseLineForSQL(desc);
                }
            }
            String ordre = sqlal.getOrdre().toUpperCase();
            String sep = "";
            if (sqlal.getOrdre().toUpperCase().equals("PARAM")) {
                ordre = "";
            }
            if (sqlal.getOrdre().toUpperCase().equals("ORDER")) {
                ordre = ORDBY;
                sep = entInfos.defineSep(ordre, sqlal);
            }
            if (num > 1 || isWhereClause.booleanValue() && sqlal.isAdd().booleanValue() && !lsDataElement.isEmpty()) {
                ordre = "";
            }
            if (isWhereClause.booleanValue() && sqlal.isAdd().booleanValue()) {
                if (entInfos.getStandardAccess().equals("DC")) {
                    SQLAndF80Utilities.writeWhereDC(entInfos, contribution, lsDataElement, lsLabel);
                } else {
                    SQLAndF80Utilities.writeWhere(entInfos, contribution, lsDataElement, lsLabel);
                }
            }
            String s = "";
            if (it.hasNext()) {
                contribution.append(NEW_LINE);
                contribution.append("           ");
                s = String.valueOf(ordre) + " " + desc.toUpperCase() + sep;
                if (entInfos.getPbb() != null && entInfos.getPbb().getBlockType().equals(PacBlockBaseTypeValues._QN_LITERAL) && s.length() > 50) {
                    SQLAndF80Utilities.splitLine(contribution, s);
                    continue;
                }
                contribution.append(s);
                continue;
            }
            contribution.append(NEW_LINE);
            contribution.append("           ");
            if (num == 1) {
                s = String.valueOf(ordre) + " " + desc.toUpperCase();
                if (entInfos.getPbb() != null && entInfos.getPbb().getBlockType().equals(PacBlockBaseTypeValues._QN_LITERAL) && s.length() > 50) {
                    SQLAndF80Utilities.splitLine(contribution, s);
                    continue;
                }
                contribution.append(s);
                continue;
            }
            s = desc.toUpperCase();
            if (entInfos.getPbb() != null && entInfos.getPbb().getBlockType().equals(PacBlockBaseTypeValues._QN_LITERAL) && s.length() > 50) {
                SQLAndF80Utilities.splitLine(contribution, s);
                continue;
            }
            contribution.append(s);
        }
    }

    public static void splitLine(GeneratorInfosForSQLEntities.MPALine contribution, String s) {
        int i = 50;
        while (i >= 0 && !Character.isWhitespace(s.charAt(i))) {
            --i;
        }
        contribution.append(s.substring(0, i));
        contribution.append(NEW_LINE);
        contribution.append("           " + s.substring(i + 1));
    }

    public static String trimRight(String name) {
        int end = name.length() - 1;
        char[] value = name.toCharArray();
        while (end >= 0 && value[end] <= ' ') {
            --end;
        }
        return new String(value, 0, end + 1);
    }

    public static void writeSpecificAccess(AccessGeneratorInfosForSQL accessGenInfos) {
        SQLUtilities.standardAccessList accessType = SQLUtilities.getAccess((String)accessGenInfos.getGenInfos().getStandardAccess());
        switch (accessType) {
            case DC: {
                SQLAndF80Utilities.generateSpecificDC(accessGenInfos);
                break;
            }
            case R: {
                SQLAndF80Utilities.generateSpecificR(accessGenInfos);
                break;
            }
            case RU: {
                SQLAndF80Utilities.generateSpecificRU(accessGenInfos);
                break;
            }
            case W: {
                SQLAndF80Utilities.generateSpecificW(accessGenInfos);
                break;
            }
            case RW: {
                SQLAndF80Utilities.generateSpecificRW(accessGenInfos);
                break;
            }
            case D: {
                SQLAndF80Utilities.generateSpecificD(accessGenInfos);
                break;
            }
            case P: {
                SQLAndF80Utilities.generateSpecificP(accessGenInfos);
                break;
            }
            case RN: {
                SQLAndF80Utilities.generateSpecificRN(accessGenInfos);
                break;
            }
            case CL: {
                SQLAndF80Utilities.generateSpecificCL(accessGenInfos);
                break;
            }
            case RA: {
                SQLAndF80Utilities.generateSpecificRA(accessGenInfos);
                break;
            }
            case SP: {
                SQLAndF80Utilities.generateSpecificNA(accessGenInfos);
                break;
            }
        }
    }

    private static void writeEndSpecificAccess(GeneratorInfosForSQLEntities entInfos, GeneratorInfosForSQLEntities.MPALine contribution) {
        if (!entInfos.isMultiRow() || !entInfos.getStandardAccess().equals("RN")) {
            contribution.append(NEW_LINE);
            contribution.append("           ");
            contribution.append(END);
            if (entInfos.isXnn() && entInfos.getStandardAccess().equals("DC") || entInfos.isMPSQL() && entInfos.getPgm() == null) {
                contribution.append(DOT);
            }
            contribution.append(NEW_LINE);
        }
        String extractMethod = entInfos.getExtractMethod();
        String specificAccess = entInfos.getNoStandardAccess();
        boolean isPersEx = false;
        if (extractMethod != null && extractMethod.trim().length() > 0 && specificAccess.trim().length() > 0) {
            isPersEx = true;
        }
        if (!entInfos.isXnn()) {
            if (entInfos.getPgm() != null || entInfos.getPgm() == null && entInfos.getExtractMethod().trim().length() == 0 && !entInfos.getStandardAccess().equals("P") && !entInfos.getStandardAccess().equals("*D")) {
                SQLAndF80Utilities.writeGoToF80(entInfos, contribution);
            }
            if (entInfos.getPgm() == null && isPersEx && !entInfos.getStandardAccess().equals("*D")) {
                SQLAndF80Utilities.writeGoToF80(contribution);
            }
        }
    }

    public static void writeStandardAccess(AccessGeneratorInfosForSQL accessGenInfos) {
        SQLUtilities.standardAccessList accessType = SQLUtilities.getAccess((String)accessGenInfos.getGenInfos().getStandardAccess());
        switch (accessType) {
            case DC: {
                SQLAndF80Utilities.generateStandardDC(accessGenInfos);
                break;
            }
            case R: {
                SQLAndF80Utilities.generateStandardR(accessGenInfos);
                break;
            }
            case RU: {
                SQLAndF80Utilities.generateStandardRU(accessGenInfos);
                break;
            }
            case W: {
                SQLAndF80Utilities.generateStandardW(accessGenInfos);
                break;
            }
            case RW: {
                SQLAndF80Utilities.generateStandardRW(accessGenInfos);
                break;
            }
            case D: {
                SQLAndF80Utilities.generateStandardD(accessGenInfos);
                break;
            }
            case P: {
                SQLAndF80Utilities.generateStandardP(accessGenInfos);
                break;
            }
            case RN: {
                SQLAndF80Utilities.generateStandardRN(accessGenInfos);
                break;
            }
            case CL: {
                SQLAndF80Utilities.generateStandardCL(accessGenInfos);
                break;
            }
            case RA: {
                SQLAndF80Utilities.generateStandardRA(accessGenInfos);
                break;
            }
            case SP: {
                break;
            }
        }
    }

    private static void generateEndAccess(GeneratorInfosForSQLEntities.MPALine contribution, GeneratorInfosForSQLEntities entInfos) {
        if (!entInfos.isMultiRow() || !entInfos.getStandardAccess().equals("RN")) {
            contribution.append(NEW_LINE);
            contribution.append("           ");
            contribution.append(END);
            if (!entInfos.isMPSQL() && (!entInfos.isXnn() || entInfos.isXnn() && entInfos.getStandardAccess().equals("DC"))) {
                contribution.append(DOT);
            }
            if (entInfos.isMPSQL() && !entInfos.isXnn() && entInfos.getPgm() == null) {
                contribution.append(DOT);
            }
            contribution.append(NEW_LINE);
        }
        if (!entInfos.isXnn()) {
            SQLAndF80Utilities.writeGoToF80(entInfos, contribution);
        }
    }

    private static void writeBeginAccess(GeneratorInfosForSQLEntities.MPALine contribution, GeneratorInfosForSQLEntities entInfos, String access) {
        String noStandardAccess = entInfos.getNoStandardAccess();
        String cursorCode = entInfos.getCursorCode();
        entInfos.getStandardAccess();
        String extractMethod = entInfos.getExtractMethod();
        if (noStandardAccess.equals("")) {
            entInfos.setFromStandardAccess(true);
        }
        if (extractMethod.trim().length() > 0 && entInfos.getPgm() == null) {
            if (noStandardAccess.trim().length() > 0) {
                SQLAndF80Utilities.writeEtiqBeginExtractMethod(contribution, cursorCode, extractMethod, noStandardAccess);
                SQLAndF80Utilities.writeCSLinesEx(contribution, noStandardAccess, extractMethod);
            } else {
                SQLAndF80Utilities.writeEtiqBeginExtractMethod(contribution, cursorCode, extractMethod, access);
                SQLAndF80Utilities.writeCSLinesEx(contribution, access, extractMethod);
            }
        } else {
            if (!entInfos.isXnn() && !entInfos.getStandardAccess().equals("DC") || entInfos.isXnn() && entInfos.getStandardAccess().equals("P")) {
                SQLAndF80Utilities.writeEtiqDeb(entInfos, contribution, cursorCode, noStandardAccess);
            }
            if (entInfos.getScr() == null || entInfos.getScr() != null && !SQLUtilities.isClient((PacScreen)entInfos.getScr())) {
                SQLAndF80Utilities.writeCSLine(entInfos, contribution, noStandardAccess, entInfos.getDag(), entInfos.getPbb());
            }
        }
        SQLAndF80Utilities.writeExecLine(entInfos, contribution, entInfos.isMultiRow(), entInfos.getPbb(), entInfos.getDescriptionType());
    }

    public static void generateStandardRA(AccessGeneratorInfosForSQL accessGenInfos) {
        GeneratorInfosForSQLEntities.MPALine contribution = accessGenInfos.getGenInfos().getMpaline();
        GeneratorInfosForSQLEntities entInfos = accessGenInfos.getGenInfos();
        String standardAccess = entInfos.getStandardAccess();
        String cursorCode = entInfos.getCursorCode();
        String sdCode = entInfos.getSdCode();
        SQLAndF80Utilities.writeBeginAccess(contribution, entInfos, "RA");
        SQLAndF80Utilities.writeRorRULine(contribution, entInfos.isSQLALL());
        entInfos.setFirst(true);
        if (entInfos.isSQLALL()) {
            if (SQLAndF80Utilities.writeAllColumn(entInfos, contribution, false)) {
                SQLAndF80Utilities.updateLastColumn(contribution, standardAccess);
                entInfos.setFirstV(true);
                SQLAndF80Utilities.writeAllVLines(entInfos, contribution, false);
                SQLAndF80Utilities.updateLastVline(contribution, standardAccess);
            }
        } else {
            SQLAndF80Utilities.writeForSTARSelect(contribution, entInfos, INTO, "");
        }
        if (cursorCode.startsWith(sdCode) && entInfos.getPbb() != null && !entInfos.getPbb().getBlockType().equals(PacBlockBaseTypeValues._QR_LITERAL)) {
            SQLAndF80Utilities.writeFromOrIntoLine(entInfos, contribution, true);
        }
        if (entInfos.getPgm() == null && !entInfos.getKeysDisplay().isEmpty()) {
            SQLAndF80Utilities.writeWhere(entInfos, contribution, entInfos.getKeysDisplay(), entInfos.getRelLabelDisplay());
        }
        if (entInfos.getPbb() != null && entInfos.getPbb().getBlockType().equals(PacBlockBaseTypeValues._QN_LITERAL)) {
            SQLAndF80Utilities.writeForBrowseAccess(contribution);
        }
        SQLAndF80Utilities.generateEndAccess(contribution, entInfos);
    }

    public static void generateStandardCL(AccessGeneratorInfosForSQL accessGenInfos) {
        GeneratorInfosForSQLEntities.MPALine contribution = accessGenInfos.getGenInfos().getMpaline();
        GeneratorInfosForSQLEntities entInfos = accessGenInfos.getGenInfos();
        SQLAndF80Utilities.writeBeginAccess(contribution, entInfos, "CL");
        String cursorCode = entInfos.getCursorCode();
        if (entInfos.getPgm() == null && entInfos.getExtractMethod().trim().length() > 0) {
            SQLAndF80Utilities.writeCLExLine(contribution, entInfos.getExtractMethod());
        } else {
            SQLAndF80Utilities.writeCLLine(contribution, cursorCode);
        }
        SQLAndF80Utilities.generateEndAccess(contribution, entInfos);
    }

    public static void generateStandardRN(AccessGeneratorInfosForSQL accessGenInfos) {
        GeneratorInfosForSQLEntities.MPALine contribution = accessGenInfos.getGenInfos().getMpaline();
        GeneratorInfosForSQLEntities entInfos = accessGenInfos.getGenInfos();
        ArrayList sqlalListColumn = entInfos.getListColumn();
        String standardAccess = entInfos.getStandardAccess();
        String cursorCode = entInfos.getCursorCode();
        SQLAndF80Utilities.writeBeginAccess(contribution, entInfos, "RN");
        if (!entInfos.isMultiRow()) {
            if (entInfos.getPgm() == null && entInfos.getExtractMethod().trim().length() > 0) {
                SQLAndF80Utilities.writeRNExLine(contribution, entInfos.getExtractMethod());
            } else {
                SQLAndF80Utilities.writeRNLine(contribution, cursorCode);
            }
            if (!sqlalListColumn.isEmpty() && standardAccess.equals("EX") && SQLAndF80Utilities.allColumnWellFormed(sqlalListColumn)) {
                entInfos.setFirst(true);
                entInfos.setFirstV(true);
                SQLAndF80Utilities.writeColumnLine(entInfos, contribution, sqlalListColumn, "RN");
            } else if (entInfos.isSQLALL()) {
                entInfos.setFirstV(true);
                SQLAndF80Utilities.writeAllVLines(entInfos, contribution, false);
                SQLAndF80Utilities.updateLastVline(contribution, standardAccess);
            } else {
                SQLAndF80Utilities.writeIntoClause(contribution, entInfos);
            }
        } else {
            SQLAndF80Utilities.writeRNForMultiRow(entInfos, contribution, null);
        }
        SQLAndF80Utilities.generateEndAccess(contribution, entInfos);
    }

    private static void writeIntoClause(GeneratorInfosForSQLEntities.MPALine contribution, GeneratorInfosForSQLEntities entInfos) {
        contribution.append(NEW_LINE);
        contribution.append("           ");
        contribution.append("INTO :" + entInfos.getCursorCode() + ":V" + entInfos.getCursorCode() + "A");
    }

    private static boolean allColumnWellFormed(ArrayList<AccessGeneratorInfosForSQL.SQLAccessLine> sqlalListColumn) {
        Iterator<AccessGeneratorInfosForSQL.SQLAccessLine> it = sqlalListColumn.iterator();
        boolean isOK = false;
        while (it.hasNext()) {
            AccessGeneratorInfosForSQL.SQLAccessLine line = it.next();
            if (line.getDescription().contains("SQL-")) {
                isOK = true;
                continue;
            }
            isOK = false;
            break;
        }
        return isOK;
    }

    public static void generateStandardP(AccessGeneratorInfosForSQL accessGenInfos) {
        GeneratorInfosForSQLEntities.MPALine contribution = accessGenInfos.getGenInfos().getMpaline();
        GeneratorInfosForSQLEntities entInfos = accessGenInfos.getGenInfos();
        String cursorCode = entInfos.getCursorCode();
        SQLAndF80Utilities.writeBeginAccess(contribution, entInfos, "P");
        if (entInfos.getPgm() == null && entInfos.getExtractMethod().trim().length() > 0) {
            SQLAndF80Utilities.writePExLine(contribution, entInfos.getExtractMethod());
        } else {
            SQLAndF80Utilities.writePLine(contribution, cursorCode);
        }
        SQLAndF80Utilities.generateEndAccess(contribution, entInfos);
    }

    public static void generateStandardUN(AccessGeneratorInfosForSQL accessGenInfos) {
        GeneratorInfosForSQLEntities.MPALine contribution = accessGenInfos.getGenInfos().getMpaline();
        GeneratorInfosForSQLEntities entInfos = accessGenInfos.getGenInfos();
        String cursorCode = entInfos.getCursorCode();
        SQLAndF80Utilities.writeEtiqBegin(contribution, cursorCode, "UN");
        SQLAndF80Utilities.writeGoToF80(entInfos, contribution);
    }

    public static void generateStandardD(AccessGeneratorInfosForSQL accessGenInfos) {
        GeneratorInfosForSQLEntities.MPALine contribution = accessGenInfos.getGenInfos().getMpaline();
        GeneratorInfosForSQLEntities entInfos = accessGenInfos.getGenInfos();
        String cursorCode = entInfos.getCursorCode();
        String sdCode = entInfos.getSdCode();
        SQLAndF80Utilities.writeBeginAccess(contribution, entInfos, "D");
        SQLAndF80Utilities.writeDLine(contribution);
        if (cursorCode.startsWith(sdCode) && entInfos.getPbb() != null && !entInfos.getPbb().getBlockType().equals(PacBlockBaseTypeValues._QR_LITERAL)) {
            SQLAndF80Utilities.writeFromOrIntoLine(entInfos, contribution, true);
        }
        if (entInfos.getPgm() == null && !entInfos.getKeysUpdate().isEmpty()) {
            ArrayList<String> lskeys = new ArrayList<String>();
            ArrayList<String> lsLabel = new ArrayList<String>();
            int i = 0;
            while (i < entInfos.getKeysUpdate().size()) {
                if (((String)entInfos.getKeysUpdate().get(i)).indexOf(SEP) > -1) {
                    String use = ((String)entInfos.getKeysUpdate().get(i)).substring(((String)entInfos.getKeysUpdate().get(i)).indexOf(SEP) + 1);
                    if (entInfos.getSrv() != null && (use.equals("S") || use.equals("T")) || entInfos.getScr() != null && use.equals("X")) {
                        lskeys.add((String)entInfos.getKeysUpdate().get(i));
                        lsLabel.add((String)entInfos.getRelLabelUpdate().get(i));
                    }
                }
                ++i;
            }
            SQLAndF80Utilities.writeWhere(entInfos, contribution, lskeys, lsLabel);
        }
        SQLAndF80Utilities.generateEndAccess(contribution, entInfos);
    }

    public static void generateStandardRW(AccessGeneratorInfosForSQL accessGenInfos) {
        GeneratorInfosForSQLEntities.MPALine contribution = accessGenInfos.getGenInfos().getMpaline();
        GeneratorInfosForSQLEntities entInfos = accessGenInfos.getGenInfos();
        DataAggregateDescription descriptionSeg = null;
        if (entInfos.getDag() != null) {
            descriptionSeg = (DataAggregateDescription)entInfos.getDag().getDataDescription();
        }
        String standardAccess = entInfos.getStandardAccess();
        String cursorCode = entInfos.getCursorCode();
        String sdCode = entInfos.getSdCode();
        SQLAndF80Utilities.writeBeginAccess(contribution, entInfos, "RW");
        SQLAndF80Utilities.writeRWLine(contribution);
        if (cursorCode.startsWith(sdCode) && entInfos.getPbb() != null && !entInfos.getPbb().getBlockType().equals(PacBlockBaseTypeValues._QR_LITERAL)) {
            SQLAndF80Utilities.writeFromOrIntoLine(entInfos, contribution, true);
        }
        SQLAndF80Utilities.writeRWLine(entInfos, contribution, descriptionSeg, false, 1);
        SQLAndF80Utilities.updateLastVline(contribution, standardAccess);
        if (entInfos.getPgm() == null && !entInfos.getKeysUpdate().isEmpty()) {
            ArrayList<String> lskeys = new ArrayList<String>();
            ArrayList<String> lsLabel = new ArrayList<String>();
            int i = 0;
            while (i < entInfos.getKeysUpdate().size()) {
                String use;
                if (((String)entInfos.getKeysUpdate().get(i)).indexOf(SEP) > -1 && ((use = ((String)entInfos.getKeysUpdate().get(i)).substring(((String)entInfos.getKeysUpdate().get(i)).indexOf(SEP) + 1)).equals("M") || use.equals("X") || use.equals("T"))) {
                    lskeys.add((String)entInfos.getKeysUpdate().get(i));
                    lsLabel.add((String)entInfos.getRelLabelUpdate().get(i));
                }
                ++i;
            }
            SQLAndF80Utilities.writeWhere(entInfos, contribution, lskeys, lsLabel);
        }
        SQLAndF80Utilities.generateEndAccess(contribution, entInfos);
    }

    public static void generateStandardW(AccessGeneratorInfosForSQL accessGenInfos) {
        GeneratorInfosForSQLEntities.MPALine contribution = accessGenInfos.getGenInfos().getMpaline();
        GeneratorInfosForSQLEntities entInfos = accessGenInfos.getGenInfos();
        String standardAccess = entInfos.getStandardAccess();
        String cursorCode = entInfos.getCursorCode();
        String sdCode = entInfos.getSdCode();
        SQLAndF80Utilities.writeBeginAccess(contribution, entInfos, "W");
        SQLAndF80Utilities.writeWLine(contribution);
        if (cursorCode.startsWith(sdCode) && entInfos.getPbb() != null && !entInfos.getPbb().getBlockType().equals(PacBlockBaseTypeValues._QR_LITERAL)) {
            SQLAndF80Utilities.writeFromOrIntoLine(entInfos, contribution, true);
        }
        if (entInfos.isSQLALL()) {
            entInfos.setFirst(true);
            if (SQLAndF80Utilities.writeAllColumn(entInfos, contribution, false)) {
                SQLAndF80Utilities.updateLastColumn(contribution, standardAccess);
                entInfos.setFirstV(true);
                SQLAndF80Utilities.writeAllVLines(entInfos, contribution, false);
                SQLAndF80Utilities.updateLastVline(contribution, standardAccess);
            }
        } else {
            SQLAndF80Utilities.writeForSTARSelect(contribution, entInfos, VALUES, PARC);
        }
        SQLAndF80Utilities.generateEndAccess(contribution, entInfos);
    }

    public static void generateStandardRU(AccessGeneratorInfosForSQL accessGenInfos) {
        GeneratorInfosForSQLEntities.MPALine contribution = accessGenInfos.getGenInfos().getMpaline();
        GeneratorInfosForSQLEntities entInfos = accessGenInfos.getGenInfos();
        String standardAccess = entInfos.getStandardAccess();
        String cursorCode = entInfos.getCursorCode();
        String sdCode = entInfos.getSdCode();
        SQLAndF80Utilities.writeBeginAccess(contribution, entInfos, "RU");
        SQLAndF80Utilities.writeRorRULine(contribution, entInfos.isSQLALL());
        entInfos.setFirst(true);
        if (entInfos.isSQLALL()) {
            if (SQLAndF80Utilities.writeAllColumn(entInfos, contribution, false)) {
                SQLAndF80Utilities.updateLastColumn(contribution, standardAccess);
                entInfos.setFirstV(true);
                SQLAndF80Utilities.writeAllVLines(entInfos, contribution, false);
                SQLAndF80Utilities.updateLastVline(contribution, standardAccess);
            }
        } else {
            SQLAndF80Utilities.writeForSTARSelect(contribution, entInfos, INTO, "");
        }
        if (cursorCode.startsWith(sdCode) && entInfos.getPbb() != null && !entInfos.getPbb().getBlockType().equals(PacBlockBaseTypeValues._QR_LITERAL)) {
            SQLAndF80Utilities.writeFromOrIntoLine(entInfos, contribution, true);
        }
        if (entInfos.getPgm() == null && !entInfos.getKeysUpdate().isEmpty()) {
            ArrayList<String> lskeys = new ArrayList<String>();
            ArrayList<String> lsLabel = new ArrayList<String>();
            int i = 0;
            while (i < entInfos.getKeysUpdate().size()) {
                if (((String)entInfos.getKeysUpdate().get(i)).indexOf(SEP) > -1) {
                    String use = ((String)entInfos.getKeysUpdate().get(i)).substring(((String)entInfos.getKeysUpdate().get(i)).indexOf(SEP) + 1);
                    if (entInfos.getSrv() != null && (use.equals("S") || use.equals("C")) || use.equals("M") || use.equals("X") || use.equals("T")) {
                        lskeys.add((String)entInfos.getKeysUpdate().get(i));
                        lsLabel.add((String)entInfos.getRelLabelUpdate().get(i));
                    }
                }
                ++i;
            }
            SQLAndF80Utilities.writeWhere(entInfos, contribution, lskeys, lsLabel);
        }
        int version = 0;
        if (entInfos.getPbb() != null && entInfos.getPbb().getVersion().trim().length() > 0) {
            version = Integer.parseInt(entInfos.getPbb().getVersion());
        }
        if (entInfos.getPbb() != null && entInfos.isOracle() && version >= 7000) {
            SQLAndF80Utilities.writeForUpdate(contribution);
        }
        SQLAndF80Utilities.generateEndAccess(contribution, entInfos);
    }

    public static void generateStandardR(AccessGeneratorInfosForSQL accessGenInfos) {
        GeneratorInfosForSQLEntities.MPALine contribution = accessGenInfos.getGenInfos().getMpaline();
        GeneratorInfosForSQLEntities entInfos = accessGenInfos.getGenInfos();
        String standardAccess = entInfos.getStandardAccess();
        String cursorCode = entInfos.getCursorCode();
        String sdCode = entInfos.getSdCode();
        SQLAndF80Utilities.writeBeginAccess(contribution, entInfos, "R");
        SQLAndF80Utilities.writeRorRULine(contribution, entInfos.isSQLALL());
        entInfos.setFirst(true);
        if (entInfos.isSQLALL()) {
            if (SQLAndF80Utilities.writeAllColumn(entInfos, contribution, false)) {
                SQLAndF80Utilities.updateLastColumn(contribution, standardAccess);
                entInfos.setFirstV(true);
                SQLAndF80Utilities.writeAllVLines(entInfos, contribution, false);
                SQLAndF80Utilities.updateLastVline(contribution, standardAccess);
            }
        } else {
            SQLAndF80Utilities.writeForSTARSelect(contribution, entInfos, INTO, "");
        }
        if (cursorCode.startsWith(sdCode) && entInfos.getPbb() != null && !entInfos.getPbb().getBlockType().equals(PacBlockBaseTypeValues._QR_LITERAL)) {
            SQLAndF80Utilities.writeFromOrIntoLine(entInfos, contribution, true);
        }
        if (entInfos.getPgm() == null) {
            if (!entInfos.getKeysRead().isEmpty()) {
                ArrayList<String> lskeys = new ArrayList<String>();
                ArrayList<String> lsLabel = new ArrayList<String>();
                int i = 0;
                while (i < entInfos.getKeysRead().size()) {
                    String use;
                    if (!(((String)entInfos.getKeysRead().get(i)).indexOf(SEP) <= -1 || (use = ((String)entInfos.getKeysRead().get(i)).substring(((String)entInfos.getKeysRead().get(i)).indexOf(SEP) + 1)).equals("N") && entInfos.getScr() == null)) {
                        lskeys.add((String)entInfos.getKeysRead().get(i));
                        lsLabel.add((String)entInfos.getRelLabelRead().get(i));
                    }
                    ++i;
                }
                SQLAndF80Utilities.writeWhere(entInfos, contribution, lskeys, lsLabel);
            } else if (!entInfos.getKeysUpdate().isEmpty()) {
                ArrayList<String> lskeys = new ArrayList<String>();
                ArrayList<String> lsLabel = new ArrayList<String>();
                int i = 0;
                while (i < entInfos.getKeysUpdate().size()) {
                    String use;
                    if (!(((String)entInfos.getKeysUpdate().get(i)).indexOf(SEP) <= -1 || (use = ((String)entInfos.getKeysUpdate().get(i)).substring(((String)entInfos.getKeysUpdate().get(i)).indexOf(SEP) + 1)).equals("N") && entInfos.getScr() == null)) {
                        lskeys.add((String)entInfos.getKeysUpdate().get(i));
                        lsLabel.add((String)entInfos.getRelLabelUpdate().get(i));
                    }
                    ++i;
                }
                SQLAndF80Utilities.writeWhere(entInfos, contribution, lskeys, lsLabel);
            }
        }
        if (entInfos.getPbb() != null && entInfos.getPbb().getBlockType().equals(PacBlockBaseTypeValues._QN_LITERAL)) {
            SQLAndF80Utilities.writeForBrowseAccess(contribution);
        }
        SQLAndF80Utilities.generateEndAccess(contribution, entInfos);
    }

    private static void writeForSTARSelect(GeneratorInfosForSQLEntities.MPALine contribution, GeneratorInfosForSQLEntities entInfos, String value, String end) {
        contribution.append(NEW_LINE);
        contribution.append("           ");
        contribution.append(value);
        contribution.append(" :");
        contribution.append(entInfos.getCursorCode());
        contribution.append(":V");
        contribution.append(entInfos.getCursorCode());
        contribution.append("A");
        contribution.append(end);
    }

    public static void generateStandardDC(AccessGeneratorInfosForSQL accessGenInfos) {
        GeneratorInfosForSQLEntities.MPALine contribution = accessGenInfos.getGenInfos().getMpaline();
        GeneratorInfosForSQLEntities entInfos = accessGenInfos.getGenInfos();
        String standardAccess = entInfos.getStandardAccess();
        String cursorCode = entInfos.getCursorCode();
        String sdCode = entInfos.getSdCode();
        SQLAndF80Utilities.writeBeginAccess(contribution, entInfos, "DC");
        if (entInfos.isSQLALL()) {
            if (!entInfos.isMultiRow()) {
                SQLAndF80Utilities.writeDeclareCursorFSA(contribution, cursorCode);
            } else {
                SQLAndF80Utilities.writeDeclareCursorForMultiRow(contribution, cursorCode);
            }
            entInfos.setFirst(true);
            if (SQLAndF80Utilities.writeAllColumn(entInfos, contribution, false)) {
                SQLAndF80Utilities.updateLastColumn(contribution, standardAccess);
            }
        } else if (!entInfos.isMultiRow()) {
            SQLAndF80Utilities.writeDeclareCursorStar(contribution, cursorCode);
        } else {
            SQLAndF80Utilities.writeDeclareCursorForMultiRow(contribution, cursorCode);
        }
        if (cursorCode.startsWith(sdCode) && entInfos.getPbb() != null && !entInfos.getPbb().getBlockType().equals(PacBlockBaseTypeValues._QR_LITERAL)) {
            SQLAndF80Utilities.writeFromOrIntoLine(entInfos, contribution, true);
        }
        if (cursorCode.startsWith(sdCode) && entInfos.getPbb() == null && entInfos.getListAccess().isEmpty() && entInfos.getListColumn().isEmpty() && entInfos.getListFrom().isEmpty() && entInfos.getListOrder().isEmpty() && entInfos.getListOther().isEmpty() && entInfos.getListParam().isEmpty() && entInfos.getNoStandardAccess().trim().length() > 0) {
            SQLAndF80Utilities.writeFromOrIntoLine(entInfos, contribution, false);
        }
        if (entInfos.getPgm() == null && !entInfos.getKeysDisplay().isEmpty()) {
            SQLAndF80Utilities.writeWhereAndOrderBy(entInfos, contribution, entInfos.getKeysDisplay(), entInfos.getRelLabelDisplay());
        }
        if (entInfos.getPbb() != null && entInfos.getPbb().getBlockType().equals(PacBlockBaseTypeValues._QN_LITERAL)) {
            SQLAndF80Utilities.writeForBrowseAccess(contribution);
        }
        if (entInfos.getPbb() != null) {
            SQLAndF80Utilities.writeForFetchOnly(entInfos, contribution);
        }
        SQLAndF80Utilities.generateEndAccess(contribution, entInfos);
    }

    private static void writeGoToF80(GeneratorInfosForSQLEntities entInfos, GeneratorInfosForSQLEntities.MPALine contribution) {
        if (entInfos.getPgm() == null && !entInfos.getStandardAccess().equals("DC")) {
            if (entInfos.getPbb() != null) {
                SQLAndF80Utilities.writeGoToF80(contribution, entInfos.getPbb().getBlockType());
            } else {
                SQLAndF80Utilities.writeGoToF80(contribution);
            }
        }
    }

    private static void writeEtiqEnd(GeneratorInfosForSQLEntities entInfos, GeneratorInfosForSQLEntities.MPALine contribution) {
        if (entInfos.getPgm() == null && (entInfos.getNewEtiq().length() > 0 || entInfos.isNewAccess())) {
            SQLAndF80Utilities.writeEtiqEnd(contribution, entInfos.getNoStandardAccess());
        }
    }

    private static void writeExecLine(GeneratorInfosForSQLEntities entInfos, GeneratorInfosForSQLEntities.MPALine contribution, boolean isMultiRow2, PacBlockBase pbb2, String descriptionType2) {
        SQLUtilities.standardAccessList accessType = SQLUtilities.getAccess((String)entInfos.getStandardAccess());
        if (entInfos.getPgm() != null) {
            if (!entInfos.isMultiRow() || !accessType.equals((Object)SQLUtilities.standardAccessList.RN)) {
                SQLAndF80Utilities.writeExecLine(contribution);
            }
        } else if (!entInfos.isMultiRow() || !accessType.equals((Object)SQLUtilities.standardAccessList.RN)) {
            if (entInfos.isOracle() && entInfos.getDescriptionType().equals("2")) {
                SQLAndF80Utilities.writeExecAt(contribution, entInfos.getPbb().getExternalName());
            } else {
                SQLAndF80Utilities.writeExecLine(contribution);
            }
        }
    }

    private static void writeCSLine(GeneratorInfosForSQLEntities entInfos, GeneratorInfosForSQLEntities.MPALine contribution, String nostandardAccess2, DataAggregate dag, PacBlockBase pbb) {
        if (entInfos.getScr() != null && SQLUtilities.isClient((PacScreen)entInfos.getScr()) || entInfos.getSrv() != null) {
            if (entInfos.getStandardAccess() != "") {
                SQLAndF80Utilities.writeCSLines(contribution, entInfos.getStandardAccess(), dag, pbb, SQLAndF80Utilities.getTableCode(entInfos));
            } else {
                SQLAndF80Utilities.writeCSLinesSP(contribution, entInfos.getNoStandardAccess(), dag, pbb, entInfos.getCursorCode());
            }
        }
    }

    public static void writeEtiqDeb(GeneratorInfosForSQLEntities entInfos, GeneratorInfosForSQLEntities.MPALine contribution, String cursorCode, String nostandardAccess) {
        SQLUtilities.standardAccessList accessType = SQLUtilities.getAccess((String)entInfos.getStandardAccess());
        if (entInfos.getPgm() == null) {
            if (accessType.equals((Object)SQLUtilities.standardAccessList.DC)) {
                if (entInfos.getStandardAccess().equals("*D")) {
                    SQLAndF80Utilities.writeEtiqBegin(contribution, cursorCode, "DC-ALL");
                } else {
                    SQLAndF80Utilities.writeEtiqBegin(contribution, cursorCode, nostandardAccess);
                }
            } else if (entInfos.getNewEtiq().length() == 0) {
                if (!entInfos.getStandardAccess().equals("")) {
                    if (entInfos.getStandardAccess().equals("*P")) {
                        SQLAndF80Utilities.writeEtiqBegin(contribution, cursorCode, "P-ALL");
                    } else if (entInfos.getStandardAccess().equals("*R")) {
                        SQLAndF80Utilities.writeEtiqBegin(contribution, cursorCode, "RN-ALL");
                    } else if (entInfos.getStandardAccess().equals("*C")) {
                        SQLAndF80Utilities.writeEtiqBegin(contribution, cursorCode, "CL-ALL");
                    } else {
                        SQLAndF80Utilities.writeEtiqBegin(contribution, cursorCode, entInfos.getStandardAccess());
                    }
                } else {
                    SQLAndF80Utilities.writeEtiqBegin(contribution, cursorCode, nostandardAccess);
                }
            } else {
                SQLAndF80Utilities.writeEtiqBegin(contribution, cursorCode, nostandardAccess);
            }
        }
    }

    private static void writeForFetchOnly(GeneratorInfosForSQLEntities entInfos, GeneratorInfosForSQLEntities.MPALine contribution) {
        if (entInfos.getPgm() != null) {
            int version = 0;
            if (entInfos.getPbb() != null && entInfos.getPbb().getVersion().trim().length() > 0) {
                version = Integer.parseInt(entInfos.getPbb().getVersion());
            }
            if ((entInfos.getPgm().getVariante().equals(PacProgramVariantValues._X_LITERAL) || entInfos.getPgm().getVariante().equals(PacProgramVariantValues._0_LITERAL)) && entInfos.getPbb() != null && entInfos.getPbb().getBlockType().equals(PacBlockBaseTypeValues._Q2_LITERAL) && version >= 2300) {
                SQLAndF80Utilities.writeFetchOnly(contribution);
            }
        }
    }

    private static void writeWhereAndOrderBy(GeneratorInfosForSQLEntities entInfos, GeneratorInfosForSQLEntities.MPALine contribution, ArrayList<String> lsDataElementCode, ArrayList<String> lsRelLabel) {
        SQLAndF80Utilities.writeWhereDC(entInfos, contribution, lsDataElementCode, lsRelLabel);
        SQLAndF80Utilities.writeOrderBy(entInfos, contribution, lsDataElementCode, lsRelLabel);
    }

    public static String generateF80D(AccessGeneratorInfosForSQL accessGenInfos, String segment) {
        PacScreen scr = ((ScreenGeneratorInfosForSQL)accessGenInfos).getScreen();
        ((ScreenGeneratorInfosForSQL)accessGenInfos).checkParametersXnn("D", segment);
        GeneratorInfosForSQLEntities geninfos = accessGenInfos.getGenInfos((RadicalEntity)scr, "D", segment, "");
        if (geninfos.isStandard()) {
            SQLAndF80Utilities.generateStandardD(accessGenInfos);
        } else {
            SQLAndF80Utilities.generateSpecificD(accessGenInfos);
        }
        return geninfos.getMpaline().toString();
    }

    public static String generateF80P(AccessGeneratorInfosForSQL accessGenInfos, String segment) {
        PacScreen scr = ((ScreenGeneratorInfosForSQL)accessGenInfos).getScreen();
        ((ScreenGeneratorInfosForSQL)accessGenInfos).checkParametersXnn("P", segment);
        GeneratorInfosForSQLEntities geninfos = accessGenInfos.getGenInfos((RadicalEntity)scr, "P", segment, "");
        geninfos.setXnn(true);
        if (geninfos.isStandard()) {
            SQLAndF80Utilities.generateStandardP(accessGenInfos);
        } else {
            SQLAndF80Utilities.generateSpecificP(accessGenInfos);
        }
        return geninfos.getMpaline().toString();
    }

    public static String generateF80R(AccessGeneratorInfosForSQL accessGenInfos, String segment) {
        PacScreen scr = ((ScreenGeneratorInfosForSQL)accessGenInfos).getScreen();
        ((ScreenGeneratorInfosForSQL)accessGenInfos).checkParametersXnn("R", segment);
        GeneratorInfosForSQLEntities geninfos = accessGenInfos.getGenInfos((RadicalEntity)scr, "R", segment, "");
        if (geninfos.isStandard()) {
            SQLAndF80Utilities.generateStandardR(accessGenInfos);
        } else {
            SQLAndF80Utilities.generateSpecificR(accessGenInfos);
        }
        return geninfos.getMpaline().toString();
    }

    public static String generateF80RU(AccessGeneratorInfosForSQL accessGenInfos, String segment) {
        PacScreen scr = ((ScreenGeneratorInfosForSQL)accessGenInfos).getScreen();
        ((ScreenGeneratorInfosForSQL)accessGenInfos).checkParametersXnn("RU", segment);
        GeneratorInfosForSQLEntities geninfos = accessGenInfos.getGenInfos((RadicalEntity)scr, "RU", segment, "");
        if (geninfos.isStandard()) {
            SQLAndF80Utilities.generateStandardRU(accessGenInfos);
        } else {
            SQLAndF80Utilities.generateSpecificRU(accessGenInfos);
        }
        return geninfos.getMpaline().toString();
    }

    public static String generateF80RN(AccessGeneratorInfosForSQL accessGenInfos, String segment) {
        PacScreen scr = ((ScreenGeneratorInfosForSQL)accessGenInfos).getScreen();
        ((ScreenGeneratorInfosForSQL)accessGenInfos).checkParametersXnn("RN", segment);
        GeneratorInfosForSQLEntities geninfos = accessGenInfos.getGenInfos((RadicalEntity)scr, "RN", segment, "");
        if (geninfos.isStandard()) {
            SQLAndF80Utilities.generateStandardRN(accessGenInfos);
        } else {
            SQLAndF80Utilities.generateSpecificRN(accessGenInfos);
        }
        return geninfos.getMpaline().toString();
    }

    public static String generateF80UN(AccessGeneratorInfosForSQL accessGenInfos, String segment) {
        PacScreen scr = ((ScreenGeneratorInfosForSQL)accessGenInfos).getScreen();
        ((ScreenGeneratorInfosForSQL)accessGenInfos).checkParametersXnn("UN", segment);
        GeneratorInfosForSQLEntities geninfos = accessGenInfos.getGenInfos((RadicalEntity)scr, "UN", segment, "");
        SQLAndF80Utilities.generateStandardUN(accessGenInfos);
        return geninfos.getMpaline().toString();
    }

    public static String generateF80DC(AccessGeneratorInfosForSQL accessGenInfos, String segment) {
        PacScreen scr = ((ScreenGeneratorInfosForSQL)accessGenInfos).getScreen();
        ((ScreenGeneratorInfosForSQL)accessGenInfos).checkParametersXnn("DC", segment);
        GeneratorInfosForSQLEntities geninfos = accessGenInfos.getGenInfos((RadicalEntity)scr, "DC", segment, "");
        geninfos.setXnn(true);
        if (geninfos.isStandard()) {
            SQLAndF80Utilities.generateStandardDC(accessGenInfos);
        } else {
            SQLAndF80Utilities.generateSpecificDC(accessGenInfos);
        }
        return geninfos.getMpaline().toString();
    }

    public static String generateF80CL(AccessGeneratorInfosForSQL accessGenInfos, String segment) {
        PacScreen scr = ((ScreenGeneratorInfosForSQL)accessGenInfos).getScreen();
        ((ScreenGeneratorInfosForSQL)accessGenInfos).checkParametersXnn("CL", segment);
        GeneratorInfosForSQLEntities geninfos = accessGenInfos.getGenInfos((RadicalEntity)scr, "CL", segment, "");
        if (geninfos.isStandard()) {
            SQLAndF80Utilities.generateStandardCL(accessGenInfos);
        } else {
            SQLAndF80Utilities.generateSpecificCL(accessGenInfos);
        }
        return geninfos.getMpaline().toString();
    }

    public static String generateF80RW(AccessGeneratorInfosForSQL accessGenInfos, String segment) {
        PacScreen scr = ((ScreenGeneratorInfosForSQL)accessGenInfos).getScreen();
        ((ScreenGeneratorInfosForSQL)accessGenInfos).checkParametersXnn("RW", segment);
        GeneratorInfosForSQLEntities geninfos = accessGenInfos.getGenInfos((RadicalEntity)scr, "RW", segment, "");
        if (geninfos.isStandard()) {
            SQLAndF80Utilities.generateStandardRW(accessGenInfos);
        } else {
            SQLAndF80Utilities.generateSpecificRW(accessGenInfos);
        }
        return geninfos.getMpaline().toString();
    }

    public static String generateF80W(AccessGeneratorInfosForSQL accessGenInfos, String segment) {
        PacScreen scr = ((ScreenGeneratorInfosForSQL)accessGenInfos).getScreen();
        ((ScreenGeneratorInfosForSQL)accessGenInfos).checkParametersXnn("W", segment);
        GeneratorInfosForSQLEntities geninfos = accessGenInfos.getGenInfos((RadicalEntity)scr, "W", segment, "");
        if (geninfos.isStandard()) {
            SQLAndF80Utilities.generateStandardW(accessGenInfos);
        } else {
            SQLAndF80Utilities.generateSpecificW(accessGenInfos);
        }
        return geninfos.getMpaline().toString();
    }

    public static String generateF80nn(String nn) {
        StringBuilder sb = new StringBuilder(70);
        sb.append("       F80");
        sb.append(nn);
        sb.append("-FN.    EXIT.");
        sb.append(NEW_LINE);
        return sb.toString();
    }

    public static String getNNforTag(IBuilderTag tag) {
        String currentNN = tag.getProperty(FILE_RANK_PROPERTY);
        if (currentNN != null && !"ZZ".equals(currentNN)) {
            try {
                Integer.parseInt(currentNN);
            }
            catch (NumberFormatException numberFormatException) {
                return "00";
            }
            return currentNN;
        }
        if (!"ZZ".equals(currentNN) && tag.getName().startsWith("F80") && tag.getName().length() == 5) {
            return tag.getName().substring(3);
        }
        return "00";
    }

    public static IBuilderTag getTagForF80Generation(IGenInfoBuilder genInfoBuilder, String segment, String id, String nn, String[] idTreeNames, boolean isGeneratednnFn) {
        String cnt;
        String specifProp;
        String sfseg = "F80-" + segment;
        String ssfct = "";
        ssfct = !id.contains("-EX-") ? String.valueOf(sfseg) + "-" + id : id;
        if (genInfoBuilder.tagFromName(ssfct) != null) {
            return genInfoBuilder.tagFromName(ssfct);
        }
        String fnContent = SQLAndF80Utilities.generateF80nn(nn);
        IBuilderTag tag = genInfoBuilder.tagFromName(sfseg);
        if (tag == null) {
            tag = genInfoBuilder.tagFromName("F80");
            if ((tag = SQLAndF80Utilities.searchSubFunctionFromF80(tag, nn)) == null) {
                return null;
            }
            int index = tag.getBeginIndex();
            tag = AbstractCommonMicroPatternHandler.AddTag(genInfoBuilder, index, index, sfseg, tag.getParent().getName());
            tag.setProperty(FILE_RANK_PROPERTY, nn);
            tag.setProperty("level", "9.5");
            if (isGeneratednnFn) {
                tag = AbstractCommonMicroPatternHandler.AddTag(genInfoBuilder, index, index, "F80" + nn + "-FN", sfseg);
                tag.setText((CharSequence)fnContent);
            }
            tag = genInfoBuilder.tagFromName(sfseg);
        } else if ("*R".equals(tag.getProperty("action"))) {
            return null;
        }
        IBuilderTag nextTag = tag.nextTag();
        if (nextTag != null && "True".equals(specifProp = nextTag.getProperty("SpecificTag")) && (cnt = nextTag.getText().toString()).equals(fnContent)) {
            genInfoBuilder.removeTagAndText(nextTag);
        }
        String fnName = "F80" + nn + "-FN";
        if (!(tag.lastSon() == null || tag.lastSon().getName().equals(fnName) || tag.lastSon().getText().toString().contains(fnName) || tag.lastSon().getTextAfter().toString().trim().startsWith(fnContent.trim()))) {
            int index = tag.lastSon().getEndIndex();
            IBuilderTag newTag = AbstractCommonMicroPatternHandler.AddTag(genInfoBuilder, index, index, "F80" + nn + "-FN", sfseg);
            newTag.setText((CharSequence)fnContent);
        }
        int index = tag.getBeginIndex();
        tag = null;
        int i = 0;
        while (i < idTreeNames.length) {
            String idName = idTreeNames[i];
            if (id.equals(idName)) break;
            if (genInfoBuilder.tagFromName(String.valueOf(sfseg) + "-" + idName) != null) {
                tag = genInfoBuilder.tagFromName(String.valueOf(sfseg) + "-" + idName);
            }
            ++i;
        }
        if (tag != null) {
            index = tag.getEndIndex();
            String refProperty = tag.getProperty("ref");
            if (refProperty != null) {
                tag = tag.nextTag();
                while (tag != null && (refProperty.equals(tag.getProperty("ref")) || refProperty.equals(tag.getProperty("MP_XNN_Ref")))) {
                    index = tag.getEndIndex();
                    tag = tag.nextTag();
                }
            }
        }
        tag = AbstractCommonMicroPatternHandler.AddTag(genInfoBuilder, index, index, ssfct, sfseg);
        tag.setProperty("level", "10");
        return tag;
    }

    public static void getOrCreateTagCursorAccess(IGenInfoBuilder genInfoBuilder, String cursorCode, String accessCode, String extractMethod, IBuilderTag current80) {
        IBuilderTag tagCursorAccessToCreate;
        String text = current80.getText().toString();
        String newLine = PdpTool.determineDelimiterOfV2((CharSequence)text);
        int beginIndexForText = current80.getBeginIndex();
        String tagCursorAccess = "F80-" + cursorCode + "-" + accessCode;
        if (extractMethod.length() > 0) {
            tagCursorAccess = String.valueOf(tagCursorAccess) + '-' + extractMethod;
        }
        if ((tagCursorAccessToCreate = genInfoBuilder.tagFromName(tagCursorAccess)) == null) {
            String tagParentName = current80.getName();
            int indexEtiqFN = text.indexOf("F80" + accessCode + "-FN");
            tagParentName = genInfoBuilder.includingTag(beginIndexForText + indexEtiqFN, beginIndexForText + indexEtiqFN + 1).getName();
            if (indexEtiqFN != -1) {
                indexEtiqFN = text.lastIndexOf(newLine, indexEtiqFN) + newLine.length();
                tagCursorAccessToCreate = AbstractCommonMicroPatternHandler.AddTag(genInfoBuilder, beginIndexForText + indexEtiqFN, beginIndexForText + indexEtiqFN, tagCursorAccess, tagParentName);
            }
        }
    }

    public static IBuilderTag getTagForF80SrvGeneration(IGenInfoBuilder genInfoBuilder, String segment, String id, String nn, String[] idTreeNames, IMicroPatternProcessingContext context, String specificAccess, String standardAccess) {
        String sfseg = "F80-" + segment;
        String ssfct = "";
        if (!id.contains("-EX-")) {
            if (id.equals("*D")) {
                id = "DC-ALL";
            } else if (id.equals("*C")) {
                id = "CL-ALL";
            } else if (id.equals("*R")) {
                id = "RN-ALL";
            } else if (id.equals("*P")) {
                id = "P-ALL";
            }
            ssfct = String.valueOf(sfseg) + "-" + id;
        } else {
            ssfct = id;
        }
        if (genInfoBuilder.tagFromName(ssfct) != null) {
            return genInfoBuilder.tagFromName(ssfct);
        }
        return null;
    }

    public static void manageTagF80SSnnForSrv(IGenInfoBuilder genInfoBuilder, MpSQLExtractionMethod mpsqlex) {
        IBuilderTag tag;
        IBuilderTag refTag;
        String sfseg = "F80-" + mpsqlex.getCursorCode();
        String ssfct = "";
        ssfct = !mpsqlex.getDeclaration().contains(" EX ") ? (mpsqlex.getMethodName().trim().length() > 0 ? String.valueOf(sfseg) + "-" + mpsqlex.getSpecificAccess() + "-" + mpsqlex.getMethodName() : String.valueOf(sfseg) + "-" + mpsqlex.getSpecificAccess()) : String.valueOf(sfseg) + "-EX-" + mpsqlex.getMethodName();
        IBuilderTag tagSSnn = genInfoBuilder.tagFromName(sfseg);
        if (tagSSnn == null) {
            IBuilderTag tagF80 = genInfoBuilder.tagFromName("F80");
            refTag = SQLAndF80Utilities.searchSubFunctionFromF80(tagF80, sfseg, "F80-");
            tagSSnn = genInfoBuilder.addTagBefore(sfseg, refTag.getName());
            tagSSnn.setProperty("level", "9.5");
        }
        if ((tag = genInfoBuilder.tagFromName(ssfct)) == null) {
            if (!mpsqlex.getReferenceTagName().equals("")) {
                if (mpsqlex.getReferenceTagName().equals(sfseg)) {
                    int begin = tagSSnn.getBeginIndex();
                    tag = genInfoBuilder.addTag(begin, begin, ssfct, sfseg);
                } else {
                    tag = genInfoBuilder.addTagAfter(ssfct, mpsqlex.getReferenceTagName());
                }
            } else if (mpsqlex.getFirstStandardAccess().equals("") && mpsqlex.getLastStandardAccess().equals("")) {
                refTag = SQLAndF80Utilities.searchSubFunctionFromF80(tagSSnn, sfseg, "F80-" + mpsqlex.getCursorCode());
                if (refTag.getName().equals(sfseg)) {
                    int begin = tagSSnn.getBeginIndex();
                    tag = genInfoBuilder.addTag(begin, begin, ssfct, sfseg);
                } else {
                    tag = genInfoBuilder.addTagAfter(ssfct, refTag.getName());
                }
            } else {
                tag = mpsqlex.isBeforeStandardAccess() ? genInfoBuilder.addTagBefore(ssfct, mpsqlex.getFirstStandardAccess()) : genInfoBuilder.addTagAfter(ssfct, mpsqlex.getLastStandardAccess());
            }
            tag.setProperty("level", "10");
        }
    }

    public static IBuilderTag searchSubFunctionFromF80(IBuilderTag startTag, String tagName, String start) {
        IBuilderTag currentTag = startTag.firstSon();
        IBuilderTag result = startTag;
        String currentFct = null;
        while (currentTag != null) {
            currentFct = currentTag.getName();
            if (currentFct.equals("F80-HELP") || currentFct.equals("F80-LE00") || currentFct.equals("F80-EM00") || currentFct.equals("F80-OKKO")) {
                return result;
            }
            if (currentFct.startsWith(start) && Ebcdic.stringCompare(currentFct, tagName) > 0) {
                return currentTag;
            }
            result = currentTag;
            currentTag = currentTag.nextTag();
        }
        return result;
    }

    public static IBuilderTag searchSubFunctionFromF80(IBuilderTag startTag, String nn) {
        IBuilderTag currentTag = startTag.firstSon();
        IBuilderTag result = startTag;
        String currentFct = null;
        boolean found = false;
        boolean afterF80 = false;
        IBuilderTag tagToReturnAtEnd = null;
        while (!found && currentTag != null) {
            currentFct = currentTag.getName();
            if (currentTag.getProperty("MP_XNN_Ref") == null) {
                if (currentFct.equals("F80-HELP") || currentFct.equals("F80-LE00") || currentFct.equals("F80-EM00") || currentFct.equals("F80-OKKO")) {
                    if (tagToReturnAtEnd != null) {
                        return tagToReturnAtEnd;
                    }
                    return result;
                }
                if (currentFct.charAt(0) == 'F') {
                    String currentNN = SQLAndF80Utilities.getNNforTag(currentTag);
                    if (currentNN.equals("00")) {
                        if (tagToReturnAtEnd == null && "ZZ".equals(currentTag.getProperty(FILE_RANK_PROPERTY))) {
                            tagToReturnAtEnd = result;
                        } else if (tagToReturnAtEnd == null && currentFct.equals("F80-ER")) {
                            tagToReturnAtEnd = result;
                        }
                    } else {
                        if (nn != null) {
                            boolean bl = found = Ebcdic.stringCompare(currentNN, nn) > 0;
                        }
                        if (found) {
                            if (tagToReturnAtEnd != null) {
                                return tagToReturnAtEnd;
                            }
                            return result;
                        }
                    }
                }
            }
            result = currentTag = currentTag.nextTag();
            if (currentTag != null || afterF80 || !startTag.nextTag().getName().startsWith("F80")) continue;
            afterF80 = true;
            currentTag = startTag.nextTag();
        }
        if (tagToReturnAtEnd != null) {
            return tagToReturnAtEnd;
        }
        return result;
    }

    public static void writeBeginEnd(AccessGeneratorInfosForSQL accessGenInfos) {
        GeneratorInfosForSQLEntities.MPALine contribution = accessGenInfos.getGenInfos().getMpaline();
        SQLAndF80Utilities.writeExecLine(contribution);
        contribution.append(NEW_LINE);
        contribution.append("           ");
        contribution.append(END);
        contribution.append(NEW_LINE);
    }

    static class Keys {
        String cursorCode;
        String dataElementCode;
        String relationalLabel;
        String hostVar;
        String controlBreak;
        List<String> lsPreviousRelLabel = new ArrayList<String>();
        List<String> lsPreviousHostVar = new ArrayList<String>();

        public Keys(String cursorCode, String dataElementCode) {
            this.cursorCode = cursorCode;
            this.dataElementCode = dataElementCode;
        }

        public String getCursorCode() {
            return this.cursorCode;
        }

        public void setCursorCode(String cursorCode) {
            this.cursorCode = cursorCode;
        }

        public String getDataElementCode() {
            return this.dataElementCode;
        }

        public void setDataElementCode(String dataElementCode) {
            this.dataElementCode = dataElementCode;
        }

        public String getRelationalLabel() {
            return this.relationalLabel;
        }

        public void setRelationalLabel(String relationalLabel) {
            this.relationalLabel = relationalLabel;
        }

        public String getHostVar() {
            return this.hostVar;
        }

        public void setHostVar(String hostVar) {
            this.hostVar = hostVar;
        }

        public String getControlBreak() {
            return this.controlBreak;
        }

        public void setControlBreak(String controlBreak) {
            this.controlBreak = controlBreak;
        }

        public List<String> getLsPreviousRelLabel() {
            return this.lsPreviousRelLabel;
        }

        public void setLsPreviousRelLabel(List<String> lsPreviousRelLabel) {
            this.lsPreviousRelLabel = lsPreviousRelLabel;
        }

        public List<String> getLsPreviousHostVar() {
            return this.lsPreviousHostVar;
        }

        public void setLsPreviousHostVar(List<String> lsPreviousHostVar) {
            this.lsPreviousHostVar = lsPreviousHostVar;
        }
    }
}

