/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.extension.micropattern;

import com.ibm.pdp.engine.IGenInfoBuilder;
import com.ibm.pdp.engine.ITextArtefactLocation;
import com.ibm.pdp.framework.cobol.micropattern.internal.MicroPatternConstants;
import com.ibm.pdp.mdl.kernel.DataAggregate;
import com.ibm.pdp.mdl.kernel.DataComponent;
import com.ibm.pdp.mdl.kernel.DataDefinition;
import com.ibm.pdp.mdl.kernel.DataElement;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.kernel.impl.DataAggregateDescriptionImpl;
import com.ibm.pdp.mdl.kernel.impl.DataAggregateImpl;
import com.ibm.pdp.mdl.kernel.impl.DataCallImpl;
import com.ibm.pdp.mdl.kernel.impl.DataElementDescriptionImpl;
import com.ibm.pdp.mdl.kernel.impl.DataUnionDescriptionImpl;
import com.ibm.pdp.mdl.kernel.impl.FillerImpl;
import com.ibm.pdp.mdl.pacbase.PacDataCall;
import com.ibm.pdp.mdl.pacbase.PacDataCallMore;
import com.ibm.pdp.mdl.pacbase.PacGeneratedLanguageValues;
import com.ibm.pdp.mdl.pacbase.impl.PacDataAggregateImpl;
import com.ibm.pdp.mdl.pacbase.impl.PacDataCallImpl;
import com.ibm.pdp.mdl.pacbase.impl.PacFillerImpl;
import com.ibm.pdp.mdl.pacbase.lal.util.GenerationContext;
import com.ibm.pdp.mdl.pacbase.lal.util.LengthAndPositionVisitor;
import com.ibm.pdp.mdl.pacbase.lal.util.PacbaseLalDescription;
import com.ibm.pdp.pacbase.extension.micropattern.AbstractCommonMicroPatternHandler;
import com.ibm.pdp.pacbase.extension.micropattern.AbstractWLineMicroPatternHandler;
import com.ibm.pdp.pacbase.extension.micropattern.BreakdateFormatter;
import com.ibm.pdp.pacbase.extension.micropattern.WFGenerationContext;
import com.ibm.pdp.pacbase.extension.micropattern.WFGenerationForOrganization;
import com.ibm.pdp.pacbase.extension.micropattern.WFMicroPatternConstants;
import com.ibm.pdp.pacbase.extension.micropattern.WFMicroPatternHandler;
import com.ibm.pdp.pacbase.extension.micropattern.internal.WorkingData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

public class WFSegmentGenerator
implements WFMicroPatternConstants,
MicroPatternConstants {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2016, 2021.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected boolean firstTime = true;
    protected String segmentCode = "";
    private String lastPLDused = "";
    protected DataAggregate dataAggregate = null;
    protected LengthAndPositionVisitor lpv;
    protected GenerationContext generationContext;
    protected ArrayList<PacbaseLalDescription> pldSsc;
    private Map<String, DataComponent> dataCalls;
    private IGenInfoBuilder generatedInfoBuilder;
    private int newLength = 0;
    protected PacbaseLalDescription pldUsedBefore;
    protected int nbDatas = 0;
    protected String pictureS94 = " PICTURE S9(4) ";
    protected String comp = "COMP";
    protected String computational = "COMPUTATIONAL";
    protected ArrayList<StringBuilder> resultDLI;
    protected WFGenerationContext wfCtx;
    WFGenerationForOrganization wfGenOrg;
    private WFMicroPatternHandler handler;
    protected String newLine = "\r\n";

    public WFSegmentGenerator(DataAggregate aDataAggregate, GenerationContext ctx, WFGenerationContext WFctx, WFMicroPatternHandler handler) {
        this.generationContext = ctx;
        this.wfCtx = WFctx;
        this.dataAggregate = aDataAggregate;
        this.handler = handler;
        this.newLine = AbstractCommonMicroPatternHandler.GetProperty_NEW_LINE(this.wfCtx.getMicroPattern().getProcessingContext());
        this.resultDLI = new ArrayList();
        this.lpv = new LengthAndPositionVisitor(null, ctx);
        this.lpv.doSwitch((EObject)this.dataAggregate);
        handler.registerReference((RadicalEntity)this.dataAggregate, this.wfCtx.getMicroPattern().getProcessingContext());
        this.dataCalls = new HashMap<String, DataComponent>();
        this.updateDataCallsMap((DataAggregateDescriptionImpl)this.dataAggregate.getDataDescription());
        this.pldSsc = new ArrayList();
        if (this.wfCtx.getParam_SSC().trim().length() > 0) {
            this.searchAllDatasForSubSchema(this.lpv.getTopParentLal());
        }
        this.initForOrganization(aDataAggregate);
        this.initAccordingToVariant(this.generationContext.getPatternVariant());
    }

    private void searchAllDatasForSubSchema(PacbaseLalDescription lal) {
        for (PacbaseLalDescription child : lal.getChildren()) {
            if (this.isDataInSubSchema(child.getName())) {
                this.pldSsc.add(child);
                continue;
            }
            if (child.getChildren().isEmpty()) continue;
            this.searchAllDatasForSubSchema(child);
        }
    }

    private void initAccordingToVariant(char variant) {
        if (variant == '4') {
            this.pictureS94 = " ";
            this.comp = "COMP-1";
            this.computational = "COMPUTATIONAL-1";
        }
    }

    private void initForOrganization(DataAggregate aDataAggregate) {
        HashMap<String, WFGenerationForOrganization> table;
        if (this.wfCtx.getParam_ORG().trim().length() > 0 && (table = this.extractedWFGenerationContext()) != null && table.containsKey(this.wfCtx.getParam_ORG())) {
            this.wfGenOrg = table.get(this.wfCtx.getParam_ORG());
            this.wfGenOrg.initDataAgregate(aDataAggregate);
        }
    }

    private HashMap<String, WFGenerationForOrganization> extractedWFGenerationContext() {
        return (HashMap)this.wfCtx.getMicroPattern().getProcessingContext().getData("contextGenerationForWF");
    }

    private void updateDataCallsMap(DataAggregateDescriptionImpl dadi) {
        EList datas = dadi.getComponents();
        for (Object obj : datas) {
            if (obj instanceof DataCallImpl) {
                this.searchAllDataCalls(dadi, (DataCallImpl)obj);
                continue;
            }
            if (!(obj instanceof FillerImpl)) continue;
            this.dataCalls.put("FILLER", (DataComponent)((FillerImpl)obj));
        }
    }

    private void searchAllDataCalls(DataAggregateDescriptionImpl dadi, DataCallImpl obj) {
        block9: {
            block7: {
                DataDefinition dd;
                block8: {
                    dd = obj.getDataDefinition();
                    if (dd == null) break block7;
                    if (dd.getDataDescription() == null) break block8;
                    if (this.dataCalls.get(dd.getName()) != null) break block9;
                    this.dataCalls.put(dd.getName(), (DataComponent)obj);
                    if (!(dd.getDataDescription() instanceof DataAggregateDescriptionImpl)) break block9;
                    this.updateDataCallsMap((DataAggregateDescriptionImpl)dd.getDataDescription());
                    break block9;
                }
                this.dataCalls.put(dd.getName(), (DataComponent)obj);
                break block9;
            }
            if (obj.getDataDescription() instanceof DataAggregateDescriptionImpl) {
                dadi = (DataAggregateDescriptionImpl)obj.getDataDescription();
                this.dataCalls.put(dadi.getName(), (DataComponent)obj);
                this.updateDataCallsMap(dadi);
            } else if (obj.getDataDescription() instanceof DataElementDescriptionImpl) {
                this.dataCalls.put(obj.getDataDescription().getName(), (DataComponent)obj);
            } else if (obj.getDataDescription() instanceof DataUnionDescriptionImpl) {
                DataUnionDescriptionImpl du = (DataUnionDescriptionImpl)obj.getDataDescription();
                EList list = du.getRedefines();
                int i = 0;
                while (i < list.size()) {
                    if (list.get(i) instanceof DataCallImpl) {
                        this.searchAllDataCalls(dadi, (DataCallImpl)list.get(i));
                    }
                    ++i;
                }
            }
        }
    }

    private int getDataLength(PacbaseLalDescription pld) {
        if ("E".equals(this.wfCtx.getParam_FOR())) {
            return pld.getInputLength();
        }
        if ("I".equals(this.wfCtx.getParam_FOR())) {
            return pld.getInternalLength();
        }
        if ("S".equals(this.wfCtx.getParam_FOR())) {
            return pld.getOutputLength();
        }
        return 0;
    }

    public int getLength() {
        if (this.wfCtx.getParam_SSC().trim().length() > 0 && this.pldSsc.size() > 0) {
            if ("E".equals(this.wfCtx.getParam_FOR())) {
                return this.lpv.getTopParentLal().calculateTotalInputLength(this.pldSsc, 0, 1);
            }
            if ("I".equals(this.wfCtx.getParam_FOR())) {
                return this.lpv.getTopParentLal().calculateTotalInternalLength(this.pldSsc, 0, 1);
            }
            if ("S".equals(this.wfCtx.getParam_FOR())) {
                return this.lpv.getTopParentLal().calculateTotalOutputLength(this.pldSsc, 0, 1);
            }
        } else {
            if ("E".equals(this.wfCtx.getParam_FOR())) {
                return Integer.parseInt(this.lpv.getTopParentLal().getTotalInputLength());
            }
            if ("I".equals(this.wfCtx.getParam_FOR())) {
                return Integer.parseInt(this.lpv.getTopParentLal().getTotalInternalLength());
            }
            if ("S".equals(this.wfCtx.getParam_FOR())) {
                return Integer.parseInt(this.lpv.getTopParentLal().getTotalOutputLength());
            }
        }
        return 0;
    }

    public int getNewLength() {
        if (this.newLength == 0) {
            this.newLength = this.getLength();
        }
        return this.newLength;
    }

    protected StringBuilder generate(boolean first) {
        StringBuilder result = new StringBuilder();
        this.generateBeforeSegment(result);
        this.generateSegment(result);
        this.generateAfterSegment(result, first);
        return result;
    }

    protected void generateBeforeSegment(StringBuilder result) {
    }

    private void generateSegment(StringBuilder result) {
        result.append((CharSequence)this.generate(this.lpv.getTopParentLal()));
    }

    protected void generateAfterSegment(StringBuilder result, boolean first) {
    }

    protected StringBuilder generate(PacbaseLalDescription pld) {
        if (!(pld.getEntity().getOwner() instanceof DataElement)) {
            this.handler.registerReference(pld.getEntity().getOwner(), this.wfCtx.getMicroPattern().getProcessingContext());
        }
        StringBuilder result = new StringBuilder();
        if (this.firstTime) {
            this.wfCtx.setSegmentEmpty(true);
        } else {
            if (this.wfCtx.getParam_SSC().trim().length() > 0) {
                boolean groupInSsc = true;
                boolean found = false;
                for (PacbaseLalDescription lal : this.pldSsc) {
                    if (!lal.getName().equals(pld.getName())) continue;
                    found = true;
                }
                if (!found && !this.isDataInSubSchema(pld.getName())) {
                    groupInSsc = false;
                    Iterator it = pld.getChildren().iterator();
                    while (it.hasNext()) {
                        if (!this.isDataInSubSchema(((PacbaseLalDescription)it.next()).getName())) continue;
                        groupInSsc = true;
                        break;
                    }
                }
                if (!this.getSortKey(pld.getName()).equals("U") && !groupInSsc) {
                    return result;
                }
            }
            this.wfCtx.setSegmentEmpty(false);
        }
        String pldAtBeginning = "";
        if (this.isDataToGenerate(pld)) {
            StringBuilder sb;
            if (this.wfGenOrg != null) {
                this.wfGenOrg.initPld(pld, this.firstTime, this.segmentCode);
            }
            if (this.firstTime) {
                this.generateFirstLevelOfSegment(pld, result);
            } else {
                StringBuilder lastPLD = new StringBuilder();
                lastPLD.append(this.segmentCode);
                lastPLD.append("-");
                lastPLD.append(pld.getName());
                this.storeWorkingData(pld, lastPLD.toString());
                this.generateDetailSegmentDescription(pld, result, lastPLD.toString());
            }
            pldAtBeginning = this.lastPLDused;
            if (result.toString().trim().length() > 0 && !result.toString().endsWith(this.newLine)) {
                if (result.toString().endsWith(".")) {
                    result.append(this.newLine);
                } else {
                    result.append(".").append(this.newLine);
                }
            }
            if (!this.firstTime) {
                if (this.wfCtx.getParam_ORG().equals("O") || this.wfCtx.getParam_ORG().equals("Q")) {
                    result.append((CharSequence)this.generateSQLVariables(pld));
                } else if (this.wfCtx.getParam_ORG().equals("D")) {
                    this.generateDLIKeysSSA(pld, this.resultDLI);
                }
            } else if (this.wfCtx.getParam_ORG().equals("D") && (sb = this.generateDLISegmentSSA(this.segmentCode, true, "10")).toString().trim().length() > 0) {
                this.locateDLIContributions(sb, String.valueOf(this.segmentCode) + "-SSA");
            }
        }
        this.firstTime = false;
        this.lastPLDused = pld.getName();
        Iterator it = pld.getChildren().iterator();
        while (it.hasNext()) {
            result.append((CharSequence)this.generate((PacbaseLalDescription)it.next()));
        }
        if (this.wfCtx.getParam_ORG().equals("D") && pld.getParent() == null) {
            int i = 0;
            while (i < this.resultDLI.size()) {
                StringBuilder sb = this.resultDLI.get(i);
                if (sb.toString().trim().length() > 0) {
                    String tagName = sb.substring(sb.indexOf("S-") + 2, sb.indexOf("."));
                    this.locateDLIContributions(sb, tagName);
                }
                ++i;
            }
            this.resultDLI = new ArrayList();
        }
        this.lastPLDused = pldAtBeginning;
        return result;
    }

    private void storeWorkingData(PacbaseLalDescription pld, String lastPld) {
        WorkingData currentWD = new WorkingData();
        currentWD.setFormat(this.wfCtx.getParam_FOR());
        currentWD.setEntityName(pld.getName());
        currentWD.setEntity(pld.getEntity().getOwner());
        currentWD.setLabel(lastPld);
        this.handler.storeWorkingData(currentWD, this.wfCtx.getMicroPattern().getProcessingContext());
    }

    private void generateFirstLevelOfSegment(PacbaseLalDescription pld, StringBuilder result) {
        if (this.wfCtx.getParam_DES() == 0) {
            result.append((CharSequence)this.generateSegmentCodeLevel(pld.getLevel()));
            if (this.segmentCode.endsWith("00")) {
                if (this.wfCtx.isMultiSegments()) {
                    if (result.toString().length() > 0) {
                        result.append(".");
                        result.append(this.newLine);
                    }
                    if (this.wfCtx.getDaMaxLength() > 0) {
                        result.append((CharSequence)this.generateSpecificSegment00());
                    }
                }
            } else if (!this.segmentCode.endsWith(this.wfCtx.getFirstSegmentCode()) && result.toString().trim().length() > 0) {
                if (!this.wfCtx.isSegmentInFDClause()) {
                    result.append(this.getRedefinesSegmentLabel());
                    String redefinesEnd = String.valueOf(this.segmentCode.substring(0, this.segmentCode.length() - 2)) + this.wfCtx.getFirstSegmentCode();
                    if (result.toString().length() + redefinesEnd.length() > 70) {
                        result.append(this.newLine);
                        result.append(this.getBlankBeforePictureInRedefines());
                        result.append(redefinesEnd);
                    } else {
                        result.append(redefinesEnd);
                    }
                }
                if (this.wfCtx.getDa00Length() > 0) {
                    result.append(".").append(this.newLine);
                    result.append(this.getFillerComplementLabel());
                    result.append(WFGenerationContext.getNCaractersNumeric(this.wfCtx.getDa00Length(), 5));
                    result.append(")");
                }
            }
        } else if (!(this.wfCtx.getParam_ORG().equals("O") || this.wfCtx.getParam_ORG().equals("Q") || this.wfCtx.getParam_ORG().equals("N"))) {
            if (this.wfCtx.getParam_ORG().equals("G")) {
                if (this.wfCtx.getParam_DES() == 2) {
                    String lgth = Integer.toString(this.getLength());
                    String loztr = "00" + lgth;
                    String loztr1 = "+" + loztr.substring(String.valueOf(lgth).length() - 1);
                    loztr1 = String.valueOf(this.getBlankBeforeValueForG().substring(loztr1.length())) + loztr1;
                    ArrayList datas = pld.getChildren(true);
                    String adrcle = "";
                    String locle = "";
                    PacbaseLalDescription pldChild = this.searchKeyChild(datas);
                    if (pldChild != null) {
                        int adress = pldChild.getInternalAddress();
                        adrcle = "00" + adress;
                        adrcle = "+" + adrcle.substring(String.valueOf(adress).length() - 1);
                        adrcle = String.valueOf(this.getBlankBeforeValueForG().substring(adrcle.length())) + adrcle;
                        int lgthKey = 0;
                        if ("E".equals(this.wfCtx.getParam_FOR())) {
                            lgthKey = pldChild.getInputLength();
                        } else if ("I".equals(this.wfCtx.getParam_FOR())) {
                            lgthKey = pldChild.getInternalLength();
                        } else if ("S".equals(this.wfCtx.getParam_FOR())) {
                            lgthKey = pldChild.getOutputLength();
                        }
                        locle = "00" + lgthKey;
                        locle = "+" + locle.substring(String.valueOf(lgthKey).length() - 1);
                        locle = String.valueOf(this.getBlankBeforeValueForG().substring(locle.length())) + locle;
                    }
                    String nutab = "";
                    EList extensions = this.dataAggregate.getExtensions();
                    for (Object ext : extensions) {
                        if (!(ext instanceof PacDataAggregateImpl)) continue;
                        String blank = "      ";
                        String structureCode = ((PacDataAggregateImpl)ext).getStructureCodeValue();
                        structureCode = structureCode.length() > 6 ? structureCode.substring(0, 6) : structureCode;
                        nutab = String.valueOf(this.generationContext.getAlphanumericDelimiter()) + structureCode + blank.substring(structureCode.length()) + this.generationContext.getAlphanumericDelimiter();
                        break;
                    }
                    String s = this.getCommonDataForOrganizationGWithValues(pldChild != null, WFGenerationContext.getNCaractersNumeric(this.wfCtx.getParam_LEV(), 2)).replaceAll("COSEGCORUB", "G-" + this.segmentCode);
                    String s1 = s.replace("PPP-LOZTR", loztr1).replace("PPP-ADRCLE", adrcle).replace("PPP-LOCLE", locle).replace("PPP-NUTAB", nutab);
                    result.append(s1);
                } else {
                    result.append(this.getCommonDataForOrganizationG(WFGenerationContext.getNCaractersNumeric(this.wfCtx.getParam_LEV(), 2)).replaceAll("COSEGCORUB", "G-" + this.segmentCode));
                }
            }
            if (this.wfCtx.getParam_LEV() <= 3 || this.wfCtx.getParam_ORG().equals("G")) {
                StringBuilder workData = new StringBuilder();
                workData.append((CharSequence)this.wfCtx.getBeginningOfTheLine(pld.getLevel(), this.firstTime, this.segmentCode.endsWith("00"), false));
                workData.append(this.segmentCode);
                if ((this.wfCtx.getParam_LEV() == 2 || this.wfCtx.getParam_LEV() == 3) && this.segmentCode.endsWith("00")) {
                    if (this.is00PartGenerate()) {
                        workData.append("-00");
                    } else {
                        workData = new StringBuilder();
                    }
                }
                result.append((CharSequence)workData);
            }
            if (!(pld.getOccurs() <= 0 || this.wfCtx.getFirstSegment().length() != 0 && this.wfCtx.getFirstSegment().equals(this.segmentCode))) {
                result.append((CharSequence)this.generateOccursClauseForSegment(pld));
            }
            if (result.toString().trim().length() > 0) {
                result.append(".").append(this.newLine);
            }
        }
    }

    private void generateDetailSegmentDescription(PacbaseLalDescription pld, StringBuilder result, String lastPLD) {
        boolean isDateToDescribe;
        int level = pld.getLevel();
        if ((this.wfCtx.getParam_ORG().equals("2") || this.wfCtx.getParam_ORG().equals("Q") || this.wfCtx.getParam_ORG().equals("N") || this.wfCtx.getParam_ORG().equals("H")) && this.isDataWithVariableLength(pld)) {
            result.append((CharSequence)this.wfCtx.getBeginningOfTheLine(level, this.firstTime, this.segmentCode.endsWith("00"), true));
            result.replace(result.length() - 1, result.length(), "V");
            result.append(this.segmentCode);
            result.append("-");
            result.append(pld.getName()).append(".");
            result.append(this.newLine);
            level = 49;
            result.append((CharSequence)this.wfCtx.getBeginningOfTheLine(level, this.firstTime, this.segmentCode.endsWith("00"), true));
            result.replace(result.length() - 1, result.length(), this.wfCtx.getDB2KeyPrefix());
            result.append(this.segmentCode);
            result.append("-");
            result.append(pld.getName().trim());
            result.append(" ").append(this.pictureS94).append(this.getSQLComplement()).append(".");
            result.append(this.newLine);
            level = 49;
        }
        result.append((CharSequence)this.wfCtx.getBeginningOfTheLine(level, this.firstTime, this.segmentCode.endsWith("00"), false));
        result.append(lastPLD);
        StringBuilder suite = new StringBuilder("");
        boolean bl = isDateToDescribe = this.handler.isDate(pld, this.wfCtx.getParam_FOR()) && this.wfCtx.isBreakdateOption();
        if (pld.getRedefines()) {
            result.append(this.newLine);
            result.append(this.wfCtx.getBlankBeforeLabel());
            result.append(this.getRedefinesDataLabel());
            result.append(this.lastPLDused);
            suite.append((CharSequence)this.generateOccursClauseForData(pld));
            if (!isDateToDescribe && (pld.getChildren().isEmpty() || this.wfCtx.getParam_LEV() > 5)) {
                result.append(this.newLine);
            }
        } else {
            this.handler.registerReference(pld.getEntity().getOwner(), this.wfCtx.getMicroPattern().getProcessingContext());
            this.lastPLDused = lastPLD;
            suite.append((CharSequence)this.generateOccursAndValues(pld));
        }
        StringBuilder content = new StringBuilder("");
        if (isDateToDescribe) {
            content.append((CharSequence)result);
            content.append((CharSequence)suite);
            result.delete(0, result.length());
            suite = new StringBuilder("");
        }
        String picture = this.getPicture(pld, content.toString());
        StringBuilder pic = new StringBuilder();
        if (this.isElementaryData(pld)) {
            String line;
            if (pld.getRedefines() && !isDateToDescribe) {
                if (picture.trim().length() > 0) {
                    pic.append(this.getBlankBeforePictureInRedefines());
                    pic.append(this.getPictureLabel());
                    pic.append(this.getBlankAfterPicture());
                }
            } else if (!picture.contains(this.newLine)) {
                pic.append("      ".substring(pld.getName().length() - 1));
                if (picture.trim().length() > 0) {
                    pic.append(this.getPictureLabel());
                }
            }
            if ((line = result.toString()).contains(this.newLine)) {
                int ind = line.lastIndexOf(this.newLine);
                line = line.substring(ind + this.newLine.length());
            }
            int lg = picture.length();
            if (picture.contains(this.newLine)) {
                lg = picture.substring(0, picture.indexOf(this.newLine)).length();
            }
            if (line.length() + pic.length() + lg > 70) {
                result.append(this.newLine);
                result.append(this.getBlankBeforePictureInRedefines());
                result.append(pic.toString().trim()).append("  ").append(picture);
            } else {
                result.append((CharSequence)pic).append(picture);
            }
        }
        if (suite.toString().trim().length() > 0 && this.isValueGeneratedInFirstPosition()) {
            result.append((CharSequence)suite);
            suite = new StringBuilder();
        }
        if (this.wfCtx.getParam_DES() != 2 || pld.getRedefines() || !this.isValueToGenerate(pld)) {
            String currentComment = this.getComments(pld);
            if ("I".equals(this.wfCtx.getParam_FOR()) && currentComment.length() > 0) {
                result.append(this.newLine);
                result.append(this.wfCtx.getBlankBeforeLabel());
                result.append(currentComment);
            } else if ("S".equals(this.wfCtx.getParam_FOR()) && pld.isBlankWhenZero(this.generationContext)) {
                result.append(this.newLine);
                result.append(this.wfCtx.getBlankBeforeLabel());
                result.append("BLANK WHEN ZERO");
            }
        }
        if (this.wfCtx.getParam_ORG().equals("P") && this.isDataWithVariableLength(pld)) {
            result.append(this.newLine);
            result.append("                          VARYING");
        }
        if (suite.toString().trim().length() > 0) {
            result.append((CharSequence)suite);
        }
    }

    protected String getSegmentName(String segmentCode) {
        Iterator it = this.dataAggregate.getExtensions().iterator();
        String segnam = "";
        while (it.hasNext()) {
            Object obj = it.next();
            if (!(obj instanceof PacDataAggregateImpl)) continue;
            PacDataAggregateImpl pdai = (PacDataAggregateImpl)obj;
            if (this.dataAggregate.getName().endsWith("00")) {
                segnam = pdai.getStructureCode();
                break;
            }
            segnam = ((PacDataAggregateImpl)obj).getStructureCodeValue();
            break;
        }
        return segnam;
    }

    private PacbaseLalDescription searchKeyChild(ArrayList<PacbaseLalDescription> datas) {
        PacbaseLalDescription pldChild = null;
        int i = 0;
        while (i < datas.size()) {
            pldChild = datas.get(i);
            String name = pldChild.getName();
            if (this.dataCalls.get(name) instanceof DataCallImpl) {
                for (Object ext : ((DataCallImpl)this.dataCalls.get(name)).getExtensions()) {
                    String key;
                    if (!(ext instanceof PacDataCallImpl) || !(key = ((PacDataCallImpl)ext).getSortKey()).equals("U")) continue;
                    return pldChild;
                }
            }
            if (!pldChild.getChildren(true).isEmpty() && (pldChild = this.searchKeyChild(pldChild.getChildren(true))) != null) {
                return pldChild;
            }
            ++i;
        }
        return null;
    }

    protected void locateDLIContributions(StringBuilder sb, String tagName) {
    }

    protected ITextArtefactLocation getLocationForDLI() {
        return null;
    }

    protected boolean isOneLineForSSA() {
        return false;
    }

    protected StringBuilder generateDLISegmentSSA(String segmentCode, boolean isSegment, String level) {
        String segnam = this.getSegmentName(segmentCode);
        StringBuilder result = new StringBuilder();
        result.append("       01                ");
        result.append("S-").append(segmentCode);
        result.append("-SSA.");
        result.append(this.newLine);
        result.append("            ").append(level).append("            ");
        if (this.isOneLineForSSA()) {
            result.append("S1-").append(segmentCode).append("-SEGNAM PICTURE X(8) VALUE ");
            result.append(this.newLine).append("                                        ");
        } else {
            result.append("S1-").append(segmentCode).append("-SEGNAM PICTURE X(8)");
            result.append(this.newLine);
            result.append("                                       VALUE ");
        }
        segnam = AbstractCommonMicroPatternHandler.replaceAlphanumericDelimiter(segnam, this.generationContext.getAlphanumericDelimiter());
        result.append(segnam.trim()).append(".");
        result.append(this.newLine);
        result.append("            ").append(level).append("            ");
        result.append("S1-").append(segmentCode).append("-CCOM   PICTURE X VALUE ").append(this.generationContext.getAlphanumericDelimiter()).append("*").append(this.generationContext.getAlphanumericDelimiter()).append(".");
        result.append(this.newLine);
        result.append("            ").append(level).append("            ");
        if (this.isOneLineForSSA()) {
            result.append("S-").append(segmentCode).append("-CCOD   PICTURE X(5) VALUE ");
        } else {
            result.append("S-").append(segmentCode).append("-CCOD   PICTURE X(5)");
            result.append(this.newLine);
            result.append("                                       VALUE ");
        }
        result.append(this.generationContext.getAlphanumericDelimiter()).append("-----").append(this.generationContext.getAlphanumericDelimiter()).append(".");
        result.append(this.newLine);
        if (isSegment) {
            result.append("            ").append(level).append("  FILLER   PICTURE X    VALUE SPACE.");
            result.append(this.newLine);
        }
        return result;
    }

    protected void generateDLIKeysSSA(PacbaseLalDescription pld, ArrayList<StringBuilder> resultDLI) {
    }

    protected int getIndexForSsaTable(ArrayList<StringBuilder> resultDLI, String newSegmentCode) {
        int i = 0;
        while (i < resultDLI.size()) {
            StringBuilder text = resultDLI.get(i);
            if (text.length() > 0) {
                String ident = text.substring(text.indexOf("S-") + 2);
                if ((ident = ident.substring(0, ident.indexOf("-SSA"))).equals(newSegmentCode)) {
                    return i;
                }
            }
            ++i;
        }
        return -1;
    }

    public StringBuilder generateSQLGlobalVariables() {
        StringBuilder result = new StringBuilder();
        return result;
    }

    public StringBuilder generateSpecificDesc() {
        StringBuilder result = new StringBuilder();
        this.firstTime = true;
        result.append((CharSequence)this.generateSpecificDesc(this.lpv.getTopParentLal()));
        return result;
    }

    protected StringBuilder generateSpecificDesc(PacbaseLalDescription pld) {
        StringBuilder result = new StringBuilder();
        if (this.isDataToGenerate(pld)) {
            StringBuilder temp;
            String segmentCodeWithoutPrefix = this.segmentCode;
            if (this.wfCtx.getParam_PFX() != null && !"".equals(this.wfCtx.getParam_PFX())) {
                segmentCodeWithoutPrefix = segmentCodeWithoutPrefix.substring(this.wfCtx.getParam_PFX().length());
            }
            if (this.wfCtx.getParam_SIP() != null && !"".equals(this.wfCtx.getParam_SIP()) && this.wfCtx.getParam_SIP().length() <= 10) {
                segmentCodeWithoutPrefix = this.wfCtx.getParam_SIP();
            }
            if (this.firstTime) {
                temp = this.wfCtx.getBeginningOfTheLine(pld.getLevel(), this.firstTime, this.segmentCode.endsWith("00"), false);
                if (this.wfCtx.getParam_ORG().equals("2")) {
                    result.append(temp.substring(0, temp.length()));
                } else {
                    result.append(temp.substring(0, temp.length() - 1));
                }
                result.append("V").append(this.wfCtx.getSQLSegmentPrefixDash());
                result.append(segmentCodeWithoutPrefix).append(".");
                result.append(this.newLine);
            } else if ((!this.segmentCode.endsWith("00") && this.isDataInSubSchema(pld.getName()) || this.segmentCode.endsWith("00")) && pld.getChildren().size() == 0 && !pld.getRedefines()) {
                ++this.nbDatas;
                temp = this.wfCtx.getBeginningOfTheLine(pld.getLevel(), this.firstTime, this.segmentCode.endsWith("00"), false);
                if (this.wfCtx.getParam_ORG().equals("2")) {
                    result.append(temp.substring(0, temp.length()));
                } else {
                    result.append(temp.substring(0, temp.length() - 1));
                }
                result.append("V").append(this.wfCtx.getSQLSegmentPrefixDash());
                result.append(segmentCodeWithoutPrefix).append(this.wfCtx.getSQLSegmentPrefixDash());
                result.append(pld.getName());
                result.append("      ".substring(pld.getName().length() - 1));
                result.append(" ").append(this.pictureS94).append(String.valueOf(this.getSQLComplement()) + ".");
                result.append(this.newLine);
            }
        }
        this.firstTime = false;
        Iterator it = pld.getChildren().iterator();
        while (it.hasNext()) {
            result.append((CharSequence)this.generateSpecificDesc((PacbaseLalDescription)it.next()));
        }
        return result;
    }

    protected String getSQLComplement() {
        return this.comp;
    }

    protected String getSegmentCode() {
        return this.segmentCode;
    }

    protected boolean isDataToGenerate(PacbaseLalDescription pld) {
        if (!this.firstTime && this.dataAggregate.equals(pld.getEntity())) {
            return false;
        }
        if (this.pldUsedBefore != null && !this.firstTime && !pld.getName().equals("FILLER") && this.pldUsedBefore.getParent() != null && pld.getName().equals(this.pldUsedBefore.getName())) {
            return false;
        }
        if ((this.wfCtx.getParam_ORG().equals("P") || this.wfCtx.getParam_ORG().equals("9") || this.wfCtx.getParam_ORG().equals("M") || this.wfCtx.getParam_ORG().equals("Q") || this.wfCtx.getParam_ORG().equals("N")) && !this.firstTime && !pld.getChildren().isEmpty()) {
            return false;
        }
        if (this.wfCtx.getParam_ORG().equals("2") && !this.wfCtx.isDescrAllOption() && (!this.firstTime && !pld.getChildren().isEmpty() || pld.getRedefines() || this.isDataInRedefines(pld))) {
            return false;
        }
        if (this.wfCtx.isGlobalContrib() && this.wfCtx.getParam_ORG().trim().length() == 0) {
            return false;
        }
        if (this.firstTime && !pld.getName().endsWith("00") && this.wfCtx.isExisting00() && this.wfCtx.getParam_SEL().contains("=00") && this.wfCtx.getDa00Length() > 0) {
            int index = this.wfCtx.getParam_SEL().indexOf("=00");
            String segment = this.wfCtx.getParam_SEL().substring(index - 2, index);
            if (segment.equals(this.dataAggregate.getName().substring(2, 4))) {
                return false;
            }
        }
        if (!this.firstTime && pld.getEntity() instanceof DataAggregateImpl && this.segmentCode.endsWith("00")) {
            return false;
        }
        this.pldUsedBefore = pld;
        return true;
    }

    protected boolean is00PartGenerate() {
        return false;
    }

    protected boolean isAnOccursData(PacbaseLalDescription pld) {
        PacbaseLalDescription pldParent = pld;
        while (pldParent != null) {
            if (pldParent.getOccurs() > 0) {
                return true;
            }
            pldParent = pldParent.getParent();
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isDataInSubSchema(String name) {
        if (this.wfCtx.getParam_SSC().trim().length() <= 0) return true;
        DataComponent dc = this.dataCalls.get(name);
        List lines = null;
        if (dc == null) return false;
        EList ext = dc.getExtensions();
        for (Object object : ext) {
            if (object instanceof PacDataCall) {
                lines = ((PacDataCall)object).getMoreLines();
                break;
            }
            if (!(object instanceof PacFillerImpl)) continue;
            lines = ((PacFillerImpl)object).getMoreLines();
            break;
        }
        PacDataCallMore pdcm = null;
        if (lines != null) {
            for (Object object : lines) {
                if (!(object instanceof PacDataCallMore)) continue;
                pdcm = (PacDataCallMore)object;
                break;
            }
        }
        if (pdcm == null) return false;
        String values = pdcm.getControlValue();
        int ssc = 0;
        try {
            ssc = Integer.parseInt(this.wfCtx.getParam_SSC());
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        if (values.isEmpty()) {
            return false;
        }
        if (--ssc > values.length() - 1) {
            return false;
        }
        if (values.charAt(ssc) == 'O') return true;
        return false;
    }

    protected boolean isDataWithVariableLength(PacbaseLalDescription pld) {
        String key = this.getSortKey(pld.getName());
        return key.equals("W") || key.equals("V") || key.equals("L");
    }

    protected boolean isElementaryData(PacbaseLalDescription pld) {
        return pld.getChildren().isEmpty() && !(pld.getEntity() instanceof DataAggregateDescriptionImpl);
    }

    protected String getSortKey(String name) {
        String key = "";
        if (this.dataCalls.containsKey(name)) {
            EList extensions = this.dataCalls.get(name).getExtensions();
            for (Object ext : extensions) {
                if (!(ext instanceof PacDataCallImpl)) continue;
                key = ((PacDataCallImpl)ext).getSortKey();
                break;
            }
        }
        return key;
    }

    protected boolean isOccursGeneratedWithTimesClause() {
        return true;
    }

    protected boolean isValueGeneratedInFirstPosition() {
        return true;
    }

    protected String getFldName(String name) {
        String fldnam = name;
        if (this.dataCalls.containsKey(name)) {
            EList extensions = this.dataCalls.get(name).getExtensions();
            block0: for (Object ext : extensions) {
                if (!(ext instanceof PacDataCallImpl)) continue;
                EList complements = ((PacDataCallImpl)ext).getMoreLines();
                for (Object compl : complements) {
                    String updateTarget;
                    if (!(compl instanceof PacDataCallMore) || (updateTarget = ((PacDataCallMore)compl).getUpdateTarget().trim()).length() <= 3 || !updateTarget.startsWith("A*")) continue;
                    fldnam = updateTarget.substring(2, updateTarget.length());
                    continue block0;
                }
            }
        }
        return fldnam;
    }

    protected boolean isValueToGenerate(PacbaseLalDescription pld) {
        return pld.getParent() == null || !this.isDataInRedefines(pld);
    }

    protected StringBuilder generateOccursAndValues(PacbaseLalDescription pld) {
        StringBuilder result = new StringBuilder();
        result.append((CharSequence)this.generateOccursClauseForData(pld));
        result.append((CharSequence)this.generateValueClause(pld));
        return result;
    }

    protected StringBuilder generateOccursClauseForData(PacbaseLalDescription pld) {
        return this.generateOccursClauseForData(pld, false);
    }

    protected StringBuilder generateOccursClauseForData(PacbaseLalDescription pld, boolean condOK) {
        StringBuilder result = new StringBuilder();
        if (pld.getOccurs() > 0) {
            String depends = "";
            if (condOK) {
                DataComponent dc = this.dataCalls.get(pld.getName());
                List lines = null;
                if (dc != null) {
                    EList ext = dc.getExtensions();
                    for (Object object : ext) {
                        if (object instanceof PacDataCall) {
                            lines = ((PacDataCall)object).getMoreLines();
                            break;
                        }
                        if (!(object instanceof PacFillerImpl)) continue;
                        lines = ((PacFillerImpl)object).getMoreLines();
                        break;
                    }
                    PacDataCallMore pdcm = null;
                    if (lines != null) {
                        for (Object object : lines) {
                            if (!(object instanceof PacDataCallMore)) continue;
                            pdcm = (PacDataCallMore)object;
                            depends = pdcm.getUpdateTarget();
                            break;
                        }
                    }
                }
            }
            result.append(this.newLine);
            result.append(this.wfCtx.getBlankBeforeLabel());
            if (depends.trim().length() > 0 && depends.startsWith("**")) {
                result.append("OCCURS 0 TO  ");
                result.append(WFGenerationContext.getNCaractersNumeric(pld.getOccurs(), 3));
                if (this.isOccursGeneratedWithTimesClause()) {
                    result.append("     TIMES");
                }
                result.append(this.newLine);
                result.append(this.wfCtx.getBlankBeforeLabel());
                result.append("DEPENDING  ON        ");
                depends = depends.replace("**", this.segmentCode.substring(0, this.segmentCode.length() - 2));
                if (depends.length() > this.segmentCode.length()) {
                    depends = String.valueOf(depends.substring(0, this.segmentCode.length())) + "-" + depends.substring(this.segmentCode.length(), depends.length());
                }
                result.append(depends);
            } else {
                result.append(this.getOccursLabel());
                result.append(WFGenerationContext.getNCaractersNumeric(pld.getOccurs(), 3));
                if (this.isOccursGeneratedWithTimesClause()) {
                    result.append("     TIMES");
                }
            }
        }
        return result;
    }

    protected StringBuilder generateOccursClauseForSegment(PacbaseLalDescription pld) {
        StringBuilder result = new StringBuilder();
        if (this.wfCtx.getParam_DES() >= 3) {
            if (this.wfCtx.getParam_LEV() > 3) {
                result.append((CharSequence)this.wfCtx.getBeginningOfTheLine(pld.getLevel(), this.firstTime, this.segmentCode.endsWith("00"), false));
                result.append(this.segmentCode);
            }
            result.append(this.getOccursLabelForSegment());
            result.append(WFGenerationContext.getNCaractersNumeric(pld.getOccurs(), 4));
        }
        return result;
    }

    protected StringBuilder generateValueClause(PacbaseLalDescription pld) {
        StringBuilder result = new StringBuilder();
        if (this.isValueToGenerate(pld)) {
            String currentComment = AbstractWLineMicroPatternHandler.GetComments(pld, this.generationContext, this.wfCtx.getParam_FOR());
            boolean isGeneratedValue = true;
            if (this.generationContext.getGeneratedLanguage() == PacGeneratedLanguageValues._C_LITERAL) {
                PacbaseLalDescription lal = pld;
                while (lal != null) {
                    if (lal.getOccurs() > 0) {
                        isGeneratedValue = false;
                    }
                    lal = lal.getParent();
                }
            }
            if (this.wfCtx.getParam_DES() == 2 && this.isElementaryData(pld)) {
                if (this.isValueGeneratedInFirstPosition()) {
                    if (isGeneratedValue) {
                        result.append(this.newLine);
                        result.append(this.wfCtx.getBlankBeforeLabel());
                        result.append(this.getValueLabel());
                    }
                    String value = this.getValue(pld);
                    if ("I".equals(this.wfCtx.getParam_FOR()) && currentComment.length() > 0) {
                        if (isGeneratedValue) {
                            result.append(value);
                        }
                        result.append(this.newLine);
                        result.append(this.wfCtx.getBlankBeforeLabel());
                        result.append(currentComment);
                    } else if ("S".equals(this.wfCtx.getParam_FOR()) && pld.isBlankWhenZero(this.generationContext)) {
                        if (isGeneratedValue) {
                            value = value.replace("SPACE", "ZERO");
                            result.append(value);
                        }
                        result.append(this.newLine);
                        result.append(this.wfCtx.getBlankBeforeLabel());
                        result.append("BLANK WHEN ZERO");
                    } else if (isGeneratedValue) {
                        result.append(value);
                    }
                } else {
                    if ("I".equals(this.wfCtx.getParam_FOR()) && currentComment.length() > 0) {
                        result.append(this.newLine);
                        result.append(this.wfCtx.getBlankBeforeLabel());
                        result.append(currentComment);
                    } else if ("S".equals(this.wfCtx.getParam_FOR()) && pld.isBlankWhenZero(this.generationContext)) {
                        result.append(this.newLine);
                        result.append(this.wfCtx.getBlankBeforeLabel());
                        result.append("BLANK WHEN ZERO");
                    }
                    if (isGeneratedValue) {
                        result.append(this.newLine);
                        result.append(this.wfCtx.getBlankBeforeLabel());
                        result.append(this.getValueLabel());
                        result.append(this.getValue(pld));
                    }
                }
            }
        }
        return result;
    }

    protected StringBuilder generateSegmentCodeLevel(int level) {
        StringBuilder result = new StringBuilder();
        return result;
    }

    protected StringBuilder generateSpecificSegment00() {
        StringBuilder result = new StringBuilder();
        return result;
    }

    protected StringBuilder generateSQLVariables(PacbaseLalDescription pld) {
        StringBuilder sb = new StringBuilder();
        sb.append("       01               ");
        sb.append("V").append(this.wfCtx.getSQLSegmentPrefixDash());
        sb.append(this.segmentCode).append(this.wfCtx.getSQLSegmentPrefixDash());
        sb.append(pld.getName());
        sb.append(this.pictureS94).append(this.getSQLComplement()).append(".").append(this.newLine);
        return sb;
    }

    protected String getCommonDataForOrganizationG(String level) {
        return "";
    }

    protected String getComments(PacbaseLalDescription pld) {
        return AbstractWLineMicroPatternHandler.GetComments(pld, this.generationContext, this.wfCtx.getParam_FOR());
    }

    protected String getCommonDataForOrganizationGWithValues(boolean keFound, String level) {
        return "";
    }

    protected String getFillerComplementLabel() {
        return "            10       FILLER         PICTURE  X(";
    }

    protected IGenInfoBuilder getGeneratedInfoBuilder() {
        return this.generatedInfoBuilder;
    }

    protected String getOccursLabel() {
        return "OCCURS       ";
    }

    protected String getOccursLabelForSegment() {
        return " OCCURS                ";
    }

    protected String getPicture(PacbaseLalDescription pld, String content) {
        if (pld.isDate(this.wfCtx.getParam_FOR())) {
            if (this.wfCtx.isBreakdateOption() && this.handler.isDate(pld, this.wfCtx.getParam_FOR())) {
                String typeDate = "";
                if ("E".equals(this.wfCtx.getParam_FOR())) {
                    typeDate = pld.getInputFormat();
                } else if ("I".equals(this.wfCtx.getParam_FOR())) {
                    typeDate = pld.getInternalFormat();
                } else if ("S".equals(this.wfCtx.getParam_FOR())) {
                    typeDate = pld.getOutputFormat();
                }
                String textBefore = "";
                StringBuilder textAfter = new StringBuilder();
                String name = pld.getName().trim();
                if (content.length() > 0) {
                    int index = content.indexOf(name);
                    textBefore = content.substring(0, index);
                    textAfter.append(content.substring(index + name.length()));
                }
                StringBuilder sb = new StringBuilder();
                if (this.wfCtx.getParam_ORG().equals("2")) {
                    if (pld.getRedefines()) {
                        textAfter.append(this.newLine);
                        int i = 0;
                        while (i < 15) {
                            textAfter.append(" ");
                            ++i;
                        }
                    } else {
                        int i = name.length();
                        while (i < 6) {
                            textAfter.append(" ");
                            ++i;
                        }
                    }
                    textAfter.append(" PICTURE X(");
                    textAfter.append(this.getDataLength(pld));
                    textAfter.append(").");
                    textAfter.append(this.newLine);
                    textAfter.append(String.valueOf(textBefore) + name);
                    textAfter.append("-BRK REDEFINES ");
                    textAfter.append(this.segmentCode).append("-").append(name);
                }
                sb.append((CharSequence)BreakdateFormatter.GenerateBreakdate(textBefore, name, typeDate, textAfter.toString(), this.wfCtx.getGeneratedDateFormat().toString().substring(1), this.wfCtx, this.segmentCode, this.newLine));
                return sb.toString();
            }
            StringBuilder sb = new StringBuilder("X(");
            sb.append(this.getDataLength(pld));
            sb.append(")");
            return sb.toString();
        }
        String tmp = pld.getFormat(this.wfCtx.getParam_FOR());
        if (this.wfCtx.getParam_FOR().equals("I") && !pld.isPictureNeeded()) {
            tmp = "";
        } else {
            if (tmp.trim().length() == 0) {
                if (!this.wfCtx.getParam_FOR().equals("I")) {
                    tmp = pld.getFormat("I");
                }
                if (tmp.trim().length() == 0) {
                    int lgth = 0;
                    if ("E".equals(this.wfCtx.getParam_FOR())) {
                        lgth = pld.getInputLength();
                    } else if ("I".equals(this.wfCtx.getParam_FOR())) {
                        lgth = pld.getInternalLength();
                    } else if ("S".equals(this.wfCtx.getParam_FOR())) {
                        lgth = pld.getOutputLength();
                    }
                    String format = "0000" + lgth;
                    tmp = "X(" + format.substring(String.valueOf(lgth).length() - 1) + ")";
                }
            }
            if ("I".equals(this.wfCtx.getParam_FOR()) && !(tmp = AbstractCommonMicroPatternHandler.GetRealFormat(pld, tmp)).startsWith("S") && this.isSignNeededBeforePicture(this.wfCtx.getParam_ORG(), pld.getUsageAfterConversion())) {
                tmp = "S" + tmp;
            }
            if ("E".equals(this.wfCtx.getParam_FOR()) || "I".equals(this.wfCtx.getParam_FOR())) {
                tmp = AbstractCommonMicroPatternHandler.TransformFormat(tmp);
            }
        }
        return tmp;
    }

    private boolean isSignNeededBeforePicture(String org, String usage) {
        return this.getValuesToGenerateSign() != null && this.getValuesToGenerateSign().contains(String.valueOf(org) + usage);
    }

    protected Set<String> getValuesToGenerateSign() {
        return null;
    }

    protected String getPictureLabel() {
        return "PICTURE  ";
    }

    protected String getRedefinesDataLabel() {
        return "REDEFINES            ";
    }

    protected String getRedefinesSegmentLabel() {
        return "  REDEFINES      ";
    }

    protected String getValue(PacbaseLalDescription pld) {
        return pld.getDefaultValue(this.wfCtx.getParam_FOR());
    }

    protected String getValueLabel() {
        return "VALUE                ";
    }

    protected boolean isDataInRedefines(PacbaseLalDescription pld) {
        if (pld.getParent() != null && pld.getParent().getRedefines()) {
            return true;
        }
        if (pld.getParent() != null) {
            return this.isDataInRedefines(pld.getParent());
        }
        return false;
    }

    protected String getBlankAfterPicture() {
        return "  ";
    }

    protected String getBlankBeforeValueForG() {
        return "         ";
    }

    protected String getBlankBeforePictureInRedefines() {
        return "              ";
    }

    public void setGeneratedInfoBuilder(IGenInfoBuilder iGenInfoBuilder) {
        this.generatedInfoBuilder = iGenInfoBuilder;
    }

    public void setIsFirstTimeInSegment(boolean isFirst) {
        this.firstTime = isFirst;
    }

    public void setNewLength(int length) {
        this.newLength = length;
    }

    public void setSegmentCode(String segCode) {
        this.segmentCode = segCode;
    }
}

