/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.extension.micropattern;

import com.ibm.pdp.engine.IBuilderTag;
import com.ibm.pdp.engine.IGenInfoBuilder;
import com.ibm.pdp.engine.IMicroPattern;
import com.ibm.pdp.engine.ITextArtefactLocation;
import com.ibm.pdp.engine.extension.TextArtefactLocation;
import com.ibm.pdp.framework.PdpTool;
import com.ibm.pdp.framework.cobol.micropattern.internal.MicroPatternConstants;
import com.ibm.pdp.mdl.kernel.DataAggregate;
import com.ibm.pdp.mdl.kernel.DataCall;
import com.ibm.pdp.mdl.kernel.DataUnit;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.pacbase.PacBlockBase;
import com.ibm.pdp.mdl.pacbase.PacBlockBaseTypeValues;
import com.ibm.pdp.mdl.pacbase.PacDataAggregate;
import com.ibm.pdp.mdl.pacbase.PacDialog;
import com.ibm.pdp.mdl.pacbase.PacGLine;
import com.ibm.pdp.mdl.pacbase.PacProgram;
import com.ibm.pdp.mdl.pacbase.PacScreen;
import com.ibm.pdp.mdl.pacbase.impl.PacGLineImpl;
import com.ibm.pdp.mdl.pacbase.lal.util.GenerationContext;
import com.ibm.pdp.mdl.pacbase.util.PacDialogWrapper;
import com.ibm.pdp.mdl.pacbase.util.PacProgramWrapper;
import com.ibm.pdp.mdl.pacbase.util.PacScreenWrapper;
import com.ibm.pdp.mdl.pacbase.util.PacbasePattern;
import com.ibm.pdp.pacbase.extension.Ebcdic;
import com.ibm.pdp.pacbase.extension.micropattern.AbstractCommonMicroPatternHandler;
import com.ibm.pdp.pacbase.extension.micropattern.DescriptionContentAssistMP;
import com.ibm.pdp.pacbase.extension.micropattern.Messages;
import com.ibm.pdp.pacbase.extension.micropattern.WFGenerationContext;
import com.ibm.pdp.pacbase.extension.micropattern.WFGenerationForOrganization;
import com.ibm.pdp.pacbase.extension.micropattern.WFMicroPatternConstants;
import com.ibm.pdp.pacbase.extension.micropattern.WFSegmentGenerator;
import com.ibm.pdp.pacbase.extension.micropattern.internal.SegmentDatasForWF;
import com.ibm.pdp.pacbase.extension.micropattern.internal.SortedWFMicroPattern;
import com.ibm.pdp.pacbase.util.EBCDICCompare;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

public abstract class WFMicroPatternHandler
extends AbstractCommonMicroPatternHandler
implements MicroPatternConstants,
WFMicroPatternConstants {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2021.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static String tempPFX;
    public static String tempSIP;

    @Override
    protected void addOtherFragments(IMicroPattern microPattern, IGenInfoBuilder genInfoBuilder) {
    }

    private void analyzeSelection(WFGenerationContext wfCxt, Map<String, String> dataAggregateMap) {
        this.analyzeSelection(wfCxt.getParam_DSL(), wfCxt.getParam_SEL(), wfCxt.getParam_DSP(), wfCxt.getParam_DSL(), wfCxt.getMicroPattern(), dataAggregateMap);
        if (wfCxt.getParam_SDSEL().trim().length() > 0) {
            String[] sels = wfCxt.getParam_SDSEL().trim().split(",");
            int i = 0;
            while (i < sels.length) {
                String selection = sels[i];
                String DA = selection.substring(0, 2);
                String sel = "";
                if (selection.length() > 2) {
                    sel = selection.substring(2, selection.length());
                }
                this.analyzeSelection(DA, sel, wfCxt.getParam_DSP(), wfCxt.getParam_DSL(), wfCxt.getMicroPattern(), dataAggregateMap);
                ++i;
            }
        }
    }

    private void analyzeSelection(String dsl, String selection, String param_dsp, String param_dsl, IMicroPattern microPattern, Map<String, String> dataAggregateMap) {
        int segSelLength = selection.trim().length();
        boolean da00 = false;
        String originalDAcode = "";
        String inProgramDAcode = "";
        EObject obj = this.searchReference(microPattern);
        if (obj instanceof RadicalEntity) {
            RadicalEntity re = (RadicalEntity)obj;
            String fromProject = re.getProject();
            String packageName = re.getPackage();
            re = selection != null && selection.trim().length() != 0 ? this.searchRadicalEntityWithoutRegisterReference(fromProject, packageName, dsl, "dataunit", microPattern.getProcessingContext()) : this.searchRadicalEntity(fromProject, packageName, dsl, "dataunit", microPattern.getProcessingContext());
            if (re instanceof DataUnit) {
                if (selection != null && selection.trim().length() == 0) {
                    this.registerReference(re, microPattern.getProcessingContext());
                }
                if (segSelLength == 0) {
                    DataUnit du = (DataUnit)re;
                    EList lsLines = du.getComponents();
                    if (lsLines != null) {
                        for (Object object : lsLines) {
                            if (!(object instanceof DataCall)) continue;
                            DataCall dataCall = (DataCall)object;
                            originalDAcode = dataCall.getDataDefinition().getName();
                            inProgramDAcode = String.valueOf(param_dsp) + originalDAcode.substring(2);
                            dataAggregateMap.put(originalDAcode, inProgramDAcode);
                        }
                    }
                } else {
                    int beg = 0;
                    while (beg < segSelLength) {
                        String eachDA = beg + 2 < segSelLength ? selection.substring(beg, beg + 2) : selection.substring(beg, segSelLength);
                        originalDAcode = String.valueOf(dsl) + eachDA;
                        inProgramDAcode = String.valueOf(param_dsp) + eachDA;
                        if (segSelLength > (beg += 2) && selection.charAt(beg) == '=') {
                            if (this.isRenamePossible() && ++beg + 2 <= segSelLength) {
                                eachDA = selection.substring(beg, beg + 2);
                            }
                            inProgramDAcode = String.valueOf(param_dsp) + eachDA;
                            beg += 2;
                        }
                        da00 = da00 || eachDA.equals("00");
                        String sel = dataAggregateMap.get(originalDAcode);
                        if (sel != null) {
                            dataAggregateMap.put(originalDAcode, String.valueOf(sel) + "/" + inProgramDAcode);
                            continue;
                        }
                        dataAggregateMap.put(originalDAcode, inProgramDAcode);
                    }
                }
                if (this.isCommonStructureEditable(selection) && !da00 && dataAggregateMap.get(String.valueOf(param_dsl) + "00") == null) {
                    dataAggregateMap.put(String.valueOf(param_dsl) + "00", String.valueOf(param_dsp) + "00");
                }
            }
        }
    }

    protected boolean isCommonStructureEditable(String selection) {
        return true;
    }

    protected boolean isSpecificDescGeneration(WFGenerationContext wfCtx) {
        return false;
    }

    protected boolean isEmptySdGenerated(String dafirstcode) {
        return false;
    }

    private static boolean isUpdatedLine(String oldText, String newText) {
        String[] newWords;
        int length = Math.min(oldText.length(), 72);
        String[] oldWords = oldText.substring(0, length).trim().split("\\s+");
        if (oldWords.length == (newWords = newText.substring(0, length = Math.min(newText.length(), 72)).trim().split("\\s+")).length) {
            int i = 0;
            while (i < oldWords.length) {
                if (!oldWords[i].equals(newWords[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    protected boolean specificCompare(String type, String line, String identLine) {
        return false;
    }

    public static ITextArtefactLocation getLocationForMPMacro(String[] lines, StringBuilder contrib, ITextArtefactLocation location, boolean sort, String newLine) {
        String contribution = contrib.toString();
        String[] linesContrib = PdpTool.splitTextIntoArrayLines((String)contribution);
        String line = linesContrib[0];
        String identLine = WFMicroPatternHandler.getIdentLine(line, false);
        String CompleteIdentLine = WFMicroPatternHandler.getIdentLine(line, true);
        String level = line.trim().substring(0, 2);
        int index = location.getBeginIndex();
        int startMP = 0;
        boolean levelTreatment = false;
        boolean firstLine = true;
        int indexForTag = 0;
        int endIndexForTag = 0;
        int i = 0;
        while (i < lines.length) {
            block20: {
                block22: {
                    String l;
                    block24: {
                        String ident;
                        block25: {
                            block23: {
                                block21: {
                                    line = lines[i];
                                    if (line.length() <= 5) break block20;
                                    if (line.charAt(6) != '*') break block21;
                                    if (sort) {
                                        indexForTag = index;
                                        contribution = "";
                                        break;
                                    }
                                    break block22;
                                }
                                if (!line.contains("EXEC SQL")) break block23;
                                startMP = index;
                                break block22;
                            }
                            l = line.trim().substring(0, 2);
                            try {
                                Integer.parseInt(l);
                            }
                            catch (NumberFormatException numberFormatException) {
                                l = "";
                            }
                            if (l.equals("01") && firstLine && EBCDICCompare.stringCompare((String)level, (String)l) > 0) {
                                indexForTag = index;
                                contribution = "";
                                break;
                            }
                            if (line.charAt(6) == '*' || !level.equals(l)) break block24;
                            ident = WFMicroPatternHandler.getIdentLine(line, false);
                            levelTreatment = true;
                            if (Ebcdic.stringCompare(ident, identLine) == 0) {
                                if (CompleteIdentLine.length() > identLine.length()) {
                                    String completeIdent = WFMicroPatternHandler.getIdentLine(line, true);
                                    if (Ebcdic.stringCompare(completeIdent, CompleteIdentLine) == 0) {
                                        return new TextArtefactLocation(-1, -1);
                                    }
                                    indexForTag = index + line.length() + newLine.length();
                                    contribution = "";
                                    break;
                                }
                                int k = 0;
                                while (k < linesContrib.length) {
                                    if (i + k < lines.length && WFMicroPatternHandler.isUpdatedLine(lines[i + k], linesContrib[k])) {
                                        indexForTag = index;
                                        endIndexForTag = index + line.length() + newLine.length();
                                        int j = 1;
                                        while (j < linesContrib.length) {
                                            endIndexForTag = endIndexForTag + line.length() + newLine.length();
                                            ++j;
                                        }
                                        return new TextArtefactLocation(indexForTag, endIndexForTag);
                                    }
                                    ++k;
                                }
                                return new TextArtefactLocation(-1, -1);
                            }
                            if (ident.length() > identLine.length()) {
                                ident = ident.substring(0, identLine.length());
                            }
                            if (Ebcdic.stringCompare(ident, identLine) != 0) break block25;
                            if (firstLine) {
                                indexForTag = index;
                                contribution = "";
                                firstLine = false;
                            }
                            break block22;
                        }
                        if (Ebcdic.stringCompare(ident, identLine) <= 0) break block22;
                        indexForTag = index;
                        if (startMP > 0) {
                            indexForTag = startMP;
                        }
                        if (sort) {
                            contribution = "";
                            break;
                        }
                        break block22;
                    }
                    if (levelTreatment) {
                        if (EBCDICCompare.stringCompare((String)l, (String)level) > 0) {
                            levelTreatment = false;
                        } else {
                            contribution = "";
                            break;
                        }
                    }
                }
                index = index + line.length() + newLine.length();
            }
            ++i;
        }
        if (contribution.trim().length() > 0 && firstLine) {
            int newIndex = index;
            if (!sort) {
                newIndex = location.getEndIndex();
            }
            indexForTag = newIndex;
        }
        return new TextArtefactLocation(indexForTag, endIndexForTag);
    }

    public String getId() {
        return "WF";
    }

    private static String getIdentLine(String line, boolean complete) {
        String s = line.trim().substring(2).trim();
        int index = s.indexOf(" ");
        if (index < 0) {
            index = s.indexOf(".");
        }
        String ident = s;
        if (index >= 0) {
            ident = s.substring(0, index);
        }
        if (ident.endsWith(".")) {
            ident = ident.substring(0, ident.length() - 1);
        }
        if (ident.contains("-") && ident.indexOf("-") < 2) {
            ident = ident.substring(ident.indexOf("-") + 1, ident.length());
        } else if (ident.startsWith("V")) {
            ident = ident.substring(1, ident.length());
        } else if ((ident.startsWith("I") || ident.startsWith("J")) && (ident.endsWith("R") || ident.endsWith("L") || ident.endsWith("M"))) {
            ident = complete ? ident.substring(0, ident.length() - 1) : ident.substring(1, ident.length() - 1);
        }
        return ident;
    }

    protected WFGenerationContext implementNewWFGenerationContext(IMicroPattern microPattern) {
        return new WFGenerationContext(microPattern);
    }

    protected WFGenerationForOrganization implementNewWFGenerationForOrg(WFGenerationContext wfCtx) {
        return new WFGenerationForOrganization(wfCtx);
    }

    protected WFSegmentGenerator implementNewSegmentGenerator(DataAggregate da, GenerationContext ctx, WFGenerationContext wfCtx) {
        return new WFSegmentGenerator(da, ctx, wfCtx, this);
    }

    protected boolean isRenamePossible() {
        return true;
    }

    protected List<String> orderedKeys(Set<String> set) {
        ArrayList<String> l = new ArrayList<String>();
        Iterator<String> its = set.iterator();
        while (its.hasNext()) {
            l.add(its.next());
        }
        Collections.sort(l, new Comparator<String>(){

            @Override
            public int compare(String object1, String object2) {
                return Ebcdic.stringCompare(object1.substring(0, 8), object2.substring(0, 8));
            }
        });
        return l;
    }

    @Override
    public boolean isAnnotationsNeededInMacro() {
        return true;
    }

    public String getTemplate() {
        return " DSP= DSL= FOR=I LEV=1";
    }

    public String getDescription() {
        return DescriptionContentAssistMP.WFMicroPattern_DESCRIPTION;
    }

    @Override
    protected String handleLocalFragment(IMicroPattern microPattern, IGenInfoBuilder genInfoBuilder) {
        StringBuilder contrib1 = new StringBuilder();
        if (!"true".equals(microPattern.getAttribute("_erase"))) {
            contrib1 = this.generateLocalMP(microPattern, genInfoBuilder);
        } else {
            this.setAllowedToHaveEmptyLocalContribution(microPattern, true);
        }
        if (microPattern.getAttribute("SAVESEL") != null) {
            microPattern.getAttributes().put("SEL", microPattern.getAttribute("SAVESEL"));
            microPattern.getAttributes().remove("SAVESEL");
        }
        if (microPattern.getAttribute("SDSEL") != null) {
            microPattern.getAttributes().remove("SDSEL");
        }
        if (microPattern.getAttribute("GENERATE_SDBEGINNING") != null) {
            microPattern.getAttributes().remove("GENERATE_SDBEGINNING");
        }
        if (microPattern.getAttribute("_erase") != null) {
            microPattern.getAttributes().remove("_erase");
        }
        String prefixWF = microPattern.getAttribute("PFX");
        String newSegCodeWF = microPattern.getAttribute("SIP");
        String localFragment = contrib1.toString();
        if (localFragment.length() != 0 && prefixWF != null) {
            if (this.isLinesLengthOK(localFragment)) {
                localFragment = localFragment.replaceAll(Pattern.quote(WFMicroPatternHandler.getTempPrefix()), prefixWF);
            } else {
                this.logWarning(Messages.MicroPatternHandler_WRONG_PREFIX, microPattern);
                localFragment = localFragment.replaceAll(Pattern.quote(WFMicroPatternHandler.getTempPrefix()), "");
            }
        }
        if (localFragment.length() != 0 && newSegCodeWF != null && newSegCodeWF.length() <= 10) {
            if (this.isLinesLengthOK(localFragment)) {
                String dsl = microPattern.getAttribute("DSL");
                String sel = microPattern.getAttribute("SEL");
                String seg = String.valueOf(dsl) + sel;
                localFragment = localFragment.replaceAll(Pattern.quote(String.valueOf(WFMicroPatternHandler.getTempSegInPgm()) + seg), newSegCodeWF);
                localFragment = localFragment.replaceAll(Pattern.quote(WFMicroPatternHandler.getTempSegInPgm()), "");
            } else {
                this.logWarning(Messages.MicroPatternHandler_WRONG_SEGINPGM, microPattern);
                localFragment = localFragment.replaceAll(Pattern.quote(WFMicroPatternHandler.getTempSegInPgm()), "");
            }
        }
        return localFragment;
    }

    public static String getTempPrefix() {
        return tempPFX;
    }

    public void setTempPrefix(String pfx) {
        tempPFX = pfx;
    }

    public static String getTempSegInPgm() {
        return tempSIP;
    }

    public void setTempSegInPgm(String sip) {
        tempSIP = sip;
    }

    protected StringBuilder generateLocalMP(IMicroPattern microPattern, IGenInfoBuilder genInfoBuilder) {
        int i;
        StringBuilder sb;
        int tpfxLength;
        int pfxLength;
        String temporaryPrefix;
        WFGenerationContext wfCtx = this.getGenerationContextForMP(microPattern);
        String dsp = wfCtx.getParam_DSP();
        if (!wfCtx.getParam_PFX().equals("")) {
            temporaryPrefix = "#!PREFIX#FOR#WF#MICROPATTERN";
            pfxLength = wfCtx.getParam_PFX().length();
            if (pfxLength > (tpfxLength = temporaryPrefix.length())) {
                sb = new StringBuilder();
                sb.append(temporaryPrefix);
                i = tpfxLength;
                while (i < pfxLength) {
                    sb.append("#");
                    ++i;
                }
                temporaryPrefix = sb.toString();
            } else {
                temporaryPrefix = temporaryPrefix.substring(0, pfxLength);
            }
            this.setTempPrefix(temporaryPrefix);
            dsp = String.valueOf(temporaryPrefix) + wfCtx.getParam_DSP();
        }
        if (!wfCtx.getParam_SIP().equals("")) {
            if (wfCtx.getParam_SIP().length() > 10) {
                this.logWarning(Messages.MicroPatternHandler_WRONG_SEGINPGM, microPattern);
            } else {
                temporaryPrefix = "#!SEGINPGM#FOR#WF#MICROPATTERN";
                pfxLength = wfCtx.getParam_SIP().length();
                if (pfxLength > (tpfxLength = temporaryPrefix.length())) {
                    sb = new StringBuilder();
                    sb.append(temporaryPrefix);
                    i = tpfxLength;
                    while (i < pfxLength) {
                        sb.append("#");
                        ++i;
                    }
                    temporaryPrefix = sb.toString();
                } else {
                    temporaryPrefix = temporaryPrefix.substring(0, pfxLength);
                }
                this.setTempSegInPgm(temporaryPrefix);
                dsp = String.valueOf(temporaryPrefix) + wfCtx.getParam_DSP();
            }
        }
        wfCtx.setParam_DSP(dsp);
        StringBuilder fragmentsResult = new StringBuilder();
        if (this.checkStatus(microPattern.getProcessingContext()) && !wfCtx.getErrorOnParameters()) {
            HashMap<String, String> dataAggregateMap = new HashMap<String, String>();
            this.analyzeSelection(wfCtx, dataAggregateMap);
            if (dataAggregateMap.size() == 0) {
                this.logWarning(Messages.WFMicroPatternHandler_WRONG_DATASTRUCTURE_VALUE, microPattern);
                return fragmentsResult;
            }
            EObject obj = this.searchReference(microPattern);
            if (!(obj instanceof RadicalEntity)) {
                return fragmentsResult;
            }
            RadicalEntity re = (RadicalEntity)obj;
            String pattern = WFMicroPatternHandler.GetPatternFor(re);
            if ("com.ibm.pdp.pacbase.batch".equals(pattern)) {
                if (wfCtx.getParam_ORG().equals("H")) {
                    return fragmentsResult;
                }
                if (wfCtx.getProgramStructure() == null) {
                    PacProgramWrapper p = new PacProgramWrapper((PacProgram)re);
                    wfCtx.setProgramStructure(p.getProgramStructure());
                }
            }
            wfCtx.setPattern(WFMicroPatternHandler.SearchPatternForWorkingPurpose(re));
            this.processBreakDateOption(wfCtx);
            wfCtx.setSQLIndicator(this.searchSQLIndicator(re, WFMicroPatternHandler.SearchPatternForWorkingPurpose(re)));
            wfCtx.setGeneratedDateFormat(WFMicroPatternHandler.SearchGeneratedDateFormatFor(re));
            GenerationContext ctx = new GenerationContext(WFMicroPatternHandler.SearchVariantFor(re), WFMicroPatternHandler.SearchGenerationParameterVariantFor(re), WFMicroPatternHandler.SearchGeneratedLanguageFor(re), WFMicroPatternHandler.SearchPatternForWorkingPurpose(re), WFMicroPatternHandler.GetProperty_ALPHA_NUMERIC_DELIMITER(microPattern.getProcessingContext()));
            if (wfCtx.getParam_BLC().length() > 0) {
                this.updateDatabaseDatas(re, wfCtx, ctx);
            }
            ctx.setBreakDateOption(wfCtx.isBreakdateOption());
            WFGenerationForOrganization wfGenOrg = this.getWFGenerationForOrganization(wfCtx);
            Iterator its = dataAggregateMap.keySet().iterator();
            String[] keysToRemove = new String[dataAggregateMap.size()];
            int ind = 0;
            String daFirstCode = "99";
            HashMap<String, WFSegmentGenerator> dataAggregateGenerator = new HashMap<String, WFSegmentGenerator>();
            while (its.hasNext()) {
                String daCode = (String)its.next();
                RadicalEntity da = this.searchRadicalEntity(re.getProject(), re.getPackage(), daCode, "dataaggregate", microPattern.getProcessingContext());
                if (da == null) {
                    if (this.is00Generated(wfCtx) && daCode.endsWith("00") && WFGenerationContext.is00Selected(wfCtx.getParam_SEL())) {
                        daFirstCode = "00";
                    }
                    keysToRemove[ind++] = daCode;
                    continue;
                }
                String selection = (String)dataAggregateMap.get(daCode);
                if (selection.contains("/")) {
                    String[] sel = selection.split("/");
                    int i2 = 0;
                    while (i2 < sel.length) {
                        dataAggregateGenerator.put(String.valueOf(sel[i2]) + daCode, this.implementNewSegmentGenerator((DataAggregate)da, ctx, wfCtx));
                        ++i2;
                    }
                    continue;
                }
                dataAggregateGenerator.put(String.valueOf(selection) + daCode, this.implementNewSegmentGenerator((DataAggregate)da, ctx, wfCtx));
                if (selection.endsWith("00")) {
                    wfCtx.setDaOccursNb(this.getOccursOnPacDataAggregate((List<?>)da.getExtensions()));
                }
                if (!selection.endsWith("00") || daCode.endsWith("00") || !this.isCommonStructureEditable(wfCtx.getParam_SEL())) continue;
                String s = String.valueOf(daCode.substring(0, 2)) + "00";
                RadicalEntity db = this.searchRadicalEntity(re.getProject(), re.getPackage(), s, "dataaggregate", microPattern.getProcessingContext());
                if (db == null) continue;
                dataAggregateGenerator.put(String.valueOf(selection) + s, this.implementNewSegmentGenerator((DataAggregate)db, ctx, wfCtx));
            }
            if (keysToRemove.length > 0 && ind > 0) {
                int j = 0;
                while (j < ind) {
                    dataAggregateMap.remove(keysToRemove[j]);
                    ++j;
                }
            }
            if (dataAggregateMap.size() == 0 && !this.isEmptySdGenerated(daFirstCode)) {
                wfCtx.errorRaised = true;
                this.logWarning(Messages.WFMicroPatternHandler_WRONG_SEGMENT_VALUE, microPattern);
                return fragmentsResult;
            }
            HashMap<String, Integer> lengths = new HashMap<String, Integer>(dataAggregateGenerator.size());
            Iterator iter = dataAggregateGenerator.entrySet().iterator();
            while (iter.hasNext()) {
                int daCodelength;
                int daCodePosition;
                Map.Entry<String, WFSegmentGenerator> entry = this.extractedSegmentGenerator(iter);
                int l = entry.getValue().getLength();
                String daCode = entry.getKey();
                String newdaCode = daCode.substring(daCodePosition = (daCodelength = daCode.length()) - 6, daCodePosition + 2);
                if (Ebcdic.stringCompare(newdaCode, daFirstCode) < 0) {
                    daFirstCode = newdaCode;
                }
                if (daCode.endsWith("00") || newdaCode.equals("00")) {
                    wfCtx.setDa00Length(wfCtx.getDa00Length() + l);
                    if (daCode.endsWith("00")) {
                        wfCtx.setExisting00(true);
                    }
                    if (!newdaCode.equals("00")) continue;
                    daFirstCode = "00";
                    continue;
                }
                String segment = daCode.substring(0, daCodelength - 4);
                if (lengths.containsKey(segment)) {
                    l += ((Integer)lengths.get(segment)).intValue();
                }
                lengths.put(segment, l);
            }
            Iterator lgs = lengths.values().iterator();
            while (lgs.hasNext()) {
                wfCtx.setDaMaxLength(Math.max((Integer)lgs.next(), wfCtx.getDaMaxLength()));
            }
            wfCtx.setFirstSegmentCode(daFirstCode);
            wfCtx.setAtLeastOneSegment(!dataAggregateMap.isEmpty());
            TreeSet<SortedWFMicroPattern> listMPs = this.extractedListMPs(microPattern);
            SortedWFMicroPattern sortedMP2 = null;
            if (listMPs != null) {
                for (SortedWFMicroPattern sortedMP2 : listMPs) {
                    if (sortedMP2.getMicroPattern().equals(microPattern)) break;
                }
            }
            List<String> segments = this.orderedKeys(dataAggregateGenerator.keySet());
            wfCtx.setMultiSegments(segments);
            this.setDatasForSqlMP(microPattern, wfCtx, segments);
            fragmentsResult.append(this.generateTextBeforeMP(microPattern, genInfoBuilder, wfCtx));
            String generateSDBeginning = microPattern.getAttribute("GENERATE_SDBEGINNING");
            if (generateSDBeginning == null || generateSDBeginning.equals("true")) {
                fragmentsResult.append(wfCtx.generateSDbeginning());
            }
            boolean isFirst = true;
            StringBuilder otherContrib = new StringBuilder();
            StringBuilder contrib00 = new StringBuilder();
            String sgtPrev = "";
            int i3 = 0;
            while (i3 < segments.size()) {
                wfCtx.setGlobalContrib(false);
                String daCode = segments.get(i3);
                WFSegmentGenerator sg = (WFSegmentGenerator)dataAggregateGenerator.get(daCode);
                String segmentCode = daCode.substring(0, daCode.length() - 4);
                sg.setSegmentCode(segmentCode);
                sg.setGeneratedInfoBuilder(genInfoBuilder);
                sg.setIsFirstTimeInSegment(isFirst);
                if (lengths.containsKey(segmentCode)) {
                    sg.setNewLength((Integer)lengths.get(segmentCode));
                }
                isFirst = i3 + 1 >= segments.size() || !segments.get(i3).substring(0, daCode.length() - 4).equals(segments.get(i3 + 1).substring(0, daCode.length() - 4));
                StringBuilder result = new StringBuilder();
                result.append((CharSequence)sg.generate(isFirst));
                if (!wfCtx.isSegmentEmpty()) {
                    if (contrib00.toString().trim().length() > 0 && segmentCode.endsWith(sgtPrev)) {
                        fragmentsResult.append(contrib00.toString());
                        contrib00 = new StringBuilder();
                        sgtPrev = "";
                    }
                    fragmentsResult.append(result.toString());
                } else if (i3 == 0 && segments.size() > 1) {
                    contrib00.append(result.toString());
                    sgtPrev = segmentCode.substring(2, 4);
                }
                if (this.isSpecificDescGeneration(wfCtx)) {
                    otherContrib.append((CharSequence)sg.generateSpecificDesc());
                }
                if (!wfCtx.isSegmentEmpty()) {
                    this.generateGlobalContributions(microPattern, sg, segmentCode, genInfoBuilder, ctx, i3 == 0, i3 == segments.size() - 1, wfCtx);
                    if (wfGenOrg != null) {
                        wfGenOrg.generateFragmentForSegment(genInfoBuilder);
                    }
                }
                if (sortedMP2 != null && (wfCtx.getParam_ORG().equals("9") || wfCtx.getParam_ORG().equals("P"))) {
                    sortedMP2.setSegmentCode(segmentCode);
                    microPattern.getProcessingContext().setData("listMPOrg", listMPs);
                }
                ++i3;
            }
            this.generateTextAfterMP(microPattern, genInfoBuilder, fragmentsResult, otherContrib, wfCtx);
        }
        return fragmentsResult;
    }

    private Map.Entry<String, WFSegmentGenerator> extractedSegmentGenerator(Iterator<?> iter) {
        return (Map.Entry)iter.next();
    }

    private TreeSet<SortedWFMicroPattern> extractedListMPs(IMicroPattern microPattern) {
        return (TreeSet)microPattern.getProcessingContext().getData("listMPOrg");
    }

    private HashMap<String, SegmentDatasForWF> extractedSegments(WFGenerationContext wfCtx) {
        return (HashMap)wfCtx.getMicroPattern().getProcessingContext().getData("WF_DATAS_SEGMENT_ID");
    }

    private void setDatasForSqlMP(IMicroPattern microPattern, WFGenerationContext wfCtx, List<String> segments) {
        if (wfCtx.getParam_ORG().length() > 0) {
            HashMap<String, SegmentDatasForWF> table = this.extractedSegments(wfCtx);
            if (table == null) {
                table = new HashMap();
                wfCtx.getMicroPattern().getProcessingContext().setData("WF_DATAS_SEGMENT_ID", table);
            }
            ArrayList<String> segsInLib = new ArrayList<String>();
            int i = 0;
            while (i < segments.size()) {
                String segment = segments.get(i).substring(0, 4);
                if (!table.containsKey(segment)) {
                    SegmentDatasForWF sgt = new SegmentDatasForWF();
                    sgt.setBlockBaseCode(wfCtx.getParam_BLC());
                    sgt.setOrg(wfCtx.getParam_ORG());
                    sgt.setSsSchema(wfCtx.getParam_SSC());
                    table.put(segment, sgt);
                }
                segsInLib.add(segments.get(i).substring(4, 8));
                if (i + 1 >= segments.size() || !segment.equals(segments.get(i + 1).substring(0, 4))) {
                    table.get(segment).setSegmentInLibrary(segsInLib);
                    segsInLib = new ArrayList();
                }
                ++i;
            }
        }
    }

    protected void generateTextAfterMP(IMicroPattern microPattern, IGenInfoBuilder genInfoBuilder, StringBuilder localContrib, StringBuilder otherContrib, WFGenerationContext wfCtx) {
        if (otherContrib.toString().trim().length() > 0) {
            localContrib.append((CharSequence)otherContrib);
        }
    }

    protected String generateTextBeforeMP(IMicroPattern microPattern, IGenInfoBuilder genInfoBuilder, WFGenerationContext wfCtx) {
        return "";
    }

    protected void generateGlobalContributions(IMicroPattern microPattern, WFSegmentGenerator sg, String segmentCode, IGenInfoBuilder genInfoBuilder, GenerationContext ctx, boolean first, boolean last, WFGenerationContext wfCtx) {
    }

    public WFGenerationContext getGenerationContextForMP(IMicroPattern microPattern) {
        HashMap<IMicroPattern, WFGenerationContext> table = (HashMap<IMicroPattern, WFGenerationContext>)microPattern.getProcessingContext().getData("contextGenerationForWF");
        if (table == null) {
            table = new HashMap<IMicroPattern, WFGenerationContext>();
            microPattern.getProcessingContext().setData("contextGenerationForWF", table);
        }
        if (table.containsKey(microPattern)) {
            return (WFGenerationContext)table.get(microPattern);
        }
        WFGenerationContext wfCtx = this.implementNewWFGenerationContext(microPattern);
        wfCtx.decodeParameter(this.searchReference(microPattern), this);
        table.put(microPattern, wfCtx);
        return wfCtx;
    }

    @Override
    protected String getGSVLabel(IMicroPattern microPattern) {
        StringBuilder sb = new StringBuilder("!");
        sb.append(this.getId());
        Iterator attributeNames = microPattern.getAttributes().keySet().iterator();
        StringBuilder sb1 = new StringBuilder();
        while (attributeNames.hasNext()) {
            String name = (String)attributeNames.next();
            if (!name.equals("DSL") && !name.equals("DSP") && !name.equals("SEL")) continue;
            String value = microPattern.getAttribute(name);
            if (sb1.length() > 0) {
                sb1.append(" ");
            }
            sb1.append(name);
            sb1.append("=");
            sb1.append(value);
        }
        if (sb1.length() > 0) {
            sb.append(" ");
            sb.append(sb1.toString());
        }
        return sb.toString();
    }

    public WFGenerationForOrganization getWFGenerationForOrganization(WFGenerationContext wfCtx) {
        if (wfCtx.getParam_ORG().trim().length() == 0) {
            return null;
        }
        HashMap<String, WFGenerationForOrganization> table = (HashMap<String, WFGenerationForOrganization>)wfCtx.getMicroPattern().getProcessingContext().getData("contextGenerationForWF");
        if (table == null) {
            table = new HashMap<String, WFGenerationForOrganization>();
            wfCtx.getMicroPattern().getProcessingContext().setData("contextGenerationForWF", table);
        }
        if (table.containsKey(wfCtx.getParam_ORG())) {
            return (WFGenerationForOrganization)table.get(wfCtx.getParam_ORG());
        }
        WFGenerationForOrganization wfOrg = this.implementNewWFGenerationForOrg(wfCtx);
        table.put(wfCtx.getParam_ORG(), wfOrg);
        return wfOrg;
    }

    protected ITextArtefactLocation getLocation(String startTagName, String[] startTexts, String endTagName, String endText, IGenInfoBuilder genInfoBuilder, String newLine) {
        IBuilderTag genEndTag;
        IBuilderTag startTag = genInfoBuilder.tagFromName(startTagName);
        int startIndex = 0;
        int endIndex = 0;
        boolean endTextExist = false;
        if (startTag != null) {
            startIndex = startTag.getBeginIndex();
            endIndex = startTag.getEndIndex();
            String text = startTag.getText().toString();
            if (startTexts != null && startTexts.length > 0) {
                int i = startTexts.length - 1;
                while (i >= 0) {
                    if (startTexts[i].trim().length() > 0 && text.contains(startTexts[i])) {
                        int ind1 = text.indexOf(startTexts[i]);
                        int ind2 = text.substring(ind1).indexOf(".");
                        int ind3 = text.substring(ind1 + ind2).indexOf(newLine);
                        startIndex = startIndex + ind1 + ind2 + ind3 + newLine.length();
                        i = -1;
                    }
                    --i;
                }
            } else {
                startIndex = startTag.getEndIndex();
            }
            if (endText != null && endText.length() > 0) {
                if (text.contains(endText)) {
                    endIndex = startTag.getBeginIndex() + text.substring(0, text.indexOf(endText)).lastIndexOf(newLine);
                    endIndex += newLine.length();
                    endTextExist = true;
                }
                while (!endTextExist && startTag.nextTag() != null) {
                    text = startTag.nextTag().getText().toString();
                    if (text.contains(endText)) {
                        endIndex = startTag.nextTag().getBeginIndex() + text.substring(0, text.indexOf(endText)).lastIndexOf(newLine);
                        endIndex += newLine.length();
                        endTextExist = true;
                    }
                    startTag = startTag.nextTag();
                }
            }
        }
        if (endTagName != null && !endTextExist && (genEndTag = genInfoBuilder.tagFromName(endTagName)) != null) {
            endIndex = genEndTag.getBeginIndex();
        }
        return new TextArtefactLocation(startIndex, endIndex);
    }

    protected void processBreakDateOption(WFGenerationContext wfCtx) {
        wfCtx.setBreakDateOption((Boolean)wfCtx.getMicroPattern().getProcessingContext().getData("BREAKDATE_OPTION"));
    }

    protected void searchBaseOptions(WFGenerationContext wfCtx, PacBlockBase database, RadicalEntity re) {
        EList gLines = database.getGOLines();
        boolean desc_all = false;
        for (Object object : gLines) {
            if (!(object instanceof PacGLineImpl)) continue;
            if (((PacGLineImpl)object).getDescription().trim().contains("DESCR=ALL")) {
                desc_all = true;
            }
            if (!((PacGLineImpl)object).getLineType().equals("O") || !desc_all) continue;
            switch (re.eClass().getClassifierID()) {
                case 39: 
                case 70: 
                case 101: {
                    wfCtx.setBreakDateOption((Boolean)wfCtx.getMicroPattern().getProcessingContext().getData("BREAKDATE_OPTION"));
                    break;
                }
            }
        }
        if (!desc_all) {
            wfCtx.setBreakDateOption(false);
        }
        wfCtx.setDescAllOption(desc_all);
    }

    private int getOccursOnPacDataAggregate(List<?> extensions) {
        if (extensions.isEmpty()) {
            return 0;
        }
        for (Object o : extensions) {
            if (!(o instanceof PacDataAggregate)) continue;
            PacDataAggregate pdc = (PacDataAggregate)o;
            return pdc.getTableSize();
        }
        return 0;
    }

    private boolean searchSQLIndicator(RadicalEntity re, PacbasePattern pattern) {
        List<PacGLine> goLines = null;
        boolean isSQLIndic = false;
        switch (re.eClass().getClassifierID()) {
            case 39: {
                PacProgramWrapper p = new PacProgramWrapper((PacProgram)re);
                isSQLIndic = p.isSQLIndicator();
                break;
            }
            case 72: {
                if (pattern.equals((Object)PacbasePattern.DIALOG)) {
                    PacDialogWrapper dialog = new PacDialogWrapper((PacDialog)re);
                    if (dialog.getOptions().toUpperCase().contains("SQLREF") || dialog.getOptions().toUpperCase().contains("SQR")) {
                        isSQLIndic = true;
                        break;
                    }
                    goLines = dialog.getGOLines();
                }
            }
            case 70: {
                if (pattern.equals((Object)PacbasePattern.DIALOG)) {
                    if (re instanceof PacScreen) {
                        PacScreenWrapper scr = new PacScreenWrapper((PacScreen)re);
                        if (scr.getDialog().getOptions().toUpperCase().contains("SQLREF") || scr.getDialog().getOptions().toUpperCase().contains("SQR")) {
                            isSQLIndic = true;
                            break;
                        }
                        goLines = this.extractedGOlines(scr);
                    }
                    for (PacGLine goline : goLines) {
                        if (!goline.getLineType().equals("O") || !goline.getDescription().toUpperCase().contains("SQLREF=YES") && !goline.getDescription().toUpperCase().contains("SQR=YES")) continue;
                        isSQLIndic = true;
                    }
                    break;
                }
                isSQLIndic = true;
                break;
            }
            default: {
                isSQLIndic = true;
            }
        }
        return isSQLIndic;
    }

    private List<PacGLine> extractedGOlines(PacScreenWrapper scr) {
        ArrayList<PacGLine> goLines = new ArrayList<PacGLine>(scr.getDialog().getGOLines().size() + scr.getGOLines().size());
        goLines.addAll((Collection<PacGLine>)scr.getDialog().getGOLines());
        goLines.addAll((Collection<PacGLine>)scr.getGOLines());
        return goLines;
    }

    public boolean is00Generated(WFGenerationContext wfctx) {
        return false;
    }

    private void updateDatabaseDatas(RadicalEntity re, WFGenerationContext wfCtx, GenerationContext ctx) {
        PacBlockBase database;
        if ((wfCtx.getParam_ORG().equals("2") || wfCtx.getParam_ORG().equals("H")) && (database = (PacBlockBase)this.searchRadicalEntity(re.getProject(), re.getPackage(), wfCtx.getParam_BLC(), "pacblockbase", wfCtx.getMicroPattern().getProcessingContext())) != null) {
            if (PacBlockBaseTypeValues._Q2_LITERAL.equals(database.getBlockType()) || PacBlockBaseTypeValues._QB_LITERAL.equals(database.getBlockType())) {
                ctx.setBlocType(GenerationContext.BlocType.DB2);
            } else if (PacBlockBaseTypeValues._QP_LITERAL.equals(database.getBlockType())) {
                ctx.setBlocType(GenerationContext.BlocType.ORACLE);
            }
        }
    }

    public static String generateExecBeginSql() {
        return "                 EXEC SQL BEGIN DECLARE SECTION END-EXEC.";
    }

    public static String generateExecEndSql() {
        return "                 EXEC SQL END   DECLARE SECTION END-EXEC.";
    }

    @Override
    protected String controlIndentLine(IMicroPattern microPattern, String line, int indentDiff) {
        String resultControl = super.controlIndentLine(microPattern, line, indentDiff);
        if (resultControl.trim().length() == 0 && (resultControl.length() > 10 || resultControl.length() < 7) && (line.trim().startsWith("01") || line.trim().startsWith("77"))) {
            return Messages.MicroPatternHandler_WRONG_INDENT;
        }
        return resultControl;
    }

    @Override
    protected void convertToAttributes(IMicroPattern microPattern, Map<String, Object> parameters) {
    }

    @Override
    protected LinkedHashMap<String, String> convertToParameters(IMicroPattern microPattern, String operandes) {
        if (microPattern.getAnalyzerResult() == null) {
            return null;
        }
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        for (Map.Entry entry : microPattern.getAttributes().entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (!key.equals("DSP") && !key.equals("DSL") && !key.equals("SEL") && !key.equals("FOR") && !key.equals("DES") && !key.equals("LEV") && !key.equals("ORG") && !key.equals("SSC") && !key.equals("BLC") && !key.equals("GRP") && !key.equals("PFX") && !key.equals("PLT") && !key.equals("SIP")) continue;
            parameters.put(key, value);
        }
        return parameters;
    }
}

