/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.extension.micropattern;

import com.ibm.pdp.engine.IGenInfoBuilder;
import com.ibm.pdp.engine.IMicroPattern;
import com.ibm.pdp.engine.IMicroPatternFilter;
import com.ibm.pdp.engine.IMicroPatternProcessingContext;
import com.ibm.pdp.framework.cobol.micropattern.internal.MicroPatternConstants;
import com.ibm.pdp.micropattern.analyzer.tool.MPDesignReference;
import com.ibm.pdp.pacbase.extension.micropattern.AbstractMicroPatternFilter;
import com.ibm.pdp.pacbase.extension.micropattern.WFMicroPatternConstants;
import java.util.List;
import java.util.Map;

public class WFMicroPatternFilter
extends AbstractMicroPatternFilter
implements IMicroPatternFilter,
MicroPatternConstants,
WFMicroPatternConstants {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2013, 2018.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public List<IMicroPattern> filters(List<IMicroPattern> microPatterns, IMicroPatternProcessingContext context) {
        boolean isMPWFexist = false;
        for (IMicroPattern microPattern : microPatterns) {
            if (!"WF".equals(microPattern.getId())) continue;
            this.convertToAttributes(microPattern);
            isMPWFexist = true;
            this.analyseSelection(microPattern);
        }
        if (isMPWFexist) {
            this.addTagsIfNeeded(context.getGeneratedInfo().toGeneratedInfoBuilder());
        }
        return microPatterns;
    }

    public String getName() {
        return null;
    }

    protected void analyseSelection(IMicroPattern microPattern) {
        String sel = microPattern.getAttribute("SEL");
        if (sel != null) {
            int ind = sel.indexOf("=");
            int lgth = sel.length();
            if (ind > 0 && ind > 2) {
                lgth = ind;
                sel = sel.substring(0, lgth);
                microPattern.getAttributes().put("SEL", sel);
            }
        }
    }

    protected void addTagsIfNeeded(IGenInfoBuilder genInfoBuilder) {
    }

    protected void convertToAttributes(IMicroPattern microPattern) {
        if (microPattern.getAnalyzerResult() != null) {
            for (Map.Entry entry : microPattern.getAnalyzerResult().getParameters().entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                if (value instanceof String) {
                    microPattern.getAttributes().put(key, (String)value);
                    continue;
                }
                if (value instanceof Integer) {
                    microPattern.getAttributes().put(key, ((Integer)value).toString());
                    continue;
                }
                if (!(value instanceof MPDesignReference)) continue;
                microPattern.getAttributes().put(key, ((MPDesignReference)value).getName());
            }
        }
    }
}

