/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.extension.micropattern;

import com.ibm.pdp.engine.IBuilderTag;
import com.ibm.pdp.engine.IGenInfoBuilder;
import com.ibm.pdp.mdl.pacbase.lal.util.PacbaseLalDescription;
import com.ibm.pdp.pacbase.extension.micropattern.AbstractCommonMicroPatternHandler;
import com.ibm.pdp.pacbase.extension.micropattern.WFGenerationContext;
import com.ibm.pdp.pacbase.extension.micropattern.WFGenerationForOrganization;

public class WFGenerationForOrganizationT
extends WFGenerationForOrganization {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2015, 2016.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private boolean isCallingCandidate = this.isCallingCandidateForOrganization();
    private StringBuilder working_F = new StringBuilder();
    private String topLevel = "";

    protected WFGenerationForOrganizationT(WFGenerationContext wfCtx) {
        super(wfCtx);
    }

    @Override
    protected void initPld(PacbaseLalDescription pld, boolean firstTime, String segmentCode) {
        super.initPld(pld, firstTime, segmentCode);
        if (this.isDataCandidateForOrganization(pld, firstTime)) {
            this.generateWorkingF(pld);
        }
        if (firstTime) {
            String s;
            String string = s = this.wfCtx.getFirstSegment().length() > 0 ? this.wfCtx.getFirstSegment() : segmentCode;
            if (!s.equals(this.topLevel)) {
                this.topLevel = s;
                this.generateTopLevel(this.topLevel);
            }
        }
    }

    private void generateTopLevel(String segmentCode) {
        this.working_F = new StringBuilder();
        this.working_F.append("         01               F-");
        this.working_F.append(segmentCode);
        this.working_F.append(".");
        this.working_F.append(this.NEW_LINE);
    }

    private void generateWorkingF(PacbaseLalDescription pld) {
        String alphanumericDelimiter = AbstractCommonMicroPatternHandler.GetProperty_ALPHA_NUMERIC_DELIMITER(this.wfCtx.getMicroPattern().getProcessingContext());
        this.working_F.append("            05        FILLER PICTURE X(8)  VALUE  ");
        this.working_F.append(alphanumericDelimiter);
        this.working_F.append(this.getValue(pld));
        this.working_F.append(alphanumericDelimiter);
        this.working_F.append(this.NEW_LINE);
    }

    @Override
    protected void generateFragmentForSegment(IGenInfoBuilder genInfoBuilder) {
        IBuilderTag tag = genInfoBuilder.tagFromName("F-" + this.topLevel);
        if (tag == null) {
            tag = this.searchTagForWorkingF(genInfoBuilder);
        }
        this.working_F.append("            05        FILLER PICTURE X(4)  VALUE  ");
        String alphanumericDelimiter = AbstractCommonMicroPatternHandler.GetProperty_ALPHA_NUMERIC_DELIMITER(this.wfCtx.getMicroPattern().getProcessingContext());
        this.working_F.append(alphanumericDelimiter);
        this.working_F.append("END.");
        this.working_F.append(alphanumericDelimiter);
        this.working_F.append(this.NEW_LINE);
        tag.setText((CharSequence)this.working_F);
    }

    protected String getValue(PacbaseLalDescription pld) {
        return "";
    }

    protected boolean isCallingCandidateForOrganization() {
        return true;
    }

    private boolean isDataCandidateForOrganization(PacbaseLalDescription pld, boolean firstTime) {
        int l;
        return this.isCallingCandidate && (!this.segmentCode.endsWith("00") || this.wfCtx.getDa00Length() > 0) && !pld.getRedefines() && (l = this.wfCtx.getRealLevel(pld.getLevel(), firstTime)) - 10 == 0;
    }

    protected IBuilderTag searchTagForWorkingF(IGenInfoBuilder genInfoBuilder) {
        return null;
    }
}

