/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.extension.micropattern;

import com.ibm.pdp.engine.IMicroPattern;
import com.ibm.pdp.mdl.pacbase.PacCDLineDataStructure;
import com.ibm.pdp.mdl.pacbase.PacDataStructureCall;
import com.ibm.pdp.mdl.pacbase.PacGeneratedDateFormatValues;
import com.ibm.pdp.mdl.pacbase.PacOrganizationValues;
import com.ibm.pdp.mdl.pacbase.PacProgramStructureValues;
import com.ibm.pdp.mdl.pacbase.PacSegmentCall;
import com.ibm.pdp.mdl.pacbase.impl.PacCommonLineDescriptionImpl;
import com.ibm.pdp.mdl.pacbase.impl.PacProgramImpl;
import com.ibm.pdp.mdl.pacbase.util.PacbasePattern;
import com.ibm.pdp.pacbase.extension.micropattern.AbstractCommonMicroPatternHandler;
import com.ibm.pdp.pacbase.extension.micropattern.Messages;
import com.ibm.pdp.pacbase.extension.micropattern.WFMicroPatternConstants;
import com.ibm.pdp.pacbase.extension.micropattern.WFMicroPatternHandler;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;

public class WFGenerationContext
implements WFMicroPatternConstants {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2014, 2021.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected String newLine = "/r/n";
    private IMicroPattern microPattern;
    private String param_BLC = "";
    private String param_DSL = "";
    private String param_DSP = "";
    private String param_FOR = "I";
    private String param_ORG = "";
    private String param_SDSEL = "";
    private String param_SEL = "";
    private int param_DES = 0;
    private int param_LEV = 1;
    private String param_PLT = "";
    private String param_SSC = "";
    private String param_PFX = "";
    private String param_SIP = "";
    private static int default_param_DES = 0;
    private static int default_param_LEV = 1;
    protected boolean errorRaised = false;
    private boolean isSegmentInFDClause = false;
    private boolean isAtLeastOneSegment = false;
    private boolean isMultiSegments = false;
    private boolean isDescrAllOption = false;
    private boolean isGlobalContrib = false;
    private boolean isSQLIndicator = false;
    private boolean isBreakDateOption = false;
    protected PacbasePattern pattern;
    PacGeneratedDateFormatValues generatedDateFormat = null;
    private int da00Length = 0;
    private boolean isExisting00 = false;
    private int daMaxLength = 0;
    private int daOccursNb = 0;
    private String firstSegmentCode = "99";
    private boolean isSegmentEmpty = false;
    private String firstSegment = "";
    private PacProgramStructureValues programStructure;

    public WFGenerationContext() {
    }

    public WFGenerationContext(IMicroPattern microPattern) {
        this.microPattern = microPattern;
        this.newLine = AbstractCommonMicroPatternHandler.GetProperty_NEW_LINE(microPattern.getProcessingContext());
    }

    public void decodeParameter(EObject obj, WFMicroPatternHandler handler) {
        String attributeValue;
        PacProgramImpl pgm;
        this.updateParameters();
        if (obj != null && obj instanceof PacProgramImpl && (pgm = (PacProgramImpl)obj).getProgramStructure().equals(PacProgramStructureValues._F_LITERAL)) {
            this.updateParametersForNatureF(pgm);
        }
        if ((attributeValue = this.microPattern.getAttribute("PLT")) != null) {
            this.param_PLT = attributeValue;
        }
        if ((attributeValue = this.microPattern.getAttribute("PFX")) != null) {
            this.param_PFX = attributeValue;
        }
        if ((attributeValue = this.microPattern.getAttribute("SIP")) != null) {
            this.param_SIP = attributeValue;
        }
        if ((attributeValue = this.microPattern.getAttribute("BLC")) != null) {
            this.param_BLC = attributeValue;
        }
        if ((attributeValue = this.microPattern.getAttribute("DES")) != null && attributeValue.trim().length() > 0) {
            try {
                this.param_DES = Integer.parseInt(attributeValue);
            }
            catch (NumberFormatException numberFormatException) {
                this.param_DES = default_param_DES;
                handler.logWarning(Messages.WFMicroPatternHandler_WRONG_DES_PARAMETER_VALUE, this.microPattern);
            }
            if (this.param_DES > 4) {
                handler.logWarning(Messages.WFMicroPatternHandler_WRONG_DES_PARAMETER_VALUE, this.microPattern);
            }
        }
        if ((attributeValue = this.microPattern.getAttribute("DSL")) != null && !this.errorRaised) {
            this.param_DSL = attributeValue;
            if (this.param_DSL.trim().length() == 0) {
                this.errorRaised = true;
                handler.logWarning(Messages.WFMicroPatternHandler_MANDATORY_DSL_PARAMETER_VALUE, this.microPattern);
            }
        }
        attributeValue = this.microPattern.getAttribute("DSP");
        if (!this.errorRaised) {
            if (attributeValue != null && attributeValue.trim().length() > 0) {
                this.param_DSP = attributeValue;
                if (this.param_DSP.length() > 2) {
                    this.param_DSP = "**";
                    handler.logWarning(Messages.WFMicroPatternHandler_WRONG_DSP_PARAMETER_VALUE, this.microPattern);
                }
                if (this.param_DSP.length() == 1) {
                    this.param_DSP = String.valueOf(this.param_DSP) + " ";
                    handler.logWarning(Messages.WFMicroPatternHandler_WRONG_DSP_PARAMETER_VALUE, this.microPattern);
                }
            } else {
                this.param_DSP = this.param_DSL;
            }
        }
        if ((attributeValue = this.microPattern.getAttribute("FOR")) != null && attributeValue.trim().length() > 0) {
            this.param_FOR = attributeValue;
        }
        if (!(this.param_FOR.equals("I") || this.param_FOR.equals("S") || this.param_FOR.equals("E"))) {
            handler.logWarning(Messages.WFMicroPatternHandler_WRONG_FOR_PARAMETER_VALUE, this.microPattern);
        }
        if ((attributeValue = this.microPattern.getAttribute("LEV")) != null && attributeValue.trim().length() > 0) {
            try {
                this.param_LEV = Integer.parseInt(attributeValue);
            }
            catch (NumberFormatException numberFormatException) {
                this.param_LEV = default_param_LEV;
                handler.logWarning(Messages.WFMicroPatternHandler_WRONG_LEV_PARAMETER_VALUE, this.microPattern);
            }
            if (this.param_LEV > 7) {
                handler.logWarning(Messages.WFMicroPatternHandler_WRONG_LEV_PARAMETER_VALUE, this.microPattern);
            }
        }
        if ((attributeValue = this.microPattern.getAttribute("ORG")) != null && !this.errorRaised) {
            this.param_ORG = attributeValue;
            if ("T".equals(this.param_ORG) && this.param_DES != 1) {
                this.param_DES = 1;
                handler.logWarning(Messages.WFMicroPatternHandler_WRONG_DES_PARAMETER_VALUE_ORGT, this.microPattern);
            }
        }
        if ((attributeValue = this.microPattern.getAttribute("SEL")) != null && !this.errorRaised) {
            this.param_SEL = attributeValue;
        }
        if ((attributeValue = this.microPattern.getAttribute("SDSEL")) != null && !this.errorRaised) {
            this.param_SDSEL = attributeValue;
        }
        if ((attributeValue = this.microPattern.getAttribute("SSC")) != null && !this.errorRaised) {
            this.param_SSC = attributeValue;
        }
    }

    private void updateParameters() {
        HashMap newMPs = (HashMap)this.microPattern.getProcessingContext().getData("newParametersForWF");
        if (newMPs != null) {
            for (IMicroPattern mp : newMPs.keySet()) {
                if (mp.getAttribute("ORG") != null || !mp.equals(this.microPattern)) continue;
                Map attributes = (Map)newMPs.get(mp);
                this.microPattern.getAttributes().put("DES", (String)attributes.get("DES"));
                this.microPattern.getAttributes().put("LEV", (String)attributes.get("LEV"));
            }
        }
    }

    private void updateParametersForNatureF(PacProgramImpl pgm) {
        PacCDLineDataStructure cdLine;
        if (this.microPattern.getAttribute("DSP") != null && this.microPattern.getAttribute("DSL") == null && (cdLine = this.getCdLine(pgm, this.microPattern.getAttribute("DSP"))) != null) {
            PacCommonLineDescriptionImpl description = (PacCommonLineDescriptionImpl)cdLine.getCommonDescription();
            this.microPattern.getAttributes().put("LEV", description.getCobolRecordLevel().getLiteral().substring(1));
            this.microPattern.getAttributes().put("FOR", description.getFormatType().getLiteral().substring(1));
            if (description.getGeneratedDescriptionType().getValue() == 0) {
                this.microPattern.getAttributes().put("DES", "");
            } else {
                this.microPattern.getAttributes().put("DES", description.getGeneratedDescriptionType().getLiteral().substring(1));
            }
            if (PacOrganizationValues._2_LITERAL.equals(description.getOrganization().getLiteral()) || PacOrganizationValues._9_LITERAL.equals(description.getOrganization().getLiteral()) || PacOrganizationValues._D_LITERAL.equals(description.getOrganization().getLiteral()) || PacOrganizationValues._G_LITERAL.equals(description.getOrganization().getLiteral()) || PacOrganizationValues._M_LITERAL.equals(description.getOrganization().getLiteral()) || PacOrganizationValues._N_LITERAL.equals(description.getOrganization().getLiteral()) || PacOrganizationValues._P_LITERAL.equals(description.getOrganization().getLiteral()) || PacOrganizationValues._Q_LITERAL.equals(description.getOrganization().getLiteral())) {
                this.microPattern.getAttributes().put("ORG", description.getOrganization().getLiteral());
            } else {
                this.microPattern.getAttributes().put("ORG", "");
            }
            if (PacOrganizationValues._S_LITERAL.equals(description.getOrganization())) {
                this.isSegmentInFDClause = true;
            }
            this.microPattern.getAttributes().put("GENERATE_SDBEGINNING", "true");
            Iterator dsCalls = cdLine.getDataStructureCalls().iterator();
            boolean first = true;
            StringBuilder sdsel = new StringBuilder();
            while (dsCalls.hasNext()) {
                PacDataStructureCall dsCall = (PacDataStructureCall)dsCalls.next();
                Iterator segmentCalls = dsCall.getSegmentCalls().iterator();
                if (first) {
                    this.microPattern.getAttributes().put("DSL", dsCall.getDataStructure().getName());
                    while (segmentCalls.hasNext()) {
                        PacSegmentCall segment = (PacSegmentCall)segmentCalls.next();
                        sdsel.append(segment.getSegment().getName().substring(2, 4));
                        if (segment.getCodeInProgram().trim().length() <= 0) continue;
                        sdsel.append("=").append(segment.getCodeInProgram());
                    }
                    this.microPattern.getAttributes().put("SEL", sdsel.toString());
                    first = false;
                    sdsel = new StringBuilder();
                    continue;
                }
                boolean firstSgt = true;
                while (segmentCalls.hasNext()) {
                    PacSegmentCall segment = (PacSegmentCall)segmentCalls.next();
                    if (firstSgt) {
                        sdsel.append(segment.getSegment().getName());
                        firstSgt = false;
                    } else {
                        sdsel.append(segment.getSegment().getName().substring(2, 4));
                    }
                    if (segment.getCodeInProgram().trim().length() <= 0) continue;
                    sdsel.append("=").append(segment.getCodeInProgram());
                }
                if (sdsel.toString().trim().length() <= 0) continue;
                sdsel.append(",");
            }
            if (sdsel.toString().trim().length() > 0) {
                this.microPattern.getAttributes().put("SDSEL", sdsel.toString());
            }
        }
    }

    public StringBuilder getBeginningOfTheLine(int level, boolean firstTime, boolean segmentCode00, boolean indexDataElt) {
        StringBuilder result = new StringBuilder(this.getBlankBeforeLabel());
        int l = this.getRealLevel(level, firstTime);
        int index = this.getIndexForCurrentLevel(l, segmentCode00);
        result.replace(index, index + 2, WFGenerationContext.getNCaractersNumeric(l, 2));
        return result;
    }

    public int getRealLevel(int level, boolean firstTime) {
        int l = level;
        if (firstTime) {
            l = this.getParam_ORG().equals("G") ? 4 : this.getParam_LEV();
        } else if (this.getParam_LEV() == 4) {
            l -= 8;
        } else if (this.getParam_LEV() == 5 || this.getParam_ORG().equals("O")) {
            l -= 9;
        } else if (!this.isGlobalContrib() && (this.getParam_ORG().equals("P") || this.getParam_ORG().equals("9") || this.getParam_ORG().equals("M") || this.getParam_ORG().equals("2") && !this.isDescrAllOption() && level != 49)) {
            l = 10;
        } else if (this.isGlobalContrib() && (this.getParam_ORG().equals("2") || this.getParam_ORG().equals("P") || this.getParam_ORG().equals("9") || this.getParam_ORG().equals("M"))) {
            l = 5;
        }
        return l;
    }

    public String getBlankBeforeLabel() {
        return "                          ";
    }

    public int getIndexForCurrentLevel(int level, boolean segmentCode00) {
        if (level == 1) {
            return 7;
        }
        if (level == 4 && this.getParam_ORG().equals("G")) {
            return 11;
        }
        if (level == 49 && (this.getParam_ORG().equals("2") || this.getParam_ORG().equals("Q") || this.getParam_ORG().equals("N"))) {
            return 14;
        }
        if (level == 5 && (this.getParam_ORG().equals("9") || this.getParam_ORG().equals("P") || this.getParam_ORG().equals("M"))) {
            return 10;
        }
        return 12;
    }

    private PacCDLineDataStructure getCdLine(PacProgramImpl pgm, String dsp) {
        if (pgm.getCDLines() != null && pgm.getCDLines().size() > 0) {
            for (Object obj : pgm.getCDLines()) {
                String codeInProg;
                if (!(obj instanceof PacCDLineDataStructure) || !dsp.equals(codeInProg = ((PacCDLineDataStructure)obj).getCommonDescription().getCodeInProgram())) continue;
                return (PacCDLineDataStructure)obj;
            }
        }
        return null;
    }

    public int getDa00Length() {
        return this.da00Length;
    }

    public void setDa00Length(int da00Length) {
        this.da00Length = da00Length;
    }

    public int getDaOccursNb() {
        return this.daOccursNb;
    }

    public void setDaOccursNb(int daOccursNb) {
        this.daOccursNb = daOccursNb;
    }

    public int getDaMaxLength() {
        return this.daMaxLength;
    }

    public void setDaMaxLength(int daMaxLength) {
        this.daMaxLength = daMaxLength;
    }

    public String getFirstSegment() {
        return this.firstSegment;
    }

    public void setFirstSegment(String firstSegment) {
        this.firstSegment = firstSegment;
    }

    public String getFirstSegmentCode() {
        return this.firstSegmentCode;
    }

    public void setFirstSegmentCode(String firstSegmentCode) {
        this.firstSegmentCode = firstSegmentCode;
    }

    public IMicroPattern getMicroPattern() {
        return this.microPattern;
    }

    public void setMicroPattern(IMicroPattern microPattern) {
        this.microPattern = microPattern;
    }

    public String getNewline() {
        return this.newLine;
    }

    public String getParam_BLC() {
        return this.param_BLC;
    }

    public void setParam_BLC(String param_BLC) {
        this.param_BLC = param_BLC;
    }

    public int getParam_DES() {
        return this.param_DES;
    }

    public void setParam_DES(int param_DES) {
        this.param_DES = param_DES;
    }

    public String getParam_DSL() {
        return this.param_DSL;
    }

    public void setParam_DSL(String param_DSL) {
        this.param_DSL = param_DSL;
    }

    public String getParam_DSP() {
        return this.param_DSP;
    }

    public void setParam_DSP(String param_DSP) {
        this.param_DSP = param_DSP;
    }

    public String getParam_FOR() {
        return this.param_FOR;
    }

    public void setParam_FOR(String param_FOR) {
        this.param_FOR = param_FOR;
    }

    public int getParam_LEV() {
        return this.param_LEV;
    }

    public void setParam_LEV(int param_LEV) {
        this.param_LEV = param_LEV;
    }

    public String getParam_ORG() {
        return this.param_ORG;
    }

    public void setParam_ORG(String param_ORG) {
        this.param_ORG = param_ORG;
    }

    public String getParam_PLT() {
        return this.param_PLT;
    }

    public void setParam_PLT(String param_PLT) {
        this.param_PLT = param_PLT;
    }

    public String getParam_SDSEL() {
        return this.param_SDSEL;
    }

    public void setParam_SDSEL(String param_SDSEL) {
        this.param_SDSEL = param_SDSEL;
    }

    public String getParam_SEL() {
        return this.param_SEL;
    }

    public void setParam_SEL(String param_SEL) {
        this.param_SEL = param_SEL;
    }

    public String getParam_SSC() {
        return this.param_SSC;
    }

    public void setParam_SSC(String param_SSC) {
        this.param_SSC = param_SSC;
    }

    public void setParam_PFX(String param_PFX) {
        this.param_PFX = param_PFX;
    }

    public String getParam_PFX() {
        return this.param_PFX;
    }

    public void setParam_SIP(String param_SIP) {
        this.param_SIP = param_SIP;
    }

    public String getParam_SIP() {
        return this.param_SIP;
    }

    public PacbasePattern getPattern() {
        return this.pattern;
    }

    public void setPattern(PacbasePattern pattern) {
        this.pattern = pattern;
    }

    public PacProgramStructureValues getProgramStructure() {
        return this.programStructure;
    }

    public void setProgramStructure(PacProgramStructureValues programStructure) {
        this.programStructure = programStructure;
    }

    public boolean isAtLeastOneSegment() {
        return this.isAtLeastOneSegment;
    }

    public void setAtLeastOneSegment(boolean isAtLeastOneSegment) {
        this.isAtLeastOneSegment = isAtLeastOneSegment;
    }

    public boolean isDescrAllOption() {
        return this.isDescrAllOption;
    }

    public void setDescAllOption(boolean isDescAll) {
        this.isDescrAllOption = isDescAll;
    }

    public boolean isExisting00() {
        return this.isExisting00;
    }

    public void setExisting00(boolean isExisting00) {
        this.isExisting00 = isExisting00;
    }

    public boolean isSegmentInFDClause() {
        return this.isSegmentInFDClause;
    }

    public boolean isMultiSegments() {
        return this.isMultiSegments;
    }

    public void setMultiSegments(List<String> segments) {
        this.isMultiSegments = false;
        int j = 0;
        while (!this.isMultiSegments && j + 1 < segments.size()) {
            if (!segments.get(j).substring(0, 4).equals(segments.get(j + 1).substring(0, 4))) {
                this.isMultiSegments = true;
            }
            ++j;
        }
    }

    public boolean isBreakdateOption() {
        return this.isBreakDateOption;
    }

    public void setBreakDateOption(boolean b) {
        this.isBreakDateOption = b;
    }

    public boolean isGlobalContrib() {
        return this.isGlobalContrib;
    }

    public void setGlobalContrib(boolean b) {
        this.isGlobalContrib = b;
    }

    public boolean isSegmentEmpty() {
        return this.isSegmentEmpty;
    }

    public void setSegmentEmpty(boolean b) {
        this.isSegmentEmpty = b;
    }

    public boolean isSQLIndicator() {
        return this.isSQLIndicator;
    }

    public void setSQLIndicator(boolean isSQLIndicator) {
        this.isSQLIndicator = isSQLIndicator;
    }

    public String getDB2KeyPrefix() {
        return "L";
    }

    public PacGeneratedDateFormatValues getGeneratedDateFormat() {
        return this.generatedDateFormat;
    }

    public void setGeneratedDateFormat(PacGeneratedDateFormatValues generatedDateFormat) {
        this.generatedDateFormat = generatedDateFormat;
    }

    public boolean getErrorOnParameters() {
        return this.errorRaised;
    }

    public String getSQLSegmentPrefixDash() {
        return this.isSQLIndicator() ? "-" : "";
    }

    public String getSQLSegmentPrefixDash1() {
        return this.getSQLSegmentPrefixDash();
    }

    protected String generateSDbeginning() {
        StringBuilder result = new StringBuilder();
        return result.toString();
    }

    public static boolean is00Selected(String sel) {
        return sel.indexOf("00") % 2 == 0;
    }

    public static String getNCaractersNumeric(int number, int numberOfCharacters) {
        String label = Integer.toString(number);
        int l = label.length();
        if (l == 6 && numberOfCharacters == 5) {
            numberOfCharacters = 6;
        }
        if (l > numberOfCharacters) {
            return label.substring(l - numberOfCharacters, l);
        }
        StringBuilder result = new StringBuilder();
        while (l < numberOfCharacters) {
            result.append("0");
            ++l;
        }
        result.append(label);
        return result.toString();
    }
}

