/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.extension.micropattern;

import com.ibm.pdp.engine.IMicroPattern;
import com.ibm.pdp.engine.IMicroPatternProcessingContext;
import com.ibm.pdp.explorer.editor.service.PTEditorService;
import com.ibm.pdp.pacbase.extension.micropattern.AbstractCommonMicroPatternHandler;
import com.ibm.pdp.pacbase.extension.micropattern.DescriptionContentAssistMP;
import com.ibm.pdp.pacbase.extension.micropattern.internal.SQLAndF80Utilities;
import com.ibm.pdp.pacbase.util.sql.AccessGeneratorInfosForSQL;
import com.ibm.pdp.pacbase.util.sql.GeneratorInfosForSQLEntities;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class SQLMicroPatternHandler
extends AbstractCommonMicroPatternHandler {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2019.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String MPSQL_IDENTIFIER = "SQL";
    public static final String SQL_DC_PROPERTY = "SQLDCMP";
    protected ArrayList<String> paramList = new ArrayList();
    protected AccessGeneratorInfosForSQL entInfos = null;

    public String getId() {
        return MPSQL_IDENTIFIER;
    }

    @Override
    public boolean isAnnotationsNeededInMacro() {
        return true;
    }

    public String getDescription() {
        return DescriptionContentAssistMP.SQLMicroPattern_DESCRIPTION;
    }

    protected void parametersTable(IMicroPattern microPattern) {
        String textInComment = this.operandes(microPattern);
        String paramLine = textInComment.substring(0).trim();
        if (paramLine.trim().length() == 0) {
            this.logWarning("Absence de param\u00e8tres", microPattern);
        } else {
            new ArrayList();
        }
        while (paramLine.trim().length() != 0) {
            String param;
            int index1 = paramLine.trim().indexOf(" ");
            int index2 = paramLine.trim().indexOf("\r\n");
            if (index1 != -1 && (index1 < index2 && index2 != -1 || index2 == -1)) {
                param = paramLine.trim().substring(0, index1);
                this.paramList.add(param);
                paramLine = paramLine.trim().substring(index1 + 1);
            }
            if (index2 != -1 && (index2 < index1 && index1 != -1 || index1 == -1)) {
                param = paramLine.trim().substring(0, index2);
                this.paramList.add(param);
                this.paramList.add("\r\n");
                paramLine = paramLine.replace("\r\n", "    ");
                paramLine = paramLine.trim().substring(index2 + 1);
            }
            if (index1 != -1 || index2 != -1) continue;
            param = paramLine.trim().substring(0);
            this.paramList.add(param);
            break;
        }
    }

    protected String writeAccess(AccessGeneratorInfosForSQL entityToGenerateInfos, IMicroPattern microPattern) {
        StringBuilder contrib = new StringBuilder();
        int resolMode = PTEditorService.getResolvingMode();
        if (entityToGenerateInfos.getGenInfos().isAccessValid()) {
            if (!entityToGenerateInfos.getGenInfos().isValidOnCDorCS()) {
                entityToGenerateInfos.getGenInfos().setMultiRow(false);
                this.logWarning("Segment non d\u00e9clar\u00e9 dans le -CD ou dans le -CS", microPattern);
                if (entityToGenerateInfos.getGenInfos().getDag() != null) {
                    if (entityToGenerateInfos.getGenInfos().isValidGG()) {
                        SQLAndF80Utilities.writeSpecificAccess(entityToGenerateInfos);
                    } else {
                        SQLAndF80Utilities.writeStandardAccess(entityToGenerateInfos);
                    }
                } else if (entityToGenerateInfos.getGenInfos().getPgm() != null) {
                    SQLAndF80Utilities.writeBeginEnd(entityToGenerateInfos);
                }
            } else if (entityToGenerateInfos.getGenInfos().isValidGG()) {
                SQLAndF80Utilities.writeSpecificAccess(entityToGenerateInfos);
            } else {
                SQLAndF80Utilities.writeStandardAccess(entityToGenerateInfos);
            }
            contrib.append(entityToGenerateInfos.getGenInfos().getMpaline().toString());
            PTEditorService.setResolvingMode((int)resolMode);
            return contrib.toString();
        }
        return "";
    }

    @Override
    protected void convertToAttributes(IMicroPattern microPattern, Map<String, Object> parameters) {
        super.convertToAttributes(microPattern, parameters);
        Object prmCsr = parameters.get("CSR");
        Object prmSe1 = parameters.get("SE1");
        Object prmAc1 = parameters.get("AC1");
        Object prmAc2 = parameters.get("AC2");
        StringBuilder buffer = new StringBuilder("");
        if (prmCsr != null && prmCsr instanceof String) {
            buffer.append(prmCsr).append(' ');
        }
        if (prmSe1 != null && prmSe1 instanceof String) {
            buffer.append(prmSe1).append(' ');
        }
        if (prmAc1 != null && prmAc1 instanceof String) {
            buffer.append(prmAc1).append(' ');
        }
        if (prmAc2 != null && prmAc2 instanceof String) {
            buffer.append(prmAc2);
        }
        microPattern.getAttributes().put("FIRST_ZONE", buffer.toString());
    }

    protected LinkedHashMap<String, String> convertToSQLBatchParameters(IMicroPattern microPattern, String operandes) {
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        GeneratorInfosForSQLEntities genInfos = this.entInfos.getGenInfos();
        parameters.put("CSR", genInfos.getCursorCode());
        parameters.put("SE1", genInfos.getSegmentCode());
        parameters.put("AC1", genInfos.getStandardAccess());
        if (genInfos.getNoStandardAccess().trim().length() > 0) {
            parameters.put("AC2", genInfos.getNoStandardAccess());
        }
        return parameters;
    }

    protected LinkedHashMap<String, String> convertToSQLTPParameters(IMicroPattern microPattern, String operandes) {
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        this.paramList = new ArrayList();
        this.parametersTable(microPattern);
        this.initialization(microPattern);
        String csr = this.paramList.get(0);
        String ac1 = this.paramList.get(1);
        String ac2 = "";
        if (this.paramList.size() > 2) {
            ac2 = this.paramList.get(2);
        }
        parameters.put("CSR", csr);
        parameters.put("AC1", ac1);
        parameters.put("AC2", ac2);
        return parameters;
    }

    protected abstract void getParam(ArrayList<String> var1);

    protected abstract void initialization(IMicroPattern var1);

    protected String[] modifyOperandes(List<String> operandes, IMicroPatternProcessingContext context) {
        Iterator<String> it = operandes.iterator();
        ArrayList<String> result = new ArrayList<String>();
        String nl = SQLMicroPatternHandler.GetProperty_NEW_LINE(context);
        while (it.hasNext()) {
            String item = it.next();
            int index = item.indexOf(nl);
            while (index != -1) {
                result.add(item.substring(0, index));
                item = item.substring(index + nl.length());
                index = item.indexOf(nl);
            }
            result.add(item);
        }
        String[] tokens = new String[result.size()];
        tokens = result.toArray(tokens);
        return tokens;
    }
}

