/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.extension.micropattern;

import com.ibm.pdp.engine.IMicroPattern;
import com.ibm.pdp.pacbase.extension.micropattern.AbstractSimpleMicroPatternHandler;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class PMicroPatternHandler
extends AbstractSimpleMicroPatternHandler {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2019.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String MPP_IDENTIFIER = "P";

    public String getId() {
        return MPP_IDENTIFIER;
    }

    @Override
    protected void handleLocal(IMicroPattern microPattern, StringBuilder contribution) {
        String etiquetteFin;
        String etiquetteDebut;
        String param1 = "";
        String textInComment = this.operandes(microPattern);
        if (textInComment == null) {
            return;
        }
        param1 = textInComment.trim();
        int index1 = param1.indexOf(" ");
        if (index1 == -1) {
            etiquetteDebut = param1;
            etiquetteFin = String.valueOf(param1) + "-FN";
        } else {
            etiquetteDebut = param1.substring(0, index1);
            etiquetteFin = param1.substring(index1 + 1).trim();
        }
        contribution.append("           PERFORM     ");
        contribution.append(etiquetteDebut);
        contribution.append(" THRU ");
        contribution.append(etiquetteFin);
        contribution.append(PMicroPatternHandler.GetProperty_NEW_LINE(microPattern.getProcessingContext()));
    }

    @Override
    protected void convertToAttributes(IMicroPattern microPattern, Map<String, Object> parameters) {
        super.convertToAttributes(microPattern, parameters);
        Object prmLbl = parameters.get("LBL");
        Object prmSfx = parameters.get("SFX");
        StringBuilder buffer = new StringBuilder("");
        if (prmLbl instanceof String) {
            buffer.append(prmLbl);
        }
        if (prmSfx instanceof String) {
            buffer.append(' ').append(prmSfx);
        }
        microPattern.getAttributes().put("FIRST_ZONE", buffer.toString());
    }

    @Override
    protected LinkedHashMap<String, String> convertToParameters(IMicroPattern microPattern, String operandes) {
        List<String> oper = this.analyseOperande(this.operandes(microPattern), microPattern.getProcessingContext());
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        String parsfx = "";
        if (oper.size() != 0) {
            String parlbl = oper.get(0);
            parameters.put("LBL", parlbl);
            int i = 1;
            while (i < oper.size()) {
                parsfx = i == 1 ? String.valueOf(parsfx) + oper.get(i) : String.valueOf(parsfx) + " " + oper.get(i);
                ++i;
            }
        }
        if (parsfx != "") {
            parameters.put("SFX", parsfx);
        }
        parameters.putAll(super.convertToParameters(microPattern, operandes));
        return parameters;
    }
}

