/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.extension.micropattern;

import com.ibm.pdp.engine.IMicroPatternGenerationExtension;
import com.ibm.pdp.engine.IMicroPatternProcessingContext;
import com.ibm.pdp.explorer.editor.service.PTEditorService;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.pacbase.PacDialog;
import com.ibm.pdp.mdl.pacbase.PacDialogServer;
import com.ibm.pdp.mdl.pacbase.PacLibrary;
import com.ibm.pdp.mdl.pacbase.PacProgram;
import com.ibm.pdp.mdl.pacbase.PacScreen;
import com.ibm.pdp.mdl.pacbase.PacServer;
import com.ibm.pdp.mdl.pacbase.impl.PacGLineImpl;
import com.ibm.pdp.mdl.pacbase.util.PacDialogWrapper;
import com.ibm.pdp.mdl.pacbase.util.PacProgramWrapper;
import com.ibm.pdp.mdl.pacbase.util.PacScreenWrapper;
import com.ibm.pdp.mdl.pacbase.util.PacServerWrapper;
import com.ibm.pdp.pacbase.design.ModelUtil;
import com.ibm.pdp.pacbase.extension.micropattern.AbstractCommonMicroPatternHandler;
import java.util.HashSet;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public abstract class MicroPatternGeneration
implements IMicroPatternGenerationExtension {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2011, 2016.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    int currentMode;
    public static final String IN_MEMRORY_ENTITIES = "inMemoryEntities";

    protected RadicalEntity getGenerationEntryPoint(IMicroPatternProcessingContext context) {
        RadicalEntity obj;
        String design;
        if (context.getGenerationProperties() != null && (design = context.getGenerationProperties().getProperty("DESIGN_PATH")) != null && (obj = ModelUtil.getSharedRadicalEntity((IPath)new Path(design))) != null) {
            return obj;
        }
        return null;
    }

    public void start(IMicroPatternProcessingContext context) {
        this.currentMode = PTEditorService.getResolvingMode();
        PTEditorService.setResolvingMode((int)3);
        if (context.getGenerationProperties() != null) {
            RadicalEntity re = this.getGenerationEntryPoint(context);
            context.setData("DESIGN_FILE_IN_CONTEXT", (Object)re);
            context.setData("BREAKDATE_OPTION", (Object)this.SearchBreakdateOption(re));
            context.setAttribute("ALPHANUMERIC_DELIMITER", this.searchAlphanumericDelimiterFor(re));
            context.setData("SKELETON", (Object)AbstractCommonMicroPatternHandler.SearchGeneratedSkeletonLanguageFor(re, null));
            context.setData(IN_MEMRORY_ENTITIES, new HashSet());
        }
    }

    public void end(IMicroPatternProcessingContext context) {
        HashSet list = (HashSet)context.getData(IN_MEMRORY_ENTITIES);
        if (list != null) {
            list.clear();
        }
        PTEditorService.setResolvingMode((int)this.currentMode);
    }

    protected abstract String searchAlphanumericDelimiterFor(RadicalEntity var1);

    private boolean SearchBreakdateOption(RadicalEntity re) {
        PacLibrary lib = null;
        switch (re.eClass().getClassifierID()) {
            case 39: {
                PacDialogServer p = new PacProgramWrapper((PacProgram)re);
                lib = p.getGenerationParameter();
                for (PacGLineImpl pgl : p.getGOLines()) {
                    if (pgl.getLineType().equals("O") && pgl.getDescription().trim().contains("BREAKDATE=YES")) {
                        return true;
                    }
                    if (!pgl.getLineType().equals("O") || !pgl.getDescription().trim().contains("BREAKDATE=NO")) continue;
                    return false;
                }
                break;
            }
            case 70: {
                PacDialogServer p = new PacScreenWrapper((PacScreen)re);
                lib = p.getGenerationParameter();
                for (PacGLineImpl pgl : p.getGOLines()) {
                    if (!pgl.getLineType().equals("O") || !pgl.getDescription().trim().contains("BREAKDATE=YES")) continue;
                    return true;
                }
                for (PacGLineImpl pgl : p.getDialog().getGOLines()) {
                    if (!pgl.getLineType().equals("O") || !pgl.getDescription().trim().contains("BREAKDATE=YES")) continue;
                    return true;
                }
                break;
            }
            case 72: {
                PacDialogServer p = new PacDialogWrapper((PacDialog)re);
                lib = p.getGenerationParameter();
                for (PacGLineImpl pgl : p.getGOLines()) {
                    if (!pgl.getLineType().equals("O") || !pgl.getDescription().trim().contains("BREAKDATE=YES")) continue;
                    return true;
                }
                break;
            }
            case 99: {
                PacDialogServer p = (PacDialogServer)re;
                lib = p.getGenerationParameter();
                for (PacGLineImpl pgl : p.getGOLines()) {
                    if (!pgl.getLineType().equals("O") || !pgl.getDescription().trim().contains("BREAKDATE=YES")) continue;
                    return true;
                }
                break;
            }
            case 101: {
                PacDialogServer p = new PacServerWrapper((PacServer)re);
                lib = p.getGenerationParameter();
                for (PacGLineImpl pgl : p.getGOLines()) {
                    if (!pgl.getLineType().equals("O") || !pgl.getDescription().trim().contains("BREAKDATE=YES")) continue;
                    return true;
                }
                for (PacGLineImpl pgl : p.getDialog().getGOLines()) {
                    if (!pgl.getLineType().equals("O") || !pgl.getDescription().trim().contains("BREAKDATE=YES")) continue;
                    return true;
                }
                break;
            }
        }
        if (lib == null) {
            return false;
        }
        for (PacGLineImpl pgl : lib.getGOLines()) {
            if (!pgl.getLineType().equals("O") || !pgl.getDescription().trim().contains("BREAKDATE=YES")) continue;
            return true;
        }
        return false;
    }
}

