/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.extension.micropattern;

import com.ibm.pdp.engine.IGenInfoBuilder;
import com.ibm.pdp.engine.IMicroPattern;
import com.ibm.pdp.engine.IMicroPatternProcessingContext;
import com.ibm.pdp.pacbase.extension.micropattern.AbstractCommonMicroPatternHandler;
import com.ibm.pdp.pacbase.extension.micropattern.DescriptionContentAssistMP;
import com.ibm.pdp.pacbase.extension.micropattern.internal.UniqueWLineMP;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class MCIMicroPatternHandler
extends AbstractCommonMicroPatternHandler {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2016, 2019.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String MPMCI_IDENTIFIER = "MCI";

    public String getId() {
        return MPMCI_IDENTIFIER;
    }

    @Override
    protected String handleLocalFragment(IMicroPattern microPattern, IGenInfoBuilder genInfoBuilder) {
        StringBuilder gen = new StringBuilder();
        IMicroPatternProcessingContext context = microPattern.getProcessingContext();
        String delim = MCIMicroPatternHandler.GetProperty_NEW_LINE(context);
        List<String> operandes = this.analyseOperande(this.operandes(microPattern), context);
        List<String> listGroup = this.decoupageOperande(operandes, context);
        int beg = genInfoBuilder.tagFromName("PROCEDURE").getBeginIndex();
        String text = genInfoBuilder.getText().subSequence(0, beg).toString();
        StringTokenizer st = new StringTokenizer(text, delim);
        String group1ToSearch = " " + listGroup.get(0);
        String group2ToSearch = " " + listGroup.get(2);
        String levelGroup1 = null;
        String levelGroup2 = null;
        String lastDataElementCode = "";
        boolean inGroup1 = false;
        boolean inGroup2 = false;
        ArrayList<UniqueWLineMP> listElementaryZoneGroup1 = new ArrayList<UniqueWLineMP>();
        HashMap<String, UniqueWLineMP> listElementaryZoneGroup2 = new HashMap<String, UniqueWLineMP>();
        while (st.hasMoreTokens()) {
            String level;
            String line = st.nextToken();
            if (line.charAt(6) == '*') continue;
            String levelLine = null;
            boolean lineWithLevel = true;
            try {
                Integer.parseInt(line.trim().substring(0, 2));
                levelLine = line.trim().substring(0, 2);
            }
            catch (NumberFormatException numberFormatException) {
                lineWithLevel = false;
            }
            if (!lineWithLevel) continue;
            if (inGroup1 && levelGroup1.compareTo(levelLine) >= 0) {
                inGroup1 = false;
            }
            if (inGroup2 && levelGroup2.compareTo(levelLine) >= 0) {
                inGroup2 = false;
            }
            if (levelGroup1 == null && !inGroup2) {
                lastDataElementCode = "";
                if (line.indexOf(group1ToSearch) != -1) {
                    if (line.contains("-CF ")) continue;
                    UniqueWLineMP lineG1 = new UniqueWLineMP(line, MCIMicroPatternHandler.GetProperty_NEW_LINE(context), false);
                    levelGroup1 = lineG1.getLevel();
                    if (levelGroup1 == null) {
                        levelGroup1 = line.trim().substring(0, 2);
                    }
                    inGroup1 = true;
                    inGroup2 = false;
                    continue;
                }
            }
            if (levelGroup2 == null && !inGroup1) {
                lastDataElementCode = "";
                if (line.indexOf(group2ToSearch) != -1) {
                    if (line.contains("-CF ")) continue;
                    UniqueWLineMP lineG2 = new UniqueWLineMP(line, MCIMicroPatternHandler.GetProperty_NEW_LINE(context), false);
                    levelGroup2 = lineG2.getLevel();
                    if (levelGroup2 == null) {
                        levelGroup2 = line.trim().substring(0, 2);
                    }
                    inGroup2 = true;
                    inGroup1 = false;
                    continue;
                }
            }
            if (inGroup1) {
                UniqueWLineMP lineAfterG1 = new UniqueWLineMP(line, MCIMicroPatternHandler.GetProperty_NEW_LINE(context), false);
                level = lineAfterG1.getLevel();
                if (level == null || "FILLER".equals(lineAfterG1.getDataElementCode())) continue;
                if (level != null && levelGroup1.compareTo(level) < 0 && !lastDataElementCode.equals(lineAfterG1.getDataElementCode())) {
                    listElementaryZoneGroup1.add(lineAfterG1);
                    lastDataElementCode = lineAfterG1.getDataElementCode();
                }
            }
            if (inGroup2) {
                UniqueWLineMP lineAfterG2 = new UniqueWLineMP(line, MCIMicroPatternHandler.GetProperty_NEW_LINE(context), false);
                level = lineAfterG2.getLevel();
                if (level == null || "FILLER".equals(lineAfterG2.getDataElementCode())) continue;
                if (levelGroup2.compareTo(level) > 0) {
                    inGroup2 = false;
                }
                if (level != null && levelGroup2.compareTo(level) < 0) {
                    listElementaryZoneGroup2.put(lineAfterG2.getDataElementCode(), lineAfterG2);
                }
            }
            if (!inGroup1 && !inGroup2 && levelGroup1 != null && levelGroup2 != null) break;
        }
        int i = 0;
        while (i < listElementaryZoneGroup1.size()) {
            String dataElementcode = ((UniqueWLineMP)listElementaryZoneGroup1.get(i)).getDataElementCode();
            if (listElementaryZoneGroup2.containsKey(dataElementcode)) {
                gen.append((CharSequence)this.addFormattedCobolLineWithoutNewLine("     MOVE "));
                gen.append(((UniqueWLineMP)listElementaryZoneGroup1.get(i)).getCompleteZone());
                if (!listGroup.get(1).equals(" ")) {
                    gen.append(listGroup.get(1));
                }
                gen.append(" TO ");
                gen.append(((UniqueWLineMP)listElementaryZoneGroup2.get(dataElementcode)).getCompleteZone());
                if (!listGroup.get(3).equals(" ")) {
                    gen.append(listGroup.get(3));
                }
                gen.append(delim);
            }
            ++i;
        }
        return gen.toString();
    }

    protected List<String> decoupageOperande(List<String> content, IMicroPatternProcessingContext context) {
        ArrayList<String> res = new ArrayList<String>();
        String group1 = null;
        String occurs1 = " ";
        String group2 = null;
        String occurs2 = " ";
        if (content.size() == 2) {
            group1 = content.get(0);
            int indParOuv = group1.indexOf("(");
            if (indParOuv != -1) {
                occurs1 = group1.substring(indParOuv);
                group1 = group1.substring(0, indParOuv).trim();
            }
            if ((indParOuv = (group2 = content.get(1)).indexOf("(")) != -1) {
                occurs2 = group2.substring(indParOuv);
                group2 = group2.substring(0, indParOuv).trim();
            }
            res.add(group1);
            res.add(occurs1);
            res.add(group2);
            res.add(occurs2);
        }
        return res;
    }

    @Override
    protected void addOtherFragments(IMicroPattern microPattern, IGenInfoBuilder genInfoBuilder) {
    }

    @Override
    public boolean isAnnotationsNeededInMacro() {
        return true;
    }

    public String getDescription() {
        return DescriptionContentAssistMP.MCIMicroPattern_DESCRIPTION;
    }

    @Override
    protected void convertToAttributes(IMicroPattern microPattern, Map<String, Object> parameters) {
        super.convertToAttributes(microPattern, parameters);
        Object prmpr1 = parameters.get("PR1");
        Object prmpr2 = parameters.get("PR2");
        StringBuilder buffer = new StringBuilder("");
        if (prmpr1 instanceof String) {
            buffer.append(prmpr1);
        }
        if (prmpr2 instanceof String) {
            buffer.append(' ').append(prmpr2);
        }
        microPattern.getAttributes().put("FIRST_ZONE", buffer.toString());
    }

    @Override
    protected LinkedHashMap<String, String> convertToParameters(IMicroPattern microPattern, String operandes) {
        List<String> oper = this.analyseOperande(this.operandes(microPattern), microPattern.getProcessingContext());
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        parameters.put("PR1", oper.get(0));
        parameters.put("PR2", oper.get(1));
        parameters.putAll(super.convertToParameters(microPattern, operandes));
        return parameters;
    }
}

