/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.extension.micropattern;

import com.ibm.pdp.engine.IMicroPattern;
import com.ibm.pdp.pacbase.extension.micropattern.AbstractGOTOMicroPatternhandler;
import java.util.LinkedHashMap;
import java.util.Map;

public class GBMicroPatternHandler
extends AbstractGOTOMicroPatternhandler {
    public static final String MPGB_IDENTIFIER = "GB";
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2019.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public String getId() {
        return MPGB_IDENTIFIER;
    }

    @Override
    protected String endOfGeneration() {
        return "-900";
    }

    @Override
    protected void convertToAttributes(IMicroPattern microPattern, Map<String, Object> parameters) {
        super.convertToAttributes(microPattern, parameters);
        Object prmLvl = parameters.get("LVL");
        Object prmDot = parameters.get("DOT");
        if (prmLvl instanceof String) {
            microPattern.getAttributes().put("FIRST_ZONE", (String)prmLvl);
        }
        if (prmDot != null) {
            microPattern.getAttributes().put("DOT", prmDot.toString());
        }
    }

    @Override
    protected LinkedHashMap<String, String> convertToParameters(IMicroPattern microPattern, String operandes) {
        try {
            LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
            Integer.parseInt(this.operandes(microPattern));
            parameters.put("LVL", operandes);
            if (microPattern.getAttribute("DOT") != null) {
                parameters.put("DOT", microPattern.getAttribute("DOT"));
            }
            parameters.putAll(super.convertToParameters(microPattern, operandes));
            return parameters;
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }
}

