/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.extension.micropattern;

import com.ibm.pdp.engine.IBuilderTag;
import com.ibm.pdp.engine.IGenInfoBuilder;
import com.ibm.pdp.engine.IMicroPattern;
import com.ibm.pdp.engine.IMicroPatternFilter;
import com.ibm.pdp.engine.IMicroPatternProcessingContext;
import com.ibm.pdp.framework.PdpTool;
import com.ibm.pdp.framework.cobol.micropattern.internal.MicroPatternConstants;
import com.ibm.pdp.pacbase.extension.micropattern.AbstractCommonMicroPatternHandler;
import com.ibm.pdp.pacbase.extension.micropattern.AbstractMicroPatternFilter;
import com.ibm.pdp.pacbase.extension.micropattern.DateAndTimeMicroPatternHandler;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class DateAndTimeWorkingMicroPatternFilter
extends AbstractMicroPatternFilter
implements IMicroPatternFilter,
MicroPatternConstants {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2017.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static Map<DateAndTimeMicroPatternHandler.TagNameAndLevel, String> StringFromNameAndLevel = new HashMap<DateAndTimeMicroPatternHandler.TagNameAndLevel, String>();

    public static int[] SearchIndicesForWorkingPart(String text, DateAndTimeMicroPatternHandler.TagNameAndLevel tagNameAndLevel, int beginningIndexToSearchFrom, DateAndTimeMicroPatternHandler.TagNameAndLevel[] allLevels, String newLine) {
        int[] res = new int[]{-1, -1};
        int tmpIndex = text.indexOf(DateAndTimeWorkingMicroPatternFilter.SearchPartName(tagNameAndLevel), beginningIndexToSearchFrom);
        if (tmpIndex != -1) {
            boolean found;
            res[0] = tmpIndex;
            tmpIndex = text.indexOf(newLine, tmpIndex);
            int next01 = text.indexOf("       01 ", tmpIndex);
            int currentIndex = DateAndTimeMicroPatternHandler.SearchRank(tagNameAndLevel, allLevels);
            boolean bl = found = currentIndex == -1;
            if (found) {
                tmpIndex = next01;
            }
            int i = currentIndex;
            while (!found && i < allLevels.length) {
                int current = text.indexOf(DateAndTimeWorkingMicroPatternFilter.SearchPartName(allLevels[i]), tmpIndex);
                if (current != -1) {
                    tmpIndex = current;
                    found = true;
                }
                ++i;
            }
            if (!found) {
                int anotherIndex;
                tmpIndex = text.indexOf("       01 ", tmpIndex);
                if (tagNameAndLevel == DateAndTimeMicroPatternHandler.LEVEL_01_TABDAT && (anotherIndex = text.indexOf("TABBI1", res[0])) != -1) {
                    tmpIndex = text.indexOf(newLine, anotherIndex) + newLine.length();
                }
            } else {
                tmpIndex = Math.min(tmpIndex, next01);
            }
            res[1] = tmpIndex = DateAndTimeWorkingMicroPatternFilter.SearchCommentBefore(text, tmpIndex, newLine);
        }
        return res;
    }

    public static String SearchPartName(DateAndTimeMicroPatternHandler.TagNameAndLevel partName) {
        if (StringFromNameAndLevel.containsKey(partName)) {
            return StringFromNameAndLevel.get(partName);
        }
        String result = "       0" + partName.getLevel() + (partName == DateAndTimeMicroPatternHandler.LEVEL_01_TT_DAT ? "   " : "  ") + partName.getName();
        if (partName.getLevel() == 5) {
            result = "  " + result + " ";
        }
        if (partName.equals(DateAndTimeMicroPatternHandler.LEVEL_01_DAT6) || partName.equals(DateAndTimeMicroPatternHandler.LEVEL_01_DAT7) || partName.equals(DateAndTimeMicroPatternHandler.LEVEL_01_DAT8)) {
            result = String.valueOf(result) + ".";
        }
        StringFromNameAndLevel.put(partName, result);
        return result;
    }

    public static int SearchCommentBefore(String text, int index, String newLine) {
        String tmpString = index > 80 ? text.substring(index - 80, index) : text.substring(0, index);
        int lastNewLine = tmpString.lastIndexOf(newLine);
        if (lastNewLine == -1) {
            return index;
        }
        if ((tmpString = tmpString.substring(0, lastNewLine)).lastIndexOf(newLine) != -1) {
            lastNewLine = tmpString.lastIndexOf(newLine) + newLine.length();
            tmpString = tmpString.substring(lastNewLine);
        }
        if (tmpString.startsWith("      *")) {
            return DateAndTimeWorkingMicroPatternFilter.SearchCommentBefore(text, index - tmpString.length() - newLine.length(), newLine);
        }
        return index;
    }

    public List<IMicroPattern> filters(List<IMicroPattern> microPatterns, IMicroPatternProcessingContext context) {
        int beginIndexForText;
        IGenInfoBuilder genInfoBuilder = context.getGeneratedInfo().toGeneratedInfoBuilder();
        IBuilderTag current = genInfoBuilder.tagFromName("WSS-CONTINUATION");
        if (current == null) {
            return microPatterns;
        }
        int realBeginIndex = beginIndexForText = current.getBeginIndex();
        String text = current.getText().toString();
        if (text.length() == 0) {
            context.setAttribute("NEW_LINE_CHARACTER", System.getProperty("line.separator"));
            return microPatterns;
        }
        String newLine = PdpTool.determineDelimiterOfV2((CharSequence)text);
        context.setAttribute("NEW_LINE_CHARACTER", newLine);
        current = this.searchFirstTag(genInfoBuilder);
        int index = 0;
        if (current == null) {
            index = text.indexOf("       01  DATCE.");
            realBeginIndex = beginIndexForText + index;
            index = text.indexOf(newLine, index);
            index = text.indexOf("       01 ", index);
            current = this.createFirstTag(genInfoBuilder, realBeginIndex, beginIndexForText + (index = DateAndTimeWorkingMicroPatternFilter.SearchCommentBefore(text, index, newLine)));
            if (current == null) {
                return microPatterns;
            }
            current.setProperty("hidden", "true");
            current.setProperty("mp", current.getName());
        } else {
            index = current.getEndIndex() - beginIndexForText;
            current.setProperty("hidden", "true");
        }
        int current01 = 1;
        while (current01 < this.getAllLevels().length) {
            String tagName = "DATE_WORKING_" + this.getAllLevels()[current01].getName();
            current = genInfoBuilder.tagFromName(tagName);
            if (current == null) {
                int[] res = DateAndTimeWorkingMicroPatternFilter.SearchIndicesForWorkingPart(text, this.getAllLevels()[current01], index, this.getAllLevels(), newLine);
                if (res[0] != -1 && (current = genInfoBuilder.includingTag(beginIndexForText + res[0], beginIndexForText + res[1])).getProperty("SpecificTag") == null) {
                    current = AbstractCommonMicroPatternHandler.AddTag(genInfoBuilder, beginIndexForText + res[0], beginIndexForText + res[1], tagName, "WSS-CONTINUATION");
                    current.setProperty("hidden", "true");
                }
            } else {
                current.setProperty("hidden", "true");
            }
            ++current01;
        }
        microPatterns = this.specialTreatment(microPatterns, context);
        return microPatterns;
    }

    public List<IMicroPattern> specialTreatment(List<IMicroPattern> microPatterns, IMicroPatternProcessingContext context) {
        return microPatterns;
    }

    public abstract IBuilderTag searchFirstTag(IGenInfoBuilder var1);

    public abstract IBuilderTag createFirstTag(IGenInfoBuilder var1, int var2, int var3);

    public abstract DateAndTimeMicroPatternHandler.TagNameAndLevel[] getAllLevels();
}

