/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.extension.micropattern;

import com.ibm.pdp.engine.IBuilderTag;
import com.ibm.pdp.engine.IGenInfoBuilder;
import com.ibm.pdp.engine.IMicroPattern;
import com.ibm.pdp.engine.IMicroPatternProcessingContext;
import com.ibm.pdp.mdl.kernel.DataElement;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.pacbase.PacAbstractDialogServer;
import com.ibm.pdp.mdl.pacbase.PacGLine;
import com.ibm.pdp.mdl.pacbase.PacGeneratedDateFormatValues;
import com.ibm.pdp.mdl.pacbase.lal.util.GenerationContext;
import com.ibm.pdp.mdl.pacbase.lal.util.LengthAndPositionVisitor;
import com.ibm.pdp.mdl.pacbase.lal.util.PacbaseLalDescription;
import com.ibm.pdp.micropattern.analyzer.tool.MPDesignReference;
import com.ibm.pdp.micropattern.pacbase.analyzer.AbstractPacAnalyzer;
import com.ibm.pdp.pacbase.extension.micropattern.AbstractCommonMicroPatternHandler;
import com.ibm.pdp.pacbase.extension.micropattern.DateAndTimeWorkingMicroPatternFilter;
import com.ibm.pdp.pacbase.extension.micropattern.Messages;
import com.ibm.pdp.pacbase.extension.micropattern.internal.WorkingData;
import com.ibm.pdp.pacbase.util.EBCDICCompare;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;

public abstract class DateAndTimeMicroPatternHandler
extends AbstractCommonMicroPatternHandler {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2023.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected static final String _YNULL_KEY = "_YNULL";
    protected static final String _XNULL_KEY = "_XNULL";
    protected static final String DATPRO_OPTION_NAME = "DATPRO";
    public static final String MP_ID = "AD";
    protected static final String DATE_FORMATS_LIST = "I D E S C M G";
    protected static final String DATE_SEPARATOR = "DATSEP";
    private static final HashMap<String, String> workAreaNames = new HashMap(10);
    public static final String VARIABLE_TAG_NAME_BEGINING = "DATE_WORKING_";
    public static final TagNameAndLevel LEVEL_01_DATCE;
    public static final TagNameAndLevel LEVEL_01_DAT6;
    public static final TagNameAndLevel LEVEL_01_DAT8;
    public static final TagNameAndLevel LEVEL_01_DAT8E;
    public static final TagNameAndLevel LEVEL_01_DAT6C;
    public static final TagNameAndLevel LEVEL_01_DAT8C;
    public static final TagNameAndLevel LEVEL_01_TIMCO;
    public static final TagNameAndLevel LEVEL_01_TIMDAY;
    public static final TagNameAndLevel LEVEL_01_DAT7;
    public static final TagNameAndLevel LEVEL_01_DATSEP;
    public static final TagNameAndLevel LEVEL_01_DATSET;
    public static final TagNameAndLevel LEVEL_01_DATSEW;
    public static final TagNameAndLevel LEVEL_01_DAT_TRANS;
    public static final TagNameAndLevel LEVEL_01_DATCTY;
    public static final TagNameAndLevel LEVEL_01_DAT7C;
    public static final TagNameAndLevel LEVEL_01_DAT8G;
    public static final TagNameAndLevel LEVEL_01_TT_DAT;
    public static final TagNameAndLevel LEVEL_01_TIMCIC;
    public static final TagNameAndLevel LEVEL_01_TIMCI1;
    public static final TagNameAndLevel LEVEL_01_DATCIC;
    public static final TagNameAndLevel LEVEL_01_DATQTM;
    public static final TagNameAndLevel LEVEL_01_TABDAT;
    public static final TagNameAndLevel LEVEL_01_LEAP_YEAR;
    public static final TagNameAndLevel LEVEL_05_DAT_CTYT;
    public static final TagNameAndLevel LEVEL_05_DAT_CTY;
    public static final TagNameAndLevel LEVEL_05_DAT_ADO;
    public static final TagNameAndLevel LEVEL_05_DATE8S;
    public static final TagNameAndLevel LEVEL_05_DATE81;
    public static final TagNameAndLevel LEVEL_05_DATE82;
    public static final TagNameAndLevel LEVEL_05_NUMDAYS;
    public static final String FUNCTION_DATE_CONVERT = "FUNCTION_DATE_CONVERT";
    public static final String FUNCTION_DATE_ER = "FUNCTION_DATE_ER";

    static {
        workAreaNames.put(_XNULL_KEY, "DAT1");
        workAreaNames.put(_YNULL_KEY, "DAT2");
        workAreaNames.put("I", "DAT6");
        workAreaNames.put("D", "DAT7");
        workAreaNames.put("E", "DAT8");
        workAreaNames.put("S", "DAT6C");
        workAreaNames.put("C", "DAT7C");
        workAreaNames.put("M", "DAT8C");
        workAreaNames.put("G", "DAT8G");
        LEVEL_01_DATCE = new TagNameAndLevel("DATCE", 1, WorkingParts.DATCE);
        LEVEL_01_DAT6 = new TagNameAndLevel("DAT6", 1, WorkingParts.DAT6);
        LEVEL_01_DAT8 = new TagNameAndLevel("DAT8", 1, WorkingParts.DAT8);
        LEVEL_01_DAT8E = new TagNameAndLevel("DAT8E", 1, WorkingParts.DAT8E);
        LEVEL_01_DAT6C = new TagNameAndLevel("DAT6C", 1, WorkingParts.DAT6C);
        LEVEL_01_DAT8C = new TagNameAndLevel("DAT8C", 1, WorkingParts.DAT8C);
        LEVEL_01_TIMCO = new TagNameAndLevel("TIMCO", 1, WorkingParts.TIMCO);
        LEVEL_01_TIMDAY = new TagNameAndLevel("TIMDAY", 1, WorkingParts.TIMDAY);
        LEVEL_01_DAT7 = new TagNameAndLevel("DAT7", 1, WorkingParts.DAT7);
        LEVEL_01_DATSEP = new TagNameAndLevel(DATE_SEPARATOR, 1, WorkingParts.DATSEP);
        LEVEL_01_DATSET = new TagNameAndLevel("DATSET", 1, WorkingParts.DATSET);
        LEVEL_01_DATSEW = new TagNameAndLevel("DATSEW", 1, WorkingParts.DATSEW);
        LEVEL_01_DAT_TRANS = new TagNameAndLevel("DAT-TRANS", 1, WorkingParts.DAT_TRANS);
        LEVEL_01_DATCTY = new TagNameAndLevel("DATCTY", 1, WorkingParts.DATCTY);
        LEVEL_01_DAT7C = new TagNameAndLevel("DAT7C", 1, WorkingParts.DAT7C);
        LEVEL_01_DAT8G = new TagNameAndLevel("DAT8G", 1, WorkingParts.DAT8G);
        LEVEL_01_TT_DAT = new TagNameAndLevel("TT-DAT", 1, WorkingParts.TT_DAT);
        LEVEL_01_TIMCIC = new TagNameAndLevel("TIMCIC", 1, WorkingParts.TIMCIC);
        LEVEL_01_TIMCI1 = new TagNameAndLevel("TIMCI1", 1, WorkingParts.TIMCI1);
        LEVEL_01_DATCIC = new TagNameAndLevel("DATCIC", 1, WorkingParts.DATCIC);
        LEVEL_01_DATQTM = new TagNameAndLevel("DATQTM", 1, WorkingParts.DATQTM);
        LEVEL_01_TABDAT = new TagNameAndLevel("TABDAT", 1, WorkingParts.TABDAT);
        LEVEL_01_LEAP_YEAR = new TagNameAndLevel("LEAP-YEAR", 1, WorkingParts.LEAP_YEAR);
        LEVEL_05_DAT_CTYT = new TagNameAndLevel("DAT-CTYT", 5, WorkingParts.DAT_CTYT);
        LEVEL_05_DAT_CTY = new TagNameAndLevel("DAT-CTY", 5, WorkingParts.DAT_CTY);
        LEVEL_05_DAT_ADO = new TagNameAndLevel("DAT-ADO", 5, WorkingParts.DAT_ADO);
        LEVEL_05_DATE8S = new TagNameAndLevel("DATE8S", 5, WorkingParts.DATE8S);
        LEVEL_05_DATE81 = new TagNameAndLevel("DATE81", 5, WorkingParts.DATE81);
        LEVEL_05_DATE82 = new TagNameAndLevel("DATE82", 5, WorkingParts.DATE82);
        LEVEL_05_NUMDAYS = new TagNameAndLevel("NUM-DAYS", 5, WorkingParts.NUM_DAYS);
    }

    protected static HashMap<String, String> getWorkAreaNames() {
        return workAreaNames;
    }

    @Override
    public boolean isAnnotationsNeededInMacro() {
        return true;
    }

    public String getId() {
        return MP_ID;
    }

    protected abstract String addSpecificLocalFragment(String var1, String var2, String var3, IMicroPatternProcessingContext var4);

    @Override
    protected String handleLocalFragment(IMicroPattern microPattern, IGenInfoBuilder genInfoBuilder) {
        String dat2Format;
        String dat1Format;
        List<String> operandes = this.analyseOperande(this.operandes(microPattern), microPattern.getProcessingContext());
        String alphanumeric_Delimiter = DateAndTimeMicroPatternHandler.GetProperty_ALPHA_NUMERIC_DELIMITER(microPattern.getProcessingContext());
        String newLine = DateAndTimeMicroPatternHandler.GetProperty_NEW_LINE(microPattern.getProcessingContext());
        String lastOperandeInNewLine = null;
        if (operandes.size() < 1 || operandes.size() > 3) {
            if (operandes.size() == 4 && microPattern.getOriginalHeaderDeclaration().contains(newLine)) {
                lastOperandeInNewLine = operandes.get(3);
                operandes.remove(3);
                microPattern.getAttributes().remove("InvalidSequenceInMPConversion");
                this.logWarning(Messages.DateAndTimeMicroPattern_TOO_MUCH_PARAMETER, microPattern);
            } else {
                this.logWarning(Messages.MicroPatternHandler_INVALID_OPERANDE_NUMBER, microPattern);
                return "";
            }
        }
        IMicroPatternProcessingContext context = microPattern.getProcessingContext();
        String xOper = null;
        String yOper = null;
        String dat1 = null;
        String dat2 = null;
        String separator = this.dateSeparator();
        String lastOperande = null;
        if (operandes.size() == 2) {
            dat1 = operandes.get(0);
            dat2 = operandes.get(1);
            lastOperande = operandes.get(1);
            xOper = _XNULL_KEY;
            yOper = _YNULL_KEY;
            if (dat1.length() == 2 && DATE_FORMATS_LIST.indexOf(dat1.charAt(0)) != -1 && DATE_FORMATS_LIST.indexOf(dat1.charAt(1)) != -1) {
                xOper = dat1.substring(0, 1);
                yOper = dat1.substring(1, 2);
                if (yOper.equals("G")) {
                    separator = "DATSET";
                }
                if (!(dat1 = this.firstPartOfOperandes(operandes.get(1), newLine)).equals(lastOperande = this.secondPartOfOperandes(operandes.get(1), newLine))) {
                    lastOperande = String.valueOf(newLine) + lastOperande;
                }
            }
            if (xOper.equals(_XNULL_KEY) && (dat1Format = this.partInvocationFormat(dat1, context)) != null && DATE_FORMATS_LIST.indexOf(dat1Format.charAt(0)) != -1 && dat1Format.length() >= 1) {
                xOper = dat1Format.substring(0, 1);
            }
            dat2Format = this.partInvocationFormat(dat2, context);
            if ((yOper.equals(_YNULL_KEY) || dat2Format != null && dat2Format.startsWith(yOper)) && DATE_FORMATS_LIST.indexOf(dat2Format.charAt(0)) != -1 && dat2Format.length() >= 1) {
                yOper = dat2Format.substring(0, 1);
                if (dat2Format.length() == 2) {
                    separator = String.valueOf(alphanumeric_Delimiter) + dat2Format.substring(1, 2) + alphanumeric_Delimiter;
                } else if (dat2Format.equals("G")) {
                    separator = "DATSET";
                }
            }
        } else if (operandes.size() == 3) {
            dat1 = operandes.get(0);
            dat2 = operandes.get(1);
            lastOperande = operandes.get(2);
            xOper = _XNULL_KEY;
            yOper = _YNULL_KEY;
            if (dat1.length() == 2 && DATE_FORMATS_LIST.indexOf(dat1.charAt(0)) != -1 && DATE_FORMATS_LIST.indexOf(dat1.charAt(1)) != -1) {
                xOper = dat1.substring(0, 1);
                yOper = dat1.substring(1, 2);
                if (yOper.equals("G")) {
                    separator = "DATSET";
                }
                dat1 = this.firstPartOfOperandes(operandes.get(1), newLine);
                dat2 = this.firstPartOfOperandes(operandes.get(2), newLine);
                if (!dat2.equals(lastOperande = this.secondPartOfOperandes(operandes.get(2), newLine))) {
                    lastOperande = String.valueOf(dat2) + newLine + lastOperande;
                }
            }
            if (xOper.equals(_XNULL_KEY) && (dat1Format = this.partInvocationFormat(dat1, context)) != null && DATE_FORMATS_LIST.indexOf(dat1Format.charAt(0)) != -1 && dat1Format.length() >= 1) {
                xOper = dat1Format.substring(0, 1);
            }
            dat2Format = this.partInvocationFormat(dat2, context);
            if ((yOper.equals(_YNULL_KEY) || dat2Format != null && dat2Format.startsWith(yOper)) && DATE_FORMATS_LIST.indexOf(dat2Format.charAt(0)) != -1 && dat2Format.length() >= 1) {
                yOper = dat2Format.substring(0, 1);
                if (dat2Format.length() == 2) {
                    separator = String.valueOf(alphanumeric_Delimiter) + dat2Format.substring(1, 2) + alphanumeric_Delimiter;
                } else if (dat2Format.equals("G")) {
                    separator = "DATSET";
                }
            }
        } else if (operandes.size() == 1) {
            dat1 = this.firstPartOfOperandes(operandes.get(0), newLine);
            if (!dat1.equals(lastOperande = (dat2 = this.secondPartOfOperandes(operandes.get(0), newLine)))) {
                lastOperande = String.valueOf(newLine) + lastOperande;
            }
            xOper = _XNULL_KEY;
            yOper = _YNULL_KEY;
            dat1Format = this.partInvocationFormat(dat1, context);
            String dat2Format2 = this.partInvocationFormat(dat2, context);
            if (dat1Format != null && DATE_FORMATS_LIST.indexOf(dat1Format.charAt(0)) != -1 && dat1Format.length() >= 1) {
                xOper = dat1Format.substring(0, 1);
            }
            if (dat2Format2 != null && DATE_FORMATS_LIST.indexOf(dat2Format2.charAt(0)) != -1 && dat2Format2.length() >= 1) {
                yOper = dat2Format2.substring(0, 1);
                if (dat2Format2.length() == 2) {
                    separator = String.valueOf(alphanumeric_Delimiter) + dat2Format2.substring(1, 2) + alphanumeric_Delimiter;
                } else if (dat2Format2.equals("G")) {
                    separator = "DATSET";
                }
            }
        }
        String convertedXOper = workAreaNames.get(xOper);
        String convertedYOper = workAreaNames.get(yOper);
        if (_XNULL_KEY.equals(xOper)) {
            xOper = "";
        }
        if (_YNULL_KEY.equals(yOper)) {
            yOper = "";
        }
        if (convertedXOper == null || convertedYOper == null) {
            this.logWarning(Messages.MicroPatternHandler_INVALID_OPERANDE_NUMBER, microPattern);
            if (convertedXOper == null) {
                convertedXOper = workAreaNames.get(_XNULL_KEY);
                xOper = "";
            }
            if (convertedYOper == null) {
                convertedYOper = workAreaNames.get(_YNULL_KEY);
                yOper = "";
            }
        }
        StringBuilder result = new StringBuilder();
        result.append((CharSequence)this.addFirstFormattedCobolLine(microPattern.getProcessingContext()));
        result.append((CharSequence)this.addFormattedCobolLine(this.addSpecificLocalFragment(dat1, convertedXOper, separator, context), context));
        String subFunctionName = this.subFunctionName(context);
        result.append((CharSequence)this.addLastFormattedCobolLine(subFunctionName, xOper, convertedYOper, lastOperande, context));
        if (lastOperandeInNewLine != null) {
            result.append("     ");
            result.append((CharSequence)this.addFormattedCobolLine(lastOperandeInNewLine, context));
        }
        return result.toString();
    }

    protected abstract StringBuilder addFirstFormattedCobolLine(IMicroPatternProcessingContext var1);

    protected abstract StringBuilder addLastFormattedCobolLine(String var1, String var2, String var3, String var4, IMicroPatternProcessingContext var5);

    protected PacbaseLalDescription findDataElementVisitor(String corub, IMicroPatternProcessingContext context) {
        PacbaseLalDescription pld = null;
        EObject obj = this.searchReference(context);
        if (obj instanceof RadicalEntity) {
            RadicalEntity re = (RadicalEntity)obj;
            GenerationContext ctx = new GenerationContext(DateAndTimeMicroPatternHandler.SearchVariantFor(re), DateAndTimeMicroPatternHandler.SearchGenerationParameterVariantFor(re), DateAndTimeMicroPatternHandler.SearchGeneratedLanguageFor(re), DateAndTimeMicroPatternHandler.SearchPatternForWorkingPurpose(re));
            LengthAndPositionVisitor lpv = new LengthAndPositionVisitor(null, ctx);
            DataElement de = (DataElement)this.searchRadicalEntity(re.getProject(), re.getPackage(), corub, "dataelement", context);
            if (de == null) {
                return null;
            }
            lpv.doSwitch((EObject)de);
            pld = lpv.getTopParentLal();
        }
        return pld;
    }

    protected abstract String searchFormatInEntityModel(String var1, IMicroPatternProcessingContext var2);

    protected abstract String searchConversationalFormatInEntityModel(String var1, String var2, IMicroPatternProcessingContext var3);

    protected String partInvocationFormat(String partName, IMicroPatternProcessingContext context) {
        if ("DATCE".equals(partName)) {
            return "S";
        }
        if ("DATOR".equals(partName)) {
            return "I";
        }
        String deCode = AbstractPacAnalyzer.GetPacDataElementFromParameter((String)partName);
        PacbaseLalDescription pld = this.findDataElementVisitor(deCode, context);
        String internalFormat = null;
        String convFormat = this.searchConversationalFormatInEntityModel(deCode, partName, context);
        if (convFormat != null) {
            return convFormat;
        }
        if (pld != null && (internalFormat = pld.getFormat("I")).equals(pld.getFormat("E")) && internalFormat.equals(pld.getFormat("S"))) {
            return internalFormat;
        }
        HashMap<String, WorkingData> allWDs = this.getWorkingData(context);
        if (allWDs != null && pld != null) {
            WorkingData wd = allWDs.get(partName);
            if (wd == null) {
                String format = this.searchFormatInEntityModel(partName, context);
                if (format != null) {
                    return pld.getFormat(format);
                }
            } else {
                return pld.getFormat(wd.getFormat());
            }
        }
        this.traceMessage("Unknown part name in a AD Micro Pattern : " + partName);
        return internalFormat;
    }

    protected StringBuilder getCommentFunction(IMicroPatternProcessingContext context) {
        StringBuilder sb = new StringBuilder(70);
        sb.append("      *N");
        sb.append(this.subFunctionCode(context));
        sb.append(".    NOTE * DATES                             *.");
        sb.append(DateAndTimeMicroPatternHandler.GetProperty_NEW_LINE(context));
        return sb;
    }

    protected abstract String generateFunctionCode(IMicroPatternProcessingContext var1);

    protected abstract String generateFunctionCodeBeginning(IMicroPatternProcessingContext var1);

    protected abstract String generateEndFunctionCode(IMicroPatternProcessingContext var1);

    @Override
    protected void addOtherFragments(IMicroPattern microPattern, IGenInfoBuilder genInfoBuilder) {
        this.addFunctionFragment(microPattern, genInfoBuilder);
        this.addWorkingFragment(microPattern, genInfoBuilder);
    }

    protected IBuilderTag searchFunctionFrom(IBuilderTag startTag, String function) {
        IBuilderTag currentTag = startTag.firstSon();
        boolean found = false;
        while (!found && currentTag != null) {
            String name = currentTag.getName();
            if (name.charAt(0) == 'F') {
                String currentFct = name.substring(1);
                boolean bl = found = EBCDICCompare.stringCompare((String)currentFct, (String)function) == 0;
                if (found) {
                    return currentTag;
                }
            }
            currentTag = currentTag.nextTag();
        }
        return null;
    }

    protected void addFunctionFragment(IMicroPattern microPattern, IGenInfoBuilder giBuilder) {
        IBuilderTag tag;
        IMicroPatternProcessingContext context = microPattern.getProcessingContext();
        String fct = this.subFunctionName(context);
        String function = fct.substring(1, 3);
        IBuilderTag fctTag = giBuilder.tagFromName(fct);
        if (fctTag == null) {
            IBuilderTag resultTag;
            EObject obj = this.searchReference(microPattern);
            IBuilderTag procTag = giBuilder.tagFromName("PROCEDURE");
            if (obj instanceof PacAbstractDialogServer) {
                procTag = giBuilder.tagFromName("F80");
            }
            resultTag = (resultTag = this.searchFunctionFrom(procTag, function)) == null ? (obj instanceof PacAbstractDialogServer ? DateAndTimeMicroPatternHandler.SearchSubFunctionForF81(procTag, fct) : DateAndTimeMicroPatternHandler.SearchSubFunctionFrom(procTag, fct)) : (obj instanceof PacAbstractDialogServer ? DateAndTimeMicroPatternHandler.SearchSubFunctionForF81(resultTag, fct) : DateAndTimeMicroPatternHandler.SearchSubFunctionFrom(procTag, fct));
            int index = resultTag.getEndIndex();
            String parentName = resultTag.getParent().getName();
            String lev = AbstractCommonMicroPatternHandler.GetPropertyFor(resultTag, "level");
            if (resultTag.getName().substring(1).startsWith(function) && lev != null && lev.length() > 0 && Float.parseFloat(lev) < (float)Integer.parseInt("10")) {
                String currentText = resultTag.getText().toString();
                index = resultTag.getBeginIndex() + currentText.lastIndexOf("       " + resultTag.getName() + "-FN.");
                fctTag = DateAndTimeMicroPatternHandler.AddTag(giBuilder, index, index, fct);
            } else {
                fctTag = DateAndTimeMicroPatternHandler.AddTag(giBuilder, index, index, fct, parentName);
            }
        } else if ("true".equals(fctTag.getProperty("SyntacticTag")) || fctTag.getProperty("msp") != null) {
            this.logWarning(Messages.DateAndTimeMicroPattern_FUNCTION_IN_SPECIFIC, microPattern, fctTag);
            return;
        }
        if (fctTag.getProperty("level") == null) {
            fctTag.setProperty("level", "10");
        }
        if (fctTag.getRelativeBeginIndex() == fctTag.getRelativeEndIndex()) {
            while (fctTag.hasSon()) {
                tag = fctTag.firstSon();
                giBuilder.removeTree(tag);
            }
            String functionCode = this.generateFunctionCode(context);
            if (functionCode != null) {
                fctTag.setText((CharSequence)this.generateFunctionCodeBeginning(context));
                IBuilderTag beginFctTag = DateAndTimeMicroPatternHandler.AddTag(giBuilder, fctTag.getEndIndex(), fctTag.getEndIndex(), FUNCTION_DATE_CONVERT, fctTag.getName());
                beginFctTag.setText((CharSequence)functionCode);
                beginFctTag.setTextAfter((CharSequence)this.generateEndFunctionCode(context));
            } else {
                giBuilder.removeTag(fctTag);
            }
        } else {
            String subName;
            String text;
            int begin;
            tag = giBuilder.tagFromName(FUNCTION_DATE_CONVERT);
            if (tag == null && (begin = (text = fctTag.getText().toString()).indexOf(String.valueOf(subName = "       " + this.subFunctionName(context)) + "-C.")) > 0) {
                int end = text.indexOf(String.valueOf(subName) + "-Z.");
                end = fctTag.getBeginIndex() + end + text.substring(end).indexOf(DateAndTimeMicroPatternHandler.GetProperty_NEW_LINE(context)) + DateAndTimeMicroPatternHandler.GetProperty_NEW_LINE(context).length();
                DateAndTimeMicroPatternHandler.AddTag(giBuilder, begin += fctTag.getBeginIndex(), end, FUNCTION_DATE_CONVERT, fctTag.getName());
                tag = giBuilder.tagFromName(FUNCTION_DATE_ER);
                if (tag == null && (begin = text.indexOf(String.valueOf(subName) + "-ER.")) > 0) {
                    end = fctTag.getBeginIndex() + text.indexOf(String.valueOf(subName) + "-FN.");
                    DateAndTimeMicroPatternHandler.AddTag(giBuilder, begin += fctTag.getBeginIndex(), end, FUNCTION_DATE_ER, fctTag.getName());
                }
            }
        }
    }

    protected String getFunctionCodeFromDATPROoption(List<PacGLine> goLines) {
        for (PacGLine gLine : goLines) {
            String functionCode;
            String gLineDesc = gLine.getDescription();
            if (!"O".equals(gLine.getLineType()) || gLineDesc == null || !gLineDesc.contains(DATPRO_OPTION_NAME) || (functionCode = gLineDesc.substring(gLineDesc.indexOf(DATPRO_OPTION_NAME) + DATPRO_OPTION_NAME.length())).charAt(0) != '=') continue;
            functionCode = functionCode.substring(1);
            if ((functionCode = functionCode.trim()).length() > 4) {
                functionCode = functionCode.substring(0, 4);
            }
            return functionCode;
        }
        return this.subFunctionDefaultCode();
    }

    protected abstract String subFunctionDefaultCode();

    protected abstract String subFunctionCode(IMicroPatternProcessingContext var1);

    protected String subFunctionName(IMicroPatternProcessingContext context) {
        return String.valueOf(this.subFunctionPrefix()) + this.subFunctionCode(context);
    }

    protected String subFunctionPrefix() {
        return "F";
    }

    protected String dateSeparator() {
        return DATE_SEPARATOR;
    }

    protected abstract TagNameAndLevel[] getLevelsForThisID(IMicroPatternProcessingContext var1);

    public abstract TagNameAndLevel[] getAllLevels();

    public static int SearchRank(TagNameAndLevel level, TagNameAndLevel[] AllLevels) {
        int indexSearch = -1;
        int i = 0;
        while (i < AllLevels.length) {
            if (level == AllLevels[i]) {
                indexSearch = i;
                return indexSearch;
            }
            ++i;
        }
        return indexSearch;
    }

    protected void addWorkingFragment(IMicroPattern microPattern, IGenInfoBuilder genInfoBuilder) {
        TagNameAndLevel[] current01Levels = this.getLevelsForThisID(microPattern.getProcessingContext());
        if (current01Levels == null) {
            return;
        }
        int i = 0;
        while (i < current01Levels.length) {
            String text = genInfoBuilder.tagFromName("WSS-CONTINUATION").getText().toString();
            String tagName = VARIABLE_TAG_NAME_BEGINING + current01Levels[i].getName();
            IBuilderTag tag = genInfoBuilder.tagFromName(tagName);
            int[] res = new int[]{-1, -1};
            if (tag == null && (res = DateAndTimeWorkingMicroPatternFilter.SearchIndicesForWorkingPart(text, current01Levels[i], 0, this.getAllLevels(), DateAndTimeMicroPatternHandler.GetProperty_NEW_LINE(microPattern.getProcessingContext())))[0] != -1) {
                int index = genInfoBuilder.tagFromName("WSS-CONTINUATION").getBeginIndex();
                tag = DateAndTimeMicroPatternHandler.AddTag(genInfoBuilder, index + res[0], index + res[1], tagName, genInfoBuilder.includingTag(index + res[0], index + res[1]).getName());
            }
            if (tag == null) {
                if (this.isSpecialTreatmentForSpecialLevel(current01Levels[i])) {
                    tag = this.specialTreatmentForWorkingPart(microPattern.getProcessingContext(), genInfoBuilder, current01Levels[i], tagName);
                } else {
                    int theoricIndex = DateAndTimeMicroPatternHandler.SearchRank(current01Levels[i], this.getAllLevels()) - 1;
                    tag = null;
                    do {
                        String previousLevelName;
                        if ((tag = genInfoBuilder.tagFromName(VARIABLE_TAG_NAME_BEGINING + (previousLevelName = this.getAllLevels()[theoricIndex].getName()))) != null) continue;
                        res = DateAndTimeWorkingMicroPatternFilter.SearchIndicesForWorkingPart(text, this.getAllLevels()[theoricIndex], 0, this.getAllLevels(), DateAndTimeMicroPatternHandler.GetProperty_NEW_LINE(microPattern.getProcessingContext()));
                    } while (tag == null && res[0] == -1 && --theoricIndex >= 0);
                    if (tag != null) {
                        int index = tag.getEndIndex();
                        tag = DateAndTimeMicroPatternHandler.AddTag(genInfoBuilder, index, index, tagName);
                    } else if (theoricIndex >= 0) {
                        int index = genInfoBuilder.tagFromName("WSS-CONTINUATION").getBeginIndex() + res[1];
                        tag = DateAndTimeMicroPatternHandler.AddTag(genInfoBuilder, index, index, tagName);
                    } else {
                        tag = this.specialTreatmentForWorkingPart(microPattern.getProcessingContext(), genInfoBuilder, current01Levels[i], tagName);
                    }
                }
            }
            this.addWorkingPart(microPattern.getProcessingContext(), tag, current01Levels[i]);
            ++i;
        }
    }

    public boolean isSpecialTreatmentForSpecialLevel(TagNameAndLevel level) {
        return false;
    }

    public IBuilderTag specialTreatmentForWorkingPart(IMicroPatternProcessingContext context, IGenInfoBuilder genInfoBuilder, TagNameAndLevel t, String tagName) {
        return null;
    }

    protected String generateWorkingDAT6(IMicroPatternProcessingContext context) {
        String newLine = DateAndTimeMicroPatternHandler.GetProperty_NEW_LINE(context);
        StringBuilder sb = new StringBuilder(480);
        sb.append("       ");
        sb.append("01  DAT6.");
        sb.append(newLine);
        sb.append("            ");
        sb.append("10 DAT61.");
        sb.append(newLine);
        sb.append("            ");
        sb.append("15 DAT619  PICTURE 99.");
        sb.append(newLine);
        sb.append("            ");
        sb.append("10 DAT62.");
        sb.append(newLine);
        sb.append("            ");
        sb.append("15 DAT629  PICTURE 99.");
        sb.append(newLine);
        sb.append("            ");
        sb.append("10 DAT63   PICTURE XX.");
        sb.append(newLine);
        return sb.toString();
    }

    protected String generateWorkingDAT8(IMicroPatternProcessingContext context) {
        String newLine = DateAndTimeMicroPatternHandler.GetProperty_NEW_LINE(context);
        StringBuilder sb = new StringBuilder(480);
        sb.append("       ");
        sb.append("01  DAT8.");
        sb.append(newLine);
        sb.append("            ");
        sb.append("10 DAT81   PICTURE XX.");
        sb.append(newLine);
        sb.append("            ");
        sb.append("10 DAT8S1  PICTURE X.");
        sb.append(newLine);
        sb.append("            ");
        sb.append("10 DAT82   PICTURE XX.");
        sb.append(newLine);
        sb.append("            ");
        sb.append("10 DAT8S2  PICTURE X.");
        sb.append(newLine);
        sb.append("            ");
        sb.append("10 DAT83   PICTURE XX.");
        sb.append(newLine);
        return sb.toString();
    }

    protected String generateWorkingDAT7(IMicroPatternProcessingContext context) {
        String newLine = DateAndTimeMicroPatternHandler.GetProperty_NEW_LINE(context);
        StringBuilder sb = new StringBuilder(320);
        sb.append("       ");
        sb.append("01  DAT7.");
        sb.append(newLine);
        sb.append("            ");
        sb.append("10 DAT71  PICTURE XX.");
        sb.append(newLine);
        sb.append("            ");
        sb.append("10 DAT72  PICTURE XX.");
        sb.append(newLine);
        sb.append("            ");
        sb.append("10 DAT73  PICTURE XX.");
        sb.append(newLine);
        return sb.toString();
    }

    protected String generateWorkingDATSEP(IMicroPatternProcessingContext context) {
        String alphanumeric_Delimiter = DateAndTimeMicroPatternHandler.GetProperty_ALPHA_NUMERIC_DELIMITER(context);
        StringBuilder sb = new StringBuilder(80);
        sb.append("       ");
        sb.append("01  DATSEP     PICTURE X VALUE ");
        sb.append(alphanumeric_Delimiter);
        sb.append("/");
        sb.append(alphanumeric_Delimiter);
        sb.append(".");
        sb.append(DateAndTimeMicroPatternHandler.GetProperty_NEW_LINE(context));
        return sb.toString();
    }

    protected String generateWorkingDATSET(IMicroPatternProcessingContext context) {
        String alphanumeric_Delimiter = DateAndTimeMicroPatternHandler.GetProperty_ALPHA_NUMERIC_DELIMITER(context);
        StringBuilder sb = new StringBuilder(80);
        sb.append("       ");
        sb.append("01  DATSET     PICTURE X VALUE ");
        sb.append(alphanumeric_Delimiter);
        sb.append("-");
        sb.append(alphanumeric_Delimiter);
        sb.append(".");
        sb.append(DateAndTimeMicroPatternHandler.GetProperty_NEW_LINE(context));
        return sb.toString();
    }

    protected String generateWorkingDATSEW(IMicroPatternProcessingContext context) {
        StringBuilder sb = new StringBuilder(80);
        sb.append("       ");
        sb.append("01  DATSEW     PICTURE X.");
        sb.append(DateAndTimeMicroPatternHandler.GetProperty_NEW_LINE(context));
        return sb.toString();
    }

    protected String generateWorkingDATTRANS(IMicroPatternProcessingContext context) {
        String newLine = DateAndTimeMicroPatternHandler.GetProperty_NEW_LINE(context);
        String alphanumeric_Delimiter = DateAndTimeMicroPatternHandler.GetProperty_ALPHA_NUMERIC_DELIMITER(context);
        StringBuilder sb = new StringBuilder(400);
        sb.append("       ");
        sb.append("01  DAT-TRANS.");
        sb.append(newLine);
        sb.append("       ");
        sb.append("  05  DAT-CTYD   PICTURE XX VALUE ");
        sb.append(alphanumeric_Delimiter);
        sb.append(DateAndTimeMicroPatternHandler.SearchCenturyReferenceYear((RadicalEntity)this.searchReference(context)));
        sb.append(alphanumeric_Delimiter);
        sb.append(".");
        sb.append(newLine);
        return sb.toString();
    }

    protected String generateWorking_05_DAT_CTYT(IMicroPatternProcessingContext context) {
        String alphanumeric_Delimiter = DateAndTimeMicroPatternHandler.GetProperty_ALPHA_NUMERIC_DELIMITER(context);
        StringBuilder sb = new StringBuilder(400);
        sb.append("       ");
        sb.append("  05  DAT-CTYT   PICTURE XX VALUE ");
        sb.append(alphanumeric_Delimiter);
        sb.append(DateAndTimeMicroPatternHandler.SearchCenturyReferenceYear((RadicalEntity)this.searchReference(context)));
        sb.append(alphanumeric_Delimiter);
        sb.append(".");
        sb.append(DateAndTimeMicroPatternHandler.GetProperty_NEW_LINE(context));
        return sb.toString();
    }

    protected String generateWorking_05_DAT_ADO(IMicroPatternProcessingContext context) {
        StringBuilder sb = new StringBuilder();
        sb.append("       ");
        sb.append("  05  DAT-ADO    PICTURE X  VALUE SPACE.");
        sb.append(DateAndTimeMicroPatternHandler.GetProperty_NEW_LINE(context));
        return sb.toString();
    }

    protected String generateWorking_05_DATE8S(IMicroPatternProcessingContext context) {
        StringBuilder sb = new StringBuilder();
        sb.append("       ");
        sb.append("  05  DATE8S    PICTURE 9(8).");
        sb.append(DateAndTimeMicroPatternHandler.GetProperty_NEW_LINE(context));
        return sb.toString();
    }

    protected String generateWorking_05_DATE81(IMicroPatternProcessingContext context) {
        StringBuilder sb = new StringBuilder();
        sb.append("       ");
        sb.append("  05  DATE81    PICTURE 9(8).");
        sb.append(DateAndTimeMicroPatternHandler.GetProperty_NEW_LINE(context));
        return sb.toString();
    }

    protected String generateWorking_05_DATE82(IMicroPatternProcessingContext context) {
        StringBuilder sb = new StringBuilder();
        sb.append("       ");
        sb.append("  05  DATE82    PICTURE 9(8).");
        sb.append(DateAndTimeMicroPatternHandler.GetProperty_NEW_LINE(context));
        return sb.toString();
    }

    protected String generateWorking_05_NUM_DAYS(IMicroPatternProcessingContext context) {
        StringBuilder sb = new StringBuilder();
        sb.append("       ");
        sb.append("  05  NUM-DAYS    PICTURE S9(9).");
        sb.append(DateAndTimeMicroPatternHandler.GetProperty_NEW_LINE(context));
        return sb.toString();
    }

    protected String generateWorkingDATCTY(IMicroPatternProcessingContext context) {
        String newLine = DateAndTimeMicroPatternHandler.GetProperty_NEW_LINE(context);
        StringBuilder sb = new StringBuilder(160);
        sb.append("       ");
        sb.append("01  DATCTY.");
        sb.append(newLine);
        sb.append("            ");
        sb.append(" 05  DATCTY9  PICTURE 99.");
        sb.append(newLine);
        return sb.toString();
    }

    protected String generateWorkingDAT7C(IMicroPatternProcessingContext context) {
        String newLine = DateAndTimeMicroPatternHandler.GetProperty_NEW_LINE(context);
        StringBuilder sb = new StringBuilder(320);
        sb.append("       ");
        sb.append("01  DAT7C.");
        sb.append(newLine);
        sb.append("       ");
        sb.append("  10  DAT71C   PICTURE XX.");
        sb.append(newLine);
        sb.append("       ");
        sb.append("  10  DAT72C   PICTURE XX.");
        sb.append(newLine);
        sb.append("       ");
        sb.append("  10  DAT73C   PICTURE XX.");
        sb.append(newLine);
        sb.append("       ");
        sb.append("  10  DAT74C   PICTURE XX.");
        sb.append(newLine);
        return sb.toString();
    }

    protected String generateWorkingDAT8G(IMicroPatternProcessingContext context) {
        String newLine = DateAndTimeMicroPatternHandler.GetProperty_NEW_LINE(context);
        String alphanumeric_Delimiter = DateAndTimeMicroPatternHandler.GetProperty_ALPHA_NUMERIC_DELIMITER(context);
        StringBuilder sb = new StringBuilder(560);
        sb.append("       ");
        sb.append("01  DAT8G.");
        sb.append(newLine);
        sb.append("       ");
        sb.append("  10  DAT81G   PICTURE XX.");
        sb.append(newLine);
        sb.append("       ");
        sb.append("  10  DAT82G   PICTURE XX.");
        sb.append(newLine);
        sb.append("       ");
        sb.append("  10  DAT8S1G  PICTURE X    VALUE ");
        sb.append(alphanumeric_Delimiter);
        sb.append("-");
        sb.append(alphanumeric_Delimiter);
        sb.append(".");
        sb.append(newLine);
        sb.append("       ");
        sb.append("  10  DAT83G   PICTURE XX.");
        sb.append(newLine);
        sb.append("       ");
        sb.append("  10  DAT8S2G  PICTURE X    VALUE ");
        sb.append(alphanumeric_Delimiter);
        sb.append("-");
        sb.append(alphanumeric_Delimiter);
        sb.append(".");
        sb.append(newLine);
        sb.append("       ");
        sb.append("  10  DAT84G   PICTURE XX.");
        sb.append(newLine);
        return sb.toString();
    }

    protected String generateWorkingTTDAT(IMicroPatternProcessingContext context) {
        String newLine = DateAndTimeMicroPatternHandler.GetProperty_NEW_LINE(context);
        StringBuilder sb = new StringBuilder(160);
        String SEVEN_SPACE = "       ";
        String TWELVE_SPACE = "            ";
        sb.append(SEVEN_SPACE);
        sb.append("01   TT-DAT.");
        sb.append(newLine);
        sb.append(TWELVE_SPACE);
        sb.append("05 T-DAT      PICTURE X OCCURS 5.");
        sb.append(newLine);
        return sb.toString();
    }

    protected String generateWorkingTIMDAY(IMicroPatternProcessingContext context) {
        String newLine = DateAndTimeMicroPatternHandler.GetProperty_NEW_LINE(context);
        String alphanumeric_Delimiter = DateAndTimeMicroPatternHandler.GetProperty_ALPHA_NUMERIC_DELIMITER(context);
        StringBuilder sb = new StringBuilder(4200);
        sb.append("       ");
        sb.append("01  TIMDAY.");
        sb.append(newLine);
        sb.append("         ");
        sb.append("05 TIMHOU    PICTURE XX.");
        sb.append(newLine);
        sb.append("         ");
        sb.append("05 TIMS1     PICTURE X  VALUE ");
        sb.append(alphanumeric_Delimiter);
        sb.append(":");
        sb.append(alphanumeric_Delimiter);
        sb.append(".");
        sb.append(newLine);
        sb.append("         ");
        sb.append("05 TIMMIN    PICTURE XX.");
        sb.append(newLine);
        sb.append("         ");
        sb.append("05 TIMS2     PICTURE X  VALUE ");
        sb.append(alphanumeric_Delimiter);
        sb.append(":");
        sb.append(alphanumeric_Delimiter);
        sb.append(".");
        sb.append(newLine);
        sb.append("         ");
        sb.append("05 TIMSEC    PICTURE XX.");
        sb.append(newLine);
        return sb.toString();
    }

    protected String generateWorkingLEAP_YEAR(IMicroPatternProcessingContext context) {
        String newLine = DateAndTimeMicroPatternHandler.GetProperty_NEW_LINE(context);
        StringBuilder sb = new StringBuilder(120);
        String SEVEN_SPACE = "       ";
        String TWELVE_SPACE = "            ";
        sb.append(SEVEN_SPACE);
        sb.append("01   LEAP-YEAR.");
        sb.append(newLine);
        sb.append(TWELVE_SPACE);
        sb.append("05 LEAP-FLAG      PICTURE X.");
        sb.append(newLine);
        sb.append(TWELVE_SPACE);
        sb.append("05 LEAP-REM      PICTURE 99.");
        sb.append(newLine);
        return sb.toString();
    }

    protected void addWorkingPart(IMicroPatternProcessingContext context, IBuilderTag tag, TagNameAndLevel levelName) {
        String content = "";
        int rank = DateAndTimeMicroPatternHandler.SearchRank(levelName, this.getAllLevels());
        switch (this.getAllLevels()[rank].getWorkingPart()) {
            case DAT6: {
                content = this.generateWorkingDAT6(context);
                break;
            }
            case DAT8: {
                content = this.generateWorkingDAT8(context);
                break;
            }
            case DAT8E: {
                content = this.generateWorkingDAT8E(context);
                break;
            }
            case DAT6C: {
                content = this.generateWorkingDAT6C(context);
                break;
            }
            case DAT8C: {
                content = this.generateWorkingDAT8C(context);
                break;
            }
            case TIMCO: {
                content = this.generateWorkingTIMCO(context);
                break;
            }
            case TIMDAY: {
                content = this.generateWorkingTIMDAY(context);
                break;
            }
            case DAT7: {
                content = this.generateWorkingDAT7(context);
                break;
            }
            case DATSEP: {
                content = this.generateWorkingDATSEP(context);
                break;
            }
            case DATSET: {
                content = this.generateWorkingDATSET(context);
                break;
            }
            case DATSEW: {
                content = this.generateWorkingDATSEW(context);
                break;
            }
            case DAT_TRANS: {
                content = this.generateWorkingDATTRANS(context);
                break;
            }
            case DAT_CTYT: {
                content = this.generateWorking_05_DAT_CTYT(context);
                break;
            }
            case DAT_CTY: {
                content = this.generateWorking_05_DAT_CTY(context);
                break;
            }
            case DAT_ADO: {
                content = this.generateWorking_05_DAT_ADO(context);
                break;
            }
            case DATE8S: {
                content = this.generateWorking_05_DATE8S(context);
                break;
            }
            case DATE81: {
                content = this.generateWorking_05_DATE81(context);
                break;
            }
            case DATE82: {
                content = this.generateWorking_05_DATE82(context);
                break;
            }
            case NUM_DAYS: {
                content = this.generateWorking_05_NUM_DAYS(context);
                break;
            }
            case DATCTY: {
                content = this.generateWorkingDATCTY(context);
                break;
            }
            case DAT7C: {
                content = this.generateWorkingDAT7C(context);
                break;
            }
            case DAT8G: {
                content = this.generateWorkingDAT8G(context);
                break;
            }
            case TT_DAT: {
                content = this.generateWorkingTTDAT(context);
                break;
            }
            case TABDAT: {
                content = this.generateWorkingTABDAT(context);
                break;
            }
            case TIMCIC: {
                content = this.generateWorkingTIMCIC(context);
                break;
            }
            case TIMCI1: {
                content = this.generateWorkingTIMCI1(context);
                break;
            }
            case DATCIC: {
                content = this.generateWorkingDATCIC(context);
                break;
            }
            case DATQTM: {
                content = this.generateWorkingDATQTM(context);
                break;
            }
            case LEAP_YEAR: {
                content = this.generateWorkingLEAP_YEAR(context);
                break;
            }
            default: {
                content = "";
            }
        }
        tag.setText((CharSequence)content);
        tag.setProperty("hidden", "true");
    }

    protected abstract String generateWorkingDAT6C(IMicroPatternProcessingContext var1);

    protected abstract String generateWorkingDAT8C(IMicroPatternProcessingContext var1);

    protected abstract String generateWorkingDAT8E(IMicroPatternProcessingContext var1);

    protected abstract String generateWorking_05_DAT_CTY(IMicroPatternProcessingContext var1);

    protected abstract String generateWorkingTIMCO(IMicroPatternProcessingContext var1);

    protected abstract String generateWorkingTABDAT(IMicroPatternProcessingContext var1);

    protected abstract String generateWorkingTIMCIC(IMicroPatternProcessingContext var1);

    protected abstract String generateWorkingTIMCI1(IMicroPatternProcessingContext var1);

    protected abstract String generateWorkingDATCIC(IMicroPatternProcessingContext var1);

    protected abstract String generateWorkingDATQTM(IMicroPatternProcessingContext var1);

    protected boolean needToOverwriteTag(IBuilderTag tag, boolean inUserCode) {
        return tag.getRelativeEndIndex() == tag.getRelativeBeginIndex();
    }

    @Override
    protected List<String> analyseOperande(String content, IMicroPatternProcessingContext context) {
        List<String> res = super.analyseOperande(content, context);
        String newLine = DateAndTimeMicroPatternHandler.GetProperty_NEW_LINE(context);
        while (res.contains(newLine)) {
            int index = res.indexOf(newLine);
            if (index <= 0 || index >= res.size() - 1) continue;
            StringBuilder sb = new StringBuilder(res.get(index - 1));
            sb.append(newLine);
            sb.append(res.get(index + 1));
            res.remove(index - 1);
            res.remove(index - 1);
            res.remove(index - 1);
            if (index - 1 >= res.size()) {
                res.add(index - 1, sb.toString());
                continue;
            }
            res.set(index - 1, sb.toString());
        }
        return res;
    }

    public static IBuilderTag SearchSubFunctionForF81(IBuilderTag startTag, String function) {
        String lev;
        IBuilderTag currentTag = startTag;
        IBuilderTag result = startTag;
        String currentFct = null;
        boolean found = false;
        while (!found && currentTag != null) {
            currentFct = currentTag.getName();
            if (currentFct.charAt(0) == 'F') {
                String currentFctf = currentFct.substring(0, 3);
                int foundf = EBCDICCompare.stringCompare((String)currentFctf, (String)function.substring(0, 3));
                if (foundf == 0) {
                    boolean bl = found = EBCDICCompare.stringCompare((String)currentFct, (String)function) > 0;
                    if (found) {
                        currentFct = result.getName();
                        break;
                    }
                } else {
                    if (foundf > 0) break;
                    if (!currentFctf.equals("F80")) {
                        currentFct = result.getName();
                        break;
                    }
                }
                result = currentTag;
            }
            currentTag = currentTag.nextTag();
        }
        if (found) {
            if (function.substring(1, 3).equals(currentFct.substring(1, 3)) && (lev = DateAndTimeMicroPatternHandler.GetPropertyFor(result, "level")) != null && lev.length() > 0 && Float.parseFloat(lev) < (float)Integer.parseInt("10")) {
                result = DateAndTimeMicroPatternHandler.SearchSubFunctionForF81(result, function);
            }
        } else if (function.substring(1, 3).equals(currentFct.substring(1, 3))) {
            while (result != null && DateAndTimeMicroPatternHandler.GetPropertyFor(result, "SpecificTag") != null) {
                result = result.previousTag();
            }
            lev = DateAndTimeMicroPatternHandler.GetPropertyFor(result, "level");
            if (lev != null && lev.length() > 0 && Float.parseFloat(lev) < (float)Integer.parseInt("10")) {
                result = DateAndTimeMicroPatternHandler.SearchSubFunctionForF81(result, function);
            }
            if (result.getName().endsWith("-FN") && result.previousTag() != null) {
                return result.previousTag();
            }
            return result;
        }
        return result;
    }

    protected String generateProcedureForADI(IMicroPattern microPattern, IGenInfoBuilder genInfoBuilder, boolean isBatchPattern) {
        EObject obj = this.searchReference(microPattern);
        IMicroPatternProcessingContext context = microPattern.getProcessingContext();
        String newLine = DateAndTimeMicroPatternHandler.GetProperty_NEW_LINE(context);
        if (obj instanceof RadicalEntity) {
            List<String> operandes = this.analyseOperande(this.operandes(microPattern), context);
            if (operandes.size() > 2) {
                microPattern.getAttributes().remove("InvalidSequenceInMPConversion");
                this.logWarning(Messages.DateAndTimeMicroPattern_TOO_MUCH_PARAMETER, microPattern);
            }
            if (operandes.size() < 1) {
                this.logWarning(Messages.MicroPatternHandler_INVALID_OPERANDE_NUMBER, microPattern);
                return "";
            }
            String dat1 = null;
            String dat2 = null;
            String lastOperande = null;
            if (operandes.size() == 1 && !(dat1 = this.firstPartOfOperandes(operandes.get(0), newLine)).equals(lastOperande = this.secondPartOfOperandes(operandes.get(0), newLine))) {
                lastOperande = String.valueOf(newLine) + lastOperande;
            }
            if (operandes.size() > 1) {
                lastOperande = "";
                dat1 = this.firstPartOfOperandes(operandes.get(0), newLine);
                if (!dat1.equals(dat2 = this.secondPartOfOperandes(operandes.get(0), newLine))) {
                    lastOperande = String.valueOf(newLine) + dat2;
                }
                int i = 1;
                while (i < operandes.size()) {
                    lastOperande = lastOperande.concat(" ");
                    lastOperande = lastOperande.concat(operandes.get(i));
                    ++i;
                }
            }
            StringBuilder result = new StringBuilder(160);
            PacGeneratedDateFormatValues dateFormat = DateAndTimeMicroPatternHandler.SearchGeneratedDateFormatFor((RadicalEntity)obj);
            result.append("           ");
            result.append("MOVE            ");
            if (dat1 != null) {
                result.append(dat1);
            }
            result.append(newLine);
            result.append("           ");
            result.append("TO DAT6 DAT8");
            result.append(newLine);
            result.append("           ");
            if (isBatchPattern) {
                if (dateFormat == PacGeneratedDateFormatValues._E_LITERAL) {
                    result.append("MOVE DAT63 TO DAT81 MOVE DAT61 TO DAT63");
                    result.append(newLine);
                    result.append("           ");
                    result.append("MOVE DAT62 TO DAT61 MOVE DAT81 TO DAT62");
                } else {
                    result.append("MOVE DAT63 TO DAT61 MOVE DAT81 TO DAT63");
                }
            } else if (dateFormat == PacGeneratedDateFormatValues._E_LITERAL) {
                result.append("MOVE DAT62 TO DAT61 MOVE DAT63 TO DAT62 MOVE DAT81 TO DAT63");
            } else {
                result.append("MOVE DAT63 TO DAT61 MOVE DAT81 TO DAT63");
            }
            result.append(newLine);
            result.append((CharSequence)this.addFormattedCobolLine("     MOVE DAT6 TO " + this.addSeveralCobolLines(lastOperande, "                ", context), context));
            return result.toString();
        }
        return "";
    }

    protected String generateProcedureForADE(IMicroPattern microPattern, IGenInfoBuilder genInfoBuilder) {
        EObject obj = this.searchReference(microPattern);
        IMicroPatternProcessingContext context = microPattern.getProcessingContext();
        String newLine = DateAndTimeMicroPatternHandler.GetProperty_NEW_LINE(context);
        if (obj instanceof RadicalEntity) {
            List<String> operandes = this.analyseOperande(this.operandes(microPattern), context);
            if (operandes.size() < 1) {
                this.logWarning(Messages.MicroPatternHandler_INVALID_OPERANDE_NUMBER, microPattern);
                return "";
            }
            String dat1 = null;
            String dat2 = null;
            String lastOperande = null;
            if (operandes.size() == 1 && !(dat1 = this.firstPartOfOperandes(operandes.get(0), newLine)).equals(lastOperande = this.secondPartOfOperandes(operandes.get(0), DateAndTimeMicroPatternHandler.GetProperty_NEW_LINE(context)))) {
                lastOperande = String.valueOf(DateAndTimeMicroPatternHandler.GetProperty_NEW_LINE(context)) + lastOperande;
            }
            if (operandes.size() > 1) {
                lastOperande = "";
                dat1 = this.firstPartOfOperandes(operandes.get(0), newLine);
                if (!dat1.equals(dat2 = this.secondPartOfOperandes(operandes.get(0), newLine))) {
                    lastOperande = String.valueOf(newLine) + dat2;
                }
                int i = 1;
                while (i < operandes.size()) {
                    lastOperande = lastOperande.concat(" ");
                    lastOperande = lastOperande.concat(operandes.get(i));
                    ++i;
                }
            }
            StringBuilder result = new StringBuilder(160);
            result.append("           ");
            result.append("MOVE            ");
            if (dat1 != null) {
                result.append(dat1);
            }
            result.append(newLine);
            result.append("           ");
            result.append("TO DAT6 DAT8");
            result.append(newLine);
            result.append("           ");
            result.append("MOVE DAT62 TO DAT82 MOVE DAT63 TO DAT83");
            result.append(newLine);
            result.append("           ");
            result.append("MOVE DATSEP TO DAT8S1 DAT8S2");
            result.append(newLine);
            result.append((CharSequence)this.addFormattedCobolLine("     MOVE DAT8 TO " + this.addSeveralCobolLines(lastOperande, "                ", context), context));
            return result.toString();
        }
        return "";
    }

    protected void convertADxFAmilyToAttributes(IMicroPattern microPattern, Map<String, Object> parameters) {
        super.convertToAttributes(microPattern, parameters);
        Object prmDe1 = parameters.get("DE1");
        Object prmDe2 = parameters.get("DE2");
        StringBuilder buffer = new StringBuilder("");
        if (prmDe1 instanceof MPDesignReference) {
            buffer.append(((MPDesignReference)prmDe1).getName());
        } else if (prmDe1 instanceof String) {
            buffer.append(prmDe1);
        }
        if (prmDe2 instanceof MPDesignReference) {
            buffer.append(' ').append(((MPDesignReference)prmDe2).getName());
        } else if (prmDe2 instanceof String) {
            buffer.append(' ').append(prmDe2);
        }
        microPattern.getAttributes().put("FIRST_ZONE", buffer.toString());
    }

    protected LinkedHashMap<String, String> convertADxFamilyToParameters(IMicroPattern microPattern, String operandes) {
        List<String> oper = this.analyseOperande(this.operandes(microPattern), microPattern.getProcessingContext());
        String[] tokens = this.modifyOperandes(oper, microPattern.getProcessingContext());
        if (tokens.length > 2) {
            microPattern.getAttributes().remove("InvalidSequenceInMPConversion");
            this.logWarning(Messages.DateAndTimeMicroPattern_TOO_MUCH_PARAMETER, microPattern);
            return null;
        }
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        if (tokens.length == 2) {
            parameters.put("DE1", DateAndTimeMicroPatternHandler.valueToString(tokens[0]));
            parameters.put("DE2", tokens[1]);
            return parameters;
        }
        if (tokens.length == 1) {
            parameters.put("DE1", DateAndTimeMicroPatternHandler.valueToString(tokens[0]));
            return parameters;
        }
        return null;
    }

    protected void convertADFAmilyToAttributes(IMicroPattern microPattern, Map<String, Object> parameters) {
        super.convertToAttributes(microPattern, parameters);
        Object prmDf1 = parameters.get("DF1");
        Object prmDf2 = parameters.get("DF2");
        Object prmDe1 = parameters.get("DE1");
        Object prmDe2 = parameters.get("DE2");
        StringBuilder buffer = new StringBuilder("");
        if (prmDf1 instanceof String && prmDf2 instanceof String) {
            buffer.append(prmDf1).append(prmDf2).append(' ');
        }
        if (prmDe1 instanceof MPDesignReference) {
            buffer.append(((MPDesignReference)prmDe1).getName());
        } else if (prmDe1 instanceof String) {
            buffer.append(prmDe1);
        }
        if (prmDe2 instanceof MPDesignReference) {
            buffer.append(' ').append(((MPDesignReference)prmDe2).getName());
        } else if (prmDe2 instanceof String) {
            buffer.append(' ').append(prmDe2);
        }
        microPattern.getAttributes().put("FIRST_ZONE", buffer.toString());
    }

    protected LinkedHashMap<String, String> convertADFamilyToParameters(IMicroPattern microPattern, String operandes) {
        List<String> oper = this.analyseOperande(this.operandes(microPattern), microPattern.getProcessingContext());
        String[] tokens = this.modifyOperandes(oper, microPattern.getProcessingContext());
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        if (tokens.length == 3 && tokens[0].length() == 2) {
            parameters.put("DF1", tokens[0].substring(0, 1));
            parameters.put("DF2", tokens[0].substring(1, 2));
            parameters.put("DE1", DateAndTimeMicroPatternHandler.valueToString(tokens[1]));
            parameters.put("DE2", tokens[2]);
            return parameters;
        }
        if (tokens.length == 2) {
            if (tokens[0].length() == 2) {
                parameters.put("DF1", tokens[0].substring(0, 1));
                parameters.put("DF2", tokens[0].substring(1, 2));
                parameters.put("DE1", DateAndTimeMicroPatternHandler.valueToString(tokens[1]));
            } else if (tokens[0].length() > 2) {
                parameters.put("DE1", DateAndTimeMicroPatternHandler.valueToString(tokens[0]));
                parameters.put("DE2", tokens[1]);
            }
            return parameters;
        }
        return null;
    }

    protected void convertDCDFAmilyToAttributes(IMicroPattern microPattern, Map<String, Object> parameters) {
        super.convertToAttributes(microPattern, parameters);
        Object prmDf1 = parameters.get("DF1");
        Object prmDf2 = parameters.get("DF2");
        Object prmDe1 = parameters.get("DE1");
        Object prmOpe = parameters.get("OPE");
        Object prmDe2 = parameters.get("DE2");
        StringBuilder buffer = new StringBuilder("");
        if (prmDf1 instanceof String && prmDf2 instanceof String) {
            buffer.append(prmDf1).append(prmDf2).append(' ');
        }
        if (prmDe1 instanceof MPDesignReference) {
            buffer.append(((MPDesignReference)prmDe1).getName());
        } else if (prmDe1 instanceof String) {
            buffer.append(prmDe1);
        }
        if (prmOpe instanceof String) {
            buffer.append(' ').append(prmOpe).append(' ');
        }
        if (prmDe2 instanceof MPDesignReference) {
            buffer.append(((MPDesignReference)prmDe2).getName());
        } else if (prmDe2 instanceof String) {
            buffer.append(prmDe2);
        }
        microPattern.getAttributes().put("FIRST_ZONE", buffer.toString());
    }

    protected LinkedHashMap<String, String> convertDCDFamilyToParameters(IMicroPattern microPattern, String operandes) {
        List<String> oper = this.analyseOperande(this.operandes(microPattern), microPattern.getProcessingContext());
        DateAndTimeMicroPatternHandler.ModifyOperandesWithLogicalWord(oper);
        String[] tokens = this.modifyOperandes(oper, microPattern.getProcessingContext());
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        if (tokens.length == 4 && tokens[0].length() == 2) {
            parameters.put("DF1", tokens[0].substring(0, 1));
            parameters.put("DF2", tokens[0].substring(1, 2));
            parameters.put("DE1", DateAndTimeMicroPatternHandler.valueToString(tokens[1]));
            parameters.put("OPE", tokens[2]);
            parameters.put("DE2", tokens[3]);
            return parameters;
        }
        if (tokens.length == 3) {
            parameters.put("DE1", DateAndTimeMicroPatternHandler.valueToString(tokens[0]));
            parameters.put("OPE", tokens[1]);
            parameters.put("DE2", tokens[2]);
            return parameters;
        }
        return null;
    }

    protected void convertDAOAmilyToAttributes(IMicroPattern microPattern, Map<String, Object> parameters) {
        super.convertToAttributes(microPattern, parameters);
        Object prmDf1 = parameters.get("DF1");
        Object prmSnb = parameters.get("SNB");
        Object prmDe1 = parameters.get("DE1");
        StringBuilder buffer = new StringBuilder("");
        if (prmDf1 instanceof String) {
            buffer.append(prmDf1).append(' ');
        }
        if (prmSnb instanceof String) {
            buffer.append(' ').append(prmSnb).append(' ');
        }
        if (prmDe1 instanceof MPDesignReference) {
            buffer.append(((MPDesignReference)prmDe1).getName());
        } else if (prmDe1 instanceof String) {
            buffer.append(prmDe1);
        }
        microPattern.getAttributes().put("FIRST_ZONE", buffer.toString());
    }

    protected LinkedHashMap<String, String> convertDAOFamilyToParameters(IMicroPattern microPattern, String operandes) {
        List<String> oper = this.analyseOperande(this.operandes(microPattern), microPattern.getProcessingContext());
        String[] tokens = this.modifyOperandes(oper, microPattern.getProcessingContext());
        if (tokens.length > 3) {
            microPattern.getAttributes().remove("InvalidSequenceInMPConversion");
            this.logWarning(Messages.DAOMicroPatternHandler_TOO_MUCH_PARAMETER, microPattern);
            return null;
        }
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        if (tokens.length == 3 && tokens[0].length() == 1) {
            parameters.put("DF1", tokens[0]);
            parameters.put("SNB", tokens[1]);
            parameters.put("DE1", DateAndTimeMicroPatternHandler.valueToString(tokens[2]));
            return parameters;
        }
        if (tokens.length == 2) {
            parameters.put("SNB", tokens[0]);
            parameters.put("DE1", DateAndTimeMicroPatternHandler.valueToString(tokens[1]));
            return parameters;
        }
        return null;
    }

    private static String valueToString(String sValue) {
        String result = sValue;
        if (sValue.startsWith("'") && sValue.endsWith("'")) {
            StringBuilder buffer = new StringBuilder(sValue);
            buffer.insert(0, "\"").append("\"");
            result = buffer.toString();
        }
        return result;
    }

    protected void convertDVFAmilyToAttributes(IMicroPattern microPattern, Map<String, Object> parameters) {
        super.convertToAttributes(microPattern, parameters);
        Object prmDf1 = parameters.get("DF1");
        Object prmDe1 = parameters.get("DE1");
        StringBuilder buffer = new StringBuilder("");
        if (prmDf1 instanceof String) {
            buffer.append(prmDf1).append(' ');
        }
        if (prmDe1 instanceof MPDesignReference) {
            buffer.append(((MPDesignReference)prmDe1).getName());
        } else if (prmDe1 instanceof String) {
            buffer.append(prmDe1);
        }
        microPattern.getAttributes().put("FIRST_ZONE", buffer.toString());
    }

    protected LinkedHashMap<String, String> convertDVFamilyToParameters(IMicroPattern microPattern, String operandes) {
        List<String> oper = this.analyseOperande(this.operandes(microPattern), microPattern.getProcessingContext());
        String[] tokens = this.modifyOperandes(oper, microPattern.getProcessingContext());
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        if (tokens.length == 2) {
            if (tokens[0].length() == 1) {
                parameters.put("DF1", tokens[0]);
                parameters.put("DE1", tokens[1]);
            }
            return parameters;
        }
        if (tokens.length == 1 && tokens[0].length() > 1) {
            parameters.put("DE1", tokens[0]);
            return parameters;
        }
        return null;
    }

    protected void convertTIMFAmilyToAttributes(IMicroPattern microPattern, Map<String, Object> parameters) {
        super.convertToAttributes(microPattern, parameters);
        Object prmDe1 = parameters.get("DE1");
        StringBuilder buffer = new StringBuilder("");
        if (prmDe1 instanceof MPDesignReference) {
            buffer.append(((MPDesignReference)prmDe1).getName());
        } else if (prmDe1 instanceof String) {
            buffer.append(prmDe1);
        }
        microPattern.getAttributes().put("FIRST_ZONE", buffer.toString());
    }

    protected LinkedHashMap<String, String> convertTIMFamilyToParameters(IMicroPattern microPattern, String operandes) {
        List<String> oper = this.analyseOperande(this.operandes(microPattern), microPattern.getProcessingContext());
        String[] tokens = this.modifyOperandes(oper, microPattern.getProcessingContext());
        if (tokens.length > 1) {
            microPattern.getAttributes().remove("InvalidSequenceInMPConversion");
            this.logWarning(Messages.DateAndTimeMicroPattern_TOO_MUCH_PARAMETER, microPattern);
            return null;
        }
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        if (tokens.length == 1) {
            parameters.put("DE1", tokens[0]);
            return parameters;
        }
        return null;
    }

    protected String[] modifyOperandes(List<String> operandes, IMicroPatternProcessingContext context) {
        Iterator<String> it = operandes.iterator();
        ArrayList<String> result = new ArrayList<String>();
        String nl = DateAndTimeMicroPatternHandler.GetProperty_NEW_LINE(context);
        while (it.hasNext()) {
            String item = it.next();
            int index = item.indexOf(nl);
            while (index != -1) {
                result.add(item.substring(0, index));
                item = item.substring(index + nl.length());
                index = item.indexOf(nl);
            }
            result.add(item);
        }
        String[] tokens = new String[result.size()];
        tokens = result.toArray(tokens);
        return tokens;
    }

    public static class TagNameAndLevel {
        String tagName;
        int tagLevel;
        WorkingParts part;

        public TagNameAndLevel(String name, int level, WorkingParts partName) {
            this.tagName = name;
            this.tagLevel = level;
            this.part = partName;
        }

        public WorkingParts getWorkingPart() {
            return this.part;
        }

        public String getName() {
            return this.tagName;
        }

        public int getLevel() {
            return this.tagLevel;
        }

        public String toString() {
            return this.tagName;
        }
    }

    public static enum WorkingParts {
        DATCE,
        DAT6,
        DAT8,
        DAT8E,
        DAT6C,
        DAT8C,
        TIMCO,
        TIMDAY,
        DAT7,
        DATSEP,
        DATSET,
        DATSEW,
        DAT_TRANS,
        DATCTY,
        DAT7C,
        DAT8G,
        TT_DAT,
        TIMCIC,
        TIMCI1,
        DATCIC,
        DATQTM,
        TABDAT,
        LEAP_YEAR,
        DAT_CTYT,
        DAT_CTY,
        DAT_ADO,
        DATE8S,
        DATE81,
        DATE82,
        NUM_DAYS;

    }
}

