/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.extension.micropattern;

import com.ibm.pdp.engine.IBuilderTag;
import com.ibm.pdp.engine.IGenInfoBuilder;
import com.ibm.pdp.engine.IMicroPattern;
import com.ibm.pdp.engine.IMicroPatternProcessingContext;
import com.ibm.pdp.framework.cobol.micropattern.internal.MicroPatternConstants;
import com.ibm.pdp.mdl.pacbase.PacGeneratedSkeletonLanguageValues;
import com.ibm.pdp.pacbase.extension.micropattern.AbstractCommonMicroPatternHandler;
import com.ibm.pdp.pacbase.extension.micropattern.DCDIDVMicroPatternUtilities;

public class DIDVMicroPatternUtilities
extends DCDIDVMicroPatternUtilities
implements MicroPatternConstants {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2015, 2016.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected static final String EN_PRE_FR = "EN-PRE";
    protected static final String EN_PRE_EN = "DEL-ER";

    public static String GenerateLocalFragment(IMicroPatternProcessingContext context, String fct, String date, String xOper, String convertedXOper, PacGeneratedSkeletonLanguageValues lang, String id) {
        String alphanumeric_Delimiter = AbstractCommonMicroPatternHandler.GetProperty_ALPHA_NUMERIC_DELIMITER(context);
        String newLine = AbstractCommonMicroPatternHandler.GetProperty_NEW_LINE(context);
        String enpre = lang == PacGeneratedSkeletonLanguageValues._FR_LITERAL ? EN_PRE_FR : EN_PRE_EN;
        StringBuilder sb = new StringBuilder(170);
        sb.append("       ");
        sb.append("    MOVE ");
        sb.append(alphanumeric_Delimiter);
        sb.append("0");
        sb.append(alphanumeric_Delimiter);
        sb.append("    TO DAT-ADO");
        sb.append(newLine);
        sb.append("       ");
        sb.append("    MOVE      ");
        sb.append(date);
        sb.append(newLine);
        sb.append("       ");
        sb.append("    TO  ");
        sb.append(convertedXOper);
        sb.append(newLine);
        sb.append("       ");
        sb.append("    PERFORM ");
        sb.append(fct);
        sb.append("-").append(xOper);
        sb.append("  THRU ");
        sb.append(fct);
        sb.append("-FN");
        sb.append(newLine);
        sb.append("       ");
        sb.append("          IF ");
        sb.append(enpre);
        if (id.startsWith("DV")) {
            sb.append(" = ");
        } else {
            sb.append(" > ");
        }
        sb.append(alphanumeric_Delimiter);
        sb.append("1");
        sb.append(alphanumeric_Delimiter);
        sb.append(newLine);
        return sb.toString();
    }

    public static IBuilderTag AddFunctionFragment(IMicroPattern microPattern, IGenInfoBuilder giBuilder, String fct) {
        IBuilderTag fctTag = giBuilder.tagFromName("FUNCTION_DATE_ER");
        if (fctTag == null) {
            fctTag = giBuilder.addTagAfter("FUNCTION_DATE_ER", "FUNCTION_DATE_CONVERT");
            fctTag.setProperty("mp", fctTag.getName());
        }
        return fctTag;
    }
}

