/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.extension.micropattern;

import com.ibm.pdp.engine.IBuilderTag;
import com.ibm.pdp.engine.IGenInfoBuilder;
import com.ibm.pdp.engine.IMicroPattern;
import com.ibm.pdp.framework.PdpTool;
import com.ibm.pdp.framework.cobol.micropattern.internal.MicroPatternConstants;

public class DCDIDVMicroPatternUtilities
implements MicroPatternConstants {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2015, 2019.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static String[] COBOL_STATEMENTS = new String[]{"ORDER", "MOVE", "GO ", "IF", "ELSE", "PERFORM", "EXEC", "ADD", "COMPUTE", "DIVIDE", "MULTIPLY", "SUBTRACT", "CALL", "CLOSE", "DELETE", "DISPLAY", "INITIALIZE", "INSPECT", "GOBACK", "OPEN", "READ", "WRITE", "STRING", "UNSTRING", "ACCEPT", "CANCEL", "COMMIT", "CONTINUE", "DROP", "ENTER", "EVALUATE", "MERGE", "RELEASE", "RETURN", "REWRITE", "ROLLBACK", "SEARCH", "SET", "SORT", "START", "STOP", "EXIT", "ACQUIRE", "ALTER", "XML GENERATE", "XML PARSE", "FROM", "INTO", "FOR BROWSE ACCESS", "FOR UPDATE", "FOR FETCH ONLY", "UNLOCK"};

    public static void AddNextSentenceFragment(IBuilderTag mpTag, IMicroPattern microPattern, IGenInfoBuilder giBuilder, String newLine, boolean isInSpecific) {
        String fctName = DCDIDVMicroPatternUtilities.searchFunction(microPattern, newLine);
        IBuilderTag generatedTag = null;
        if (isInSpecific) {
            int index = microPattern.getLocation().getEndIndex();
            generatedTag = mpTag.firstSon();
            while (generatedTag != null && generatedTag.getBeginIndex() < index) {
                generatedTag = generatedTag.nextTag();
            }
        } else {
            generatedTag = giBuilder.tagFromName(String.valueOf(mpTag.getName()) + "_" + microPattern.getId());
        }
        if (generatedTag != null) {
            int index;
            IBuilderTag tag = null;
            int beginIndex = index = generatedTag.getEndIndex();
            String s = new String(microPattern.getProcessingContext().getGeneratedInfo().toGeneratedInfoBuilder().getText().subSequence(index, mpTag.getParent().getEndIndex()).toString());
            int indiceIf = s.indexOf("IF");
            if (indiceIf != -1) {
                int indiceEndTagBeforeIf = s.substring(0, indiceIf).lastIndexOf(newLine);
                s = s.substring(0, indiceEndTagBeforeIf);
            }
            String[] allLines = PdpTool.splitTextIntoArrayLines((String)s);
            boolean cond = false;
            boolean process = false;
            int i = 0;
            while (i < allLines.length) {
                String line = allLines[i];
                if (DCDIDVMicroPatternUtilities.IsNextSentenceNeeded(line)) {
                    beginIndex = index;
                    process = true;
                    break;
                }
                index = index + line.length() + newLine.length();
                if (line.trim().startsWith("AND") || line.trim().startsWith("OR")) {
                    beginIndex = index;
                    cond = true;
                }
                ++i;
            }
            if (!process && !cond) {
                beginIndex = generatedTag.getEndIndex();
            }
            tag = giBuilder.addTag(beginIndex, beginIndex, String.valueOf(generatedTag.getName()) + "_Next", generatedTag.getParent().getName());
            tag.setProperty("mp", tag.getName());
            tag.setProperty("GSVLabel", DCDIDVMicroPatternUtilities.getGSVLabel(microPattern));
            StringBuilder sb = new StringBuilder(200);
            sb.append("       ");
            sb.append("          NEXT SENTENCE ELSE GO TO    ");
            sb.append(fctName).append("-FN.");
            sb.append(newLine);
            tag.setText((CharSequence)sb.toString());
        }
    }

    private static String getGSVLabel(IMicroPattern microPattern) {
        StringBuilder sb = new StringBuilder("!");
        sb.append(microPattern.getId());
        sb.append(" Next Sentence");
        return sb.toString();
    }

    private static String searchFunction(IMicroPattern microPattern, String newLine) {
        int ind;
        String fctName = "";
        int index = microPattern.getLocation().getBeginIndex();
        String s = new String(microPattern.getProcessingContext().getGeneratedInfo().toGeneratedInfoBuilder().getText().subSequence(0, index).toString());
        String[] allLines = PdpTool.splitTextIntoArrayLines((String)s);
        int i = ind = allLines.length - 1;
        while (i > 0) {
            String line = allLines[i];
            if (line.startsWith("       ") && line.charAt(7) != ' ') {
                line = line.trim();
                fctName = line.substring(0, line.indexOf(46));
                break;
            }
            --i;
        }
        return fctName;
    }

    public static final boolean IsNextSentenceNeeded(String s) {
        if (s.trim().startsWith("*N")) {
            return true;
        }
        int i = 0;
        while (i < COBOL_STATEMENTS.length) {
            if (s.trim().startsWith(COBOL_STATEMENTS[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

