/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.extension.micropattern;

import com.ibm.pdp.engine.IGenInfoBuilder;
import com.ibm.pdp.engine.IMicroPattern;
import com.ibm.pdp.engine.IMicroPatternFilter;
import com.ibm.pdp.engine.IMicroPatternProcessingContext;
import com.ibm.pdp.framework.PdpTool;
import com.ibm.pdp.pacbase.extension.micropattern.AbstractMicroPatternFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class CommonMicroPatternFilter
extends AbstractMicroPatternFilter
implements IMicroPatternFilter {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2014.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public List<IMicroPattern> filters(List<IMicroPattern> microPatterns, IMicroPatternProcessingContext context) {
        IGenInfoBuilder gib = context.getGeneratedInfo().toGeneratedInfoBuilder();
        String newLine = PdpTool.determineDelimiterOfV2((CharSequence)gib.getText());
        context.setAttribute("NEW_LINE_CHARACTER", newLine);
        String pattern = gib.getProperty("pattern");
        boolean patternBatch = "com.ibm.pdp.pacbase.batch".equals(pattern);
        Collections.sort(microPatterns, new Comparator<IMicroPattern>(){

            @Override
            public int compare(IMicroPattern o1, IMicroPattern o2) {
                return o1.getLocation().getBeginIndex() - o2.getLocation().getBeginIndex();
            }

            @Override
            public boolean equals(Object o) {
                return super.equals(o);
            }
        });
        ArrayList<Integer> mpIds = new ArrayList<Integer>();
        Iterator<IMicroPattern> itMP = microPatterns.iterator();
        int id = 0;
        while (itMP.hasNext()) {
            IMicroPattern mp = itMP.next();
            if (!patternBatch) {
                String func;
                if (mp.getId().startsWith("X") && this.isXnnMicroPatternhandler(pattern, mp.getId())) {
                    func = mp.getId().substring(1);
                    mp.setUsageId("XNN");
                    mp.getAttributes().put("nn", func);
                } else if (mp.getId().startsWith("Y") && (func = mp.getId().substring(1)).trim().length() != 0) {
                    mp.setUsageId("YNN");
                    mp.getAttributes().put("nn", func);
                }
            }
            String mpId = mp.getAttribute("id");
            int mpIdInt = 0;
            try {
                mpIdInt = Integer.parseInt(mpId);
            }
            catch (NumberFormatException numberFormatException) {
                mpIdInt = 0;
            }
            if (mpIdInt > id) {
                id = mpIdInt;
            }
            boolean found = false;
            if (mpIds.size() > 0) {
                for (Integer idTemp : mpIds) {
                    if (!idTemp.equals(mpIdInt)) continue;
                    if (mpId != null) {
                        mp.getAttributes().remove("id");
                    }
                    found = true;
                }
            }
            if (found) continue;
            mpIds.add(mpIdInt);
        }
        context.setAttribute("lastId", String.valueOf(id));
        return microPatterns;
    }

    private boolean isXnnMicroPatternhandler(String pattern, String id) {
        if ("com.ibm.pdp.pacbase.dialog".equals(pattern)) {
            return !"XR".equals(id) && !"XP".equals(id) && !"XRU".equals(id) && !"XRN".equals(id) && !"XD".equals(id) && !"XW".equals(id) && !"XRW".equals(id) && !"XUN".equals(id) && !"XP1".equals(id);
        }
        if ("com.ibm.pdp.pacbase.csserver".equals(pattern)) {
            return !"XT".equals(id);
        }
        return true;
    }

    public String getName() {
        return "Common Micro Pattern Filter";
    }
}

