/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.extension.micropattern;

import com.ibm.icu.util.StringTokenizer;
import com.ibm.pdp.engine.IBuilderTag;
import com.ibm.pdp.engine.IGenInfoBuilder;
import com.ibm.pdp.engine.IMicroPattern;
import com.ibm.pdp.engine.IMicroPatternProcessingContext;
import com.ibm.pdp.framework.PdpTool;
import com.ibm.pdp.pacbase.PacTool;
import com.ibm.pdp.pacbase.extension.micropattern.AbstractCommonMicroPatternHandler;
import com.ibm.pdp.pacbase.extension.micropattern.Messages;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class COMicroPatternHandler
extends AbstractCommonMicroPatternHandler {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2013, 2019.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String MPCO_IDENTIFIER = "CO";
    private static final String SPACES_BEFORE_STATEMENT = "                       ";
    private String LABEL_FFSS_900 = "       ffss-900. ";
    private String LABEL_GOTO_900 = "GO TO ffmm-FN.";
    protected static final String LABEL_900 = "-900";
    private static final String IF_STATEMENT = "IF ";

    public String getId() {
        return MPCO_IDENTIFIER;
    }

    @Override
    protected String handleLocalFragment(IMicroPattern microPattern, IGenInfoBuilder genInfoBuilder) {
        IBuilderTag tagEvaluate;
        int ind;
        String oper = this.operandes(microPattern);
        if (oper == null) {
            return "";
        }
        IBuilderTag tag = COMicroPatternHandler.CurrentTag(microPattern);
        String levelCO = this.getLevel(tag);
        String ffss = tag.getName().substring(0, Math.min(5, tag.getName().length()));
        if (tag.getParent().getName().endsWith("-BODY")) {
            tag = tag.getParent();
        }
        if (tag.getParent().getProperty("msp") == null) {
            IBuilderTag tempTag = tag;
            tag = tag.getParent();
            while (!tempTag.getParent().getName().startsWith(ffss)) {
                tempTag = tempTag.getParent();
            }
            levelCO = this.getLevel(tempTag);
        }
        if ((ind = PacTool.searchTextInText(tag.getParent().getText().toString(), "    EVALUATE " + oper, true, true)) > 0 && (tagEvaluate = genInfoBuilder.includingTag(tag.getParent().getBeginIndex() + ind, tag.getParent().getBeginIndex() + ind)).getProperty("specificTag") != null) {
            this.logWarning(Messages.COMicroPatternHandler_INEFFECTIVE_MICRO_PATTERN, microPattern, tag.getParent());
        }
        IBuilderTag nextTag = tag.nextTag();
        String level = null;
        while (nextTag != null) {
            String ffssNextTag = nextTag.getName().substring(0, Math.min(5, nextTag.getName().length()));
            if (!ffss.equals(ffssNextTag)) {
                boolean isCO = false;
                String conditionLevel = nextTag.getProperty("level");
                if (conditionLevel == null || conditionLevel.compareTo(levelCO) > 0) {
                    String newLine = AbstractCommonMicroPatternHandler.GetProperty_NEW_LINE(microPattern.getProcessingContext());
                    int index = this.getIndexForIfStatement(nextTag.getText().toString(), microPattern.getProcessingContext());
                    if (index > 0) {
                        IBuilderTag tagIF = genInfoBuilder.includingTag(nextTag.getBeginIndex() + index, nextTag.getBeginIndex() + index);
                        String categ = COMicroPatternHandler.GetPropertyFor(tagIF.getParent(), "category");
                        String currentLevel = this.getLevel(tagIF);
                        if (conditionLevel != null && (currentLevel == null || conditionLevel.compareTo(currentLevel) == 0)) {
                            if (COMicroPatternHandler.GetPropertyFor(tagIF, "msp") != null || categ != null && "pac_function".equals(categ) && COMicroPatternHandler.GetPropertyFor(tagIF.getParent(), "msp") != null) {
                                if (level == null || level.compareTo(currentLevel) == 0) {
                                    String tagText = tagIF.getText().toString();
                                    if (this.isIfLinkedToCO(tagText, microPattern.getProcessingContext())) {
                                        String msp = COMicroPatternHandler.GetPropertyFor(tagIF, "msp");
                                        if (msp != null) {
                                            String newText = this.generateNewTextForCO(tagIF.getText().toString(), oper, msp, microPattern.getProcessingContext()).toString();
                                            int beginIndex = tagText.indexOf(IF_STATEMENT) + IF_STATEMENT.length();
                                            int endIndex = beginIndex + tagText.substring(beginIndex).indexOf(newLine);
                                            COMicroPatternHandler.ReplaceText(tagIF, tagIF.getBeginIndex() + beginIndex, tagIF.getBeginIndex() + endIndex + newLine.length(), newText, false);
                                        }
                                        isCO = true;
                                    }
                                    level = currentLevel;
                                }
                            } else if (!this.isSpecificGenerationOk(tagIF.getText().toString(), oper)) {
                                this.logWarning(Messages.COMicroPatternHandler_INVALID_SPECIFIC, microPattern, tagIF);
                            }
                        }
                    }
                    if (isCO) {
                        String text900 = this.LABEL_FFSS_900.replace("ffss", nextTag.getName());
                        index = nextTag.getText().toString().indexOf(text900);
                        if (index > 0) {
                            index = this.updateTheLast900Label(genInfoBuilder, nextTag, index, conditionLevel, level, text900);
                        }
                        if (index < 0 && nextTag.lastSon() != null) {
                            text900 = String.valueOf(text900) + this.LABEL_GOTO_900.replace("ffmm", tag.getParent().getName());
                            if (!tag.getName().endsWith("-BODY")) {
                                nextTag.lastSon().setTextAfter((CharSequence)(String.valueOf(text900) + newLine + nextTag.lastSon().getTextAfter()));
                            } else {
                                nextTag.lastSon().setTextBefore((CharSequence)(String.valueOf(text900) + newLine + nextTag.lastSon().getTextAfter()));
                            }
                        }
                    }
                }
            }
            nextTag = nextTag.nextTag();
        }
        this.setAllowedToHaveEmptyLocalContribution(microPattern, true);
        return "";
    }

    private boolean isSpecificGenerationOk(String text, String oper) {
        StringTokenizer words = new StringTokenizer(text);
        boolean found = false;
        boolean ifFound = false;
        boolean nextFound = false;
        while (words.hasMoreTokens()) {
            String word = words.nextToken();
            if (ifFound) {
                if ("NEXT".equals(word)) {
                    nextFound = true;
                    break;
                }
                if (word.equals(oper)) {
                    found = true;
                    break;
                }
            }
            if (!"IF".equals(word)) continue;
            ifFound = true;
        }
        if (!found && !nextFound) {
            found = true;
        }
        return found;
    }

    private boolean isIfLinkedToCO(String text, IMicroPatternProcessingContext context) {
        String[] lines = PdpTool.splitTextIntoArrayLines((String)text);
        int i = 0;
        while (i < lines.length) {
            if (lines[i].indexOf(IF_STATEMENT) > 0) {
                return lines[i].length() > 8 && lines[i].substring(0, 7).trim().length() == 0 && lines[i].charAt(7) != ' ';
            }
            ++i;
        }
        return false;
    }

    private int getIndexForIfStatement(String text, IMicroPatternProcessingContext context) {
        int index = 0;
        String[] lines = PdpTool.splitTextIntoArrayLines((String)text);
        int i = 0;
        while (i < lines.length) {
            if (!lines[i].trim().startsWith("*") && lines[i].indexOf(IF_STATEMENT) > 0) {
                return index += lines[i].indexOf(IF_STATEMENT);
            }
            index += lines[i].length();
            ++i;
        }
        return -1;
    }

    protected String getLevel(IBuilderTag tag) {
        String level = null;
        while (level == null) {
            level = tag.getParent().getProperty("level");
            tag = tag.getParent();
        }
        return level;
    }

    protected StringBuilder generateNewTextForCO(String text, String oper, String msp, IMicroPatternProcessingContext context) {
        StringBuilder result = new StringBuilder();
        StringBuilder newText = new StringBuilder();
        String newLine = COMicroPatternHandler.GetProperty_NEW_LINE(context);
        String[] lines = PdpTool.splitTextIntoArrayLines((String)text);
        int i = 0;
        while (i < lines.length) {
            String line = lines[i];
            if (line.contains(IF_STATEMENT)) {
                int ifIndex = line.indexOf(IF_STATEMENT) + 2;
                int endIndex = line.length();
                String textAfter = "";
                if (endIndex > 71) {
                    endIndex = 72;
                    textAfter = line.substring(endIndex);
                }
                String value = COMicroPatternHandler.trimRight(line.substring(ifIndex, endIndex));
                result.append("   ");
                result.append(oper).append(" =");
                if (textAfter.length() > 0) {
                    while (result.length() < 71 - ifIndex) {
                        result.append(" ");
                    }
                    result.append(textAfter);
                }
                result.append(newLine);
                textAfter = "";
                if (PacTool.markAtEndOfLine()) {
                    textAfter = msp;
                }
                newText.append(SPACES_BEFORE_STATEMENT).append(value.trim());
                if (textAfter.length() > 0) {
                    while (newText.length() < 72) {
                        newText.append(" ");
                    }
                    newText.append(textAfter);
                }
                result.append((CharSequence)newText).append(newLine);
                break;
            }
            ++i;
        }
        return result;
    }

    @Override
    protected void addOtherFragments(IMicroPattern microPattern, IGenInfoBuilder genInfoBuilder) {
    }

    protected int updateTheLast900Label(IGenInfoBuilder genInfoBuilder, IBuilderTag nextTag, int index, String currentLevel, String level, String text900) {
        return index;
    }

    @Override
    protected void convertToAttributes(IMicroPattern microPattern, Map<String, Object> parameters) {
        super.convertToAttributes(microPattern, parameters);
        Object prmDec = parameters.get("DEC");
        if (prmDec instanceof String) {
            microPattern.getAttributes().put("FIRST_ZONE", prmDec.toString());
        }
    }

    @Override
    protected LinkedHashMap<String, String> convertToParameters(IMicroPattern microPattern, String operandes) {
        List<String> oper = this.analyseOperande(this.operandes(microPattern), microPattern.getProcessingContext());
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        parameters.put("DEC", oper.get(0));
        return parameters;
    }
}

