/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.extension.micropattern;

import com.ibm.pdp.engine.IMicroPattern;
import com.ibm.pdp.pacbase.extension.micropattern.AbstractSimpleMicroPatternHandler;
import java.util.LinkedHashMap;
import java.util.Map;

public class COAMicroPatternHandler
extends AbstractSimpleMicroPatternHandler {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2019.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String MPCOA_IDENTIFIER = "COA";

    public String getId() {
        return MPCOA_IDENTIFIER;
    }

    protected String getMarge() {
        return "       ";
    }

    @Override
    protected void handleLocal(IMicroPattern microPattern, StringBuilder contribution) {
        String textInComment = this.operandes(microPattern);
        if (textInComment == null) {
            textInComment = microPattern.getConfigurationArea();
        }
        String ordrecobol = textInComment.trim();
        contribution.append(this.getMarge());
        contribution.append(ordrecobol);
        this.appendEndOfContribution(contribution, microPattern);
        contribution.append(COAMicroPatternHandler.GetProperty_NEW_LINE(microPattern.getProcessingContext()));
    }

    protected void appendEndOfContribution(StringBuilder contribution, IMicroPattern microPattern) {
        String dot = microPattern.getAttribute("DOT_OPERANDES");
        if (Boolean.parseBoolean(dot)) {
            contribution.append(".");
            microPattern.getAttributes().remove("DOT_OPERANDES");
        }
        while (contribution.length() < 72) {
            contribution.append(" ");
        }
        contribution.append(MPCOA_IDENTIFIER);
    }

    @Override
    protected boolean isDotInsertedInRightMargin() {
        return false;
    }

    @Override
    protected void convertToAttributes(IMicroPattern microPattern, Map<String, Object> parameters) {
        super.convertToAttributes(microPattern, parameters);
        Object prmPr1 = parameters.get("LBL");
        StringBuilder buffer = new StringBuilder("");
        if (prmPr1 != null && prmPr1 instanceof String) {
            buffer.append(prmPr1).append(' ');
        }
        microPattern.getAttributes().put("FIRST_ZONE", buffer.toString());
    }

    @Override
    protected LinkedHashMap<String, String> convertToParameters(IMicroPattern microPattern, String operandes) {
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        parameters.put("LBL", operandes);
        return parameters;
    }
}

