/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.extension.micropattern;

import com.ibm.pdp.mdl.pacbase.util.PacbasePattern;
import com.ibm.pdp.pacbase.extension.micropattern.WFGenerationContext;

public class BreakdateFormatter {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2015.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    private static StringBuilder formatterDate(StringBuilder sb, String start, String level, String prefix, String date, String type, String currentGeneratedDateFormat, WFGenerationContext wfCtx, String segmentCode, String newLine) {
        String totalPrefixForSecondNewLevel;
        String totalPrefixForFirstNewLevel;
        if (wfCtx != null && sb.toString().trim().startsWith("01")) {
            start = String.valueOf(start) + " ";
            prefix = prefix.substring(5);
        }
        String firstNewLevel = "";
        String secondNewLevel = "";
        if (level.length() > 0) {
            int i = Integer.parseInt(level);
            if (i == 1) {
                int j = 0;
                while (j < 4) {
                    start = String.valueOf(start) + " ";
                    ++j;
                }
            }
            if ((firstNewLevel = String.valueOf(++i)).trim().length() < 2) {
                firstNewLevel = "0" + firstNewLevel;
            }
            if ((secondNewLevel = String.valueOf(++i)).trim().length() < 2) {
                secondNewLevel = "0" + secondNewLevel;
            }
        }
        if (wfCtx != null && !wfCtx.getPattern().equals((Object)PacbasePattern.BATCH)) {
            totalPrefixForFirstNewLevel = wfCtx.getBeginningOfTheLine(Integer.parseInt(firstNewLevel), false, segmentCode.endsWith("00"), false) + prefix.trim();
            totalPrefixForSecondNewLevel = wfCtx.getBeginningOfTheLine(Integer.parseInt(secondNewLevel), false, segmentCode.endsWith("00"), false) + prefix.trim();
        } else {
            totalPrefixForFirstNewLevel = String.valueOf(start) + firstNewLevel + prefix;
            totalPrefixForSecondNewLevel = String.valueOf(start) + secondNewLevel + prefix;
        }
        sb.append(totalPrefixForFirstNewLevel);
        sb.append(date);
        if (type.startsWith("G") || type.startsWith("I") || type.startsWith("S")) {
            sb.append("-YYX.");
        } else if (currentGeneratedDateFormat.equals("E")) {
            sb.append("-MMX.");
        } else {
            sb.append("-DDX.");
        }
        sb.append(newLine);
        sb.append(totalPrefixForSecondNewLevel);
        sb.append(date);
        if (type.startsWith("I")) {
            sb.append("-YY PIC 99.");
        } else if (type.startsWith("G") || type.startsWith("S")) {
            sb.append("-YY PIC 9(4).");
        } else if (currentGeneratedDateFormat.equals("E")) {
            sb.append("-MM PIC 99.");
        } else {
            sb.append("-DD PIC 99.");
        }
        sb.append(newLine);
        if (type.startsWith("E") || type.startsWith("G") || type.startsWith("M")) {
            sb.append(totalPrefixForFirstNewLevel);
            sb.append(date);
            sb.append("-S1 PIC X.");
            sb.append(newLine);
        }
        sb.append(totalPrefixForFirstNewLevel);
        sb.append(date);
        if (type.startsWith("G") || type.startsWith("I") || type.startsWith("S")) {
            sb.append("-MMX.");
        } else if (currentGeneratedDateFormat.equals("E")) {
            sb.append("-DDX.");
        } else {
            sb.append("-MMX.");
        }
        sb.append(newLine);
        sb.append(totalPrefixForSecondNewLevel);
        sb.append(date);
        if (type.startsWith("G") || type.startsWith("I") || type.startsWith("S")) {
            sb.append("-MM PIC 99.");
        } else if (currentGeneratedDateFormat.equals("E")) {
            sb.append("-DD PIC 99.");
        } else {
            sb.append("-MM PIC 99.");
        }
        sb.append(newLine);
        if (type.startsWith("E") || type.startsWith("G") || type.startsWith("M")) {
            sb.append(totalPrefixForFirstNewLevel);
            sb.append(date);
            sb.append("-S2 PIC X.");
            sb.append(newLine);
        }
        sb.append(totalPrefixForFirstNewLevel);
        sb.append(date);
        if (type.startsWith("G") || type.startsWith("I") || type.startsWith("S")) {
            sb.append("-DDX.");
        } else {
            sb.append("-YYX.");
        }
        sb.append(newLine);
        sb.append(totalPrefixForSecondNewLevel);
        sb.append(date);
        if (type.startsWith("C") || type.startsWith("M")) {
            sb.append("-YY PIC 9(4).");
        } else if (type.startsWith("G") || type.startsWith("I") || type.startsWith("S")) {
            sb.append("-DD PIC 99.");
        } else {
            sb.append("-YY PIC 99.");
        }
        return sb;
    }

    public static StringBuilder GenerateBreakdate(String textBefore, String date, String typeDate, String textAfter, String newLine, String currentGeneratedDateFormat) {
        return BreakdateFormatter.GenerateBreakdate(textBefore, date, typeDate, textAfter, currentGeneratedDateFormat, null, null, newLine);
    }

    public static StringBuilder GenerateBreakdate(String textBefore, String date, String typeDate, String textAfter, String currentGeneratedDateFormat, WFGenerationContext wfCtx, String segmentCode, String newLine) {
        StringBuilder sb = new StringBuilder();
        sb.append(textBefore);
        sb.append(date);
        sb.append(textAfter);
        if (!sb.toString().endsWith(".")) {
            sb.append(".");
        }
        sb.append(newLine);
        String start = "";
        String level = "";
        String prefix = "";
        int i = 0;
        while (i < textBefore.length()) {
            char c = textBefore.charAt(i);
            if (c == ' ') {
                if (level.length() != 0) break;
                start = String.valueOf(start) + " ";
            } else {
                level = String.valueOf(level) + String.valueOf(c);
            }
            ++i;
        }
        prefix = textBefore.substring(start.length() + level.length());
        return BreakdateFormatter.formatterDate(sb, start, level, prefix, date, typeDate, currentGeneratedDateFormat, wfCtx, segmentCode, newLine);
    }
}

