/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.extension.micropattern;

import com.ibm.pdp.engine.IAnalyzerResult;
import com.ibm.pdp.engine.IBuilderTag;
import com.ibm.pdp.engine.IGenInfoBuilder;
import com.ibm.pdp.engine.IMicroPattern;
import com.ibm.pdp.engine.IMicroPatternProcessingContext;
import com.ibm.pdp.framework.PdpTool;
import com.ibm.pdp.mdl.kernel.DataElement;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.pacbase.PacGeneratedDateFormatValues;
import com.ibm.pdp.mdl.pacbase.lal.util.GenerationContext;
import com.ibm.pdp.mdl.pacbase.lal.util.LengthAndPositionVisitor;
import com.ibm.pdp.mdl.pacbase.lal.util.PacbaseLalDescription;
import com.ibm.pdp.pacbase.extension.micropattern.AbstractSimpleMicroPatternHandler;
import com.ibm.pdp.pacbase.extension.micropattern.BreakdateFormatter;
import com.ibm.pdp.pacbase.extension.micropattern.DateAndTimeWorkingMicroPatternFilter;
import com.ibm.pdp.pacbase.extension.micropattern.Messages;
import com.ibm.pdp.pacbase.extension.micropattern.internal.UniqueWLineMP;
import com.ibm.pdp.pacbase.extension.micropattern.internal.WorkingData;
import com.ibm.pdp.trace.PTTraceManager;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.ecore.EObject;

public abstract class AbstractWLineMicroPatternHandler
extends AbstractSimpleMicroPatternHandler {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2020.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static Pattern MPdelimiter = null;
    private static final String MPDelimiterRegex = "(\\.+|\\s)+";
    public static final String BeforeComment = "                            ";
    private static final String PICTURE = "                        PICTURE ";
    private static final String ATTRIBUTE_FORMAT = "FORMAT_FOR_W";
    private static final String ATTRIBUTE_COMMENT_OR_BLANK_WHEN_ZERO = "COMMENT_OR_BLANK_WHEN_ZERO";
    private static final String ATTRIBUTE_DATE = "IS_DATE";

    private static ArrayList<String> SearchAllMPs(String allText, String NEW_LINE) {
        ArrayList<String> result = new ArrayList<String>();
        Matcher m = MPdelimiter.matcher(allText);
        int index = 0;
        while (m.find()) {
            String res = allText.substring(index, m.end());
            index = m.end();
            result.add(res);
        }
        if (index < allText.length()) {
            result.add(allText.substring(index));
        }
        return result;
    }

    public String createCommentLine(IMicroPattern microPattern) {
        StringBuilder tmpSB = new StringBuilder(BeforeComment);
        if (this.getCommentOrBlankWhenZero(microPattern) == null) {
            return "";
        }
        if (this.getCommentOrBlankWhenZero(microPattern).trim().length() > 0) {
            tmpSB.append(this.getCommentOrBlankWhenZero(microPattern));
        }
        return tmpSB.toString();
    }

    public String createPictureLine(String dataElementCode, String oldContent, WorkingData wd, IMicroPattern microPattern) {
        boolean isDate;
        StringBuilder tmpSB = new StringBuilder(PICTURE);
        this.initFormatAndComment(dataElementCode, this.getReferenceFormat(), oldContent, wd, microPattern);
        String format = microPattern.getAttribute(ATTRIBUTE_FORMAT);
        boolean bl = isDate = microPattern.getAttribute(ATTRIBUTE_DATE) != null;
        if (this.isBreakdateOption(microPattern.getProcessingContext()) && isDate) {
            return format;
        }
        if (format == null || format.trim().length() == 0) {
            return null;
        }
        tmpSB.append(format);
        return tmpSB.toString();
    }

    @Override
    protected void handleLocal(IMicroPattern microPattern, StringBuilder contribution) {
    }

    protected void initFormatAndComment(String corub, String referenceFormat, String oldContent, WorkingData wd, IMicroPattern microPattern) {
        microPattern.getAttributes().put(ATTRIBUTE_FORMAT, null);
        microPattern.getAttributes().put(ATTRIBUTE_COMMENT_OR_BLANK_WHEN_ZERO, null);
        microPattern.getAttributes().put(ATTRIBUTE_DATE, null);
        EObject obj = this.searchReference(microPattern.getProcessingContext());
        if (obj instanceof RadicalEntity) {
            RadicalEntity re = (RadicalEntity)obj;
            DataElement dataelement = (DataElement)this.searchRadicalEntity(re.getProject(), re.getPackage(), corub, "dataelement", microPattern.getProcessingContext());
            if (dataelement != null) {
                this.initFormatAndComment(dataelement, referenceFormat, oldContent, wd, microPattern);
            } else {
                microPattern.getAttributes().put(ATTRIBUTE_FORMAT, null);
                String message = "No data Element " + corub + " from the reference " + re.getDesignId(re.getProject());
                if (TraceLevel > 0) {
                    PTTraceManager.getInstance().trace(AbstractWLineMicroPatternHandler.class, "com.ibm.pdp.pac", 1, message);
                }
            }
        }
    }

    protected void initFormatAndComment(DataElement dataelement, String referenceFormat, String oldContent, WorkingData wd, IMicroPattern microPattern) {
        IMicroPatternProcessingContext context = microPattern.getProcessingContext();
        EObject obj = this.searchReference(context);
        if (obj instanceof RadicalEntity && dataelement != null) {
            RadicalEntity re = (RadicalEntity)obj;
            PacGeneratedDateFormatValues generatedDateFormat = AbstractWLineMicroPatternHandler.SearchGeneratedDateFormatFor(re);
            wd.setEntity((RadicalEntity)dataelement);
            this.storeWorkingData(wd, context);
            this.registerReference((RadicalEntity)dataelement, context);
            GenerationContext ctx = new GenerationContext(AbstractWLineMicroPatternHandler.SearchVariantFor(re), AbstractWLineMicroPatternHandler.SearchGenerationParameterVariantFor(re), AbstractWLineMicroPatternHandler.SearchGeneratedLanguageFor(re), AbstractWLineMicroPatternHandler.SearchPatternForWorkingPurpose(re));
            LengthAndPositionVisitor lpv = new LengthAndPositionVisitor(null, ctx);
            lpv.doSwitch((EObject)dataelement);
            PacbaseLalDescription pld = lpv.getTopParentLal();
            String format = null;
            String commentOrBlankWhenZero = null;
            boolean isDate = false;
            if (pld != null) {
                ctx.setBreakDateOption(this.isBreakdateOption(context));
                if (pld.isDate(referenceFormat)) {
                    isDate = true;
                    if (this.isBreakdateOption(context) && this.isDate(pld, referenceFormat)) {
                        String typeDate = "";
                        if ("E".equals(referenceFormat)) {
                            typeDate = pld.getInputFormat();
                        } else if ("I".equals(referenceFormat)) {
                            typeDate = pld.getInternalFormat();
                            commentOrBlankWhenZero = AbstractWLineMicroPatternHandler.GetComments(pld, ctx, referenceFormat);
                        } else if ("S".equals(referenceFormat)) {
                            typeDate = pld.getOutputFormat();
                            commentOrBlankWhenZero = pld.isBlankWhenZero(ctx) ? "BLANK WHEN ZERO" : "";
                        }
                        int ind1 = oldContent.indexOf(pld.getName());
                        String textBefore = oldContent.substring(0, ind1);
                        String textAfter = oldContent.substring(ind1 + pld.getName().trim().length());
                        StringBuilder sb = BreakdateFormatter.GenerateBreakdate(textBefore, pld.getName(), typeDate, textAfter, AbstractWLineMicroPatternHandler.GetProperty_NEW_LINE(context), generatedDateFormat.toString().substring(1));
                        format = sb.toString();
                    } else {
                        isDate = this.isDate(pld, referenceFormat);
                        StringBuilder sb = new StringBuilder("X(");
                        if ("E".equals(referenceFormat)) {
                            sb.append(pld.getInputLength());
                        } else if ("I".equals(referenceFormat)) {
                            sb.append(pld.getInternalLength());
                            commentOrBlankWhenZero = AbstractWLineMicroPatternHandler.GetComments(pld, ctx, referenceFormat);
                        } else if ("S".equals(referenceFormat)) {
                            sb.append(pld.getOutputLength());
                            commentOrBlankWhenZero = pld.isBlankWhenZero(ctx) ? "BLANK WHEN ZERO" : "";
                        }
                        sb.append(")");
                        format = sb.toString();
                    }
                } else if ("E".equals(referenceFormat)) {
                    format = pld.getInputFormat();
                } else if ("I".equals(referenceFormat)) {
                    if (pld.isPictureNeeded()) {
                        format = pld.getInternalFormat();
                    }
                    commentOrBlankWhenZero = AbstractWLineMicroPatternHandler.GetComments(pld, ctx, referenceFormat);
                } else if ("S".equals(referenceFormat)) {
                    format = pld.getOutputFormat();
                    String string = commentOrBlankWhenZero = pld.isBlankWhenZero(ctx) ? "BLANK WHEN ZERO" : "";
                }
                if ("I".equals(referenceFormat)) {
                    format = AbstractWLineMicroPatternHandler.GetRealFormat(pld, format);
                }
                if ("E".equals(referenceFormat) || "I".equals(referenceFormat)) {
                    format = AbstractWLineMicroPatternHandler.TransformFormat(format);
                }
                microPattern.getAttributes().put(ATTRIBUTE_COMMENT_OR_BLANK_WHEN_ZERO, commentOrBlankWhenZero);
                microPattern.getAttributes().put(ATTRIBUTE_FORMAT, format);
                if (isDate) {
                    microPattern.getAttributes().put(ATTRIBUTE_DATE, "notNull");
                } else {
                    microPattern.getAttributes().remove(ATTRIBUTE_DATE);
                }
            }
        }
    }

    public boolean isDate(IMicroPattern microPattern) {
        return microPattern.getAttributes().containsKey(ATTRIBUTE_DATE);
    }

    public String getCommentOrBlankWhenZero(IMicroPattern microPattern) {
        return (String)microPattern.getAttributes().get(ATTRIBUTE_COMMENT_OR_BLANK_WHEN_ZERO);
    }

    public abstract String getReferenceFormat();

    protected void organizeTags(IMicroPattern microPattern, int endIndex) {
        IGenInfoBuilder giBuilder = microPattern.getProcessingContext().getGeneratedInfo().toGeneratedInfoBuilder();
        IBuilderTag tag = giBuilder.includingTag(microPattern.getLocation().getBeginIndex(), endIndex);
        if (tag.hasSon()) {
            int mpBeg = microPattern.getLocation().getBeginIndex();
            IBuilderTag currentTag = tag;
            IBuilderTag nextTag = tag.firstSon();
            boolean mpInOneTag = false;
            while (!mpInOneTag && nextTag != null) {
                mpInOneTag = currentTag.getBeginIndex() <= mpBeg && nextTag.getBeginIndex() >= endIndex;
                currentTag = nextTag;
                nextTag = nextTag.nextTag();
            }
            if (!mpInOneTag) {
                boolean bl = mpInOneTag = currentTag.getEndIndex() <= mpBeg && tag.getEndIndex() >= endIndex;
            }
            if (!mpInOneTag) {
                currentTag = AbstractWLineMicroPatternHandler.CurrentTag(microPattern);
                int locBegin = microPattern.getLocation().getBeginIndex();
                int locEnd = microPattern.getLocation().getEndIndex();
                nextTag = giBuilder.includingTag(endIndex - 5, endIndex);
                String mpBeginText = new StringBuilder(giBuilder.getText().subSequence(mpBeg, nextTag.getBeginIndex())).toString();
                nextTag.setTextBefore(nextTag.getTextBefore().subSequence(0, nextTag.getTextBefore().length() - mpBeginText.length()));
                nextTag.setText((CharSequence)(String.valueOf(mpBeginText) + nextTag.getText()));
                String mpEndText = new StringBuilder(giBuilder.getText().subSequence(currentTag.getEndIndex(), endIndex)).toString();
                currentTag.setTextAfter((CharSequence)currentTag.getTextAfter().toString().substring(mpEndText.length()));
                currentTag.setText((CharSequence)(currentTag.getText() + mpEndText));
                microPattern.getLocation().shift(locBegin - microPattern.getLocation().getBeginIndex());
                microPattern.getLocation().shiftEnd(locEnd - microPattern.getLocation().getEndIndex());
            }
        }
    }

    protected UniqueWLineMP testIfRedefines(IGenInfoBuilder genInfoBuilder, int index, String mpContent, IMicroPatternProcessingContext context) {
        int endIndex = DateAndTimeWorkingMicroPatternFilter.SearchCommentBefore(genInfoBuilder.getText().toString(), index, AbstractWLineMicroPatternHandler.GetProperty_NEW_LINE(context));
        String before = new StringBuilder(genInfoBuilder.getText().subSequence(0, endIndex - AbstractWLineMicroPatternHandler.GetProperty_NEW_LINE(context).length())).toString();
        String line = before.substring(endIndex = before.lastIndexOf(AbstractWLineMicroPatternHandler.GetProperty_NEW_LINE(context)));
        if (line.length() > 72) {
            line = line.substring(0, 72);
        }
        if ((line = line.trim()).endsWith("REDEFINES")) {
            UniqueWLineMP gen = new UniqueWLineMP("        10  " + mpContent.substring(6), AbstractWLineMicroPatternHandler.GetProperty_NEW_LINE(context), true);
            return gen;
        }
        return null;
    }

    protected StringBuilder completeGSVLabel(String GSVLabel, String text) {
        StringBuilder sb = new StringBuilder();
        sb.append(GSVLabel);
        sb.append(" ");
        String[] al = new String[3];
        StringBuilder sb1 = new StringBuilder();
        int indice = 0;
        int i = 0;
        while (i < text.toString().length()) {
            if (text.toString().charAt(i) != ' ') {
                sb1.append(text.toString().charAt(i));
            } else if (sb1.length() > 0 && indice < 3) {
                al[indice] = sb1.toString();
                ++indice;
                sb1 = new StringBuilder();
            }
            ++i;
        }
        if (sb1.length() > 0 && indice < 3) {
            al[indice] = sb1.toString();
        }
        sb.append(al[1]);
        return sb;
    }

    @Override
    public void process(IMicroPattern microPattern, IGenInfoBuilder genInfoBuilder) {
        UniqueWLineMP.TextAndTags textAndTags;
        String GSVLabel = this.getGSVLabel(microPattern);
        IAnalyzerResult mpAnalyzerResult = microPattern.getAnalyzerResult();
        if (mpAnalyzerResult != null) {
            this.convertToAttributes(microPattern, mpAnalyzerResult.getParameters());
        }
        this.beforeProcess(microPattern);
        StringBuilder contribution = new StringBuilder();
        MPdelimiter = Pattern.compile(MPDelimiterRegex + AbstractWLineMicroPatternHandler.GetProperty_NEW_LINE(microPattern.getProcessingContext()));
        int index = microPattern.getLocation().getBeginIndex() + microPattern.getOriginalHeaderDeclaration().length();
        IBuilderTag currentTag = AbstractWLineMicroPatternHandler.CurrentTag(microPattern);
        String text = new StringBuilder(genInfoBuilder.getText().subSequence(index, Math.min(genInfoBuilder.getText().length(), index + 100))).toString();
        int indexEndText = index + text.indexOf(AbstractWLineMicroPatternHandler.GetProperty_NEW_LINE(microPattern.getProcessingContext())) + AbstractWLineMicroPatternHandler.GetProperty_NEW_LINE(microPattern.getProcessingContext()).length();
        IBuilderTag tmpTag = genInfoBuilder.includingTag(index, indexEndText);
        if (!currentTag.equals(tmpTag)) {
            this.logWarning(Messages.WIESMicroPatternHandler_NO_DATA_ELEMENT_CALL, microPattern);
            return;
        }
        text = new StringBuilder(genInfoBuilder.getText().subSequence(index, indexEndText)).toString();
        StringBuilder sb = this.completeGSVLabel(GSVLabel, text);
        ArrayList<String> l = AbstractWLineMicroPatternHandler.SearchAllMPs(text, AbstractWLineMicroPatternHandler.GetProperty_NEW_LINE(microPattern.getProcessingContext()));
        String mpContent = l.size() > 0 ? (String)l.get(0) : "";
        int mpEndIndex = index + mpContent.length();
        UniqueWLineMP gen = new UniqueWLineMP(mpContent, AbstractWLineMicroPatternHandler.GetProperty_NEW_LINE(microPattern.getProcessingContext()), false);
        if (!gen.isWellFormed()) {
            UniqueWLineMP genForRedefine = this.testIfRedefines(genInfoBuilder, index, mpContent, microPattern.getProcessingContext());
            if (genForRedefine == null || !genForRedefine.isWellFormed()) {
                this.logWarning(Messages.MicroPatternHandler_OPERANDE_NOT_COMPLIANT, microPattern);
                return;
            }
            gen = genForRedefine;
        }
        if (!(textAndTags = gen.generate(this, microPattern)).isWellFormed()) {
            this.logWarning(textAndTags.getErrorMessage(), microPattern);
            return;
        }
        int headerLength = microPattern.getOriginalHeaderDeclaration().length();
        this.organizeTags(microPattern, index + (Integer)textAndTags.getIndexes().get(0));
        boolean inUserCode = AbstractWLineMicroPatternHandler.IsInSpecificCode(microPattern);
        if (inUserCode) {
            contribution.append(this.getNewHeader(microPattern, microPattern.getOriginalHeaderDeclaration()));
        } else {
            contribution.append(microPattern.getOriginalHeaderDeclaration());
        }
        headerLength = contribution.length();
        contribution.append(textAndTags.getText().substring(0, (Integer)textAndTags.getIndexes().get(0)));
        IBuilderTag tag = AbstractWLineMicroPatternHandler.CurrentTag(microPattern);
        boolean somethingAfterMP = tag.getEndIndex() != mpEndIndex;
        int mpBegin = microPattern.getLocation().getBeginIndex();
        int mpEnd = microPattern.getLocation().getEndIndex() + text.length();
        AbstractWLineMicroPatternHandler.ReplaceText(tag, mpBegin, mpEnd, contribution.toString(), false);
        text = textAndTags.getText().substring((Integer)textAndTags.getIndexes().get(0));
        if (text.length() != 0) {
            text = this.indentText(text, microPattern);
        }
        if (text.length() > 0) {
            this.addDotIfNeeded(microPattern, new StringBuilder(text));
            int ind = mpBegin + headerLength + (Integer)textAndTags.getIndexes().get(0);
            if (!inUserCode && (somethingAfterMP || AbstractWLineMicroPatternHandler.IsSeveralMPinTag(tag))) {
                AbstractWLineMicroPatternHandler.ReplaceText(tag, ind, ind, text, false);
            } else {
                if (inUserCode && "true".equals(microPattern.getProcessingContext().getData("DOUBLE_ON_MICRO_PATTERN"))) {
                    this.cleanAlreadyGeneratedMicroPattern(microPattern, text, genInfoBuilder, ind);
                }
                tag = AbstractWLineMicroPatternHandler.AddTag(genInfoBuilder, ind, ind, this.getDefaultTagName(microPattern, inUserCode), inUserCode ? tag.getName() : tag.getParent().getName());
                tag.setProperty("GSVLabel", sb.toString());
                if (inUserCode) {
                    tag.setProperty("specificMP", this.findId(microPattern));
                }
                tag.setText((CharSequence)text);
            }
        }
        this.afterProcess(microPattern);
    }

    protected String addDotInProperty(IMicroPattern microPattern, CharSequence oldHeader) {
        StringBuilder newHeader = new StringBuilder(oldHeader);
        if (newHeader.indexOf("DOT=") < 0) {
            String newAttribute = " DOT=\"true\"";
            String[] lines = PdpTool.splitTextIntoArrayLines((String)newHeader.toString());
            int idx = 0;
            int i = 0;
            while (i < lines.length) {
                String line = lines[i];
                idx += line.length();
                if (i == lines.length - 1) {
                    if (line.length() + newAttribute.length() > 72) {
                        newHeader.append("      ");
                        newHeader.append('*');
                        newHeader.append(newAttribute);
                        newHeader.append(AbstractWLineMicroPatternHandler.GetProperty_NEW_LINE(microPattern.getProcessingContext()));
                    } else {
                        newHeader.insert(idx, newAttribute);
                    }
                }
                idx += AbstractWLineMicroPatternHandler.GetProperty_NEW_LINE(microPattern.getProcessingContext()).length();
                ++i;
            }
        }
        return newHeader.toString();
    }

    @Override
    public boolean isAnnotationsNeededInMacro() {
        return true;
    }

    @Override
    protected String controlIndentLine(IMicroPattern microPattern, String line, int indentDiff) {
        String resultControl = super.controlIndentLine(microPattern, line, indentDiff);
        if (resultControl.trim().length() == 0 && resultControl.length() < 11) {
            return Messages.MicroPatternHandler_WRONG_INDENT;
        }
        return resultControl;
    }
}

