/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.extension.micropattern;

import com.ibm.pdp.engine.IGenInfoBuilder;
import com.ibm.pdp.engine.IMicroPattern;
import com.ibm.pdp.pacbase.extension.micropattern.AbstractCommonMicroPatternHandler;
import com.ibm.pdp.pacbase.extension.micropattern.Messages;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractSimpleMicroPatternHandler
extends AbstractCommonMicroPatternHandler {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2011, 2021.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    protected abstract void handleLocal(IMicroPattern var1, StringBuilder var2);

    @Override
    protected void addOtherFragments(IMicroPattern microPattern, IGenInfoBuilder genInfoBuilder) {
    }

    @Override
    protected String handleLocalFragment(IMicroPattern microPattern, IGenInfoBuilder genInfoBuilder) {
        StringBuilder result = new StringBuilder();
        this.handleLocal(microPattern, result);
        return result.toString();
    }

    protected boolean isDotGenerated(IMicroPattern microPattern) {
        String dotAttribute = microPattern.getAttribute("DOT");
        return dotAttribute == null || !"false".equalsIgnoreCase(dotAttribute);
    }

    protected void convertERUFAmilyToAttributes(IMicroPattern microPattern, Map<String, Object> parameters) {
        super.convertToAttributes(microPattern, parameters);
        Object prmErc = parameters.get("ERC");
        Object prmDec = parameters.get("DEC");
        StringBuilder buffer = new StringBuilder("");
        if (prmErc instanceof String) {
            buffer.append(prmErc).append(' ');
        }
        if (prmDec instanceof String) {
            buffer.append(prmDec);
        }
        microPattern.getAttributes().put("FIRST_ZONE", buffer.toString());
    }

    protected LinkedHashMap<String, String> convertERUFamilyToParameters(IMicroPattern microPattern, String operandes) {
        List<String> oper = this.analyseOperande(this.operandes(microPattern), microPattern.getProcessingContext());
        if (oper.size() > 2) {
            microPattern.getAttributes().remove("InvalidSequenceInMPConversion");
            this.logWarning(Messages.ERUMicroPatternHandler_TOO_MUCH_PARAMETER, microPattern);
            return null;
        }
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        if (oper.size() == 1) {
            parameters.put("ERC", oper.get(0));
            return parameters;
        }
        if (oper.size() == 2) {
            parameters.put("ERC", oper.get(0));
            parameters.put("DEC", AbstractSimpleMicroPatternHandler.valueToString(oper.get(1)));
            return parameters;
        }
        return null;
    }

    protected void convertGxxFAmilyToAttributes(IMicroPattern microPattern, Map<String, Object> parameters) {
        super.convertToAttributes(microPattern, parameters);
        Object prmDot = parameters.get("DOT");
        if (prmDot != null) {
            microPattern.getAttributes().put("DOT", prmDot.toString());
        }
    }

    protected LinkedHashMap<String, String> convertGxxFamilyToParameters(IMicroPattern microPattern, String operandes) {
        List<String> oper = this.analyseOperande(this.operandes(microPattern), microPattern.getProcessingContext());
        if (oper.size() > 0 && microPattern.getAttribute("DOT") == null) {
            microPattern.getAttributes().remove("InvalidSequenceInMPConversion");
            this.logWarning(Messages.SimpleGxxMicroPatternHandler_TOO_MUCH_PARAMETER, microPattern);
            return null;
        }
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        if (microPattern.getAttribute("DOT") != null) {
            parameters.put("DOT", microPattern.getAttribute("DOT"));
            return parameters;
        }
        return null;
    }

    protected void convertPrmFamilyToAttributes(IMicroPattern microPattern, Map<String, Object> parameters) {
        super.convertToAttributes(microPattern, parameters);
        Object prmPrm = parameters.get("PRM");
        if (prmPrm instanceof String) {
            microPattern.getAttributes().put("FIRST_ZONE", (String)prmPrm);
        }
    }

    protected LinkedHashMap<String, String> convertPrmFamilyToParameters(IMicroPattern microPattern, String operandes) {
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        parameters.put("PRM", operandes);
        return parameters;
    }

    private static String valueToString(String sValue) {
        String result = sValue;
        if (sValue.startsWith("'") && sValue.endsWith("'")) {
            StringBuilder buffer = new StringBuilder(sValue);
            buffer.insert(0, "\"").append("\"");
            result = buffer.toString();
        }
        return result;
    }
}

