/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.extension.micropattern;

import com.ibm.pdp.engine.IMicroPattern;
import com.ibm.pdp.engine.IMicroPatternProcessingContext;
import com.ibm.pdp.pacbase.extension.micropattern.AbstractSimpleMicroPatternHandler;
import com.ibm.pdp.pacbase.extension.micropattern.YnnMicroPatternHandler;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractNNMicroPatternhandler
extends AbstractSimpleMicroPatternHandler {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2019.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String ATTRIBUTE_NN = "nn";

    protected abstract String getBeginningSequence();

    protected abstract String getEndingSequence();

    protected String getLineContent(String functionCode, String modifier, String service) {
        StringBuilder result = new StringBuilder(this.getBeginningSequence());
        result.append(functionCode);
        result.append("-");
        result.append(modifier);
        if (this.isServiceNeeded() && service.length() > 0) {
            result.append("-");
            result.append(service);
        }
        result.append(this.getEndingSequence());
        return result.toString();
    }

    protected abstract boolean isServiceNeeded();

    @Override
    protected void handleLocal(IMicroPattern microPattern, StringBuilder contribution) {
        String modifier = microPattern.getAttribute(ATTRIBUTE_NN);
        IMicroPatternProcessingContext context = microPattern.getProcessingContext();
        List<String> operandes = this.analyseOperande(this.operandes(microPattern), context);
        String codeFonc = "";
        String service = "";
        Iterator<String> ito = operandes.iterator();
        if (ito.hasNext()) {
            codeFonc = ito.next().trim();
        }
        if (ito.hasNext()) {
            service = ito.next().trim();
        }
        if (codeFonc.length() > 4) {
            codeFonc = codeFonc.substring(0, 4);
        }
        contribution.append((CharSequence)this.addFormattedCobolLineWithoutNewLine(this.getLineContent(codeFonc, modifier, service)));
        if (this instanceof YnnMicroPatternHandler) {
            while (contribution.length() < 72) {
                contribution.append(" ");
            }
            contribution.append("COA");
        }
        contribution.append(AbstractNNMicroPatternhandler.GetProperty_NEW_LINE(context));
    }

    @Override
    protected void convertToAttributes(IMicroPattern microPattern, Map<String, Object> parameters) {
        super.convertToAttributes(microPattern, parameters);
        Object param1 = parameters.get("SE1");
        if (param1 instanceof String) {
            microPattern.getAttributes().put("FIRST_ZONE", (String)param1);
        }
    }

    @Override
    protected LinkedHashMap<String, String> convertToParameters(IMicroPattern microPattern, String operandes) {
        try {
            LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
            parameters.put("SE1", operandes);
            return parameters;
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }
}

