/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.extension.micropattern;

import com.ibm.pdp.engine.IMicroPattern;
import com.ibm.pdp.engine.IMicroPatternProcessingContext;
import com.ibm.pdp.pacbase.extension.micropattern.AbstractSimpleMicroPatternHandler;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractMASMicroPatternHandler
extends AbstractSimpleMicroPatternHandler {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2019.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    @Override
    protected void handleLocal(IMicroPattern microPattern, StringBuilder contribution) {
        IMicroPatternProcessingContext context = microPattern.getProcessingContext();
        if (this.checkStatus(context)) {
            List<Object> paramList = new ArrayList();
            String param = "";
            contribution.append("           ");
            contribution.append(this.getOperLabel());
            String textInComment = this.operandes(microPattern);
            String paramLine = textInComment.trim();
            if (paramLine.length() == 0) {
                this.logWarning("Absence de param\u00e8tres", microPattern);
            }
            paramList = this.analyseOperande(textInComment, context);
            int k = 0;
            int l = paramList.size();
            k = 0;
            while (k < l) {
                param = (String)paramList.get(k);
                param = param.replace(AbstractMASMicroPatternHandler.GetProperty_NEW_LINE(context), String.valueOf(AbstractMASMicroPatternHandler.GetProperty_NEW_LINE(context)) + "           ");
                if (k == 0) {
                    contribution.append(String.valueOf(param) + this.getLinkLabel());
                } else {
                    contribution.append(param);
                    if (param.indexOf(AbstractMASMicroPatternHandler.GetProperty_NEW_LINE(context)) == -1 && k + 1 < l) {
                        contribution.append(" ");
                    }
                }
                ++k;
            }
            contribution.append(AbstractMASMicroPatternHandler.GetProperty_NEW_LINE(context));
        }
    }

    public abstract String getOperLabel();

    public abstract String getLinkLabel();

    @Override
    protected void convertToAttributes(IMicroPattern microPattern, Map<String, Object> parameters) {
        super.convertToAttributes(microPattern, parameters);
        Object prmPr1 = parameters.get("PR1");
        Object prmPr2 = parameters.get("PR2");
        Object prmSfx = parameters.get("SFX");
        StringBuilder buffer = new StringBuilder("");
        if (prmPr1 != null && prmPr1 instanceof String) {
            buffer.append(prmPr1).append(' ');
        }
        if (prmPr2 != null && prmPr2 instanceof String) {
            buffer.append(' ').append(prmPr2);
        }
        if (prmSfx != null && prmSfx instanceof String) {
            buffer.append(' ').append(prmSfx).append(' ');
        }
        microPattern.getAttributes().put("FIRST_ZONE", buffer.toString());
    }

    @Override
    protected LinkedHashMap<String, String> convertToParameters(IMicroPattern microPattern, String operandes) {
        List<String> oper = this.analyseOperande(this.operandes(microPattern), microPattern.getProcessingContext());
        String[] tokens = this.modifyOperandes(oper, microPattern.getProcessingContext());
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        if (tokens.length == 1) {
            parameters.put("PR1", tokens[0]);
            return parameters;
        }
        if (tokens.length == 2) {
            parameters.put("PR1", tokens[0]);
            parameters.put("PR2", tokens[1]);
            return parameters;
        }
        if (tokens.length == 3) {
            parameters.put("PR1", tokens[0]);
            parameters.put("PR2", tokens[1]);
            parameters.put("SFX", tokens[2]);
            return parameters;
        }
        return null;
    }

    protected String[] modifyOperandes(List<String> operandes, IMicroPatternProcessingContext context) {
        Iterator<String> it = operandes.iterator();
        ArrayList<String> result = new ArrayList<String>();
        String nl = AbstractMASMicroPatternHandler.GetProperty_NEW_LINE(context);
        while (it.hasNext()) {
            String item = it.next();
            int index = item.indexOf(nl);
            while (index != -1) {
                result.add(item.substring(0, index));
                item = item.substring(index + nl.length());
                index = item.indexOf(nl);
            }
            result.add(item);
        }
        String[] tokens = new String[result.size()];
        tokens = result.toArray(tokens);
        return tokens;
    }
}

