/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.extension.micropattern;

import com.ibm.icu.util.StringTokenizer;
import com.ibm.pdp.engine.IBuilderTag;
import com.ibm.pdp.engine.IMicroPattern;
import com.ibm.pdp.pacbase.extension.micropattern.AbstractSimpleMicroPatternHandler;
import com.ibm.pdp.pacbase.extension.micropattern.Messages;

public abstract class AbstractGOTOMicroPatternhandler
extends AbstractSimpleMicroPatternHandler {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2019.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    protected String searchFunction(IMicroPattern microPattern, String valueToSearch, boolean inUserCode) {
        int index = microPattern.getLocation().getBeginIndex();
        String s = new StringBuilder(microPattern.getProcessingContext().getGeneratedInfo().toGeneratedInfoBuilder().getText().subSequence(0, index)).toString();
        boolean found = false;
        String etiquette = null;
        int beginIndexForText = s.length();
        String firstLabelFound = null;
        int newLineLength = AbstractGOTOMicroPatternhandler.GetProperty_NEW_LINE(microPattern.getProcessingContext()).length();
        while (!found) {
            int lineLength;
            String line = null;
            int currentIndex = index - 1;
            while (currentIndex != 0) {
                if (s.charAt(currentIndex) == '\n') {
                    line = s.substring(currentIndex + newLineLength - 1, index);
                    break;
                }
                --currentIndex;
            }
            if (line == null) break;
            index = currentIndex - newLineLength + 1;
            found = line.startsWith("       ") && line.charAt(7) != ' ';
            beginIndexForText = beginIndexForText - line.length() - newLineLength;
            if (!found) continue;
            if ((line = line.trim()).charAt((lineLength = line.length()) - 4) == 'l' && line.charAt(lineLength - 3) == 'v') {
                int firstBlank;
                String level = line.substring(lineLength - 2);
                if (firstLabelFound == null) {
                    firstLabelFound = line.substring(0, 3);
                }
                if (level.compareTo(valueToSearch) > 0) {
                    found = false;
                }
                if (level.compareTo(valueToSearch) != 0 || (etiquette = line.substring(0, (firstBlank = line.indexOf(" ")) - 1)).startsWith(firstLabelFound)) continue;
                etiquette = null;
                continue;
            }
            found = false;
        }
        IBuilderTag tag = AbstractGOTOMicroPatternhandler.CurrentTag(microPattern);
        tag = this.searchFunction(tag, valueToSearch, inUserCode);
        int beginIndexForTag = -1;
        if (tag != null) {
            beginIndexForTag = tag.getBeginIndex() + AbstractGOTOMicroPatternhandler.FirstIndexLabelFromTag(tag, AbstractGOTOMicroPatternhandler.GetProperty_NEW_LINE(microPattern.getProcessingContext()));
        }
        if (beginIndexForText != -1 && beginIndexForText > beginIndexForTag) {
            return etiquette;
        }
        if (beginIndexForTag != -1) {
            if (this.getLabel(tag) != null) {
                return this.getLabel(tag);
            }
            if (beginIndexForTag == beginIndexForText) {
                return etiquette;
            }
            return tag.getName();
        }
        return null;
    }

    protected IBuilderTag searchFunction(IBuilderTag tag, String valueToSearch, boolean inUserCode) {
        if (tag.getName().equals("PROCEDURE")) {
            return null;
        }
        String currentLevel = AbstractGOTOMicroPatternhandler.GetPropertyFor(tag, "level");
        if (currentLevel != null) {
            if (valueToSearch == null) {
                return tag;
            }
            if (valueToSearch.equals(currentLevel)) {
                return tag;
            }
            if (currentLevel.compareTo(valueToSearch) > 0) {
                return this.searchFunction(tag.getParent(), valueToSearch, inUserCode);
            }
            if ("10".equals(valueToSearch)) {
                if ("09.5".equals(currentLevel) || "00".equals(currentLevel)) {
                    return tag;
                }
                return this.searchFunction(tag.getParent(), valueToSearch, inUserCode);
            }
            return null;
        }
        return this.searchFunction(tag.getParent(), valueToSearch, inUserCode);
    }

    protected String getLabel(IBuilderTag tag) {
        return tag.getName();
    }

    protected abstract String endOfGeneration();

    @Override
    public String operandes(IMicroPattern microPattern) {
        String oper = super.operandes(microPattern);
        if (oper != null && oper.trim().length() > 0) {
            StringTokenizer st = new StringTokenizer(oper);
            oper = st.nextToken();
        }
        return oper;
    }

    @Override
    protected void handleLocal(IMicroPattern microPattern, StringBuilder contribution) {
        String fct;
        String oper = this.operandes(microPattern);
        boolean isNumeric = false;
        if (oper != null) {
            int l = oper.length();
            isNumeric = true;
            int i = 0;
            while (i < l && isNumeric) {
                isNumeric = Character.isDigit(oper.charAt(i));
                ++i;
            }
        }
        if ((fct = this.searchFunction(microPattern, oper, AbstractGOTOMicroPatternhandler.IsInSpecificCode(microPattern))) == null) {
            this.logWarning(Messages.GTMicroPatternHandler_LEVEL_IN_OPERANDE_NOT_FOUND, microPattern);
        }
        if ((fct = this.validateFunction(fct, isNumeric)) == null) {
            return;
        }
        contribution.append("           ");
        contribution.append("GO TO ");
        contribution.append(fct);
        contribution.append(this.endOfGeneration());
        if (this.isDotGenerated(microPattern)) {
            contribution.append(".");
        }
        contribution.append(AbstractGOTOMicroPatternhandler.GetProperty_NEW_LINE(microPattern.getProcessingContext()));
    }

    @Override
    protected boolean isDotAlwaysGenerated() {
        return true;
    }

    public String validateFunction(String currentFunction, boolean isOperandeNumeric) {
        if (currentFunction != null) {
            return currentFunction;
        }
        if (isOperandeNumeric) {
            return "F    ";
        }
        return currentFunction;
    }
}

