/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.extension.micropattern;

import com.ibm.icu.util.StringTokenizer;
import com.ibm.pdp.cobolcompare.CobolDifferencer;
import com.ibm.pdp.cobolcompare.CobolToken;
import com.ibm.pdp.cobolcompare.CobolTokenizer;
import com.ibm.pdp.engine.IAnalyzerResult;
import com.ibm.pdp.engine.IBuilderTag;
import com.ibm.pdp.engine.IBuilderTree;
import com.ibm.pdp.engine.IGenInfoBuilder;
import com.ibm.pdp.engine.IMicroPattern;
import com.ibm.pdp.engine.IMicroPatternHandler;
import com.ibm.pdp.engine.IMicroPatternProcessingContext;
import com.ibm.pdp.engine.extension.ITextPartitioner;
import com.ibm.pdp.engine.turbo.core.BasicTextPartition;
import com.ibm.pdp.engine.turbo.core.Dictionary;
import com.ibm.pdp.engine.turbo.impl.MicroPattern;
import com.ibm.pdp.engine.turbo.impl.MicroPatternEngine;
import com.ibm.pdp.explorer.editor.service.PTEditorService;
import com.ibm.pdp.framework.PdpTool;
import com.ibm.pdp.framework.Reference;
import com.ibm.pdp.framework.cobol.matching.CobolFullLinePartitioner;
import com.ibm.pdp.framework.cobol.micropattern.internal.MicroPatternConstants;
import com.ibm.pdp.framework.pattern.PdpPatternGenStatesExceptions;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.pacbase.PacAbstractCDLine;
import com.ibm.pdp.mdl.pacbase.PacAccessModeValues;
import com.ibm.pdp.mdl.pacbase.PacCDLineDataStructure;
import com.ibm.pdp.mdl.pacbase.PacCenturySystemDateValues;
import com.ibm.pdp.mdl.pacbase.PacCobolTypeValues;
import com.ibm.pdp.mdl.pacbase.PacCommonLineDescription;
import com.ibm.pdp.mdl.pacbase.PacCommunicationMonitor;
import com.ibm.pdp.mdl.pacbase.PacDialog;
import com.ibm.pdp.mdl.pacbase.PacDialogTypeValues;
import com.ibm.pdp.mdl.pacbase.PacFolder;
import com.ibm.pdp.mdl.pacbase.PacGeneratedDateFormatValues;
import com.ibm.pdp.mdl.pacbase.PacGeneratedLanguageValues;
import com.ibm.pdp.mdl.pacbase.PacGeneratedSkeletonLanguageValues;
import com.ibm.pdp.mdl.pacbase.PacIOModeValues;
import com.ibm.pdp.mdl.pacbase.PacMapTypeValues;
import com.ibm.pdp.mdl.pacbase.PacOrganizationValues;
import com.ibm.pdp.mdl.pacbase.PacProgram;
import com.ibm.pdp.mdl.pacbase.PacScreen;
import com.ibm.pdp.mdl.pacbase.PacServer;
import com.ibm.pdp.mdl.pacbase.converter.PacPictureParser;
import com.ibm.pdp.mdl.pacbase.lal.util.GenerationContext;
import com.ibm.pdp.mdl.pacbase.lal.util.PacbaseLalDescription;
import com.ibm.pdp.mdl.pacbase.util.PacCommunicationMonitorWrapper;
import com.ibm.pdp.mdl.pacbase.util.PacDialogWrapper;
import com.ibm.pdp.mdl.pacbase.util.PacFolderWrapper;
import com.ibm.pdp.mdl.pacbase.util.PacProgramWrapper;
import com.ibm.pdp.mdl.pacbase.util.PacScreenWrapper;
import com.ibm.pdp.mdl.pacbase.util.PacServerWrapper;
import com.ibm.pdp.mdl.pacbase.util.PacbasePattern;
import com.ibm.pdp.micropattern.analyzer.MPAnalyzerManager;
import com.ibm.pdp.micropattern.analyzer.MPAnalyzerResult;
import com.ibm.pdp.pacbase.PacTool;
import com.ibm.pdp.pacbase.PdpPacbasePlugin;
import com.ibm.pdp.pacbase.extension.micropattern.Messages;
import com.ibm.pdp.pacbase.extension.micropattern.internal.WorkingData;
import com.ibm.pdp.pacbase.generate.util.InterruptedGeneratorException;
import com.ibm.pdp.pacbase.generate.util.PacbaseLinksEntitiesService;
import com.ibm.pdp.pacbase.util.EBCDICCompare;
import com.ibm.pdp.pacbase.util.PacQuoteConverter;
import com.ibm.pdp.trace.PTTraceManager;
import com.ibm.pdp.util.ExceptionWrapper;
import com.ibm.pdp.util.Ints;
import com.ibm.pdp.util.Util;
import com.ibm.pdp.util.diff.DiffCursor;
import com.ibm.pdp.util.ints.IntSequence;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;

public abstract class AbstractCommonMicroPatternHandler
implements MicroPatternConstants,
IMicroPatternHandler {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2021.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String SPECIFIC_TAG_PROPERTY = "SpecificTag";
    public static final String MSP_TAG_PROPERTY = "msp";
    public static final String REF_TAG_PROPERTY = "ref";
    public static final String DESIGN_FILE = "DESIGN_FILE_IN_CONTEXT";
    public static final String BREAKDATE_OPTION = "BREAKDATE_OPTION";
    public static final String ALPHANUMERIC_DELIMITER = "ALPHANUMERIC_DELIMITER";
    public static final String NEW_LINE_CHARACTER = "NEW_LINE_CHARACTER";
    public static final String SKELETON = "SKELETON";
    public static final String ATTRIBUTE_ID = "id";
    public static final String ATTRIBUTE_IDT = "IDT";
    public static final String ATTRIBUTE_PFX = "PFX";
    public static final String ATTRIBUTE_PL = "pl";
    public static final String ATTRIBUTE_IDTEMP = "idTemp";
    public static final String ATTRIBUTE_LASTID = "lastId";
    public static final String PROPERTY_MP = "mp";
    public static final String PROPERTY_SPECIFIC_MP = "specificMP";
    public static final String DOT = "DOT";
    public static final String INDENT = "IDT";
    public static final String PREFIX = "PFX";
    public static final String SEGINPGM = "SIP";
    public static final int RIGHT_MARGIN = 72;
    public static final String LEVEL_PROPERTY = "level";
    public static final String GENERATED_LEVEL = "10";
    public static final String PROPERTY_XNN_REF = "MP_XNN_Ref";
    public static final String NO_REGISTER_REFERENCE = "NoRegisterReference";
    protected static final String EMPTY_STRING = "";
    public static int TraceLevel;
    public static final String WORKING_DATA = "WORKING_DATA";
    public static final String FIRST_COLUMNS = "      ";
    public static final String COMMENT_CHAR = "*";

    protected void beforeProcess(IMicroPattern microPattern) {
    }

    protected void afterProcess(IMicroPattern microPattern) {
    }

    public static String GetProperty_NEW_LINE(IMicroPatternProcessingContext context) {
        return context.getAttribute(NEW_LINE_CHARACTER);
    }

    public static String GetProperty_ALPHA_NUMERIC_DELIMITER(IMicroPatternProcessingContext context) {
        return context.getAttribute(ALPHANUMERIC_DELIMITER);
    }

    public String getNamespace() {
        return "com.ibm.pdp.pacbase";
    }

    public void init() {
        TraceLevel = PTTraceManager.getInstance().getTraceLevel("com.ibm.pdp.pac");
    }

    public boolean isBreakdateOption(IMicroPatternProcessingContext context) {
        Boolean b = (Boolean)context.getData(BREAKDATE_OPTION);
        return b != null ? b : false;
    }

    public static String replaceAlphanumericDelimiter(String text, String alphanumericDelimiter) {
        return PacQuoteConverter.ReplaceDelimiter((String)text, (char)alphanumericDelimiter.charAt(0));
    }

    protected boolean isDate(PacbaseLalDescription pld, String format) {
        String typeDate = EMPTY_STRING;
        if ("E".equals(format)) {
            typeDate = pld.getInputFormat();
        } else if ("I".equals(format)) {
            typeDate = pld.getInternalFormat();
        } else if ("S".equals(format)) {
            typeDate = pld.getOutputFormat();
        }
        PacPictureParser ppp = new PacPictureParser(typeDate);
        return ppp.isDateSubType();
    }

    protected String getDefaultTagName(IMicroPattern microPattern, boolean isInSpecificCode) {
        String tagName = EMPTY_STRING;
        if (isInSpecificCode) {
            tagName = String.valueOf(this.getId()) + "_" + this.findId(microPattern);
        } else {
            IBuilderTag tag = AbstractCommonMicroPatternHandler.CurrentTag(microPattern);
            tagName = String.valueOf(tag.getName()) + "_" + this.getId();
            if (microPattern.getAttribute(ATTRIBUTE_ID) != null) {
                tagName = String.valueOf(tagName) + "_" + microPattern.getAttribute(ATTRIBUTE_ID);
            }
        }
        return tagName;
    }

    protected String findId(IMicroPattern microPattern) {
        String id = microPattern.getAttribute(ATTRIBUTE_ID);
        if (id == null) {
            String idtemp = microPattern.getAttribute(ATTRIBUTE_IDTEMP);
            if (idtemp != null) {
                id = idtemp;
                microPattern.getAttributes().put(ATTRIBUTE_ID, idtemp);
                microPattern.getAttributes().remove(ATTRIBUTE_IDTEMP);
            } else {
                int lastId = Integer.parseInt(microPattern.getProcessingContext().getAttribute(ATTRIBUTE_LASTID));
                id = String.valueOf(++lastId);
                microPattern.getProcessingContext().setAttribute(ATTRIBUTE_LASTID, id);
                microPattern.getAttributes().put(ATTRIBUTE_IDTEMP, id);
            }
        }
        return id;
    }

    protected String getNewHeader(IMicroPattern microPattern, CharSequence oldHeader) {
        StringBuilder newHeader = new StringBuilder(oldHeader);
        IMicroPatternProcessingContext context = microPattern.getProcessingContext();
        int startIndex = newHeader.indexOf("id=");
        if (startIndex < 0 || microPattern.getAttribute(ATTRIBUTE_ID) == null) {
            if (microPattern.getAttribute(ATTRIBUTE_ID) == null && startIndex > 0) {
                int endIndex = newHeader.substring(startIndex).indexOf(" ");
                if (endIndex < 0) {
                    endIndex = newHeader.substring(startIndex).indexOf(AbstractCommonMicroPatternHandler.GetProperty_NEW_LINE(context));
                }
                endIndex = startIndex + endIndex;
                StringBuilder str = new StringBuilder(endIndex - startIndex);
                int i = 0;
                while (i < endIndex - startIndex) {
                    str.append(" ");
                    ++i;
                }
                newHeader.replace(startIndex, endIndex, " ");
            }
            String[] newAttributes = new String[]{" id=" + this.findId(microPattern), EMPTY_STRING, EMPTY_STRING};
            String[] lines = PdpTool.splitTextIntoArrayLines((String)newHeader.toString());
            newHeader = new StringBuilder();
            int realNewHeader = lines.length - 1;
            if (realNewHeader == 0) {
                realNewHeader = -1;
            } else {
                while (realNewHeader > 0 && !lines[realNewHeader--].startsWith("      *!")) {
                }
            }
            int i = 0;
            while (i <= realNewHeader) {
                newHeader.append(lines[i]);
                newHeader.append(AbstractCommonMicroPatternHandler.GetProperty_NEW_LINE(context));
                ++i;
            }
            i = realNewHeader + 1;
            while (i < lines.length) {
                String line = lines[i];
                boolean slash = false;
                String oper = this.operandes(microPattern);
                int slashIndex = -1;
                slashIndex = oper != null ? line.indexOf("/", line.indexOf(oper) + oper.length()) : line.indexOf("/");
                if (slashIndex != -1 && newAttributes != null) {
                    slash = true;
                    newAttributes[1] = " /";
                    newAttributes[2] = " " + line.substring(slashIndex + 1, line.length());
                    line = line.substring(0, slashIndex);
                }
                boolean dotAtEnd = (line = AbstractCommonMicroPatternHandler.trimRight(line)).length() > 72 && (line.endsWith(DOT) || line.endsWith("dot"));
                String dot = null;
                if (dotAtEnd) {
                    dot = line.substring(72);
                    line = AbstractCommonMicroPatternHandler.trimRight(line.substring(0, 72));
                }
                newHeader.append(line);
                int lth = line.length();
                if (newAttributes != null && (i == lines.length - 1 || slash)) {
                    int j = 0;
                    while (j < newAttributes.length) {
                        if (lth + newAttributes[j].length() > 72) {
                            if (dotAtEnd) {
                                while (lth < 72) {
                                    newHeader.append(" ");
                                    ++lth;
                                }
                                newHeader.append(dot);
                                dotAtEnd = false;
                            }
                            newHeader.append(AbstractCommonMicroPatternHandler.GetProperty_NEW_LINE(context));
                            newHeader.append(FIRST_COLUMNS);
                            newHeader.append('*');
                            newHeader.append(newAttributes[j]);
                            lth = newAttributes[j].length() + 7;
                        } else {
                            newHeader.append(newAttributes[j]);
                            lth += newAttributes[j].length();
                        }
                        ++j;
                    }
                    newAttributes = null;
                }
                if (dotAtEnd) {
                    while (lth < 72) {
                        newHeader.append(" ");
                        ++lth;
                    }
                    newHeader.append(dot);
                    dotAtEnd = false;
                }
                newHeader.append(AbstractCommonMicroPatternHandler.GetProperty_NEW_LINE(context));
                ++i;
            }
        }
        if (MPAnalyzerManager.accept((String)microPattern.getId()) && microPattern.getAnalyzerResult() == null) {
            StringBuilder newSyntaxHeader = this.getNewSyntaxHeader(microPattern, newHeader.toString(), false);
            if (newSyntaxHeader.length() > 0) {
                newHeader = newSyntaxHeader;
            } else {
                this.logWarning(Messages.MicroPatternHandler_SYNTAX_CONVERSION_FAILURE, microPattern);
            }
        }
        if (microPattern.getAnalyzerResult() != null) {
            microPattern.getAnalyzerResult().getNeedFormat();
        }
        return newHeader.toString();
    }

    private StringBuilder getNewSyntaxHeader(IMicroPattern microPattern, String oldSyntaxHeader, boolean macroCall) {
        StringBuilder newSyntaxHeader = new StringBuilder(EMPTY_STRING);
        IMicroPatternProcessingContext context = microPattern.getProcessingContext();
        LinkedHashMap<Object, Object> parameters = new LinkedHashMap();
        String operandes = this.operandes(microPattern);
        if (operandes != null && operandes.length() > 0) {
            parameters = this.convertToParameters(microPattern, operandes);
        } else if ("WF".equals(microPattern.getId())) {
            parameters = this.convertToParameters(microPattern, operandes);
        }
        if (microPattern.getAttribute("InvalidSequenceInMPConversion") != null && "true".equals(microPattern.getAttribute("InvalidSequenceInMPConversion"))) {
            Util.rethrow((Throwable)new Exception("InvalidSequenceInMPConversion : " + microPattern.getOriginalHeaderDeclaration()));
        }
        if (parameters != null) {
            StringBuilder mpToken = new StringBuilder("      *!");
            mpToken.append(microPattern.getVisibleId());
            int mpTokenIdx = oldSyntaxHeader.lastIndexOf(mpToken.toString());
            if (mpTokenIdx >= 0) {
                if (!macroCall) {
                    String sId = this.findId(microPattern);
                    parameters.put(ATTRIBUTE_ID, sId);
                }
                String sRightMargin = EMPTY_STRING;
                int endOfLineIdx = oldSyntaxHeader.indexOf(AbstractCommonMicroPatternHandler.GetProperty_NEW_LINE(context), mpTokenIdx);
                if (endOfLineIdx - mpTokenIdx > 72) {
                    sRightMargin = oldSyntaxHeader.substring(mpTokenIdx + 72, endOfLineIdx);
                }
                newSyntaxHeader.append(oldSyntaxHeader.substring(0, mpTokenIdx));
                StringBuilder lineBuffer = new StringBuilder("      *!");
                lineBuffer.append(microPattern.getVisibleId());
                for (Map.Entry<Object, Object> parameter : parameters.entrySet()) {
                    StringBuilder assoc = new StringBuilder((String)parameter.getKey());
                    assoc.append('=');
                    if (((String)parameter.getValue()).indexOf(32) > 0) {
                        assoc.append('\"').append((String)parameter.getValue()).append('\"');
                    } else {
                        assoc.append((String)parameter.getValue());
                    }
                    if (lineBuffer.length() + assoc.length() >= 72) {
                        if (sRightMargin.length() > 0) {
                            this.appendRightMargin(sRightMargin, lineBuffer);
                            sRightMargin = EMPTY_STRING;
                        }
                        newSyntaxHeader.append((CharSequence)lineBuffer).append(AbstractCommonMicroPatternHandler.GetProperty_NEW_LINE(context));
                        lineBuffer = new StringBuilder("      *!-");
                    }
                    lineBuffer.append(' ').append((CharSequence)assoc);
                }
                if (sRightMargin.length() > 0) {
                    this.appendRightMargin(sRightMargin, lineBuffer);
                }
                newSyntaxHeader.append((CharSequence)lineBuffer);
                newSyntaxHeader.append(AbstractCommonMicroPatternHandler.GetProperty_NEW_LINE(context));
            }
        }
        return newSyntaxHeader;
    }

    private void appendRightMargin(String sRightMargin, StringBuilder lineBuffer) {
        int i = lineBuffer.length();
        while (i < 72) {
            lineBuffer.append(' ');
            ++i;
        }
        lineBuffer.append(sRightMargin);
    }

    public boolean isAnnotationsNeededInMacro() {
        return false;
    }

    protected boolean isDotAlwaysGenerated() {
        return false;
    }

    protected boolean isDotInsertedInRightMargin() {
        return true;
    }

    protected void changeTheOperandeValueIfPossible(IMicroPattern microPattern) {
        String operandeValue = microPattern.getAttribute("FIRST_ZONE");
        if (operandeValue != null) {
            operandeValue = operandeValue.trim();
            if (!this.isMultipleLinesAllowed() && operandeValue.indexOf(AbstractCommonMicroPatternHandler.GetProperty_NEW_LINE(microPattern.getProcessingContext())) != -1) {
                operandeValue = operandeValue.replaceAll(AbstractCommonMicroPatternHandler.GetProperty_NEW_LINE(microPattern.getProcessingContext()), " ");
                microPattern.getAttributes().put("FIRST_ZONE", operandeValue);
            }
        }
    }

    protected boolean checkStatus(IMicroPatternProcessingContext context) {
        int status = context.getStatus();
        return status == 0 || 4 == status;
    }

    public static int FirstIndexLabelFromTag(IBuilderTag tag, String newLine) {
        String text = tag.getText().toString();
        int index = 0;
        String[] lines = PdpTool.splitTextIntoArrayLines((String)text);
        boolean found = false;
        int i = 0;
        while (!found) {
            String line;
            boolean bl = found = (line = lines[i++]).startsWith("       ") && line.charAt(7) != ' ';
            if (found) continue;
            index = index + line.length() + newLine.length();
        }
        return index;
    }

    public static String GetComments(PacbaseLalDescription pld, GenerationContext ctx, String format) {
        String comment = pld.getComments(ctx);
        if (ctx.getPattern() != PacbasePattern.BATCH && comment == "BLANK WHEN ZERO" && !"S".equals(format)) {
            return EMPTY_STRING;
        }
        return comment;
    }

    public static String GetRealFormat(PacbaseLalDescription pld, String currentFormat) {
        return pld.getRealFormat(currentFormat);
    }

    public static String TransformFormat(String currentFormat) {
        if (currentFormat != null && currentFormat.indexOf("V(") != -1) {
            return currentFormat.replace("V(", "V9(");
        }
        return currentFormat;
    }

    public static IBuilderTag CurrentTag(IMicroPattern microPattern) {
        IGenInfoBuilder giBuilder = microPattern.getProcessingContext().getGeneratedInfo().toGeneratedInfoBuilder();
        int index = microPattern.getLocation().getBeginIndex() + 7;
        IBuilderTag currentTag = giBuilder.includingTag(index, index);
        return currentTag;
    }

    public static String GetPropertyFor(IBuilderTag tag, String propertyName) {
        String propName = "+" + propertyName;
        String propValue = tag.getProperty(propName);
        if (propValue != null) {
            return propValue;
        }
        propValue = tag.getProperty(propertyName);
        return propValue;
    }

    public static boolean IsInSpecificCode(IMicroPattern microPattern) {
        IBuilderTag tag = AbstractCommonMicroPatternHandler.CurrentTag(microPattern);
        return AbstractCommonMicroPatternHandler.GetPropertyFor(tag, SPECIFIC_TAG_PROPERTY) != null;
    }

    public static List<String> ListOfTags(IBuilderTag tag) {
        ArrayList<String> l = new ArrayList<String>();
        do {
            l.add(tag.getName());
        } while ((tag = tag.getParent()) != null);
        return l;
    }

    public static void CheckValidityEntity(RadicalEntity re, IMicroPatternProcessingContext context) {
        Object obj = context.getData("PLES");
        if (obj == null) {
            obj = new PacbaseLinksEntitiesService();
            context.setData("PLES", obj);
        }
        PacbaseLinksEntitiesService ples = (PacbaseLinksEntitiesService)obj;
        ples.checkValidityEntity(re);
    }

    protected void logError(String errorMsg, IMicroPattern microPattern) {
        this.logEverything(microPattern, 6, errorMsg);
    }

    protected void logWarning(String warningMsg, IMicroPattern microPattern) {
        this.logEverything(microPattern, 4, warningMsg);
    }

    private void logEverything(IMicroPattern microPattern, int logLevel, String errorMsg) {
        microPattern.getProcessingContext().setStatus(logLevel, microPattern, errorMsg, null);
        int statusLevel = 4;
        if (logLevel == 4) {
            statusLevel = 2;
        }
        String cobol = PacTool.getLogicalCobolFileNameFromDesign((RadicalEntity)this.searchReference(microPattern));
        String place = AbstractCommonMicroPatternHandler.CurrentTag(microPattern).getName();
        String completeErrorMsg = String.valueOf(errorMsg) + AbstractCommonMicroPatternHandler.GetProperty_NEW_LINE(microPattern.getProcessingContext()) + cobol + " " + place + " : " + microPattern.getOriginalHeaderDeclaration();
        Status status = new Status(statusLevel, "com.ibm.pdp.pacbase", completeErrorMsg);
        PdpPacbasePlugin.getDefault().getLog().log((IStatus)status);
    }

    protected void logError(String errorMsg, IMicroPattern microPattern, IBuilderTag tag) {
        this.logEverything(tag, microPattern, 6, errorMsg);
    }

    protected void logWarning(String warningMsg, IMicroPattern microPattern, IBuilderTag tag) {
        this.logEverything(tag, microPattern, 4, warningMsg);
    }

    private void logEverything(IBuilderTag tag, IMicroPattern microPattern, int logLevel, String errorMsg) {
        microPattern.getProcessingContext().setStatus(logLevel, tag, errorMsg, null);
        int statusLevel = 4;
        if (logLevel == 4) {
            statusLevel = 2;
        }
        String cobol = PacTool.getLogicalCobolFileNameFromDesign((RadicalEntity)this.searchReference(microPattern));
        String place = tag.getName();
        String completeErrorMsg = String.valueOf(errorMsg) + AbstractCommonMicroPatternHandler.GetProperty_NEW_LINE(microPattern.getProcessingContext()) + cobol + " " + place + " : " + microPattern.getOriginalHeaderDeclaration();
        Status status = new Status(statusLevel, "com.ibm.pdp.pacbase", completeErrorMsg);
        PdpPacbasePlugin.getDefault().getLog().log((IStatus)status);
    }

    public static void ModifyOperandesWithLogicalWord(List<String> operandes) {
        int e = 0;
        while (e < operandes.size()) {
            String element = operandes.get(e);
            if ("NOT".equals(element)) {
                operandes.set(e, String.valueOf(operandes.get(e)) + operandes.get(++e));
                int i = e;
                int l = operandes.size() - 1;
                while (l > i) {
                    operandes.set(i++, operandes.get(i));
                }
                operandes.remove(i);
                continue;
            }
            ++e;
        }
    }

    public boolean isMicroPatternContainsOnlyOperandeValue(IMicroPattern microPattern) {
        IAnalyzerResult analyzerResult = microPattern.getAnalyzerResult();
        return analyzerResult == null || !analyzerResult.isWellFormed();
    }

    public static String OperandeValue(IMicroPattern microPattern, boolean onlyOperandeValue) {
        Map param;
        Object param1;
        MPAnalyzerResult mpr;
        String operandeValue;
        if (onlyOperandeValue) {
            int secondDoubleQuote;
            int lastDoubleQuote;
            int firstDoubleQuote;
            String s = microPattern.getOriginalHeaderDeclaration();
            if (s.length() > 7) {
                s = s.substring(7);
            }
            if ((firstDoubleQuote = (s = s.trim()).indexOf("\"")) != -1 && (lastDoubleQuote = s.lastIndexOf("\"")) != -1 && firstDoubleQuote != lastDoubleQuote && (secondDoubleQuote = s.indexOf("\"", firstDoubleQuote + 1)) != lastDoubleQuote) {
                s = s.substring(firstDoubleQuote + 1, lastDoubleQuote);
                microPattern.getAttributes().put("FIRST_ZONE", s);
            }
        }
        if ((operandeValue = microPattern.getAttribute("FIRST_ZONE")) == null || operandeValue.trim().length() == 0) {
            operandeValue = microPattern.getAttribute("OPERANDES");
        }
        if (operandeValue == null && (mpr = (MPAnalyzerResult)microPattern.getAnalyzerResult()) != null && (param1 = (param = mpr.getParameters()).get("SE1")) != null && param1 instanceof String) {
            operandeValue = (String)param1;
        }
        if (operandeValue == null || operandeValue.trim().length() == 0) {
            operandeValue = microPattern.getAttribute(DOT);
        }
        if (operandeValue != null) {
            operandeValue = operandeValue.trim();
            if (!microPattern.getId().equals("PCB") && operandeValue.endsWith(".")) {
                operandeValue = operandeValue.substring(0, operandeValue.length() - 1);
                microPattern.getAttributes().put("DOT_OPERANDES", "true");
            }
            operandeValue = operandeValue.trim();
        }
        return operandeValue;
    }

    public String operandes(IMicroPattern microPattern) {
        String operandeValue = AbstractCommonMicroPatternHandler.OperandeValue(microPattern, this.isMicroPatternContainsOnlyOperandeValue(microPattern));
        if (!this.isMultipleLinesAllowed() && operandeValue != null && operandeValue.indexOf(AbstractCommonMicroPatternHandler.GetProperty_NEW_LINE(microPattern.getProcessingContext())) != -1) {
            operandeValue = operandeValue.replaceAll(AbstractCommonMicroPatternHandler.GetProperty_NEW_LINE(microPattern.getProcessingContext()), " ");
        }
        return operandeValue == null ? null : (operandeValue.trim().length() == 0 ? null : operandeValue);
    }

    public void process(IMicroPattern microPattern, IGenInfoBuilder genInfoBuilder) {
        try {
            IAnalyzerResult mpAnalyzerResult = microPattern.getAnalyzerResult();
            if (mpAnalyzerResult != null) {
                this.convertToAttributes(microPattern, mpAnalyzerResult.getParameters());
            }
            this.beforeProcess(microPattern);
            this.internalProcess(microPattern, genInfoBuilder);
            this.afterProcess(microPattern);
        }
        catch (Exception ex) {
            if (ex instanceof ExceptionWrapper && ((ExceptionWrapper)ex).getRealThrowable() instanceof InterruptedGeneratorException) {
                Util.rethrow((Throwable)ex);
            }
            this.logWarning(Messages.bind((String)Messages.MicroPatternHandler_UNKNOWN_ERROR, (Object)microPattern.getOriginalHeaderDeclaration()), microPattern);
            this.traceMessage("ERROR during the execution of micro pattern expansion: ");
            this.traceMessage(microPattern.getOriginalHeaderDeclaration());
            this.traceMessage(ex.getMessage());
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            ex.printStackTrace(pw);
            this.traceMessage(sw.toString());
        }
    }

    protected void convertToAttributes(IMicroPattern microPattern, Map<String, Object> parameters) {
        Object paramIDT;
        Object paramId = parameters.get(ATTRIBUTE_ID);
        if (paramId instanceof Integer) {
            microPattern.getAttributes().put(ATTRIBUTE_ID, String.valueOf(paramId));
        }
        if ((paramIDT = parameters.get("IDT")) instanceof Integer) {
            microPattern.getAttributes().put("IDT", String.valueOf(paramIDT));
        }
    }

    protected LinkedHashMap<String, String> convertToParameters(IMicroPattern microPattern, String operandes) {
        LinkedHashMap<String, String> parametersForAllMP = new LinkedHashMap<String, String>();
        if (microPattern.getAttribute("IDT") != null) {
            parametersForAllMP.put("IDT", microPattern.getAttribute("IDT"));
        }
        return parametersForAllMP;
    }

    protected void internalProcess(IMicroPattern microPattern, IGenInfoBuilder genInfoBuilder) {
        IAnalyzerResult analyzerResult = microPattern.getAnalyzerResult();
        if (analyzerResult != null && !analyzerResult.isWellFormed()) {
            for (String malformedMessage : analyzerResult.getMalformedMessages()) {
                this.logWarning(malformedMessage, microPattern);
            }
        } else if (this.addLocalFragment(microPattern, genInfoBuilder)) {
            this.addOtherFragments(microPattern, genInfoBuilder);
        }
    }

    protected String getGSVLabel(IMicroPattern microPattern) {
        StringBuilder sb = new StringBuilder("!");
        sb.append(this.getId());
        String operandes = microPattern.getAttribute("NEW_SYNTAX_HEADER");
        if (operandes == null || operandes.length() == 0) {
            String syntaxHeader = this.getNewSyntaxHeader(microPattern, microPattern.getOriginalHeaderDeclaration(), true).toString();
            int begin = syntaxHeader.trim().indexOf(" ");
            int end = syntaxHeader.trim().lastIndexOf(" ");
            if (begin != -1 && end != -1) {
                operandes = syntaxHeader.trim().substring(begin, end);
            }
        }
        if (operandes != null && operandes.length() > 0) {
            StringBuilder sb1 = new StringBuilder();
            String[] ls = operandes.split(AbstractCommonMicroPatternHandler.GetProperty_NEW_LINE(microPattern.getProcessingContext()));
            int i = 0;
            while (i < ls.length) {
                if (i > 0) {
                    sb1.append(" ");
                }
                sb1.append(ls[i].trim());
                ++i;
            }
            sb.append(" ");
            sb.append(sb1.toString());
        }
        return sb.toString();
    }

    protected boolean addLocalFragment(IMicroPattern microPattern, IGenInfoBuilder genInfoBuilder) {
        boolean inUserCode = AbstractCommonMicroPatternHandler.IsInSpecificCode(microPattern);
        StringBuilder contrib = new StringBuilder();
        if (!inUserCode) {
            IBuilderTag tag = AbstractCommonMicroPatternHandler.CurrentTag(microPattern);
            contrib.append(this.handleLocalFragmentAndIndent(microPattern, genInfoBuilder));
            this.addDotIfNeeded(microPattern, contrib);
            int index = microPattern.getLocation().getBeginIndex() + microPattern.getOriginalHeaderDeclaration().length();
            int mpBegin = microPattern.getLocation().getBeginIndex();
            int mpEnd = microPattern.getLocation().getEndIndex();
            String newSyntaxHeader = null;
            if (MPAnalyzerManager.accept((String)microPattern.getId()) && microPattern.getAnalyzerResult() == null) {
                String oldSyntaxHeader = microPattern.getOriginalHeaderDeclaration();
                newSyntaxHeader = this.getNewSyntaxHeader(microPattern, oldSyntaxHeader, true).toString();
                if (newSyntaxHeader.length() > 0) {
                    AbstractCommonMicroPatternHandler.ReplaceText(tag, mpBegin, mpEnd, newSyntaxHeader, false);
                    ((MicroPattern)microPattern).setHeaderDecl(newSyntaxHeader);
                    index = microPattern.getLocation().getBeginIndex() + microPattern.getOriginalHeaderDeclaration().length();
                    mpEnd = microPattern.getLocation().getEndIndex();
                    Map attributes = microPattern.getAttributes();
                    int begin = newSyntaxHeader.trim().indexOf(" ");
                    int end = newSyntaxHeader.trim().lastIndexOf(" ");
                    attributes.put("NEW_SYNTAX_HEADER", newSyntaxHeader.trim().substring(begin, end));
                } else if (this.isAnnotationsNeededInMacro()) {
                    this.logWarning(Messages.MicroPatternHandler_SYNTAX_CONVERSION_FAILURE, microPattern);
                }
            }
            if (contrib.toString().trim().length() > 0) {
                String parentTagName = tag.getParent().getName();
                if (index < tag.getEndIndex() || AbstractCommonMicroPatternHandler.IsSeveralMPinTag(tag)) {
                    parentTagName = tag.getName();
                }
                if (this.isAnnotationsNeededInMacro()) {
                    tag = AbstractCommonMicroPatternHandler.AddTag(genInfoBuilder, index, index, this.getDefaultTagName(microPattern, inUserCode), parentTagName);
                    tag.setText((CharSequence)contrib.toString());
                } else {
                    tag.setProperty("lowMPFrom", AbstractCommonMicroPatternHandler.GetPropertyFor(tag, MSP_TAG_PROPERTY));
                    AbstractCommonMicroPatternHandler.ReplaceText(tag, mpBegin, mpEnd, contrib.toString(), false);
                }
                tag.setProperty("GSVLabel", this.getGSVLabel(microPattern));
            } else if (!this.isAnnotationsNeededInMacro()) {
                AbstractCommonMicroPatternHandler.ReplaceText(tag, mpBegin, mpEnd, EMPTY_STRING, false);
                if (!this.isAllowedToHaveEmptyLocalContribution(microPattern)) {
                    this.logWarning(Messages.MicroPatternHandler_NO_GENERATION, microPattern);
                }
            }
            if (this.isAnnotationsNeededInMacro()) {
                if (newSyntaxHeader == null || newSyntaxHeader.trim().length() == 0) {
                    AbstractCommonMicroPatternHandler.ReplaceText(tag, mpBegin, mpEnd, microPattern.getOriginalHeaderDeclaration(), false);
                } else {
                    AbstractCommonMicroPatternHandler.ReplaceText(tag, mpBegin, mpEnd, newSyntaxHeader, false);
                }
            }
        } else {
            this.changeTheOperandeValueIfPossible(microPattern);
            String contribLocal = this.handleLocalFragmentAndIndent(microPattern, genInfoBuilder);
            if (contribLocal.length() > 0) {
                if ("true".equals(microPattern.getProcessingContext().getData("DOUBLE_ON_MICRO_PATTERN"))) {
                    this.cleanAlreadyGeneratedMicroPattern(microPattern, contribLocal, genInfoBuilder, -1);
                    contrib = new StringBuilder(contribLocal);
                    this.addDotIfNeeded(microPattern, contrib);
                } else if (this.isAlreadyGeneratedCode(microPattern, contribLocal, genInfoBuilder)) {
                    contribLocal = EMPTY_STRING;
                } else {
                    contrib = new StringBuilder(contribLocal);
                    this.addDotIfNeeded(microPattern, contrib);
                }
                IBuilderTag tag = AbstractCommonMicroPatternHandler.CurrentTag(microPattern);
                int index = microPattern.getLocation().getBeginIndex() + microPattern.getOriginalHeaderDeclaration().length();
                IBuilderTag parentTag = tag.getParent();
                IBuilderTag originalTag = tag;
                boolean twoMPAtTheSamePlace = false;
                if (tag.getBeginIndex() == parentTag.getBeginIndex() && tag.getLength() == parentTag.getLength() && tag.getBeginIndex() == microPattern.getLocation().getBeginIndex() && tag.getEndIndex() == microPattern.getLocation().getEndIndex() && AbstractCommonMicroPatternHandler.GetPropertyFor(parentTag, MSP_TAG_PROPERTY) != null) {
                    tag = parentTag.getParent();
                    twoMPAtTheSamePlace = true;
                }
                IBuilderTag newTag = AbstractCommonMicroPatternHandler.AddTag(genInfoBuilder, index, index, this.getDefaultTagName(microPattern, inUserCode), tag.getName());
                newTag.setProperty(PROPERTY_SPECIFIC_MP, this.findId(microPattern));
                String oldSyntaxHeader = microPattern.getOriginalHeaderDeclaration();
                String newSyntaxHeader = this.getNewSyntaxHeader(microPattern, oldSyntaxHeader, true).toString();
                int begin = newSyntaxHeader.trim().indexOf(" ");
                if (begin != -1) {
                    Map attributes = microPattern.getAttributes();
                    attributes.put("NEW_SYNTAX_HEADER", newSyntaxHeader.trim().substring(begin));
                }
                newTag.setProperty("GSVLabel", this.getGSVLabel(microPattern));
                newTag.setText((CharSequence)contrib.toString());
                if (twoMPAtTheSamePlace) {
                    originalTag.setText((CharSequence)this.getNewHeader(microPattern, microPattern.getOriginalHeaderDeclaration()));
                } else {
                    newTag.setTextBefore((CharSequence)this.getNewHeader(microPattern, newTag.getTextBefore()));
                }
            } else if (!this.isAllowedToHaveEmptyLocalContribution(microPattern)) {
                this.logWarning(Messages.MicroPatternHandler_NO_GENERATION, microPattern);
            } else {
                String oldSyntaxHeader = microPattern.getOriginalHeaderDeclaration();
                String newSyntaxHeader = this.getNewSyntaxHeader(microPattern, oldSyntaxHeader, true).toString();
                IBuilderTag tag = AbstractCommonMicroPatternHandler.CurrentTag(microPattern);
                int endIndex = microPattern.getLocation().getBeginIndex() + microPattern.getOriginalHeaderDeclaration().length();
                AbstractCommonMicroPatternHandler.ReplaceText(tag, microPattern.getLocation().getBeginIndex(), endIndex, newSyntaxHeader, false);
            }
        }
        return true;
    }

    protected boolean isAllowedToHaveEmptyLocalContribution(IMicroPattern microPattern) {
        if (microPattern.getAttributes().containsKey("AllowedToHaveEmptyLocalContribution")) {
            return "true".equals(microPattern.getAttributes().get("AllowedToHaveEmptyLocalContribution"));
        }
        return false;
    }

    public void setAllowedToHaveEmptyLocalContribution(IMicroPattern microPattern, boolean b) {
        microPattern.getAttributes().put("AllowedToHaveEmptyLocalContribution", String.valueOf(b));
    }

    /*
     * Unable to fully structure code
     */
    private boolean isAlreadyGeneratedCode(IMicroPattern microPattern, String contrib, IGenInfoBuilder genInfoBuilder) {
        disableDuplicateProcess = System.getProperty("disableDuplicateProcess");
        if (disableDuplicateProcess != null && "true".equals(disableDuplicateProcess)) {
            return false;
        }
        if ("WI".equals(microPattern.getId()) || "WE".equals(microPattern.getId()) || "WS".equals(microPattern.getId()) || "WF".equals(microPattern.getId())) {
            return false;
        }
        context = microPattern.getProcessingContext();
        lines = PdpTool.splitTextIntoArrayLines((String)contrib);
        if (lines.length > 2) {
            return false;
        }
        text = new String(genInfoBuilder.getText().toString().substring(microPattern.getLocation().getEndIndex()).toString());
        index = 0;
        sb = new StringBuilder();
        i = 0;
        while (i < lines.length) {
            if (!text.substring(index).contains(AbstractCommonMicroPatternHandler.GetProperty_NEW_LINE(context))) break;
            line = text.substring(index, index + text.substring(index).indexOf(AbstractCommonMicroPatternHandler.GetProperty_NEW_LINE(context)));
            index = index + line.length() + AbstractCommonMicroPatternHandler.GetProperty_NEW_LINE(context).length();
            if (line.length() > 72) {
                line = line.substring(0, 72);
            }
            line = line.trim();
            if (!contrib.trim().endsWith(".") && i == lines.length - 1 && line.trim().endsWith(".")) {
                line = line.substring(0, line.length() - 1);
            }
            sb.append(line);
            sb.append(AbstractCommonMicroPatternHandler.GetProperty_NEW_LINE(context));
            ++i;
        }
        wordsGen = new StringTokenizer(contrib, " ");
        wordsRef = new StringTokenizer(sb.toString(), " ");
        if (wordsGen.countTokens() == wordsRef.countTokens()) ** GOTO lbl35
        return false;
lbl-1000:
        // 1 sources

        {
            if (wordsGen.nextToken().equals(wordsRef.nextToken())) continue;
            return false;
lbl35:
            // 2 sources

            ** while (wordsGen.hasMoreTokens())
        }
lbl36:
        // 1 sources

        return true;
    }

    protected void cleanAlreadyGeneratedMicroPattern(IMicroPattern microPattern, String contrib, IGenInfoBuilder genInfoBuilder, int indexToBeginWith) {
        IBuilderTag tag = AbstractCommonMicroPatternHandler.CurrentTag(microPattern);
        int globalIndex = indexToBeginWith;
        if (globalIndex == -1) {
            globalIndex = microPattern.getLocation().getBeginIndex() + microPattern.getOriginalHeaderDeclaration().length();
        }
        int index = globalIndex - tag.getBeginIndex();
        String text = tag.getText().toString();
        if (text.length() <= index) {
            return;
        }
        text = text.substring(index);
        boolean ok = true;
        CobolTokenizer tokenizer1 = new CobolTokenizer((CharSequence)contrib);
        CobolTokenizer tokenizer2 = new CobolTokenizer((CharSequence)text);
        CobolToken token1 = tokenizer1.newToken();
        CobolToken token2 = tokenizer2.newToken();
        int lastIndex = -1;
        while (ok && tokenizer1.nextToken(token1)) {
            if (!tokenizer2.nextToken(token2)) {
                ok = false;
            } else {
                lastIndex = token2.beginIdx;
            }
            if (token1.equals((Object)token2)) continue;
            ok = false;
        }
        if (!ok) {
            return;
        }
        int endIndex = 0;
        CobolDifferencer cd = new CobolDifferencer(contrib, text);
        int[] result = cd.getModifiedLineIndexes();
        int i = 0;
        while (i < result.length) {
            int j = result[i];
            if (j > lastIndex) {
                endIndex = j;
                break;
            }
            ++i;
        }
        if (endIndex != 0) {
            String tagNameToRemove = String.valueOf(microPattern.getId()) + "GeneratedMicroPatternToRemove";
            IBuilderTag tagToRemove = genInfoBuilder.addTag(globalIndex, globalIndex + endIndex, tagNameToRemove);
            genInfoBuilder.removeTagAndText(tagToRemove);
        }
    }

    protected String handleLocalFragmentAndIndent(IMicroPattern microPattern, IGenInfoBuilder genInfoBuilder) {
        String localFragment = this.handleLocalFragment(microPattern, genInfoBuilder);
        if (localFragment.length() != 0 && microPattern.getAttribute("IDT") != null) {
            return this.indentText(localFragment, microPattern);
        }
        return localFragment;
    }

    public String indentText(String text, IMicroPattern microPattern) {
        IMicroPatternProcessingContext context = microPattern.getProcessingContext();
        String attInd = microPattern.getAttribute("IDT");
        if (attInd != null && !"0".equals(attInd)) {
            try {
                Integer.parseInt(attInd);
            }
            catch (Exception exception) {
                this.logWarning(Messages.MicroPatternHandler_WRONG_INDENT, microPattern);
                return text;
            }
            if (COMMENT_CHAR.equals(microPattern.getId())) {
                return text;
            }
            int indent = Integer.parseInt(microPattern.getAttribute("IDT"));
            String[] its = PdpTool.splitTextIntoArrayLines((String)text);
            int indentDiff = 0;
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < its.length) {
                String resultControl;
                int initialIndent = its[i].length() - its[i].trim().length() + 1;
                if (i == 0) {
                    indentDiff = indent - initialIndent;
                }
                if ((resultControl = this.controlIndentLine(microPattern, its[i], indentDiff)).trim().length() > 0) {
                    this.logWarning(resultControl, microPattern);
                    return text;
                }
                sb.append(resultControl);
                sb.append(its[i].trim());
                sb.append(AbstractCommonMicroPatternHandler.GetProperty_NEW_LINE(context));
                ++i;
            }
            text = sb.toString();
        }
        return text;
    }

    protected String controlIndentLine(IMicroPattern microPattern, String line, int indentDiff) {
        boolean isInProcedure = false;
        if (AbstractCommonMicroPatternHandler.ListOfTags(AbstractCommonMicroPatternHandler.CurrentTag(microPattern)).contains("PROCEDURE")) {
            isInProcedure = true;
        }
        int initialIndent = line.length() - line.trim().length();
        StringBuilder sbi = new StringBuilder();
        int j = 0;
        while (j < initialIndent + indentDiff) {
            sbi.append(" ");
            ++j;
        }
        String beginSpace = sbi.toString();
        int beginSpaceNb = beginSpace.length();
        int lineLength = beginSpaceNb + line.trim().length();
        if (isInProcedure && beginSpaceNb < 11) {
            return Messages.MicroPatternHandler_WRONG_INDENT;
        }
        if (lineLength > 72) {
            return Messages.MicroPatternHandler_WRONG_INDENT;
        }
        return beginSpace;
    }

    protected boolean isLinesLengthOK(String localFragment) {
        String[] its = PdpTool.splitTextIntoArrayLines((String)localFragment);
        int i = 0;
        while (i < its.length) {
            String line = its[i];
            if (line.trim().length() > 71) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected abstract String handleLocalFragment(IMicroPattern var1, IGenInfoBuilder var2);

    protected abstract void addOtherFragments(IMicroPattern var1, IGenInfoBuilder var2);

    public boolean isMultipleLinesAllowed() {
        return true;
    }

    public static boolean IsSeveralMPinTag(IBuilderTag tag) {
        int lastMP;
        String tagContent = tag.getText().toString();
        int firstMP = tagContent.indexOf("      *!");
        return firstMP != (lastMP = tagContent.lastIndexOf("      *!"));
    }

    protected HashMap<String, WorkingData> getWorkingData(IMicroPatternProcessingContext context) {
        HashMap allWDs = (HashMap)context.getData(WORKING_DATA);
        if (allWDs == null) {
            allWDs = new HashMap();
            context.setData(WORKING_DATA, allWDs);
        }
        return allWDs;
    }

    protected void storeWorkingData(WorkingData wd, IMicroPatternProcessingContext context) {
        if (wd.getEntity() != null && wd.getEntity().getName().equals(wd.getEntityName())) {
            this.getWorkingData(context).put(wd.getLabel(), wd);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void registerReference(RadicalEntity obj, IMicroPatternProcessingContext context) {
        HashSet list = (HashSet)context.getData("inMemoryEntities");
        if (list != null) {
            if (list.contains(obj)) return;
            AbstractCommonMicroPatternHandler.CheckValidityEntity(obj, context);
            list.add(obj);
        } else {
            AbstractCommonMicroPatternHandler.CheckValidityEntity(obj, context);
        }
        if (obj.getDesignURI() == null) return;
        String patternName = context.getGenerationProperties().getProperty("PATTERN_NAME");
        String genStateId = PdpPatternGenStatesExceptions.getGenStateId((RadicalEntity)obj, (String)patternName, (boolean)true, null, (String)"1");
        String stateId = obj.getStateId();
        Reference reference = new Reference(obj.getProject(), true, obj.getPackage(), null, obj.getName(), obj.eClass().getName().toLowerCase(), stateId, genStateId, this.getId());
        context.registerGenerationReference((Object)reference);
    }

    public static IBuilderTag PutTagFunctionAfter(IBuilderTag tag, String functionTagName) {
        IGenInfoBuilder giBuilder = tag.getGenInfoBuilder();
        IBuilderTag currentTag = tag.nextTag();
        while (currentTag != null && currentTag.getName().startsWith(functionTagName)) {
            IBuilderTag tmpTag;
            currentTag = tmpTag = currentTag.nextTag();
        }
        IBuilderTag functionTag = AbstractCommonMicroPatternHandler.AddTag(giBuilder, tag.getEndIndex(), currentTag.getBeginIndex(), functionTagName, tag.getParent().getName());
        if (functionTag.hasSon()) {
            IBuilderTree tree;
            if (!functionTag.firstSon().getName().startsWith(functionTagName)) {
                tree = giBuilder.removeTreeAndText(functionTag.firstSon());
                giBuilder.addTree(functionTag.getBeginIndex(), tree, functionTag.getParent().getName());
            }
            if (!functionTag.lastSon().getName().startsWith(functionTagName)) {
                tree = giBuilder.removeTreeAndText(functionTag.lastSon());
                giBuilder.addTree(functionTag.getEndIndex(), tree, functionTag.getParent().getName());
            }
        }
        return functionTag;
    }

    protected static boolean ReplaceText(IBuilderTag tag, int startIndex, int endIndex, String newText, boolean allowTagDeletion) {
        return MicroPatternEngine.ReplaceText((IGenInfoBuilder)tag.getGenInfoBuilder(), (IBuilderTag)tag, (int)startIndex, (int)endIndex, (String)newText, (boolean)false);
    }

    protected static boolean ReplaceText(IGenInfoBuilder builder, int startIndex, int endIndex, String newText, boolean allowTagDeletion) {
        return MicroPatternEngine.ReplaceText((IGenInfoBuilder)builder, null, (int)startIndex, (int)endIndex, (String)newText, (boolean)false);
    }

    public RadicalEntity searchRadicalEntity(String fromProject, String packageName, String entityCodeToSearch, String entityTypeToSearch, IMicroPatternProcessingContext context) {
        return this.searchRadicalEntity(fromProject, packageName, entityCodeToSearch, null, entityTypeToSearch, context);
    }

    public RadicalEntity searchRadicalEntity(String fromProject, String packageName, String entityCodeToSearch, String subType, String entityTypeToSearch, IMicroPatternProcessingContext context) {
        Stack<String> packages = new Stack<String>();
        int i = 0;
        while (i < packageName.length()) {
            if (packageName.charAt(i) == '.') {
                packages.push(packageName.substring(0, i));
            }
            ++i;
        }
        packages.push(packageName);
        while (!packages.empty()) {
            String pkg = (String)packages.pop();
            RadicalEntity re = null;
            try {
                re = subType == null ? PTEditorService.resolveSharedResource((String)fromProject, (String)pkg, (String)entityCodeToSearch, (String)entityTypeToSearch) : PTEditorService.resolveSharedResource((String)fromProject, (String)pkg, (String)entityCodeToSearch, (String)subType, (String)entityTypeToSearch);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.traceMessage("Unknown Entity code : " + entityCodeToSearch + "." + entityTypeToSearch);
            }
            if (re == null) continue;
            if (context.getData(NO_REGISTER_REFERENCE) == null) {
                this.registerReference(re, context);
            }
            return re;
        }
        return null;
    }

    public RadicalEntity searchRadicalEntityWithoutRegisterReference(String fromProject, String packageName, String entityCodeToSearch, String entityTypeToSearch, IMicroPatternProcessingContext context) {
        context.setData(NO_REGISTER_REFERENCE, (Object)true);
        RadicalEntity re = this.searchRadicalEntity(fromProject, packageName, entityCodeToSearch, entityTypeToSearch, context);
        context.setData(NO_REGISTER_REFERENCE, null);
        return re;
    }

    public EObject searchReference(IMicroPatternProcessingContext context) {
        Object obj = context.getData(DESIGN_FILE);
        if (obj instanceof EObject) {
            return (EObject)obj;
        }
        return null;
    }

    public EObject searchReference(IMicroPattern microPattern) {
        return this.searchReference(microPattern.getProcessingContext());
    }

    public static char SearchVariantFor(RadicalEntity re) {
        char result = ' ';
        switch (re.eClass().getClassifierID()) {
            case 39: {
                PacProgramWrapper p = new PacProgramWrapper((PacProgram)re);
                result = p.getVariante().getLiteral().charAt(1);
                break;
            }
            case 70: {
                PacScreenWrapper p = new PacScreenWrapper((PacScreen)re);
                if (!p.getCobolType().equals(PacCobolTypeValues._NONE_LITERAL)) {
                    result = p.getCobolType().getLiteral().charAt(1);
                    break;
                }
                result = ((PacScreen)re).getDialog().getCobolType().getLiteral().charAt(1);
                break;
            }
            case 72: {
                PacDialogWrapper p = new PacDialogWrapper((PacDialog)re);
                result = p.getCobolType().getLiteral().charAt(1);
                break;
            }
            case 101: {
                PacServerWrapper p = new PacServerWrapper((PacServer)re);
                if (!p.getCobolType().equals(PacCobolTypeValues._NONE_LITERAL)) {
                    result = p.getCobolType().getLiteral().charAt(1);
                    break;
                }
                result = p.getDialog().getCobolType().getLiteral().charAt(1);
                break;
            }
            case 127: {
                PacCommunicationMonitorWrapper p = new PacCommunicationMonitorWrapper((PacCommunicationMonitor)re);
                if (!p.getCobolType().equals(PacCobolTypeValues._NONE_LITERAL)) {
                    result = p.getCobolType().getLiteral().charAt(1);
                    break;
                }
                if (p.getPacDialogCommunicationMonitor() != null) {
                    result = p.getPacDialogCommunicationMonitor().getCobolType().getLiteral().charAt(1);
                    break;
                }
                result = p.getPacDialogServer().getCobolType().getLiteral().charAt(1);
                break;
            }
            case 120: {
                PacFolderWrapper p = new PacFolderWrapper((PacFolder)re);
                result = !p.getCobolType().equals(PacCobolTypeValues._NONE_LITERAL) ? p.getCobolType().getLiteral().charAt(1) : p.getPacDialogFolder().getCobolType().getLiteral().charAt(1);
            }
        }
        return result;
    }

    public static PacMapTypeValues SearchMapTypeFor(RadicalEntity re) {
        PacMapTypeValues result = PacMapTypeValues._NONE_LITERAL;
        switch (re.eClass().getClassifierID()) {
            case 70: {
                PacScreenWrapper p = new PacScreenWrapper((PacScreen)re);
                if (!p.getMapType().equals(PacMapTypeValues._NONE_LITERAL)) {
                    result = p.getMapType();
                    break;
                }
                result = ((PacScreen)re).getDialog().getMapType();
                break;
            }
            case 72: {
                PacDialogWrapper p = new PacDialogWrapper((PacDialog)re);
                result = p.getMapType();
                break;
            }
            case 101: {
                PacServerWrapper p = new PacServerWrapper((PacServer)re);
                if (!p.getMapType().equals(PacMapTypeValues._NONE_LITERAL)) {
                    result = p.getMapType();
                    break;
                }
                result = ((PacServer)re).getDialog().getMapType();
                break;
            }
            case 120: {
                PacFolderWrapper p = new PacFolderWrapper((PacFolder)re);
                result = !p.getMapType().equals(PacMapTypeValues._NONE_LITERAL) ? p.getMapType() : ((PacFolder)re).getPacDialogFolder().getMapType();
            }
        }
        return result;
    }

    public static PacGeneratedSkeletonLanguageValues SearchGeneratedSkeletonLanguageFor(RadicalEntity re, IMicroPattern microPattern) {
        PacGeneratedSkeletonLanguageValues lang = null;
        if (microPattern != null) {
            lang = (PacGeneratedSkeletonLanguageValues)microPattern.getProcessingContext().getData(SKELETON);
        }
        if (lang == null) {
            if (re instanceof PacScreen) {
                PacScreenWrapper p = new PacScreenWrapper((PacScreen)re);
                lang = p.getSkeletonLanguage();
            } else if (re instanceof PacServer) {
                PacServerWrapper p = new PacServerWrapper((PacServer)re);
                lang = p.getSkeletonLanguage();
            } else if (re instanceof PacProgram) {
                PacProgramWrapper p = new PacProgramWrapper((PacProgram)re);
                lang = p.getSkeletonLanguage();
            } else if (re instanceof PacCommunicationMonitor) {
                PacCommunicationMonitorWrapper p = new PacCommunicationMonitorWrapper((PacCommunicationMonitor)re);
                lang = p.getSkeletonLanguage();
            } else if (re instanceof PacFolder) {
                PacFolderWrapper p = new PacFolderWrapper((PacFolder)re);
                lang = p.getSkeletonLanguage();
            }
        }
        return lang;
    }

    public static String GetPatternFor(RadicalEntity re) {
        switch (re.eClass().getClassifierID()) {
            case 39: {
                return "com.ibm.pdp.pacbase.batch";
            }
            case 101: {
                return "com.ibm.pdp.pacbase.csserver";
            }
            case 72: {
                return "com.ibm.pdp.pacbase.dialog";
            }
            case 70: {
                PacScreenWrapper p = new PacScreenWrapper((PacScreen)re);
                if (p.getDialogType().equals(PacDialogTypeValues._C_LITERAL) || p.getDialogType().equals(PacDialogTypeValues._MC_LITERAL) || p.getDialogType().equals(PacDialogTypeValues._SC_LITERAL)) {
                    return "com.ibm.pdp.pacbase.csclient";
                }
                return "com.ibm.pdp.pacbase.dialog";
            }
            case 120: {
                return "com.ibm.pdp.pacbase.folder";
            }
            case 127: {
                return "com.ibm.pdp.pacbase.communicationmonitor";
            }
        }
        return null;
    }

    public static PacbasePattern SearchPatternForWorkingPurpose(RadicalEntity re) {
        switch (re.eClass().getClassifierID()) {
            case 39: {
                return PacbasePattern.BATCH;
            }
            case 101: {
                return PacbasePattern.SERVER;
            }
            case 72: {
                return PacbasePattern.DIALOG;
            }
            case 70: {
                PacScreenWrapper p = new PacScreenWrapper((PacScreen)re);
                if (p.getDialogType().equals(PacDialogTypeValues._C_LITERAL) || p.getDialogType().equals(PacDialogTypeValues._MC_LITERAL) || p.getDialogType().equals(PacDialogTypeValues._SC_LITERAL)) {
                    return PacbasePattern.CLIENT;
                }
                return PacbasePattern.DIALOG;
            }
        }
        return PacbasePattern.BATCH;
    }

    private static List<PacAbstractCDLine> GetCDLinesForEntity(RadicalEntity re) {
        if (re instanceof PacProgram) {
            PacProgramWrapper p = new PacProgramWrapper((PacProgram)re);
            return p.getCDLines();
        }
        return null;
    }

    public static PacIOModeValues SearchOpenTypeFileFor(RadicalEntity re, String dataStructureName) {
        List<PacAbstractCDLine> result = AbstractCommonMicroPatternHandler.GetCDLinesForEntity(re);
        if (result != null) {
            for (PacAbstractCDLine cdLine : result) {
                PacCommonLineDescription dsCommonline = cdLine.getCommonDescription();
                if (!dsCommonline.getCodeInProgram().equals(dataStructureName)) continue;
                return cdLine.getIOMode();
            }
        }
        return null;
    }

    public static PacAccessModeValues SearchAccesFileFor(RadicalEntity re, String dataStructureName) {
        List<PacAbstractCDLine> result = AbstractCommonMicroPatternHandler.GetCDLinesForEntity(re);
        if (result != null) {
            for (PacAbstractCDLine cdLine : result) {
                PacCDLineDataStructure dsCDLine;
                PacCommonLineDescription dsCommonline;
                if (!(cdLine instanceof PacCDLineDataStructure) || !(dsCommonline = (dsCDLine = (PacCDLineDataStructure)cdLine).getCommonDescription()).getCodeInProgram().equals(dataStructureName)) continue;
                return dsCDLine.getAccessMode();
            }
        }
        return null;
    }

    public static PacOrganizationValues SearchOrganizationFileFor(RadicalEntity re, String dataStructureName) {
        List<PacAbstractCDLine> result = AbstractCommonMicroPatternHandler.GetCDLinesForEntity(re);
        if (result != null) {
            for (PacAbstractCDLine cdLine : result) {
                PacCDLineDataStructure dsCDLine;
                PacCommonLineDescription dsCommonline;
                if (!(cdLine instanceof PacCDLineDataStructure) || !(dsCommonline = (dsCDLine = (PacCDLineDataStructure)cdLine).getCommonDescription()).getCodeInProgram().equals(dataStructureName)) continue;
                return dsCDLine.getCommonDescription().getOrganization();
            }
        }
        return null;
    }

    public static String SearchAccessKeyFor(RadicalEntity re, String dataStructureName) {
        List<PacAbstractCDLine> result = AbstractCommonMicroPatternHandler.GetCDLinesForEntity(re);
        if (result != null) {
            for (PacAbstractCDLine cdLine : result) {
                PacCDLineDataStructure dsCDLine;
                PacCommonLineDescription dsCommonline;
                if (!(cdLine instanceof PacCDLineDataStructure) || !(dsCommonline = (dsCDLine = (PacCDLineDataStructure)cdLine).getCommonDescription()).getCodeInProgram().equals(dataStructureName)) continue;
                return dsCDLine.getAccessKeyDataElementCode();
            }
        }
        return null;
    }

    public static char SearchGenerationParameterVariantFor(RadicalEntity re) {
        char result = ' ';
        switch (re.eClass().getClassifierID()) {
            case 39: {
                PacProgramWrapper p = new PacProgramWrapper((PacProgram)re);
                result = p.getGenerationParameter().getCobolType().getLiteral().charAt(1);
                break;
            }
            case 70: {
                PacScreenWrapper p = new PacScreenWrapper((PacScreen)re);
                result = p.getGenerationParameter().getCobolType().getLiteral().charAt(1);
                break;
            }
            case 72: {
                PacDialogWrapper p = new PacDialogWrapper((PacDialog)re);
                result = p.getGenerationParameter().getCobolType().getLiteral().charAt(1);
                break;
            }
            case 101: {
                PacServerWrapper p = new PacServerWrapper((PacServer)re);
                result = p.getGenerationParameter().getCobolType().getLiteral().charAt(1);
                break;
            }
            case 127: {
                PacCommunicationMonitorWrapper p = new PacCommunicationMonitorWrapper((PacCommunicationMonitor)re);
                result = p.getGenerationParameter().getCobolType().getLiteral().charAt(1);
                break;
            }
            case 120: {
                PacFolderWrapper p = new PacFolderWrapper((PacFolder)re);
                result = p.getGenerationParameter().getCobolType().getLiteral().charAt(1);
            }
        }
        return result;
    }

    public static PacGeneratedLanguageValues SearchGeneratedLanguageFor(RadicalEntity re) {
        PacGeneratedLanguageValues result = null;
        switch (re.eClass().getClassifierID()) {
            case 39: {
                PacProgramWrapper p = new PacProgramWrapper((PacProgram)re);
                result = p.getGenerationParameter().getGeneratedLanguage();
                break;
            }
            case 70: {
                PacScreenWrapper p = new PacScreenWrapper((PacScreen)re);
                result = p.getGenerationParameter().getGeneratedLanguage();
                break;
            }
            case 72: {
                PacDialogWrapper p = new PacDialogWrapper((PacDialog)re);
                result = p.getGenerationParameter().getGeneratedLanguage();
                break;
            }
            case 101: {
                PacServerWrapper p = new PacServerWrapper((PacServer)re);
                result = p.getGenerationParameter().getGeneratedLanguage();
                break;
            }
            case 127: {
                PacCommunicationMonitorWrapper p = new PacCommunicationMonitorWrapper((PacCommunicationMonitor)re);
                result = p.getGenerationParameter().getGeneratedLanguage();
                break;
            }
            case 120: {
                PacFolderWrapper p = new PacFolderWrapper((PacFolder)re);
                result = p.getGenerationParameter().getGeneratedLanguage();
            }
        }
        return result;
    }

    public static boolean IsCICSCobolGeneration(RadicalEntity re) {
        char screenVariant = AbstractCommonMicroPatternHandler.SearchVariantFor(re);
        PacMapTypeValues mapVariant = AbstractCommonMicroPatternHandler.SearchMapTypeFor(re);
        return !(screenVariant != 'X' && screenVariant != '0' || !mapVariant.equals(PacMapTypeValues._0_LITERAL) && !mapVariant.equals(PacMapTypeValues._C_LITERAL) && !mapVariant.equals(PacMapTypeValues._2_LITERAL));
    }

    public static boolean isIMSCobolGeneration(RadicalEntity re) {
        PacMapTypeValues mapType = AbstractCommonMicroPatternHandler.SearchMapTypeFor(re);
        return mapType == PacMapTypeValues._1_LITERAL || mapType == PacMapTypeValues._3_LITERAL;
    }

    public static PacCenturySystemDateValues SearchCenturySystemDateFor(RadicalEntity re) {
        PacCenturySystemDateValues result = PacCenturySystemDateValues._N_LITERAL;
        switch (re.eClass().getClassifierID()) {
            case 39: {
                PacProgramWrapper p = new PacProgramWrapper((PacProgram)re);
                result = p.getGenerationParameter().getCenturySystemDate();
                break;
            }
            case 70: {
                PacScreenWrapper p = new PacScreenWrapper((PacScreen)re);
                result = p.getGenerationParameter().getCenturySystemDate();
                break;
            }
            case 72: {
                PacDialogWrapper p = new PacDialogWrapper((PacDialog)re);
                result = p.getGenerationParameter().getCenturySystemDate();
                break;
            }
            case 101: {
                PacServerWrapper p = new PacServerWrapper((PacServer)re);
                result = p.getGenerationParameter().getCenturySystemDate();
                break;
            }
            case 127: {
                PacCommunicationMonitorWrapper p = new PacCommunicationMonitorWrapper((PacCommunicationMonitor)re);
                result = p.getGenerationParameter().getCenturySystemDate();
                break;
            }
            case 120: {
                PacFolderWrapper p = new PacFolderWrapper((PacFolder)re);
                result = p.getGenerationParameter().getCenturySystemDate();
            }
        }
        return result;
    }

    public static int SearchCenturyReferenceYear(RadicalEntity re) {
        int year = 0;
        switch (re.eClass().getClassifierID()) {
            case 39: {
                PacProgramWrapper p = new PacProgramWrapper((PacProgram)re);
                year = p.getGenerationParameter().getCenturyReferenceYear();
                break;
            }
            case 70: {
                PacScreenWrapper p = new PacScreenWrapper((PacScreen)re);
                year = p.getGenerationParameter().getCenturyReferenceYear();
                break;
            }
            case 101: {
                PacServerWrapper p = new PacServerWrapper((PacServer)re);
                year = p.getGenerationParameter().getCenturyReferenceYear();
                break;
            }
            case 127: {
                PacCommunicationMonitorWrapper p = new PacCommunicationMonitorWrapper((PacCommunicationMonitor)re);
                year = p.getGenerationParameter().getCenturyReferenceYear();
                break;
            }
            case 120: {
                PacFolderWrapper p = new PacFolderWrapper((PacFolder)re);
                year = p.getGenerationParameter().getCenturyReferenceYear();
            }
        }
        if (year <= 0) {
            year = 61;
        }
        return year;
    }

    public static PacGeneratedDateFormatValues SearchGeneratedDateFormatFor(RadicalEntity re) {
        PacGeneratedDateFormatValues result = null;
        switch (re.eClass().getClassifierID()) {
            case 39: {
                PacProgramWrapper p = new PacProgramWrapper((PacProgram)re);
                result = p.getGenerationParameter().getGeneratedDateFormat();
                break;
            }
            case 70: {
                PacScreenWrapper p = new PacScreenWrapper((PacScreen)re);
                result = p.getGenerationParameter().getGeneratedDateFormat();
                break;
            }
            case 72: {
                PacDialogWrapper p = new PacDialogWrapper((PacDialog)re);
                result = p.getGenerationParameter().getGeneratedDateFormat();
                break;
            }
            case 101: {
                PacServerWrapper p = new PacServerWrapper((PacServer)re);
                result = p.getGenerationParameter().getGeneratedDateFormat();
                break;
            }
            case 127: {
                PacCommunicationMonitorWrapper p = new PacCommunicationMonitorWrapper((PacCommunicationMonitor)re);
                result = p.getGenerationParameter().getGeneratedDateFormat();
                break;
            }
            case 120: {
                PacFolderWrapper p = new PacFolderWrapper((PacFolder)re);
                result = p.getGenerationParameter().getGeneratedDateFormat();
            }
        }
        return result;
    }

    public static IBuilderTag SearchSubFunctionFrom(IBuilderTag startTag, String function) {
        IBuilderTag currentTag;
        IBuilderTag result = currentTag = startTag.firstSon();
        String currentFct = null;
        boolean found = false;
        while (!found && currentTag != null) {
            currentFct = currentTag.getName();
            if (currentFct.charAt(0) == 'F') {
                boolean bl = found = EBCDICCompare.stringCompare((String)currentFct, (String)function) > 0;
                if (found) {
                    currentFct = result.getName();
                    break;
                }
                result = currentTag;
            }
            currentTag = currentTag.nextTag();
        }
        if (found) {
            String lev;
            if (EBCDICCompare.stringCompare((String)currentFct, (String)function) == 0) {
                return result;
            }
            if (function.substring(1, 3).equals(currentFct.substring(1, 3)) && (lev = AbstractCommonMicroPatternHandler.GetPropertyFor(result, LEVEL_PROPERTY)) != null && lev.length() > 0 && Float.parseFloat(lev) < (float)Integer.parseInt(GENERATED_LEVEL)) {
                result = AbstractCommonMicroPatternHandler.SearchSubFunctionFrom(result, function);
            }
        } else if (function.substring(1, 3).equals(result.getName().substring(1, 3))) {
            while (result != null && AbstractCommonMicroPatternHandler.GetPropertyFor(result, SPECIFIC_TAG_PROPERTY) != null) {
                result = result.previousTag();
            }
            if (result == null) {
                return startTag;
            }
            String lev = AbstractCommonMicroPatternHandler.GetPropertyFor(result, LEVEL_PROPERTY);
            if (lev != null && lev.length() > 0 && Float.parseFloat(lev) < (float)Integer.parseInt(GENERATED_LEVEL)) {
                result = AbstractCommonMicroPatternHandler.SearchSubFunctionFrom(result, function);
            }
            return result;
        }
        return result;
    }

    protected IBuilderTag searchTagWithRef(IBuilderTag tag) {
        if (tag.getName().equals("PROCEDURE")) {
            return null;
        }
        if (AbstractCommonMicroPatternHandler.GetPropertyFor(tag, REF_TAG_PROPERTY) != null) {
            return tag;
        }
        return this.searchTagWithRef(tag.getParent());
    }

    public StringBuilder addFormattedCobolLine(String content, IMicroPatternProcessingContext context) {
        StringBuilder sb = this.addFormattedCobolLineWithoutNewLine(content);
        sb.append(AbstractCommonMicroPatternHandler.GetProperty_NEW_LINE(context));
        return sb;
    }

    public StringBuilder addFormattedCobolLineWithoutNewLine(String content) {
        StringBuilder sb = new StringBuilder(80);
        sb.append(FIRST_COLUMNS);
        if (content.charAt(0) != ' ' && content.charAt(0) != '*') {
            sb.append(' ');
        }
        sb.append(content);
        return sb;
    }

    public StringBuilder addSeveralCobolLines(String content, String firstSpaces, IMicroPatternProcessingContext context) {
        if (content.startsWith(AbstractCommonMicroPatternHandler.GetProperty_NEW_LINE(context))) {
            content = " " + content;
        }
        StringTokenizer st = new StringTokenizer(content, AbstractCommonMicroPatternHandler.GetProperty_NEW_LINE(context));
        StringBuilder result = new StringBuilder();
        if (st.hasMoreTokens()) {
            result.append(st.nextToken());
        }
        if (st.hasMoreTokens()) {
            result.append(AbstractCommonMicroPatternHandler.GetProperty_NEW_LINE(context));
        }
        while (st.hasMoreTokens()) {
            result.append(firstSpaces);
            result.append(st.nextToken());
            if (!st.hasMoreTokens()) continue;
            result.append(AbstractCommonMicroPatternHandler.GetProperty_NEW_LINE(context));
        }
        return result;
    }

    public void traceMessage(String message) {
        if (TraceLevel > 0) {
            PTTraceManager.getInstance().trace(this.getClass(), "com.ibm.pdp.pac", 1, message);
        }
    }

    public static String trimRight(String name) {
        int end = name.length() - 1;
        char[] value = name.toCharArray();
        while (end >= 0 && value[end] <= ' ') {
            --end;
        }
        return new String(value, 0, end + 1);
    }

    public static String FormatString(String value, int length, char charToInsertBefore) {
        StringBuilder sb = new StringBuilder(value);
        while (sb.length() < length) {
            sb.insert(0, charToInsertBefore);
        }
        return sb.toString();
    }

    /*
     * Unable to fully structure code
     */
    private void moveDOTFromHeaderToContribution(IMicroPattern microPattern, StringBuilder contribution) {
        block2: {
            if (AbstractCommonMicroPatternHandler.IsInSpecificCode(microPattern)) {
                return;
            }
            if (!this.isDotInsertedInRightMargin() || this.isAnnotationsNeededInMacro()) break block2;
            context = microPattern.getProcessingContext();
            dotIndex = microPattern.getOriginalHeaderDeclaration().indexOf("DOT", 72);
            if (dotIndex != 72 || microPattern.getOriginalHeaderDeclaration().indexOf(AbstractCommonMicroPatternHandler.GetProperty_NEW_LINE(context)) <= dotIndex) break block2;
            dotIndex = contribution.indexOf(AbstractCommonMicroPatternHandler.GetProperty_NEW_LINE(context));
            if (dotIndex != -1) ** GOTO lbl14
            contribution.append(microPattern.getOriginalHeaderDeclaration());
            return;
lbl-1000:
            // 1 sources

            {
                contribution.insert(dotIndex++, ' ');
lbl14:
                // 2 sources

                ** while (dotIndex < 72)
            }
lbl15:
            // 1 sources

            contribution.insert(dotIndex, "DOT");
        }
    }

    public static IBuilderTag AddTag(IGenInfoBuilder genInfoBuilder, int beginIndex, int endIndex, String tagName) {
        IBuilderTag newTag = genInfoBuilder.addTag(beginIndex, endIndex, tagName);
        newTag.setProperty(PROPERTY_MP, newTag.getName());
        return newTag;
    }

    public static IBuilderTag AddTag(IGenInfoBuilder genInfoBuilder, int beginIndex, int endIndex, String tagName, String parentName) {
        IBuilderTag newTag = genInfoBuilder.addTag(beginIndex, endIndex, tagName, parentName);
        if (newTag == null) {
            return null;
        }
        newTag.setProperty(PROPERTY_MP, newTag.getName());
        return newTag;
    }

    protected void addDotIfNeeded(IMicroPattern microPattern, StringBuilder contribution) {
        if (this.isDotAlwaysGenerated()) {
            this.moveDOTFromHeaderToContribution(microPattern, contribution);
            microPattern.getAttributes().remove("DOT_OPERANDES");
            return;
        }
        String dot = microPattern.getAttribute(DOT);
        IMicroPatternProcessingContext context = microPattern.getProcessingContext();
        if (Boolean.parseBoolean(dot)) {
            int length = contribution.length();
            String endOfContribution = contribution.substring(length - AbstractCommonMicroPatternHandler.GetProperty_NEW_LINE(context).length(), length);
            if (endOfContribution.equals(AbstractCommonMicroPatternHandler.GetProperty_NEW_LINE(context))) {
                contribution.replace(length - AbstractCommonMicroPatternHandler.GetProperty_NEW_LINE(context).length(), length, "." + endOfContribution);
            }
        } else {
            String endOfContribution;
            int length;
            dot = microPattern.getAttribute("DOT_OPERANDES");
            if (Boolean.parseBoolean(dot) && (length = contribution.length()) > AbstractCommonMicroPatternHandler.GetProperty_NEW_LINE(context).length() && (endOfContribution = contribution.substring(length - AbstractCommonMicroPatternHandler.GetProperty_NEW_LINE(context).length(), length)).equals(AbstractCommonMicroPatternHandler.GetProperty_NEW_LINE(context))) {
                contribution.replace(length - AbstractCommonMicroPatternHandler.GetProperty_NEW_LINE(context).length(), length, "." + endOfContribution);
            }
            microPattern.getAttributes().remove("DOT_OPERANDES");
        }
        this.moveDOTFromHeaderToContribution(microPattern, contribution);
    }

    public static int[] IndexOfText(String allText, String textToSearch, int beginIndex, String NEW_LINE) {
        int[] result = new int[2];
        String[] allLines = PdpTool.splitTextIntoArrayLines((String)textToSearch);
        String line = allLines[0];
        result[0] = allText.indexOf(line, beginIndex);
        if (result[0] != -1) {
            result[1] = AbstractCommonMicroPatternHandler.SearchAllLines(allText, allLines, result[0], NEW_LINE);
        }
        if (result[0] != -1 && result[1] == -1) {
            return AbstractCommonMicroPatternHandler.IndexOfText(allText, textToSearch, result[0] + 1, NEW_LINE);
        }
        return result;
    }

    protected static int SearchAllLines(String allText, String[] allLines, int index, String NEW_LINE) {
        int currentIndex = index;
        boolean stop = false;
        int i = 1;
        while (i < allLines.length && !stop) {
            String line = String.valueOf(NEW_LINE) + allLines[i];
            int newLineIndex = allText.indexOf(NEW_LINE, currentIndex);
            stop = (currentIndex = allText.indexOf(line, currentIndex)) != newLineIndex;
            ++currentIndex;
            ++i;
        }
        if (!stop) {
            return allText.indexOf(NEW_LINE, currentIndex) + NEW_LINE.length();
        }
        return -1;
    }

    public static boolean CobolCompare(String reference, String generated) {
        Dictionary dictionary = new Dictionary();
        CobolFullLinePartitioner refPartitioner = new CobolFullLinePartitioner();
        BasicTextPartition refPartition = new BasicTextPartition(dictionary, (ITextPartitioner)refPartitioner);
        CobolFullLinePartitioner genPartitioner = new CobolFullLinePartitioner();
        BasicTextPartition genPartition = new BasicTextPartition(dictionary, (ITextPartitioner)genPartitioner);
        refPartition.setText((CharSequence)reference);
        genPartition.setText((CharSequence)generated);
        DiffCursor dC = Ints.newDiffCursor((IntSequence)refPartition.getWords(), (IntSequence)genPartition.getWords());
        while (dC.searchNextDifference()) {
            switch (dC.getDifferenceNature()) {
                // Empty switch
            }
            int refStart = refPartition.wordBeginIndex(dC.getReferenceBeginIndex());
            int refEnd = refPartition.wordBeginIndex(dC.getReferenceEndIndex());
            int genStart = genPartition.wordBeginIndex(dC.getModifiedBeginIndex());
            int genEnd = genPartition.wordBeginIndex(dC.getModifiedEndIndex());
            String ref = reference.substring(refStart, refEnd);
            String gen = generated.substring(genStart, genEnd);
            if (!AbstractCommonMicroPatternHandler.IsRealDifference(ref, gen)) continue;
            return false;
        }
        return true;
    }

    private static boolean IsRealDifference(String ref, String gen) {
        return true;
    }

    protected String firstPartOfOperandes(String operandeParam, String newLine) {
        int index = operandeParam.indexOf(newLine);
        if (index == -1) {
            return operandeParam;
        }
        return operandeParam.substring(0, index);
    }

    protected String secondPartOfOperandes(String operandeParam, String newLine) {
        int index = operandeParam.indexOf(newLine);
        if (index == -1) {
            return operandeParam;
        }
        String lastOperandeParam = operandeParam.substring(index + newLine.length());
        int index2 = lastOperandeParam.indexOf(newLine);
        if (index2 == -1) {
            return lastOperandeParam;
        }
        return operandeParam.substring(index, index2);
    }

    protected List<String> analyseOperande(String content, IMicroPatternProcessingContext context) {
        ArrayList<String> result = new ArrayList<String>();
        if (content == null) {
            return result;
        }
        content = content.replace(AbstractCommonMicroPatternHandler.GetProperty_NEW_LINE(context), " " + AbstractCommonMicroPatternHandler.GetProperty_NEW_LINE(context) + " ").trim();
        ArrayList<String> paramList = new ArrayList<String>();
        boolean inQuote = false;
        boolean inDoubleQuote = false;
        Stack<String> inParenthesisS = new Stack<String>();
        int start = 0;
        int stop = -1;
        int i = 0;
        while (i < content.length()) {
            String param;
            if (!inQuote && inParenthesisS.isEmpty() && content.charAt(i) == '\"') {
                if (inDoubleQuote) {
                    paramList.add(content.substring(start, i + 1));
                    inDoubleQuote = false;
                    start = i + 1;
                } else {
                    inDoubleQuote = true;
                    if (i > 0 && content.charAt(i - 1) == ' ') {
                        param = this.trimOnlySpace(content, start, stop);
                        if (param.length() > 0) {
                            paramList.add(param);
                        }
                        start = i;
                        stop = -1;
                    }
                }
            } else if (!inDoubleQuote && inParenthesisS.isEmpty() && content.charAt(i) == '\'') {
                if (inQuote) {
                    paramList.add(content.substring(start, i + 1));
                    inQuote = false;
                    start = i + 1;
                } else {
                    inQuote = true;
                    if (i > 0 && content.charAt(i - 1) == ' ') {
                        param = this.trimOnlySpace(content, start, stop);
                        if (param.length() > 0) {
                            paramList.add(param);
                        }
                        start = i;
                        stop = -1;
                    }
                }
            }
            if (!(inQuote || inDoubleQuote || content.charAt(i) != '(' && content.charAt(i) != ')')) {
                if (content.charAt(i) == ')') {
                    inParenthesisS.pop();
                    if (inParenthesisS.isEmpty()) {
                        paramList.add(content.substring(start, i + 1));
                        start = i + 1;
                    }
                } else {
                    inParenthesisS.push("(");
                    if (i > 0 && content.charAt(i - 1) == ' ' && inParenthesisS.size() == 1) {
                        param = this.trimOnlySpace(content, start, stop);
                        if (param.length() > 0) {
                            paramList.add(param);
                        }
                        start = i;
                        stop = -1;
                    }
                }
            } else if (!inQuote && !inDoubleQuote && inParenthesisS.isEmpty()) {
                if (content.charAt(i) == ' ') {
                    stop = i;
                } else if (stop != -1) {
                    param = this.trimOnlySpace(content, start, stop);
                    if (param.length() > 0) {
                        paramList.add(param);
                    }
                    stop = -1;
                    start = i;
                }
            }
            ++i;
        }
        if (start != content.length()) {
            paramList.add(content.substring(start));
        }
        boolean inParenthesis = false;
        inQuote = false;
        StringBuilder tmpResult = null;
        for (String element : paramList) {
            int quote = element.indexOf("'");
            if (quote != -1) {
                if (!inQuote) {
                    inQuote = true;
                    if (element.length() > quote + 1) {
                        inQuote = element.indexOf("'", quote + 1) != -1;
                    }
                    tmpResult = new StringBuilder(element);
                    if (!inQuote) {
                        if (result.size() > 0) {
                            result.add(tmpResult.insert(0, (String)result.remove(result.size() - 1)).toString());
                        } else {
                            result.add(tmpResult.toString());
                        }
                        tmpResult = new StringBuilder();
                        continue;
                    }
                    inQuote = false;
                    result.add(tmpResult.toString());
                    tmpResult = new StringBuilder();
                    continue;
                }
                if (element.length() > quote + 1 && element.charAt(quote + 1) == '\'' && !element.endsWith("'")) {
                    tmpResult.append(element);
                    continue;
                }
                inQuote = false;
                tmpResult.append(element);
                result.add(tmpResult.toString());
                tmpResult = new StringBuilder();
                continue;
            }
            if (!inQuote) {
                int parenthesis;
                if (inParenthesis) {
                    parenthesis = element.indexOf(")");
                    if (parenthesis != -1) {
                        inParenthesis = false;
                        tmpResult.append(element);
                        result.add(tmpResult.insert(0, String.valueOf((String)result.remove(result.size() - 1)) + " ").toString());
                        tmpResult = new StringBuilder();
                        continue;
                    }
                } else {
                    parenthesis = element.indexOf("(");
                    if (parenthesis != -1) {
                        inParenthesis = element.indexOf(")") == -1;
                        tmpResult = new StringBuilder(element);
                        if (inParenthesis) continue;
                        if (result.size() > 0 && parenthesis == 0) {
                            result.add(tmpResult.insert(0, String.valueOf((String)result.remove(result.size() - 1)) + " ").toString());
                        } else {
                            result.add(tmpResult.toString());
                        }
                        tmpResult = new StringBuilder();
                        continue;
                    }
                    parenthesis = element.indexOf(")");
                    if (parenthesis != -1) {
                        inParenthesis = false;
                        tmpResult.append(element);
                        result.add(tmpResult.insert(0, String.valueOf((String)result.remove(result.size() - 1)) + " ").toString());
                        tmpResult = new StringBuilder();
                    }
                }
            }
            if (inQuote || inParenthesis) {
                tmpResult.append(element);
                continue;
            }
            if (!AbstractCommonMicroPatternHandler.GetProperty_NEW_LINE(context).equals(element) && element.trim().length() <= 0) continue;
            result.add(element);
        }
        if (tmpResult != null && tmpResult.length() > 0) {
            if (inParenthesis) {
                result.add(tmpResult.insert(0, String.valueOf((String)result.remove(result.size() - 1)) + " ").toString());
            } else if (result.size() == 0) {
                result.add(tmpResult.toString());
            } else {
                result.add(tmpResult.insert(0, (String)result.remove(result.size() - 1)).toString());
            }
        }
        Object[] tabResult = result.toArray();
        int[] tabOfOf = new int[tabResult.length];
        int j = 0;
        boolean somethingToDo = false;
        int i2 = 0;
        while (i2 < tabResult.length) {
            if ("OF".equalsIgnoreCase(tabResult[i2].toString())) {
                tabOfOf[j++] = i2;
                somethingToDo = true;
            } else {
                tabOfOf[j++] = -1;
            }
            ++i2;
        }
        if (!somethingToDo) {
            return result;
        }
        result = new ArrayList();
        int k = 0;
        int i3 = 0;
        while (i3 < tabOfOf.length) {
            j = tabOfOf[i3];
            if (j != -1) {
                if (j > 1) {
                    while (k < j - 1) {
                        result.add(tabResult[k++].toString());
                    }
                }
                tmpResult = new StringBuilder();
                tmpResult.append(tabResult[j - 1]);
                tmpResult.append(" ");
                tmpResult.append(tabResult[j]);
                if (j + 1 < tabResult.length) {
                    tmpResult.append(" ");
                    tmpResult.append(tabResult[j + 1]);
                }
                result.add(tmpResult.toString());
                k = j + 2;
            }
            ++i3;
        }
        while (k < tabResult.length) {
            result.add(tabResult[k++].toString());
        }
        return result;
    }

    private String trimOnlySpace(String text, int start, int stop) {
        return text.substring(start, stop).replaceAll("^[ ]+|[ ]+$", EMPTY_STRING);
    }

    public List<Object> getReferencedEntities(IMicroPattern microPattern) {
        return null;
    }
}

