/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.extension.micropattern;

import com.ibm.pdp.engine.IMicroPattern;
import com.ibm.pdp.engine.IMicroPatternProcessingContext;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.pacbase.PacScreen;
import com.ibm.pdp.pacbase.extension.micropattern.AbstractSimpleMicroPatternHandler;
import com.ibm.pdp.pacbase.extension.micropattern.Messages;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class AbstractCallScreenMicroPatternHandler
extends AbstractSimpleMicroPatternHandler {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2011, 2019.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    @Override
    protected void handleLocal(IMicroPattern microPattern, StringBuilder contribution) {
        IMicroPatternProcessingContext context = microPattern.getProcessingContext();
        String operandes = this.operandes(microPattern);
        if (operandes == null || operandes.trim().length() == 0) {
            this.logWarning(Messages.MicroPatternHandler_INVALID_OPERANDE_VALUE, microPattern);
        }
        String alphanumeric_Delimiter = AbstractCallScreenMicroPatternHandler.GetProperty_ALPHA_NUMERIC_DELIMITER(context);
        if (this.checkStatus(microPattern.getProcessingContext())) {
            contribution.append("           ");
            contribution.append("MOVE       ");
            contribution.append(alphanumeric_Delimiter);
            contribution.append(this.getExternalName(operandes, (RadicalEntity)this.searchReference(microPattern), microPattern.getProcessingContext()));
            contribution.append(alphanumeric_Delimiter);
            contribution.append("    TO      ");
            contribution.append("5-");
            contribution.append(this.getEndScreenCode((PacScreen)this.searchReference(microPattern)));
            contribution.append("-PROGE");
            contribution.append(AbstractCallScreenMicroPatternHandler.GetProperty_NEW_LINE(context));
            contribution.append("           ");
            contribution.append("MOVE ");
            contribution.append(alphanumeric_Delimiter);
            contribution.append("O");
            contribution.append(alphanumeric_Delimiter);
            contribution.append(" TO OPER");
            contribution.append(this.getEndOper());
            contribution.append(AbstractCallScreenMicroPatternHandler.GetProperty_NEW_LINE(context));
        }
    }

    public abstract String getExternalName(String var1, RadicalEntity var2, IMicroPatternProcessingContext var3);

    public abstract String getEndOper();

    public abstract String getEndScreenCode(PacScreen var1);

    @Override
    protected void convertToAttributes(IMicroPattern microPattern, Map<String, Object> parameters) {
        super.convertToAttributes(microPattern, parameters);
        Object param1 = parameters.get("SCR");
        if (param1 instanceof String) {
            microPattern.getAttributes().put("FIRST_ZONE", (String)param1);
        }
    }

    @Override
    protected LinkedHashMap<String, String> convertToParameters(IMicroPattern microPattern, String operandes) {
        try {
            LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
            parameters.put("SCR", operandes);
            return parameters;
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }
}

