/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.extension.matching;

import com.ibm.pdp.engine.IGeneratedTag;
import com.ibm.pdp.framework.PdpTool;
import com.ibm.pdp.pacbase.extension.matching.PacGeneratedTextAnalyzer;
import com.ibm.pdp.pacbase.extension.matching.PacScreenCommentsDetection;
import com.ibm.pdp.pacbase.extension.matching.StartPacFunctionPrecededByCommentHandler;
import com.ibm.pdp.util.Strings;
import com.ibm.pdp.util.diff.DiffCursor;
import com.ibm.pdp.util.diff.DifferenceNature;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class StartPacScreenFunctionPrecededByCommentHandler
extends StartPacFunctionPrecededByCommentHandler {
    private static String CARRIAGE_RETURN = "\r\n";
    private static int CARRIAGE_RETURN_LENGTH = CARRIAGE_RETURN.length();
    private Map<String, Character> elements = null;
    private int elementID = -1;
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2017.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public StartPacScreenFunctionPrecededByCommentHandler(String tagName, IGeneratedTag tag) {
        super(tagName, tag);
    }

    private boolean searchForAComment(String tagName, CharSequence text, int counter, int begin, int end) {
        int[] offsets = PacScreenCommentsDetection.searchForAComment(tagName, text, counter, begin, end);
        if (offsets.length != 2) {
            return false;
        }
        if ((offsets = this.extractCorrectOffsetsFromComments(text, begin, counter, offsets)) == null) {
            return false;
        }
        this._lineStartOffset = offsets[0];
        this._lineEndOffset = offsets[1];
        return true;
    }

    private String buildCompressedString(String[] input) {
        int inputLongueur = input.length;
        StringBuilder sb = new StringBuilder(inputLongueur);
        int i = 0;
        while (i < inputLongueur) {
            char c;
            String s = String.valueOf(input[i]) + CARRIAGE_RETURN;
            Character o = this.elements.get(s);
            if (o != null) {
                c = o.charValue();
            } else {
                ++this.elementID;
                c = (char)this.elementID;
                this.elements.put(s, Character.valueOf(c));
            }
            sb.append(c);
            ++i;
        }
        return sb.toString();
    }

    private int[] extractCorrectOffsetsFromComments(CharSequence text, int begin, int counter, int[] offsets) {
        String sbTxt;
        Iterator fils = this._tag.sons();
        if (!fils.hasNext()) {
            return null;
        }
        IGeneratedTag unFils = (IGeneratedTag)fils.next();
        CharSequence leTexteComplet = unFils.getGeneratedInfo().getText();
        String commentsInGenerated = leTexteComplet.subSequence(unFils.getBeginIndex(), unFils.getEndIndex()).toString();
        String commentsInText = text.subSequence(offsets[0], counter).toString();
        int[] result = new int[2];
        if (commentsInGenerated.equalsIgnoreCase(commentsInText)) {
            return offsets;
        }
        String[] commentsInGen = PdpTool.splitTextIntoArrayLines((String)commentsInGenerated);
        String[] commentsInTxt = PdpTool.splitTextIntoArrayLines((String)commentsInText);
        this.elements = new HashMap<String, Character>();
        this.elementID = -1;
        String sbGen = this.buildCompressedString(commentsInGen);
        DiffCursor dc = Strings.newDiffCursor((CharSequence)sbGen, (CharSequence)(sbTxt = this.buildCompressedString(commentsInTxt)));
        boolean differenceFound = dc.searchNextDifference();
        if (differenceFound) {
            if (dc.getDifferenceNature() == DifferenceNature.Insertion && dc.getReferenceBeginIndex() == 0 && dc.getReferenceEndIndex() == 0 && dc.getModifiedBeginIndex() == 0) {
                int nb2CarAAjouter = 0;
                int insertedLines = dc.getModifiedEndIndex();
                int i = 0;
                while (i < insertedLines) {
                    nb2CarAAjouter += commentsInTxt[i].length() + CARRIAGE_RETURN_LENGTH;
                    ++i;
                }
                result[0] = offsets[0] + nb2CarAAjouter;
                result[1] = PdpTool.getLineEndOffset((CharSequence)text, (int)result[0]);
                return result;
            }
            return offsets;
        }
        return null;
    }

    @Override
    protected boolean processOccurrence(PacGeneratedTextAnalyzer textAnalyzer, int beginIdx, int endIdx) {
        boolean b = super.processOccurrence(textAnalyzer, beginIdx, endIdx);
        if (b) {
            CharSequence text = textAnalyzer.getText();
            int i1 = Math.max(0, this._lineStartOffset - 1600);
            int i2 = this._lineStartOffset;
            boolean b2 = this.searchForAComment(this._tagName, text, this.index(), i1, i2);
            return b2;
        }
        return false;
    }
}

