/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.extension.matching;

import com.ibm.pdp.engine.extension.ITextPartitioner;
import com.ibm.pdp.engine.extension.TextToken;
import com.ibm.pdp.framework.PdpTool;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class PacbasePartitioner
implements ITextPartitioner {
    private static int PRIME_NUMBER;
    private static final byte NORMAL_CHR = 0;
    private static final byte SPECIAL_CHR = 1;
    private static final byte WHITE_CHR = 2;
    private static final byte EOL_CHR = 3;
    private static final byte STRING_CHR = 4;
    private static final char[] specials;
    private static final char[] stringDelim;
    private static final char[] whites;
    private static final char[] eols;
    private static byte[] charCategory;
    private static final int CAT_NORMAL_ATOM = 0;
    private static final int CAT_LINE_COMMENT = 1;
    private static final int CAT_STRING = 2;
    private static final int CAT_COL_AFTER_72 = 3;
    private CharSequence _text;
    private boolean _defaultIgnoreCase;
    private int _columnOfIdx;
    private int _lastEndIdx;
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    static {
        char c;
        PRIME_NUMBER = 37;
        specials = new char[]{'\"', '/', '.', ',', ';', ':', '+', '*', '!', '#', '%', '&', '?', '|', '~', '<', '>', '=', '(', ')', '[', ']', '{', '}', '\\', '\'', '\u00b0'};
        stringDelim = new char[]{'\"', '\''};
        whites = new char[]{' ', '\t'};
        eols = new char[]{'\n', '\r'};
        charCategory = new byte[65536];
        char[] cArray = specials;
        int n = specials.length;
        int n2 = 0;
        while (n2 < n) {
            c = cArray[n2];
            PacbasePartitioner.charCategory[c] = 1;
            ++n2;
        }
        cArray = whites;
        n = whites.length;
        n2 = 0;
        while (n2 < n) {
            c = cArray[n2];
            PacbasePartitioner.charCategory[c] = 2;
            ++n2;
        }
        cArray = eols;
        n = eols.length;
        n2 = 0;
        while (n2 < n) {
            c = cArray[n2];
            PacbasePartitioner.charCategory[c] = 3;
            ++n2;
        }
        cArray = stringDelim;
        n = stringDelim.length;
        n2 = 0;
        while (n2 < n) {
            c = cArray[n2];
            PacbasePartitioner.charCategory[c] = 4;
            ++n2;
        }
    }

    public PacbasePartitioner() {
        this(null, false);
    }

    public PacbasePartitioner(boolean ignoreCase) {
        this(null, ignoreCase);
    }

    public PacbasePartitioner(CharSequence initialText, boolean ignoreCase) {
        if (initialText != null) {
            this._text = initialText;
        }
        this._defaultIgnoreCase = ignoreCase;
    }

    public TextToken newToken() {
        this._columnOfIdx = 1;
        return new TextToken();
    }

    public TextToken newToken(int beginIndex, int endIndex, int category, boolean ignoreCase, int hash) {
        this.recomputeColumnOfIdx(endIndex);
        return new TextToken(beginIndex, endIndex, category, ignoreCase, hash);
    }

    public CharSequence getText() {
        return this._text;
    }

    public void setText(CharSequence newText) {
        this._text = newText;
    }

    public void textChanged(int index, int nbRemoved, int nbAdded) {
    }

    private void recomputeColumnOfIdx(int endIndex) {
        int stepsBackward = 0;
        this._columnOfIdx = 0;
        int idx = endIndex;
        boolean found = false;
        while (idx > -1 && !found) {
            char car = this._text.charAt(idx);
            if (car == '\n') {
                found = true;
                continue;
            }
            ++stepsBackward;
            --idx;
        }
        this._columnOfIdx = found ? stepsBackward : endIndex - 1;
    }

    public boolean nextToken(TextToken atom) {
        CharSequence txt = this._text;
        int textLength = txt.length();
        int idx = atom.endIdx;
        if (this._lastEndIdx != idx) {
            this.recomputeColumnOfIdx(idx);
        }
        int hash = 0;
        int factor = PRIME_NUMBER;
        while (idx < textLength) {
            int chr = txt.charAt(idx);
            byte chrCategory = charCategory[chr];
            if (chrCategory == 2) {
                ++idx;
                ++this._columnOfIdx;
                continue;
            }
            if (chrCategory == 3) {
                ++idx;
                ++this._columnOfIdx;
                while (idx < textLength) {
                    chr = txt.charAt(idx);
                    chrCategory = charCategory[chr];
                    if (chrCategory != 3) {
                        this._columnOfIdx = 1;
                        break;
                    }
                    ++idx;
                    ++this._columnOfIdx;
                }
                if (idx == textLength) {
                    return false;
                }
            }
            if (this._columnOfIdx > 0 && this._columnOfIdx < 7) {
                ++idx;
                ++this._columnOfIdx;
                continue;
            }
            if (this._columnOfIdx > 72) {
                hash = chr;
                atom.category = 3;
                atom.beginIdx = idx++;
                ++this._columnOfIdx;
                while (idx < textLength) {
                    chr = txt.charAt(idx);
                    chrCategory = charCategory[chr];
                    if (chrCategory == 3 || chrCategory == 1 || chrCategory == 2) break;
                    hash += factor * chr;
                    ++idx;
                    ++this._columnOfIdx;
                }
                atom.endIdx = idx;
                this._lastEndIdx = idx;
                atom.hash = hash;
                atom.ignoreCase = true;
                return true;
            }
            if (chr == 42 && this._columnOfIdx == 7) {
                hash = chr;
                atom.category = 1;
                atom.beginIdx = idx++;
                ++this._columnOfIdx;
                while (idx < textLength) {
                    chr = txt.charAt(idx);
                    if (this._columnOfIdx >= 73 || charCategory[chr] == 3) break;
                    hash += factor * chr;
                    ++idx;
                    ++this._columnOfIdx;
                }
                atom.endIdx = idx;
                this._lastEndIdx = idx;
                atom.hash = hash;
                atom.ignoreCase = true;
                return true;
            }
            if (chr == 39 || chr == 45 && this._columnOfIdx == 7) {
                hash = chr;
                atom.category = 2;
                atom.beginIdx = idx++;
                ++this._columnOfIdx;
                while (idx < textLength) {
                    chr = txt.charAt(idx);
                    if (this._columnOfIdx >= 73 || chr == 39 || charCategory[chr] == 3) break;
                    hash += factor * chr;
                    ++idx;
                    ++this._columnOfIdx;
                }
                if (chr == 39) {
                    hash += factor * chr;
                    ++idx;
                    ++this._columnOfIdx;
                }
                atom.endIdx = idx;
                this._lastEndIdx = idx;
                atom.hash = hash;
                atom.ignoreCase = false;
                return true;
            }
            if (chrCategory == 1) {
                hash = chr;
                atom.category = 0;
                atom.beginIdx = idx++;
                ++this._columnOfIdx;
                while (idx < textLength) {
                    chr = txt.charAt(idx);
                    chrCategory = charCategory[chr];
                    if (this._columnOfIdx >= 73 || chrCategory == 3 || chrCategory != 1 || chrCategory == 2) break;
                    hash += factor * chr;
                    ++idx;
                    ++this._columnOfIdx;
                }
                atom.endIdx = idx;
                this._lastEndIdx = idx;
                atom.hash = hash;
                atom.ignoreCase = true;
                return true;
            }
            hash = chr;
            atom.category = 0;
            atom.beginIdx = idx++;
            ++this._columnOfIdx;
            while (idx < textLength) {
                chr = txt.charAt(idx);
                chrCategory = charCategory[chr];
                if (this._columnOfIdx >= 73 || chrCategory == 3 || chrCategory == 1 || chrCategory == 2) break;
                hash += factor * chr;
                ++idx;
                ++this._columnOfIdx;
            }
            atom.endIdx = idx;
            this._lastEndIdx = idx;
            atom.hash = hash;
            atom.ignoreCase = true;
            return true;
        }
        return false;
    }

    private static void checkNumbersDistribution(Map<Integer, List<String>> collisions) {
        System.out.println("STATISTICS (token donne ==> nombre de token ayant meme hashcode)");
        Iterator<Integer> keyset = collisions.keySet().iterator();
        HashMap<Integer, Integer> collisionsStat = new HashMap<Integer, Integer>();
        while (keyset.hasNext()) {
            Integer key = keyset.next();
            List<String> value = collisions.get(key);
            Integer x = (Integer)collisionsStat.get(new Integer(value.size()));
            x = x != null ? new Integer(x + 1) : new Integer(1);
            collisionsStat.put(new Integer(value.size()), x);
            System.out.println(key + " ==> " + value.size());
        }
        System.out.println("STATISTICS (Pour 1 nombre de collisions (REM : quand == 1 , pas collision))==> nombre d'entrees concern\u00e9es)");
        for (Integer key : collisionsStat.keySet()) {
            System.out.println(key + " ==> " + collisionsStat.get(key));
        }
    }

    public static void main(String[] args) {
        String text = PdpTool.readFileContents((String)"C:/a/PAC900.cbl");
        PacbasePartitioner ppa = new PacbasePartitioner();
        ppa.setText(text);
        TextToken atom = null;
        atom = ppa.newToken();
        ArrayList<TextToken> atomsList = new ArrayList<TextToken>();
        HashMap collisions = new HashMap();
        boolean encore = ppa.nextToken(atom);
        while (encore) {
            atomsList.add(new TextToken(atom.beginIdx, atom.endIdx, atom.category, atom.ignoreCase, atom.hash));
            System.out.println("atome=" + text.substring(atom.beginIdx, atom.endIdx) + " " + atom.beginIdx + " " + atom.endIdx + " hash=" + atom.hash);
            System.out.println(String.valueOf(atom.hash) + " => " + atom.hash % PRIME_NUMBER);
            System.out.println("");
            String s = text.substring(atom.beginIdx, atom.endIdx);
            ArrayList<String> list = (ArrayList<String>)collisions.get(new Integer(atom.hash));
            if (list == null) {
                list = new ArrayList<String>();
            }
            if (!list.contains(s)) {
                list.add(s);
                collisions.put(new Integer(atom.hash), list);
            }
            encore = ppa.nextToken(atom);
        }
        atom = (TextToken)atomsList.get(72);
        System.out.println("=============================RESTART================================");
        atom = ppa.newToken(atom.beginIdx, atom.endIdx, 0, true, atom.hash);
        while (ppa.nextToken(atom)) {
            System.out.println("atome=" + text.substring(atom.beginIdx, atom.endIdx) + " " + atom.beginIdx + " " + atom.endIdx + " hash=" + atom.hash);
            System.out.println();
        }
    }
}

