/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.extension.matching;

import com.ibm.pdp.engine.IGeneratedInfo;
import com.ibm.pdp.engine.IProblem;
import com.ibm.pdp.engine.extension.ITextAnalyzer;
import com.ibm.pdp.engine.extension.ITextScanner;
import com.ibm.pdp.framework.PdpTool;
import com.ibm.pdp.framework.Trace;
import com.ibm.pdp.mdl.pacbase.PacProgramStructureValues;
import com.ibm.pdp.mdl.pacbase.PacProgramVariantValues;
import com.ibm.pdp.pacbase.PacTool;
import com.ibm.pdp.pacbase.extension.matching.BasicPacLabelRecognizer;
import com.ibm.pdp.pacbase.extension.matching.PacFunctionPositionCommentsDetection;
import com.ibm.pdp.pacbase.extension.matching.PacLabel;
import com.ibm.pdp.pacbase.extension.matching.PacProgramCommentsDetection;
import com.ibm.pdp.pacbase.extension.matching.PacScreenCommentsDetection;
import com.ibm.pdp.pacbase.extension.matching.TextAnalyzerAnalysisData;
import com.ibm.pdp.pacbase.extension.matching.TextScannerResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class PacSpecificTextScanner
implements ITextScanner {
    protected static final String GENERATED_FUNCTION_CST = "gen_function";
    private static final String PROCEDURE_DIVISION_SEARCH_STRING = "       PROCEDURE DIVISION";
    private static final String PROCEDURE_TAG_NAME = "PROCEDURE";
    private static final String PROCEDURE_DIVISION_TAG_NAME = "PROCEDURE-DIVISION";
    protected static final String CR = System.getProperty("line.separator");
    protected ITextAnalyzer _textAnalyzer;
    protected int _beginIndex;
    protected int _endIndex;
    protected boolean _isProgram;
    protected int _counter;
    protected boolean _found = false;
    protected int _lineStartOffset;
    protected int _lineEndOffset;
    protected String _tagNameToReturn;
    protected boolean _isBeginIndex;
    protected PacLabel _pacLabel;
    protected CharSequence _text;
    protected Map<String, String> _tagProperties;
    protected IGeneratedInfo _generatedInfo;
    protected TextAnalyzerAnalysisData _textAnalyzerAnalysisData;
    protected Map<String, String> _generatedFunctionsToDiscard;
    protected Map<String, String> _generatedFunctionsTagNames;
    protected boolean _aCommentExists = false;
    protected int _commentStartingOffset = 0;
    protected int _commentEndingOffset = 0;
    protected boolean _aCommentPosExists = false;
    protected int _commentPosStartingOffset = 0;
    protected int _commentPosEndingOffset = 0;
    protected boolean _isADeclarativeFunction = false;
    protected int _declSectionStartingOffset = 0;
    protected int _declSectionEndingOffset = 0;
    protected boolean _procDivisionAlreadyTreated;
    protected boolean _endProcDivisionHasBeenTreated;
    protected List<TextScannerResult> _resultsCache;
    protected boolean _isPgmOfNatureD = false;
    protected boolean _isPgmOfNatureF = false;
    protected boolean _isPgmOfNatureS = false;
    protected boolean _isPgmOfVariantC = false;
    protected boolean _isPgmOfVariantC_Or_NatureSDF = false;
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2017.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public PacSpecificTextScanner(IGeneratedInfo generatedInfo, ITextAnalyzer textAnalyzer, int beginIdx, int endIdx, boolean isProgram, TextAnalyzerAnalysisData textAnalysisData) {
        this._textAnalyzer = textAnalyzer;
        this._text = textAnalyzer.getText();
        this._isProgram = isProgram;
        this._procDivisionAlreadyTreated = false;
        this._resultsCache = new ArrayList<TextScannerResult>();
        this._endProcDivisionHasBeenTreated = false;
        this._generatedInfo = generatedInfo;
        if (this._generatedInfo != null) {
            String prop2;
            String prop = this._generatedInfo.getProperty("variant");
            if (prop != null && PacProgramVariantValues.get((String)prop) == PacProgramVariantValues._C_LITERAL) {
                this._isPgmOfVariantC = true;
            }
            if ((prop2 = this._generatedInfo.getProperty("nature")) != null) {
                if (PacProgramStructureValues.get((String)prop2) == PacProgramStructureValues._D_LITERAL) {
                    this._isPgmOfNatureD = true;
                } else if (PacProgramStructureValues.get((String)prop2) == PacProgramStructureValues._F_LITERAL) {
                    this._isPgmOfNatureF = true;
                } else if (PacProgramStructureValues.get((String)prop2) == PacProgramStructureValues._S_LITERAL) {
                    this._isPgmOfNatureS = true;
                }
            }
            this._isPgmOfVariantC_Or_NatureSDF = this._isPgmOfNatureD || this._isPgmOfNatureF || this._isPgmOfNatureS || this._isPgmOfVariantC;
        }
        this._textAnalyzerAnalysisData = textAnalysisData;
        this.init(beginIdx, endIdx);
    }

    protected void init(int beginIdx, int endIdx) {
        this._beginIndex = beginIdx;
        this._endIndex = endIdx;
        this._counter = this._beginIndex;
        this._isADeclarativeFunction = false;
        this._declSectionStartingOffset = 0;
        this._declSectionEndingOffset = 0;
        this._aCommentExists = false;
        this._commentStartingOffset = 0;
        this._commentEndingOffset = 0;
        this._aCommentPosExists = false;
        this._commentPosStartingOffset = 0;
        this._commentPosEndingOffset = 0;
        this._found = false;
        this._lineStartOffset = 0;
        this._lineEndOffset = 0;
        this._pacLabel = null;
        this._tagProperties = null;
        this._generatedFunctionsToDiscard = this._textAnalyzerAnalysisData.getGeneratedFunctionsToDiscard();
        this._generatedFunctionsTagNames = this._textAnalyzerAnalysisData.getGeneratedFunctionsTagNames();
    }

    public boolean foundProblem() {
        return false;
    }

    public boolean foundTag() {
        return this._found;
    }

    public IProblem getProblem() {
        return null;
    }

    public String getTagName() {
        if (this.foundTag()) {
            return this._tagNameToReturn;
        }
        return null;
    }

    public Map<String, String> getTagProperties() {
        return this._tagProperties;
    }

    public int index() {
        if (!this._found) {
            return -1;
        }
        if (this.isBeginIndex()) {
            return this._lineStartOffset;
        }
        return this._lineEndOffset;
    }

    public boolean isBeginIndex() {
        return this._isBeginIndex;
    }

    protected void insertProcedureDivisionTags(String line, int start, int end) {
        if (line.indexOf(PROCEDURE_DIVISION_SEARCH_STRING) == -1) {
            return;
        }
        this._procDivisionAlreadyTreated = true;
        this._tagProperties = new HashMap<String, String>();
        this._tagProperties.put("category", "procedure");
        this._found = true;
        this._lineStartOffset = start;
        this._lineEndOffset = end;
        this._isBeginIndex = true;
        this._tagNameToReturn = PROCEDURE_TAG_NAME;
        String name = PROCEDURE_DIVISION_TAG_NAME;
        boolean isBegin = true;
        HashMap<String, String> prop = new HashMap<String, String>();
        prop.put("category", "procedure_division");
        TextScannerResult stsr = new TextScannerResult(name, isBegin, start, end, prop);
        this._resultsCache.add(stsr);
        isBegin = false;
        int idx = line.indexOf(46, 25);
        if (idx != -1) {
            TextScannerResult stsr2 = new TextScannerResult(name, isBegin, start, end, prop);
            this._resultsCache.add(stsr2);
        } else {
            idx = this._text.toString().indexOf(46, end);
            if (idx != -1) {
                int x1 = PdpTool.getLineStartOffset((CharSequence)this._text, (int)idx);
                int x2 = PdpTool.getLineEndOffset((CharSequence)this._text, (int)idx);
                TextScannerResult stsr2 = new TextScannerResult(name, isBegin, x1, x2, prop);
                this._resultsCache.add(stsr2);
            } else {
                this._resultsCache.clear();
                this._found = false;
            }
        }
    }

    public final boolean scan() {
        if (this._isPgmOfVariantC_Or_NatureSDF) {
            return false;
        }
        if (this._resultsCache.size() > 0) {
            TextScannerResult stsr = this._resultsCache.get(0);
            this._tagNameToReturn = stsr.getTagName();
            this._lineStartOffset = stsr.getBeginIndex();
            this._lineEndOffset = stsr.getEndIndex();
            this._isBeginIndex = stsr.isBeginIndex();
            this._found = true;
            this._tagProperties = stsr.getTagProperties();
            this._resultsCache.remove(0);
            return true;
        }
        this._found = false;
        int length = this._text.length();
        while (!this._found && this._counter < length && this._counter < this._endIndex) {
            this._tagProperties = null;
            int start = PdpTool.getLineStartOffset((CharSequence)this._text, (int)this._counter);
            int end = PdpTool.getLineEndOffset((CharSequence)this._text, (int)this._counter);
            if (start < this._beginIndex) {
                this._counter = end;
                continue;
            }
            if (end > this._endIndex) {
                return false;
            }
            CharSequence cs = this._text.subSequence(start, end);
            if (!this._procDivisionAlreadyTreated) {
                this.insertProcedureDivisionTags(cs.toString(), start, end);
                if (this._resultsCache.size() > 0) {
                    this._counter = end;
                    return true;
                }
            }
            this._pacLabel = BasicPacLabelRecognizer.findPacbaseLabelInLine(cs.toString());
            if (this._pacLabel != null) {
                String progrName;
                int idx2;
                int idx1;
                String level;
                if (this.belongsToFunctionsToDiscard(this._pacLabel)) {
                    this._counter = end;
                    continue;
                }
                this._tagProperties = new HashMap<String, String>();
                if (this._pacLabel.isBeginningLabel()) {
                    level = this._textAnalyzerAnalysisData.getFunctionsLevels().get(this._pacLabel.getPacLabel());
                    if (level == null && Trace.traceOn) {
                        idx1 = this._text.toString().indexOf(String.valueOf(CR) + "       PROGRAM-ID.");
                        idx2 = this._text.toString().indexOf(String.valueOf(CR) + "      *AUTHOR.");
                        progrName = "unknown";
                        if (idx1 != -1 && idx2 != -1) {
                            progrName = this._text.subSequence(idx1, idx2).toString();
                        }
                        Trace.errPrintln((String)("PacSpecificTextScanner.scan(). Level not found for : " + this._pacLabel.getPacLabel() + " in " + progrName + "."));
                        level = "10";
                    }
                    this._tagProperties.put("level", level);
                }
                if (this._pacLabel.isBeginningLabel()) {
                    this._isBeginIndex = true;
                    this._aCommentExists = this.searchForAComment(this._pacLabel, this._text, start, this._beginIndex, this._endIndex);
                    this._aCommentPosExists = this.searchForAPositionComment(this._pacLabel, this._text, start, this._beginIndex, this._endIndex);
                    if (this._aCommentPosExists) {
                        this._aCommentPosExists = false;
                        this.decodePositionComment(this._tagProperties);
                    }
                    if (this._aCommentExists) {
                        this._tagProperties.put("StartingOffsetWithoutComment", "" + start);
                        this._lineStartOffset = this._commentStartingOffset;
                        this._lineEndOffset = this._commentEndingOffset;
                    } else {
                        boolean isADeclarative = false;
                        if (this._pacLabel.getPacLabel().startsWith("F0A")) {
                            isADeclarative = this.searchForRealStartForDeclarativeFunction(this._pacLabel, this._text, start, this._beginIndex, this._endIndex);
                        }
                        if (isADeclarative) {
                            this._lineStartOffset = this._declSectionStartingOffset;
                            this._lineEndOffset = this._declSectionEndingOffset;
                        } else {
                            this._lineStartOffset = start;
                            this._lineEndOffset = end;
                        }
                    }
                } else {
                    this._isBeginIndex = false;
                    this._lineStartOffset = start;
                    this._lineEndOffset = end;
                    level = this._textAnalyzerAnalysisData.getFunctionsLevels().get(this._pacLabel.getPacLabel());
                    if (level == null && Trace.traceOn) {
                        idx1 = this._text.toString().indexOf(String.valueOf(CR) + "       PROGRAM-ID.");
                        idx2 = this._text.toString().indexOf(String.valueOf(CR) + "      *AUTHOR.");
                        progrName = "unknown";
                        if (idx1 != -1 && idx2 != -1) {
                            progrName = this._text.subSequence(idx1, idx2).toString();
                        }
                        Trace.errPrintln((String)("PacSpecificTextScanner.scan(). Level not found for : " + this._pacLabel.getPacLabel() + " in " + progrName + "."));
                        level = "10";
                    }
                    this._tagProperties.put("level", level);
                }
                this._tagProperties.put("category", "pac_function");
                this._found = true;
                String tagNameCorresponding = this._generatedFunctionsTagNames.get(this._pacLabel.getPacLabel());
                this._tagNameToReturn = tagNameCorresponding == null ? this._pacLabel.getPacLabel() : tagNameCorresponding;
                this._counter = end;
                return true;
            }
            this._counter = end;
        }
        if (!this._endProcDivisionHasBeenTreated && this._endIndex >= this._text.length()) {
            this._found = true;
            this._tagNameToReturn = PROCEDURE_TAG_NAME;
            this._isBeginIndex = false;
            this._lineStartOffset = PdpTool.getLineStartOffset((CharSequence)this._text, (int)(this._text.length() - 1));
            this._lineEndOffset = PdpTool.getLineEndOffset((CharSequence)this._text, (int)(this._text.length() - 2));
            this._tagProperties = new HashMap<String, String>();
            this._tagProperties.put("category", "procedure");
            this._endProcDivisionHasBeenTreated = true;
            return true;
        }
        return false;
    }

    protected int[] searchForRealFunctionStart(String pacLabel, CharSequence text, int counter, int begin, int end) {
        if (pacLabel.length() != 5) {
            return new int[0];
        }
        int[] result = new int[2];
        int idx = counter - 2;
        String functionNum = pacLabel.substring(3);
        String stringToSearch = " SEC" + functionNum + " SECTION.";
        for (int nbOfLinesStepped = 0; idx >= begin && nbOfLinesStepped < 2; ++nbOfLinesStepped, idx -= 2) {
            if ((idx = PdpTool.getLineStartOffset((CharSequence)text, (int)idx)) >= begin) {
                String s = text.subSequence(idx + 6, idx + 21).toString();
                if (!s.equalsIgnoreCase(stringToSearch)) continue;
                result[0] = idx;
                result[1] = PdpTool.getLineEndOffset((CharSequence)text, (int)idx);
                return result;
            }
            return new int[0];
        }
        return new int[0];
    }

    protected boolean searchForRealStartForDeclarativeFunction(PacLabel pacLabel, CharSequence text, int counter, int begin, int end) {
        int[] offsets = this.searchForRealFunctionStart(pacLabel.getPacLabel(), text, counter, begin, end);
        if (offsets.length != 2) {
            return false;
        }
        this._declSectionStartingOffset = offsets[0];
        this._declSectionEndingOffset = offsets[1];
        return true;
    }

    protected boolean searchForAPositionComment(PacLabel pacLabel, CharSequence text, int counter, int begin, int end) {
        int[] offsets = PacFunctionPositionCommentsDetection.searchForAComment(pacLabel.getPacLabel(), text, counter, begin, end);
        if (offsets.length != 2) {
            return false;
        }
        this._commentPosStartingOffset = offsets[0];
        this._commentPosEndingOffset = offsets[1];
        return true;
    }

    protected void decodePositionComment(Map<String, String> _tagProperties) {
        String contents = this._text.subSequence(this._commentPosStartingOffset, this._commentPosEndingOffset).toString();
        int idx = (contents = contents.replace("\r\n", "").trim()).indexOf(32);
        if (idx < 0) {
            return;
        }
        String pos = contents.substring(2, idx).trim();
        boolean isAfter = false;
        boolean isBefore = false;
        boolean isBeginning = false;
        if ("AFTER".equalsIgnoreCase(pos)) {
            isAfter = true;
        } else if ("BEFORE".equalsIgnoreCase(pos)) {
            isBefore = true;
        } else if ("BEGINNING".equalsIgnoreCase(pos)) {
            isBeginning = true;
        } else if (!"REPLACE".equalsIgnoreCase(pos)) {
            return;
        }
        if (contents.length() < idx + 1) {
            return;
        }
        String destTagName = contents.substring(idx + 1).toString().trim();
        if (destTagName.length() == 0) {
            return;
        }
        if (isAfter) {
            _tagProperties.put("TagPosition", "A");
        } else if (isBefore) {
            _tagProperties.put("TagPosition", "B");
        } else if (isBeginning) {
            _tagProperties.put("TagPosition", "E");
        } else {
            _tagProperties.put("TagPosition", "R");
        }
        _tagProperties.put("TagName", destTagName);
        if (this._aCommentExists && this._commentStartingOffset < this._commentPosStartingOffset) {
            _tagProperties.put("CommentStart", Integer.toString(this._commentStartingOffset));
        } else {
            _tagProperties.put("CommentStart", Integer.toString(this._commentPosStartingOffset));
        }
    }

    private void formatFunctionComments(int commentsStartingOffset, int commentsEndingOffset) {
        CharSequence comments;
        String functionTitle;
        if (this.isBeginIndex() && (functionTitle = PacTool.formatForGSVNodeTitle(comments = this._text.subSequence(commentsStartingOffset, commentsEndingOffset), this._pacLabel.getPacLabel(), true)).length() > 0) {
            this._tagProperties.put("GSV_NODE_LABEL_SUPPLEMENT", " : " + functionTitle);
        }
    }

    protected boolean belongsToFunctionsToDiscard(PacLabel pacLabel) {
        if (this._isProgram || this._generatedFunctionsToDiscard == null || this._generatedFunctionsToDiscard.size() == 0) {
            return false;
        }
        String s = this._generatedFunctionsToDiscard.get(pacLabel.getPacLabel());
        return GENERATED_FUNCTION_CST.equals(s);
    }

    private boolean searchForAComment(PacLabel pacLabel, CharSequence text, int counter, int begin, int end) {
        int[] offsets = null;
        offsets = this._isProgram ? PacProgramCommentsDetection.searchForAComment(pacLabel.getPacLabel(), text, counter, begin, end) : PacScreenCommentsDetection.searchForAComment(pacLabel.getPacLabel(), text, counter, begin, end);
        if (offsets == null || offsets.length != 2) {
            return false;
        }
        this._commentStartingOffset = offsets[0];
        this._commentEndingOffset = offsets[1];
        this.formatFunctionComments(this._commentStartingOffset, counter);
        return true;
    }
}

